/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/schema.proto

package com.google.pubsub.v1;

/**
 *
 *
 * <pre>
 * A schema resource.
 * </pre>
 *
 * Protobuf type {@code google.pubsub.v1.Schema}
 */
public final class Schema extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.pubsub.v1.Schema)
    SchemaOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Schema.newBuilder() to construct.
  private Schema(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Schema() {
    name_ = "";
    type_ = 0;
    definition_ = "";
    revisionId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Schema();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.pubsub.v1.SchemaProto.internal_static_google_pubsub_v1_Schema_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.pubsub.v1.SchemaProto
        .internal_static_google_pubsub_v1_Schema_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.pubsub.v1.Schema.class, com.google.pubsub.v1.Schema.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible schema definition types.
   * </pre>
   *
   * Protobuf enum {@code google.pubsub.v1.Schema.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * A Protocol Buffer schema definition.
     * </pre>
     *
     * <code>PROTOCOL_BUFFER = 1;</code>
     */
    PROTOCOL_BUFFER(1),
    /**
     *
     *
     * <pre>
     * An Avro schema definition.
     * </pre>
     *
     * <code>AVRO = 2;</code>
     */
    AVRO(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * A Protocol Buffer schema definition.
     * </pre>
     *
     * <code>PROTOCOL_BUFFER = 1;</code>
     */
    public static final int PROTOCOL_BUFFER_VALUE = 1;
    /**
     *
     *
     * <pre>
     * An Avro schema definition.
     * </pre>
     *
     * <code>AVRO = 2;</code>
     */
    public static final int AVRO_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return PROTOCOL_BUFFER;
        case 2:
          return AVRO;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.pubsub.v1.Schema.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.pubsub.v1.Schema.Type)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. Name of the schema.
   * Format is `projects/{project}/schemas/{schema}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the schema.
   * Format is `projects/{project}/schemas/{schema}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * The type of the schema definition.
   * </pre>
   *
   * <code>.google.pubsub.v1.Schema.Type type = 2;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * The type of the schema definition.
   * </pre>
   *
   * <code>.google.pubsub.v1.Schema.Type type = 2;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.pubsub.v1.Schema.Type getType() {
    com.google.pubsub.v1.Schema.Type result = com.google.pubsub.v1.Schema.Type.forNumber(type_);
    return result == null ? com.google.pubsub.v1.Schema.Type.UNRECOGNIZED : result;
  }

  public static final int DEFINITION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object definition_ = "";
  /**
   *
   *
   * <pre>
   * The definition of the schema. This should contain a string representing
   * the full definition of the schema that is a valid schema definition of
   * the type specified in `type`.
   * </pre>
   *
   * <code>string definition = 3;</code>
   *
   * @return The definition.
   */
  @java.lang.Override
  public java.lang.String getDefinition() {
    java.lang.Object ref = definition_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      definition_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The definition of the schema. This should contain a string representing
   * the full definition of the schema that is a valid schema definition of
   * the type specified in `type`.
   * </pre>
   *
   * <code>string definition = 3;</code>
   *
   * @return The bytes for definition.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefinitionBytes() {
    java.lang.Object ref = definition_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      definition_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REVISION_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object revisionId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The revision ID of the schema.
   * </pre>
   *
   * <code>
   * string revision_id = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The revisionId.
   */
  @java.lang.Override
  public java.lang.String getRevisionId() {
    java.lang.Object ref = revisionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      revisionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The revision ID of the schema.
   * </pre>
   *
   * <code>
   * string revision_id = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for revisionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRevisionIdBytes() {
    java.lang.Object ref = revisionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      revisionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REVISION_CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp revisionCreateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp that the revision was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp revision_create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the revisionCreateTime field is set.
   */
  @java.lang.Override
  public boolean hasRevisionCreateTime() {
    return revisionCreateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp that the revision was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp revision_create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The revisionCreateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRevisionCreateTime() {
    return revisionCreateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : revisionCreateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp that the revision was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp revision_create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRevisionCreateTimeOrBuilder() {
    return revisionCreateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : revisionCreateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (type_ != com.google.pubsub.v1.Schema.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(definition_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, definition_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(revisionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, revisionId_);
    }
    if (revisionCreateTime_ != null) {
      output.writeMessage(6, getRevisionCreateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (type_ != com.google.pubsub.v1.Schema.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(definition_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, definition_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(revisionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, revisionId_);
    }
    if (revisionCreateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getRevisionCreateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.pubsub.v1.Schema)) {
      return super.equals(obj);
    }
    com.google.pubsub.v1.Schema other = (com.google.pubsub.v1.Schema) obj;

    if (!getName().equals(other.getName())) return false;
    if (type_ != other.type_) return false;
    if (!getDefinition().equals(other.getDefinition())) return false;
    if (!getRevisionId().equals(other.getRevisionId())) return false;
    if (hasRevisionCreateTime() != other.hasRevisionCreateTime()) return false;
    if (hasRevisionCreateTime()) {
      if (!getRevisionCreateTime().equals(other.getRevisionCreateTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + DEFINITION_FIELD_NUMBER;
    hash = (53 * hash) + getDefinition().hashCode();
    hash = (37 * hash) + REVISION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRevisionId().hashCode();
    if (hasRevisionCreateTime()) {
      hash = (37 * hash) + REVISION_CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getRevisionCreateTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.pubsub.v1.Schema parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.Schema parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.Schema parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.Schema parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.Schema parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.Schema parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.Schema parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.Schema parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.Schema parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.Schema parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.Schema parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.Schema parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.pubsub.v1.Schema prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A schema resource.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.Schema}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.pubsub.v1.Schema)
      com.google.pubsub.v1.SchemaOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.SchemaProto.internal_static_google_pubsub_v1_Schema_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.SchemaProto
          .internal_static_google_pubsub_v1_Schema_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.Schema.class, com.google.pubsub.v1.Schema.Builder.class);
    }

    // Construct using com.google.pubsub.v1.Schema.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      type_ = 0;
      definition_ = "";
      revisionId_ = "";
      revisionCreateTime_ = null;
      if (revisionCreateTimeBuilder_ != null) {
        revisionCreateTimeBuilder_.dispose();
        revisionCreateTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.pubsub.v1.SchemaProto.internal_static_google_pubsub_v1_Schema_descriptor;
    }

    @java.lang.Override
    public com.google.pubsub.v1.Schema getDefaultInstanceForType() {
      return com.google.pubsub.v1.Schema.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.pubsub.v1.Schema build() {
      com.google.pubsub.v1.Schema result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.pubsub.v1.Schema buildPartial() {
      com.google.pubsub.v1.Schema result = new com.google.pubsub.v1.Schema(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.pubsub.v1.Schema result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.definition_ = definition_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.revisionId_ = revisionId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.revisionCreateTime_ =
            revisionCreateTimeBuilder_ == null
                ? revisionCreateTime_
                : revisionCreateTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.pubsub.v1.Schema) {
        return mergeFrom((com.google.pubsub.v1.Schema) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.pubsub.v1.Schema other) {
      if (other == com.google.pubsub.v1.Schema.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (!other.getDefinition().isEmpty()) {
        definition_ = other.definition_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getRevisionId().isEmpty()) {
        revisionId_ = other.revisionId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasRevisionCreateTime()) {
        mergeRevisionCreateTime(other.getRevisionCreateTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                definition_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                revisionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 50:
              {
                input.readMessage(
                    getRevisionCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the schema.
     * Format is `projects/{project}/schemas/{schema}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the schema.
     * Format is `projects/{project}/schemas/{schema}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the schema.
     * Format is `projects/{project}/schemas/{schema}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the schema.
     * Format is `projects/{project}/schemas/{schema}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the schema.
     * Format is `projects/{project}/schemas/{schema}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The type of the schema definition.
     * </pre>
     *
     * <code>.google.pubsub.v1.Schema.Type type = 2;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The type of the schema definition.
     * </pre>
     *
     * <code>.google.pubsub.v1.Schema.Type type = 2;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the schema definition.
     * </pre>
     *
     * <code>.google.pubsub.v1.Schema.Type type = 2;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.pubsub.v1.Schema.Type getType() {
      com.google.pubsub.v1.Schema.Type result = com.google.pubsub.v1.Schema.Type.forNumber(type_);
      return result == null ? com.google.pubsub.v1.Schema.Type.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The type of the schema definition.
     * </pre>
     *
     * <code>.google.pubsub.v1.Schema.Type type = 2;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.pubsub.v1.Schema.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the schema definition.
     * </pre>
     *
     * <code>.google.pubsub.v1.Schema.Type type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      type_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object definition_ = "";
    /**
     *
     *
     * <pre>
     * The definition of the schema. This should contain a string representing
     * the full definition of the schema that is a valid schema definition of
     * the type specified in `type`.
     * </pre>
     *
     * <code>string definition = 3;</code>
     *
     * @return The definition.
     */
    public java.lang.String getDefinition() {
      java.lang.Object ref = definition_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        definition_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The definition of the schema. This should contain a string representing
     * the full definition of the schema that is a valid schema definition of
     * the type specified in `type`.
     * </pre>
     *
     * <code>string definition = 3;</code>
     *
     * @return The bytes for definition.
     */
    public com.google.protobuf.ByteString getDefinitionBytes() {
      java.lang.Object ref = definition_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        definition_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The definition of the schema. This should contain a string representing
     * the full definition of the schema that is a valid schema definition of
     * the type specified in `type`.
     * </pre>
     *
     * <code>string definition = 3;</code>
     *
     * @param value The definition to set.
     * @return This builder for chaining.
     */
    public Builder setDefinition(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      definition_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The definition of the schema. This should contain a string representing
     * the full definition of the schema that is a valid schema definition of
     * the type specified in `type`.
     * </pre>
     *
     * <code>string definition = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefinition() {
      definition_ = getDefaultInstance().getDefinition();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The definition of the schema. This should contain a string representing
     * the full definition of the schema that is a valid schema definition of
     * the type specified in `type`.
     * </pre>
     *
     * <code>string definition = 3;</code>
     *
     * @param value The bytes for definition to set.
     * @return This builder for chaining.
     */
    public Builder setDefinitionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      definition_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object revisionId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The revision ID of the schema.
     * </pre>
     *
     * <code>
     * string revision_id = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The revisionId.
     */
    public java.lang.String getRevisionId() {
      java.lang.Object ref = revisionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        revisionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The revision ID of the schema.
     * </pre>
     *
     * <code>
     * string revision_id = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for revisionId.
     */
    public com.google.protobuf.ByteString getRevisionIdBytes() {
      java.lang.Object ref = revisionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        revisionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The revision ID of the schema.
     * </pre>
     *
     * <code>
     * string revision_id = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The revisionId to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      revisionId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The revision ID of the schema.
     * </pre>
     *
     * <code>
     * string revision_id = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRevisionId() {
      revisionId_ = getDefaultInstance().getRevisionId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The revision ID of the schema.
     * </pre>
     *
     * <code>
     * string revision_id = 4 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for revisionId to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      revisionId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp revisionCreateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        revisionCreateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the revisionCreateTime field is set.
     */
    public boolean hasRevisionCreateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The revisionCreateTime.
     */
    public com.google.protobuf.Timestamp getRevisionCreateTime() {
      if (revisionCreateTimeBuilder_ == null) {
        return revisionCreateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : revisionCreateTime_;
      } else {
        return revisionCreateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRevisionCreateTime(com.google.protobuf.Timestamp value) {
      if (revisionCreateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        revisionCreateTime_ = value;
      } else {
        revisionCreateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRevisionCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (revisionCreateTimeBuilder_ == null) {
        revisionCreateTime_ = builderForValue.build();
      } else {
        revisionCreateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRevisionCreateTime(com.google.protobuf.Timestamp value) {
      if (revisionCreateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && revisionCreateTime_ != null
            && revisionCreateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getRevisionCreateTimeBuilder().mergeFrom(value);
        } else {
          revisionCreateTime_ = value;
        }
      } else {
        revisionCreateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRevisionCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      revisionCreateTime_ = null;
      if (revisionCreateTimeBuilder_ != null) {
        revisionCreateTimeBuilder_.dispose();
        revisionCreateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getRevisionCreateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getRevisionCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getRevisionCreateTimeOrBuilder() {
      if (revisionCreateTimeBuilder_ != null) {
        return revisionCreateTimeBuilder_.getMessageOrBuilder();
      } else {
        return revisionCreateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : revisionCreateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRevisionCreateTimeFieldBuilder() {
      if (revisionCreateTimeBuilder_ == null) {
        revisionCreateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getRevisionCreateTime(), getParentForChildren(), isClean());
        revisionCreateTime_ = null;
      }
      return revisionCreateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.pubsub.v1.Schema)
  }

  // @@protoc_insertion_point(class_scope:google.pubsub.v1.Schema)
  private static final com.google.pubsub.v1.Schema DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.pubsub.v1.Schema();
  }

  public static com.google.pubsub.v1.Schema getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Schema> PARSER =
      new com.google.protobuf.AbstractParser<Schema>() {
        @java.lang.Override
        public Schema parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Schema> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Schema> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.pubsub.v1.Schema getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
