/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/uptime.proto

// Protobuf Java Version: 3.25.8
package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * Describes a Synthetic Monitor to be invoked by Uptime.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.SyntheticMonitorTarget}
 */
public final class SyntheticMonitorTarget extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.SyntheticMonitorTarget)
    SyntheticMonitorTargetOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SyntheticMonitorTarget.newBuilder() to construct.
  private SyntheticMonitorTarget(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SyntheticMonitorTarget() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SyntheticMonitorTarget();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.UptimeProto
        .internal_static_google_monitoring_v3_SyntheticMonitorTarget_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.UptimeProto
        .internal_static_google_monitoring_v3_SyntheticMonitorTarget_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.SyntheticMonitorTarget.class,
            com.google.monitoring.v3.SyntheticMonitorTarget.Builder.class);
  }

  public interface CloudFunctionV2TargetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Fully qualified GCFv2 resource name
     * i.e. `projects/{project}/locations/{location}/functions/{function}`
     * Required.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    java.lang.String getName();

    /**
     *
     *
     * <pre>
     * Required. Fully qualified GCFv2 resource name
     * i.e. `projects/{project}/locations/{location}/functions/{function}`
     * Required.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Output only. The `cloud_run_revision` Monitored Resource associated with
     * the GCFv2. The Synthetic Monitor execution results (metrics, logs, and
     * spans) are reported against this Monitored Resource. This field is output
     * only.
     * </pre>
     *
     * <code>
     * .google.api.MonitoredResource cloud_run_revision = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the cloudRunRevision field is set.
     */
    boolean hasCloudRunRevision();

    /**
     *
     *
     * <pre>
     * Output only. The `cloud_run_revision` Monitored Resource associated with
     * the GCFv2. The Synthetic Monitor execution results (metrics, logs, and
     * spans) are reported against this Monitored Resource. This field is output
     * only.
     * </pre>
     *
     * <code>
     * .google.api.MonitoredResource cloud_run_revision = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The cloudRunRevision.
     */
    com.google.api.MonitoredResource getCloudRunRevision();

    /**
     *
     *
     * <pre>
     * Output only. The `cloud_run_revision` Monitored Resource associated with
     * the GCFv2. The Synthetic Monitor execution results (metrics, logs, and
     * spans) are reported against this Monitored Resource. This field is output
     * only.
     * </pre>
     *
     * <code>
     * .google.api.MonitoredResource cloud_run_revision = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.api.MonitoredResourceOrBuilder getCloudRunRevisionOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * A Synthetic Monitor deployed to a Cloud Functions V2 instance.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target}
   */
  public static final class CloudFunctionV2Target extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target)
      CloudFunctionV2TargetOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use CloudFunctionV2Target.newBuilder() to construct.
    private CloudFunctionV2Target(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CloudFunctionV2Target() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CloudFunctionV2Target();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_SyntheticMonitorTarget_CloudFunctionV2Target_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_SyntheticMonitorTarget_CloudFunctionV2Target_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target.class,
              com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target.Builder.class);
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Required. Fully qualified GCFv2 resource name
     * i.e. `projects/{project}/locations/{location}/functions/{function}`
     * Required.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Fully qualified GCFv2 resource name
     * i.e. `projects/{project}/locations/{location}/functions/{function}`
     * Required.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CLOUD_RUN_REVISION_FIELD_NUMBER = 2;
    private com.google.api.MonitoredResource cloudRunRevision_;

    /**
     *
     *
     * <pre>
     * Output only. The `cloud_run_revision` Monitored Resource associated with
     * the GCFv2. The Synthetic Monitor execution results (metrics, logs, and
     * spans) are reported against this Monitored Resource. This field is output
     * only.
     * </pre>
     *
     * <code>
     * .google.api.MonitoredResource cloud_run_revision = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the cloudRunRevision field is set.
     */
    @java.lang.Override
    public boolean hasCloudRunRevision() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The `cloud_run_revision` Monitored Resource associated with
     * the GCFv2. The Synthetic Monitor execution results (metrics, logs, and
     * spans) are reported against this Monitored Resource. This field is output
     * only.
     * </pre>
     *
     * <code>
     * .google.api.MonitoredResource cloud_run_revision = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The cloudRunRevision.
     */
    @java.lang.Override
    public com.google.api.MonitoredResource getCloudRunRevision() {
      return cloudRunRevision_ == null
          ? com.google.api.MonitoredResource.getDefaultInstance()
          : cloudRunRevision_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The `cloud_run_revision` Monitored Resource associated with
     * the GCFv2. The Synthetic Monitor execution results (metrics, logs, and
     * spans) are reported against this Monitored Resource. This field is output
     * only.
     * </pre>
     *
     * <code>
     * .google.api.MonitoredResource cloud_run_revision = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.api.MonitoredResourceOrBuilder getCloudRunRevisionOrBuilder() {
      return cloudRunRevision_ == null
          ? com.google.api.MonitoredResource.getDefaultInstance()
          : cloudRunRevision_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getCloudRunRevision());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCloudRunRevision());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target other =
          (com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target) obj;

      if (!getName().equals(other.getName())) return false;
      if (hasCloudRunRevision() != other.hasCloudRunRevision()) return false;
      if (hasCloudRunRevision()) {
        if (!getCloudRunRevision().equals(other.getCloudRunRevision())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (hasCloudRunRevision()) {
        hash = (37 * hash) + CLOUD_RUN_REVISION_FIELD_NUMBER;
        hash = (53 * hash) + getCloudRunRevision().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A Synthetic Monitor deployed to a Cloud Functions V2 instance.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target)
        com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2TargetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_SyntheticMonitorTarget_CloudFunctionV2Target_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_SyntheticMonitorTarget_CloudFunctionV2Target_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target.class,
                com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target.Builder
                    .class);
      }

      // Construct using
      // com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getCloudRunRevisionFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        cloudRunRevision_ = null;
        if (cloudRunRevisionBuilder_ != null) {
          cloudRunRevisionBuilder_.dispose();
          cloudRunRevisionBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_SyntheticMonitorTarget_CloudFunctionV2Target_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target
          getDefaultInstanceForType() {
        return com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target build() {
        com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target buildPartial() {
        com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target result =
            new com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.cloudRunRevision_ =
              cloudRunRevisionBuilder_ == null
                  ? cloudRunRevision_
                  : cloudRunRevisionBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target) {
          return mergeFrom(
              (com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target other) {
        if (other
            == com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasCloudRunRevision()) {
          mergeCloudRunRevision(other.getCloudRunRevision());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getCloudRunRevisionFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";

      /**
       *
       *
       * <pre>
       * Required. Fully qualified GCFv2 resource name
       * i.e. `projects/{project}/locations/{location}/functions/{function}`
       * Required.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Fully qualified GCFv2 resource name
       * i.e. `projects/{project}/locations/{location}/functions/{function}`
       * Required.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Fully qualified GCFv2 resource name
       * i.e. `projects/{project}/locations/{location}/functions/{function}`
       * Required.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Fully qualified GCFv2 resource name
       * i.e. `projects/{project}/locations/{location}/functions/{function}`
       * Required.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Fully qualified GCFv2 resource name
       * i.e. `projects/{project}/locations/{location}/functions/{function}`
       * Required.
       * </pre>
       *
       * <code>
       * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.api.MonitoredResource cloudRunRevision_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.api.MonitoredResource,
              com.google.api.MonitoredResource.Builder,
              com.google.api.MonitoredResourceOrBuilder>
          cloudRunRevisionBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. The `cloud_run_revision` Monitored Resource associated with
       * the GCFv2. The Synthetic Monitor execution results (metrics, logs, and
       * spans) are reported against this Monitored Resource. This field is output
       * only.
       * </pre>
       *
       * <code>
       * .google.api.MonitoredResource cloud_run_revision = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the cloudRunRevision field is set.
       */
      public boolean hasCloudRunRevision() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Output only. The `cloud_run_revision` Monitored Resource associated with
       * the GCFv2. The Synthetic Monitor execution results (metrics, logs, and
       * spans) are reported against this Monitored Resource. This field is output
       * only.
       * </pre>
       *
       * <code>
       * .google.api.MonitoredResource cloud_run_revision = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The cloudRunRevision.
       */
      public com.google.api.MonitoredResource getCloudRunRevision() {
        if (cloudRunRevisionBuilder_ == null) {
          return cloudRunRevision_ == null
              ? com.google.api.MonitoredResource.getDefaultInstance()
              : cloudRunRevision_;
        } else {
          return cloudRunRevisionBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The `cloud_run_revision` Monitored Resource associated with
       * the GCFv2. The Synthetic Monitor execution results (metrics, logs, and
       * spans) are reported against this Monitored Resource. This field is output
       * only.
       * </pre>
       *
       * <code>
       * .google.api.MonitoredResource cloud_run_revision = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setCloudRunRevision(com.google.api.MonitoredResource value) {
        if (cloudRunRevisionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          cloudRunRevision_ = value;
        } else {
          cloudRunRevisionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The `cloud_run_revision` Monitored Resource associated with
       * the GCFv2. The Synthetic Monitor execution results (metrics, logs, and
       * spans) are reported against this Monitored Resource. This field is output
       * only.
       * </pre>
       *
       * <code>
       * .google.api.MonitoredResource cloud_run_revision = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setCloudRunRevision(com.google.api.MonitoredResource.Builder builderForValue) {
        if (cloudRunRevisionBuilder_ == null) {
          cloudRunRevision_ = builderForValue.build();
        } else {
          cloudRunRevisionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The `cloud_run_revision` Monitored Resource associated with
       * the GCFv2. The Synthetic Monitor execution results (metrics, logs, and
       * spans) are reported against this Monitored Resource. This field is output
       * only.
       * </pre>
       *
       * <code>
       * .google.api.MonitoredResource cloud_run_revision = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeCloudRunRevision(com.google.api.MonitoredResource value) {
        if (cloudRunRevisionBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && cloudRunRevision_ != null
              && cloudRunRevision_ != com.google.api.MonitoredResource.getDefaultInstance()) {
            getCloudRunRevisionBuilder().mergeFrom(value);
          } else {
            cloudRunRevision_ = value;
          }
        } else {
          cloudRunRevisionBuilder_.mergeFrom(value);
        }
        if (cloudRunRevision_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The `cloud_run_revision` Monitored Resource associated with
       * the GCFv2. The Synthetic Monitor execution results (metrics, logs, and
       * spans) are reported against this Monitored Resource. This field is output
       * only.
       * </pre>
       *
       * <code>
       * .google.api.MonitoredResource cloud_run_revision = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearCloudRunRevision() {
        bitField0_ = (bitField0_ & ~0x00000002);
        cloudRunRevision_ = null;
        if (cloudRunRevisionBuilder_ != null) {
          cloudRunRevisionBuilder_.dispose();
          cloudRunRevisionBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The `cloud_run_revision` Monitored Resource associated with
       * the GCFv2. The Synthetic Monitor execution results (metrics, logs, and
       * spans) are reported against this Monitored Resource. This field is output
       * only.
       * </pre>
       *
       * <code>
       * .google.api.MonitoredResource cloud_run_revision = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.api.MonitoredResource.Builder getCloudRunRevisionBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getCloudRunRevisionFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Output only. The `cloud_run_revision` Monitored Resource associated with
       * the GCFv2. The Synthetic Monitor execution results (metrics, logs, and
       * spans) are reported against this Monitored Resource. This field is output
       * only.
       * </pre>
       *
       * <code>
       * .google.api.MonitoredResource cloud_run_revision = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.api.MonitoredResourceOrBuilder getCloudRunRevisionOrBuilder() {
        if (cloudRunRevisionBuilder_ != null) {
          return cloudRunRevisionBuilder_.getMessageOrBuilder();
        } else {
          return cloudRunRevision_ == null
              ? com.google.api.MonitoredResource.getDefaultInstance()
              : cloudRunRevision_;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The `cloud_run_revision` Monitored Resource associated with
       * the GCFv2. The Synthetic Monitor execution results (metrics, logs, and
       * spans) are reported against this Monitored Resource. This field is output
       * only.
       * </pre>
       *
       * <code>
       * .google.api.MonitoredResource cloud_run_revision = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.api.MonitoredResource,
              com.google.api.MonitoredResource.Builder,
              com.google.api.MonitoredResourceOrBuilder>
          getCloudRunRevisionFieldBuilder() {
        if (cloudRunRevisionBuilder_ == null) {
          cloudRunRevisionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.api.MonitoredResource,
                  com.google.api.MonitoredResource.Builder,
                  com.google.api.MonitoredResourceOrBuilder>(
                  getCloudRunRevision(), getParentForChildren(), isClean());
          cloudRunRevision_ = null;
        }
        return cloudRunRevisionBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target)
    private static final com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target();
    }

    public static com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CloudFunctionV2Target> PARSER =
        new com.google.protobuf.AbstractParser<CloudFunctionV2Target>() {
          @java.lang.Override
          public CloudFunctionV2Target parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CloudFunctionV2Target> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CloudFunctionV2Target> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int targetCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object target_;

  public enum TargetCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CLOUD_FUNCTION_V2(1),
    TARGET_NOT_SET(0);
    private final int value;

    private TargetCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TargetCase valueOf(int value) {
      return forNumber(value);
    }

    public static TargetCase forNumber(int value) {
      switch (value) {
        case 1:
          return CLOUD_FUNCTION_V2;
        case 0:
          return TARGET_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TargetCase getTargetCase() {
    return TargetCase.forNumber(targetCase_);
  }

  public static final int CLOUD_FUNCTION_V2_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * Target a Synthetic Monitor GCFv2 instance.
   * </pre>
   *
   * <code>.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target cloud_function_v2 = 1;
   * </code>
   *
   * @return Whether the cloudFunctionV2 field is set.
   */
  @java.lang.Override
  public boolean hasCloudFunctionV2() {
    return targetCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * Target a Synthetic Monitor GCFv2 instance.
   * </pre>
   *
   * <code>.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target cloud_function_v2 = 1;
   * </code>
   *
   * @return The cloudFunctionV2.
   */
  @java.lang.Override
  public com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target
      getCloudFunctionV2() {
    if (targetCase_ == 1) {
      return (com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target) target_;
    }
    return com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Target a Synthetic Monitor GCFv2 instance.
   * </pre>
   *
   * <code>.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target cloud_function_v2 = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2TargetOrBuilder
      getCloudFunctionV2OrBuilder() {
    if (targetCase_ == 1) {
      return (com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target) target_;
    }
    return com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target
        .getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (targetCase_ == 1) {
      output.writeMessage(
          1, (com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target) target_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (targetCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target) target_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.SyntheticMonitorTarget)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.SyntheticMonitorTarget other =
        (com.google.monitoring.v3.SyntheticMonitorTarget) obj;

    if (!getTargetCase().equals(other.getTargetCase())) return false;
    switch (targetCase_) {
      case 1:
        if (!getCloudFunctionV2().equals(other.getCloudFunctionV2())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (targetCase_) {
      case 1:
        hash = (37 * hash) + CLOUD_FUNCTION_V2_FIELD_NUMBER;
        hash = (53 * hash) + getCloudFunctionV2().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.SyntheticMonitorTarget parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.SyntheticMonitorTarget parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.SyntheticMonitorTarget parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.SyntheticMonitorTarget parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.SyntheticMonitorTarget parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.SyntheticMonitorTarget parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.SyntheticMonitorTarget parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.SyntheticMonitorTarget parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.SyntheticMonitorTarget parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.SyntheticMonitorTarget parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.SyntheticMonitorTarget parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.SyntheticMonitorTarget parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.SyntheticMonitorTarget prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Describes a Synthetic Monitor to be invoked by Uptime.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.SyntheticMonitorTarget}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.SyntheticMonitorTarget)
      com.google.monitoring.v3.SyntheticMonitorTargetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_SyntheticMonitorTarget_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_SyntheticMonitorTarget_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.SyntheticMonitorTarget.class,
              com.google.monitoring.v3.SyntheticMonitorTarget.Builder.class);
    }

    // Construct using com.google.monitoring.v3.SyntheticMonitorTarget.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (cloudFunctionV2Builder_ != null) {
        cloudFunctionV2Builder_.clear();
      }
      targetCase_ = 0;
      target_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_SyntheticMonitorTarget_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.SyntheticMonitorTarget getDefaultInstanceForType() {
      return com.google.monitoring.v3.SyntheticMonitorTarget.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.SyntheticMonitorTarget build() {
      com.google.monitoring.v3.SyntheticMonitorTarget result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.SyntheticMonitorTarget buildPartial() {
      com.google.monitoring.v3.SyntheticMonitorTarget result =
          new com.google.monitoring.v3.SyntheticMonitorTarget(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.monitoring.v3.SyntheticMonitorTarget result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.monitoring.v3.SyntheticMonitorTarget result) {
      result.targetCase_ = targetCase_;
      result.target_ = this.target_;
      if (targetCase_ == 1 && cloudFunctionV2Builder_ != null) {
        result.target_ = cloudFunctionV2Builder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.SyntheticMonitorTarget) {
        return mergeFrom((com.google.monitoring.v3.SyntheticMonitorTarget) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.SyntheticMonitorTarget other) {
      if (other == com.google.monitoring.v3.SyntheticMonitorTarget.getDefaultInstance())
        return this;
      switch (other.getTargetCase()) {
        case CLOUD_FUNCTION_V2:
          {
            mergeCloudFunctionV2(other.getCloudFunctionV2());
            break;
          }
        case TARGET_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCloudFunctionV2FieldBuilder().getBuilder(), extensionRegistry);
                targetCase_ = 1;
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int targetCase_ = 0;
    private java.lang.Object target_;

    public TargetCase getTargetCase() {
      return TargetCase.forNumber(targetCase_);
    }

    public Builder clearTarget() {
      targetCase_ = 0;
      target_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target,
            com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target.Builder,
            com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2TargetOrBuilder>
        cloudFunctionV2Builder_;

    /**
     *
     *
     * <pre>
     * Target a Synthetic Monitor GCFv2 instance.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target cloud_function_v2 = 1;
     * </code>
     *
     * @return Whether the cloudFunctionV2 field is set.
     */
    @java.lang.Override
    public boolean hasCloudFunctionV2() {
      return targetCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Target a Synthetic Monitor GCFv2 instance.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target cloud_function_v2 = 1;
     * </code>
     *
     * @return The cloudFunctionV2.
     */
    @java.lang.Override
    public com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target
        getCloudFunctionV2() {
      if (cloudFunctionV2Builder_ == null) {
        if (targetCase_ == 1) {
          return (com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target) target_;
        }
        return com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target
            .getDefaultInstance();
      } else {
        if (targetCase_ == 1) {
          return cloudFunctionV2Builder_.getMessage();
        }
        return com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Target a Synthetic Monitor GCFv2 instance.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target cloud_function_v2 = 1;
     * </code>
     */
    public Builder setCloudFunctionV2(
        com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target value) {
      if (cloudFunctionV2Builder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        target_ = value;
        onChanged();
      } else {
        cloudFunctionV2Builder_.setMessage(value);
      }
      targetCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Target a Synthetic Monitor GCFv2 instance.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target cloud_function_v2 = 1;
     * </code>
     */
    public Builder setCloudFunctionV2(
        com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target.Builder
            builderForValue) {
      if (cloudFunctionV2Builder_ == null) {
        target_ = builderForValue.build();
        onChanged();
      } else {
        cloudFunctionV2Builder_.setMessage(builderForValue.build());
      }
      targetCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Target a Synthetic Monitor GCFv2 instance.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target cloud_function_v2 = 1;
     * </code>
     */
    public Builder mergeCloudFunctionV2(
        com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target value) {
      if (cloudFunctionV2Builder_ == null) {
        if (targetCase_ == 1
            && target_
                != com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target
                    .getDefaultInstance()) {
          target_ =
              com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target.newBuilder(
                      (com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target)
                          target_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          target_ = value;
        }
        onChanged();
      } else {
        if (targetCase_ == 1) {
          cloudFunctionV2Builder_.mergeFrom(value);
        } else {
          cloudFunctionV2Builder_.setMessage(value);
        }
      }
      targetCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Target a Synthetic Monitor GCFv2 instance.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target cloud_function_v2 = 1;
     * </code>
     */
    public Builder clearCloudFunctionV2() {
      if (cloudFunctionV2Builder_ == null) {
        if (targetCase_ == 1) {
          targetCase_ = 0;
          target_ = null;
          onChanged();
        }
      } else {
        if (targetCase_ == 1) {
          targetCase_ = 0;
          target_ = null;
        }
        cloudFunctionV2Builder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Target a Synthetic Monitor GCFv2 instance.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target cloud_function_v2 = 1;
     * </code>
     */
    public com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target.Builder
        getCloudFunctionV2Builder() {
      return getCloudFunctionV2FieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Target a Synthetic Monitor GCFv2 instance.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target cloud_function_v2 = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2TargetOrBuilder
        getCloudFunctionV2OrBuilder() {
      if ((targetCase_ == 1) && (cloudFunctionV2Builder_ != null)) {
        return cloudFunctionV2Builder_.getMessageOrBuilder();
      } else {
        if (targetCase_ == 1) {
          return (com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target) target_;
        }
        return com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Target a Synthetic Monitor GCFv2 instance.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target cloud_function_v2 = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target,
            com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target.Builder,
            com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2TargetOrBuilder>
        getCloudFunctionV2FieldBuilder() {
      if (cloudFunctionV2Builder_ == null) {
        if (!(targetCase_ == 1)) {
          target_ =
              com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target
                  .getDefaultInstance();
        }
        cloudFunctionV2Builder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target,
                com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target.Builder,
                com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2TargetOrBuilder>(
                (com.google.monitoring.v3.SyntheticMonitorTarget.CloudFunctionV2Target) target_,
                getParentForChildren(),
                isClean());
        target_ = null;
      }
      targetCase_ = 1;
      onChanged();
      return cloudFunctionV2Builder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.SyntheticMonitorTarget)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.SyntheticMonitorTarget)
  private static final com.google.monitoring.v3.SyntheticMonitorTarget DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.SyntheticMonitorTarget();
  }

  public static com.google.monitoring.v3.SyntheticMonitorTarget getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SyntheticMonitorTarget> PARSER =
      new com.google.protobuf.AbstractParser<SyntheticMonitorTarget>() {
        @java.lang.Override
        public SyntheticMonitorTarget parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SyntheticMonitorTarget> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SyntheticMonitorTarget> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.SyntheticMonitorTarget getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
