/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UptimeCheckConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_UPTIME_CHECK_CONFIG_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/uptimeCheckConfigs/{uptime_check_config}");
    private static final PathTemplate ORGANIZATION_UPTIME_CHECK_CONFIG_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/uptimeCheckConfigs/{uptime_check_config}");
    private static final PathTemplate FOLDER_UPTIME_CHECK_CONFIG_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/uptimeCheckConfigs/{uptime_check_config}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private String project;
    private String uptimeCheckConfig;
    private String organization;
    private String folder;

    @Deprecated
    protected UptimeCheckConfigName() {
    }

    public String getProject() {
        return this.project;
    }

    public String getUptimeCheckConfig() {
        return this.uptimeCheckConfig;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    private UptimeCheckConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.uptimeCheckConfig = (String)Preconditions.checkNotNull((Object)builder.getUptimeCheckConfig());
        this.pathTemplate = PROJECT_UPTIME_CHECK_CONFIG_PATH_TEMPLATE;
    }

    private UptimeCheckConfigName(OrganizationUptimeCheckConfigBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.uptimeCheckConfig = (String)Preconditions.checkNotNull((Object)builder.getUptimeCheckConfig());
        this.pathTemplate = ORGANIZATION_UPTIME_CHECK_CONFIG_PATH_TEMPLATE;
    }

    private UptimeCheckConfigName(FolderUptimeCheckConfigBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.uptimeCheckConfig = (String)Preconditions.checkNotNull((Object)builder.getUptimeCheckConfig());
        this.pathTemplate = FOLDER_UPTIME_CHECK_CONFIG_PATH_TEMPLATE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectUptimeCheckConfigBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationUptimeCheckConfigBuilder newOrganizationUptimeCheckConfigBuilder() {
        return new OrganizationUptimeCheckConfigBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderUptimeCheckConfigBuilder newFolderUptimeCheckConfigBuilder() {
        return new FolderUptimeCheckConfigBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static UptimeCheckConfigName of(String project, String uptimeCheckConfig) {
        return UptimeCheckConfigName.newProjectUptimeCheckConfigBuilder().setProject(project).setUptimeCheckConfig(uptimeCheckConfig).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static UptimeCheckConfigName ofProjectUptimeCheckConfigName(String project, String uptimeCheckConfig) {
        return UptimeCheckConfigName.newProjectUptimeCheckConfigBuilder().setProject(project).setUptimeCheckConfig(uptimeCheckConfig).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static UptimeCheckConfigName ofOrganizationUptimeCheckConfigName(String organization, String uptimeCheckConfig) {
        return UptimeCheckConfigName.newOrganizationUptimeCheckConfigBuilder().setOrganization(organization).setUptimeCheckConfig(uptimeCheckConfig).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static UptimeCheckConfigName ofFolderUptimeCheckConfigName(String folder, String uptimeCheckConfig) {
        return UptimeCheckConfigName.newFolderUptimeCheckConfigBuilder().setFolder(folder).setUptimeCheckConfig(uptimeCheckConfig).build();
    }

    public static String format(String project, String uptimeCheckConfig) {
        return UptimeCheckConfigName.newBuilder().setProject(project).setUptimeCheckConfig(uptimeCheckConfig).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectUptimeCheckConfigName(String project, String uptimeCheckConfig) {
        return UptimeCheckConfigName.newBuilder().setProject(project).setUptimeCheckConfig(uptimeCheckConfig).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationUptimeCheckConfigName(String organization, String uptimeCheckConfig) {
        return UptimeCheckConfigName.newOrganizationUptimeCheckConfigBuilder().setOrganization(organization).setUptimeCheckConfig(uptimeCheckConfig).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderUptimeCheckConfigName(String folder, String uptimeCheckConfig) {
        return UptimeCheckConfigName.newFolderUptimeCheckConfigBuilder().setFolder(folder).setUptimeCheckConfig(uptimeCheckConfig).build().toString();
    }

    public static UptimeCheckConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_UPTIME_CHECK_CONFIG_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_UPTIME_CHECK_CONFIG_PATH_TEMPLATE.match(formattedString);
            return UptimeCheckConfigName.ofProjectUptimeCheckConfigName((String)matchMap.get("project"), (String)matchMap.get("uptime_check_config"));
        }
        if (ORGANIZATION_UPTIME_CHECK_CONFIG_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_UPTIME_CHECK_CONFIG_PATH_TEMPLATE.match(formattedString);
            return UptimeCheckConfigName.ofOrganizationUptimeCheckConfigName((String)matchMap.get("organization"), (String)matchMap.get("uptime_check_config"));
        }
        if (FOLDER_UPTIME_CHECK_CONFIG_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = FOLDER_UPTIME_CHECK_CONFIG_PATH_TEMPLATE.match(formattedString);
            return UptimeCheckConfigName.ofFolderUptimeCheckConfigName((String)matchMap.get("folder"), (String)matchMap.get("uptime_check_config"));
        }
        throw new ValidationException("JobName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<UptimeCheckConfigName> parseList(List<String> formattedStrings) {
        ArrayList<UptimeCheckConfigName> list = new ArrayList<UptimeCheckConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UptimeCheckConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UptimeCheckConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UptimeCheckConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_UPTIME_CHECK_CONFIG_PATH_TEMPLATE.matches(formattedString) || ORGANIZATION_UPTIME_CHECK_CONFIG_PATH_TEMPLATE.matches(formattedString) || FOLDER_UPTIME_CHECK_CONFIG_PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UptimeCheckConfigName uptimeCheckConfigName = this;
            synchronized (uptimeCheckConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.uptimeCheckConfig != null) {
                        fieldMapBuilder.put((Object)"uptime_check_config", (Object)this.uptimeCheckConfig);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            UptimeCheckConfigName that = (UptimeCheckConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.uptimeCheckConfig, that.uptimeCheckConfig) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.uptimeCheckConfig);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        return h ^= Objects.hashCode(this.folder);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderUptimeCheckConfigBuilder {
        private String folder;
        private String uptimeCheckConfig;

        private FolderUptimeCheckConfigBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getUptimeCheckConfig() {
            return this.uptimeCheckConfig;
        }

        public FolderUptimeCheckConfigBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderUptimeCheckConfigBuilder setUptimeCheckConfig(String uptimeCheckConfig) {
            this.uptimeCheckConfig = uptimeCheckConfig;
            return this;
        }

        public UptimeCheckConfigName build() {
            return new UptimeCheckConfigName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationUptimeCheckConfigBuilder {
        private String organization;
        private String uptimeCheckConfig;

        private OrganizationUptimeCheckConfigBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getUptimeCheckConfig() {
            return this.uptimeCheckConfig;
        }

        public OrganizationUptimeCheckConfigBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationUptimeCheckConfigBuilder setUptimeCheckConfig(String uptimeCheckConfig) {
            this.uptimeCheckConfig = uptimeCheckConfig;
            return this;
        }

        public UptimeCheckConfigName build() {
            return new UptimeCheckConfigName(this);
        }
    }

    public static class Builder {
        private String project;
        private String uptimeCheckConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getUptimeCheckConfig() {
            return this.uptimeCheckConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setUptimeCheckConfig(String uptimeCheckConfig) {
            this.uptimeCheckConfig = uptimeCheckConfig;
            return this;
        }

        private Builder(UptimeCheckConfigName uptimeCheckConfigName) {
            Preconditions.checkArgument((uptimeCheckConfigName.pathTemplate == PROJECT_UPTIME_CHECK_CONFIG_PATH_TEMPLATE ? 1 : 0) != 0, (Object)"toBuilder is only supported when UptimeCheckConfigName has the pattern of projects/{project}/uptimeCheckConfigs/{uptime_check_config}.");
            this.project = uptimeCheckConfigName.project;
            this.uptimeCheckConfig = uptimeCheckConfigName.uptimeCheckConfig;
        }

        public UptimeCheckConfigName build() {
            return new UptimeCheckConfigName(this);
        }
    }
}

