/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MonitoredResourceDescriptorName
implements ResourceName {
    private static final PathTemplate PROJECT_MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/monitoredResourceDescriptors/{monitored_resource_descriptor}");
    private static final PathTemplate ORGANIZATION_MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/monitoredResourceDescriptors/{monitored_resource_descriptor}");
    private static final PathTemplate FOLDER_MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/monitoredResourceDescriptors/{monitored_resource_descriptor}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private String project;
    private String monitoredResourceDescriptor;
    private String organization;
    private String folder;

    @Deprecated
    protected MonitoredResourceDescriptorName() {
    }

    public String getProject() {
        return this.project;
    }

    public String getMonitoredResourceDescriptor() {
        return this.monitoredResourceDescriptor;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    private MonitoredResourceDescriptorName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.monitoredResourceDescriptor = (String)Preconditions.checkNotNull((Object)builder.getMonitoredResourceDescriptor());
        this.pathTemplate = PROJECT_MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE;
    }

    private MonitoredResourceDescriptorName(OrganizationMonitoredResourceDescriptorBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.monitoredResourceDescriptor = (String)Preconditions.checkNotNull((Object)builder.getMonitoredResourceDescriptor());
        this.pathTemplate = ORGANIZATION_MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE;
    }

    private MonitoredResourceDescriptorName(FolderMonitoredResourceDescriptorBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.monitoredResourceDescriptor = (String)Preconditions.checkNotNull((Object)builder.getMonitoredResourceDescriptor());
        this.pathTemplate = FOLDER_MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectMonitoredResourceDescriptorBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationMonitoredResourceDescriptorBuilder newOrganizationMonitoredResourceDescriptorBuilder() {
        return new OrganizationMonitoredResourceDescriptorBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderMonitoredResourceDescriptorBuilder newFolderMonitoredResourceDescriptorBuilder() {
        return new FolderMonitoredResourceDescriptorBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MonitoredResourceDescriptorName of(String project, String monitoredResourceDescriptor) {
        return MonitoredResourceDescriptorName.newProjectMonitoredResourceDescriptorBuilder().setProject(project).setMonitoredResourceDescriptor(monitoredResourceDescriptor).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static MonitoredResourceDescriptorName ofProjectMonitoredResourceDescriptorName(String project, String monitoredResourceDescriptor) {
        return MonitoredResourceDescriptorName.newProjectMonitoredResourceDescriptorBuilder().setProject(project).setMonitoredResourceDescriptor(monitoredResourceDescriptor).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static MonitoredResourceDescriptorName ofOrganizationMonitoredResourceDescriptorName(String organization, String monitoredResourceDescriptor) {
        return MonitoredResourceDescriptorName.newOrganizationMonitoredResourceDescriptorBuilder().setOrganization(organization).setMonitoredResourceDescriptor(monitoredResourceDescriptor).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static MonitoredResourceDescriptorName ofFolderMonitoredResourceDescriptorName(String folder, String monitoredResourceDescriptor) {
        return MonitoredResourceDescriptorName.newFolderMonitoredResourceDescriptorBuilder().setFolder(folder).setMonitoredResourceDescriptor(monitoredResourceDescriptor).build();
    }

    public static String format(String project, String monitoredResourceDescriptor) {
        return MonitoredResourceDescriptorName.newBuilder().setProject(project).setMonitoredResourceDescriptor(monitoredResourceDescriptor).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectMonitoredResourceDescriptorName(String project, String monitoredResourceDescriptor) {
        return MonitoredResourceDescriptorName.newBuilder().setProject(project).setMonitoredResourceDescriptor(monitoredResourceDescriptor).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationMonitoredResourceDescriptorName(String organization, String monitoredResourceDescriptor) {
        return MonitoredResourceDescriptorName.newOrganizationMonitoredResourceDescriptorBuilder().setOrganization(organization).setMonitoredResourceDescriptor(monitoredResourceDescriptor).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderMonitoredResourceDescriptorName(String folder, String monitoredResourceDescriptor) {
        return MonitoredResourceDescriptorName.newFolderMonitoredResourceDescriptorBuilder().setFolder(folder).setMonitoredResourceDescriptor(monitoredResourceDescriptor).build().toString();
    }

    public static MonitoredResourceDescriptorName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE.match(formattedString);
            return MonitoredResourceDescriptorName.ofProjectMonitoredResourceDescriptorName((String)matchMap.get("project"), (String)matchMap.get("monitored_resource_descriptor"));
        }
        if (ORGANIZATION_MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE.match(formattedString);
            return MonitoredResourceDescriptorName.ofOrganizationMonitoredResourceDescriptorName((String)matchMap.get("organization"), (String)matchMap.get("monitored_resource_descriptor"));
        }
        if (FOLDER_MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = FOLDER_MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE.match(formattedString);
            return MonitoredResourceDescriptorName.ofFolderMonitoredResourceDescriptorName((String)matchMap.get("folder"), (String)matchMap.get("monitored_resource_descriptor"));
        }
        throw new ValidationException("JobName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<MonitoredResourceDescriptorName> parseList(List<String> formattedStrings) {
        ArrayList<MonitoredResourceDescriptorName> list = new ArrayList<MonitoredResourceDescriptorName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MonitoredResourceDescriptorName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MonitoredResourceDescriptorName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MonitoredResourceDescriptorName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE.matches(formattedString) || ORGANIZATION_MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE.matches(formattedString) || FOLDER_MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MonitoredResourceDescriptorName monitoredResourceDescriptorName = this;
            synchronized (monitoredResourceDescriptorName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.monitoredResourceDescriptor != null) {
                        fieldMapBuilder.put((Object)"monitored_resource_descriptor", (Object)this.monitoredResourceDescriptor);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            MonitoredResourceDescriptorName that = (MonitoredResourceDescriptorName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.monitoredResourceDescriptor, that.monitoredResourceDescriptor) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.monitoredResourceDescriptor);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        return h ^= Objects.hashCode(this.folder);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderMonitoredResourceDescriptorBuilder {
        private String folder;
        private String monitoredResourceDescriptor;

        private FolderMonitoredResourceDescriptorBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getMonitoredResourceDescriptor() {
            return this.monitoredResourceDescriptor;
        }

        public FolderMonitoredResourceDescriptorBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderMonitoredResourceDescriptorBuilder setMonitoredResourceDescriptor(String monitoredResourceDescriptor) {
            this.monitoredResourceDescriptor = monitoredResourceDescriptor;
            return this;
        }

        public MonitoredResourceDescriptorName build() {
            return new MonitoredResourceDescriptorName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationMonitoredResourceDescriptorBuilder {
        private String organization;
        private String monitoredResourceDescriptor;

        private OrganizationMonitoredResourceDescriptorBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getMonitoredResourceDescriptor() {
            return this.monitoredResourceDescriptor;
        }

        public OrganizationMonitoredResourceDescriptorBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationMonitoredResourceDescriptorBuilder setMonitoredResourceDescriptor(String monitoredResourceDescriptor) {
            this.monitoredResourceDescriptor = monitoredResourceDescriptor;
            return this;
        }

        public MonitoredResourceDescriptorName build() {
            return new MonitoredResourceDescriptorName(this);
        }
    }

    public static class Builder {
        private String project;
        private String monitoredResourceDescriptor;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getMonitoredResourceDescriptor() {
            return this.monitoredResourceDescriptor;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setMonitoredResourceDescriptor(String monitoredResourceDescriptor) {
            this.monitoredResourceDescriptor = monitoredResourceDescriptor;
            return this;
        }

        private Builder(MonitoredResourceDescriptorName monitoredResourceDescriptorName) {
            Preconditions.checkArgument((monitoredResourceDescriptorName.pathTemplate == PROJECT_MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE ? 1 : 0) != 0, (Object)"toBuilder is only supported when MonitoredResourceDescriptorName has the pattern of projects/{project}/monitoredResourceDescriptors/{monitored_resource_descriptor}.");
            this.project = monitoredResourceDescriptorName.project;
            this.monitoredResourceDescriptor = monitoredResourceDescriptorName.monitoredResourceDescriptor;
        }

        public MonitoredResourceDescriptorName build() {
            return new MonitoredResourceDescriptorName(this);
        }
    }
}

