/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ServiceName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/services/{service}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String service;

    public String getProject() {
        return this.project;
    }

    public String getService() {
        return this.service;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ServiceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
    }

    public static ServiceName of(String project, String service) {
        return ServiceName.newBuilder().setProject(project).setService(service).build();
    }

    public static String format(String project, String service) {
        return ServiceName.newBuilder().setProject(project).setService(service).build().toString();
    }

    public static ServiceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ServiceName.parse: formattedString not in valid format");
        return ServiceName.of((String)matchMap.get("project"), (String)matchMap.get("service"));
    }

    public static List<ServiceName> parseList(List<String> formattedStrings) {
        ArrayList<ServiceName> list = new ArrayList<ServiceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServiceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServiceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServiceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServiceName serviceName = this;
            synchronized (serviceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"service", (Object)this.service);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "service", this.service});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ServiceName) {
            ServiceName that = (ServiceName)o;
            return this.project.equals(that.project) && this.service.equals(that.service);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.service.hashCode();
    }

    public static class Builder {
        private String project;
        private String service;

        public String getProject() {
            return this.project;
        }

        public String getService() {
            return this.service;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        private Builder() {
        }

        private Builder(ServiceName serviceName) {
            this.project = serviceName.project;
            this.service = serviceName.service;
        }

        public ServiceName build() {
            return new ServiceName(this);
        }
    }
}

