/*
 * Decompiled with CFR 0.152.
 */
package com.google.firestore.admin.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CollectionGroupName
implements ResourceName {
    private static final PathTemplate PROJECT_DATABASE_COLLECTION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/databases/{database}/collectionGroups/{collection}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String database;
    private final String collection;

    @Deprecated
    protected CollectionGroupName() {
        this.project = null;
        this.database = null;
        this.collection = null;
    }

    private CollectionGroupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.database = (String)Preconditions.checkNotNull((Object)builder.getDatabase());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
    }

    public String getProject() {
        return this.project;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        return this.collection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CollectionGroupName of(String project, String database, String collection) {
        return CollectionGroupName.newBuilder().setProject(project).setDatabase(database).setCollection(collection).build();
    }

    public static String format(String project, String database, String collection) {
        return CollectionGroupName.newBuilder().setProject(project).setDatabase(database).setCollection(collection).build().toString();
    }

    public static CollectionGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_DATABASE_COLLECTION.validatedMatch(formattedString, "CollectionGroupName.parse: formattedString not in valid format");
        return CollectionGroupName.of((String)matchMap.get("project"), (String)matchMap.get("database"), (String)matchMap.get("collection"));
    }

    public static List<CollectionGroupName> parseList(List<String> formattedStrings) {
        ArrayList<CollectionGroupName> list = new ArrayList<CollectionGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CollectionGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CollectionGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CollectionGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_DATABASE_COLLECTION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CollectionGroupName collectionGroupName = this;
            synchronized (collectionGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.database != null) {
                        fieldMapBuilder.put((Object)"database", (Object)this.database);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_DATABASE_COLLECTION.instantiate(new String[]{"project", this.project, "database", this.database, "collection", this.collection});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CollectionGroupName that = (CollectionGroupName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.database, that.database) && Objects.equals(this.collection, that.collection);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.database);
        h *= 1000003;
        return h ^= Objects.hashCode(this.collection);
    }

    public static class Builder {
        private String project;
        private String database;
        private String collection;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getCollection() {
            return this.collection;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        private Builder(CollectionGroupName collectionGroupName) {
            this.project = collectionGroupName.project;
            this.database = collectionGroupName.database;
            this.collection = collectionGroupName.collection;
        }

        public CollectionGroupName build() {
            return new CollectionGroupName(this);
        }
    }
}

