/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/admin/v1/user_creds.proto

// Protobuf Java Version: 3.25.8
package com.google.firestore.admin.v1;

/**
 *
 *
 * <pre>
 * A Cloud Firestore User Creds.
 * </pre>
 *
 * Protobuf type {@code google.firestore.admin.v1.UserCreds}
 */
public final class UserCreds extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.UserCreds)
    UserCredsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use UserCreds.newBuilder() to construct.
  private UserCreds(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UserCreds() {
    name_ = "";
    state_ = 0;
    securePassword_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UserCreds();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.admin.v1.UserCredsProto
        .internal_static_google_firestore_admin_v1_UserCreds_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.admin.v1.UserCredsProto
        .internal_static_google_firestore_admin_v1_UserCreds_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.admin.v1.UserCreds.class,
            com.google.firestore.admin.v1.UserCreds.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The state of the user creds (ENABLED or DISABLED).
   * </pre>
   *
   * Protobuf enum {@code google.firestore.admin.v1.UserCreds.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default value. Should not be used.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The user creds are enabled.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    ENABLED(1),
    /**
     *
     *
     * <pre>
     * The user creds are disabled.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    DISABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default value. Should not be used.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The user creds are enabled.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    public static final int ENABLED_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The user creds are disabled.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    public static final int DISABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ENABLED;
        case 2:
          return DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.admin.v1.UserCreds.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.UserCreds.State)
  }

  public interface ResourceIdentityOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.admin.v1.UserCreds.ResourceIdentity)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Principal identifier string.
     * See: https://cloud.google.com/iam/docs/principal-identifiers
     * </pre>
     *
     * <code>string principal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The principal.
     */
    java.lang.String getPrincipal();

    /**
     *
     *
     * <pre>
     * Output only. Principal identifier string.
     * See: https://cloud.google.com/iam/docs/principal-identifiers
     * </pre>
     *
     * <code>string principal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for principal.
     */
    com.google.protobuf.ByteString getPrincipalBytes();
  }

  /**
   *
   *
   * <pre>
   * Describes a Resource Identity principal.
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.UserCreds.ResourceIdentity}
   */
  public static final class ResourceIdentity extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.UserCreds.ResourceIdentity)
      ResourceIdentityOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ResourceIdentity.newBuilder() to construct.
    private ResourceIdentity(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ResourceIdentity() {
      principal_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ResourceIdentity();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.UserCredsProto
          .internal_static_google_firestore_admin_v1_UserCreds_ResourceIdentity_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.UserCredsProto
          .internal_static_google_firestore_admin_v1_UserCreds_ResourceIdentity_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.UserCreds.ResourceIdentity.class,
              com.google.firestore.admin.v1.UserCreds.ResourceIdentity.Builder.class);
    }

    public static final int PRINCIPAL_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object principal_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Principal identifier string.
     * See: https://cloud.google.com/iam/docs/principal-identifiers
     * </pre>
     *
     * <code>string principal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The principal.
     */
    @java.lang.Override
    public java.lang.String getPrincipal() {
      java.lang.Object ref = principal_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        principal_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Principal identifier string.
     * See: https://cloud.google.com/iam/docs/principal-identifiers
     * </pre>
     *
     * <code>string principal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for principal.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPrincipalBytes() {
      java.lang.Object ref = principal_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        principal_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(principal_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, principal_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(principal_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, principal_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.admin.v1.UserCreds.ResourceIdentity)) {
        return super.equals(obj);
      }
      com.google.firestore.admin.v1.UserCreds.ResourceIdentity other =
          (com.google.firestore.admin.v1.UserCreds.ResourceIdentity) obj;

      if (!getPrincipal().equals(other.getPrincipal())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PRINCIPAL_FIELD_NUMBER;
      hash = (53 * hash) + getPrincipal().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.admin.v1.UserCreds.ResourceIdentity parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.admin.v1.UserCreds.ResourceIdentity parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.UserCreds.ResourceIdentity parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.admin.v1.UserCreds.ResourceIdentity parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.UserCreds.ResourceIdentity parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.admin.v1.UserCreds.ResourceIdentity parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.UserCreds.ResourceIdentity parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.admin.v1.UserCreds.ResourceIdentity parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.UserCreds.ResourceIdentity parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.admin.v1.UserCreds.ResourceIdentity parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.UserCreds.ResourceIdentity parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.admin.v1.UserCreds.ResourceIdentity parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.firestore.admin.v1.UserCreds.ResourceIdentity prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Describes a Resource Identity principal.
     * </pre>
     *
     * Protobuf type {@code google.firestore.admin.v1.UserCreds.ResourceIdentity}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.UserCreds.ResourceIdentity)
        com.google.firestore.admin.v1.UserCreds.ResourceIdentityOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.admin.v1.UserCredsProto
            .internal_static_google_firestore_admin_v1_UserCreds_ResourceIdentity_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.admin.v1.UserCredsProto
            .internal_static_google_firestore_admin_v1_UserCreds_ResourceIdentity_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.admin.v1.UserCreds.ResourceIdentity.class,
                com.google.firestore.admin.v1.UserCreds.ResourceIdentity.Builder.class);
      }

      // Construct using com.google.firestore.admin.v1.UserCreds.ResourceIdentity.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        principal_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.admin.v1.UserCredsProto
            .internal_static_google_firestore_admin_v1_UserCreds_ResourceIdentity_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.UserCreds.ResourceIdentity getDefaultInstanceForType() {
        return com.google.firestore.admin.v1.UserCreds.ResourceIdentity.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.UserCreds.ResourceIdentity build() {
        com.google.firestore.admin.v1.UserCreds.ResourceIdentity result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.UserCreds.ResourceIdentity buildPartial() {
        com.google.firestore.admin.v1.UserCreds.ResourceIdentity result =
            new com.google.firestore.admin.v1.UserCreds.ResourceIdentity(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.firestore.admin.v1.UserCreds.ResourceIdentity result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.principal_ = principal_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.admin.v1.UserCreds.ResourceIdentity) {
          return mergeFrom((com.google.firestore.admin.v1.UserCreds.ResourceIdentity) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.firestore.admin.v1.UserCreds.ResourceIdentity other) {
        if (other == com.google.firestore.admin.v1.UserCreds.ResourceIdentity.getDefaultInstance())
          return this;
        if (!other.getPrincipal().isEmpty()) {
          principal_ = other.principal_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  principal_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object principal_ = "";

      /**
       *
       *
       * <pre>
       * Output only. Principal identifier string.
       * See: https://cloud.google.com/iam/docs/principal-identifiers
       * </pre>
       *
       * <code>string principal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The principal.
       */
      public java.lang.String getPrincipal() {
        java.lang.Object ref = principal_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          principal_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Principal identifier string.
       * See: https://cloud.google.com/iam/docs/principal-identifiers
       * </pre>
       *
       * <code>string principal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for principal.
       */
      public com.google.protobuf.ByteString getPrincipalBytes() {
        java.lang.Object ref = principal_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          principal_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Principal identifier string.
       * See: https://cloud.google.com/iam/docs/principal-identifiers
       * </pre>
       *
       * <code>string principal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The principal to set.
       * @return This builder for chaining.
       */
      public Builder setPrincipal(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        principal_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Principal identifier string.
       * See: https://cloud.google.com/iam/docs/principal-identifiers
       * </pre>
       *
       * <code>string principal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPrincipal() {
        principal_ = getDefaultInstance().getPrincipal();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Principal identifier string.
       * See: https://cloud.google.com/iam/docs/principal-identifiers
       * </pre>
       *
       * <code>string principal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for principal to set.
       * @return This builder for chaining.
       */
      public Builder setPrincipalBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        principal_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.UserCreds.ResourceIdentity)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.UserCreds.ResourceIdentity)
    private static final com.google.firestore.admin.v1.UserCreds.ResourceIdentity DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.admin.v1.UserCreds.ResourceIdentity();
    }

    public static com.google.firestore.admin.v1.UserCreds.ResourceIdentity getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ResourceIdentity> PARSER =
        new com.google.protobuf.AbstractParser<ResourceIdentity>() {
          @java.lang.Override
          public ResourceIdentity parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ResourceIdentity> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ResourceIdentity> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.UserCreds.ResourceIdentity getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int userCredsIdentityCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object userCredsIdentity_;

  public enum UserCredsIdentityCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    RESOURCE_IDENTITY(6),
    USERCREDSIDENTITY_NOT_SET(0);
    private final int value;

    private UserCredsIdentityCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static UserCredsIdentityCase valueOf(int value) {
      return forNumber(value);
    }

    public static UserCredsIdentityCase forNumber(int value) {
      switch (value) {
        case 6:
          return RESOURCE_IDENTITY;
        case 0:
          return USERCREDSIDENTITY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public UserCredsIdentityCase getUserCredsIdentityCase() {
    return UserCredsIdentityCase.forNumber(userCredsIdentityCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Identifier. The resource name of the UserCreds.
   * Format:
   * `projects/{project}/databases/{database}/userCreds/{user_creds}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Identifier. The resource name of the UserCreds.
   * Format:
   * `projects/{project}/databases/{database}/userCreds/{user_creds}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. The time the user creds were created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The time the user creds were created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The time the user creds were created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. The time the user creds were last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The time the user creds were last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The time the user creds were last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. Whether the user creds are enabled or disabled. Defaults to
   * ENABLED on creation.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.UserCreds.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Whether the user creds are enabled or disabled. Defaults to
   * ENABLED on creation.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.UserCreds.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.UserCreds.State getState() {
    com.google.firestore.admin.v1.UserCreds.State result =
        com.google.firestore.admin.v1.UserCreds.State.forNumber(state_);
    return result == null ? com.google.firestore.admin.v1.UserCreds.State.UNRECOGNIZED : result;
  }

  public static final int SECURE_PASSWORD_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object securePassword_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The plaintext server-generated password for the user creds.
   * Only populated in responses for CreateUserCreds and ResetUserPassword.
   * </pre>
   *
   * <code>string secure_password = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The securePassword.
   */
  @java.lang.Override
  public java.lang.String getSecurePassword() {
    java.lang.Object ref = securePassword_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      securePassword_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The plaintext server-generated password for the user creds.
   * Only populated in responses for CreateUserCreds and ResetUserPassword.
   * </pre>
   *
   * <code>string secure_password = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for securePassword.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSecurePasswordBytes() {
    java.lang.Object ref = securePassword_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      securePassword_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_IDENTITY_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Resource Identity descriptor.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.UserCreds.ResourceIdentity resource_identity = 6;</code>
   *
   * @return Whether the resourceIdentity field is set.
   */
  @java.lang.Override
  public boolean hasResourceIdentity() {
    return userCredsIdentityCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Resource Identity descriptor.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.UserCreds.ResourceIdentity resource_identity = 6;</code>
   *
   * @return The resourceIdentity.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.UserCreds.ResourceIdentity getResourceIdentity() {
    if (userCredsIdentityCase_ == 6) {
      return (com.google.firestore.admin.v1.UserCreds.ResourceIdentity) userCredsIdentity_;
    }
    return com.google.firestore.admin.v1.UserCreds.ResourceIdentity.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Resource Identity descriptor.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.UserCreds.ResourceIdentity resource_identity = 6;</code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.UserCreds.ResourceIdentityOrBuilder
      getResourceIdentityOrBuilder() {
    if (userCredsIdentityCase_ == 6) {
      return (com.google.firestore.admin.v1.UserCreds.ResourceIdentity) userCredsIdentity_;
    }
    return com.google.firestore.admin.v1.UserCreds.ResourceIdentity.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getUpdateTime());
    }
    if (state_ != com.google.firestore.admin.v1.UserCreds.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(securePassword_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, securePassword_);
    }
    if (userCredsIdentityCase_ == 6) {
      output.writeMessage(
          6, (com.google.firestore.admin.v1.UserCreds.ResourceIdentity) userCredsIdentity_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    if (state_ != com.google.firestore.admin.v1.UserCreds.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(securePassword_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, securePassword_);
    }
    if (userCredsIdentityCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.firestore.admin.v1.UserCreds.ResourceIdentity) userCredsIdentity_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.admin.v1.UserCreds)) {
      return super.equals(obj);
    }
    com.google.firestore.admin.v1.UserCreds other = (com.google.firestore.admin.v1.UserCreds) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getSecurePassword().equals(other.getSecurePassword())) return false;
    if (!getUserCredsIdentityCase().equals(other.getUserCredsIdentityCase())) return false;
    switch (userCredsIdentityCase_) {
      case 6:
        if (!getResourceIdentity().equals(other.getResourceIdentity())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + SECURE_PASSWORD_FIELD_NUMBER;
    hash = (53 * hash) + getSecurePassword().hashCode();
    switch (userCredsIdentityCase_) {
      case 6:
        hash = (37 * hash) + RESOURCE_IDENTITY_FIELD_NUMBER;
        hash = (53 * hash) + getResourceIdentity().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.admin.v1.UserCreds parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.UserCreds parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.UserCreds parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.UserCreds parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.UserCreds parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.UserCreds parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.UserCreds parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.UserCreds parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.UserCreds parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.UserCreds parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.UserCreds parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.UserCreds parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.admin.v1.UserCreds prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A Cloud Firestore User Creds.
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.UserCreds}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.UserCreds)
      com.google.firestore.admin.v1.UserCredsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.UserCredsProto
          .internal_static_google_firestore_admin_v1_UserCreds_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.UserCredsProto
          .internal_static_google_firestore_admin_v1_UserCreds_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.UserCreds.class,
              com.google.firestore.admin.v1.UserCreds.Builder.class);
    }

    // Construct using com.google.firestore.admin.v1.UserCreds.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      state_ = 0;
      securePassword_ = "";
      if (resourceIdentityBuilder_ != null) {
        resourceIdentityBuilder_.clear();
      }
      userCredsIdentityCase_ = 0;
      userCredsIdentity_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.admin.v1.UserCredsProto
          .internal_static_google_firestore_admin_v1_UserCreds_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.UserCreds getDefaultInstanceForType() {
      return com.google.firestore.admin.v1.UserCreds.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.UserCreds build() {
      com.google.firestore.admin.v1.UserCreds result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.UserCreds buildPartial() {
      com.google.firestore.admin.v1.UserCreds result =
          new com.google.firestore.admin.v1.UserCreds(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.admin.v1.UserCreds result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.securePassword_ = securePassword_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.firestore.admin.v1.UserCreds result) {
      result.userCredsIdentityCase_ = userCredsIdentityCase_;
      result.userCredsIdentity_ = this.userCredsIdentity_;
      if (userCredsIdentityCase_ == 6 && resourceIdentityBuilder_ != null) {
        result.userCredsIdentity_ = resourceIdentityBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.admin.v1.UserCreds) {
        return mergeFrom((com.google.firestore.admin.v1.UserCreds) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.admin.v1.UserCreds other) {
      if (other == com.google.firestore.admin.v1.UserCreds.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getSecurePassword().isEmpty()) {
        securePassword_ = other.securePassword_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      switch (other.getUserCredsIdentityCase()) {
        case RESOURCE_IDENTITY:
          {
            mergeResourceIdentity(other.getResourceIdentity());
            break;
          }
        case USERCREDSIDENTITY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                securePassword_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getResourceIdentityFieldBuilder().getBuilder(), extensionRegistry);
                userCredsIdentityCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int userCredsIdentityCase_ = 0;
    private java.lang.Object userCredsIdentity_;

    public UserCredsIdentityCase getUserCredsIdentityCase() {
      return UserCredsIdentityCase.forNumber(userCredsIdentityCase_);
    }

    public Builder clearUserCredsIdentity() {
      userCredsIdentityCase_ = 0;
      userCredsIdentity_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the UserCreds.
     * Format:
     * `projects/{project}/databases/{database}/userCreds/{user_creds}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the UserCreds.
     * Format:
     * `projects/{project}/databases/{database}/userCreds/{user_creds}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the UserCreds.
     * Format:
     * `projects/{project}/databases/{database}/userCreds/{user_creds}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the UserCreds.
     * Format:
     * `projects/{project}/databases/{database}/userCreds/{user_creds}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the UserCreds.
     * Format:
     * `projects/{project}/databases/{database}/userCreds/{user_creds}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The time the user creds were created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The time the user creds were created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time the user creds were created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time the user creds were created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time the user creds were created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time the user creds were created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time the user creds were created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The time the user creds were created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time the user creds were created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The time the user creds were last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The time the user creds were last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time the user creds were last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time the user creds were last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time the user creds were last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time the user creds were last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time the user creds were last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The time the user creds were last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time the user creds were last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. Whether the user creds are enabled or disabled. Defaults to
     * ENABLED on creation.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.UserCreds.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Whether the user creds are enabled or disabled. Defaults to
     * ENABLED on creation.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.UserCreds.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Whether the user creds are enabled or disabled. Defaults to
     * ENABLED on creation.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.UserCreds.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.UserCreds.State getState() {
      com.google.firestore.admin.v1.UserCreds.State result =
          com.google.firestore.admin.v1.UserCreds.State.forNumber(state_);
      return result == null ? com.google.firestore.admin.v1.UserCreds.State.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. Whether the user creds are enabled or disabled. Defaults to
     * ENABLED on creation.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.UserCreds.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.firestore.admin.v1.UserCreds.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      state_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Whether the user creds are enabled or disabled. Defaults to
     * ENABLED on creation.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.UserCreds.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000008);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object securePassword_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The plaintext server-generated password for the user creds.
     * Only populated in responses for CreateUserCreds and ResetUserPassword.
     * </pre>
     *
     * <code>string secure_password = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The securePassword.
     */
    public java.lang.String getSecurePassword() {
      java.lang.Object ref = securePassword_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        securePassword_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The plaintext server-generated password for the user creds.
     * Only populated in responses for CreateUserCreds and ResetUserPassword.
     * </pre>
     *
     * <code>string secure_password = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for securePassword.
     */
    public com.google.protobuf.ByteString getSecurePasswordBytes() {
      java.lang.Object ref = securePassword_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        securePassword_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The plaintext server-generated password for the user creds.
     * Only populated in responses for CreateUserCreds and ResetUserPassword.
     * </pre>
     *
     * <code>string secure_password = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The securePassword to set.
     * @return This builder for chaining.
     */
    public Builder setSecurePassword(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      securePassword_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The plaintext server-generated password for the user creds.
     * Only populated in responses for CreateUserCreds and ResetUserPassword.
     * </pre>
     *
     * <code>string secure_password = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSecurePassword() {
      securePassword_ = getDefaultInstance().getSecurePassword();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The plaintext server-generated password for the user creds.
     * Only populated in responses for CreateUserCreds and ResetUserPassword.
     * </pre>
     *
     * <code>string secure_password = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for securePassword to set.
     * @return This builder for chaining.
     */
    public Builder setSecurePasswordBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      securePassword_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.UserCreds.ResourceIdentity,
            com.google.firestore.admin.v1.UserCreds.ResourceIdentity.Builder,
            com.google.firestore.admin.v1.UserCreds.ResourceIdentityOrBuilder>
        resourceIdentityBuilder_;

    /**
     *
     *
     * <pre>
     * Resource Identity descriptor.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.UserCreds.ResourceIdentity resource_identity = 6;</code>
     *
     * @return Whether the resourceIdentity field is set.
     */
    @java.lang.Override
    public boolean hasResourceIdentity() {
      return userCredsIdentityCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Resource Identity descriptor.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.UserCreds.ResourceIdentity resource_identity = 6;</code>
     *
     * @return The resourceIdentity.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.UserCreds.ResourceIdentity getResourceIdentity() {
      if (resourceIdentityBuilder_ == null) {
        if (userCredsIdentityCase_ == 6) {
          return (com.google.firestore.admin.v1.UserCreds.ResourceIdentity) userCredsIdentity_;
        }
        return com.google.firestore.admin.v1.UserCreds.ResourceIdentity.getDefaultInstance();
      } else {
        if (userCredsIdentityCase_ == 6) {
          return resourceIdentityBuilder_.getMessage();
        }
        return com.google.firestore.admin.v1.UserCreds.ResourceIdentity.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Resource Identity descriptor.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.UserCreds.ResourceIdentity resource_identity = 6;</code>
     */
    public Builder setResourceIdentity(
        com.google.firestore.admin.v1.UserCreds.ResourceIdentity value) {
      if (resourceIdentityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        userCredsIdentity_ = value;
        onChanged();
      } else {
        resourceIdentityBuilder_.setMessage(value);
      }
      userCredsIdentityCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource Identity descriptor.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.UserCreds.ResourceIdentity resource_identity = 6;</code>
     */
    public Builder setResourceIdentity(
        com.google.firestore.admin.v1.UserCreds.ResourceIdentity.Builder builderForValue) {
      if (resourceIdentityBuilder_ == null) {
        userCredsIdentity_ = builderForValue.build();
        onChanged();
      } else {
        resourceIdentityBuilder_.setMessage(builderForValue.build());
      }
      userCredsIdentityCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource Identity descriptor.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.UserCreds.ResourceIdentity resource_identity = 6;</code>
     */
    public Builder mergeResourceIdentity(
        com.google.firestore.admin.v1.UserCreds.ResourceIdentity value) {
      if (resourceIdentityBuilder_ == null) {
        if (userCredsIdentityCase_ == 6
            && userCredsIdentity_
                != com.google.firestore.admin.v1.UserCreds.ResourceIdentity.getDefaultInstance()) {
          userCredsIdentity_ =
              com.google.firestore.admin.v1.UserCreds.ResourceIdentity.newBuilder(
                      (com.google.firestore.admin.v1.UserCreds.ResourceIdentity) userCredsIdentity_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          userCredsIdentity_ = value;
        }
        onChanged();
      } else {
        if (userCredsIdentityCase_ == 6) {
          resourceIdentityBuilder_.mergeFrom(value);
        } else {
          resourceIdentityBuilder_.setMessage(value);
        }
      }
      userCredsIdentityCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource Identity descriptor.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.UserCreds.ResourceIdentity resource_identity = 6;</code>
     */
    public Builder clearResourceIdentity() {
      if (resourceIdentityBuilder_ == null) {
        if (userCredsIdentityCase_ == 6) {
          userCredsIdentityCase_ = 0;
          userCredsIdentity_ = null;
          onChanged();
        }
      } else {
        if (userCredsIdentityCase_ == 6) {
          userCredsIdentityCase_ = 0;
          userCredsIdentity_ = null;
        }
        resourceIdentityBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource Identity descriptor.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.UserCreds.ResourceIdentity resource_identity = 6;</code>
     */
    public com.google.firestore.admin.v1.UserCreds.ResourceIdentity.Builder
        getResourceIdentityBuilder() {
      return getResourceIdentityFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Resource Identity descriptor.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.UserCreds.ResourceIdentity resource_identity = 6;</code>
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.UserCreds.ResourceIdentityOrBuilder
        getResourceIdentityOrBuilder() {
      if ((userCredsIdentityCase_ == 6) && (resourceIdentityBuilder_ != null)) {
        return resourceIdentityBuilder_.getMessageOrBuilder();
      } else {
        if (userCredsIdentityCase_ == 6) {
          return (com.google.firestore.admin.v1.UserCreds.ResourceIdentity) userCredsIdentity_;
        }
        return com.google.firestore.admin.v1.UserCreds.ResourceIdentity.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Resource Identity descriptor.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.UserCreds.ResourceIdentity resource_identity = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.UserCreds.ResourceIdentity,
            com.google.firestore.admin.v1.UserCreds.ResourceIdentity.Builder,
            com.google.firestore.admin.v1.UserCreds.ResourceIdentityOrBuilder>
        getResourceIdentityFieldBuilder() {
      if (resourceIdentityBuilder_ == null) {
        if (!(userCredsIdentityCase_ == 6)) {
          userCredsIdentity_ =
              com.google.firestore.admin.v1.UserCreds.ResourceIdentity.getDefaultInstance();
        }
        resourceIdentityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.admin.v1.UserCreds.ResourceIdentity,
                com.google.firestore.admin.v1.UserCreds.ResourceIdentity.Builder,
                com.google.firestore.admin.v1.UserCreds.ResourceIdentityOrBuilder>(
                (com.google.firestore.admin.v1.UserCreds.ResourceIdentity) userCredsIdentity_,
                getParentForChildren(),
                isClean());
        userCredsIdentity_ = null;
      }
      userCredsIdentityCase_ = 6;
      onChanged();
      return resourceIdentityBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.UserCreds)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.UserCreds)
  private static final com.google.firestore.admin.v1.UserCreds DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.admin.v1.UserCreds();
  }

  public static com.google.firestore.admin.v1.UserCreds getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UserCreds> PARSER =
      new com.google.protobuf.AbstractParser<UserCreds>() {
        @java.lang.Override
        public UserCreds parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UserCreds> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UserCreds> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.admin.v1.UserCreds getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
