/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DocumentName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String knowledgeBase;
    private final String document;

    public String getProject() {
        return this.project;
    }

    public String getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public String getDocument() {
        return this.document;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DocumentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.knowledgeBase = (String)Preconditions.checkNotNull((Object)builder.getKnowledgeBase());
        this.document = (String)Preconditions.checkNotNull((Object)builder.getDocument());
    }

    public static DocumentName of(String project, String knowledgeBase, String document) {
        return DocumentName.newBuilder().setProject(project).setKnowledgeBase(knowledgeBase).setDocument(document).build();
    }

    public static String format(String project, String knowledgeBase, String document) {
        return DocumentName.newBuilder().setProject(project).setKnowledgeBase(knowledgeBase).setDocument(document).build().toString();
    }

    public static DocumentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "DocumentName.parse: formattedString not in valid format");
        return DocumentName.of((String)matchMap.get("project"), (String)matchMap.get("knowledge_base"), (String)matchMap.get("document"));
    }

    public static List<DocumentName> parseList(List<String> formattedStrings) {
        ArrayList<DocumentName> list = new ArrayList<DocumentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DocumentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DocumentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DocumentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DocumentName documentName = this;
            synchronized (documentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"knowledgeBase", (Object)this.knowledgeBase);
                    fieldMapBuilder.put((Object)"document", (Object)this.document);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "knowledge_base", this.knowledgeBase, "document", this.document});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DocumentName) {
            DocumentName that = (DocumentName)o;
            return this.project.equals(that.project) && this.knowledgeBase.equals(that.knowledgeBase) && this.document.equals(that.document);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.knowledgeBase.hashCode();
        h *= 1000003;
        return h ^= this.document.hashCode();
    }

    public static class Builder {
        private String project;
        private String knowledgeBase;
        private String document;

        public String getProject() {
            return this.project;
        }

        public String getKnowledgeBase() {
            return this.knowledgeBase;
        }

        public String getDocument() {
            return this.document;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setKnowledgeBase(String knowledgeBase) {
            this.knowledgeBase = knowledgeBase;
            return this;
        }

        public Builder setDocument(String document) {
            this.document = document;
            return this;
        }

        private Builder() {
        }

        private Builder(DocumentName documentName) {
            this.project = documentName.project;
            this.knowledgeBase = documentName.knowledgeBase;
            this.document = documentName.document;
        }

        public DocumentName build() {
            return new DocumentName(this);
        }
    }
}

