/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KnowledgeBaseName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/knowledgeBases/{knowledge_base}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String knowledgeBase;

    public String getProject() {
        return this.project;
    }

    public String getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private KnowledgeBaseName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.knowledgeBase = (String)Preconditions.checkNotNull((Object)builder.getKnowledgeBase());
    }

    public static KnowledgeBaseName of(String project, String knowledgeBase) {
        return KnowledgeBaseName.newBuilder().setProject(project).setKnowledgeBase(knowledgeBase).build();
    }

    public static String format(String project, String knowledgeBase) {
        return KnowledgeBaseName.newBuilder().setProject(project).setKnowledgeBase(knowledgeBase).build().toString();
    }

    public static KnowledgeBaseName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "KnowledgeBaseName.parse: formattedString not in valid format");
        return KnowledgeBaseName.of((String)matchMap.get("project"), (String)matchMap.get("knowledge_base"));
    }

    public static List<KnowledgeBaseName> parseList(List<String> formattedStrings) {
        ArrayList<KnowledgeBaseName> list = new ArrayList<KnowledgeBaseName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KnowledgeBaseName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KnowledgeBaseName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KnowledgeBaseName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KnowledgeBaseName knowledgeBaseName = this;
            synchronized (knowledgeBaseName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"knowledgeBase", (Object)this.knowledgeBase);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "knowledge_base", this.knowledgeBase});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KnowledgeBaseName) {
            KnowledgeBaseName that = (KnowledgeBaseName)o;
            return this.project.equals(that.project) && this.knowledgeBase.equals(that.knowledgeBase);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.knowledgeBase.hashCode();
    }

    public static class Builder {
        private String project;
        private String knowledgeBase;

        public String getProject() {
            return this.project;
        }

        public String getKnowledgeBase() {
            return this.knowledgeBase;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setKnowledgeBase(String knowledgeBase) {
            this.knowledgeBase = knowledgeBase;
            return this;
        }

        private Builder() {
        }

        private Builder(KnowledgeBaseName knowledgeBaseName) {
            this.project = knowledgeBaseName.project;
            this.knowledgeBase = knowledgeBaseName.knowledgeBase;
        }

        public KnowledgeBaseName build() {
            return new KnowledgeBaseName(this);
        }
    }
}

