/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/admin/v1/index.proto

package com.google.datastore.admin.v1;

/**
 *
 *
 * <pre>
 * Datastore composite index definition.
 * </pre>
 *
 * Protobuf type {@code google.datastore.admin.v1.Index}
 */
public final class Index extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.admin.v1.Index)
    IndexOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Index.newBuilder() to construct.
  private Index(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Index() {
    projectId_ = "";
    indexId_ = "";
    kind_ = "";
    ancestor_ = 0;
    properties_ = java.util.Collections.emptyList();
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Index();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.admin.v1.IndexProto
        .internal_static_google_datastore_admin_v1_Index_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.admin.v1.IndexProto
        .internal_static_google_datastore_admin_v1_Index_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.admin.v1.Index.class,
            com.google.datastore.admin.v1.Index.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * For an ordered index, specifies whether each of the entity's ancestors
   * will be included.
   * </pre>
   *
   * Protobuf enum {@code google.datastore.admin.v1.Index.AncestorMode}
   */
  public enum AncestorMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The ancestor mode is unspecified.
     * </pre>
     *
     * <code>ANCESTOR_MODE_UNSPECIFIED = 0;</code>
     */
    ANCESTOR_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Do not include the entity's ancestors in the index.
     * </pre>
     *
     * <code>NONE = 1;</code>
     */
    NONE(1),
    /**
     *
     *
     * <pre>
     * Include all the entity's ancestors in the index.
     * </pre>
     *
     * <code>ALL_ANCESTORS = 2;</code>
     */
    ALL_ANCESTORS(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The ancestor mode is unspecified.
     * </pre>
     *
     * <code>ANCESTOR_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int ANCESTOR_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Do not include the entity's ancestors in the index.
     * </pre>
     *
     * <code>NONE = 1;</code>
     */
    public static final int NONE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Include all the entity's ancestors in the index.
     * </pre>
     *
     * <code>ALL_ANCESTORS = 2;</code>
     */
    public static final int ALL_ANCESTORS_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AncestorMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AncestorMode forNumber(int value) {
      switch (value) {
        case 0:
          return ANCESTOR_MODE_UNSPECIFIED;
        case 1:
          return NONE;
        case 2:
          return ALL_ANCESTORS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AncestorMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AncestorMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<AncestorMode>() {
          public AncestorMode findValueByNumber(int number) {
            return AncestorMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.datastore.admin.v1.Index.getDescriptor().getEnumTypes().get(0);
    }

    private static final AncestorMode[] VALUES = values();

    public static AncestorMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AncestorMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.datastore.admin.v1.Index.AncestorMode)
  }

  /**
   *
   *
   * <pre>
   * The direction determines how a property is indexed.
   * </pre>
   *
   * Protobuf enum {@code google.datastore.admin.v1.Index.Direction}
   */
  public enum Direction implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The direction is unspecified.
     * </pre>
     *
     * <code>DIRECTION_UNSPECIFIED = 0;</code>
     */
    DIRECTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The property's values are indexed so as to support sequencing in
     * ascending order and also query by &lt;, &gt;, &lt;=, &gt;=, and =.
     * </pre>
     *
     * <code>ASCENDING = 1;</code>
     */
    ASCENDING(1),
    /**
     *
     *
     * <pre>
     * The property's values are indexed so as to support sequencing in
     * descending order and also query by &lt;, &gt;, &lt;=, &gt;=, and =.
     * </pre>
     *
     * <code>DESCENDING = 2;</code>
     */
    DESCENDING(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The direction is unspecified.
     * </pre>
     *
     * <code>DIRECTION_UNSPECIFIED = 0;</code>
     */
    public static final int DIRECTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The property's values are indexed so as to support sequencing in
     * ascending order and also query by &lt;, &gt;, &lt;=, &gt;=, and =.
     * </pre>
     *
     * <code>ASCENDING = 1;</code>
     */
    public static final int ASCENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The property's values are indexed so as to support sequencing in
     * descending order and also query by &lt;, &gt;, &lt;=, &gt;=, and =.
     * </pre>
     *
     * <code>DESCENDING = 2;</code>
     */
    public static final int DESCENDING_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Direction valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Direction forNumber(int value) {
      switch (value) {
        case 0:
          return DIRECTION_UNSPECIFIED;
        case 1:
          return ASCENDING;
        case 2:
          return DESCENDING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Direction> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Direction> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Direction>() {
          public Direction findValueByNumber(int number) {
            return Direction.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.datastore.admin.v1.Index.getDescriptor().getEnumTypes().get(1);
    }

    private static final Direction[] VALUES = values();

    public static Direction valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Direction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.datastore.admin.v1.Index.Direction)
  }

  /**
   *
   *
   * <pre>
   * The possible set of states of an index.
   * </pre>
   *
   * Protobuf enum {@code google.datastore.admin.v1.Index.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The state is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The index is being created, and cannot be used by queries.
     * There is an active long-running operation for the index.
     * The index is updated when writing an entity.
     * Some index data may exist.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The index is ready to be used.
     * The index is updated when writing an entity.
     * The index is fully populated from all stored entities it applies to.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    READY(2),
    /**
     *
     *
     * <pre>
     * The index is being deleted, and cannot be used by queries.
     * There is an active long-running operation for the index.
     * The index is not updated when writing an entity.
     * Some index data may exist.
     * </pre>
     *
     * <code>DELETING = 3;</code>
     */
    DELETING(3),
    /**
     *
     *
     * <pre>
     * The index was being created or deleted, but something went wrong.
     * The index cannot by used by queries.
     * There is no active long-running operation for the index,
     * and the most recently finished long-running operation failed.
     * The index is not updated when writing an entity.
     * Some index data may exist.
     * </pre>
     *
     * <code>ERROR = 4;</code>
     */
    ERROR(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The state is unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The index is being created, and cannot be used by queries.
     * There is an active long-running operation for the index.
     * The index is updated when writing an entity.
     * Some index data may exist.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The index is ready to be used.
     * The index is updated when writing an entity.
     * The index is fully populated from all stored entities it applies to.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    public static final int READY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The index is being deleted, and cannot be used by queries.
     * There is an active long-running operation for the index.
     * The index is not updated when writing an entity.
     * Some index data may exist.
     * </pre>
     *
     * <code>DELETING = 3;</code>
     */
    public static final int DELETING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The index was being created or deleted, but something went wrong.
     * The index cannot by used by queries.
     * There is no active long-running operation for the index,
     * and the most recently finished long-running operation failed.
     * The index is not updated when writing an entity.
     * Some index data may exist.
     * </pre>
     *
     * <code>ERROR = 4;</code>
     */
    public static final int ERROR_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return READY;
        case 3:
          return DELETING;
        case 4:
          return ERROR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.datastore.admin.v1.Index.getDescriptor().getEnumTypes().get(2);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.datastore.admin.v1.Index.State)
  }

  public interface IndexedPropertyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.datastore.admin.v1.Index.IndexedProperty)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The property name to index.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. The property name to index.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Required. The indexed property's direction.  Must not be DIRECTION_UNSPECIFIED.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.Index.Direction direction = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for direction.
     */
    int getDirectionValue();
    /**
     *
     *
     * <pre>
     * Required. The indexed property's direction.  Must not be DIRECTION_UNSPECIFIED.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.Index.Direction direction = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The direction.
     */
    com.google.datastore.admin.v1.Index.Direction getDirection();
  }
  /**
   *
   *
   * <pre>
   * A property of an index.
   * </pre>
   *
   * Protobuf type {@code google.datastore.admin.v1.Index.IndexedProperty}
   */
  public static final class IndexedProperty extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.datastore.admin.v1.Index.IndexedProperty)
      IndexedPropertyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IndexedProperty.newBuilder() to construct.
    private IndexedProperty(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IndexedProperty() {
      name_ = "";
      direction_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new IndexedProperty();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.admin.v1.IndexProto
          .internal_static_google_datastore_admin_v1_Index_IndexedProperty_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.admin.v1.IndexProto
          .internal_static_google_datastore_admin_v1_Index_IndexedProperty_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.admin.v1.Index.IndexedProperty.class,
              com.google.datastore.admin.v1.Index.IndexedProperty.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The property name to index.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The property name to index.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DIRECTION_FIELD_NUMBER = 2;
    private int direction_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The indexed property's direction.  Must not be DIRECTION_UNSPECIFIED.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.Index.Direction direction = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for direction.
     */
    @java.lang.Override
    public int getDirectionValue() {
      return direction_;
    }
    /**
     *
     *
     * <pre>
     * Required. The indexed property's direction.  Must not be DIRECTION_UNSPECIFIED.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.Index.Direction direction = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The direction.
     */
    @java.lang.Override
    public com.google.datastore.admin.v1.Index.Direction getDirection() {
      com.google.datastore.admin.v1.Index.Direction result =
          com.google.datastore.admin.v1.Index.Direction.forNumber(direction_);
      return result == null ? com.google.datastore.admin.v1.Index.Direction.UNRECOGNIZED : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (direction_
          != com.google.datastore.admin.v1.Index.Direction.DIRECTION_UNSPECIFIED.getNumber()) {
        output.writeEnum(2, direction_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (direction_
          != com.google.datastore.admin.v1.Index.Direction.DIRECTION_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, direction_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.datastore.admin.v1.Index.IndexedProperty)) {
        return super.equals(obj);
      }
      com.google.datastore.admin.v1.Index.IndexedProperty other =
          (com.google.datastore.admin.v1.Index.IndexedProperty) obj;

      if (!getName().equals(other.getName())) return false;
      if (direction_ != other.direction_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + DIRECTION_FIELD_NUMBER;
      hash = (53 * hash) + direction_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.datastore.admin.v1.Index.IndexedProperty parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.admin.v1.Index.IndexedProperty parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.admin.v1.Index.IndexedProperty parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.admin.v1.Index.IndexedProperty parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.admin.v1.Index.IndexedProperty parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.admin.v1.Index.IndexedProperty parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.admin.v1.Index.IndexedProperty parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.datastore.admin.v1.Index.IndexedProperty parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.datastore.admin.v1.Index.IndexedProperty parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.datastore.admin.v1.Index.IndexedProperty parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.datastore.admin.v1.Index.IndexedProperty parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.datastore.admin.v1.Index.IndexedProperty parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.datastore.admin.v1.Index.IndexedProperty prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A property of an index.
     * </pre>
     *
     * Protobuf type {@code google.datastore.admin.v1.Index.IndexedProperty}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.datastore.admin.v1.Index.IndexedProperty)
        com.google.datastore.admin.v1.Index.IndexedPropertyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.datastore.admin.v1.IndexProto
            .internal_static_google_datastore_admin_v1_Index_IndexedProperty_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.datastore.admin.v1.IndexProto
            .internal_static_google_datastore_admin_v1_Index_IndexedProperty_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.datastore.admin.v1.Index.IndexedProperty.class,
                com.google.datastore.admin.v1.Index.IndexedProperty.Builder.class);
      }

      // Construct using com.google.datastore.admin.v1.Index.IndexedProperty.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        direction_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.datastore.admin.v1.IndexProto
            .internal_static_google_datastore_admin_v1_Index_IndexedProperty_descriptor;
      }

      @java.lang.Override
      public com.google.datastore.admin.v1.Index.IndexedProperty getDefaultInstanceForType() {
        return com.google.datastore.admin.v1.Index.IndexedProperty.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.datastore.admin.v1.Index.IndexedProperty build() {
        com.google.datastore.admin.v1.Index.IndexedProperty result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.datastore.admin.v1.Index.IndexedProperty buildPartial() {
        com.google.datastore.admin.v1.Index.IndexedProperty result =
            new com.google.datastore.admin.v1.Index.IndexedProperty(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.datastore.admin.v1.Index.IndexedProperty result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.direction_ = direction_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.datastore.admin.v1.Index.IndexedProperty) {
          return mergeFrom((com.google.datastore.admin.v1.Index.IndexedProperty) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.datastore.admin.v1.Index.IndexedProperty other) {
        if (other == com.google.datastore.admin.v1.Index.IndexedProperty.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.direction_ != 0) {
          setDirectionValue(other.getDirectionValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  direction_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. The property name to index.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The property name to index.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The property name to index.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The property name to index.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The property name to index.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int direction_ = 0;
      /**
       *
       *
       * <pre>
       * Required. The indexed property's direction.  Must not be DIRECTION_UNSPECIFIED.
       * </pre>
       *
       * <code>
       * .google.datastore.admin.v1.Index.Direction direction = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for direction.
       */
      @java.lang.Override
      public int getDirectionValue() {
        return direction_;
      }
      /**
       *
       *
       * <pre>
       * Required. The indexed property's direction.  Must not be DIRECTION_UNSPECIFIED.
       * </pre>
       *
       * <code>
       * .google.datastore.admin.v1.Index.Direction direction = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for direction to set.
       * @return This builder for chaining.
       */
      public Builder setDirectionValue(int value) {
        direction_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The indexed property's direction.  Must not be DIRECTION_UNSPECIFIED.
       * </pre>
       *
       * <code>
       * .google.datastore.admin.v1.Index.Direction direction = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The direction.
       */
      @java.lang.Override
      public com.google.datastore.admin.v1.Index.Direction getDirection() {
        com.google.datastore.admin.v1.Index.Direction result =
            com.google.datastore.admin.v1.Index.Direction.forNumber(direction_);
        return result == null ? com.google.datastore.admin.v1.Index.Direction.UNRECOGNIZED : result;
      }
      /**
       *
       *
       * <pre>
       * Required. The indexed property's direction.  Must not be DIRECTION_UNSPECIFIED.
       * </pre>
       *
       * <code>
       * .google.datastore.admin.v1.Index.Direction direction = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The direction to set.
       * @return This builder for chaining.
       */
      public Builder setDirection(com.google.datastore.admin.v1.Index.Direction value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        direction_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The indexed property's direction.  Must not be DIRECTION_UNSPECIFIED.
       * </pre>
       *
       * <code>
       * .google.datastore.admin.v1.Index.Direction direction = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDirection() {
        bitField0_ = (bitField0_ & ~0x00000002);
        direction_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.datastore.admin.v1.Index.IndexedProperty)
    }

    // @@protoc_insertion_point(class_scope:google.datastore.admin.v1.Index.IndexedProperty)
    private static final com.google.datastore.admin.v1.Index.IndexedProperty DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.datastore.admin.v1.Index.IndexedProperty();
    }

    public static com.google.datastore.admin.v1.Index.IndexedProperty getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IndexedProperty> PARSER =
        new com.google.protobuf.AbstractParser<IndexedProperty>() {
          @java.lang.Override
          public IndexedProperty parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<IndexedProperty> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IndexedProperty> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.datastore.admin.v1.Index.IndexedProperty getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Project ID.
   * </pre>
   *
   * <code>string project_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Project ID.
   * </pre>
   *
   * <code>string project_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INDEX_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object indexId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource ID of the index.
   * </pre>
   *
   * <code>string index_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The indexId.
   */
  @java.lang.Override
  public java.lang.String getIndexId() {
    java.lang.Object ref = indexId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      indexId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource ID of the index.
   * </pre>
   *
   * <code>string index_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for indexId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIndexIdBytes() {
    java.lang.Object ref = indexId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      indexId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KIND_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * Required. The entity kind to which this index applies.
   * </pre>
   *
   * <code>string kind = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The entity kind to which this index applies.
   * </pre>
   *
   * <code>string kind = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANCESTOR_FIELD_NUMBER = 5;
  private int ancestor_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The index's ancestor mode.  Must not be ANCESTOR_MODE_UNSPECIFIED.
   * </pre>
   *
   * <code>
   * .google.datastore.admin.v1.Index.AncestorMode ancestor = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for ancestor.
   */
  @java.lang.Override
  public int getAncestorValue() {
    return ancestor_;
  }
  /**
   *
   *
   * <pre>
   * Required. The index's ancestor mode.  Must not be ANCESTOR_MODE_UNSPECIFIED.
   * </pre>
   *
   * <code>
   * .google.datastore.admin.v1.Index.AncestorMode ancestor = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The ancestor.
   */
  @java.lang.Override
  public com.google.datastore.admin.v1.Index.AncestorMode getAncestor() {
    com.google.datastore.admin.v1.Index.AncestorMode result =
        com.google.datastore.admin.v1.Index.AncestorMode.forNumber(ancestor_);
    return result == null ? com.google.datastore.admin.v1.Index.AncestorMode.UNRECOGNIZED : result;
  }

  public static final int PROPERTIES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.datastore.admin.v1.Index.IndexedProperty> properties_;
  /**
   *
   *
   * <pre>
   * Required. An ordered sequence of property names and their index attributes.
   * </pre>
   *
   * <code>
   * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.datastore.admin.v1.Index.IndexedProperty> getPropertiesList() {
    return properties_;
  }
  /**
   *
   *
   * <pre>
   * Required. An ordered sequence of property names and their index attributes.
   * </pre>
   *
   * <code>
   * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.datastore.admin.v1.Index.IndexedPropertyOrBuilder>
      getPropertiesOrBuilderList() {
    return properties_;
  }
  /**
   *
   *
   * <pre>
   * Required. An ordered sequence of property names and their index attributes.
   * </pre>
   *
   * <code>
   * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getPropertiesCount() {
    return properties_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. An ordered sequence of property names and their index attributes.
   * </pre>
   *
   * <code>
   * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.datastore.admin.v1.Index.IndexedProperty getProperties(int index) {
    return properties_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. An ordered sequence of property names and their index attributes.
   * </pre>
   *
   * <code>
   * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.datastore.admin.v1.Index.IndexedPropertyOrBuilder getPropertiesOrBuilder(
      int index) {
    return properties_.get(index);
  }

  public static final int STATE_FIELD_NUMBER = 7;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of the index.
   * </pre>
   *
   * <code>
   * .google.datastore.admin.v1.Index.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of the index.
   * </pre>
   *
   * <code>
   * .google.datastore.admin.v1.Index.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.datastore.admin.v1.Index.State getState() {
    com.google.datastore.admin.v1.Index.State result =
        com.google.datastore.admin.v1.Index.State.forNumber(state_);
    return result == null ? com.google.datastore.admin.v1.Index.State.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(indexId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, indexId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kind_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, kind_);
    }
    if (ancestor_
        != com.google.datastore.admin.v1.Index.AncestorMode.ANCESTOR_MODE_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, ancestor_);
    }
    for (int i = 0; i < properties_.size(); i++) {
      output.writeMessage(6, properties_.get(i));
    }
    if (state_ != com.google.datastore.admin.v1.Index.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(7, state_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(indexId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, indexId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kind_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, kind_);
    }
    if (ancestor_
        != com.google.datastore.admin.v1.Index.AncestorMode.ANCESTOR_MODE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, ancestor_);
    }
    for (int i = 0; i < properties_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, properties_.get(i));
    }
    if (state_ != com.google.datastore.admin.v1.Index.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, state_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.admin.v1.Index)) {
      return super.equals(obj);
    }
    com.google.datastore.admin.v1.Index other = (com.google.datastore.admin.v1.Index) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getIndexId().equals(other.getIndexId())) return false;
    if (!getKind().equals(other.getKind())) return false;
    if (ancestor_ != other.ancestor_) return false;
    if (!getPropertiesList().equals(other.getPropertiesList())) return false;
    if (state_ != other.state_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + INDEX_ID_FIELD_NUMBER;
    hash = (53 * hash) + getIndexId().hashCode();
    hash = (37 * hash) + KIND_FIELD_NUMBER;
    hash = (53 * hash) + getKind().hashCode();
    hash = (37 * hash) + ANCESTOR_FIELD_NUMBER;
    hash = (53 * hash) + ancestor_;
    if (getPropertiesCount() > 0) {
      hash = (37 * hash) + PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + getPropertiesList().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.admin.v1.Index parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.admin.v1.Index parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.admin.v1.Index parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.admin.v1.Index parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.admin.v1.Index parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.admin.v1.Index parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.admin.v1.Index parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.admin.v1.Index parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.admin.v1.Index parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.admin.v1.Index parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.admin.v1.Index parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.admin.v1.Index parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.admin.v1.Index prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Datastore composite index definition.
   * </pre>
   *
   * Protobuf type {@code google.datastore.admin.v1.Index}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.admin.v1.Index)
      com.google.datastore.admin.v1.IndexOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.admin.v1.IndexProto
          .internal_static_google_datastore_admin_v1_Index_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.admin.v1.IndexProto
          .internal_static_google_datastore_admin_v1_Index_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.admin.v1.Index.class,
              com.google.datastore.admin.v1.Index.Builder.class);
    }

    // Construct using com.google.datastore.admin.v1.Index.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      projectId_ = "";
      indexId_ = "";
      kind_ = "";
      ancestor_ = 0;
      if (propertiesBuilder_ == null) {
        properties_ = java.util.Collections.emptyList();
      } else {
        properties_ = null;
        propertiesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      state_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.admin.v1.IndexProto
          .internal_static_google_datastore_admin_v1_Index_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.admin.v1.Index getDefaultInstanceForType() {
      return com.google.datastore.admin.v1.Index.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.admin.v1.Index build() {
      com.google.datastore.admin.v1.Index result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.admin.v1.Index buildPartial() {
      com.google.datastore.admin.v1.Index result = new com.google.datastore.admin.v1.Index(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.datastore.admin.v1.Index result) {
      if (propertiesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          properties_ = java.util.Collections.unmodifiableList(properties_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.properties_ = properties_;
      } else {
        result.properties_ = propertiesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.datastore.admin.v1.Index result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.indexId_ = indexId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.kind_ = kind_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.ancestor_ = ancestor_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.state_ = state_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.admin.v1.Index) {
        return mergeFrom((com.google.datastore.admin.v1.Index) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.admin.v1.Index other) {
      if (other == com.google.datastore.admin.v1.Index.getDefaultInstance()) return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getIndexId().isEmpty()) {
        indexId_ = other.indexId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getKind().isEmpty()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.ancestor_ != 0) {
        setAncestorValue(other.getAncestorValue());
      }
      if (propertiesBuilder_ == null) {
        if (!other.properties_.isEmpty()) {
          if (properties_.isEmpty()) {
            properties_ = other.properties_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensurePropertiesIsMutable();
            properties_.addAll(other.properties_);
          }
          onChanged();
        }
      } else {
        if (!other.properties_.isEmpty()) {
          if (propertiesBuilder_.isEmpty()) {
            propertiesBuilder_.dispose();
            propertiesBuilder_ = null;
            properties_ = other.properties_;
            bitField0_ = (bitField0_ & ~0x00000010);
            propertiesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPropertiesFieldBuilder()
                    : null;
          } else {
            propertiesBuilder_.addAllMessages(other.properties_);
          }
        }
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                indexId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 40:
              {
                ancestor_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            case 50:
              {
                com.google.datastore.admin.v1.Index.IndexedProperty m =
                    input.readMessage(
                        com.google.datastore.admin.v1.Index.IndexedProperty.parser(),
                        extensionRegistry);
                if (propertiesBuilder_ == null) {
                  ensurePropertiesIsMutable();
                  properties_.add(m);
                } else {
                  propertiesBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 56:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Project ID.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Project ID.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Project ID.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Project ID.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Project ID.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object indexId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource ID of the index.
     * </pre>
     *
     * <code>string index_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The indexId.
     */
    public java.lang.String getIndexId() {
      java.lang.Object ref = indexId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        indexId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource ID of the index.
     * </pre>
     *
     * <code>string index_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for indexId.
     */
    public com.google.protobuf.ByteString getIndexIdBytes() {
      java.lang.Object ref = indexId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        indexId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource ID of the index.
     * </pre>
     *
     * <code>string index_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The indexId to set.
     * @return This builder for chaining.
     */
    public Builder setIndexId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      indexId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource ID of the index.
     * </pre>
     *
     * <code>string index_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndexId() {
      indexId_ = getDefaultInstance().getIndexId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource ID of the index.
     * </pre>
     *
     * <code>string index_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for indexId to set.
     * @return This builder for chaining.
     */
    public Builder setIndexIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      indexId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * Required. The entity kind to which this index applies.
     * </pre>
     *
     * <code>string kind = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The entity kind to which this index applies.
     * </pre>
     *
     * <code>string kind = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The entity kind to which this index applies.
     * </pre>
     *
     * <code>string kind = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The entity kind to which this index applies.
     * </pre>
     *
     * <code>string kind = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The entity kind to which this index applies.
     * </pre>
     *
     * <code>string kind = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int ancestor_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The index's ancestor mode.  Must not be ANCESTOR_MODE_UNSPECIFIED.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.Index.AncestorMode ancestor = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for ancestor.
     */
    @java.lang.Override
    public int getAncestorValue() {
      return ancestor_;
    }
    /**
     *
     *
     * <pre>
     * Required. The index's ancestor mode.  Must not be ANCESTOR_MODE_UNSPECIFIED.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.Index.AncestorMode ancestor = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for ancestor to set.
     * @return This builder for chaining.
     */
    public Builder setAncestorValue(int value) {
      ancestor_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The index's ancestor mode.  Must not be ANCESTOR_MODE_UNSPECIFIED.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.Index.AncestorMode ancestor = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The ancestor.
     */
    @java.lang.Override
    public com.google.datastore.admin.v1.Index.AncestorMode getAncestor() {
      com.google.datastore.admin.v1.Index.AncestorMode result =
          com.google.datastore.admin.v1.Index.AncestorMode.forNumber(ancestor_);
      return result == null
          ? com.google.datastore.admin.v1.Index.AncestorMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The index's ancestor mode.  Must not be ANCESTOR_MODE_UNSPECIFIED.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.Index.AncestorMode ancestor = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The ancestor to set.
     * @return This builder for chaining.
     */
    public Builder setAncestor(com.google.datastore.admin.v1.Index.AncestorMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      ancestor_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The index's ancestor mode.  Must not be ANCESTOR_MODE_UNSPECIFIED.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.Index.AncestorMode ancestor = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAncestor() {
      bitField0_ = (bitField0_ & ~0x00000008);
      ancestor_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.datastore.admin.v1.Index.IndexedProperty> properties_ =
        java.util.Collections.emptyList();

    private void ensurePropertiesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        properties_ =
            new java.util.ArrayList<com.google.datastore.admin.v1.Index.IndexedProperty>(
                properties_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.admin.v1.Index.IndexedProperty,
            com.google.datastore.admin.v1.Index.IndexedProperty.Builder,
            com.google.datastore.admin.v1.Index.IndexedPropertyOrBuilder>
        propertiesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. An ordered sequence of property names and their index attributes.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.datastore.admin.v1.Index.IndexedProperty> getPropertiesList() {
      if (propertiesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(properties_);
      } else {
        return propertiesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. An ordered sequence of property names and their index attributes.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getPropertiesCount() {
      if (propertiesBuilder_ == null) {
        return properties_.size();
      } else {
        return propertiesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. An ordered sequence of property names and their index attributes.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.datastore.admin.v1.Index.IndexedProperty getProperties(int index) {
      if (propertiesBuilder_ == null) {
        return properties_.get(index);
      } else {
        return propertiesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. An ordered sequence of property names and their index attributes.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setProperties(
        int index, com.google.datastore.admin.v1.Index.IndexedProperty value) {
      if (propertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePropertiesIsMutable();
        properties_.set(index, value);
        onChanged();
      } else {
        propertiesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. An ordered sequence of property names and their index attributes.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setProperties(
        int index, com.google.datastore.admin.v1.Index.IndexedProperty.Builder builderForValue) {
      if (propertiesBuilder_ == null) {
        ensurePropertiesIsMutable();
        properties_.set(index, builderForValue.build());
        onChanged();
      } else {
        propertiesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. An ordered sequence of property names and their index attributes.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addProperties(com.google.datastore.admin.v1.Index.IndexedProperty value) {
      if (propertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePropertiesIsMutable();
        properties_.add(value);
        onChanged();
      } else {
        propertiesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. An ordered sequence of property names and their index attributes.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addProperties(
        int index, com.google.datastore.admin.v1.Index.IndexedProperty value) {
      if (propertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePropertiesIsMutable();
        properties_.add(index, value);
        onChanged();
      } else {
        propertiesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. An ordered sequence of property names and their index attributes.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addProperties(
        com.google.datastore.admin.v1.Index.IndexedProperty.Builder builderForValue) {
      if (propertiesBuilder_ == null) {
        ensurePropertiesIsMutable();
        properties_.add(builderForValue.build());
        onChanged();
      } else {
        propertiesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. An ordered sequence of property names and their index attributes.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addProperties(
        int index, com.google.datastore.admin.v1.Index.IndexedProperty.Builder builderForValue) {
      if (propertiesBuilder_ == null) {
        ensurePropertiesIsMutable();
        properties_.add(index, builderForValue.build());
        onChanged();
      } else {
        propertiesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. An ordered sequence of property names and their index attributes.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllProperties(
        java.lang.Iterable<? extends com.google.datastore.admin.v1.Index.IndexedProperty> values) {
      if (propertiesBuilder_ == null) {
        ensurePropertiesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, properties_);
        onChanged();
      } else {
        propertiesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. An ordered sequence of property names and their index attributes.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearProperties() {
      if (propertiesBuilder_ == null) {
        properties_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        propertiesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. An ordered sequence of property names and their index attributes.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeProperties(int index) {
      if (propertiesBuilder_ == null) {
        ensurePropertiesIsMutable();
        properties_.remove(index);
        onChanged();
      } else {
        propertiesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. An ordered sequence of property names and their index attributes.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.datastore.admin.v1.Index.IndexedProperty.Builder getPropertiesBuilder(
        int index) {
      return getPropertiesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. An ordered sequence of property names and their index attributes.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.datastore.admin.v1.Index.IndexedPropertyOrBuilder getPropertiesOrBuilder(
        int index) {
      if (propertiesBuilder_ == null) {
        return properties_.get(index);
      } else {
        return propertiesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. An ordered sequence of property names and their index attributes.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.datastore.admin.v1.Index.IndexedPropertyOrBuilder>
        getPropertiesOrBuilderList() {
      if (propertiesBuilder_ != null) {
        return propertiesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(properties_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. An ordered sequence of property names and their index attributes.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.datastore.admin.v1.Index.IndexedProperty.Builder addPropertiesBuilder() {
      return getPropertiesFieldBuilder()
          .addBuilder(com.google.datastore.admin.v1.Index.IndexedProperty.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. An ordered sequence of property names and their index attributes.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.datastore.admin.v1.Index.IndexedProperty.Builder addPropertiesBuilder(
        int index) {
      return getPropertiesFieldBuilder()
          .addBuilder(
              index, com.google.datastore.admin.v1.Index.IndexedProperty.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. An ordered sequence of property names and their index attributes.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.admin.v1.Index.IndexedProperty properties = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.datastore.admin.v1.Index.IndexedProperty.Builder>
        getPropertiesBuilderList() {
      return getPropertiesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.admin.v1.Index.IndexedProperty,
            com.google.datastore.admin.v1.Index.IndexedProperty.Builder,
            com.google.datastore.admin.v1.Index.IndexedPropertyOrBuilder>
        getPropertiesFieldBuilder() {
      if (propertiesBuilder_ == null) {
        propertiesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.datastore.admin.v1.Index.IndexedProperty,
                com.google.datastore.admin.v1.Index.IndexedProperty.Builder,
                com.google.datastore.admin.v1.Index.IndexedPropertyOrBuilder>(
                properties_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        properties_ = null;
      }
      return propertiesBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of the index.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.Index.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the index.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.Index.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the index.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.Index.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.datastore.admin.v1.Index.State getState() {
      com.google.datastore.admin.v1.Index.State result =
          com.google.datastore.admin.v1.Index.State.forNumber(state_);
      return result == null ? com.google.datastore.admin.v1.Index.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the index.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.Index.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.datastore.admin.v1.Index.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the index.
     * </pre>
     *
     * <code>
     * .google.datastore.admin.v1.Index.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      state_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.admin.v1.Index)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.admin.v1.Index)
  private static final com.google.datastore.admin.v1.Index DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.admin.v1.Index();
  }

  public static com.google.datastore.admin.v1.Index getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Index> PARSER =
      new com.google.protobuf.AbstractParser<Index>() {
        @java.lang.Override
        public Index parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Index> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Index> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.admin.v1.Index getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
