/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/admin/v1/datastore_admin.proto

package com.google.datastore.admin.v1;

/**
 *
 *
 * <pre>
 * The request for
 * [google.datastore.admin.v1.DatastoreAdmin.ExportEntities][google.datastore.admin.v1.DatastoreAdmin.ExportEntities].
 * </pre>
 *
 * Protobuf type {@code google.datastore.admin.v1.ExportEntitiesRequest}
 */
public final class ExportEntitiesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.admin.v1.ExportEntitiesRequest)
    ExportEntitiesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExportEntitiesRequest.newBuilder() to construct.
  private ExportEntitiesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExportEntitiesRequest() {
    projectId_ = "";
    outputUrlPrefix_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExportEntitiesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.admin.v1.DatastoreAdminProto
        .internal_static_google_datastore_admin_v1_ExportEntitiesRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 2:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.admin.v1.DatastoreAdminProto
        .internal_static_google_datastore_admin_v1_ExportEntitiesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.admin.v1.ExportEntitiesRequest.class,
            com.google.datastore.admin.v1.ExportEntitiesRequest.Builder.class);
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Required. Project ID against which to make the request.
   * </pre>
   *
   * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Project ID against which to make the request.
   * </pre>
   *
   * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 2;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.datastore.admin.v1.DatastoreAdminProto
                .internal_static_google_datastore_admin_v1_ExportEntitiesRequest_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Client-assigned labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Client-assigned labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Client-assigned labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Client-assigned labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ENTITY_FILTER_FIELD_NUMBER = 3;
  private com.google.datastore.admin.v1.EntityFilter entityFilter_;
  /**
   *
   *
   * <pre>
   * Description of what data from the project is included in the export.
   * </pre>
   *
   * <code>.google.datastore.admin.v1.EntityFilter entity_filter = 3;</code>
   *
   * @return Whether the entityFilter field is set.
   */
  @java.lang.Override
  public boolean hasEntityFilter() {
    return entityFilter_ != null;
  }
  /**
   *
   *
   * <pre>
   * Description of what data from the project is included in the export.
   * </pre>
   *
   * <code>.google.datastore.admin.v1.EntityFilter entity_filter = 3;</code>
   *
   * @return The entityFilter.
   */
  @java.lang.Override
  public com.google.datastore.admin.v1.EntityFilter getEntityFilter() {
    return entityFilter_ == null
        ? com.google.datastore.admin.v1.EntityFilter.getDefaultInstance()
        : entityFilter_;
  }
  /**
   *
   *
   * <pre>
   * Description of what data from the project is included in the export.
   * </pre>
   *
   * <code>.google.datastore.admin.v1.EntityFilter entity_filter = 3;</code>
   */
  @java.lang.Override
  public com.google.datastore.admin.v1.EntityFilterOrBuilder getEntityFilterOrBuilder() {
    return entityFilter_ == null
        ? com.google.datastore.admin.v1.EntityFilter.getDefaultInstance()
        : entityFilter_;
  }

  public static final int OUTPUT_URL_PREFIX_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object outputUrlPrefix_ = "";
  /**
   *
   *
   * <pre>
   * Required. Location for the export metadata and data files.
   *
   * The full resource URL of the external storage location. Currently, only
   * Google Cloud Storage is supported. So output_url_prefix should be of the
   * form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the
   * name of the Cloud Storage bucket and `NAMESPACE_PATH` is an optional Cloud
   * Storage namespace path (this is not a Cloud Datastore namespace). For more
   * information about Cloud Storage namespace paths, see
   * [Object name
   * considerations](https://cloud.google.com/storage/docs/naming#object-considerations).
   *
   * The resulting files will be nested deeper than the specified URL prefix.
   * The final output URL will be provided in the
   * [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url] field. That
   * value should be used for subsequent ImportEntities operations.
   *
   * By nesting the data files deeper, the same Cloud Storage bucket can be used
   * in multiple ExportEntities operations without conflict.
   * </pre>
   *
   * <code>string output_url_prefix = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The outputUrlPrefix.
   */
  @java.lang.Override
  public java.lang.String getOutputUrlPrefix() {
    java.lang.Object ref = outputUrlPrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      outputUrlPrefix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Location for the export metadata and data files.
   *
   * The full resource URL of the external storage location. Currently, only
   * Google Cloud Storage is supported. So output_url_prefix should be of the
   * form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the
   * name of the Cloud Storage bucket and `NAMESPACE_PATH` is an optional Cloud
   * Storage namespace path (this is not a Cloud Datastore namespace). For more
   * information about Cloud Storage namespace paths, see
   * [Object name
   * considerations](https://cloud.google.com/storage/docs/naming#object-considerations).
   *
   * The resulting files will be nested deeper than the specified URL prefix.
   * The final output URL will be provided in the
   * [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url] field. That
   * value should be used for subsequent ImportEntities operations.
   *
   * By nesting the data files deeper, the same Cloud Storage bucket can be used
   * in multiple ExportEntities operations without conflict.
   * </pre>
   *
   * <code>string output_url_prefix = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for outputUrlPrefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOutputUrlPrefixBytes() {
    java.lang.Object ref = outputUrlPrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      outputUrlPrefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 2);
    if (entityFilter_ != null) {
      output.writeMessage(3, getEntityFilter());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputUrlPrefix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, outputUrlPrefix_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, labels__);
    }
    if (entityFilter_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEntityFilter());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputUrlPrefix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, outputUrlPrefix_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.admin.v1.ExportEntitiesRequest)) {
      return super.equals(obj);
    }
    com.google.datastore.admin.v1.ExportEntitiesRequest other =
        (com.google.datastore.admin.v1.ExportEntitiesRequest) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasEntityFilter() != other.hasEntityFilter()) return false;
    if (hasEntityFilter()) {
      if (!getEntityFilter().equals(other.getEntityFilter())) return false;
    }
    if (!getOutputUrlPrefix().equals(other.getOutputUrlPrefix())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasEntityFilter()) {
      hash = (37 * hash) + ENTITY_FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getEntityFilter().hashCode();
    }
    hash = (37 * hash) + OUTPUT_URL_PREFIX_FIELD_NUMBER;
    hash = (53 * hash) + getOutputUrlPrefix().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.admin.v1.ExportEntitiesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.admin.v1.ExportEntitiesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.admin.v1.ExportEntitiesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.admin.v1.ExportEntitiesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.admin.v1.ExportEntitiesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.admin.v1.ExportEntitiesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.admin.v1.ExportEntitiesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.admin.v1.ExportEntitiesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.admin.v1.ExportEntitiesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.admin.v1.ExportEntitiesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.admin.v1.ExportEntitiesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.admin.v1.ExportEntitiesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.admin.v1.ExportEntitiesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for
   * [google.datastore.admin.v1.DatastoreAdmin.ExportEntities][google.datastore.admin.v1.DatastoreAdmin.ExportEntities].
   * </pre>
   *
   * Protobuf type {@code google.datastore.admin.v1.ExportEntitiesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.admin.v1.ExportEntitiesRequest)
      com.google.datastore.admin.v1.ExportEntitiesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.admin.v1.DatastoreAdminProto
          .internal_static_google_datastore_admin_v1_ExportEntitiesRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 2:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 2:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.admin.v1.DatastoreAdminProto
          .internal_static_google_datastore_admin_v1_ExportEntitiesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.admin.v1.ExportEntitiesRequest.class,
              com.google.datastore.admin.v1.ExportEntitiesRequest.Builder.class);
    }

    // Construct using com.google.datastore.admin.v1.ExportEntitiesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      projectId_ = "";
      internalGetMutableLabels().clear();
      entityFilter_ = null;
      if (entityFilterBuilder_ != null) {
        entityFilterBuilder_.dispose();
        entityFilterBuilder_ = null;
      }
      outputUrlPrefix_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.admin.v1.DatastoreAdminProto
          .internal_static_google_datastore_admin_v1_ExportEntitiesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.admin.v1.ExportEntitiesRequest getDefaultInstanceForType() {
      return com.google.datastore.admin.v1.ExportEntitiesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.admin.v1.ExportEntitiesRequest build() {
      com.google.datastore.admin.v1.ExportEntitiesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.admin.v1.ExportEntitiesRequest buildPartial() {
      com.google.datastore.admin.v1.ExportEntitiesRequest result =
          new com.google.datastore.admin.v1.ExportEntitiesRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.datastore.admin.v1.ExportEntitiesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.entityFilter_ =
            entityFilterBuilder_ == null ? entityFilter_ : entityFilterBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.outputUrlPrefix_ = outputUrlPrefix_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.admin.v1.ExportEntitiesRequest) {
        return mergeFrom((com.google.datastore.admin.v1.ExportEntitiesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.admin.v1.ExportEntitiesRequest other) {
      if (other == com.google.datastore.admin.v1.ExportEntitiesRequest.getDefaultInstance())
        return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000002;
      if (other.hasEntityFilter()) {
        mergeEntityFilter(other.getEntityFilter());
      }
      if (!other.getOutputUrlPrefix().isEmpty()) {
        outputUrlPrefix_ = other.outputUrlPrefix_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getEntityFilterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                outputUrlPrefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Required. Project ID against which to make the request.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Project ID against which to make the request.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Project ID against which to make the request.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Project ID against which to make the request.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Project ID against which to make the request.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Client-assigned labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Client-assigned labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Client-assigned labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Client-assigned labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Client-assigned labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000002;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Client-assigned labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Client-assigned labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }

    private com.google.datastore.admin.v1.EntityFilter entityFilter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.admin.v1.EntityFilter,
            com.google.datastore.admin.v1.EntityFilter.Builder,
            com.google.datastore.admin.v1.EntityFilterOrBuilder>
        entityFilterBuilder_;
    /**
     *
     *
     * <pre>
     * Description of what data from the project is included in the export.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.EntityFilter entity_filter = 3;</code>
     *
     * @return Whether the entityFilter field is set.
     */
    public boolean hasEntityFilter() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Description of what data from the project is included in the export.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.EntityFilter entity_filter = 3;</code>
     *
     * @return The entityFilter.
     */
    public com.google.datastore.admin.v1.EntityFilter getEntityFilter() {
      if (entityFilterBuilder_ == null) {
        return entityFilter_ == null
            ? com.google.datastore.admin.v1.EntityFilter.getDefaultInstance()
            : entityFilter_;
      } else {
        return entityFilterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Description of what data from the project is included in the export.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.EntityFilter entity_filter = 3;</code>
     */
    public Builder setEntityFilter(com.google.datastore.admin.v1.EntityFilter value) {
      if (entityFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entityFilter_ = value;
      } else {
        entityFilterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of what data from the project is included in the export.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.EntityFilter entity_filter = 3;</code>
     */
    public Builder setEntityFilter(
        com.google.datastore.admin.v1.EntityFilter.Builder builderForValue) {
      if (entityFilterBuilder_ == null) {
        entityFilter_ = builderForValue.build();
      } else {
        entityFilterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of what data from the project is included in the export.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.EntityFilter entity_filter = 3;</code>
     */
    public Builder mergeEntityFilter(com.google.datastore.admin.v1.EntityFilter value) {
      if (entityFilterBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && entityFilter_ != null
            && entityFilter_ != com.google.datastore.admin.v1.EntityFilter.getDefaultInstance()) {
          getEntityFilterBuilder().mergeFrom(value);
        } else {
          entityFilter_ = value;
        }
      } else {
        entityFilterBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of what data from the project is included in the export.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.EntityFilter entity_filter = 3;</code>
     */
    public Builder clearEntityFilter() {
      bitField0_ = (bitField0_ & ~0x00000004);
      entityFilter_ = null;
      if (entityFilterBuilder_ != null) {
        entityFilterBuilder_.dispose();
        entityFilterBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of what data from the project is included in the export.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.EntityFilter entity_filter = 3;</code>
     */
    public com.google.datastore.admin.v1.EntityFilter.Builder getEntityFilterBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getEntityFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Description of what data from the project is included in the export.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.EntityFilter entity_filter = 3;</code>
     */
    public com.google.datastore.admin.v1.EntityFilterOrBuilder getEntityFilterOrBuilder() {
      if (entityFilterBuilder_ != null) {
        return entityFilterBuilder_.getMessageOrBuilder();
      } else {
        return entityFilter_ == null
            ? com.google.datastore.admin.v1.EntityFilter.getDefaultInstance()
            : entityFilter_;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of what data from the project is included in the export.
     * </pre>
     *
     * <code>.google.datastore.admin.v1.EntityFilter entity_filter = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.admin.v1.EntityFilter,
            com.google.datastore.admin.v1.EntityFilter.Builder,
            com.google.datastore.admin.v1.EntityFilterOrBuilder>
        getEntityFilterFieldBuilder() {
      if (entityFilterBuilder_ == null) {
        entityFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.admin.v1.EntityFilter,
                com.google.datastore.admin.v1.EntityFilter.Builder,
                com.google.datastore.admin.v1.EntityFilterOrBuilder>(
                getEntityFilter(), getParentForChildren(), isClean());
        entityFilter_ = null;
      }
      return entityFilterBuilder_;
    }

    private java.lang.Object outputUrlPrefix_ = "";
    /**
     *
     *
     * <pre>
     * Required. Location for the export metadata and data files.
     *
     * The full resource URL of the external storage location. Currently, only
     * Google Cloud Storage is supported. So output_url_prefix should be of the
     * form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the
     * name of the Cloud Storage bucket and `NAMESPACE_PATH` is an optional Cloud
     * Storage namespace path (this is not a Cloud Datastore namespace). For more
     * information about Cloud Storage namespace paths, see
     * [Object name
     * considerations](https://cloud.google.com/storage/docs/naming#object-considerations).
     *
     * The resulting files will be nested deeper than the specified URL prefix.
     * The final output URL will be provided in the
     * [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url] field. That
     * value should be used for subsequent ImportEntities operations.
     *
     * By nesting the data files deeper, the same Cloud Storage bucket can be used
     * in multiple ExportEntities operations without conflict.
     * </pre>
     *
     * <code>string output_url_prefix = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The outputUrlPrefix.
     */
    public java.lang.String getOutputUrlPrefix() {
      java.lang.Object ref = outputUrlPrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        outputUrlPrefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Location for the export metadata and data files.
     *
     * The full resource URL of the external storage location. Currently, only
     * Google Cloud Storage is supported. So output_url_prefix should be of the
     * form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the
     * name of the Cloud Storage bucket and `NAMESPACE_PATH` is an optional Cloud
     * Storage namespace path (this is not a Cloud Datastore namespace). For more
     * information about Cloud Storage namespace paths, see
     * [Object name
     * considerations](https://cloud.google.com/storage/docs/naming#object-considerations).
     *
     * The resulting files will be nested deeper than the specified URL prefix.
     * The final output URL will be provided in the
     * [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url] field. That
     * value should be used for subsequent ImportEntities operations.
     *
     * By nesting the data files deeper, the same Cloud Storage bucket can be used
     * in multiple ExportEntities operations without conflict.
     * </pre>
     *
     * <code>string output_url_prefix = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for outputUrlPrefix.
     */
    public com.google.protobuf.ByteString getOutputUrlPrefixBytes() {
      java.lang.Object ref = outputUrlPrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        outputUrlPrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Location for the export metadata and data files.
     *
     * The full resource URL of the external storage location. Currently, only
     * Google Cloud Storage is supported. So output_url_prefix should be of the
     * form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the
     * name of the Cloud Storage bucket and `NAMESPACE_PATH` is an optional Cloud
     * Storage namespace path (this is not a Cloud Datastore namespace). For more
     * information about Cloud Storage namespace paths, see
     * [Object name
     * considerations](https://cloud.google.com/storage/docs/naming#object-considerations).
     *
     * The resulting files will be nested deeper than the specified URL prefix.
     * The final output URL will be provided in the
     * [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url] field. That
     * value should be used for subsequent ImportEntities operations.
     *
     * By nesting the data files deeper, the same Cloud Storage bucket can be used
     * in multiple ExportEntities operations without conflict.
     * </pre>
     *
     * <code>string output_url_prefix = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The outputUrlPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setOutputUrlPrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      outputUrlPrefix_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Location for the export metadata and data files.
     *
     * The full resource URL of the external storage location. Currently, only
     * Google Cloud Storage is supported. So output_url_prefix should be of the
     * form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the
     * name of the Cloud Storage bucket and `NAMESPACE_PATH` is an optional Cloud
     * Storage namespace path (this is not a Cloud Datastore namespace). For more
     * information about Cloud Storage namespace paths, see
     * [Object name
     * considerations](https://cloud.google.com/storage/docs/naming#object-considerations).
     *
     * The resulting files will be nested deeper than the specified URL prefix.
     * The final output URL will be provided in the
     * [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url] field. That
     * value should be used for subsequent ImportEntities operations.
     *
     * By nesting the data files deeper, the same Cloud Storage bucket can be used
     * in multiple ExportEntities operations without conflict.
     * </pre>
     *
     * <code>string output_url_prefix = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutputUrlPrefix() {
      outputUrlPrefix_ = getDefaultInstance().getOutputUrlPrefix();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Location for the export metadata and data files.
     *
     * The full resource URL of the external storage location. Currently, only
     * Google Cloud Storage is supported. So output_url_prefix should be of the
     * form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the
     * name of the Cloud Storage bucket and `NAMESPACE_PATH` is an optional Cloud
     * Storage namespace path (this is not a Cloud Datastore namespace). For more
     * information about Cloud Storage namespace paths, see
     * [Object name
     * considerations](https://cloud.google.com/storage/docs/naming#object-considerations).
     *
     * The resulting files will be nested deeper than the specified URL prefix.
     * The final output URL will be provided in the
     * [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url] field. That
     * value should be used for subsequent ImportEntities operations.
     *
     * By nesting the data files deeper, the same Cloud Storage bucket can be used
     * in multiple ExportEntities operations without conflict.
     * </pre>
     *
     * <code>string output_url_prefix = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for outputUrlPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setOutputUrlPrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      outputUrlPrefix_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.admin.v1.ExportEntitiesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.admin.v1.ExportEntitiesRequest)
  private static final com.google.datastore.admin.v1.ExportEntitiesRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.admin.v1.ExportEntitiesRequest();
  }

  public static com.google.datastore.admin.v1.ExportEntitiesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExportEntitiesRequest> PARSER =
      new com.google.protobuf.AbstractParser<ExportEntitiesRequest>() {
        @java.lang.Override
        public ExportEntitiesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExportEntitiesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExportEntitiesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.admin.v1.ExportEntitiesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
