/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataform/v1/dataform.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.dataform.v1;

public interface RepositoryOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.Repository)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Identifier. The repository's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Identifier. The repository's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the repository was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the repository was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the repository was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The repository's user-friendly name.
   * </pre>
   *
   * <code>string display_name = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();

  /**
   *
   *
   * <pre>
   * Optional. The repository's user-friendly name.
   * </pre>
   *
   * <code>string display_name = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Optional. If set, configures this repository to be linked to a Git remote.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.Repository.GitRemoteSettings git_remote_settings = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the gitRemoteSettings field is set.
   */
  boolean hasGitRemoteSettings();

  /**
   *
   *
   * <pre>
   * Optional. If set, configures this repository to be linked to a Git remote.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.Repository.GitRemoteSettings git_remote_settings = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The gitRemoteSettings.
   */
  com.google.cloud.dataform.v1.Repository.GitRemoteSettings getGitRemoteSettings();

  /**
   *
   *
   * <pre>
   * Optional. If set, configures this repository to be linked to a Git remote.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.Repository.GitRemoteSettings git_remote_settings = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.dataform.v1.Repository.GitRemoteSettingsOrBuilder
      getGitRemoteSettingsOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The name of the Secret Manager secret version to be used to
   * interpolate variables into the .npmrc file for package installation
   * operations. Must be in the format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. The
   * file itself must be in a JSON format.
   * </pre>
   *
   * <code>
   * string npmrc_environment_variables_secret_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The npmrcEnvironmentVariablesSecretVersion.
   */
  java.lang.String getNpmrcEnvironmentVariablesSecretVersion();

  /**
   *
   *
   * <pre>
   * Optional. The name of the Secret Manager secret version to be used to
   * interpolate variables into the .npmrc file for package installation
   * operations. Must be in the format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. The
   * file itself must be in a JSON format.
   * </pre>
   *
   * <code>
   * string npmrc_environment_variables_secret_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for npmrcEnvironmentVariablesSecretVersion.
   */
  com.google.protobuf.ByteString getNpmrcEnvironmentVariablesSecretVersionBytes();

  /**
   *
   *
   * <pre>
   * Optional. If set, fields of `workspace_compilation_overrides` override the
   * default compilation settings that are specified in dataform.json when
   * creating workspace-scoped compilation results. See documentation for
   * `WorkspaceCompilationOverrides` for more information.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides workspace_compilation_overrides = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the workspaceCompilationOverrides field is set.
   */
  boolean hasWorkspaceCompilationOverrides();

  /**
   *
   *
   * <pre>
   * Optional. If set, fields of `workspace_compilation_overrides` override the
   * default compilation settings that are specified in dataform.json when
   * creating workspace-scoped compilation results. See documentation for
   * `WorkspaceCompilationOverrides` for more information.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides workspace_compilation_overrides = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The workspaceCompilationOverrides.
   */
  com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides
      getWorkspaceCompilationOverrides();

  /**
   *
   *
   * <pre>
   * Optional. If set, fields of `workspace_compilation_overrides` override the
   * default compilation settings that are specified in dataform.json when
   * creating workspace-scoped compilation results. See documentation for
   * `WorkspaceCompilationOverrides` for more information.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides workspace_compilation_overrides = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverridesOrBuilder
      getWorkspaceCompilationOverridesOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Repository user labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  int getLabelsCount();

  /**
   *
   *
   * <pre>
   * Optional. Repository user labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  boolean containsLabels(java.lang.String key);

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();

  /**
   *
   *
   * <pre>
   * Optional. Repository user labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();

  /**
   *
   *
   * <pre>
   * Optional. Repository user labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);

  /**
   *
   *
   * <pre>
   * Optional. Repository user labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. Input only. If set to true, the authenticated user will be
   * granted the roles/dataform.admin role on the created repository.
   * </pre>
   *
   * <code>
   * bool set_authenticated_user_admin = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The setAuthenticatedUserAdmin.
   */
  boolean getSetAuthenticatedUserAdmin();

  /**
   *
   *
   * <pre>
   * Optional. The service account to run workflow invocations under.
   * </pre>
   *
   * <code>string service_account = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The serviceAccount.
   */
  java.lang.String getServiceAccount();

  /**
   *
   *
   * <pre>
   * Optional. The service account to run workflow invocations under.
   * </pre>
   *
   * <code>string service_account = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for serviceAccount.
   */
  com.google.protobuf.ByteString getServiceAccountBytes();

  /**
   *
   *
   * <pre>
   * Optional. The reference to a KMS encryption key. If provided, it will be
   * used to encrypt user data in the repository and all child resources. It is
   * not possible to add or update the encryption key after the repository is
   * created. Example:
   * `projects/{kms_project}/locations/{location}/keyRings/{key_location}/cryptoKeys/{key}`
   * </pre>
   *
   * <code>
   * string kms_key_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The kmsKeyName.
   */
  java.lang.String getKmsKeyName();

  /**
   *
   *
   * <pre>
   * Optional. The reference to a KMS encryption key. If provided, it will be
   * used to encrypt user data in the repository and all child resources. It is
   * not possible to add or update the encryption key after the repository is
   * created. Example:
   * `projects/{kms_project}/locations/{location}/keyRings/{key_location}/cryptoKeys/{key}`
   * </pre>
   *
   * <code>
   * string kms_key_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for kmsKeyName.
   */
  com.google.protobuf.ByteString getKmsKeyNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. A data encryption state of a Git repository if this Repository
   * is protected by a KMS key.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the dataEncryptionState field is set.
   */
  boolean hasDataEncryptionState();

  /**
   *
   *
   * <pre>
   * Output only. A data encryption state of a Git repository if this Repository
   * is protected by a KMS key.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The dataEncryptionState.
   */
  com.google.cloud.dataform.v1.DataEncryptionState getDataEncryptionState();

  /**
   *
   *
   * <pre>
   * Output only. A data encryption state of a Git repository if this Repository
   * is protected by a KMS key.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.dataform.v1.DataEncryptionStateOrBuilder getDataEncryptionStateOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the internalMetadata field is set.
   */
  boolean hasInternalMetadata();

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The internalMetadata.
   */
  java.lang.String getInternalMetadata();

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for internalMetadata.
   */
  com.google.protobuf.ByteString getInternalMetadataBytes();
}
