/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataform/v1/dataform.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.dataform.v1;

/**
 *
 *
 * <pre>
 * Represents a Dataform Git repository.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataform.v1.Repository}
 */
public final class Repository extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.Repository)
    RepositoryOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Repository.newBuilder() to construct.
  private Repository(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Repository() {
    name_ = "";
    displayName_ = "";
    npmrcEnvironmentVariablesSecretVersion_ = "";
    serviceAccount_ = "";
    kmsKeyName_ = "";
    internalMetadata_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Repository();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_Repository_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 5:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_Repository_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataform.v1.Repository.class,
            com.google.cloud.dataform.v1.Repository.Builder.class);
  }

  public interface GitRemoteSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.Repository.GitRemoteSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The Git remote's URL.
     * </pre>
     *
     * <code>string url = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The url.
     */
    java.lang.String getUrl();

    /**
     *
     *
     * <pre>
     * Required. The Git remote's URL.
     * </pre>
     *
     * <code>string url = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for url.
     */
    com.google.protobuf.ByteString getUrlBytes();

    /**
     *
     *
     * <pre>
     * Required. The Git remote's default branch name.
     * </pre>
     *
     * <code>string default_branch = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The defaultBranch.
     */
    java.lang.String getDefaultBranch();

    /**
     *
     *
     * <pre>
     * Required. The Git remote's default branch name.
     * </pre>
     *
     * <code>string default_branch = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for defaultBranch.
     */
    com.google.protobuf.ByteString getDefaultBranchBytes();

    /**
     *
     *
     * <pre>
     * Optional. The name of the Secret Manager secret version to use as an
     * authentication token for Git operations. Must be in the format
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * </pre>
     *
     * <code>
     * string authentication_token_secret_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The authenticationTokenSecretVersion.
     */
    java.lang.String getAuthenticationTokenSecretVersion();

    /**
     *
     *
     * <pre>
     * Optional. The name of the Secret Manager secret version to use as an
     * authentication token for Git operations. Must be in the format
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * </pre>
     *
     * <code>
     * string authentication_token_secret_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for authenticationTokenSecretVersion.
     */
    com.google.protobuf.ByteString getAuthenticationTokenSecretVersionBytes();

    /**
     *
     *
     * <pre>
     * Optional. Authentication fields for remote uris using SSH protocol.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig ssh_authentication_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sshAuthenticationConfig field is set.
     */
    boolean hasSshAuthenticationConfig();

    /**
     *
     *
     * <pre>
     * Optional. Authentication fields for remote uris using SSH protocol.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig ssh_authentication_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sshAuthenticationConfig.
     */
    com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
        getSshAuthenticationConfig();

    /**
     *
     *
     * <pre>
     * Optional. Authentication fields for remote uris using SSH protocol.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig ssh_authentication_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfigOrBuilder
        getSshAuthenticationConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. Deprecated: The field does not contain any token status
     * information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus token_status = 4 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.cloud.dataform.v1.Repository.GitRemoteSettings.token_status is deprecated.
     *     See google/cloud/dataform/v1/dataform.proto;l=630
     * @return The enum numeric value on the wire for tokenStatus.
     */
    @java.lang.Deprecated
    int getTokenStatusValue();

    /**
     *
     *
     * <pre>
     * Output only. Deprecated: The field does not contain any token status
     * information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus token_status = 4 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.cloud.dataform.v1.Repository.GitRemoteSettings.token_status is deprecated.
     *     See google/cloud/dataform/v1/dataform.proto;l=630
     * @return The tokenStatus.
     */
    @java.lang.Deprecated
    com.google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus getTokenStatus();
  }

  /**
   *
   *
   * <pre>
   * Controls Git remote configuration for a repository.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.Repository.GitRemoteSettings}
   */
  public static final class GitRemoteSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.Repository.GitRemoteSettings)
      GitRemoteSettingsOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use GitRemoteSettings.newBuilder() to construct.
    private GitRemoteSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GitRemoteSettings() {
      url_ = "";
      defaultBranch_ = "";
      authenticationTokenSecretVersion_ = "";
      tokenStatus_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GitRemoteSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_Repository_GitRemoteSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_Repository_GitRemoteSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.Repository.GitRemoteSettings.class,
              com.google.cloud.dataform.v1.Repository.GitRemoteSettings.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The status of the authentication token.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus}
     */
    public enum TokenStatus implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>TOKEN_STATUS_UNSPECIFIED = 0;</code>
       */
      TOKEN_STATUS_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The token could not be found in Secret Manager (or the Dataform
       * Service Account did not have permission to access it).
       * </pre>
       *
       * <code>NOT_FOUND = 1;</code>
       */
      NOT_FOUND(1),
      /**
       *
       *
       * <pre>
       * The token could not be used to authenticate against the Git remote.
       * </pre>
       *
       * <code>INVALID = 2;</code>
       */
      INVALID(2),
      /**
       *
       *
       * <pre>
       * The token was used successfully to authenticate against the Git remote.
       * </pre>
       *
       * <code>VALID = 3;</code>
       */
      VALID(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>TOKEN_STATUS_UNSPECIFIED = 0;</code>
       */
      public static final int TOKEN_STATUS_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * The token could not be found in Secret Manager (or the Dataform
       * Service Account did not have permission to access it).
       * </pre>
       *
       * <code>NOT_FOUND = 1;</code>
       */
      public static final int NOT_FOUND_VALUE = 1;

      /**
       *
       *
       * <pre>
       * The token could not be used to authenticate against the Git remote.
       * </pre>
       *
       * <code>INVALID = 2;</code>
       */
      public static final int INVALID_VALUE = 2;

      /**
       *
       *
       * <pre>
       * The token was used successfully to authenticate against the Git remote.
       * </pre>
       *
       * <code>VALID = 3;</code>
       */
      public static final int VALID_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TokenStatus valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static TokenStatus forNumber(int value) {
        switch (value) {
          case 0:
            return TOKEN_STATUS_UNSPECIFIED;
          case 1:
            return NOT_FOUND;
          case 2:
            return INVALID;
          case 3:
            return VALID;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<TokenStatus> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<TokenStatus> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<TokenStatus>() {
            public TokenStatus findValueByNumber(int number) {
              return TokenStatus.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.dataform.v1.Repository.GitRemoteSettings.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final TokenStatus[] VALUES = values();

      public static TokenStatus valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private TokenStatus(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus)
    }

    public interface SshAuthenticationConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The name of the Secret Manager secret version to use as a
       * ssh private key for Git operations.
       * Must be in the format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
       * </pre>
       *
       * <code>
       * string user_private_key_secret_version = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The userPrivateKeySecretVersion.
       */
      java.lang.String getUserPrivateKeySecretVersion();

      /**
       *
       *
       * <pre>
       * Required. The name of the Secret Manager secret version to use as a
       * ssh private key for Git operations.
       * Must be in the format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
       * </pre>
       *
       * <code>
       * string user_private_key_secret_version = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for userPrivateKeySecretVersion.
       */
      com.google.protobuf.ByteString getUserPrivateKeySecretVersionBytes();

      /**
       *
       *
       * <pre>
       * Required. Content of a public SSH key to verify an identity of a remote
       * Git host.
       * </pre>
       *
       * <code>string host_public_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The hostPublicKey.
       */
      java.lang.String getHostPublicKey();

      /**
       *
       *
       * <pre>
       * Required. Content of a public SSH key to verify an identity of a remote
       * Git host.
       * </pre>
       *
       * <code>string host_public_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for hostPublicKey.
       */
      com.google.protobuf.ByteString getHostPublicKeyBytes();
    }

    /**
     *
     *
     * <pre>
     * Configures fields for performing SSH authentication.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig}
     */
    public static final class SshAuthenticationConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig)
        SshAuthenticationConfigOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use SshAuthenticationConfig.newBuilder() to construct.
      private SshAuthenticationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SshAuthenticationConfig() {
        userPrivateKeySecretVersion_ = "";
        hostPublicKey_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SshAuthenticationConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_Repository_GitRemoteSettings_SshAuthenticationConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_Repository_GitRemoteSettings_SshAuthenticationConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
                    .class,
                com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
                    .Builder.class);
      }

      public static final int USER_PRIVATE_KEY_SECRET_VERSION_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object userPrivateKeySecretVersion_ = "";

      /**
       *
       *
       * <pre>
       * Required. The name of the Secret Manager secret version to use as a
       * ssh private key for Git operations.
       * Must be in the format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
       * </pre>
       *
       * <code>
       * string user_private_key_secret_version = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The userPrivateKeySecretVersion.
       */
      @java.lang.Override
      public java.lang.String getUserPrivateKeySecretVersion() {
        java.lang.Object ref = userPrivateKeySecretVersion_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          userPrivateKeySecretVersion_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the Secret Manager secret version to use as a
       * ssh private key for Git operations.
       * Must be in the format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
       * </pre>
       *
       * <code>
       * string user_private_key_secret_version = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for userPrivateKeySecretVersion.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUserPrivateKeySecretVersionBytes() {
        java.lang.Object ref = userPrivateKeySecretVersion_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          userPrivateKeySecretVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int HOST_PUBLIC_KEY_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object hostPublicKey_ = "";

      /**
       *
       *
       * <pre>
       * Required. Content of a public SSH key to verify an identity of a remote
       * Git host.
       * </pre>
       *
       * <code>string host_public_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The hostPublicKey.
       */
      @java.lang.Override
      public java.lang.String getHostPublicKey() {
        java.lang.Object ref = hostPublicKey_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          hostPublicKey_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Content of a public SSH key to verify an identity of a remote
       * Git host.
       * </pre>
       *
       * <code>string host_public_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for hostPublicKey.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getHostPublicKeyBytes() {
        java.lang.Object ref = hostPublicKey_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          hostPublicKey_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userPrivateKeySecretVersion_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(
              output, 1, userPrivateKeySecretVersion_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostPublicKey_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, hostPublicKey_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userPrivateKeySecretVersion_)) {
          size +=
              com.google.protobuf.GeneratedMessageV3.computeStringSize(
                  1, userPrivateKeySecretVersion_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostPublicKey_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, hostPublicKey_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig other =
            (com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig) obj;

        if (!getUserPrivateKeySecretVersion().equals(other.getUserPrivateKeySecretVersion()))
          return false;
        if (!getHostPublicKey().equals(other.getHostPublicKey())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + USER_PRIVATE_KEY_SECRET_VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getUserPrivateKeySecretVersion().hashCode();
        hash = (37 * hash) + HOST_PUBLIC_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getHostPublicKey().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings
              .SshAuthenticationConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings
              .SshAuthenticationConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings
              .SshAuthenticationConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings
              .SshAuthenticationConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings
              .SshAuthenticationConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings
              .SshAuthenticationConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings
              .SshAuthenticationConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings
              .SshAuthenticationConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings
              .SshAuthenticationConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings
              .SshAuthenticationConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings
              .SshAuthenticationConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings
              .SshAuthenticationConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Configures fields for performing SSH authentication.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig)
          com.google.cloud.dataform.v1.Repository.GitRemoteSettings
              .SshAuthenticationConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_Repository_GitRemoteSettings_SshAuthenticationConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_Repository_GitRemoteSettings_SshAuthenticationConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
                      .class,
                  com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          userPrivateKeySecretVersion_ = "";
          hostPublicKey_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_Repository_GitRemoteSettings_SshAuthenticationConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
            getDefaultInstanceForType() {
          return com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
            build() {
          com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
            buildPartial() {
          com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig result =
              new com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.userPrivateKeySecretVersion_ = userPrivateKeySecretVersion_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.hostPublicKey_ = hostPublicKey_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig) {
            return mergeFrom(
                (com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
                other) {
          if (other
              == com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
                  .getDefaultInstance()) return this;
          if (!other.getUserPrivateKeySecretVersion().isEmpty()) {
            userPrivateKeySecretVersion_ = other.userPrivateKeySecretVersion_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getHostPublicKey().isEmpty()) {
            hostPublicKey_ = other.hostPublicKey_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    userPrivateKeySecretVersion_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    hostPublicKey_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object userPrivateKeySecretVersion_ = "";

        /**
         *
         *
         * <pre>
         * Required. The name of the Secret Manager secret version to use as a
         * ssh private key for Git operations.
         * Must be in the format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
         * </pre>
         *
         * <code>
         * string user_private_key_secret_version = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The userPrivateKeySecretVersion.
         */
        public java.lang.String getUserPrivateKeySecretVersion() {
          java.lang.Object ref = userPrivateKeySecretVersion_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            userPrivateKeySecretVersion_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The name of the Secret Manager secret version to use as a
         * ssh private key for Git operations.
         * Must be in the format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
         * </pre>
         *
         * <code>
         * string user_private_key_secret_version = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The bytes for userPrivateKeySecretVersion.
         */
        public com.google.protobuf.ByteString getUserPrivateKeySecretVersionBytes() {
          java.lang.Object ref = userPrivateKeySecretVersion_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            userPrivateKeySecretVersion_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The name of the Secret Manager secret version to use as a
         * ssh private key for Git operations.
         * Must be in the format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
         * </pre>
         *
         * <code>
         * string user_private_key_secret_version = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The userPrivateKeySecretVersion to set.
         * @return This builder for chaining.
         */
        public Builder setUserPrivateKeySecretVersion(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          userPrivateKeySecretVersion_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The name of the Secret Manager secret version to use as a
         * ssh private key for Git operations.
         * Must be in the format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
         * </pre>
         *
         * <code>
         * string user_private_key_secret_version = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUserPrivateKeySecretVersion() {
          userPrivateKeySecretVersion_ = getDefaultInstance().getUserPrivateKeySecretVersion();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The name of the Secret Manager secret version to use as a
         * ssh private key for Git operations.
         * Must be in the format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
         * </pre>
         *
         * <code>
         * string user_private_key_secret_version = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The bytes for userPrivateKeySecretVersion to set.
         * @return This builder for chaining.
         */
        public Builder setUserPrivateKeySecretVersionBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          userPrivateKeySecretVersion_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object hostPublicKey_ = "";

        /**
         *
         *
         * <pre>
         * Required. Content of a public SSH key to verify an identity of a remote
         * Git host.
         * </pre>
         *
         * <code>string host_public_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The hostPublicKey.
         */
        public java.lang.String getHostPublicKey() {
          java.lang.Object ref = hostPublicKey_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            hostPublicKey_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. Content of a public SSH key to verify an identity of a remote
         * Git host.
         * </pre>
         *
         * <code>string host_public_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for hostPublicKey.
         */
        public com.google.protobuf.ByteString getHostPublicKeyBytes() {
          java.lang.Object ref = hostPublicKey_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            hostPublicKey_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. Content of a public SSH key to verify an identity of a remote
         * Git host.
         * </pre>
         *
         * <code>string host_public_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The hostPublicKey to set.
         * @return This builder for chaining.
         */
        public Builder setHostPublicKey(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          hostPublicKey_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. Content of a public SSH key to verify an identity of a remote
         * Git host.
         * </pre>
         *
         * <code>string host_public_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearHostPublicKey() {
          hostPublicKey_ = getDefaultInstance().getHostPublicKey();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. Content of a public SSH key to verify an identity of a remote
         * Git host.
         * </pre>
         *
         * <code>string host_public_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for hostPublicKey to set.
         * @return This builder for chaining.
         */
        public Builder setHostPublicKeyBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          hostPublicKey_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig)
      private static final com.google.cloud.dataform.v1.Repository.GitRemoteSettings
              .SshAuthenticationConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig();
      }

      public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings
              .SshAuthenticationConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SshAuthenticationConfig> PARSER =
          new com.google.protobuf.AbstractParser<SshAuthenticationConfig>() {
            @java.lang.Override
            public SshAuthenticationConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SshAuthenticationConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SshAuthenticationConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int URL_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object url_ = "";

    /**
     *
     *
     * <pre>
     * Required. The Git remote's URL.
     * </pre>
     *
     * <code>string url = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The url.
     */
    @java.lang.Override
    public java.lang.String getUrl() {
      java.lang.Object ref = url_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        url_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The Git remote's URL.
     * </pre>
     *
     * <code>string url = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for url.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUrlBytes() {
      java.lang.Object ref = url_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        url_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DEFAULT_BRANCH_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object defaultBranch_ = "";

    /**
     *
     *
     * <pre>
     * Required. The Git remote's default branch name.
     * </pre>
     *
     * <code>string default_branch = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The defaultBranch.
     */
    @java.lang.Override
    public java.lang.String getDefaultBranch() {
      java.lang.Object ref = defaultBranch_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultBranch_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The Git remote's default branch name.
     * </pre>
     *
     * <code>string default_branch = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for defaultBranch.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDefaultBranchBytes() {
      java.lang.Object ref = defaultBranch_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultBranch_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AUTHENTICATION_TOKEN_SECRET_VERSION_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object authenticationTokenSecretVersion_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The name of the Secret Manager secret version to use as an
     * authentication token for Git operations. Must be in the format
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * </pre>
     *
     * <code>
     * string authentication_token_secret_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The authenticationTokenSecretVersion.
     */
    @java.lang.Override
    public java.lang.String getAuthenticationTokenSecretVersion() {
      java.lang.Object ref = authenticationTokenSecretVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        authenticationTokenSecretVersion_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the Secret Manager secret version to use as an
     * authentication token for Git operations. Must be in the format
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     * </pre>
     *
     * <code>
     * string authentication_token_secret_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for authenticationTokenSecretVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAuthenticationTokenSecretVersionBytes() {
      java.lang.Object ref = authenticationTokenSecretVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        authenticationTokenSecretVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SSH_AUTHENTICATION_CONFIG_FIELD_NUMBER = 5;
    private com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
        sshAuthenticationConfig_;

    /**
     *
     *
     * <pre>
     * Optional. Authentication fields for remote uris using SSH protocol.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig ssh_authentication_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sshAuthenticationConfig field is set.
     */
    @java.lang.Override
    public boolean hasSshAuthenticationConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Authentication fields for remote uris using SSH protocol.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig ssh_authentication_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sshAuthenticationConfig.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
        getSshAuthenticationConfig() {
      return sshAuthenticationConfig_ == null
          ? com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
              .getDefaultInstance()
          : sshAuthenticationConfig_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Authentication fields for remote uris using SSH protocol.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig ssh_authentication_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.Repository.GitRemoteSettings
            .SshAuthenticationConfigOrBuilder
        getSshAuthenticationConfigOrBuilder() {
      return sshAuthenticationConfig_ == null
          ? com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
              .getDefaultInstance()
          : sshAuthenticationConfig_;
    }

    public static final int TOKEN_STATUS_FIELD_NUMBER = 4;
    private int tokenStatus_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. Deprecated: The field does not contain any token status
     * information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus token_status = 4 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.cloud.dataform.v1.Repository.GitRemoteSettings.token_status is deprecated.
     *     See google/cloud/dataform/v1/dataform.proto;l=630
     * @return The enum numeric value on the wire for tokenStatus.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getTokenStatusValue() {
      return tokenStatus_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Deprecated: The field does not contain any token status
     * information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus token_status = 4 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.cloud.dataform.v1.Repository.GitRemoteSettings.token_status is deprecated.
     *     See google/cloud/dataform/v1/dataform.proto;l=630
     * @return The tokenStatus.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus getTokenStatus() {
      com.google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus result =
          com.google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus.forNumber(
              tokenStatus_);
      return result == null
          ? com.google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, url_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultBranch_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, defaultBranch_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(
          authenticationTokenSecretVersion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 3, authenticationTokenSecretVersion_);
      }
      if (tokenStatus_
          != com.google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus
              .TOKEN_STATUS_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, tokenStatus_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(5, getSshAuthenticationConfig());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, url_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultBranch_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, defaultBranch_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(
          authenticationTokenSecretVersion_)) {
        size +=
            com.google.protobuf.GeneratedMessageV3.computeStringSize(
                3, authenticationTokenSecretVersion_);
      }
      if (tokenStatus_
          != com.google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus
              .TOKEN_STATUS_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, tokenStatus_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5, getSshAuthenticationConfig());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataform.v1.Repository.GitRemoteSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.dataform.v1.Repository.GitRemoteSettings other =
          (com.google.cloud.dataform.v1.Repository.GitRemoteSettings) obj;

      if (!getUrl().equals(other.getUrl())) return false;
      if (!getDefaultBranch().equals(other.getDefaultBranch())) return false;
      if (!getAuthenticationTokenSecretVersion()
          .equals(other.getAuthenticationTokenSecretVersion())) return false;
      if (hasSshAuthenticationConfig() != other.hasSshAuthenticationConfig()) return false;
      if (hasSshAuthenticationConfig()) {
        if (!getSshAuthenticationConfig().equals(other.getSshAuthenticationConfig())) return false;
      }
      if (tokenStatus_ != other.tokenStatus_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + URL_FIELD_NUMBER;
      hash = (53 * hash) + getUrl().hashCode();
      hash = (37 * hash) + DEFAULT_BRANCH_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultBranch().hashCode();
      hash = (37 * hash) + AUTHENTICATION_TOKEN_SECRET_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getAuthenticationTokenSecretVersion().hashCode();
      if (hasSshAuthenticationConfig()) {
        hash = (37 * hash) + SSH_AUTHENTICATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getSshAuthenticationConfig().hashCode();
      }
      hash = (37 * hash) + TOKEN_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + tokenStatus_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataform.v1.Repository.GitRemoteSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Controls Git remote configuration for a repository.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataform.v1.Repository.GitRemoteSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.Repository.GitRemoteSettings)
        com.google.cloud.dataform.v1.Repository.GitRemoteSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_Repository_GitRemoteSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_Repository_GitRemoteSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.Repository.GitRemoteSettings.class,
                com.google.cloud.dataform.v1.Repository.GitRemoteSettings.Builder.class);
      }

      // Construct using com.google.cloud.dataform.v1.Repository.GitRemoteSettings.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSshAuthenticationConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        url_ = "";
        defaultBranch_ = "";
        authenticationTokenSecretVersion_ = "";
        sshAuthenticationConfig_ = null;
        if (sshAuthenticationConfigBuilder_ != null) {
          sshAuthenticationConfigBuilder_.dispose();
          sshAuthenticationConfigBuilder_ = null;
        }
        tokenStatus_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_Repository_GitRemoteSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.Repository.GitRemoteSettings getDefaultInstanceForType() {
        return com.google.cloud.dataform.v1.Repository.GitRemoteSettings.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.Repository.GitRemoteSettings build() {
        com.google.cloud.dataform.v1.Repository.GitRemoteSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.Repository.GitRemoteSettings buildPartial() {
        com.google.cloud.dataform.v1.Repository.GitRemoteSettings result =
            new com.google.cloud.dataform.v1.Repository.GitRemoteSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.dataform.v1.Repository.GitRemoteSettings result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.url_ = url_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.defaultBranch_ = defaultBranch_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.authenticationTokenSecretVersion_ = authenticationTokenSecretVersion_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.sshAuthenticationConfig_ =
              sshAuthenticationConfigBuilder_ == null
                  ? sshAuthenticationConfig_
                  : sshAuthenticationConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.tokenStatus_ = tokenStatus_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataform.v1.Repository.GitRemoteSettings) {
          return mergeFrom((com.google.cloud.dataform.v1.Repository.GitRemoteSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dataform.v1.Repository.GitRemoteSettings other) {
        if (other == com.google.cloud.dataform.v1.Repository.GitRemoteSettings.getDefaultInstance())
          return this;
        if (!other.getUrl().isEmpty()) {
          url_ = other.url_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDefaultBranch().isEmpty()) {
          defaultBranch_ = other.defaultBranch_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getAuthenticationTokenSecretVersion().isEmpty()) {
          authenticationTokenSecretVersion_ = other.authenticationTokenSecretVersion_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.hasSshAuthenticationConfig()) {
          mergeSshAuthenticationConfig(other.getSshAuthenticationConfig());
        }
        if (other.tokenStatus_ != 0) {
          setTokenStatusValue(other.getTokenStatusValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  url_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  defaultBranch_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  authenticationTokenSecretVersion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 32:
                {
                  tokenStatus_ = input.readEnum();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 32
              case 42:
                {
                  input.readMessage(
                      getSshAuthenticationConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object url_ = "";

      /**
       *
       *
       * <pre>
       * Required. The Git remote's URL.
       * </pre>
       *
       * <code>string url = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The url.
       */
      public java.lang.String getUrl() {
        java.lang.Object ref = url_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          url_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The Git remote's URL.
       * </pre>
       *
       * <code>string url = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for url.
       */
      public com.google.protobuf.ByteString getUrlBytes() {
        java.lang.Object ref = url_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          url_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The Git remote's URL.
       * </pre>
       *
       * <code>string url = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The url to set.
       * @return This builder for chaining.
       */
      public Builder setUrl(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        url_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The Git remote's URL.
       * </pre>
       *
       * <code>string url = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUrl() {
        url_ = getDefaultInstance().getUrl();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The Git remote's URL.
       * </pre>
       *
       * <code>string url = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for url to set.
       * @return This builder for chaining.
       */
      public Builder setUrlBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        url_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object defaultBranch_ = "";

      /**
       *
       *
       * <pre>
       * Required. The Git remote's default branch name.
       * </pre>
       *
       * <code>string default_branch = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The defaultBranch.
       */
      public java.lang.String getDefaultBranch() {
        java.lang.Object ref = defaultBranch_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          defaultBranch_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The Git remote's default branch name.
       * </pre>
       *
       * <code>string default_branch = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for defaultBranch.
       */
      public com.google.protobuf.ByteString getDefaultBranchBytes() {
        java.lang.Object ref = defaultBranch_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          defaultBranch_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The Git remote's default branch name.
       * </pre>
       *
       * <code>string default_branch = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The defaultBranch to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultBranch(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultBranch_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The Git remote's default branch name.
       * </pre>
       *
       * <code>string default_branch = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDefaultBranch() {
        defaultBranch_ = getDefaultInstance().getDefaultBranch();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The Git remote's default branch name.
       * </pre>
       *
       * <code>string default_branch = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for defaultBranch to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultBranchBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        defaultBranch_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object authenticationTokenSecretVersion_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The name of the Secret Manager secret version to use as an
       * authentication token for Git operations. Must be in the format
       * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
       * </pre>
       *
       * <code>
       * string authentication_token_secret_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The authenticationTokenSecretVersion.
       */
      public java.lang.String getAuthenticationTokenSecretVersion() {
        java.lang.Object ref = authenticationTokenSecretVersion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          authenticationTokenSecretVersion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The name of the Secret Manager secret version to use as an
       * authentication token for Git operations. Must be in the format
       * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
       * </pre>
       *
       * <code>
       * string authentication_token_secret_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for authenticationTokenSecretVersion.
       */
      public com.google.protobuf.ByteString getAuthenticationTokenSecretVersionBytes() {
        java.lang.Object ref = authenticationTokenSecretVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          authenticationTokenSecretVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The name of the Secret Manager secret version to use as an
       * authentication token for Git operations. Must be in the format
       * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
       * </pre>
       *
       * <code>
       * string authentication_token_secret_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The authenticationTokenSecretVersion to set.
       * @return This builder for chaining.
       */
      public Builder setAuthenticationTokenSecretVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        authenticationTokenSecretVersion_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The name of the Secret Manager secret version to use as an
       * authentication token for Git operations. Must be in the format
       * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
       * </pre>
       *
       * <code>
       * string authentication_token_secret_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAuthenticationTokenSecretVersion() {
        authenticationTokenSecretVersion_ =
            getDefaultInstance().getAuthenticationTokenSecretVersion();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The name of the Secret Manager secret version to use as an
       * authentication token for Git operations. Must be in the format
       * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
       * </pre>
       *
       * <code>
       * string authentication_token_secret_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for authenticationTokenSecretVersion to set.
       * @return This builder for chaining.
       */
      public Builder setAuthenticationTokenSecretVersionBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        authenticationTokenSecretVersion_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
          sshAuthenticationConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig,
              com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
                  .Builder,
              com.google.cloud.dataform.v1.Repository.GitRemoteSettings
                  .SshAuthenticationConfigOrBuilder>
          sshAuthenticationConfigBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Authentication fields for remote uris using SSH protocol.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig ssh_authentication_config = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the sshAuthenticationConfig field is set.
       */
      public boolean hasSshAuthenticationConfig() {
        return ((bitField0_ & 0x00000008) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Authentication fields for remote uris using SSH protocol.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig ssh_authentication_config = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The sshAuthenticationConfig.
       */
      public com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
          getSshAuthenticationConfig() {
        if (sshAuthenticationConfigBuilder_ == null) {
          return sshAuthenticationConfig_ == null
              ? com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
                  .getDefaultInstance()
              : sshAuthenticationConfig_;
        } else {
          return sshAuthenticationConfigBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Authentication fields for remote uris using SSH protocol.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig ssh_authentication_config = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setSshAuthenticationConfig(
          com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig value) {
        if (sshAuthenticationConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          sshAuthenticationConfig_ = value;
        } else {
          sshAuthenticationConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Authentication fields for remote uris using SSH protocol.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig ssh_authentication_config = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setSshAuthenticationConfig(
          com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig.Builder
              builderForValue) {
        if (sshAuthenticationConfigBuilder_ == null) {
          sshAuthenticationConfig_ = builderForValue.build();
        } else {
          sshAuthenticationConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Authentication fields for remote uris using SSH protocol.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig ssh_authentication_config = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeSshAuthenticationConfig(
          com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig value) {
        if (sshAuthenticationConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && sshAuthenticationConfig_ != null
              && sshAuthenticationConfig_
                  != com.google.cloud.dataform.v1.Repository.GitRemoteSettings
                      .SshAuthenticationConfig.getDefaultInstance()) {
            getSshAuthenticationConfigBuilder().mergeFrom(value);
          } else {
            sshAuthenticationConfig_ = value;
          }
        } else {
          sshAuthenticationConfigBuilder_.mergeFrom(value);
        }
        if (sshAuthenticationConfig_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Authentication fields for remote uris using SSH protocol.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig ssh_authentication_config = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearSshAuthenticationConfig() {
        bitField0_ = (bitField0_ & ~0x00000008);
        sshAuthenticationConfig_ = null;
        if (sshAuthenticationConfigBuilder_ != null) {
          sshAuthenticationConfigBuilder_.dispose();
          sshAuthenticationConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Authentication fields for remote uris using SSH protocol.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig ssh_authentication_config = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
              .Builder
          getSshAuthenticationConfigBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getSshAuthenticationConfigFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Authentication fields for remote uris using SSH protocol.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig ssh_authentication_config = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dataform.v1.Repository.GitRemoteSettings
              .SshAuthenticationConfigOrBuilder
          getSshAuthenticationConfigOrBuilder() {
        if (sshAuthenticationConfigBuilder_ != null) {
          return sshAuthenticationConfigBuilder_.getMessageOrBuilder();
        } else {
          return sshAuthenticationConfig_ == null
              ? com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
                  .getDefaultInstance()
              : sshAuthenticationConfig_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Authentication fields for remote uris using SSH protocol.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig ssh_authentication_config = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig,
              com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
                  .Builder,
              com.google.cloud.dataform.v1.Repository.GitRemoteSettings
                  .SshAuthenticationConfigOrBuilder>
          getSshAuthenticationConfigFieldBuilder() {
        if (sshAuthenticationConfigBuilder_ == null) {
          sshAuthenticationConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig,
                  com.google.cloud.dataform.v1.Repository.GitRemoteSettings.SshAuthenticationConfig
                      .Builder,
                  com.google.cloud.dataform.v1.Repository.GitRemoteSettings
                      .SshAuthenticationConfigOrBuilder>(
                  getSshAuthenticationConfig(), getParentForChildren(), isClean());
          sshAuthenticationConfig_ = null;
        }
        return sshAuthenticationConfigBuilder_;
      }

      private int tokenStatus_ = 0;

      /**
       *
       *
       * <pre>
       * Output only. Deprecated: The field does not contain any token status
       * information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus token_status = 4 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @deprecated google.cloud.dataform.v1.Repository.GitRemoteSettings.token_status is
       *     deprecated. See google/cloud/dataform/v1/dataform.proto;l=630
       * @return The enum numeric value on the wire for tokenStatus.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public int getTokenStatusValue() {
        return tokenStatus_;
      }

      /**
       *
       *
       * <pre>
       * Output only. Deprecated: The field does not contain any token status
       * information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus token_status = 4 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @deprecated google.cloud.dataform.v1.Repository.GitRemoteSettings.token_status is
       *     deprecated. See google/cloud/dataform/v1/dataform.proto;l=630
       * @param value The enum numeric value on the wire for tokenStatus to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setTokenStatusValue(int value) {
        tokenStatus_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Deprecated: The field does not contain any token status
       * information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus token_status = 4 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @deprecated google.cloud.dataform.v1.Repository.GitRemoteSettings.token_status is
       *     deprecated. See google/cloud/dataform/v1/dataform.proto;l=630
       * @return The tokenStatus.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus
          getTokenStatus() {
        com.google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus result =
            com.google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus.forNumber(
                tokenStatus_);
        return result == null
            ? com.google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Output only. Deprecated: The field does not contain any token status
       * information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus token_status = 4 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @deprecated google.cloud.dataform.v1.Repository.GitRemoteSettings.token_status is
       *     deprecated. See google/cloud/dataform/v1/dataform.proto;l=630
       * @param value The tokenStatus to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setTokenStatus(
          com.google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        tokenStatus_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Deprecated: The field does not contain any token status
       * information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.Repository.GitRemoteSettings.TokenStatus token_status = 4 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @deprecated google.cloud.dataform.v1.Repository.GitRemoteSettings.token_status is
       *     deprecated. See google/cloud/dataform/v1/dataform.proto;l=630
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearTokenStatus() {
        bitField0_ = (bitField0_ & ~0x00000010);
        tokenStatus_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.Repository.GitRemoteSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.Repository.GitRemoteSettings)
    private static final com.google.cloud.dataform.v1.Repository.GitRemoteSettings DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.Repository.GitRemoteSettings();
    }

    public static com.google.cloud.dataform.v1.Repository.GitRemoteSettings getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GitRemoteSettings> PARSER =
        new com.google.protobuf.AbstractParser<GitRemoteSettings>() {
          @java.lang.Override
          public GitRemoteSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GitRemoteSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GitRemoteSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.Repository.GitRemoteSettings getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface WorkspaceCompilationOverridesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The default database (Google Cloud project ID).
     * </pre>
     *
     * <code>string default_database = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The defaultDatabase.
     */
    java.lang.String getDefaultDatabase();

    /**
     *
     *
     * <pre>
     * Optional. The default database (Google Cloud project ID).
     * </pre>
     *
     * <code>string default_database = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for defaultDatabase.
     */
    com.google.protobuf.ByteString getDefaultDatabaseBytes();

    /**
     *
     *
     * <pre>
     * Optional. The suffix that should be appended to all schema (BigQuery
     * dataset ID) names.
     * </pre>
     *
     * <code>string schema_suffix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The schemaSuffix.
     */
    java.lang.String getSchemaSuffix();

    /**
     *
     *
     * <pre>
     * Optional. The suffix that should be appended to all schema (BigQuery
     * dataset ID) names.
     * </pre>
     *
     * <code>string schema_suffix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for schemaSuffix.
     */
    com.google.protobuf.ByteString getSchemaSuffixBytes();

    /**
     *
     *
     * <pre>
     * Optional. The prefix that should be prepended to all table names.
     * </pre>
     *
     * <code>string table_prefix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The tablePrefix.
     */
    java.lang.String getTablePrefix();

    /**
     *
     *
     * <pre>
     * Optional. The prefix that should be prepended to all table names.
     * </pre>
     *
     * <code>string table_prefix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for tablePrefix.
     */
    com.google.protobuf.ByteString getTablePrefixBytes();
  }

  /**
   *
   *
   * <pre>
   * Configures workspace compilation overrides for a repository.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides}
   */
  public static final class WorkspaceCompilationOverrides
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides)
      WorkspaceCompilationOverridesOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use WorkspaceCompilationOverrides.newBuilder() to construct.
    private WorkspaceCompilationOverrides(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private WorkspaceCompilationOverrides() {
      defaultDatabase_ = "";
      schemaSuffix_ = "";
      tablePrefix_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new WorkspaceCompilationOverrides();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_Repository_WorkspaceCompilationOverrides_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_Repository_WorkspaceCompilationOverrides_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides.class,
              com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides.Builder.class);
    }

    public static final int DEFAULT_DATABASE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object defaultDatabase_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The default database (Google Cloud project ID).
     * </pre>
     *
     * <code>string default_database = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The defaultDatabase.
     */
    @java.lang.Override
    public java.lang.String getDefaultDatabase() {
      java.lang.Object ref = defaultDatabase_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultDatabase_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The default database (Google Cloud project ID).
     * </pre>
     *
     * <code>string default_database = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for defaultDatabase.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDefaultDatabaseBytes() {
      java.lang.Object ref = defaultDatabase_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultDatabase_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCHEMA_SUFFIX_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object schemaSuffix_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The suffix that should be appended to all schema (BigQuery
     * dataset ID) names.
     * </pre>
     *
     * <code>string schema_suffix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The schemaSuffix.
     */
    @java.lang.Override
    public java.lang.String getSchemaSuffix() {
      java.lang.Object ref = schemaSuffix_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schemaSuffix_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The suffix that should be appended to all schema (BigQuery
     * dataset ID) names.
     * </pre>
     *
     * <code>string schema_suffix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for schemaSuffix.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSchemaSuffixBytes() {
      java.lang.Object ref = schemaSuffix_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schemaSuffix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TABLE_PREFIX_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object tablePrefix_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The prefix that should be prepended to all table names.
     * </pre>
     *
     * <code>string table_prefix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The tablePrefix.
     */
    @java.lang.Override
    public java.lang.String getTablePrefix() {
      java.lang.Object ref = tablePrefix_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tablePrefix_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The prefix that should be prepended to all table names.
     * </pre>
     *
     * <code>string table_prefix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for tablePrefix.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTablePrefixBytes() {
      java.lang.Object ref = tablePrefix_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tablePrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultDatabase_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, defaultDatabase_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schemaSuffix_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, schemaSuffix_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tablePrefix_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, tablePrefix_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultDatabase_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, defaultDatabase_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(schemaSuffix_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, schemaSuffix_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tablePrefix_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, tablePrefix_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides)) {
        return super.equals(obj);
      }
      com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides other =
          (com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides) obj;

      if (!getDefaultDatabase().equals(other.getDefaultDatabase())) return false;
      if (!getSchemaSuffix().equals(other.getSchemaSuffix())) return false;
      if (!getTablePrefix().equals(other.getTablePrefix())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DEFAULT_DATABASE_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultDatabase().hashCode();
      hash = (37 * hash) + SCHEMA_SUFFIX_FIELD_NUMBER;
      hash = (53 * hash) + getSchemaSuffix().hashCode();
      hash = (37 * hash) + TABLE_PREFIX_FIELD_NUMBER;
      hash = (53 * hash) + getTablePrefix().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Configures workspace compilation overrides for a repository.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides)
        com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverridesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_Repository_WorkspaceCompilationOverrides_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_Repository_WorkspaceCompilationOverrides_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides.class,
                com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        defaultDatabase_ = "";
        schemaSuffix_ = "";
        tablePrefix_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_Repository_WorkspaceCompilationOverrides_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides
          getDefaultInstanceForType() {
        return com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides build() {
        com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides buildPartial() {
        com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides result =
            new com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.defaultDatabase_ = defaultDatabase_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.schemaSuffix_ = schemaSuffix_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.tablePrefix_ = tablePrefix_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides) {
          return mergeFrom(
              (com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides other) {
        if (other
            == com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides
                .getDefaultInstance()) return this;
        if (!other.getDefaultDatabase().isEmpty()) {
          defaultDatabase_ = other.defaultDatabase_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getSchemaSuffix().isEmpty()) {
          schemaSuffix_ = other.schemaSuffix_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getTablePrefix().isEmpty()) {
          tablePrefix_ = other.tablePrefix_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  defaultDatabase_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  schemaSuffix_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  tablePrefix_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object defaultDatabase_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The default database (Google Cloud project ID).
       * </pre>
       *
       * <code>string default_database = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The defaultDatabase.
       */
      public java.lang.String getDefaultDatabase() {
        java.lang.Object ref = defaultDatabase_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          defaultDatabase_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The default database (Google Cloud project ID).
       * </pre>
       *
       * <code>string default_database = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for defaultDatabase.
       */
      public com.google.protobuf.ByteString getDefaultDatabaseBytes() {
        java.lang.Object ref = defaultDatabase_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          defaultDatabase_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The default database (Google Cloud project ID).
       * </pre>
       *
       * <code>string default_database = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The defaultDatabase to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultDatabase(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultDatabase_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The default database (Google Cloud project ID).
       * </pre>
       *
       * <code>string default_database = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDefaultDatabase() {
        defaultDatabase_ = getDefaultInstance().getDefaultDatabase();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The default database (Google Cloud project ID).
       * </pre>
       *
       * <code>string default_database = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for defaultDatabase to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultDatabaseBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        defaultDatabase_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object schemaSuffix_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The suffix that should be appended to all schema (BigQuery
       * dataset ID) names.
       * </pre>
       *
       * <code>string schema_suffix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The schemaSuffix.
       */
      public java.lang.String getSchemaSuffix() {
        java.lang.Object ref = schemaSuffix_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          schemaSuffix_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The suffix that should be appended to all schema (BigQuery
       * dataset ID) names.
       * </pre>
       *
       * <code>string schema_suffix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for schemaSuffix.
       */
      public com.google.protobuf.ByteString getSchemaSuffixBytes() {
        java.lang.Object ref = schemaSuffix_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          schemaSuffix_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The suffix that should be appended to all schema (BigQuery
       * dataset ID) names.
       * </pre>
       *
       * <code>string schema_suffix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The schemaSuffix to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaSuffix(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        schemaSuffix_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The suffix that should be appended to all schema (BigQuery
       * dataset ID) names.
       * </pre>
       *
       * <code>string schema_suffix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSchemaSuffix() {
        schemaSuffix_ = getDefaultInstance().getSchemaSuffix();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The suffix that should be appended to all schema (BigQuery
       * dataset ID) names.
       * </pre>
       *
       * <code>string schema_suffix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for schemaSuffix to set.
       * @return This builder for chaining.
       */
      public Builder setSchemaSuffixBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        schemaSuffix_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object tablePrefix_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The prefix that should be prepended to all table names.
       * </pre>
       *
       * <code>string table_prefix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The tablePrefix.
       */
      public java.lang.String getTablePrefix() {
        java.lang.Object ref = tablePrefix_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          tablePrefix_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The prefix that should be prepended to all table names.
       * </pre>
       *
       * <code>string table_prefix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for tablePrefix.
       */
      public com.google.protobuf.ByteString getTablePrefixBytes() {
        java.lang.Object ref = tablePrefix_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          tablePrefix_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The prefix that should be prepended to all table names.
       * </pre>
       *
       * <code>string table_prefix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The tablePrefix to set.
       * @return This builder for chaining.
       */
      public Builder setTablePrefix(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        tablePrefix_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The prefix that should be prepended to all table names.
       * </pre>
       *
       * <code>string table_prefix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTablePrefix() {
        tablePrefix_ = getDefaultInstance().getTablePrefix();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The prefix that should be prepended to all table names.
       * </pre>
       *
       * <code>string table_prefix = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for tablePrefix to set.
       * @return This builder for chaining.
       */
      public Builder setTablePrefixBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        tablePrefix_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides)
    private static final com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides();
    }

    public static com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WorkspaceCompilationOverrides> PARSER =
        new com.google.protobuf.AbstractParser<WorkspaceCompilationOverrides>() {
          @java.lang.Override
          public WorkspaceCompilationOverrides parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<WorkspaceCompilationOverrides> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WorkspaceCompilationOverrides> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Identifier. The repository's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Identifier. The repository's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 13;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the repository was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the repository was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the repository was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The repository's user-friendly name.
   * </pre>
   *
   * <code>string display_name = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The repository's user-friendly name.
   * </pre>
   *
   * <code>string display_name = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GIT_REMOTE_SETTINGS_FIELD_NUMBER = 2;
  private com.google.cloud.dataform.v1.Repository.GitRemoteSettings gitRemoteSettings_;

  /**
   *
   *
   * <pre>
   * Optional. If set, configures this repository to be linked to a Git remote.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.Repository.GitRemoteSettings git_remote_settings = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the gitRemoteSettings field is set.
   */
  @java.lang.Override
  public boolean hasGitRemoteSettings() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. If set, configures this repository to be linked to a Git remote.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.Repository.GitRemoteSettings git_remote_settings = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The gitRemoteSettings.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.Repository.GitRemoteSettings getGitRemoteSettings() {
    return gitRemoteSettings_ == null
        ? com.google.cloud.dataform.v1.Repository.GitRemoteSettings.getDefaultInstance()
        : gitRemoteSettings_;
  }

  /**
   *
   *
   * <pre>
   * Optional. If set, configures this repository to be linked to a Git remote.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.Repository.GitRemoteSettings git_remote_settings = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.Repository.GitRemoteSettingsOrBuilder
      getGitRemoteSettingsOrBuilder() {
    return gitRemoteSettings_ == null
        ? com.google.cloud.dataform.v1.Repository.GitRemoteSettings.getDefaultInstance()
        : gitRemoteSettings_;
  }

  public static final int NPMRC_ENVIRONMENT_VARIABLES_SECRET_VERSION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object npmrcEnvironmentVariablesSecretVersion_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The name of the Secret Manager secret version to be used to
   * interpolate variables into the .npmrc file for package installation
   * operations. Must be in the format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. The
   * file itself must be in a JSON format.
   * </pre>
   *
   * <code>
   * string npmrc_environment_variables_secret_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The npmrcEnvironmentVariablesSecretVersion.
   */
  @java.lang.Override
  public java.lang.String getNpmrcEnvironmentVariablesSecretVersion() {
    java.lang.Object ref = npmrcEnvironmentVariablesSecretVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      npmrcEnvironmentVariablesSecretVersion_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The name of the Secret Manager secret version to be used to
   * interpolate variables into the .npmrc file for package installation
   * operations. Must be in the format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. The
   * file itself must be in a JSON format.
   * </pre>
   *
   * <code>
   * string npmrc_environment_variables_secret_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for npmrcEnvironmentVariablesSecretVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNpmrcEnvironmentVariablesSecretVersionBytes() {
    java.lang.Object ref = npmrcEnvironmentVariablesSecretVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      npmrcEnvironmentVariablesSecretVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WORKSPACE_COMPILATION_OVERRIDES_FIELD_NUMBER = 4;
  private com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides
      workspaceCompilationOverrides_;

  /**
   *
   *
   * <pre>
   * Optional. If set, fields of `workspace_compilation_overrides` override the
   * default compilation settings that are specified in dataform.json when
   * creating workspace-scoped compilation results. See documentation for
   * `WorkspaceCompilationOverrides` for more information.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides workspace_compilation_overrides = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the workspaceCompilationOverrides field is set.
   */
  @java.lang.Override
  public boolean hasWorkspaceCompilationOverrides() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. If set, fields of `workspace_compilation_overrides` override the
   * default compilation settings that are specified in dataform.json when
   * creating workspace-scoped compilation results. See documentation for
   * `WorkspaceCompilationOverrides` for more information.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides workspace_compilation_overrides = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The workspaceCompilationOverrides.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides
      getWorkspaceCompilationOverrides() {
    return workspaceCompilationOverrides_ == null
        ? com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides.getDefaultInstance()
        : workspaceCompilationOverrides_;
  }

  /**
   *
   *
   * <pre>
   * Optional. If set, fields of `workspace_compilation_overrides` override the
   * default compilation settings that are specified in dataform.json when
   * creating workspace-scoped compilation results. See documentation for
   * `WorkspaceCompilationOverrides` for more information.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides workspace_compilation_overrides = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverridesOrBuilder
      getWorkspaceCompilationOverridesOrBuilder() {
    return workspaceCompilationOverrides_ == null
        ? com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides.getDefaultInstance()
        : workspaceCompilationOverrides_;
  }

  public static final int LABELS_FIELD_NUMBER = 5;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataform.v1.DataformProto
                .internal_static_google_cloud_dataform_v1_Repository_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Repository user labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Repository user labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Repository user labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. Repository user labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SET_AUTHENTICATED_USER_ADMIN_FIELD_NUMBER = 9;
  private boolean setAuthenticatedUserAdmin_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Input only. If set to true, the authenticated user will be
   * granted the roles/dataform.admin role on the created repository.
   * </pre>
   *
   * <code>
   * bool set_authenticated_user_admin = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The setAuthenticatedUserAdmin.
   */
  @java.lang.Override
  public boolean getSetAuthenticatedUserAdmin() {
    return setAuthenticatedUserAdmin_;
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The service account to run workflow invocations under.
   * </pre>
   *
   * <code>string service_account = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The service account to run workflow invocations under.
   * </pre>
   *
   * <code>string service_account = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KMS_KEY_NAME_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKeyName_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The reference to a KMS encryption key. If provided, it will be
   * used to encrypt user data in the repository and all child resources. It is
   * not possible to add or update the encryption key after the repository is
   * created. Example:
   * `projects/{kms_project}/locations/{location}/keyRings/{key_location}/cryptoKeys/{key}`
   * </pre>
   *
   * <code>
   * string kms_key_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The kmsKeyName.
   */
  @java.lang.Override
  public java.lang.String getKmsKeyName() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKeyName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The reference to a KMS encryption key. If provided, it will be
   * used to encrypt user data in the repository and all child resources. It is
   * not possible to add or update the encryption key after the repository is
   * created. Example:
   * `projects/{kms_project}/locations/{location}/keyRings/{key_location}/cryptoKeys/{key}`
   * </pre>
   *
   * <code>
   * string kms_key_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for kmsKeyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyNameBytes() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKeyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_ENCRYPTION_STATE_FIELD_NUMBER = 12;
  private com.google.cloud.dataform.v1.DataEncryptionState dataEncryptionState_;

  /**
   *
   *
   * <pre>
   * Output only. A data encryption state of a Git repository if this Repository
   * is protected by a KMS key.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the dataEncryptionState field is set.
   */
  @java.lang.Override
  public boolean hasDataEncryptionState() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. A data encryption state of a Git repository if this Repository
   * is protected by a KMS key.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The dataEncryptionState.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.DataEncryptionState getDataEncryptionState() {
    return dataEncryptionState_ == null
        ? com.google.cloud.dataform.v1.DataEncryptionState.getDefaultInstance()
        : dataEncryptionState_;
  }

  /**
   *
   *
   * <pre>
   * Output only. A data encryption state of a Git repository if this Repository
   * is protected by a KMS key.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.DataEncryptionStateOrBuilder
      getDataEncryptionStateOrBuilder() {
    return dataEncryptionState_ == null
        ? com.google.cloud.dataform.v1.DataEncryptionState.getDefaultInstance()
        : dataEncryptionState_;
  }

  public static final int INTERNAL_METADATA_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object internalMetadata_ = "";

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the internalMetadata field is set.
   */
  @java.lang.Override
  public boolean hasInternalMetadata() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The internalMetadata.
   */
  @java.lang.Override
  public java.lang.String getInternalMetadata() {
    java.lang.Object ref = internalMetadata_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      internalMetadata_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for internalMetadata.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInternalMetadataBytes() {
    java.lang.Object ref = internalMetadata_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      internalMetadata_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getGitRemoteSettings());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(
        npmrcEnvironmentVariablesSecretVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 3, npmrcEnvironmentVariablesSecretVersion_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getWorkspaceCompilationOverrides());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 5);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, displayName_);
    }
    if (setAuthenticatedUserAdmin_ != false) {
      output.writeBool(9, setAuthenticatedUserAdmin_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, kmsKeyName_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(12, getDataEncryptionState());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(13, getCreateTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, internalMetadata_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getGitRemoteSettings());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(
        npmrcEnvironmentVariablesSecretVersion_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              3, npmrcEnvironmentVariablesSecretVersion_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, getWorkspaceCompilationOverrides());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, displayName_);
    }
    if (setAuthenticatedUserAdmin_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, setAuthenticatedUserAdmin_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, serviceAccount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, kmsKeyName_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(12, getDataEncryptionState());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getCreateTime());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, internalMetadata_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataform.v1.Repository)) {
      return super.equals(obj);
    }
    com.google.cloud.dataform.v1.Repository other = (com.google.cloud.dataform.v1.Repository) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasGitRemoteSettings() != other.hasGitRemoteSettings()) return false;
    if (hasGitRemoteSettings()) {
      if (!getGitRemoteSettings().equals(other.getGitRemoteSettings())) return false;
    }
    if (!getNpmrcEnvironmentVariablesSecretVersion()
        .equals(other.getNpmrcEnvironmentVariablesSecretVersion())) return false;
    if (hasWorkspaceCompilationOverrides() != other.hasWorkspaceCompilationOverrides())
      return false;
    if (hasWorkspaceCompilationOverrides()) {
      if (!getWorkspaceCompilationOverrides().equals(other.getWorkspaceCompilationOverrides()))
        return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (getSetAuthenticatedUserAdmin() != other.getSetAuthenticatedUserAdmin()) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getKmsKeyName().equals(other.getKmsKeyName())) return false;
    if (hasDataEncryptionState() != other.hasDataEncryptionState()) return false;
    if (hasDataEncryptionState()) {
      if (!getDataEncryptionState().equals(other.getDataEncryptionState())) return false;
    }
    if (hasInternalMetadata() != other.hasInternalMetadata()) return false;
    if (hasInternalMetadata()) {
      if (!getInternalMetadata().equals(other.getInternalMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasGitRemoteSettings()) {
      hash = (37 * hash) + GIT_REMOTE_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getGitRemoteSettings().hashCode();
    }
    hash = (37 * hash) + NPMRC_ENVIRONMENT_VARIABLES_SECRET_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getNpmrcEnvironmentVariablesSecretVersion().hashCode();
    if (hasWorkspaceCompilationOverrides()) {
      hash = (37 * hash) + WORKSPACE_COMPILATION_OVERRIDES_FIELD_NUMBER;
      hash = (53 * hash) + getWorkspaceCompilationOverrides().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + SET_AUTHENTICATED_USER_ADMIN_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSetAuthenticatedUserAdmin());
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (37 * hash) + KMS_KEY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKeyName().hashCode();
    if (hasDataEncryptionState()) {
      hash = (37 * hash) + DATA_ENCRYPTION_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getDataEncryptionState().hashCode();
    }
    if (hasInternalMetadata()) {
      hash = (37 * hash) + INTERNAL_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getInternalMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataform.v1.Repository parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.Repository parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.Repository parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.Repository parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.Repository parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.Repository parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.Repository parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.Repository parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.Repository parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.Repository parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.Repository parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.Repository parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataform.v1.Repository prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a Dataform Git repository.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.Repository}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.Repository)
      com.google.cloud.dataform.v1.RepositoryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_Repository_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_Repository_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.Repository.class,
              com.google.cloud.dataform.v1.Repository.Builder.class);
    }

    // Construct using com.google.cloud.dataform.v1.Repository.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getGitRemoteSettingsFieldBuilder();
        getWorkspaceCompilationOverridesFieldBuilder();
        getDataEncryptionStateFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      displayName_ = "";
      gitRemoteSettings_ = null;
      if (gitRemoteSettingsBuilder_ != null) {
        gitRemoteSettingsBuilder_.dispose();
        gitRemoteSettingsBuilder_ = null;
      }
      npmrcEnvironmentVariablesSecretVersion_ = "";
      workspaceCompilationOverrides_ = null;
      if (workspaceCompilationOverridesBuilder_ != null) {
        workspaceCompilationOverridesBuilder_.dispose();
        workspaceCompilationOverridesBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      setAuthenticatedUserAdmin_ = false;
      serviceAccount_ = "";
      kmsKeyName_ = "";
      dataEncryptionState_ = null;
      if (dataEncryptionStateBuilder_ != null) {
        dataEncryptionStateBuilder_.dispose();
        dataEncryptionStateBuilder_ = null;
      }
      internalMetadata_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_Repository_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.Repository getDefaultInstanceForType() {
      return com.google.cloud.dataform.v1.Repository.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.Repository build() {
      com.google.cloud.dataform.v1.Repository result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.Repository buildPartial() {
      com.google.cloud.dataform.v1.Repository result =
          new com.google.cloud.dataform.v1.Repository(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataform.v1.Repository result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.gitRemoteSettings_ =
            gitRemoteSettingsBuilder_ == null
                ? gitRemoteSettings_
                : gitRemoteSettingsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.npmrcEnvironmentVariablesSecretVersion_ = npmrcEnvironmentVariablesSecretVersion_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.workspaceCompilationOverrides_ =
            workspaceCompilationOverridesBuilder_ == null
                ? workspaceCompilationOverrides_
                : workspaceCompilationOverridesBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.setAuthenticatedUserAdmin_ = setAuthenticatedUserAdmin_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.kmsKeyName_ = kmsKeyName_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.dataEncryptionState_ =
            dataEncryptionStateBuilder_ == null
                ? dataEncryptionState_
                : dataEncryptionStateBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.internalMetadata_ = internalMetadata_;
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataform.v1.Repository) {
        return mergeFrom((com.google.cloud.dataform.v1.Repository) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataform.v1.Repository other) {
      if (other == com.google.cloud.dataform.v1.Repository.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasGitRemoteSettings()) {
        mergeGitRemoteSettings(other.getGitRemoteSettings());
      }
      if (!other.getNpmrcEnvironmentVariablesSecretVersion().isEmpty()) {
        npmrcEnvironmentVariablesSecretVersion_ = other.npmrcEnvironmentVariablesSecretVersion_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasWorkspaceCompilationOverrides()) {
        mergeWorkspaceCompilationOverrides(other.getWorkspaceCompilationOverrides());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000040;
      if (other.getSetAuthenticatedUserAdmin() != false) {
        setSetAuthenticatedUserAdmin(other.getSetAuthenticatedUserAdmin());
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getKmsKeyName().isEmpty()) {
        kmsKeyName_ = other.kmsKeyName_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasDataEncryptionState()) {
        mergeDataEncryptionState(other.getDataEncryptionState());
      }
      if (other.hasInternalMetadata()) {
        internalMetadata_ = other.internalMetadata_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getGitRemoteSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 26:
              {
                npmrcEnvironmentVariablesSecretVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getWorkspaceCompilationOverridesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 42
            case 66:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 66
            case 72:
              {
                setAuthenticatedUserAdmin_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 72
            case 82:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 90:
              {
                kmsKeyName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getDataEncryptionStateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 106
            case 122:
              {
                internalMetadata_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Identifier. The repository's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The repository's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The repository's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The repository's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The repository's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the repository was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the repository was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the repository was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the repository was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the repository was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the repository was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the repository was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the repository was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the repository was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The repository's user-friendly name.
     * </pre>
     *
     * <code>string display_name = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The repository's user-friendly name.
     * </pre>
     *
     * <code>string display_name = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The repository's user-friendly name.
     * </pre>
     *
     * <code>string display_name = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The repository's user-friendly name.
     * </pre>
     *
     * <code>string display_name = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The repository's user-friendly name.
     * </pre>
     *
     * <code>string display_name = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.dataform.v1.Repository.GitRemoteSettings gitRemoteSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.Repository.GitRemoteSettings,
            com.google.cloud.dataform.v1.Repository.GitRemoteSettings.Builder,
            com.google.cloud.dataform.v1.Repository.GitRemoteSettingsOrBuilder>
        gitRemoteSettingsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. If set, configures this repository to be linked to a Git remote.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.GitRemoteSettings git_remote_settings = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the gitRemoteSettings field is set.
     */
    public boolean hasGitRemoteSettings() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, configures this repository to be linked to a Git remote.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.GitRemoteSettings git_remote_settings = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The gitRemoteSettings.
     */
    public com.google.cloud.dataform.v1.Repository.GitRemoteSettings getGitRemoteSettings() {
      if (gitRemoteSettingsBuilder_ == null) {
        return gitRemoteSettings_ == null
            ? com.google.cloud.dataform.v1.Repository.GitRemoteSettings.getDefaultInstance()
            : gitRemoteSettings_;
      } else {
        return gitRemoteSettingsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, configures this repository to be linked to a Git remote.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.GitRemoteSettings git_remote_settings = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGitRemoteSettings(
        com.google.cloud.dataform.v1.Repository.GitRemoteSettings value) {
      if (gitRemoteSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gitRemoteSettings_ = value;
      } else {
        gitRemoteSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, configures this repository to be linked to a Git remote.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.GitRemoteSettings git_remote_settings = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGitRemoteSettings(
        com.google.cloud.dataform.v1.Repository.GitRemoteSettings.Builder builderForValue) {
      if (gitRemoteSettingsBuilder_ == null) {
        gitRemoteSettings_ = builderForValue.build();
      } else {
        gitRemoteSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, configures this repository to be linked to a Git remote.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.GitRemoteSettings git_remote_settings = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGitRemoteSettings(
        com.google.cloud.dataform.v1.Repository.GitRemoteSettings value) {
      if (gitRemoteSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && gitRemoteSettings_ != null
            && gitRemoteSettings_
                != com.google.cloud.dataform.v1.Repository.GitRemoteSettings.getDefaultInstance()) {
          getGitRemoteSettingsBuilder().mergeFrom(value);
        } else {
          gitRemoteSettings_ = value;
        }
      } else {
        gitRemoteSettingsBuilder_.mergeFrom(value);
      }
      if (gitRemoteSettings_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, configures this repository to be linked to a Git remote.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.GitRemoteSettings git_remote_settings = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGitRemoteSettings() {
      bitField0_ = (bitField0_ & ~0x00000008);
      gitRemoteSettings_ = null;
      if (gitRemoteSettingsBuilder_ != null) {
        gitRemoteSettingsBuilder_.dispose();
        gitRemoteSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, configures this repository to be linked to a Git remote.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.GitRemoteSettings git_remote_settings = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataform.v1.Repository.GitRemoteSettings.Builder
        getGitRemoteSettingsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getGitRemoteSettingsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, configures this repository to be linked to a Git remote.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.GitRemoteSettings git_remote_settings = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataform.v1.Repository.GitRemoteSettingsOrBuilder
        getGitRemoteSettingsOrBuilder() {
      if (gitRemoteSettingsBuilder_ != null) {
        return gitRemoteSettingsBuilder_.getMessageOrBuilder();
      } else {
        return gitRemoteSettings_ == null
            ? com.google.cloud.dataform.v1.Repository.GitRemoteSettings.getDefaultInstance()
            : gitRemoteSettings_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, configures this repository to be linked to a Git remote.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.GitRemoteSettings git_remote_settings = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.Repository.GitRemoteSettings,
            com.google.cloud.dataform.v1.Repository.GitRemoteSettings.Builder,
            com.google.cloud.dataform.v1.Repository.GitRemoteSettingsOrBuilder>
        getGitRemoteSettingsFieldBuilder() {
      if (gitRemoteSettingsBuilder_ == null) {
        gitRemoteSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.Repository.GitRemoteSettings,
                com.google.cloud.dataform.v1.Repository.GitRemoteSettings.Builder,
                com.google.cloud.dataform.v1.Repository.GitRemoteSettingsOrBuilder>(
                getGitRemoteSettings(), getParentForChildren(), isClean());
        gitRemoteSettings_ = null;
      }
      return gitRemoteSettingsBuilder_;
    }

    private java.lang.Object npmrcEnvironmentVariablesSecretVersion_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The name of the Secret Manager secret version to be used to
     * interpolate variables into the .npmrc file for package installation
     * operations. Must be in the format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. The
     * file itself must be in a JSON format.
     * </pre>
     *
     * <code>
     * string npmrc_environment_variables_secret_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The npmrcEnvironmentVariablesSecretVersion.
     */
    public java.lang.String getNpmrcEnvironmentVariablesSecretVersion() {
      java.lang.Object ref = npmrcEnvironmentVariablesSecretVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        npmrcEnvironmentVariablesSecretVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the Secret Manager secret version to be used to
     * interpolate variables into the .npmrc file for package installation
     * operations. Must be in the format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. The
     * file itself must be in a JSON format.
     * </pre>
     *
     * <code>
     * string npmrc_environment_variables_secret_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for npmrcEnvironmentVariablesSecretVersion.
     */
    public com.google.protobuf.ByteString getNpmrcEnvironmentVariablesSecretVersionBytes() {
      java.lang.Object ref = npmrcEnvironmentVariablesSecretVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        npmrcEnvironmentVariablesSecretVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the Secret Manager secret version to be used to
     * interpolate variables into the .npmrc file for package installation
     * operations. Must be in the format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. The
     * file itself must be in a JSON format.
     * </pre>
     *
     * <code>
     * string npmrc_environment_variables_secret_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The npmrcEnvironmentVariablesSecretVersion to set.
     * @return This builder for chaining.
     */
    public Builder setNpmrcEnvironmentVariablesSecretVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      npmrcEnvironmentVariablesSecretVersion_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the Secret Manager secret version to be used to
     * interpolate variables into the .npmrc file for package installation
     * operations. Must be in the format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. The
     * file itself must be in a JSON format.
     * </pre>
     *
     * <code>
     * string npmrc_environment_variables_secret_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNpmrcEnvironmentVariablesSecretVersion() {
      npmrcEnvironmentVariablesSecretVersion_ =
          getDefaultInstance().getNpmrcEnvironmentVariablesSecretVersion();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the Secret Manager secret version to be used to
     * interpolate variables into the .npmrc file for package installation
     * operations. Must be in the format `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. The
     * file itself must be in a JSON format.
     * </pre>
     *
     * <code>
     * string npmrc_environment_variables_secret_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for npmrcEnvironmentVariablesSecretVersion to set.
     * @return This builder for chaining.
     */
    public Builder setNpmrcEnvironmentVariablesSecretVersionBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      npmrcEnvironmentVariablesSecretVersion_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides
        workspaceCompilationOverrides_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides,
            com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides.Builder,
            com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverridesOrBuilder>
        workspaceCompilationOverridesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. If set, fields of `workspace_compilation_overrides` override the
     * default compilation settings that are specified in dataform.json when
     * creating workspace-scoped compilation results. See documentation for
     * `WorkspaceCompilationOverrides` for more information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides workspace_compilation_overrides = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the workspaceCompilationOverrides field is set.
     */
    public boolean hasWorkspaceCompilationOverrides() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, fields of `workspace_compilation_overrides` override the
     * default compilation settings that are specified in dataform.json when
     * creating workspace-scoped compilation results. See documentation for
     * `WorkspaceCompilationOverrides` for more information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides workspace_compilation_overrides = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The workspaceCompilationOverrides.
     */
    public com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides
        getWorkspaceCompilationOverrides() {
      if (workspaceCompilationOverridesBuilder_ == null) {
        return workspaceCompilationOverrides_ == null
            ? com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides
                .getDefaultInstance()
            : workspaceCompilationOverrides_;
      } else {
        return workspaceCompilationOverridesBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, fields of `workspace_compilation_overrides` override the
     * default compilation settings that are specified in dataform.json when
     * creating workspace-scoped compilation results. See documentation for
     * `WorkspaceCompilationOverrides` for more information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides workspace_compilation_overrides = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWorkspaceCompilationOverrides(
        com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides value) {
      if (workspaceCompilationOverridesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        workspaceCompilationOverrides_ = value;
      } else {
        workspaceCompilationOverridesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, fields of `workspace_compilation_overrides` override the
     * default compilation settings that are specified in dataform.json when
     * creating workspace-scoped compilation results. See documentation for
     * `WorkspaceCompilationOverrides` for more information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides workspace_compilation_overrides = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setWorkspaceCompilationOverrides(
        com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides.Builder
            builderForValue) {
      if (workspaceCompilationOverridesBuilder_ == null) {
        workspaceCompilationOverrides_ = builderForValue.build();
      } else {
        workspaceCompilationOverridesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, fields of `workspace_compilation_overrides` override the
     * default compilation settings that are specified in dataform.json when
     * creating workspace-scoped compilation results. See documentation for
     * `WorkspaceCompilationOverrides` for more information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides workspace_compilation_overrides = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeWorkspaceCompilationOverrides(
        com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides value) {
      if (workspaceCompilationOverridesBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && workspaceCompilationOverrides_ != null
            && workspaceCompilationOverrides_
                != com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides
                    .getDefaultInstance()) {
          getWorkspaceCompilationOverridesBuilder().mergeFrom(value);
        } else {
          workspaceCompilationOverrides_ = value;
        }
      } else {
        workspaceCompilationOverridesBuilder_.mergeFrom(value);
      }
      if (workspaceCompilationOverrides_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, fields of `workspace_compilation_overrides` override the
     * default compilation settings that are specified in dataform.json when
     * creating workspace-scoped compilation results. See documentation for
     * `WorkspaceCompilationOverrides` for more information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides workspace_compilation_overrides = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearWorkspaceCompilationOverrides() {
      bitField0_ = (bitField0_ & ~0x00000020);
      workspaceCompilationOverrides_ = null;
      if (workspaceCompilationOverridesBuilder_ != null) {
        workspaceCompilationOverridesBuilder_.dispose();
        workspaceCompilationOverridesBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, fields of `workspace_compilation_overrides` override the
     * default compilation settings that are specified in dataform.json when
     * creating workspace-scoped compilation results. See documentation for
     * `WorkspaceCompilationOverrides` for more information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides workspace_compilation_overrides = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides.Builder
        getWorkspaceCompilationOverridesBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getWorkspaceCompilationOverridesFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, fields of `workspace_compilation_overrides` override the
     * default compilation settings that are specified in dataform.json when
     * creating workspace-scoped compilation results. See documentation for
     * `WorkspaceCompilationOverrides` for more information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides workspace_compilation_overrides = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverridesOrBuilder
        getWorkspaceCompilationOverridesOrBuilder() {
      if (workspaceCompilationOverridesBuilder_ != null) {
        return workspaceCompilationOverridesBuilder_.getMessageOrBuilder();
      } else {
        return workspaceCompilationOverrides_ == null
            ? com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides
                .getDefaultInstance()
            : workspaceCompilationOverrides_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, fields of `workspace_compilation_overrides` override the
     * default compilation settings that are specified in dataform.json when
     * creating workspace-scoped compilation results. See documentation for
     * `WorkspaceCompilationOverrides` for more information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides workspace_compilation_overrides = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides,
            com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides.Builder,
            com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverridesOrBuilder>
        getWorkspaceCompilationOverridesFieldBuilder() {
      if (workspaceCompilationOverridesBuilder_ == null) {
        workspaceCompilationOverridesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides,
                com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverrides.Builder,
                com.google.cloud.dataform.v1.Repository.WorkspaceCompilationOverridesOrBuilder>(
                getWorkspaceCompilationOverrides(), getParentForChildren(), isClean());
        workspaceCompilationOverrides_ = null;
      }
      return workspaceCompilationOverridesBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Repository user labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Repository user labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Repository user labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. Repository user labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Repository user labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Repository user labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Repository user labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private boolean setAuthenticatedUserAdmin_;

    /**
     *
     *
     * <pre>
     * Optional. Input only. If set to true, the authenticated user will be
     * granted the roles/dataform.admin role on the created repository.
     * </pre>
     *
     * <code>
     * bool set_authenticated_user_admin = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The setAuthenticatedUserAdmin.
     */
    @java.lang.Override
    public boolean getSetAuthenticatedUserAdmin() {
      return setAuthenticatedUserAdmin_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. If set to true, the authenticated user will be
     * granted the roles/dataform.admin role on the created repository.
     * </pre>
     *
     * <code>
     * bool set_authenticated_user_admin = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @param value The setAuthenticatedUserAdmin to set.
     * @return This builder for chaining.
     */
    public Builder setSetAuthenticatedUserAdmin(boolean value) {

      setAuthenticatedUserAdmin_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Input only. If set to true, the authenticated user will be
     * granted the roles/dataform.admin role on the created repository.
     * </pre>
     *
     * <code>
     * bool set_authenticated_user_admin = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSetAuthenticatedUserAdmin() {
      bitField0_ = (bitField0_ & ~0x00000080);
      setAuthenticatedUserAdmin_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The service account to run workflow invocations under.
     * </pre>
     *
     * <code>string service_account = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The service account to run workflow invocations under.
     * </pre>
     *
     * <code>string service_account = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The service account to run workflow invocations under.
     * </pre>
     *
     * <code>string service_account = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The service account to run workflow invocations under.
     * </pre>
     *
     * <code>string service_account = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The service account to run workflow invocations under.
     * </pre>
     *
     * <code>string service_account = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKeyName_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The reference to a KMS encryption key. If provided, it will be
     * used to encrypt user data in the repository and all child resources. It is
     * not possible to add or update the encryption key after the repository is
     * created. Example:
     * `projects/{kms_project}/locations/{location}/keyRings/{key_location}/cryptoKeys/{key}`
     * </pre>
     *
     * <code>
     * string kms_key_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The kmsKeyName.
     */
    public java.lang.String getKmsKeyName() {
      java.lang.Object ref = kmsKeyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The reference to a KMS encryption key. If provided, it will be
     * used to encrypt user data in the repository and all child resources. It is
     * not possible to add or update the encryption key after the repository is
     * created. Example:
     * `projects/{kms_project}/locations/{location}/keyRings/{key_location}/cryptoKeys/{key}`
     * </pre>
     *
     * <code>
     * string kms_key_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for kmsKeyName.
     */
    public com.google.protobuf.ByteString getKmsKeyNameBytes() {
      java.lang.Object ref = kmsKeyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The reference to a KMS encryption key. If provided, it will be
     * used to encrypt user data in the repository and all child resources. It is
     * not possible to add or update the encryption key after the repository is
     * created. Example:
     * `projects/{kms_project}/locations/{location}/keyRings/{key_location}/cryptoKeys/{key}`
     * </pre>
     *
     * <code>
     * string kms_key_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKeyName_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The reference to a KMS encryption key. If provided, it will be
     * used to encrypt user data in the repository and all child resources. It is
     * not possible to add or update the encryption key after the repository is
     * created. Example:
     * `projects/{kms_project}/locations/{location}/keyRings/{key_location}/cryptoKeys/{key}`
     * </pre>
     *
     * <code>
     * string kms_key_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyName() {
      kmsKeyName_ = getDefaultInstance().getKmsKeyName();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The reference to a KMS encryption key. If provided, it will be
     * used to encrypt user data in the repository and all child resources. It is
     * not possible to add or update the encryption key after the repository is
     * created. Example:
     * `projects/{kms_project}/locations/{location}/keyRings/{key_location}/cryptoKeys/{key}`
     * </pre>
     *
     * <code>
     * string kms_key_name = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKeyName_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.cloud.dataform.v1.DataEncryptionState dataEncryptionState_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.DataEncryptionState,
            com.google.cloud.dataform.v1.DataEncryptionState.Builder,
            com.google.cloud.dataform.v1.DataEncryptionStateOrBuilder>
        dataEncryptionStateBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. A data encryption state of a Git repository if this Repository
     * is protected by a KMS key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the dataEncryptionState field is set.
     */
    public boolean hasDataEncryptionState() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. A data encryption state of a Git repository if this Repository
     * is protected by a KMS key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The dataEncryptionState.
     */
    public com.google.cloud.dataform.v1.DataEncryptionState getDataEncryptionState() {
      if (dataEncryptionStateBuilder_ == null) {
        return dataEncryptionState_ == null
            ? com.google.cloud.dataform.v1.DataEncryptionState.getDefaultInstance()
            : dataEncryptionState_;
      } else {
        return dataEncryptionStateBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A data encryption state of a Git repository if this Repository
     * is protected by a KMS key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDataEncryptionState(com.google.cloud.dataform.v1.DataEncryptionState value) {
      if (dataEncryptionStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataEncryptionState_ = value;
      } else {
        dataEncryptionStateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A data encryption state of a Git repository if this Repository
     * is protected by a KMS key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDataEncryptionState(
        com.google.cloud.dataform.v1.DataEncryptionState.Builder builderForValue) {
      if (dataEncryptionStateBuilder_ == null) {
        dataEncryptionState_ = builderForValue.build();
      } else {
        dataEncryptionStateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A data encryption state of a Git repository if this Repository
     * is protected by a KMS key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDataEncryptionState(
        com.google.cloud.dataform.v1.DataEncryptionState value) {
      if (dataEncryptionStateBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && dataEncryptionState_ != null
            && dataEncryptionState_
                != com.google.cloud.dataform.v1.DataEncryptionState.getDefaultInstance()) {
          getDataEncryptionStateBuilder().mergeFrom(value);
        } else {
          dataEncryptionState_ = value;
        }
      } else {
        dataEncryptionStateBuilder_.mergeFrom(value);
      }
      if (dataEncryptionState_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A data encryption state of a Git repository if this Repository
     * is protected by a KMS key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDataEncryptionState() {
      bitField0_ = (bitField0_ & ~0x00000400);
      dataEncryptionState_ = null;
      if (dataEncryptionStateBuilder_ != null) {
        dataEncryptionStateBuilder_.dispose();
        dataEncryptionStateBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A data encryption state of a Git repository if this Repository
     * is protected by a KMS key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.DataEncryptionState.Builder
        getDataEncryptionStateBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getDataEncryptionStateFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. A data encryption state of a Git repository if this Repository
     * is protected by a KMS key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.DataEncryptionStateOrBuilder
        getDataEncryptionStateOrBuilder() {
      if (dataEncryptionStateBuilder_ != null) {
        return dataEncryptionStateBuilder_.getMessageOrBuilder();
      } else {
        return dataEncryptionState_ == null
            ? com.google.cloud.dataform.v1.DataEncryptionState.getDefaultInstance()
            : dataEncryptionState_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A data encryption state of a Git repository if this Repository
     * is protected by a KMS key.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.DataEncryptionState data_encryption_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.DataEncryptionState,
            com.google.cloud.dataform.v1.DataEncryptionState.Builder,
            com.google.cloud.dataform.v1.DataEncryptionStateOrBuilder>
        getDataEncryptionStateFieldBuilder() {
      if (dataEncryptionStateBuilder_ == null) {
        dataEncryptionStateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.DataEncryptionState,
                com.google.cloud.dataform.v1.DataEncryptionState.Builder,
                com.google.cloud.dataform.v1.DataEncryptionStateOrBuilder>(
                getDataEncryptionState(), getParentForChildren(), isClean());
        dataEncryptionState_ = null;
      }
      return dataEncryptionStateBuilder_;
    }

    private java.lang.Object internalMetadata_ = "";

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the internalMetadata field is set.
     */
    public boolean hasInternalMetadata() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The internalMetadata.
     */
    public java.lang.String getInternalMetadata() {
      java.lang.Object ref = internalMetadata_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        internalMetadata_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for internalMetadata.
     */
    public com.google.protobuf.ByteString getInternalMetadataBytes() {
      java.lang.Object ref = internalMetadata_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        internalMetadata_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The internalMetadata to set.
     * @return This builder for chaining.
     */
    public Builder setInternalMetadata(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      internalMetadata_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInternalMetadata() {
      internalMetadata_ = getDefaultInstance().getInternalMetadata();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for internalMetadata to set.
     * @return This builder for chaining.
     */
    public Builder setInternalMetadataBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      internalMetadata_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.Repository)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.Repository)
  private static final com.google.cloud.dataform.v1.Repository DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.Repository();
  }

  public static com.google.cloud.dataform.v1.Repository getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Repository> PARSER =
      new com.google.protobuf.AbstractParser<Repository>() {
        @java.lang.Override
        public Repository parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Repository> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Repository> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataform.v1.Repository getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
