/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataform/v1/dataform.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.dataform.v1;

/**
 *
 *
 * <pre>
 * Represents a Dataform release configuration.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataform.v1.ReleaseConfig}
 */
public final class ReleaseConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.ReleaseConfig)
    ReleaseConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ReleaseConfig.newBuilder() to construct.
  private ReleaseConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReleaseConfig() {
    name_ = "";
    gitCommitish_ = "";
    cronSchedule_ = "";
    timeZone_ = "";
    recentScheduledReleaseRecords_ = java.util.Collections.emptyList();
    releaseCompilationResult_ = "";
    internalMetadata_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReleaseConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_ReleaseConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_ReleaseConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataform.v1.ReleaseConfig.class,
            com.google.cloud.dataform.v1.ReleaseConfig.Builder.class);
  }

  public interface ScheduledReleaseRecordOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the created compilation result, if one was successfully
     * created. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>string compilation_result = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the compilationResult field is set.
     */
    boolean hasCompilationResult();

    /**
     *
     *
     * <pre>
     * The name of the created compilation result, if one was successfully
     * created. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>string compilation_result = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The compilationResult.
     */
    java.lang.String getCompilationResult();

    /**
     *
     *
     * <pre>
     * The name of the created compilation result, if one was successfully
     * created. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>string compilation_result = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for compilationResult.
     */
    com.google.protobuf.ByteString getCompilationResultBytes();

    /**
     *
     *
     * <pre>
     * The error status encountered upon this attempt to create the
     * compilation result, if the attempt was unsuccessful.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     *
     * @return Whether the errorStatus field is set.
     */
    boolean hasErrorStatus();

    /**
     *
     *
     * <pre>
     * The error status encountered upon this attempt to create the
     * compilation result, if the attempt was unsuccessful.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     *
     * @return The errorStatus.
     */
    com.google.rpc.Status getErrorStatus();

    /**
     *
     *
     * <pre>
     * The error status encountered upon this attempt to create the
     * compilation result, if the attempt was unsuccessful.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     */
    com.google.rpc.StatusOrBuilder getErrorStatusOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of this release attempt.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp release_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the releaseTime field is set.
     */
    boolean hasReleaseTime();

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of this release attempt.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp release_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The releaseTime.
     */
    com.google.protobuf.Timestamp getReleaseTime();

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of this release attempt.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp release_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getReleaseTimeOrBuilder();

    com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord.ResultCase getResultCase();
  }

  /**
   *
   *
   * <pre>
   * A record of an attempt to create a compilation result for this release
   * config.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord}
   */
  public static final class ScheduledReleaseRecord extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord)
      ScheduledReleaseRecordOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ScheduledReleaseRecord.newBuilder() to construct.
    private ScheduledReleaseRecord(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ScheduledReleaseRecord() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ScheduledReleaseRecord();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_ReleaseConfig_ScheduledReleaseRecord_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_ReleaseConfig_ScheduledReleaseRecord_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord.class,
              com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord.Builder.class);
    }

    private int bitField0_;
    private int resultCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object result_;

    public enum ResultCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      COMPILATION_RESULT(2),
      ERROR_STATUS(3),
      RESULT_NOT_SET(0);
      private final int value;

      private ResultCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ResultCase valueOf(int value) {
        return forNumber(value);
      }

      public static ResultCase forNumber(int value) {
        switch (value) {
          case 2:
            return COMPILATION_RESULT;
          case 3:
            return ERROR_STATUS;
          case 0:
            return RESULT_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ResultCase getResultCase() {
      return ResultCase.forNumber(resultCase_);
    }

    public static final int COMPILATION_RESULT_FIELD_NUMBER = 2;

    /**
     *
     *
     * <pre>
     * The name of the created compilation result, if one was successfully
     * created. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>string compilation_result = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the compilationResult field is set.
     */
    public boolean hasCompilationResult() {
      return resultCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * The name of the created compilation result, if one was successfully
     * created. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>string compilation_result = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The compilationResult.
     */
    public java.lang.String getCompilationResult() {
      java.lang.Object ref = "";
      if (resultCase_ == 2) {
        ref = result_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (resultCase_ == 2) {
          result_ = s;
        }
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the created compilation result, if one was successfully
     * created. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>string compilation_result = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for compilationResult.
     */
    public com.google.protobuf.ByteString getCompilationResultBytes() {
      java.lang.Object ref = "";
      if (resultCase_ == 2) {
        ref = result_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (resultCase_ == 2) {
          result_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ERROR_STATUS_FIELD_NUMBER = 3;

    /**
     *
     *
     * <pre>
     * The error status encountered upon this attempt to create the
     * compilation result, if the attempt was unsuccessful.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     *
     * @return Whether the errorStatus field is set.
     */
    @java.lang.Override
    public boolean hasErrorStatus() {
      return resultCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * The error status encountered upon this attempt to create the
     * compilation result, if the attempt was unsuccessful.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     *
     * @return The errorStatus.
     */
    @java.lang.Override
    public com.google.rpc.Status getErrorStatus() {
      if (resultCase_ == 3) {
        return (com.google.rpc.Status) result_;
      }
      return com.google.rpc.Status.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * The error status encountered upon this attempt to create the
     * compilation result, if the attempt was unsuccessful.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     */
    @java.lang.Override
    public com.google.rpc.StatusOrBuilder getErrorStatusOrBuilder() {
      if (resultCase_ == 3) {
        return (com.google.rpc.Status) result_;
      }
      return com.google.rpc.Status.getDefaultInstance();
    }

    public static final int RELEASE_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp releaseTime_;

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of this release attempt.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp release_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the releaseTime field is set.
     */
    @java.lang.Override
    public boolean hasReleaseTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of this release attempt.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp release_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The releaseTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getReleaseTime() {
      return releaseTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : releaseTime_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of this release attempt.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp release_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getReleaseTimeOrBuilder() {
      return releaseTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : releaseTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getReleaseTime());
      }
      if (resultCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, result_);
      }
      if (resultCase_ == 3) {
        output.writeMessage(3, (com.google.rpc.Status) result_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getReleaseTime());
      }
      if (resultCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, result_);
      }
      if (resultCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.rpc.Status) result_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord)) {
        return super.equals(obj);
      }
      com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord other =
          (com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord) obj;

      if (hasReleaseTime() != other.hasReleaseTime()) return false;
      if (hasReleaseTime()) {
        if (!getReleaseTime().equals(other.getReleaseTime())) return false;
      }
      if (!getResultCase().equals(other.getResultCase())) return false;
      switch (resultCase_) {
        case 2:
          if (!getCompilationResult().equals(other.getCompilationResult())) return false;
          break;
        case 3:
          if (!getErrorStatus().equals(other.getErrorStatus())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasReleaseTime()) {
        hash = (37 * hash) + RELEASE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getReleaseTime().hashCode();
      }
      switch (resultCase_) {
        case 2:
          hash = (37 * hash) + COMPILATION_RESULT_FIELD_NUMBER;
          hash = (53 * hash) + getCompilationResult().hashCode();
          break;
        case 3:
          hash = (37 * hash) + ERROR_STATUS_FIELD_NUMBER;
          hash = (53 * hash) + getErrorStatus().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A record of an attempt to create a compilation result for this release
     * config.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord)
        com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecordOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_ReleaseConfig_ScheduledReleaseRecord_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_ReleaseConfig_ScheduledReleaseRecord_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord.class,
                com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord.Builder.class);
      }

      // Construct using
      // com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getReleaseTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (errorStatusBuilder_ != null) {
          errorStatusBuilder_.clear();
        }
        releaseTime_ = null;
        if (releaseTimeBuilder_ != null) {
          releaseTimeBuilder_.dispose();
          releaseTimeBuilder_ = null;
        }
        resultCase_ = 0;
        result_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_ReleaseConfig_ScheduledReleaseRecord_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord
          getDefaultInstanceForType() {
        return com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord build() {
        com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord buildPartial() {
        com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord result =
            new com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.releaseTime_ =
              releaseTimeBuilder_ == null ? releaseTime_ : releaseTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord result) {
        result.resultCase_ = resultCase_;
        result.result_ = this.result_;
        if (resultCase_ == 3 && errorStatusBuilder_ != null) {
          result.result_ = errorStatusBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord) {
          return mergeFrom(
              (com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord other) {
        if (other
            == com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord
                .getDefaultInstance()) return this;
        if (other.hasReleaseTime()) {
          mergeReleaseTime(other.getReleaseTime());
        }
        switch (other.getResultCase()) {
          case COMPILATION_RESULT:
            {
              resultCase_ = 2;
              result_ = other.result_;
              onChanged();
              break;
            }
          case ERROR_STATUS:
            {
              mergeErrorStatus(other.getErrorStatus());
              break;
            }
          case RESULT_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getReleaseTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  resultCase_ = 2;
                  result_ = s;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getErrorStatusFieldBuilder().getBuilder(), extensionRegistry);
                  resultCase_ = 3;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int resultCase_ = 0;
      private java.lang.Object result_;

      public ResultCase getResultCase() {
        return ResultCase.forNumber(resultCase_);
      }

      public Builder clearResult() {
        resultCase_ = 0;
        result_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * The name of the created compilation result, if one was successfully
       * created. Must be in the format
       * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
       * </pre>
       *
       * <code>string compilation_result = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return Whether the compilationResult field is set.
       */
      @java.lang.Override
      public boolean hasCompilationResult() {
        return resultCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * The name of the created compilation result, if one was successfully
       * created. Must be in the format
       * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
       * </pre>
       *
       * <code>string compilation_result = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The compilationResult.
       */
      @java.lang.Override
      public java.lang.String getCompilationResult() {
        java.lang.Object ref = "";
        if (resultCase_ == 2) {
          ref = result_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (resultCase_ == 2) {
            result_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the created compilation result, if one was successfully
       * created. Must be in the format
       * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
       * </pre>
       *
       * <code>string compilation_result = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for compilationResult.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getCompilationResultBytes() {
        java.lang.Object ref = "";
        if (resultCase_ == 2) {
          ref = result_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (resultCase_ == 2) {
            result_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the created compilation result, if one was successfully
       * created. Must be in the format
       * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
       * </pre>
       *
       * <code>string compilation_result = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The compilationResult to set.
       * @return This builder for chaining.
       */
      public Builder setCompilationResult(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        resultCase_ = 2;
        result_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the created compilation result, if one was successfully
       * created. Must be in the format
       * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
       * </pre>
       *
       * <code>string compilation_result = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCompilationResult() {
        if (resultCase_ == 2) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the created compilation result, if one was successfully
       * created. Must be in the format
       * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
       * </pre>
       *
       * <code>string compilation_result = 2 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for compilationResult to set.
       * @return This builder for chaining.
       */
      public Builder setCompilationResultBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        resultCase_ = 2;
        result_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          errorStatusBuilder_;

      /**
       *
       *
       * <pre>
       * The error status encountered upon this attempt to create the
       * compilation result, if the attempt was unsuccessful.
       * </pre>
       *
       * <code>.google.rpc.Status error_status = 3;</code>
       *
       * @return Whether the errorStatus field is set.
       */
      @java.lang.Override
      public boolean hasErrorStatus() {
        return resultCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * The error status encountered upon this attempt to create the
       * compilation result, if the attempt was unsuccessful.
       * </pre>
       *
       * <code>.google.rpc.Status error_status = 3;</code>
       *
       * @return The errorStatus.
       */
      @java.lang.Override
      public com.google.rpc.Status getErrorStatus() {
        if (errorStatusBuilder_ == null) {
          if (resultCase_ == 3) {
            return (com.google.rpc.Status) result_;
          }
          return com.google.rpc.Status.getDefaultInstance();
        } else {
          if (resultCase_ == 3) {
            return errorStatusBuilder_.getMessage();
          }
          return com.google.rpc.Status.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * The error status encountered upon this attempt to create the
       * compilation result, if the attempt was unsuccessful.
       * </pre>
       *
       * <code>.google.rpc.Status error_status = 3;</code>
       */
      public Builder setErrorStatus(com.google.rpc.Status value) {
        if (errorStatusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          result_ = value;
          onChanged();
        } else {
          errorStatusBuilder_.setMessage(value);
        }
        resultCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * The error status encountered upon this attempt to create the
       * compilation result, if the attempt was unsuccessful.
       * </pre>
       *
       * <code>.google.rpc.Status error_status = 3;</code>
       */
      public Builder setErrorStatus(com.google.rpc.Status.Builder builderForValue) {
        if (errorStatusBuilder_ == null) {
          result_ = builderForValue.build();
          onChanged();
        } else {
          errorStatusBuilder_.setMessage(builderForValue.build());
        }
        resultCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * The error status encountered upon this attempt to create the
       * compilation result, if the attempt was unsuccessful.
       * </pre>
       *
       * <code>.google.rpc.Status error_status = 3;</code>
       */
      public Builder mergeErrorStatus(com.google.rpc.Status value) {
        if (errorStatusBuilder_ == null) {
          if (resultCase_ == 3 && result_ != com.google.rpc.Status.getDefaultInstance()) {
            result_ =
                com.google.rpc.Status.newBuilder((com.google.rpc.Status) result_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            result_ = value;
          }
          onChanged();
        } else {
          if (resultCase_ == 3) {
            errorStatusBuilder_.mergeFrom(value);
          } else {
            errorStatusBuilder_.setMessage(value);
          }
        }
        resultCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * The error status encountered upon this attempt to create the
       * compilation result, if the attempt was unsuccessful.
       * </pre>
       *
       * <code>.google.rpc.Status error_status = 3;</code>
       */
      public Builder clearErrorStatus() {
        if (errorStatusBuilder_ == null) {
          if (resultCase_ == 3) {
            resultCase_ = 0;
            result_ = null;
            onChanged();
          }
        } else {
          if (resultCase_ == 3) {
            resultCase_ = 0;
            result_ = null;
          }
          errorStatusBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The error status encountered upon this attempt to create the
       * compilation result, if the attempt was unsuccessful.
       * </pre>
       *
       * <code>.google.rpc.Status error_status = 3;</code>
       */
      public com.google.rpc.Status.Builder getErrorStatusBuilder() {
        return getErrorStatusFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The error status encountered upon this attempt to create the
       * compilation result, if the attempt was unsuccessful.
       * </pre>
       *
       * <code>.google.rpc.Status error_status = 3;</code>
       */
      @java.lang.Override
      public com.google.rpc.StatusOrBuilder getErrorStatusOrBuilder() {
        if ((resultCase_ == 3) && (errorStatusBuilder_ != null)) {
          return errorStatusBuilder_.getMessageOrBuilder();
        } else {
          if (resultCase_ == 3) {
            return (com.google.rpc.Status) result_;
          }
          return com.google.rpc.Status.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * The error status encountered upon this attempt to create the
       * compilation result, if the attempt was unsuccessful.
       * </pre>
       *
       * <code>.google.rpc.Status error_status = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          getErrorStatusFieldBuilder() {
        if (errorStatusBuilder_ == null) {
          if (!(resultCase_ == 3)) {
            result_ = com.google.rpc.Status.getDefaultInstance();
          }
          errorStatusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.rpc.Status,
                  com.google.rpc.Status.Builder,
                  com.google.rpc.StatusOrBuilder>(
                  (com.google.rpc.Status) result_, getParentForChildren(), isClean());
          result_ = null;
        }
        resultCase_ = 3;
        onChanged();
        return errorStatusBuilder_;
      }

      private com.google.protobuf.Timestamp releaseTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          releaseTimeBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. The timestamp of this release attempt.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp release_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the releaseTime field is set.
       */
      public boolean hasReleaseTime() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * Output only. The timestamp of this release attempt.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp release_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The releaseTime.
       */
      public com.google.protobuf.Timestamp getReleaseTime() {
        if (releaseTimeBuilder_ == null) {
          return releaseTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : releaseTime_;
        } else {
          return releaseTimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The timestamp of this release attempt.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp release_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setReleaseTime(com.google.protobuf.Timestamp value) {
        if (releaseTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          releaseTime_ = value;
        } else {
          releaseTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The timestamp of this release attempt.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp release_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setReleaseTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (releaseTimeBuilder_ == null) {
          releaseTime_ = builderForValue.build();
        } else {
          releaseTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The timestamp of this release attempt.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp release_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeReleaseTime(com.google.protobuf.Timestamp value) {
        if (releaseTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && releaseTime_ != null
              && releaseTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getReleaseTimeBuilder().mergeFrom(value);
          } else {
            releaseTime_ = value;
          }
        } else {
          releaseTimeBuilder_.mergeFrom(value);
        }
        if (releaseTime_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The timestamp of this release attempt.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp release_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearReleaseTime() {
        bitField0_ = (bitField0_ & ~0x00000004);
        releaseTime_ = null;
        if (releaseTimeBuilder_ != null) {
          releaseTimeBuilder_.dispose();
          releaseTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The timestamp of this release attempt.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp release_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getReleaseTimeBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getReleaseTimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Output only. The timestamp of this release attempt.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp release_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getReleaseTimeOrBuilder() {
        if (releaseTimeBuilder_ != null) {
          return releaseTimeBuilder_.getMessageOrBuilder();
        } else {
          return releaseTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : releaseTime_;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The timestamp of this release attempt.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp release_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getReleaseTimeFieldBuilder() {
        if (releaseTimeBuilder_ == null) {
          releaseTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getReleaseTime(), getParentForChildren(), isClean());
          releaseTime_ = null;
        }
        return releaseTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord)
    private static final com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord();
    }

    public static com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ScheduledReleaseRecord> PARSER =
        new com.google.protobuf.AbstractParser<ScheduledReleaseRecord>() {
          @java.lang.Override
          public ScheduledReleaseRecord parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ScheduledReleaseRecord> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ScheduledReleaseRecord> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Identifier. The release config's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Identifier. The release config's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GIT_COMMITISH_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object gitCommitish_ = "";

  /**
   *
   *
   * <pre>
   * Required. Git commit/tag/branch name at which the repository should be
   * compiled. Must exist in the remote repository. Examples:
   * - a commit SHA: `12ade345`
   * - a tag: `tag1`
   * - a branch name: `branch1`
   * </pre>
   *
   * <code>string git_commitish = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The gitCommitish.
   */
  @java.lang.Override
  public java.lang.String getGitCommitish() {
    java.lang.Object ref = gitCommitish_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      gitCommitish_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Git commit/tag/branch name at which the repository should be
   * compiled. Must exist in the remote repository. Examples:
   * - a commit SHA: `12ade345`
   * - a tag: `tag1`
   * - a branch name: `branch1`
   * </pre>
   *
   * <code>string git_commitish = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for gitCommitish.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGitCommitishBytes() {
    java.lang.Object ref = gitCommitish_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      gitCommitish_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CODE_COMPILATION_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.dataform.v1.CodeCompilationConfig codeCompilationConfig_;

  /**
   *
   *
   * <pre>
   * Optional. If set, fields of `code_compilation_config` override the default
   * compilation settings that are specified in dataform.json.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the codeCompilationConfig field is set.
   */
  @java.lang.Override
  public boolean hasCodeCompilationConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. If set, fields of `code_compilation_config` override the default
   * compilation settings that are specified in dataform.json.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The codeCompilationConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.CodeCompilationConfig getCodeCompilationConfig() {
    return codeCompilationConfig_ == null
        ? com.google.cloud.dataform.v1.CodeCompilationConfig.getDefaultInstance()
        : codeCompilationConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. If set, fields of `code_compilation_config` override the default
   * compilation settings that are specified in dataform.json.
   * </pre>
   *
   * <code>
   * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.CodeCompilationConfigOrBuilder
      getCodeCompilationConfigOrBuilder() {
    return codeCompilationConfig_ == null
        ? com.google.cloud.dataform.v1.CodeCompilationConfig.getDefaultInstance()
        : codeCompilationConfig_;
  }

  public static final int CRON_SCHEDULE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cronSchedule_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Optional schedule (in cron format) for automatic creation of
   * compilation results.
   * </pre>
   *
   * <code>string cron_schedule = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The cronSchedule.
   */
  @java.lang.Override
  public java.lang.String getCronSchedule() {
    java.lang.Object ref = cronSchedule_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cronSchedule_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Optional schedule (in cron format) for automatic creation of
   * compilation results.
   * </pre>
   *
   * <code>string cron_schedule = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for cronSchedule.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCronScheduleBytes() {
    java.lang.Object ref = cronSchedule_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cronSchedule_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIME_ZONE_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object timeZone_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Specifies the time zone to be used when interpreting
   * cron_schedule. Must be a time zone name from the time zone database
   * (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
   * unspecified, the default is UTC.
   * </pre>
   *
   * <code>string time_zone = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The timeZone.
   */
  @java.lang.Override
  public java.lang.String getTimeZone() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      timeZone_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Specifies the time zone to be used when interpreting
   * cron_schedule. Must be a time zone name from the time zone database
   * (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
   * unspecified, the default is UTC.
   * </pre>
   *
   * <code>string time_zone = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for timeZone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTimeZoneBytes() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      timeZone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECENT_SCHEDULED_RELEASE_RECORDS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord>
      recentScheduledReleaseRecords_;

  /**
   *
   *
   * <pre>
   * Output only. Records of the 10 most recent scheduled release attempts,
   * ordered in descending order of `release_time`. Updated whenever automatic
   * creation of a compilation result is triggered by cron_schedule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord>
      getRecentScheduledReleaseRecordsList() {
    return recentScheduledReleaseRecords_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Records of the 10 most recent scheduled release attempts,
   * ordered in descending order of `release_time`. Updated whenever automatic
   * creation of a compilation result is triggered by cron_schedule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecordOrBuilder>
      getRecentScheduledReleaseRecordsOrBuilderList() {
    return recentScheduledReleaseRecords_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Records of the 10 most recent scheduled release attempts,
   * ordered in descending order of `release_time`. Updated whenever automatic
   * creation of a compilation result is triggered by cron_schedule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getRecentScheduledReleaseRecordsCount() {
    return recentScheduledReleaseRecords_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. Records of the 10 most recent scheduled release attempts,
   * ordered in descending order of `release_time`. Updated whenever automatic
   * creation of a compilation result is triggered by cron_schedule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord
      getRecentScheduledReleaseRecords(int index) {
    return recentScheduledReleaseRecords_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. Records of the 10 most recent scheduled release attempts,
   * ordered in descending order of `release_time`. Updated whenever automatic
   * creation of a compilation result is triggered by cron_schedule.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecordOrBuilder
      getRecentScheduledReleaseRecordsOrBuilder(int index) {
    return recentScheduledReleaseRecords_.get(index);
  }

  public static final int RELEASE_COMPILATION_RESULT_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object releaseCompilationResult_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The name of the currently released compilation result for this
   * release config. This value is updated when a compilation result is
   * automatically created from this release config (using cron_schedule), or
   * when this resource is updated by API call (perhaps to roll back to an
   * earlier release). The compilation result must have been created using this
   * release config. Must be in the format
   * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
   * </pre>
   *
   * <code>
   * string release_compilation_result = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The releaseCompilationResult.
   */
  @java.lang.Override
  public java.lang.String getReleaseCompilationResult() {
    java.lang.Object ref = releaseCompilationResult_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      releaseCompilationResult_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The name of the currently released compilation result for this
   * release config. This value is updated when a compilation result is
   * automatically created from this release config (using cron_schedule), or
   * when this resource is updated by API call (perhaps to roll back to an
   * earlier release). The compilation result must have been created using this
   * release config. Must be in the format
   * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
   * </pre>
   *
   * <code>
   * string release_compilation_result = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for releaseCompilationResult.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReleaseCompilationResultBytes() {
    java.lang.Object ref = releaseCompilationResult_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      releaseCompilationResult_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISABLED_FIELD_NUMBER = 8;
  private boolean disabled_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Disables automatic creation of compilation results.
   * </pre>
   *
   * <code>bool disabled = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public boolean getDisabled() {
    return disabled_;
  }

  public static final int INTERNAL_METADATA_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object internalMetadata_ = "";

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the internalMetadata field is set.
   */
  @java.lang.Override
  public boolean hasInternalMetadata() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The internalMetadata.
   */
  @java.lang.Override
  public java.lang.String getInternalMetadata() {
    java.lang.Object ref = internalMetadata_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      internalMetadata_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for internalMetadata.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInternalMetadataBytes() {
    java.lang.Object ref = internalMetadata_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      internalMetadata_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gitCommitish_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, gitCommitish_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCodeCompilationConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cronSchedule_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, cronSchedule_);
    }
    for (int i = 0; i < recentScheduledReleaseRecords_.size(); i++) {
      output.writeMessage(5, recentScheduledReleaseRecords_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(releaseCompilationResult_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, releaseCompilationResult_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, timeZone_);
    }
    if (disabled_ != false) {
      output.writeBool(8, disabled_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, internalMetadata_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gitCommitish_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, gitCommitish_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCodeCompilationConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cronSchedule_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, cronSchedule_);
    }
    for (int i = 0; i < recentScheduledReleaseRecords_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, recentScheduledReleaseRecords_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(releaseCompilationResult_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(6, releaseCompilationResult_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, timeZone_);
    }
    if (disabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, disabled_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, internalMetadata_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataform.v1.ReleaseConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dataform.v1.ReleaseConfig other =
        (com.google.cloud.dataform.v1.ReleaseConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getGitCommitish().equals(other.getGitCommitish())) return false;
    if (hasCodeCompilationConfig() != other.hasCodeCompilationConfig()) return false;
    if (hasCodeCompilationConfig()) {
      if (!getCodeCompilationConfig().equals(other.getCodeCompilationConfig())) return false;
    }
    if (!getCronSchedule().equals(other.getCronSchedule())) return false;
    if (!getTimeZone().equals(other.getTimeZone())) return false;
    if (!getRecentScheduledReleaseRecordsList()
        .equals(other.getRecentScheduledReleaseRecordsList())) return false;
    if (!getReleaseCompilationResult().equals(other.getReleaseCompilationResult())) return false;
    if (getDisabled() != other.getDisabled()) return false;
    if (hasInternalMetadata() != other.hasInternalMetadata()) return false;
    if (hasInternalMetadata()) {
      if (!getInternalMetadata().equals(other.getInternalMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + GIT_COMMITISH_FIELD_NUMBER;
    hash = (53 * hash) + getGitCommitish().hashCode();
    if (hasCodeCompilationConfig()) {
      hash = (37 * hash) + CODE_COMPILATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getCodeCompilationConfig().hashCode();
    }
    hash = (37 * hash) + CRON_SCHEDULE_FIELD_NUMBER;
    hash = (53 * hash) + getCronSchedule().hashCode();
    hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getTimeZone().hashCode();
    if (getRecentScheduledReleaseRecordsCount() > 0) {
      hash = (37 * hash) + RECENT_SCHEDULED_RELEASE_RECORDS_FIELD_NUMBER;
      hash = (53 * hash) + getRecentScheduledReleaseRecordsList().hashCode();
    }
    hash = (37 * hash) + RELEASE_COMPILATION_RESULT_FIELD_NUMBER;
    hash = (53 * hash) + getReleaseCompilationResult().hashCode();
    hash = (37 * hash) + DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
    if (hasInternalMetadata()) {
      hash = (37 * hash) + INTERNAL_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getInternalMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataform.v1.ReleaseConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.ReleaseConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.ReleaseConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.ReleaseConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.ReleaseConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.ReleaseConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.ReleaseConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.ReleaseConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.ReleaseConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.ReleaseConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.ReleaseConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.ReleaseConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataform.v1.ReleaseConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a Dataform release configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.ReleaseConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.ReleaseConfig)
      com.google.cloud.dataform.v1.ReleaseConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_ReleaseConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_ReleaseConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.ReleaseConfig.class,
              com.google.cloud.dataform.v1.ReleaseConfig.Builder.class);
    }

    // Construct using com.google.cloud.dataform.v1.ReleaseConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCodeCompilationConfigFieldBuilder();
        getRecentScheduledReleaseRecordsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      gitCommitish_ = "";
      codeCompilationConfig_ = null;
      if (codeCompilationConfigBuilder_ != null) {
        codeCompilationConfigBuilder_.dispose();
        codeCompilationConfigBuilder_ = null;
      }
      cronSchedule_ = "";
      timeZone_ = "";
      if (recentScheduledReleaseRecordsBuilder_ == null) {
        recentScheduledReleaseRecords_ = java.util.Collections.emptyList();
      } else {
        recentScheduledReleaseRecords_ = null;
        recentScheduledReleaseRecordsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      releaseCompilationResult_ = "";
      disabled_ = false;
      internalMetadata_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_ReleaseConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.ReleaseConfig getDefaultInstanceForType() {
      return com.google.cloud.dataform.v1.ReleaseConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.ReleaseConfig build() {
      com.google.cloud.dataform.v1.ReleaseConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.ReleaseConfig buildPartial() {
      com.google.cloud.dataform.v1.ReleaseConfig result =
          new com.google.cloud.dataform.v1.ReleaseConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dataform.v1.ReleaseConfig result) {
      if (recentScheduledReleaseRecordsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          recentScheduledReleaseRecords_ =
              java.util.Collections.unmodifiableList(recentScheduledReleaseRecords_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.recentScheduledReleaseRecords_ = recentScheduledReleaseRecords_;
      } else {
        result.recentScheduledReleaseRecords_ = recentScheduledReleaseRecordsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dataform.v1.ReleaseConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.gitCommitish_ = gitCommitish_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.codeCompilationConfig_ =
            codeCompilationConfigBuilder_ == null
                ? codeCompilationConfig_
                : codeCompilationConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.cronSchedule_ = cronSchedule_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.timeZone_ = timeZone_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.releaseCompilationResult_ = releaseCompilationResult_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.disabled_ = disabled_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.internalMetadata_ = internalMetadata_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataform.v1.ReleaseConfig) {
        return mergeFrom((com.google.cloud.dataform.v1.ReleaseConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataform.v1.ReleaseConfig other) {
      if (other == com.google.cloud.dataform.v1.ReleaseConfig.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getGitCommitish().isEmpty()) {
        gitCommitish_ = other.gitCommitish_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCodeCompilationConfig()) {
        mergeCodeCompilationConfig(other.getCodeCompilationConfig());
      }
      if (!other.getCronSchedule().isEmpty()) {
        cronSchedule_ = other.cronSchedule_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getTimeZone().isEmpty()) {
        timeZone_ = other.timeZone_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (recentScheduledReleaseRecordsBuilder_ == null) {
        if (!other.recentScheduledReleaseRecords_.isEmpty()) {
          if (recentScheduledReleaseRecords_.isEmpty()) {
            recentScheduledReleaseRecords_ = other.recentScheduledReleaseRecords_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureRecentScheduledReleaseRecordsIsMutable();
            recentScheduledReleaseRecords_.addAll(other.recentScheduledReleaseRecords_);
          }
          onChanged();
        }
      } else {
        if (!other.recentScheduledReleaseRecords_.isEmpty()) {
          if (recentScheduledReleaseRecordsBuilder_.isEmpty()) {
            recentScheduledReleaseRecordsBuilder_.dispose();
            recentScheduledReleaseRecordsBuilder_ = null;
            recentScheduledReleaseRecords_ = other.recentScheduledReleaseRecords_;
            bitField0_ = (bitField0_ & ~0x00000020);
            recentScheduledReleaseRecordsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRecentScheduledReleaseRecordsFieldBuilder()
                    : null;
          } else {
            recentScheduledReleaseRecordsBuilder_.addAllMessages(
                other.recentScheduledReleaseRecords_);
          }
        }
      }
      if (!other.getReleaseCompilationResult().isEmpty()) {
        releaseCompilationResult_ = other.releaseCompilationResult_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.getDisabled() != false) {
        setDisabled(other.getDisabled());
      }
      if (other.hasInternalMetadata()) {
        internalMetadata_ = other.internalMetadata_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                gitCommitish_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getCodeCompilationConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                cronSchedule_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord m =
                    input.readMessage(
                        com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord.parser(),
                        extensionRegistry);
                if (recentScheduledReleaseRecordsBuilder_ == null) {
                  ensureRecentScheduledReleaseRecordsIsMutable();
                  recentScheduledReleaseRecords_.add(m);
                } else {
                  recentScheduledReleaseRecordsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                releaseCompilationResult_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                timeZone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            case 64:
              {
                disabled_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 74:
              {
                internalMetadata_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Identifier. The release config's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The release config's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The release config's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The release config's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The release config's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object gitCommitish_ = "";

    /**
     *
     *
     * <pre>
     * Required. Git commit/tag/branch name at which the repository should be
     * compiled. Must exist in the remote repository. Examples:
     * - a commit SHA: `12ade345`
     * - a tag: `tag1`
     * - a branch name: `branch1`
     * </pre>
     *
     * <code>string git_commitish = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The gitCommitish.
     */
    public java.lang.String getGitCommitish() {
      java.lang.Object ref = gitCommitish_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gitCommitish_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Git commit/tag/branch name at which the repository should be
     * compiled. Must exist in the remote repository. Examples:
     * - a commit SHA: `12ade345`
     * - a tag: `tag1`
     * - a branch name: `branch1`
     * </pre>
     *
     * <code>string git_commitish = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for gitCommitish.
     */
    public com.google.protobuf.ByteString getGitCommitishBytes() {
      java.lang.Object ref = gitCommitish_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gitCommitish_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Git commit/tag/branch name at which the repository should be
     * compiled. Must exist in the remote repository. Examples:
     * - a commit SHA: `12ade345`
     * - a tag: `tag1`
     * - a branch name: `branch1`
     * </pre>
     *
     * <code>string git_commitish = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The gitCommitish to set.
     * @return This builder for chaining.
     */
    public Builder setGitCommitish(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      gitCommitish_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Git commit/tag/branch name at which the repository should be
     * compiled. Must exist in the remote repository. Examples:
     * - a commit SHA: `12ade345`
     * - a tag: `tag1`
     * - a branch name: `branch1`
     * </pre>
     *
     * <code>string git_commitish = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGitCommitish() {
      gitCommitish_ = getDefaultInstance().getGitCommitish();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Git commit/tag/branch name at which the repository should be
     * compiled. Must exist in the remote repository. Examples:
     * - a commit SHA: `12ade345`
     * - a tag: `tag1`
     * - a branch name: `branch1`
     * </pre>
     *
     * <code>string git_commitish = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for gitCommitish to set.
     * @return This builder for chaining.
     */
    public Builder setGitCommitishBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      gitCommitish_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.dataform.v1.CodeCompilationConfig codeCompilationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.CodeCompilationConfig,
            com.google.cloud.dataform.v1.CodeCompilationConfig.Builder,
            com.google.cloud.dataform.v1.CodeCompilationConfigOrBuilder>
        codeCompilationConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. If set, fields of `code_compilation_config` override the default
     * compilation settings that are specified in dataform.json.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the codeCompilationConfig field is set.
     */
    public boolean hasCodeCompilationConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, fields of `code_compilation_config` override the default
     * compilation settings that are specified in dataform.json.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The codeCompilationConfig.
     */
    public com.google.cloud.dataform.v1.CodeCompilationConfig getCodeCompilationConfig() {
      if (codeCompilationConfigBuilder_ == null) {
        return codeCompilationConfig_ == null
            ? com.google.cloud.dataform.v1.CodeCompilationConfig.getDefaultInstance()
            : codeCompilationConfig_;
      } else {
        return codeCompilationConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, fields of `code_compilation_config` override the default
     * compilation settings that are specified in dataform.json.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCodeCompilationConfig(
        com.google.cloud.dataform.v1.CodeCompilationConfig value) {
      if (codeCompilationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        codeCompilationConfig_ = value;
      } else {
        codeCompilationConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, fields of `code_compilation_config` override the default
     * compilation settings that are specified in dataform.json.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCodeCompilationConfig(
        com.google.cloud.dataform.v1.CodeCompilationConfig.Builder builderForValue) {
      if (codeCompilationConfigBuilder_ == null) {
        codeCompilationConfig_ = builderForValue.build();
      } else {
        codeCompilationConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, fields of `code_compilation_config` override the default
     * compilation settings that are specified in dataform.json.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCodeCompilationConfig(
        com.google.cloud.dataform.v1.CodeCompilationConfig value) {
      if (codeCompilationConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && codeCompilationConfig_ != null
            && codeCompilationConfig_
                != com.google.cloud.dataform.v1.CodeCompilationConfig.getDefaultInstance()) {
          getCodeCompilationConfigBuilder().mergeFrom(value);
        } else {
          codeCompilationConfig_ = value;
        }
      } else {
        codeCompilationConfigBuilder_.mergeFrom(value);
      }
      if (codeCompilationConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, fields of `code_compilation_config` override the default
     * compilation settings that are specified in dataform.json.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCodeCompilationConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      codeCompilationConfig_ = null;
      if (codeCompilationConfigBuilder_ != null) {
        codeCompilationConfigBuilder_.dispose();
        codeCompilationConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, fields of `code_compilation_config` override the default
     * compilation settings that are specified in dataform.json.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataform.v1.CodeCompilationConfig.Builder
        getCodeCompilationConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCodeCompilationConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, fields of `code_compilation_config` override the default
     * compilation settings that are specified in dataform.json.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataform.v1.CodeCompilationConfigOrBuilder
        getCodeCompilationConfigOrBuilder() {
      if (codeCompilationConfigBuilder_ != null) {
        return codeCompilationConfigBuilder_.getMessageOrBuilder();
      } else {
        return codeCompilationConfig_ == null
            ? com.google.cloud.dataform.v1.CodeCompilationConfig.getDefaultInstance()
            : codeCompilationConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, fields of `code_compilation_config` override the default
     * compilation settings that are specified in dataform.json.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CodeCompilationConfig code_compilation_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.CodeCompilationConfig,
            com.google.cloud.dataform.v1.CodeCompilationConfig.Builder,
            com.google.cloud.dataform.v1.CodeCompilationConfigOrBuilder>
        getCodeCompilationConfigFieldBuilder() {
      if (codeCompilationConfigBuilder_ == null) {
        codeCompilationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.CodeCompilationConfig,
                com.google.cloud.dataform.v1.CodeCompilationConfig.Builder,
                com.google.cloud.dataform.v1.CodeCompilationConfigOrBuilder>(
                getCodeCompilationConfig(), getParentForChildren(), isClean());
        codeCompilationConfig_ = null;
      }
      return codeCompilationConfigBuilder_;
    }

    private java.lang.Object cronSchedule_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Optional schedule (in cron format) for automatic creation of
     * compilation results.
     * </pre>
     *
     * <code>string cron_schedule = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The cronSchedule.
     */
    public java.lang.String getCronSchedule() {
      java.lang.Object ref = cronSchedule_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cronSchedule_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional schedule (in cron format) for automatic creation of
     * compilation results.
     * </pre>
     *
     * <code>string cron_schedule = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for cronSchedule.
     */
    public com.google.protobuf.ByteString getCronScheduleBytes() {
      java.lang.Object ref = cronSchedule_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cronSchedule_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional schedule (in cron format) for automatic creation of
     * compilation results.
     * </pre>
     *
     * <code>string cron_schedule = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The cronSchedule to set.
     * @return This builder for chaining.
     */
    public Builder setCronSchedule(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cronSchedule_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional schedule (in cron format) for automatic creation of
     * compilation results.
     * </pre>
     *
     * <code>string cron_schedule = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCronSchedule() {
      cronSchedule_ = getDefaultInstance().getCronSchedule();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional schedule (in cron format) for automatic creation of
     * compilation results.
     * </pre>
     *
     * <code>string cron_schedule = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for cronSchedule to set.
     * @return This builder for chaining.
     */
    public Builder setCronScheduleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cronSchedule_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object timeZone_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Specifies the time zone to be used when interpreting
     * cron_schedule. Must be a time zone name from the time zone database
     * (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
     * unspecified, the default is UTC.
     * </pre>
     *
     * <code>string time_zone = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The timeZone.
     */
    public java.lang.String getTimeZone() {
      java.lang.Object ref = timeZone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timeZone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the time zone to be used when interpreting
     * cron_schedule. Must be a time zone name from the time zone database
     * (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
     * unspecified, the default is UTC.
     * </pre>
     *
     * <code>string time_zone = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for timeZone.
     */
    public com.google.protobuf.ByteString getTimeZoneBytes() {
      java.lang.Object ref = timeZone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        timeZone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the time zone to be used when interpreting
     * cron_schedule. Must be a time zone name from the time zone database
     * (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
     * unspecified, the default is UTC.
     * </pre>
     *
     * <code>string time_zone = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      timeZone_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the time zone to be used when interpreting
     * cron_schedule. Must be a time zone name from the time zone database
     * (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
     * unspecified, the default is UTC.
     * </pre>
     *
     * <code>string time_zone = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeZone() {
      timeZone_ = getDefaultInstance().getTimeZone();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the time zone to be used when interpreting
     * cron_schedule. Must be a time zone name from the time zone database
     * (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
     * unspecified, the default is UTC.
     * </pre>
     *
     * <code>string time_zone = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      timeZone_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord>
        recentScheduledReleaseRecords_ = java.util.Collections.emptyList();

    private void ensureRecentScheduledReleaseRecordsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        recentScheduledReleaseRecords_ =
            new java.util.ArrayList<
                com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord>(
                recentScheduledReleaseRecords_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord,
            com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord.Builder,
            com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecordOrBuilder>
        recentScheduledReleaseRecordsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled release attempts,
     * ordered in descending order of `release_time`. Updated whenever automatic
     * creation of a compilation result is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord>
        getRecentScheduledReleaseRecordsList() {
      if (recentScheduledReleaseRecordsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(recentScheduledReleaseRecords_);
      } else {
        return recentScheduledReleaseRecordsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled release attempts,
     * ordered in descending order of `release_time`. Updated whenever automatic
     * creation of a compilation result is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getRecentScheduledReleaseRecordsCount() {
      if (recentScheduledReleaseRecordsBuilder_ == null) {
        return recentScheduledReleaseRecords_.size();
      } else {
        return recentScheduledReleaseRecordsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled release attempts,
     * ordered in descending order of `release_time`. Updated whenever automatic
     * creation of a compilation result is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord
        getRecentScheduledReleaseRecords(int index) {
      if (recentScheduledReleaseRecordsBuilder_ == null) {
        return recentScheduledReleaseRecords_.get(index);
      } else {
        return recentScheduledReleaseRecordsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled release attempts,
     * ordered in descending order of `release_time`. Updated whenever automatic
     * creation of a compilation result is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRecentScheduledReleaseRecords(
        int index, com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord value) {
      if (recentScheduledReleaseRecordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRecentScheduledReleaseRecordsIsMutable();
        recentScheduledReleaseRecords_.set(index, value);
        onChanged();
      } else {
        recentScheduledReleaseRecordsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled release attempts,
     * ordered in descending order of `release_time`. Updated whenever automatic
     * creation of a compilation result is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRecentScheduledReleaseRecords(
        int index,
        com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord.Builder builderForValue) {
      if (recentScheduledReleaseRecordsBuilder_ == null) {
        ensureRecentScheduledReleaseRecordsIsMutable();
        recentScheduledReleaseRecords_.set(index, builderForValue.build());
        onChanged();
      } else {
        recentScheduledReleaseRecordsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled release attempts,
     * ordered in descending order of `release_time`. Updated whenever automatic
     * creation of a compilation result is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRecentScheduledReleaseRecords(
        com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord value) {
      if (recentScheduledReleaseRecordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRecentScheduledReleaseRecordsIsMutable();
        recentScheduledReleaseRecords_.add(value);
        onChanged();
      } else {
        recentScheduledReleaseRecordsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled release attempts,
     * ordered in descending order of `release_time`. Updated whenever automatic
     * creation of a compilation result is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRecentScheduledReleaseRecords(
        int index, com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord value) {
      if (recentScheduledReleaseRecordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRecentScheduledReleaseRecordsIsMutable();
        recentScheduledReleaseRecords_.add(index, value);
        onChanged();
      } else {
        recentScheduledReleaseRecordsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled release attempts,
     * ordered in descending order of `release_time`. Updated whenever automatic
     * creation of a compilation result is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRecentScheduledReleaseRecords(
        com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord.Builder builderForValue) {
      if (recentScheduledReleaseRecordsBuilder_ == null) {
        ensureRecentScheduledReleaseRecordsIsMutable();
        recentScheduledReleaseRecords_.add(builderForValue.build());
        onChanged();
      } else {
        recentScheduledReleaseRecordsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled release attempts,
     * ordered in descending order of `release_time`. Updated whenever automatic
     * creation of a compilation result is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRecentScheduledReleaseRecords(
        int index,
        com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord.Builder builderForValue) {
      if (recentScheduledReleaseRecordsBuilder_ == null) {
        ensureRecentScheduledReleaseRecordsIsMutable();
        recentScheduledReleaseRecords_.add(index, builderForValue.build());
        onChanged();
      } else {
        recentScheduledReleaseRecordsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled release attempts,
     * ordered in descending order of `release_time`. Updated whenever automatic
     * creation of a compilation result is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllRecentScheduledReleaseRecords(
        java.lang.Iterable<
                ? extends com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord>
            values) {
      if (recentScheduledReleaseRecordsBuilder_ == null) {
        ensureRecentScheduledReleaseRecordsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, recentScheduledReleaseRecords_);
        onChanged();
      } else {
        recentScheduledReleaseRecordsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled release attempts,
     * ordered in descending order of `release_time`. Updated whenever automatic
     * creation of a compilation result is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRecentScheduledReleaseRecords() {
      if (recentScheduledReleaseRecordsBuilder_ == null) {
        recentScheduledReleaseRecords_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        recentScheduledReleaseRecordsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled release attempts,
     * ordered in descending order of `release_time`. Updated whenever automatic
     * creation of a compilation result is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeRecentScheduledReleaseRecords(int index) {
      if (recentScheduledReleaseRecordsBuilder_ == null) {
        ensureRecentScheduledReleaseRecordsIsMutable();
        recentScheduledReleaseRecords_.remove(index);
        onChanged();
      } else {
        recentScheduledReleaseRecordsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled release attempts,
     * ordered in descending order of `release_time`. Updated whenever automatic
     * creation of a compilation result is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord.Builder
        getRecentScheduledReleaseRecordsBuilder(int index) {
      return getRecentScheduledReleaseRecordsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled release attempts,
     * ordered in descending order of `release_time`. Updated whenever automatic
     * creation of a compilation result is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecordOrBuilder
        getRecentScheduledReleaseRecordsOrBuilder(int index) {
      if (recentScheduledReleaseRecordsBuilder_ == null) {
        return recentScheduledReleaseRecords_.get(index);
      } else {
        return recentScheduledReleaseRecordsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled release attempts,
     * ordered in descending order of `release_time`. Updated whenever automatic
     * creation of a compilation result is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecordOrBuilder>
        getRecentScheduledReleaseRecordsOrBuilderList() {
      if (recentScheduledReleaseRecordsBuilder_ != null) {
        return recentScheduledReleaseRecordsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(recentScheduledReleaseRecords_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled release attempts,
     * ordered in descending order of `release_time`. Updated whenever automatic
     * creation of a compilation result is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord.Builder
        addRecentScheduledReleaseRecordsBuilder() {
      return getRecentScheduledReleaseRecordsFieldBuilder()
          .addBuilder(
              com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled release attempts,
     * ordered in descending order of `release_time`. Updated whenever automatic
     * creation of a compilation result is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord.Builder
        addRecentScheduledReleaseRecordsBuilder(int index) {
      return getRecentScheduledReleaseRecordsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Records of the 10 most recent scheduled release attempts,
     * ordered in descending order of `release_time`. Updated whenever automatic
     * creation of a compilation result is triggered by cron_schedule.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord recent_scheduled_release_records = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord.Builder>
        getRecentScheduledReleaseRecordsBuilderList() {
      return getRecentScheduledReleaseRecordsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord,
            com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord.Builder,
            com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecordOrBuilder>
        getRecentScheduledReleaseRecordsFieldBuilder() {
      if (recentScheduledReleaseRecordsBuilder_ == null) {
        recentScheduledReleaseRecordsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord,
                com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecord.Builder,
                com.google.cloud.dataform.v1.ReleaseConfig.ScheduledReleaseRecordOrBuilder>(
                recentScheduledReleaseRecords_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        recentScheduledReleaseRecords_ = null;
      }
      return recentScheduledReleaseRecordsBuilder_;
    }

    private java.lang.Object releaseCompilationResult_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The name of the currently released compilation result for this
     * release config. This value is updated when a compilation result is
     * automatically created from this release config (using cron_schedule), or
     * when this resource is updated by API call (perhaps to roll back to an
     * earlier release). The compilation result must have been created using this
     * release config. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>
     * string release_compilation_result = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The releaseCompilationResult.
     */
    public java.lang.String getReleaseCompilationResult() {
      java.lang.Object ref = releaseCompilationResult_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        releaseCompilationResult_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the currently released compilation result for this
     * release config. This value is updated when a compilation result is
     * automatically created from this release config (using cron_schedule), or
     * when this resource is updated by API call (perhaps to roll back to an
     * earlier release). The compilation result must have been created using this
     * release config. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>
     * string release_compilation_result = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for releaseCompilationResult.
     */
    public com.google.protobuf.ByteString getReleaseCompilationResultBytes() {
      java.lang.Object ref = releaseCompilationResult_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        releaseCompilationResult_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the currently released compilation result for this
     * release config. This value is updated when a compilation result is
     * automatically created from this release config (using cron_schedule), or
     * when this resource is updated by API call (perhaps to roll back to an
     * earlier release). The compilation result must have been created using this
     * release config. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>
     * string release_compilation_result = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The releaseCompilationResult to set.
     * @return This builder for chaining.
     */
    public Builder setReleaseCompilationResult(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      releaseCompilationResult_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the currently released compilation result for this
     * release config. This value is updated when a compilation result is
     * automatically created from this release config (using cron_schedule), or
     * when this resource is updated by API call (perhaps to roll back to an
     * earlier release). The compilation result must have been created using this
     * release config. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>
     * string release_compilation_result = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReleaseCompilationResult() {
      releaseCompilationResult_ = getDefaultInstance().getReleaseCompilationResult();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the currently released compilation result for this
     * release config. This value is updated when a compilation result is
     * automatically created from this release config (using cron_schedule), or
     * when this resource is updated by API call (perhaps to roll back to an
     * earlier release). The compilation result must have been created using this
     * release config. Must be in the format
     * `projects/&#42;&#47;locations/&#42;&#47;repositories/&#42;&#47;compilationResults/&#42;`.
     * </pre>
     *
     * <code>
     * string release_compilation_result = 6 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for releaseCompilationResult to set.
     * @return This builder for chaining.
     */
    public Builder setReleaseCompilationResultBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      releaseCompilationResult_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private boolean disabled_;

    /**
     *
     *
     * <pre>
     * Optional. Disables automatic creation of compilation results.
     * </pre>
     *
     * <code>bool disabled = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Disables automatic creation of compilation results.
     * </pre>
     *
     * <code>bool disabled = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The disabled to set.
     * @return This builder for chaining.
     */
    public Builder setDisabled(boolean value) {

      disabled_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Disables automatic creation of compilation results.
     * </pre>
     *
     * <code>bool disabled = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisabled() {
      bitField0_ = (bitField0_ & ~0x00000080);
      disabled_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object internalMetadata_ = "";

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the internalMetadata field is set.
     */
    public boolean hasInternalMetadata() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The internalMetadata.
     */
    public java.lang.String getInternalMetadata() {
      java.lang.Object ref = internalMetadata_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        internalMetadata_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for internalMetadata.
     */
    public com.google.protobuf.ByteString getInternalMetadataBytes() {
      java.lang.Object ref = internalMetadata_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        internalMetadata_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The internalMetadata to set.
     * @return This builder for chaining.
     */
    public Builder setInternalMetadata(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      internalMetadata_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInternalMetadata() {
      internalMetadata_ = getDefaultInstance().getInternalMetadata();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for internalMetadata to set.
     * @return This builder for chaining.
     */
    public Builder setInternalMetadataBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      internalMetadata_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.ReleaseConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.ReleaseConfig)
  private static final com.google.cloud.dataform.v1.ReleaseConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.ReleaseConfig();
  }

  public static com.google.cloud.dataform.v1.ReleaseConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReleaseConfig> PARSER =
      new com.google.protobuf.AbstractParser<ReleaseConfig>() {
        @java.lang.Override
        public ReleaseConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReleaseConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReleaseConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataform.v1.ReleaseConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
