/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataform/v1/dataform.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.dataform.v1;

/**
 *
 *
 * <pre>
 * Describes a relation and its columns.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataform.v1.RelationDescriptor}
 */
public final class RelationDescriptor extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.RelationDescriptor)
    RelationDescriptorOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RelationDescriptor.newBuilder() to construct.
  private RelationDescriptor(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RelationDescriptor() {
    description_ = "";
    columns_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RelationDescriptor();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_RelationDescriptor_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 3:
        return internalGetBigqueryLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_RelationDescriptor_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataform.v1.RelationDescriptor.class,
            com.google.cloud.dataform.v1.RelationDescriptor.Builder.class);
  }

  public interface ColumnDescriptorOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The identifier for the column. Each entry in `path` represents one level
     * of nesting.
     * </pre>
     *
     * <code>repeated string path = 1;</code>
     *
     * @return A list containing the path.
     */
    java.util.List<java.lang.String> getPathList();

    /**
     *
     *
     * <pre>
     * The identifier for the column. Each entry in `path` represents one level
     * of nesting.
     * </pre>
     *
     * <code>repeated string path = 1;</code>
     *
     * @return The count of path.
     */
    int getPathCount();

    /**
     *
     *
     * <pre>
     * The identifier for the column. Each entry in `path` represents one level
     * of nesting.
     * </pre>
     *
     * <code>repeated string path = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The path at the given index.
     */
    java.lang.String getPath(int index);

    /**
     *
     *
     * <pre>
     * The identifier for the column. Each entry in `path` represents one level
     * of nesting.
     * </pre>
     *
     * <code>repeated string path = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the path at the given index.
     */
    com.google.protobuf.ByteString getPathBytes(int index);

    /**
     *
     *
     * <pre>
     * A textual description of the column.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();

    /**
     *
     *
     * <pre>
     * A textual description of the column.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();

    /**
     *
     *
     * <pre>
     * A list of BigQuery policy tags that will be applied to the column.
     * </pre>
     *
     * <code>repeated string bigquery_policy_tags = 3;</code>
     *
     * @return A list containing the bigqueryPolicyTags.
     */
    java.util.List<java.lang.String> getBigqueryPolicyTagsList();

    /**
     *
     *
     * <pre>
     * A list of BigQuery policy tags that will be applied to the column.
     * </pre>
     *
     * <code>repeated string bigquery_policy_tags = 3;</code>
     *
     * @return The count of bigqueryPolicyTags.
     */
    int getBigqueryPolicyTagsCount();

    /**
     *
     *
     * <pre>
     * A list of BigQuery policy tags that will be applied to the column.
     * </pre>
     *
     * <code>repeated string bigquery_policy_tags = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The bigqueryPolicyTags at the given index.
     */
    java.lang.String getBigqueryPolicyTags(int index);

    /**
     *
     *
     * <pre>
     * A list of BigQuery policy tags that will be applied to the column.
     * </pre>
     *
     * <code>repeated string bigquery_policy_tags = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the bigqueryPolicyTags at the given index.
     */
    com.google.protobuf.ByteString getBigqueryPolicyTagsBytes(int index);
  }

  /**
   *
   *
   * <pre>
   * Describes a column.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor}
   */
  public static final class ColumnDescriptor extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor)
      ColumnDescriptorOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ColumnDescriptor.newBuilder() to construct.
    private ColumnDescriptor(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ColumnDescriptor() {
      path_ = com.google.protobuf.LazyStringArrayList.emptyList();
      description_ = "";
      bigqueryPolicyTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ColumnDescriptor();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_RelationDescriptor_ColumnDescriptor_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_RelationDescriptor_ColumnDescriptor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor.class,
              com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor.Builder.class);
    }

    public static final int PATH_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList path_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * The identifier for the column. Each entry in `path` represents one level
     * of nesting.
     * </pre>
     *
     * <code>repeated string path = 1;</code>
     *
     * @return A list containing the path.
     */
    public com.google.protobuf.ProtocolStringList getPathList() {
      return path_;
    }

    /**
     *
     *
     * <pre>
     * The identifier for the column. Each entry in `path` represents one level
     * of nesting.
     * </pre>
     *
     * <code>repeated string path = 1;</code>
     *
     * @return The count of path.
     */
    public int getPathCount() {
      return path_.size();
    }

    /**
     *
     *
     * <pre>
     * The identifier for the column. Each entry in `path` represents one level
     * of nesting.
     * </pre>
     *
     * <code>repeated string path = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The path at the given index.
     */
    public java.lang.String getPath(int index) {
      return path_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The identifier for the column. Each entry in `path` represents one level
     * of nesting.
     * </pre>
     *
     * <code>repeated string path = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the path at the given index.
     */
    public com.google.protobuf.ByteString getPathBytes(int index) {
      return path_.getByteString(index);
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * A textual description of the column.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * A textual description of the column.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int BIGQUERY_POLICY_TAGS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList bigqueryPolicyTags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * A list of BigQuery policy tags that will be applied to the column.
     * </pre>
     *
     * <code>repeated string bigquery_policy_tags = 3;</code>
     *
     * @return A list containing the bigqueryPolicyTags.
     */
    public com.google.protobuf.ProtocolStringList getBigqueryPolicyTagsList() {
      return bigqueryPolicyTags_;
    }

    /**
     *
     *
     * <pre>
     * A list of BigQuery policy tags that will be applied to the column.
     * </pre>
     *
     * <code>repeated string bigquery_policy_tags = 3;</code>
     *
     * @return The count of bigqueryPolicyTags.
     */
    public int getBigqueryPolicyTagsCount() {
      return bigqueryPolicyTags_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of BigQuery policy tags that will be applied to the column.
     * </pre>
     *
     * <code>repeated string bigquery_policy_tags = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The bigqueryPolicyTags at the given index.
     */
    public java.lang.String getBigqueryPolicyTags(int index) {
      return bigqueryPolicyTags_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of BigQuery policy tags that will be applied to the column.
     * </pre>
     *
     * <code>repeated string bigquery_policy_tags = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the bigqueryPolicyTags at the given index.
     */
    public com.google.protobuf.ByteString getBigqueryPolicyTagsBytes(int index) {
      return bigqueryPolicyTags_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < path_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, path_.getRaw(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
      }
      for (int i = 0; i < bigqueryPolicyTags_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 3, bigqueryPolicyTags_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < path_.size(); i++) {
          dataSize += computeStringSizeNoTag(path_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getPathList().size();
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < bigqueryPolicyTags_.size(); i++) {
          dataSize += computeStringSizeNoTag(bigqueryPolicyTags_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getBigqueryPolicyTagsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor)) {
        return super.equals(obj);
      }
      com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor other =
          (com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor) obj;

      if (!getPathList().equals(other.getPathList())) return false;
      if (!getDescription().equals(other.getDescription())) return false;
      if (!getBigqueryPolicyTagsList().equals(other.getBigqueryPolicyTagsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getPathCount() > 0) {
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPathList().hashCode();
      }
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      if (getBigqueryPolicyTagsCount() > 0) {
        hash = (37 * hash) + BIGQUERY_POLICY_TAGS_FIELD_NUMBER;
        hash = (53 * hash) + getBigqueryPolicyTagsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Describes a column.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor)
        com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_RelationDescriptor_ColumnDescriptor_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_RelationDescriptor_ColumnDescriptor_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor.class,
                com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor.Builder.class);
      }

      // Construct using
      // com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        path_ = com.google.protobuf.LazyStringArrayList.emptyList();
        description_ = "";
        bigqueryPolicyTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_RelationDescriptor_ColumnDescriptor_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor
          getDefaultInstanceForType() {
        return com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor build() {
        com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor buildPartial() {
        com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor result =
            new com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          path_.makeImmutable();
          result.path_ = path_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.description_ = description_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          bigqueryPolicyTags_.makeImmutable();
          result.bigqueryPolicyTags_ = bigqueryPolicyTags_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor) {
          return mergeFrom(
              (com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor other) {
        if (other
            == com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor
                .getDefaultInstance()) return this;
        if (!other.path_.isEmpty()) {
          if (path_.isEmpty()) {
            path_ = other.path_;
            bitField0_ |= 0x00000001;
          } else {
            ensurePathIsMutable();
            path_.addAll(other.path_);
          }
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.bigqueryPolicyTags_.isEmpty()) {
          if (bigqueryPolicyTags_.isEmpty()) {
            bigqueryPolicyTags_ = other.bigqueryPolicyTags_;
            bitField0_ |= 0x00000004;
          } else {
            ensureBigqueryPolicyTagsIsMutable();
            bigqueryPolicyTags_.addAll(other.bigqueryPolicyTags_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensurePathIsMutable();
                  path_.add(s);
                  break;
                } // case 10
              case 18:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureBigqueryPolicyTagsIsMutable();
                  bigqueryPolicyTags_.add(s);
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList path_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensurePathIsMutable() {
        if (!path_.isModifiable()) {
          path_ = new com.google.protobuf.LazyStringArrayList(path_);
        }
        bitField0_ |= 0x00000001;
      }

      /**
       *
       *
       * <pre>
       * The identifier for the column. Each entry in `path` represents one level
       * of nesting.
       * </pre>
       *
       * <code>repeated string path = 1;</code>
       *
       * @return A list containing the path.
       */
      public com.google.protobuf.ProtocolStringList getPathList() {
        path_.makeImmutable();
        return path_;
      }

      /**
       *
       *
       * <pre>
       * The identifier for the column. Each entry in `path` represents one level
       * of nesting.
       * </pre>
       *
       * <code>repeated string path = 1;</code>
       *
       * @return The count of path.
       */
      public int getPathCount() {
        return path_.size();
      }

      /**
       *
       *
       * <pre>
       * The identifier for the column. Each entry in `path` represents one level
       * of nesting.
       * </pre>
       *
       * <code>repeated string path = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The path at the given index.
       */
      public java.lang.String getPath(int index) {
        return path_.get(index);
      }

      /**
       *
       *
       * <pre>
       * The identifier for the column. Each entry in `path` represents one level
       * of nesting.
       * </pre>
       *
       * <code>repeated string path = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the path at the given index.
       */
      public com.google.protobuf.ByteString getPathBytes(int index) {
        return path_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * The identifier for the column. Each entry in `path` represents one level
       * of nesting.
       * </pre>
       *
       * <code>repeated string path = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePathIsMutable();
        path_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The identifier for the column. Each entry in `path` represents one level
       * of nesting.
       * </pre>
       *
       * <code>repeated string path = 1;</code>
       *
       * @param value The path to add.
       * @return This builder for chaining.
       */
      public Builder addPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePathIsMutable();
        path_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The identifier for the column. Each entry in `path` represents one level
       * of nesting.
       * </pre>
       *
       * <code>repeated string path = 1;</code>
       *
       * @param values The path to add.
       * @return This builder for chaining.
       */
      public Builder addAllPath(java.lang.Iterable<java.lang.String> values) {
        ensurePathIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, path_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The identifier for the column. Each entry in `path` represents one level
       * of nesting.
       * </pre>
       *
       * <code>repeated string path = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPath() {
        path_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The identifier for the column. Each entry in `path` represents one level
       * of nesting.
       * </pre>
       *
       * <code>repeated string path = 1;</code>
       *
       * @param value The bytes of the path to add.
       * @return This builder for chaining.
       */
      public Builder addPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensurePathIsMutable();
        path_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";

      /**
       *
       *
       * <pre>
       * A textual description of the column.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * A textual description of the column.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * A textual description of the column.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A textual description of the column.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A textual description of the column.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList bigqueryPolicyTags_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureBigqueryPolicyTagsIsMutable() {
        if (!bigqueryPolicyTags_.isModifiable()) {
          bigqueryPolicyTags_ = new com.google.protobuf.LazyStringArrayList(bigqueryPolicyTags_);
        }
        bitField0_ |= 0x00000004;
      }

      /**
       *
       *
       * <pre>
       * A list of BigQuery policy tags that will be applied to the column.
       * </pre>
       *
       * <code>repeated string bigquery_policy_tags = 3;</code>
       *
       * @return A list containing the bigqueryPolicyTags.
       */
      public com.google.protobuf.ProtocolStringList getBigqueryPolicyTagsList() {
        bigqueryPolicyTags_.makeImmutable();
        return bigqueryPolicyTags_;
      }

      /**
       *
       *
       * <pre>
       * A list of BigQuery policy tags that will be applied to the column.
       * </pre>
       *
       * <code>repeated string bigquery_policy_tags = 3;</code>
       *
       * @return The count of bigqueryPolicyTags.
       */
      public int getBigqueryPolicyTagsCount() {
        return bigqueryPolicyTags_.size();
      }

      /**
       *
       *
       * <pre>
       * A list of BigQuery policy tags that will be applied to the column.
       * </pre>
       *
       * <code>repeated string bigquery_policy_tags = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The bigqueryPolicyTags at the given index.
       */
      public java.lang.String getBigqueryPolicyTags(int index) {
        return bigqueryPolicyTags_.get(index);
      }

      /**
       *
       *
       * <pre>
       * A list of BigQuery policy tags that will be applied to the column.
       * </pre>
       *
       * <code>repeated string bigquery_policy_tags = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the bigqueryPolicyTags at the given index.
       */
      public com.google.protobuf.ByteString getBigqueryPolicyTagsBytes(int index) {
        return bigqueryPolicyTags_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * A list of BigQuery policy tags that will be applied to the column.
       * </pre>
       *
       * <code>repeated string bigquery_policy_tags = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The bigqueryPolicyTags to set.
       * @return This builder for chaining.
       */
      public Builder setBigqueryPolicyTags(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBigqueryPolicyTagsIsMutable();
        bigqueryPolicyTags_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of BigQuery policy tags that will be applied to the column.
       * </pre>
       *
       * <code>repeated string bigquery_policy_tags = 3;</code>
       *
       * @param value The bigqueryPolicyTags to add.
       * @return This builder for chaining.
       */
      public Builder addBigqueryPolicyTags(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBigqueryPolicyTagsIsMutable();
        bigqueryPolicyTags_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of BigQuery policy tags that will be applied to the column.
       * </pre>
       *
       * <code>repeated string bigquery_policy_tags = 3;</code>
       *
       * @param values The bigqueryPolicyTags to add.
       * @return This builder for chaining.
       */
      public Builder addAllBigqueryPolicyTags(java.lang.Iterable<java.lang.String> values) {
        ensureBigqueryPolicyTagsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bigqueryPolicyTags_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of BigQuery policy tags that will be applied to the column.
       * </pre>
       *
       * <code>repeated string bigquery_policy_tags = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBigqueryPolicyTags() {
        bigqueryPolicyTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of BigQuery policy tags that will be applied to the column.
       * </pre>
       *
       * <code>repeated string bigquery_policy_tags = 3;</code>
       *
       * @param value The bytes of the bigqueryPolicyTags to add.
       * @return This builder for chaining.
       */
      public Builder addBigqueryPolicyTagsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureBigqueryPolicyTagsIsMutable();
        bigqueryPolicyTags_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor)
    private static final com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor();
    }

    public static com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ColumnDescriptor> PARSER =
        new com.google.protobuf.AbstractParser<ColumnDescriptor>() {
          @java.lang.Override
          public ColumnDescriptor parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ColumnDescriptor> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ColumnDescriptor> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * A text description of the relation.
   * </pre>
   *
   * <code>string description = 1;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A text description of the relation.
   * </pre>
   *
   * <code>string description = 1;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COLUMNS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor> columns_;

  /**
   *
   *
   * <pre>
   * A list of descriptions of columns within the relation.
   * </pre>
   *
   * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor>
      getColumnsList() {
    return columns_;
  }

  /**
   *
   *
   * <pre>
   * A list of descriptions of columns within the relation.
   * </pre>
   *
   * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptorOrBuilder>
      getColumnsOrBuilderList() {
    return columns_;
  }

  /**
   *
   *
   * <pre>
   * A list of descriptions of columns within the relation.
   * </pre>
   *
   * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
   * </code>
   */
  @java.lang.Override
  public int getColumnsCount() {
    return columns_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of descriptions of columns within the relation.
   * </pre>
   *
   * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor getColumns(int index) {
    return columns_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of descriptions of columns within the relation.
   * </pre>
   *
   * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptorOrBuilder
      getColumnsOrBuilder(int index) {
    return columns_.get(index);
  }

  public static final int BIGQUERY_LABELS_FIELD_NUMBER = 3;

  private static final class BigqueryLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataform.v1.DataformProto
                .internal_static_google_cloud_dataform_v1_RelationDescriptor_BigqueryLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> bigqueryLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetBigqueryLabels() {
    if (bigqueryLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          BigqueryLabelsDefaultEntryHolder.defaultEntry);
    }
    return bigqueryLabels_;
  }

  public int getBigqueryLabelsCount() {
    return internalGetBigqueryLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * A set of BigQuery labels that should be applied to the relation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; bigquery_labels = 3;</code>
   */
  @java.lang.Override
  public boolean containsBigqueryLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetBigqueryLabels().getMap().containsKey(key);
  }

  /** Use {@link #getBigqueryLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getBigqueryLabels() {
    return getBigqueryLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * A set of BigQuery labels that should be applied to the relation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; bigquery_labels = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getBigqueryLabelsMap() {
    return internalGetBigqueryLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * A set of BigQuery labels that should be applied to the relation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; bigquery_labels = 3;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getBigqueryLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetBigqueryLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * A set of BigQuery labels that should be applied to the relation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; bigquery_labels = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getBigqueryLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetBigqueryLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, description_);
    }
    for (int i = 0; i < columns_.size(); i++) {
      output.writeMessage(2, columns_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetBigqueryLabels(), BigqueryLabelsDefaultEntryHolder.defaultEntry, 3);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, description_);
    }
    for (int i = 0; i < columns_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, columns_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetBigqueryLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> bigqueryLabels__ =
          BigqueryLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, bigqueryLabels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataform.v1.RelationDescriptor)) {
      return super.equals(obj);
    }
    com.google.cloud.dataform.v1.RelationDescriptor other =
        (com.google.cloud.dataform.v1.RelationDescriptor) obj;

    if (!getDescription().equals(other.getDescription())) return false;
    if (!getColumnsList().equals(other.getColumnsList())) return false;
    if (!internalGetBigqueryLabels().equals(other.internalGetBigqueryLabels())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getColumnsCount() > 0) {
      hash = (37 * hash) + COLUMNS_FIELD_NUMBER;
      hash = (53 * hash) + getColumnsList().hashCode();
    }
    if (!internalGetBigqueryLabels().getMap().isEmpty()) {
      hash = (37 * hash) + BIGQUERY_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetBigqueryLabels().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataform.v1.RelationDescriptor parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.RelationDescriptor parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.RelationDescriptor parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.RelationDescriptor parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.RelationDescriptor parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.RelationDescriptor parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.RelationDescriptor parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.RelationDescriptor parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.RelationDescriptor parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.RelationDescriptor parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.RelationDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.RelationDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataform.v1.RelationDescriptor prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Describes a relation and its columns.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.RelationDescriptor}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.RelationDescriptor)
      com.google.cloud.dataform.v1.RelationDescriptorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_RelationDescriptor_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetBigqueryLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMutableBigqueryLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_RelationDescriptor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.RelationDescriptor.class,
              com.google.cloud.dataform.v1.RelationDescriptor.Builder.class);
    }

    // Construct using com.google.cloud.dataform.v1.RelationDescriptor.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      description_ = "";
      if (columnsBuilder_ == null) {
        columns_ = java.util.Collections.emptyList();
      } else {
        columns_ = null;
        columnsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableBigqueryLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_RelationDescriptor_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.RelationDescriptor getDefaultInstanceForType() {
      return com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.RelationDescriptor build() {
      com.google.cloud.dataform.v1.RelationDescriptor result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.RelationDescriptor buildPartial() {
      com.google.cloud.dataform.v1.RelationDescriptor result =
          new com.google.cloud.dataform.v1.RelationDescriptor(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dataform.v1.RelationDescriptor result) {
      if (columnsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          columns_ = java.util.Collections.unmodifiableList(columns_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.columns_ = columns_;
      } else {
        result.columns_ = columnsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dataform.v1.RelationDescriptor result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.bigqueryLabels_ = internalGetBigqueryLabels();
        result.bigqueryLabels_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataform.v1.RelationDescriptor) {
        return mergeFrom((com.google.cloud.dataform.v1.RelationDescriptor) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataform.v1.RelationDescriptor other) {
      if (other == com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance())
        return this;
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (columnsBuilder_ == null) {
        if (!other.columns_.isEmpty()) {
          if (columns_.isEmpty()) {
            columns_ = other.columns_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureColumnsIsMutable();
            columns_.addAll(other.columns_);
          }
          onChanged();
        }
      } else {
        if (!other.columns_.isEmpty()) {
          if (columnsBuilder_.isEmpty()) {
            columnsBuilder_.dispose();
            columnsBuilder_ = null;
            columns_ = other.columns_;
            bitField0_ = (bitField0_ & ~0x00000002);
            columnsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getColumnsFieldBuilder()
                    : null;
          } else {
            columnsBuilder_.addAllMessages(other.columns_);
          }
        }
      }
      internalGetMutableBigqueryLabels().mergeFrom(other.internalGetBigqueryLabels());
      bitField0_ |= 0x00000004;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor m =
                    input.readMessage(
                        com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor.parser(),
                        extensionRegistry);
                if (columnsBuilder_ == null) {
                  ensureColumnsIsMutable();
                  columns_.add(m);
                } else {
                  columnsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> bigqueryLabels__ =
                    input.readMessage(
                        BigqueryLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableBigqueryLabels()
                    .getMutableMap()
                    .put(bigqueryLabels__.getKey(), bigqueryLabels__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * A text description of the relation.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A text description of the relation.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A text description of the relation.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A text description of the relation.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A text description of the relation.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor>
        columns_ = java.util.Collections.emptyList();

    private void ensureColumnsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        columns_ =
            new java.util.ArrayList<
                com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor>(columns_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor,
            com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor.Builder,
            com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptorOrBuilder>
        columnsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of descriptions of columns within the relation.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor>
        getColumnsList() {
      if (columnsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(columns_);
      } else {
        return columnsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of descriptions of columns within the relation.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
     * </code>
     */
    public int getColumnsCount() {
      if (columnsBuilder_ == null) {
        return columns_.size();
      } else {
        return columnsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of descriptions of columns within the relation.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
     * </code>
     */
    public com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor getColumns(int index) {
      if (columnsBuilder_ == null) {
        return columns_.get(index);
      } else {
        return columnsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of descriptions of columns within the relation.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
     * </code>
     */
    public Builder setColumns(
        int index, com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor value) {
      if (columnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureColumnsIsMutable();
        columns_.set(index, value);
        onChanged();
      } else {
        columnsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of descriptions of columns within the relation.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
     * </code>
     */
    public Builder setColumns(
        int index,
        com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor.Builder builderForValue) {
      if (columnsBuilder_ == null) {
        ensureColumnsIsMutable();
        columns_.set(index, builderForValue.build());
        onChanged();
      } else {
        columnsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of descriptions of columns within the relation.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
     * </code>
     */
    public Builder addColumns(
        com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor value) {
      if (columnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureColumnsIsMutable();
        columns_.add(value);
        onChanged();
      } else {
        columnsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of descriptions of columns within the relation.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
     * </code>
     */
    public Builder addColumns(
        int index, com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor value) {
      if (columnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureColumnsIsMutable();
        columns_.add(index, value);
        onChanged();
      } else {
        columnsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of descriptions of columns within the relation.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
     * </code>
     */
    public Builder addColumns(
        com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor.Builder builderForValue) {
      if (columnsBuilder_ == null) {
        ensureColumnsIsMutable();
        columns_.add(builderForValue.build());
        onChanged();
      } else {
        columnsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of descriptions of columns within the relation.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
     * </code>
     */
    public Builder addColumns(
        int index,
        com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor.Builder builderForValue) {
      if (columnsBuilder_ == null) {
        ensureColumnsIsMutable();
        columns_.add(index, builderForValue.build());
        onChanged();
      } else {
        columnsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of descriptions of columns within the relation.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
     * </code>
     */
    public Builder addAllColumns(
        java.lang.Iterable<
                ? extends com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor>
            values) {
      if (columnsBuilder_ == null) {
        ensureColumnsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, columns_);
        onChanged();
      } else {
        columnsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of descriptions of columns within the relation.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
     * </code>
     */
    public Builder clearColumns() {
      if (columnsBuilder_ == null) {
        columns_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        columnsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of descriptions of columns within the relation.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
     * </code>
     */
    public Builder removeColumns(int index) {
      if (columnsBuilder_ == null) {
        ensureColumnsIsMutable();
        columns_.remove(index);
        onChanged();
      } else {
        columnsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of descriptions of columns within the relation.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
     * </code>
     */
    public com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor.Builder
        getColumnsBuilder(int index) {
      return getColumnsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of descriptions of columns within the relation.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
     * </code>
     */
    public com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptorOrBuilder
        getColumnsOrBuilder(int index) {
      if (columnsBuilder_ == null) {
        return columns_.get(index);
      } else {
        return columnsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of descriptions of columns within the relation.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptorOrBuilder>
        getColumnsOrBuilderList() {
      if (columnsBuilder_ != null) {
        return columnsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(columns_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of descriptions of columns within the relation.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
     * </code>
     */
    public com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor.Builder
        addColumnsBuilder() {
      return getColumnsFieldBuilder()
          .addBuilder(
              com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of descriptions of columns within the relation.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
     * </code>
     */
    public com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor.Builder
        addColumnsBuilder(int index) {
      return getColumnsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of descriptions of columns within the relation.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor columns = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor.Builder>
        getColumnsBuilderList() {
      return getColumnsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor,
            com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor.Builder,
            com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptorOrBuilder>
        getColumnsFieldBuilder() {
      if (columnsBuilder_ == null) {
        columnsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor,
                com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptor.Builder,
                com.google.cloud.dataform.v1.RelationDescriptor.ColumnDescriptorOrBuilder>(
                columns_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        columns_ = null;
      }
      return columnsBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> bigqueryLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetBigqueryLabels() {
      if (bigqueryLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            BigqueryLabelsDefaultEntryHolder.defaultEntry);
      }
      return bigqueryLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableBigqueryLabels() {
      if (bigqueryLabels_ == null) {
        bigqueryLabels_ =
            com.google.protobuf.MapField.newMapField(BigqueryLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!bigqueryLabels_.isMutable()) {
        bigqueryLabels_ = bigqueryLabels_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return bigqueryLabels_;
    }

    public int getBigqueryLabelsCount() {
      return internalGetBigqueryLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * A set of BigQuery labels that should be applied to the relation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_labels = 3;</code>
     */
    @java.lang.Override
    public boolean containsBigqueryLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetBigqueryLabels().getMap().containsKey(key);
    }

    /** Use {@link #getBigqueryLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getBigqueryLabels() {
      return getBigqueryLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * A set of BigQuery labels that should be applied to the relation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_labels = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getBigqueryLabelsMap() {
      return internalGetBigqueryLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * A set of BigQuery labels that should be applied to the relation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_labels = 3;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getBigqueryLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetBigqueryLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * A set of BigQuery labels that should be applied to the relation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_labels = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getBigqueryLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetBigqueryLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearBigqueryLabels() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableBigqueryLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A set of BigQuery labels that should be applied to the relation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_labels = 3;</code>
     */
    public Builder removeBigqueryLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableBigqueryLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableBigqueryLabels() {
      bitField0_ |= 0x00000004;
      return internalGetMutableBigqueryLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * A set of BigQuery labels that should be applied to the relation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_labels = 3;</code>
     */
    public Builder putBigqueryLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableBigqueryLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A set of BigQuery labels that should be applied to the relation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_labels = 3;</code>
     */
    public Builder putAllBigqueryLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableBigqueryLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.RelationDescriptor)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.RelationDescriptor)
  private static final com.google.cloud.dataform.v1.RelationDescriptor DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.RelationDescriptor();
  }

  public static com.google.cloud.dataform.v1.RelationDescriptor getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RelationDescriptor> PARSER =
      new com.google.protobuf.AbstractParser<RelationDescriptor>() {
        @java.lang.Override
        public RelationDescriptor parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RelationDescriptor> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RelationDescriptor> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataform.v1.RelationDescriptor getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
