/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataform/v1/dataform.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.dataform.v1;

/**
 *
 *
 * <pre>
 * Includes various configuration options for a workflow invocation.
 * If both `included_targets` and `included_tags` are unset, all actions
 * will be included.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataform.v1.InvocationConfig}
 */
public final class InvocationConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.InvocationConfig)
    InvocationConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use InvocationConfig.newBuilder() to construct.
  private InvocationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InvocationConfig() {
    includedTargets_ = java.util.Collections.emptyList();
    includedTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
    serviceAccount_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InvocationConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_InvocationConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_InvocationConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataform.v1.InvocationConfig.class,
            com.google.cloud.dataform.v1.InvocationConfig.Builder.class);
  }

  public static final int INCLUDED_TARGETS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dataform.v1.Target> includedTargets_;

  /**
   *
   *
   * <pre>
   * Optional. The set of action identifiers to include.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataform.v1.Target> getIncludedTargetsList() {
    return includedTargets_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The set of action identifiers to include.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dataform.v1.TargetOrBuilder>
      getIncludedTargetsOrBuilderList() {
    return includedTargets_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The set of action identifiers to include.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getIncludedTargetsCount() {
    return includedTargets_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. The set of action identifiers to include.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.Target getIncludedTargets(int index) {
    return includedTargets_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. The set of action identifiers to include.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.TargetOrBuilder getIncludedTargetsOrBuilder(int index) {
    return includedTargets_.get(index);
  }

  public static final int INCLUDED_TAGS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList includedTags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Optional. The set of tags to include.
   * </pre>
   *
   * <code>repeated string included_tags = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the includedTags.
   */
  public com.google.protobuf.ProtocolStringList getIncludedTagsList() {
    return includedTags_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The set of tags to include.
   * </pre>
   *
   * <code>repeated string included_tags = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of includedTags.
   */
  public int getIncludedTagsCount() {
    return includedTags_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. The set of tags to include.
   * </pre>
   *
   * <code>repeated string included_tags = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The includedTags at the given index.
   */
  public java.lang.String getIncludedTags(int index) {
    return includedTags_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. The set of tags to include.
   * </pre>
   *
   * <code>repeated string included_tags = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the includedTags at the given index.
   */
  public com.google.protobuf.ByteString getIncludedTagsBytes(int index) {
    return includedTags_.getByteString(index);
  }

  public static final int TRANSITIVE_DEPENDENCIES_INCLUDED_FIELD_NUMBER = 3;
  private boolean transitiveDependenciesIncluded_ = false;

  /**
   *
   *
   * <pre>
   * Optional. When set to true, transitive dependencies of included actions
   * will be executed.
   * </pre>
   *
   * <code>bool transitive_dependencies_included = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The transitiveDependenciesIncluded.
   */
  @java.lang.Override
  public boolean getTransitiveDependenciesIncluded() {
    return transitiveDependenciesIncluded_;
  }

  public static final int TRANSITIVE_DEPENDENTS_INCLUDED_FIELD_NUMBER = 4;
  private boolean transitiveDependentsIncluded_ = false;

  /**
   *
   *
   * <pre>
   * Optional. When set to true, transitive dependents of included actions will
   * be executed.
   * </pre>
   *
   * <code>bool transitive_dependents_included = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The transitiveDependentsIncluded.
   */
  @java.lang.Override
  public boolean getTransitiveDependentsIncluded() {
    return transitiveDependentsIncluded_;
  }

  public static final int FULLY_REFRESH_INCREMENTAL_TABLES_ENABLED_FIELD_NUMBER = 5;
  private boolean fullyRefreshIncrementalTablesEnabled_ = false;

  /**
   *
   *
   * <pre>
   * Optional. When set to true, any incremental tables will be fully refreshed.
   * </pre>
   *
   * <code>
   * bool fully_refresh_incremental_tables_enabled = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The fullyRefreshIncrementalTablesEnabled.
   */
  @java.lang.Override
  public boolean getFullyRefreshIncrementalTablesEnabled() {
    return fullyRefreshIncrementalTablesEnabled_;
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The service account to run workflow invocations under.
   * </pre>
   *
   * <code>string service_account = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The service account to run workflow invocations under.
   * </pre>
   *
   * <code>string service_account = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < includedTargets_.size(); i++) {
      output.writeMessage(1, includedTargets_.get(i));
    }
    for (int i = 0; i < includedTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, includedTags_.getRaw(i));
    }
    if (transitiveDependenciesIncluded_ != false) {
      output.writeBool(3, transitiveDependenciesIncluded_);
    }
    if (transitiveDependentsIncluded_ != false) {
      output.writeBool(4, transitiveDependentsIncluded_);
    }
    if (fullyRefreshIncrementalTablesEnabled_ != false) {
      output.writeBool(5, fullyRefreshIncrementalTablesEnabled_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, serviceAccount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < includedTargets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, includedTargets_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < includedTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(includedTags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getIncludedTagsList().size();
    }
    if (transitiveDependenciesIncluded_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(3, transitiveDependenciesIncluded_);
    }
    if (transitiveDependentsIncluded_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(4, transitiveDependentsIncluded_);
    }
    if (fullyRefreshIncrementalTablesEnabled_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              5, fullyRefreshIncrementalTablesEnabled_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, serviceAccount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataform.v1.InvocationConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dataform.v1.InvocationConfig other =
        (com.google.cloud.dataform.v1.InvocationConfig) obj;

    if (!getIncludedTargetsList().equals(other.getIncludedTargetsList())) return false;
    if (!getIncludedTagsList().equals(other.getIncludedTagsList())) return false;
    if (getTransitiveDependenciesIncluded() != other.getTransitiveDependenciesIncluded())
      return false;
    if (getTransitiveDependentsIncluded() != other.getTransitiveDependentsIncluded()) return false;
    if (getFullyRefreshIncrementalTablesEnabled()
        != other.getFullyRefreshIncrementalTablesEnabled()) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getIncludedTargetsCount() > 0) {
      hash = (37 * hash) + INCLUDED_TARGETS_FIELD_NUMBER;
      hash = (53 * hash) + getIncludedTargetsList().hashCode();
    }
    if (getIncludedTagsCount() > 0) {
      hash = (37 * hash) + INCLUDED_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getIncludedTagsList().hashCode();
    }
    hash = (37 * hash) + TRANSITIVE_DEPENDENCIES_INCLUDED_FIELD_NUMBER;
    hash =
        (53 * hash) + com.google.protobuf.Internal.hashBoolean(getTransitiveDependenciesIncluded());
    hash = (37 * hash) + TRANSITIVE_DEPENDENTS_INCLUDED_FIELD_NUMBER;
    hash =
        (53 * hash) + com.google.protobuf.Internal.hashBoolean(getTransitiveDependentsIncluded());
    hash = (37 * hash) + FULLY_REFRESH_INCREMENTAL_TABLES_ENABLED_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashBoolean(getFullyRefreshIncrementalTablesEnabled());
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataform.v1.InvocationConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.InvocationConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.InvocationConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.InvocationConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.InvocationConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.InvocationConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.InvocationConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.InvocationConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.InvocationConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.InvocationConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.InvocationConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.InvocationConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataform.v1.InvocationConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Includes various configuration options for a workflow invocation.
   * If both `included_targets` and `included_tags` are unset, all actions
   * will be included.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.InvocationConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.InvocationConfig)
      com.google.cloud.dataform.v1.InvocationConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_InvocationConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_InvocationConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.InvocationConfig.class,
              com.google.cloud.dataform.v1.InvocationConfig.Builder.class);
    }

    // Construct using com.google.cloud.dataform.v1.InvocationConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (includedTargetsBuilder_ == null) {
        includedTargets_ = java.util.Collections.emptyList();
      } else {
        includedTargets_ = null;
        includedTargetsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      includedTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      transitiveDependenciesIncluded_ = false;
      transitiveDependentsIncluded_ = false;
      fullyRefreshIncrementalTablesEnabled_ = false;
      serviceAccount_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_InvocationConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.InvocationConfig getDefaultInstanceForType() {
      return com.google.cloud.dataform.v1.InvocationConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.InvocationConfig build() {
      com.google.cloud.dataform.v1.InvocationConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.InvocationConfig buildPartial() {
      com.google.cloud.dataform.v1.InvocationConfig result =
          new com.google.cloud.dataform.v1.InvocationConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dataform.v1.InvocationConfig result) {
      if (includedTargetsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          includedTargets_ = java.util.Collections.unmodifiableList(includedTargets_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.includedTargets_ = includedTargets_;
      } else {
        result.includedTargets_ = includedTargetsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dataform.v1.InvocationConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        includedTags_.makeImmutable();
        result.includedTags_ = includedTags_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.transitiveDependenciesIncluded_ = transitiveDependenciesIncluded_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.transitiveDependentsIncluded_ = transitiveDependentsIncluded_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.fullyRefreshIncrementalTablesEnabled_ = fullyRefreshIncrementalTablesEnabled_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataform.v1.InvocationConfig) {
        return mergeFrom((com.google.cloud.dataform.v1.InvocationConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataform.v1.InvocationConfig other) {
      if (other == com.google.cloud.dataform.v1.InvocationConfig.getDefaultInstance()) return this;
      if (includedTargetsBuilder_ == null) {
        if (!other.includedTargets_.isEmpty()) {
          if (includedTargets_.isEmpty()) {
            includedTargets_ = other.includedTargets_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureIncludedTargetsIsMutable();
            includedTargets_.addAll(other.includedTargets_);
          }
          onChanged();
        }
      } else {
        if (!other.includedTargets_.isEmpty()) {
          if (includedTargetsBuilder_.isEmpty()) {
            includedTargetsBuilder_.dispose();
            includedTargetsBuilder_ = null;
            includedTargets_ = other.includedTargets_;
            bitField0_ = (bitField0_ & ~0x00000001);
            includedTargetsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getIncludedTargetsFieldBuilder()
                    : null;
          } else {
            includedTargetsBuilder_.addAllMessages(other.includedTargets_);
          }
        }
      }
      if (!other.includedTags_.isEmpty()) {
        if (includedTags_.isEmpty()) {
          includedTags_ = other.includedTags_;
          bitField0_ |= 0x00000002;
        } else {
          ensureIncludedTagsIsMutable();
          includedTags_.addAll(other.includedTags_);
        }
        onChanged();
      }
      if (other.getTransitiveDependenciesIncluded() != false) {
        setTransitiveDependenciesIncluded(other.getTransitiveDependenciesIncluded());
      }
      if (other.getTransitiveDependentsIncluded() != false) {
        setTransitiveDependentsIncluded(other.getTransitiveDependentsIncluded());
      }
      if (other.getFullyRefreshIncrementalTablesEnabled() != false) {
        setFullyRefreshIncrementalTablesEnabled(other.getFullyRefreshIncrementalTablesEnabled());
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.dataform.v1.Target m =
                    input.readMessage(
                        com.google.cloud.dataform.v1.Target.parser(), extensionRegistry);
                if (includedTargetsBuilder_ == null) {
                  ensureIncludedTargetsIsMutable();
                  includedTargets_.add(m);
                } else {
                  includedTargetsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIncludedTagsIsMutable();
                includedTags_.add(s);
                break;
              } // case 18
            case 24:
              {
                transitiveDependenciesIncluded_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                transitiveDependentsIncluded_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                fullyRefreshIncrementalTablesEnabled_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.dataform.v1.Target> includedTargets_ =
        java.util.Collections.emptyList();

    private void ensureIncludedTargetsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        includedTargets_ =
            new java.util.ArrayList<com.google.cloud.dataform.v1.Target>(includedTargets_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataform.v1.Target,
            com.google.cloud.dataform.v1.Target.Builder,
            com.google.cloud.dataform.v1.TargetOrBuilder>
        includedTargetsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The set of action identifiers to include.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dataform.v1.Target> getIncludedTargetsList() {
      if (includedTargetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(includedTargets_);
      } else {
        return includedTargetsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of action identifiers to include.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getIncludedTargetsCount() {
      if (includedTargetsBuilder_ == null) {
        return includedTargets_.size();
      } else {
        return includedTargetsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of action identifiers to include.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataform.v1.Target getIncludedTargets(int index) {
      if (includedTargetsBuilder_ == null) {
        return includedTargets_.get(index);
      } else {
        return includedTargetsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of action identifiers to include.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setIncludedTargets(int index, com.google.cloud.dataform.v1.Target value) {
      if (includedTargetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIncludedTargetsIsMutable();
        includedTargets_.set(index, value);
        onChanged();
      } else {
        includedTargetsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of action identifiers to include.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setIncludedTargets(
        int index, com.google.cloud.dataform.v1.Target.Builder builderForValue) {
      if (includedTargetsBuilder_ == null) {
        ensureIncludedTargetsIsMutable();
        includedTargets_.set(index, builderForValue.build());
        onChanged();
      } else {
        includedTargetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of action identifiers to include.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addIncludedTargets(com.google.cloud.dataform.v1.Target value) {
      if (includedTargetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIncludedTargetsIsMutable();
        includedTargets_.add(value);
        onChanged();
      } else {
        includedTargetsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of action identifiers to include.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addIncludedTargets(int index, com.google.cloud.dataform.v1.Target value) {
      if (includedTargetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIncludedTargetsIsMutable();
        includedTargets_.add(index, value);
        onChanged();
      } else {
        includedTargetsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of action identifiers to include.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addIncludedTargets(com.google.cloud.dataform.v1.Target.Builder builderForValue) {
      if (includedTargetsBuilder_ == null) {
        ensureIncludedTargetsIsMutable();
        includedTargets_.add(builderForValue.build());
        onChanged();
      } else {
        includedTargetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of action identifiers to include.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addIncludedTargets(
        int index, com.google.cloud.dataform.v1.Target.Builder builderForValue) {
      if (includedTargetsBuilder_ == null) {
        ensureIncludedTargetsIsMutable();
        includedTargets_.add(index, builderForValue.build());
        onChanged();
      } else {
        includedTargetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of action identifiers to include.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllIncludedTargets(
        java.lang.Iterable<? extends com.google.cloud.dataform.v1.Target> values) {
      if (includedTargetsBuilder_ == null) {
        ensureIncludedTargetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, includedTargets_);
        onChanged();
      } else {
        includedTargetsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of action identifiers to include.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearIncludedTargets() {
      if (includedTargetsBuilder_ == null) {
        includedTargets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        includedTargetsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of action identifiers to include.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeIncludedTargets(int index) {
      if (includedTargetsBuilder_ == null) {
        ensureIncludedTargetsIsMutable();
        includedTargets_.remove(index);
        onChanged();
      } else {
        includedTargetsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of action identifiers to include.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataform.v1.Target.Builder getIncludedTargetsBuilder(int index) {
      return getIncludedTargetsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of action identifiers to include.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataform.v1.TargetOrBuilder getIncludedTargetsOrBuilder(int index) {
      if (includedTargetsBuilder_ == null) {
        return includedTargets_.get(index);
      } else {
        return includedTargetsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of action identifiers to include.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dataform.v1.TargetOrBuilder>
        getIncludedTargetsOrBuilderList() {
      if (includedTargetsBuilder_ != null) {
        return includedTargetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(includedTargets_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of action identifiers to include.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataform.v1.Target.Builder addIncludedTargetsBuilder() {
      return getIncludedTargetsFieldBuilder()
          .addBuilder(com.google.cloud.dataform.v1.Target.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of action identifiers to include.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataform.v1.Target.Builder addIncludedTargetsBuilder(int index) {
      return getIncludedTargetsFieldBuilder()
          .addBuilder(index, com.google.cloud.dataform.v1.Target.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of action identifiers to include.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataform.v1.Target included_targets = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dataform.v1.Target.Builder>
        getIncludedTargetsBuilderList() {
      return getIncludedTargetsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataform.v1.Target,
            com.google.cloud.dataform.v1.Target.Builder,
            com.google.cloud.dataform.v1.TargetOrBuilder>
        getIncludedTargetsFieldBuilder() {
      if (includedTargetsBuilder_ == null) {
        includedTargetsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataform.v1.Target,
                com.google.cloud.dataform.v1.Target.Builder,
                com.google.cloud.dataform.v1.TargetOrBuilder>(
                includedTargets_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        includedTargets_ = null;
      }
      return includedTargetsBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList includedTags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIncludedTagsIsMutable() {
      if (!includedTags_.isModifiable()) {
        includedTags_ = new com.google.protobuf.LazyStringArrayList(includedTags_);
      }
      bitField0_ |= 0x00000002;
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of tags to include.
     * </pre>
     *
     * <code>repeated string included_tags = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the includedTags.
     */
    public com.google.protobuf.ProtocolStringList getIncludedTagsList() {
      includedTags_.makeImmutable();
      return includedTags_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of tags to include.
     * </pre>
     *
     * <code>repeated string included_tags = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of includedTags.
     */
    public int getIncludedTagsCount() {
      return includedTags_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of tags to include.
     * </pre>
     *
     * <code>repeated string included_tags = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The includedTags at the given index.
     */
    public java.lang.String getIncludedTags(int index) {
      return includedTags_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of tags to include.
     * </pre>
     *
     * <code>repeated string included_tags = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the includedTags at the given index.
     */
    public com.google.protobuf.ByteString getIncludedTagsBytes(int index) {
      return includedTags_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of tags to include.
     * </pre>
     *
     * <code>repeated string included_tags = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The includedTags to set.
     * @return This builder for chaining.
     */
    public Builder setIncludedTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludedTagsIsMutable();
      includedTags_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of tags to include.
     * </pre>
     *
     * <code>repeated string included_tags = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The includedTags to add.
     * @return This builder for chaining.
     */
    public Builder addIncludedTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludedTagsIsMutable();
      includedTags_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of tags to include.
     * </pre>
     *
     * <code>repeated string included_tags = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The includedTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllIncludedTags(java.lang.Iterable<java.lang.String> values) {
      ensureIncludedTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, includedTags_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of tags to include.
     * </pre>
     *
     * <code>repeated string included_tags = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludedTags() {
      includedTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The set of tags to include.
     * </pre>
     *
     * <code>repeated string included_tags = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the includedTags to add.
     * @return This builder for chaining.
     */
    public Builder addIncludedTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIncludedTagsIsMutable();
      includedTags_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private boolean transitiveDependenciesIncluded_;

    /**
     *
     *
     * <pre>
     * Optional. When set to true, transitive dependencies of included actions
     * will be executed.
     * </pre>
     *
     * <code>bool transitive_dependencies_included = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The transitiveDependenciesIncluded.
     */
    @java.lang.Override
    public boolean getTransitiveDependenciesIncluded() {
      return transitiveDependenciesIncluded_;
    }

    /**
     *
     *
     * <pre>
     * Optional. When set to true, transitive dependencies of included actions
     * will be executed.
     * </pre>
     *
     * <code>bool transitive_dependencies_included = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The transitiveDependenciesIncluded to set.
     * @return This builder for chaining.
     */
    public Builder setTransitiveDependenciesIncluded(boolean value) {

      transitiveDependenciesIncluded_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. When set to true, transitive dependencies of included actions
     * will be executed.
     * </pre>
     *
     * <code>bool transitive_dependencies_included = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransitiveDependenciesIncluded() {
      bitField0_ = (bitField0_ & ~0x00000004);
      transitiveDependenciesIncluded_ = false;
      onChanged();
      return this;
    }

    private boolean transitiveDependentsIncluded_;

    /**
     *
     *
     * <pre>
     * Optional. When set to true, transitive dependents of included actions will
     * be executed.
     * </pre>
     *
     * <code>bool transitive_dependents_included = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The transitiveDependentsIncluded.
     */
    @java.lang.Override
    public boolean getTransitiveDependentsIncluded() {
      return transitiveDependentsIncluded_;
    }

    /**
     *
     *
     * <pre>
     * Optional. When set to true, transitive dependents of included actions will
     * be executed.
     * </pre>
     *
     * <code>bool transitive_dependents_included = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The transitiveDependentsIncluded to set.
     * @return This builder for chaining.
     */
    public Builder setTransitiveDependentsIncluded(boolean value) {

      transitiveDependentsIncluded_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. When set to true, transitive dependents of included actions will
     * be executed.
     * </pre>
     *
     * <code>bool transitive_dependents_included = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransitiveDependentsIncluded() {
      bitField0_ = (bitField0_ & ~0x00000008);
      transitiveDependentsIncluded_ = false;
      onChanged();
      return this;
    }

    private boolean fullyRefreshIncrementalTablesEnabled_;

    /**
     *
     *
     * <pre>
     * Optional. When set to true, any incremental tables will be fully refreshed.
     * </pre>
     *
     * <code>
     * bool fully_refresh_incremental_tables_enabled = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The fullyRefreshIncrementalTablesEnabled.
     */
    @java.lang.Override
    public boolean getFullyRefreshIncrementalTablesEnabled() {
      return fullyRefreshIncrementalTablesEnabled_;
    }

    /**
     *
     *
     * <pre>
     * Optional. When set to true, any incremental tables will be fully refreshed.
     * </pre>
     *
     * <code>
     * bool fully_refresh_incremental_tables_enabled = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The fullyRefreshIncrementalTablesEnabled to set.
     * @return This builder for chaining.
     */
    public Builder setFullyRefreshIncrementalTablesEnabled(boolean value) {

      fullyRefreshIncrementalTablesEnabled_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. When set to true, any incremental tables will be fully refreshed.
     * </pre>
     *
     * <code>
     * bool fully_refresh_incremental_tables_enabled = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFullyRefreshIncrementalTablesEnabled() {
      bitField0_ = (bitField0_ & ~0x00000010);
      fullyRefreshIncrementalTablesEnabled_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The service account to run workflow invocations under.
     * </pre>
     *
     * <code>string service_account = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The service account to run workflow invocations under.
     * </pre>
     *
     * <code>string service_account = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The service account to run workflow invocations under.
     * </pre>
     *
     * <code>string service_account = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The service account to run workflow invocations under.
     * </pre>
     *
     * <code>string service_account = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The service account to run workflow invocations under.
     * </pre>
     *
     * <code>string service_account = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.InvocationConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.InvocationConfig)
  private static final com.google.cloud.dataform.v1.InvocationConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.InvocationConfig();
  }

  public static com.google.cloud.dataform.v1.InvocationConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InvocationConfig> PARSER =
      new com.google.protobuf.AbstractParser<InvocationConfig>() {
        @java.lang.Override
        public InvocationConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InvocationConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InvocationConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataform.v1.InvocationConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
