/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataform/v1/dataform.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.dataform.v1;

/**
 *
 *
 * <pre>
 * Represents a single Dataform action in a compilation result.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction}
 */
public final class CompilationResultAction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.CompilationResultAction)
    CompilationResultActionOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CompilationResultAction.newBuilder() to construct.
  private CompilationResultAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CompilationResultAction() {
    filePath_ = "";
    internalMetadata_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CompilationResultAction();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_CompilationResultAction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataform.v1.DataformProto
        .internal_static_google_cloud_dataform_v1_CompilationResultAction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataform.v1.CompilationResultAction.class,
            com.google.cloud.dataform.v1.CompilationResultAction.Builder.class);
  }

  public interface RelationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.CompilationResultAction.Relation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    java.util.List<com.google.cloud.dataform.v1.Target> getDependencyTargetsList();

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    com.google.cloud.dataform.v1.Target getDependencyTargets(int index);

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    int getDependencyTargetsCount();

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    java.util.List<? extends com.google.cloud.dataform.v1.TargetOrBuilder>
        getDependencyTargetsOrBuilderList();

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    com.google.cloud.dataform.v1.TargetOrBuilder getDependencyTargetsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Whether this action is disabled (i.e. should not be run).
     * </pre>
     *
     * <code>bool disabled = 2;</code>
     *
     * @return The disabled.
     */
    boolean getDisabled();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @return A list containing the tags.
     */
    java.util.List<java.lang.String> getTagsList();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @return The count of tags.
     */
    int getTagsCount();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    java.lang.String getTags(int index);

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    com.google.protobuf.ByteString getTagsBytes(int index);

    /**
     *
     *
     * <pre>
     * Descriptor for the relation and its columns.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 4;</code>
     *
     * @return Whether the relationDescriptor field is set.
     */
    boolean hasRelationDescriptor();

    /**
     *
     *
     * <pre>
     * Descriptor for the relation and its columns.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 4;</code>
     *
     * @return The relationDescriptor.
     */
    com.google.cloud.dataform.v1.RelationDescriptor getRelationDescriptor();

    /**
     *
     *
     * <pre>
     * Descriptor for the relation and its columns.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 4;</code>
     */
    com.google.cloud.dataform.v1.RelationDescriptorOrBuilder getRelationDescriptorOrBuilder();

    /**
     *
     *
     * <pre>
     * The type of this relation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType relation_type = 5;
     * </code>
     *
     * @return The enum numeric value on the wire for relationType.
     */
    int getRelationTypeValue();

    /**
     *
     *
     * <pre>
     * The type of this relation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType relation_type = 5;
     * </code>
     *
     * @return The relationType.
     */
    com.google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType getRelationType();

    /**
     *
     *
     * <pre>
     * The SELECT query which returns rows which this relation should contain.
     * </pre>
     *
     * <code>string select_query = 6;</code>
     *
     * @return The selectQuery.
     */
    java.lang.String getSelectQuery();

    /**
     *
     *
     * <pre>
     * The SELECT query which returns rows which this relation should contain.
     * </pre>
     *
     * <code>string select_query = 6;</code>
     *
     * @return The bytes for selectQuery.
     */
    com.google.protobuf.ByteString getSelectQueryBytes();

    /**
     *
     *
     * <pre>
     * SQL statements to be executed before creating the relation.
     * </pre>
     *
     * <code>repeated string pre_operations = 7;</code>
     *
     * @return A list containing the preOperations.
     */
    java.util.List<java.lang.String> getPreOperationsList();

    /**
     *
     *
     * <pre>
     * SQL statements to be executed before creating the relation.
     * </pre>
     *
     * <code>repeated string pre_operations = 7;</code>
     *
     * @return The count of preOperations.
     */
    int getPreOperationsCount();

    /**
     *
     *
     * <pre>
     * SQL statements to be executed before creating the relation.
     * </pre>
     *
     * <code>repeated string pre_operations = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The preOperations at the given index.
     */
    java.lang.String getPreOperations(int index);

    /**
     *
     *
     * <pre>
     * SQL statements to be executed before creating the relation.
     * </pre>
     *
     * <code>repeated string pre_operations = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the preOperations at the given index.
     */
    com.google.protobuf.ByteString getPreOperationsBytes(int index);

    /**
     *
     *
     * <pre>
     * SQL statements to be executed after creating the relation.
     * </pre>
     *
     * <code>repeated string post_operations = 8;</code>
     *
     * @return A list containing the postOperations.
     */
    java.util.List<java.lang.String> getPostOperationsList();

    /**
     *
     *
     * <pre>
     * SQL statements to be executed after creating the relation.
     * </pre>
     *
     * <code>repeated string post_operations = 8;</code>
     *
     * @return The count of postOperations.
     */
    int getPostOperationsCount();

    /**
     *
     *
     * <pre>
     * SQL statements to be executed after creating the relation.
     * </pre>
     *
     * <code>repeated string post_operations = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The postOperations at the given index.
     */
    java.lang.String getPostOperations(int index);

    /**
     *
     *
     * <pre>
     * SQL statements to be executed after creating the relation.
     * </pre>
     *
     * <code>repeated string post_operations = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the postOperations at the given index.
     */
    com.google.protobuf.ByteString getPostOperationsBytes(int index);

    /**
     *
     *
     * <pre>
     * Configures `INCREMENTAL_TABLE` settings for this relation. Only set if
     * `relation_type` is `INCREMENTAL_TABLE`.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig incremental_table_config = 9;
     * </code>
     *
     * @return Whether the incrementalTableConfig field is set.
     */
    boolean hasIncrementalTableConfig();

    /**
     *
     *
     * <pre>
     * Configures `INCREMENTAL_TABLE` settings for this relation. Only set if
     * `relation_type` is `INCREMENTAL_TABLE`.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig incremental_table_config = 9;
     * </code>
     *
     * @return The incrementalTableConfig.
     */
    com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
        getIncrementalTableConfig();

    /**
     *
     *
     * <pre>
     * Configures `INCREMENTAL_TABLE` settings for this relation. Only set if
     * `relation_type` is `INCREMENTAL_TABLE`.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig incremental_table_config = 9;
     * </code>
     */
    com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfigOrBuilder
        getIncrementalTableConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * The SQL expression used to partition the relation.
     * </pre>
     *
     * <code>string partition_expression = 10;</code>
     *
     * @return The partitionExpression.
     */
    java.lang.String getPartitionExpression();

    /**
     *
     *
     * <pre>
     * The SQL expression used to partition the relation.
     * </pre>
     *
     * <code>string partition_expression = 10;</code>
     *
     * @return The bytes for partitionExpression.
     */
    com.google.protobuf.ByteString getPartitionExpressionBytes();

    /**
     *
     *
     * <pre>
     * A list of columns or SQL expressions used to cluster the table.
     * </pre>
     *
     * <code>repeated string cluster_expressions = 11;</code>
     *
     * @return A list containing the clusterExpressions.
     */
    java.util.List<java.lang.String> getClusterExpressionsList();

    /**
     *
     *
     * <pre>
     * A list of columns or SQL expressions used to cluster the table.
     * </pre>
     *
     * <code>repeated string cluster_expressions = 11;</code>
     *
     * @return The count of clusterExpressions.
     */
    int getClusterExpressionsCount();

    /**
     *
     *
     * <pre>
     * A list of columns or SQL expressions used to cluster the table.
     * </pre>
     *
     * <code>repeated string cluster_expressions = 11;</code>
     *
     * @param index The index of the element to return.
     * @return The clusterExpressions at the given index.
     */
    java.lang.String getClusterExpressions(int index);

    /**
     *
     *
     * <pre>
     * A list of columns or SQL expressions used to cluster the table.
     * </pre>
     *
     * <code>repeated string cluster_expressions = 11;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the clusterExpressions at the given index.
     */
    com.google.protobuf.ByteString getClusterExpressionsBytes(int index);

    /**
     *
     *
     * <pre>
     * Sets the partition expiration in days.
     * </pre>
     *
     * <code>int32 partition_expiration_days = 12;</code>
     *
     * @return The partitionExpirationDays.
     */
    int getPartitionExpirationDays();

    /**
     *
     *
     * <pre>
     * Specifies whether queries on this table must include a predicate filter
     * that filters on the partitioning column.
     * </pre>
     *
     * <code>bool require_partition_filter = 13;</code>
     *
     * @return The requirePartitionFilter.
     */
    boolean getRequirePartitionFilter();

    /**
     *
     *
     * <pre>
     * Additional options that will be provided as key/value pairs into the
     * options clause of a create table/view statement. See
     * https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language
     * for more information on which options are supported.
     * </pre>
     *
     * <code>map&lt;string, string&gt; additional_options = 14;</code>
     */
    int getAdditionalOptionsCount();

    /**
     *
     *
     * <pre>
     * Additional options that will be provided as key/value pairs into the
     * options clause of a create table/view statement. See
     * https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language
     * for more information on which options are supported.
     * </pre>
     *
     * <code>map&lt;string, string&gt; additional_options = 14;</code>
     */
    boolean containsAdditionalOptions(java.lang.String key);

    /** Use {@link #getAdditionalOptionsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getAdditionalOptions();

    /**
     *
     *
     * <pre>
     * Additional options that will be provided as key/value pairs into the
     * options clause of a create table/view statement. See
     * https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language
     * for more information on which options are supported.
     * </pre>
     *
     * <code>map&lt;string, string&gt; additional_options = 14;</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getAdditionalOptionsMap();

    /**
     *
     *
     * <pre>
     * Additional options that will be provided as key/value pairs into the
     * options clause of a create table/view statement. See
     * https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language
     * for more information on which options are supported.
     * </pre>
     *
     * <code>map&lt;string, string&gt; additional_options = 14;</code>
     */
    /* nullable */
    java.lang.String getAdditionalOptionsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);

    /**
     *
     *
     * <pre>
     * Additional options that will be provided as key/value pairs into the
     * options clause of a create table/view statement. See
     * https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language
     * for more information on which options are supported.
     * </pre>
     *
     * <code>map&lt;string, string&gt; additional_options = 14;</code>
     */
    java.lang.String getAdditionalOptionsOrThrow(java.lang.String key);
  }

  /**
   *
   *
   * <pre>
   * Represents a database relation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction.Relation}
   */
  public static final class Relation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.CompilationResultAction.Relation)
      RelationOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Relation.newBuilder() to construct.
    private Relation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Relation() {
      dependencyTargets_ = java.util.Collections.emptyList();
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      relationType_ = 0;
      selectQuery_ = "";
      preOperations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      postOperations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      partitionExpression_ = "";
      clusterExpressions_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Relation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_Relation_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 14:
          return internalGetAdditionalOptions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_Relation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.CompilationResultAction.Relation.class,
              com.google.cloud.dataform.v1.CompilationResultAction.Relation.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Indicates the type of this relation.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType}
     */
    public enum RelationType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>RELATION_TYPE_UNSPECIFIED = 0;</code>
       */
      RELATION_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The relation is a table.
       * </pre>
       *
       * <code>TABLE = 1;</code>
       */
      TABLE(1),
      /**
       *
       *
       * <pre>
       * The relation is a view.
       * </pre>
       *
       * <code>VIEW = 2;</code>
       */
      VIEW(2),
      /**
       *
       *
       * <pre>
       * The relation is an incrementalized table.
       * </pre>
       *
       * <code>INCREMENTAL_TABLE = 3;</code>
       */
      INCREMENTAL_TABLE(3),
      /**
       *
       *
       * <pre>
       * The relation is a materialized view.
       * </pre>
       *
       * <code>MATERIALIZED_VIEW = 4;</code>
       */
      MATERIALIZED_VIEW(4),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>RELATION_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int RELATION_TYPE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * The relation is a table.
       * </pre>
       *
       * <code>TABLE = 1;</code>
       */
      public static final int TABLE_VALUE = 1;

      /**
       *
       *
       * <pre>
       * The relation is a view.
       * </pre>
       *
       * <code>VIEW = 2;</code>
       */
      public static final int VIEW_VALUE = 2;

      /**
       *
       *
       * <pre>
       * The relation is an incrementalized table.
       * </pre>
       *
       * <code>INCREMENTAL_TABLE = 3;</code>
       */
      public static final int INCREMENTAL_TABLE_VALUE = 3;

      /**
       *
       *
       * <pre>
       * The relation is a materialized view.
       * </pre>
       *
       * <code>MATERIALIZED_VIEW = 4;</code>
       */
      public static final int MATERIALIZED_VIEW_VALUE = 4;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static RelationType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static RelationType forNumber(int value) {
        switch (value) {
          case 0:
            return RELATION_TYPE_UNSPECIFIED;
          case 1:
            return TABLE;
          case 2:
            return VIEW;
          case 3:
            return INCREMENTAL_TABLE;
          case 4:
            return MATERIALIZED_VIEW;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<RelationType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<RelationType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<RelationType>() {
            public RelationType findValueByNumber(int number) {
              return RelationType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.dataform.v1.CompilationResultAction.Relation.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final RelationType[] VALUES = values();

      public static RelationType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private RelationType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType)
    }

    public interface IncrementalTableConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The SELECT query which returns rows which should be inserted into the
       * relation if it already exists and is not being refreshed.
       * </pre>
       *
       * <code>string incremental_select_query = 1;</code>
       *
       * @return The incrementalSelectQuery.
       */
      java.lang.String getIncrementalSelectQuery();

      /**
       *
       *
       * <pre>
       * The SELECT query which returns rows which should be inserted into the
       * relation if it already exists and is not being refreshed.
       * </pre>
       *
       * <code>string incremental_select_query = 1;</code>
       *
       * @return The bytes for incrementalSelectQuery.
       */
      com.google.protobuf.ByteString getIncrementalSelectQueryBytes();

      /**
       *
       *
       * <pre>
       * Whether this table should be protected from being refreshed.
       * </pre>
       *
       * <code>bool refresh_disabled = 2;</code>
       *
       * @return The refreshDisabled.
       */
      boolean getRefreshDisabled();

      /**
       *
       *
       * <pre>
       * A set of columns or SQL expressions used to define row uniqueness.
       * If any duplicates are discovered (as defined by `unique_key_parts`),
       * only the newly selected rows (as defined by `incremental_select_query`)
       * will be included in the relation.
       * </pre>
       *
       * <code>repeated string unique_key_parts = 3;</code>
       *
       * @return A list containing the uniqueKeyParts.
       */
      java.util.List<java.lang.String> getUniqueKeyPartsList();

      /**
       *
       *
       * <pre>
       * A set of columns or SQL expressions used to define row uniqueness.
       * If any duplicates are discovered (as defined by `unique_key_parts`),
       * only the newly selected rows (as defined by `incremental_select_query`)
       * will be included in the relation.
       * </pre>
       *
       * <code>repeated string unique_key_parts = 3;</code>
       *
       * @return The count of uniqueKeyParts.
       */
      int getUniqueKeyPartsCount();

      /**
       *
       *
       * <pre>
       * A set of columns or SQL expressions used to define row uniqueness.
       * If any duplicates are discovered (as defined by `unique_key_parts`),
       * only the newly selected rows (as defined by `incremental_select_query`)
       * will be included in the relation.
       * </pre>
       *
       * <code>repeated string unique_key_parts = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The uniqueKeyParts at the given index.
       */
      java.lang.String getUniqueKeyParts(int index);

      /**
       *
       *
       * <pre>
       * A set of columns or SQL expressions used to define row uniqueness.
       * If any duplicates are discovered (as defined by `unique_key_parts`),
       * only the newly selected rows (as defined by `incremental_select_query`)
       * will be included in the relation.
       * </pre>
       *
       * <code>repeated string unique_key_parts = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the uniqueKeyParts at the given index.
       */
      com.google.protobuf.ByteString getUniqueKeyPartsBytes(int index);

      /**
       *
       *
       * <pre>
       * A SQL expression conditional used to limit the set of existing rows
       * considered for a merge operation (see `unique_key_parts` for more
       * information).
       * </pre>
       *
       * <code>string update_partition_filter = 4;</code>
       *
       * @return The updatePartitionFilter.
       */
      java.lang.String getUpdatePartitionFilter();

      /**
       *
       *
       * <pre>
       * A SQL expression conditional used to limit the set of existing rows
       * considered for a merge operation (see `unique_key_parts` for more
       * information).
       * </pre>
       *
       * <code>string update_partition_filter = 4;</code>
       *
       * @return The bytes for updatePartitionFilter.
       */
      com.google.protobuf.ByteString getUpdatePartitionFilterBytes();

      /**
       *
       *
       * <pre>
       * SQL statements to be executed before inserting new rows into the
       * relation.
       * </pre>
       *
       * <code>repeated string incremental_pre_operations = 5;</code>
       *
       * @return A list containing the incrementalPreOperations.
       */
      java.util.List<java.lang.String> getIncrementalPreOperationsList();

      /**
       *
       *
       * <pre>
       * SQL statements to be executed before inserting new rows into the
       * relation.
       * </pre>
       *
       * <code>repeated string incremental_pre_operations = 5;</code>
       *
       * @return The count of incrementalPreOperations.
       */
      int getIncrementalPreOperationsCount();

      /**
       *
       *
       * <pre>
       * SQL statements to be executed before inserting new rows into the
       * relation.
       * </pre>
       *
       * <code>repeated string incremental_pre_operations = 5;</code>
       *
       * @param index The index of the element to return.
       * @return The incrementalPreOperations at the given index.
       */
      java.lang.String getIncrementalPreOperations(int index);

      /**
       *
       *
       * <pre>
       * SQL statements to be executed before inserting new rows into the
       * relation.
       * </pre>
       *
       * <code>repeated string incremental_pre_operations = 5;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the incrementalPreOperations at the given index.
       */
      com.google.protobuf.ByteString getIncrementalPreOperationsBytes(int index);

      /**
       *
       *
       * <pre>
       * SQL statements to be executed after inserting new rows into the
       * relation.
       * </pre>
       *
       * <code>repeated string incremental_post_operations = 6;</code>
       *
       * @return A list containing the incrementalPostOperations.
       */
      java.util.List<java.lang.String> getIncrementalPostOperationsList();

      /**
       *
       *
       * <pre>
       * SQL statements to be executed after inserting new rows into the
       * relation.
       * </pre>
       *
       * <code>repeated string incremental_post_operations = 6;</code>
       *
       * @return The count of incrementalPostOperations.
       */
      int getIncrementalPostOperationsCount();

      /**
       *
       *
       * <pre>
       * SQL statements to be executed after inserting new rows into the
       * relation.
       * </pre>
       *
       * <code>repeated string incremental_post_operations = 6;</code>
       *
       * @param index The index of the element to return.
       * @return The incrementalPostOperations at the given index.
       */
      java.lang.String getIncrementalPostOperations(int index);

      /**
       *
       *
       * <pre>
       * SQL statements to be executed after inserting new rows into the
       * relation.
       * </pre>
       *
       * <code>repeated string incremental_post_operations = 6;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the incrementalPostOperations at the given index.
       */
      com.google.protobuf.ByteString getIncrementalPostOperationsBytes(int index);
    }

    /**
     *
     *
     * <pre>
     * Contains settings for relations of type `INCREMENTAL_TABLE`.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig}
     */
    public static final class IncrementalTableConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig)
        IncrementalTableConfigOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use IncrementalTableConfig.newBuilder() to construct.
      private IncrementalTableConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private IncrementalTableConfig() {
        incrementalSelectQuery_ = "";
        uniqueKeyParts_ = com.google.protobuf.LazyStringArrayList.emptyList();
        updatePartitionFilter_ = "";
        incrementalPreOperations_ = com.google.protobuf.LazyStringArrayList.emptyList();
        incrementalPostOperations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new IncrementalTableConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_Relation_IncrementalTableConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_Relation_IncrementalTableConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
                    .class,
                com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
                    .Builder.class);
      }

      public static final int INCREMENTAL_SELECT_QUERY_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object incrementalSelectQuery_ = "";

      /**
       *
       *
       * <pre>
       * The SELECT query which returns rows which should be inserted into the
       * relation if it already exists and is not being refreshed.
       * </pre>
       *
       * <code>string incremental_select_query = 1;</code>
       *
       * @return The incrementalSelectQuery.
       */
      @java.lang.Override
      public java.lang.String getIncrementalSelectQuery() {
        java.lang.Object ref = incrementalSelectQuery_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          incrementalSelectQuery_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * The SELECT query which returns rows which should be inserted into the
       * relation if it already exists and is not being refreshed.
       * </pre>
       *
       * <code>string incremental_select_query = 1;</code>
       *
       * @return The bytes for incrementalSelectQuery.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getIncrementalSelectQueryBytes() {
        java.lang.Object ref = incrementalSelectQuery_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          incrementalSelectQuery_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int REFRESH_DISABLED_FIELD_NUMBER = 2;
      private boolean refreshDisabled_ = false;

      /**
       *
       *
       * <pre>
       * Whether this table should be protected from being refreshed.
       * </pre>
       *
       * <code>bool refresh_disabled = 2;</code>
       *
       * @return The refreshDisabled.
       */
      @java.lang.Override
      public boolean getRefreshDisabled() {
        return refreshDisabled_;
      }

      public static final int UNIQUE_KEY_PARTS_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList uniqueKeyParts_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      /**
       *
       *
       * <pre>
       * A set of columns or SQL expressions used to define row uniqueness.
       * If any duplicates are discovered (as defined by `unique_key_parts`),
       * only the newly selected rows (as defined by `incremental_select_query`)
       * will be included in the relation.
       * </pre>
       *
       * <code>repeated string unique_key_parts = 3;</code>
       *
       * @return A list containing the uniqueKeyParts.
       */
      public com.google.protobuf.ProtocolStringList getUniqueKeyPartsList() {
        return uniqueKeyParts_;
      }

      /**
       *
       *
       * <pre>
       * A set of columns or SQL expressions used to define row uniqueness.
       * If any duplicates are discovered (as defined by `unique_key_parts`),
       * only the newly selected rows (as defined by `incremental_select_query`)
       * will be included in the relation.
       * </pre>
       *
       * <code>repeated string unique_key_parts = 3;</code>
       *
       * @return The count of uniqueKeyParts.
       */
      public int getUniqueKeyPartsCount() {
        return uniqueKeyParts_.size();
      }

      /**
       *
       *
       * <pre>
       * A set of columns or SQL expressions used to define row uniqueness.
       * If any duplicates are discovered (as defined by `unique_key_parts`),
       * only the newly selected rows (as defined by `incremental_select_query`)
       * will be included in the relation.
       * </pre>
       *
       * <code>repeated string unique_key_parts = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The uniqueKeyParts at the given index.
       */
      public java.lang.String getUniqueKeyParts(int index) {
        return uniqueKeyParts_.get(index);
      }

      /**
       *
       *
       * <pre>
       * A set of columns or SQL expressions used to define row uniqueness.
       * If any duplicates are discovered (as defined by `unique_key_parts`),
       * only the newly selected rows (as defined by `incremental_select_query`)
       * will be included in the relation.
       * </pre>
       *
       * <code>repeated string unique_key_parts = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the uniqueKeyParts at the given index.
       */
      public com.google.protobuf.ByteString getUniqueKeyPartsBytes(int index) {
        return uniqueKeyParts_.getByteString(index);
      }

      public static final int UPDATE_PARTITION_FILTER_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private volatile java.lang.Object updatePartitionFilter_ = "";

      /**
       *
       *
       * <pre>
       * A SQL expression conditional used to limit the set of existing rows
       * considered for a merge operation (see `unique_key_parts` for more
       * information).
       * </pre>
       *
       * <code>string update_partition_filter = 4;</code>
       *
       * @return The updatePartitionFilter.
       */
      @java.lang.Override
      public java.lang.String getUpdatePartitionFilter() {
        java.lang.Object ref = updatePartitionFilter_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          updatePartitionFilter_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * A SQL expression conditional used to limit the set of existing rows
       * considered for a merge operation (see `unique_key_parts` for more
       * information).
       * </pre>
       *
       * <code>string update_partition_filter = 4;</code>
       *
       * @return The bytes for updatePartitionFilter.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUpdatePartitionFilterBytes() {
        java.lang.Object ref = updatePartitionFilter_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          updatePartitionFilter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int INCREMENTAL_PRE_OPERATIONS_FIELD_NUMBER = 5;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList incrementalPreOperations_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      /**
       *
       *
       * <pre>
       * SQL statements to be executed before inserting new rows into the
       * relation.
       * </pre>
       *
       * <code>repeated string incremental_pre_operations = 5;</code>
       *
       * @return A list containing the incrementalPreOperations.
       */
      public com.google.protobuf.ProtocolStringList getIncrementalPreOperationsList() {
        return incrementalPreOperations_;
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed before inserting new rows into the
       * relation.
       * </pre>
       *
       * <code>repeated string incremental_pre_operations = 5;</code>
       *
       * @return The count of incrementalPreOperations.
       */
      public int getIncrementalPreOperationsCount() {
        return incrementalPreOperations_.size();
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed before inserting new rows into the
       * relation.
       * </pre>
       *
       * <code>repeated string incremental_pre_operations = 5;</code>
       *
       * @param index The index of the element to return.
       * @return The incrementalPreOperations at the given index.
       */
      public java.lang.String getIncrementalPreOperations(int index) {
        return incrementalPreOperations_.get(index);
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed before inserting new rows into the
       * relation.
       * </pre>
       *
       * <code>repeated string incremental_pre_operations = 5;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the incrementalPreOperations at the given index.
       */
      public com.google.protobuf.ByteString getIncrementalPreOperationsBytes(int index) {
        return incrementalPreOperations_.getByteString(index);
      }

      public static final int INCREMENTAL_POST_OPERATIONS_FIELD_NUMBER = 6;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList incrementalPostOperations_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      /**
       *
       *
       * <pre>
       * SQL statements to be executed after inserting new rows into the
       * relation.
       * </pre>
       *
       * <code>repeated string incremental_post_operations = 6;</code>
       *
       * @return A list containing the incrementalPostOperations.
       */
      public com.google.protobuf.ProtocolStringList getIncrementalPostOperationsList() {
        return incrementalPostOperations_;
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed after inserting new rows into the
       * relation.
       * </pre>
       *
       * <code>repeated string incremental_post_operations = 6;</code>
       *
       * @return The count of incrementalPostOperations.
       */
      public int getIncrementalPostOperationsCount() {
        return incrementalPostOperations_.size();
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed after inserting new rows into the
       * relation.
       * </pre>
       *
       * <code>repeated string incremental_post_operations = 6;</code>
       *
       * @param index The index of the element to return.
       * @return The incrementalPostOperations at the given index.
       */
      public java.lang.String getIncrementalPostOperations(int index) {
        return incrementalPostOperations_.get(index);
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed after inserting new rows into the
       * relation.
       * </pre>
       *
       * <code>repeated string incremental_post_operations = 6;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the incrementalPostOperations at the given index.
       */
      public com.google.protobuf.ByteString getIncrementalPostOperationsBytes(int index) {
        return incrementalPostOperations_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(incrementalSelectQuery_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, incrementalSelectQuery_);
        }
        if (refreshDisabled_ != false) {
          output.writeBool(2, refreshDisabled_);
        }
        for (int i = 0; i < uniqueKeyParts_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, uniqueKeyParts_.getRaw(i));
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(updatePartitionFilter_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, updatePartitionFilter_);
        }
        for (int i = 0; i < incrementalPreOperations_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(
              output, 5, incrementalPreOperations_.getRaw(i));
        }
        for (int i = 0; i < incrementalPostOperations_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(
              output, 6, incrementalPostOperations_.getRaw(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(incrementalSelectQuery_)) {
          size +=
              com.google.protobuf.GeneratedMessageV3.computeStringSize(1, incrementalSelectQuery_);
        }
        if (refreshDisabled_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, refreshDisabled_);
        }
        {
          int dataSize = 0;
          for (int i = 0; i < uniqueKeyParts_.size(); i++) {
            dataSize += computeStringSizeNoTag(uniqueKeyParts_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getUniqueKeyPartsList().size();
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(updatePartitionFilter_)) {
          size +=
              com.google.protobuf.GeneratedMessageV3.computeStringSize(4, updatePartitionFilter_);
        }
        {
          int dataSize = 0;
          for (int i = 0; i < incrementalPreOperations_.size(); i++) {
            dataSize += computeStringSizeNoTag(incrementalPreOperations_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getIncrementalPreOperationsList().size();
        }
        {
          int dataSize = 0;
          for (int i = 0; i < incrementalPostOperations_.size(); i++) {
            dataSize += computeStringSizeNoTag(incrementalPostOperations_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getIncrementalPostOperationsList().size();
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig other =
            (com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig)
                obj;

        if (!getIncrementalSelectQuery().equals(other.getIncrementalSelectQuery())) return false;
        if (getRefreshDisabled() != other.getRefreshDisabled()) return false;
        if (!getUniqueKeyPartsList().equals(other.getUniqueKeyPartsList())) return false;
        if (!getUpdatePartitionFilter().equals(other.getUpdatePartitionFilter())) return false;
        if (!getIncrementalPreOperationsList().equals(other.getIncrementalPreOperationsList()))
          return false;
        if (!getIncrementalPostOperationsList().equals(other.getIncrementalPostOperationsList()))
          return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + INCREMENTAL_SELECT_QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getIncrementalSelectQuery().hashCode();
        hash = (37 * hash) + REFRESH_DISABLED_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRefreshDisabled());
        if (getUniqueKeyPartsCount() > 0) {
          hash = (37 * hash) + UNIQUE_KEY_PARTS_FIELD_NUMBER;
          hash = (53 * hash) + getUniqueKeyPartsList().hashCode();
        }
        hash = (37 * hash) + UPDATE_PARTITION_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getUpdatePartitionFilter().hashCode();
        if (getIncrementalPreOperationsCount() > 0) {
          hash = (37 * hash) + INCREMENTAL_PRE_OPERATIONS_FIELD_NUMBER;
          hash = (53 * hash) + getIncrementalPreOperationsList().hashCode();
        }
        if (getIncrementalPostOperationsCount() > 0) {
          hash = (37 * hash) + INCREMENTAL_POST_OPERATIONS_FIELD_NUMBER;
          hash = (53 * hash) + getIncrementalPostOperationsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.Relation
              .IncrementalTableConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.Relation
              .IncrementalTableConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.Relation
              .IncrementalTableConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.Relation
              .IncrementalTableConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.Relation
              .IncrementalTableConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.Relation
              .IncrementalTableConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.Relation
              .IncrementalTableConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.Relation
              .IncrementalTableConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.Relation
              .IncrementalTableConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.Relation
              .IncrementalTableConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.Relation
              .IncrementalTableConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.Relation
              .IncrementalTableConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Contains settings for relations of type `INCREMENTAL_TABLE`.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig)
          com.google.cloud.dataform.v1.CompilationResultAction.Relation
              .IncrementalTableConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_CompilationResultAction_Relation_IncrementalTableConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_CompilationResultAction_Relation_IncrementalTableConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dataform.v1.CompilationResultAction.Relation
                      .IncrementalTableConfig.class,
                  com.google.cloud.dataform.v1.CompilationResultAction.Relation
                      .IncrementalTableConfig.Builder.class);
        }

        // Construct using
        // com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          incrementalSelectQuery_ = "";
          refreshDisabled_ = false;
          uniqueKeyParts_ = com.google.protobuf.LazyStringArrayList.emptyList();
          updatePartitionFilter_ = "";
          incrementalPreOperations_ = com.google.protobuf.LazyStringArrayList.emptyList();
          incrementalPostOperations_ = com.google.protobuf.LazyStringArrayList.emptyList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_CompilationResultAction_Relation_IncrementalTableConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
            getDefaultInstanceForType() {
          return com.google.cloud.dataform.v1.CompilationResultAction.Relation
              .IncrementalTableConfig.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
            build() {
          com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
            buildPartial() {
          com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
              result =
                  new com.google.cloud.dataform.v1.CompilationResultAction.Relation
                      .IncrementalTableConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.incrementalSelectQuery_ = incrementalSelectQuery_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.refreshDisabled_ = refreshDisabled_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            uniqueKeyParts_.makeImmutable();
            result.uniqueKeyParts_ = uniqueKeyParts_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.updatePartitionFilter_ = updatePartitionFilter_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            incrementalPreOperations_.makeImmutable();
            result.incrementalPreOperations_ = incrementalPreOperations_;
          }
          if (((from_bitField0_ & 0x00000020) != 0)) {
            incrementalPostOperations_.makeImmutable();
            result.incrementalPostOperations_ = incrementalPostOperations_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dataform.v1.CompilationResultAction.Relation
                  .IncrementalTableConfig) {
            return mergeFrom(
                (com.google.cloud.dataform.v1.CompilationResultAction.Relation
                        .IncrementalTableConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
                other) {
          if (other
              == com.google.cloud.dataform.v1.CompilationResultAction.Relation
                  .IncrementalTableConfig.getDefaultInstance()) return this;
          if (!other.getIncrementalSelectQuery().isEmpty()) {
            incrementalSelectQuery_ = other.incrementalSelectQuery_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.getRefreshDisabled() != false) {
            setRefreshDisabled(other.getRefreshDisabled());
          }
          if (!other.uniqueKeyParts_.isEmpty()) {
            if (uniqueKeyParts_.isEmpty()) {
              uniqueKeyParts_ = other.uniqueKeyParts_;
              bitField0_ |= 0x00000004;
            } else {
              ensureUniqueKeyPartsIsMutable();
              uniqueKeyParts_.addAll(other.uniqueKeyParts_);
            }
            onChanged();
          }
          if (!other.getUpdatePartitionFilter().isEmpty()) {
            updatePartitionFilter_ = other.updatePartitionFilter_;
            bitField0_ |= 0x00000008;
            onChanged();
          }
          if (!other.incrementalPreOperations_.isEmpty()) {
            if (incrementalPreOperations_.isEmpty()) {
              incrementalPreOperations_ = other.incrementalPreOperations_;
              bitField0_ |= 0x00000010;
            } else {
              ensureIncrementalPreOperationsIsMutable();
              incrementalPreOperations_.addAll(other.incrementalPreOperations_);
            }
            onChanged();
          }
          if (!other.incrementalPostOperations_.isEmpty()) {
            if (incrementalPostOperations_.isEmpty()) {
              incrementalPostOperations_ = other.incrementalPostOperations_;
              bitField0_ |= 0x00000020;
            } else {
              ensureIncrementalPostOperationsIsMutable();
              incrementalPostOperations_.addAll(other.incrementalPostOperations_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    incrementalSelectQuery_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 16:
                  {
                    refreshDisabled_ = input.readBool();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 26:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureUniqueKeyPartsIsMutable();
                    uniqueKeyParts_.add(s);
                    break;
                  } // case 26
                case 34:
                  {
                    updatePartitionFilter_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 34
                case 42:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureIncrementalPreOperationsIsMutable();
                    incrementalPreOperations_.add(s);
                    break;
                  } // case 42
                case 50:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureIncrementalPostOperationsIsMutable();
                    incrementalPostOperations_.add(s);
                    break;
                  } // case 50
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object incrementalSelectQuery_ = "";

        /**
         *
         *
         * <pre>
         * The SELECT query which returns rows which should be inserted into the
         * relation if it already exists and is not being refreshed.
         * </pre>
         *
         * <code>string incremental_select_query = 1;</code>
         *
         * @return The incrementalSelectQuery.
         */
        public java.lang.String getIncrementalSelectQuery() {
          java.lang.Object ref = incrementalSelectQuery_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            incrementalSelectQuery_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * The SELECT query which returns rows which should be inserted into the
         * relation if it already exists and is not being refreshed.
         * </pre>
         *
         * <code>string incremental_select_query = 1;</code>
         *
         * @return The bytes for incrementalSelectQuery.
         */
        public com.google.protobuf.ByteString getIncrementalSelectQueryBytes() {
          java.lang.Object ref = incrementalSelectQuery_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            incrementalSelectQuery_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * The SELECT query which returns rows which should be inserted into the
         * relation if it already exists and is not being refreshed.
         * </pre>
         *
         * <code>string incremental_select_query = 1;</code>
         *
         * @param value The incrementalSelectQuery to set.
         * @return This builder for chaining.
         */
        public Builder setIncrementalSelectQuery(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          incrementalSelectQuery_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The SELECT query which returns rows which should be inserted into the
         * relation if it already exists and is not being refreshed.
         * </pre>
         *
         * <code>string incremental_select_query = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearIncrementalSelectQuery() {
          incrementalSelectQuery_ = getDefaultInstance().getIncrementalSelectQuery();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The SELECT query which returns rows which should be inserted into the
         * relation if it already exists and is not being refreshed.
         * </pre>
         *
         * <code>string incremental_select_query = 1;</code>
         *
         * @param value The bytes for incrementalSelectQuery to set.
         * @return This builder for chaining.
         */
        public Builder setIncrementalSelectQueryBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          incrementalSelectQuery_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private boolean refreshDisabled_;

        /**
         *
         *
         * <pre>
         * Whether this table should be protected from being refreshed.
         * </pre>
         *
         * <code>bool refresh_disabled = 2;</code>
         *
         * @return The refreshDisabled.
         */
        @java.lang.Override
        public boolean getRefreshDisabled() {
          return refreshDisabled_;
        }

        /**
         *
         *
         * <pre>
         * Whether this table should be protected from being refreshed.
         * </pre>
         *
         * <code>bool refresh_disabled = 2;</code>
         *
         * @param value The refreshDisabled to set.
         * @return This builder for chaining.
         */
        public Builder setRefreshDisabled(boolean value) {

          refreshDisabled_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Whether this table should be protected from being refreshed.
         * </pre>
         *
         * <code>bool refresh_disabled = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRefreshDisabled() {
          bitField0_ = (bitField0_ & ~0x00000002);
          refreshDisabled_ = false;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList uniqueKeyParts_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureUniqueKeyPartsIsMutable() {
          if (!uniqueKeyParts_.isModifiable()) {
            uniqueKeyParts_ = new com.google.protobuf.LazyStringArrayList(uniqueKeyParts_);
          }
          bitField0_ |= 0x00000004;
        }

        /**
         *
         *
         * <pre>
         * A set of columns or SQL expressions used to define row uniqueness.
         * If any duplicates are discovered (as defined by `unique_key_parts`),
         * only the newly selected rows (as defined by `incremental_select_query`)
         * will be included in the relation.
         * </pre>
         *
         * <code>repeated string unique_key_parts = 3;</code>
         *
         * @return A list containing the uniqueKeyParts.
         */
        public com.google.protobuf.ProtocolStringList getUniqueKeyPartsList() {
          uniqueKeyParts_.makeImmutable();
          return uniqueKeyParts_;
        }

        /**
         *
         *
         * <pre>
         * A set of columns or SQL expressions used to define row uniqueness.
         * If any duplicates are discovered (as defined by `unique_key_parts`),
         * only the newly selected rows (as defined by `incremental_select_query`)
         * will be included in the relation.
         * </pre>
         *
         * <code>repeated string unique_key_parts = 3;</code>
         *
         * @return The count of uniqueKeyParts.
         */
        public int getUniqueKeyPartsCount() {
          return uniqueKeyParts_.size();
        }

        /**
         *
         *
         * <pre>
         * A set of columns or SQL expressions used to define row uniqueness.
         * If any duplicates are discovered (as defined by `unique_key_parts`),
         * only the newly selected rows (as defined by `incremental_select_query`)
         * will be included in the relation.
         * </pre>
         *
         * <code>repeated string unique_key_parts = 3;</code>
         *
         * @param index The index of the element to return.
         * @return The uniqueKeyParts at the given index.
         */
        public java.lang.String getUniqueKeyParts(int index) {
          return uniqueKeyParts_.get(index);
        }

        /**
         *
         *
         * <pre>
         * A set of columns or SQL expressions used to define row uniqueness.
         * If any duplicates are discovered (as defined by `unique_key_parts`),
         * only the newly selected rows (as defined by `incremental_select_query`)
         * will be included in the relation.
         * </pre>
         *
         * <code>repeated string unique_key_parts = 3;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the uniqueKeyParts at the given index.
         */
        public com.google.protobuf.ByteString getUniqueKeyPartsBytes(int index) {
          return uniqueKeyParts_.getByteString(index);
        }

        /**
         *
         *
         * <pre>
         * A set of columns or SQL expressions used to define row uniqueness.
         * If any duplicates are discovered (as defined by `unique_key_parts`),
         * only the newly selected rows (as defined by `incremental_select_query`)
         * will be included in the relation.
         * </pre>
         *
         * <code>repeated string unique_key_parts = 3;</code>
         *
         * @param index The index to set the value at.
         * @param value The uniqueKeyParts to set.
         * @return This builder for chaining.
         */
        public Builder setUniqueKeyParts(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUniqueKeyPartsIsMutable();
          uniqueKeyParts_.set(index, value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * A set of columns or SQL expressions used to define row uniqueness.
         * If any duplicates are discovered (as defined by `unique_key_parts`),
         * only the newly selected rows (as defined by `incremental_select_query`)
         * will be included in the relation.
         * </pre>
         *
         * <code>repeated string unique_key_parts = 3;</code>
         *
         * @param value The uniqueKeyParts to add.
         * @return This builder for chaining.
         */
        public Builder addUniqueKeyParts(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUniqueKeyPartsIsMutable();
          uniqueKeyParts_.add(value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * A set of columns or SQL expressions used to define row uniqueness.
         * If any duplicates are discovered (as defined by `unique_key_parts`),
         * only the newly selected rows (as defined by `incremental_select_query`)
         * will be included in the relation.
         * </pre>
         *
         * <code>repeated string unique_key_parts = 3;</code>
         *
         * @param values The uniqueKeyParts to add.
         * @return This builder for chaining.
         */
        public Builder addAllUniqueKeyParts(java.lang.Iterable<java.lang.String> values) {
          ensureUniqueKeyPartsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, uniqueKeyParts_);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * A set of columns or SQL expressions used to define row uniqueness.
         * If any duplicates are discovered (as defined by `unique_key_parts`),
         * only the newly selected rows (as defined by `incremental_select_query`)
         * will be included in the relation.
         * </pre>
         *
         * <code>repeated string unique_key_parts = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUniqueKeyParts() {
          uniqueKeyParts_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          ;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * A set of columns or SQL expressions used to define row uniqueness.
         * If any duplicates are discovered (as defined by `unique_key_parts`),
         * only the newly selected rows (as defined by `incremental_select_query`)
         * will be included in the relation.
         * </pre>
         *
         * <code>repeated string unique_key_parts = 3;</code>
         *
         * @param value The bytes of the uniqueKeyParts to add.
         * @return This builder for chaining.
         */
        public Builder addUniqueKeyPartsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureUniqueKeyPartsIsMutable();
          uniqueKeyParts_.add(value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private java.lang.Object updatePartitionFilter_ = "";

        /**
         *
         *
         * <pre>
         * A SQL expression conditional used to limit the set of existing rows
         * considered for a merge operation (see `unique_key_parts` for more
         * information).
         * </pre>
         *
         * <code>string update_partition_filter = 4;</code>
         *
         * @return The updatePartitionFilter.
         */
        public java.lang.String getUpdatePartitionFilter() {
          java.lang.Object ref = updatePartitionFilter_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            updatePartitionFilter_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * A SQL expression conditional used to limit the set of existing rows
         * considered for a merge operation (see `unique_key_parts` for more
         * information).
         * </pre>
         *
         * <code>string update_partition_filter = 4;</code>
         *
         * @return The bytes for updatePartitionFilter.
         */
        public com.google.protobuf.ByteString getUpdatePartitionFilterBytes() {
          java.lang.Object ref = updatePartitionFilter_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            updatePartitionFilter_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * A SQL expression conditional used to limit the set of existing rows
         * considered for a merge operation (see `unique_key_parts` for more
         * information).
         * </pre>
         *
         * <code>string update_partition_filter = 4;</code>
         *
         * @param value The updatePartitionFilter to set.
         * @return This builder for chaining.
         */
        public Builder setUpdatePartitionFilter(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          updatePartitionFilter_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * A SQL expression conditional used to limit the set of existing rows
         * considered for a merge operation (see `unique_key_parts` for more
         * information).
         * </pre>
         *
         * <code>string update_partition_filter = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUpdatePartitionFilter() {
          updatePartitionFilter_ = getDefaultInstance().getUpdatePartitionFilter();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * A SQL expression conditional used to limit the set of existing rows
         * considered for a merge operation (see `unique_key_parts` for more
         * information).
         * </pre>
         *
         * <code>string update_partition_filter = 4;</code>
         *
         * @param value The bytes for updatePartitionFilter to set.
         * @return This builder for chaining.
         */
        public Builder setUpdatePartitionFilterBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          updatePartitionFilter_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList incrementalPreOperations_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureIncrementalPreOperationsIsMutable() {
          if (!incrementalPreOperations_.isModifiable()) {
            incrementalPreOperations_ =
                new com.google.protobuf.LazyStringArrayList(incrementalPreOperations_);
          }
          bitField0_ |= 0x00000010;
        }

        /**
         *
         *
         * <pre>
         * SQL statements to be executed before inserting new rows into the
         * relation.
         * </pre>
         *
         * <code>repeated string incremental_pre_operations = 5;</code>
         *
         * @return A list containing the incrementalPreOperations.
         */
        public com.google.protobuf.ProtocolStringList getIncrementalPreOperationsList() {
          incrementalPreOperations_.makeImmutable();
          return incrementalPreOperations_;
        }

        /**
         *
         *
         * <pre>
         * SQL statements to be executed before inserting new rows into the
         * relation.
         * </pre>
         *
         * <code>repeated string incremental_pre_operations = 5;</code>
         *
         * @return The count of incrementalPreOperations.
         */
        public int getIncrementalPreOperationsCount() {
          return incrementalPreOperations_.size();
        }

        /**
         *
         *
         * <pre>
         * SQL statements to be executed before inserting new rows into the
         * relation.
         * </pre>
         *
         * <code>repeated string incremental_pre_operations = 5;</code>
         *
         * @param index The index of the element to return.
         * @return The incrementalPreOperations at the given index.
         */
        public java.lang.String getIncrementalPreOperations(int index) {
          return incrementalPreOperations_.get(index);
        }

        /**
         *
         *
         * <pre>
         * SQL statements to be executed before inserting new rows into the
         * relation.
         * </pre>
         *
         * <code>repeated string incremental_pre_operations = 5;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the incrementalPreOperations at the given index.
         */
        public com.google.protobuf.ByteString getIncrementalPreOperationsBytes(int index) {
          return incrementalPreOperations_.getByteString(index);
        }

        /**
         *
         *
         * <pre>
         * SQL statements to be executed before inserting new rows into the
         * relation.
         * </pre>
         *
         * <code>repeated string incremental_pre_operations = 5;</code>
         *
         * @param index The index to set the value at.
         * @param value The incrementalPreOperations to set.
         * @return This builder for chaining.
         */
        public Builder setIncrementalPreOperations(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIncrementalPreOperationsIsMutable();
          incrementalPreOperations_.set(index, value);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * SQL statements to be executed before inserting new rows into the
         * relation.
         * </pre>
         *
         * <code>repeated string incremental_pre_operations = 5;</code>
         *
         * @param value The incrementalPreOperations to add.
         * @return This builder for chaining.
         */
        public Builder addIncrementalPreOperations(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIncrementalPreOperationsIsMutable();
          incrementalPreOperations_.add(value);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * SQL statements to be executed before inserting new rows into the
         * relation.
         * </pre>
         *
         * <code>repeated string incremental_pre_operations = 5;</code>
         *
         * @param values The incrementalPreOperations to add.
         * @return This builder for chaining.
         */
        public Builder addAllIncrementalPreOperations(java.lang.Iterable<java.lang.String> values) {
          ensureIncrementalPreOperationsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, incrementalPreOperations_);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * SQL statements to be executed before inserting new rows into the
         * relation.
         * </pre>
         *
         * <code>repeated string incremental_pre_operations = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearIncrementalPreOperations() {
          incrementalPreOperations_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          ;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * SQL statements to be executed before inserting new rows into the
         * relation.
         * </pre>
         *
         * <code>repeated string incremental_pre_operations = 5;</code>
         *
         * @param value The bytes of the incrementalPreOperations to add.
         * @return This builder for chaining.
         */
        public Builder addIncrementalPreOperationsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureIncrementalPreOperationsIsMutable();
          incrementalPreOperations_.add(value);
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList incrementalPostOperations_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureIncrementalPostOperationsIsMutable() {
          if (!incrementalPostOperations_.isModifiable()) {
            incrementalPostOperations_ =
                new com.google.protobuf.LazyStringArrayList(incrementalPostOperations_);
          }
          bitField0_ |= 0x00000020;
        }

        /**
         *
         *
         * <pre>
         * SQL statements to be executed after inserting new rows into the
         * relation.
         * </pre>
         *
         * <code>repeated string incremental_post_operations = 6;</code>
         *
         * @return A list containing the incrementalPostOperations.
         */
        public com.google.protobuf.ProtocolStringList getIncrementalPostOperationsList() {
          incrementalPostOperations_.makeImmutable();
          return incrementalPostOperations_;
        }

        /**
         *
         *
         * <pre>
         * SQL statements to be executed after inserting new rows into the
         * relation.
         * </pre>
         *
         * <code>repeated string incremental_post_operations = 6;</code>
         *
         * @return The count of incrementalPostOperations.
         */
        public int getIncrementalPostOperationsCount() {
          return incrementalPostOperations_.size();
        }

        /**
         *
         *
         * <pre>
         * SQL statements to be executed after inserting new rows into the
         * relation.
         * </pre>
         *
         * <code>repeated string incremental_post_operations = 6;</code>
         *
         * @param index The index of the element to return.
         * @return The incrementalPostOperations at the given index.
         */
        public java.lang.String getIncrementalPostOperations(int index) {
          return incrementalPostOperations_.get(index);
        }

        /**
         *
         *
         * <pre>
         * SQL statements to be executed after inserting new rows into the
         * relation.
         * </pre>
         *
         * <code>repeated string incremental_post_operations = 6;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the incrementalPostOperations at the given index.
         */
        public com.google.protobuf.ByteString getIncrementalPostOperationsBytes(int index) {
          return incrementalPostOperations_.getByteString(index);
        }

        /**
         *
         *
         * <pre>
         * SQL statements to be executed after inserting new rows into the
         * relation.
         * </pre>
         *
         * <code>repeated string incremental_post_operations = 6;</code>
         *
         * @param index The index to set the value at.
         * @param value The incrementalPostOperations to set.
         * @return This builder for chaining.
         */
        public Builder setIncrementalPostOperations(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIncrementalPostOperationsIsMutable();
          incrementalPostOperations_.set(index, value);
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * SQL statements to be executed after inserting new rows into the
         * relation.
         * </pre>
         *
         * <code>repeated string incremental_post_operations = 6;</code>
         *
         * @param value The incrementalPostOperations to add.
         * @return This builder for chaining.
         */
        public Builder addIncrementalPostOperations(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIncrementalPostOperationsIsMutable();
          incrementalPostOperations_.add(value);
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * SQL statements to be executed after inserting new rows into the
         * relation.
         * </pre>
         *
         * <code>repeated string incremental_post_operations = 6;</code>
         *
         * @param values The incrementalPostOperations to add.
         * @return This builder for chaining.
         */
        public Builder addAllIncrementalPostOperations(
            java.lang.Iterable<java.lang.String> values) {
          ensureIncrementalPostOperationsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, incrementalPostOperations_);
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * SQL statements to be executed after inserting new rows into the
         * relation.
         * </pre>
         *
         * <code>repeated string incremental_post_operations = 6;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearIncrementalPostOperations() {
          incrementalPostOperations_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
          ;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * SQL statements to be executed after inserting new rows into the
         * relation.
         * </pre>
         *
         * <code>repeated string incremental_post_operations = 6;</code>
         *
         * @param value The bytes of the incrementalPostOperations to add.
         * @return This builder for chaining.
         */
        public Builder addIncrementalPostOperationsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureIncrementalPostOperationsIsMutable();
          incrementalPostOperations_.add(value);
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig)
      private static final com.google.cloud.dataform.v1.CompilationResultAction.Relation
              .IncrementalTableConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dataform.v1.CompilationResultAction.Relation
                .IncrementalTableConfig();
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.Relation
              .IncrementalTableConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<IncrementalTableConfig> PARSER =
          new com.google.protobuf.AbstractParser<IncrementalTableConfig>() {
            @java.lang.Override
            public IncrementalTableConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<IncrementalTableConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<IncrementalTableConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int DEPENDENCY_TARGETS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.dataform.v1.Target> dependencyTargets_;

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dataform.v1.Target> getDependencyTargetsList() {
      return dependencyTargets_;
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.dataform.v1.TargetOrBuilder>
        getDependencyTargetsOrBuilderList() {
      return dependencyTargets_;
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public int getDependencyTargetsCount() {
      return dependencyTargets_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.Target getDependencyTargets(int index) {
      return dependencyTargets_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.TargetOrBuilder getDependencyTargetsOrBuilder(int index) {
      return dependencyTargets_.get(index);
    }

    public static final int DISABLED_FIELD_NUMBER = 2;
    private boolean disabled_ = false;

    /**
     *
     *
     * <pre>
     * Whether this action is disabled (i.e. should not be run).
     * </pre>
     *
     * <code>bool disabled = 2;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }

    public static final int TAGS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList tags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      return tags_;
    }

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }

    public static final int RELATION_DESCRIPTOR_FIELD_NUMBER = 4;
    private com.google.cloud.dataform.v1.RelationDescriptor relationDescriptor_;

    /**
     *
     *
     * <pre>
     * Descriptor for the relation and its columns.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 4;</code>
     *
     * @return Whether the relationDescriptor field is set.
     */
    @java.lang.Override
    public boolean hasRelationDescriptor() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Descriptor for the relation and its columns.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 4;</code>
     *
     * @return The relationDescriptor.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.RelationDescriptor getRelationDescriptor() {
      return relationDescriptor_ == null
          ? com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()
          : relationDescriptor_;
    }

    /**
     *
     *
     * <pre>
     * Descriptor for the relation and its columns.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.RelationDescriptorOrBuilder
        getRelationDescriptorOrBuilder() {
      return relationDescriptor_ == null
          ? com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()
          : relationDescriptor_;
    }

    public static final int RELATION_TYPE_FIELD_NUMBER = 5;
    private int relationType_ = 0;

    /**
     *
     *
     * <pre>
     * The type of this relation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType relation_type = 5;
     * </code>
     *
     * @return The enum numeric value on the wire for relationType.
     */
    @java.lang.Override
    public int getRelationTypeValue() {
      return relationType_;
    }

    /**
     *
     *
     * <pre>
     * The type of this relation.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType relation_type = 5;
     * </code>
     *
     * @return The relationType.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType
        getRelationType() {
      com.google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType result =
          com.google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType.forNumber(
              relationType_);
      return result == null
          ? com.google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType.UNRECOGNIZED
          : result;
    }

    public static final int SELECT_QUERY_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object selectQuery_ = "";

    /**
     *
     *
     * <pre>
     * The SELECT query which returns rows which this relation should contain.
     * </pre>
     *
     * <code>string select_query = 6;</code>
     *
     * @return The selectQuery.
     */
    @java.lang.Override
    public java.lang.String getSelectQuery() {
      java.lang.Object ref = selectQuery_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selectQuery_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The SELECT query which returns rows which this relation should contain.
     * </pre>
     *
     * <code>string select_query = 6;</code>
     *
     * @return The bytes for selectQuery.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSelectQueryBytes() {
      java.lang.Object ref = selectQuery_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selectQuery_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PRE_OPERATIONS_FIELD_NUMBER = 7;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList preOperations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * SQL statements to be executed before creating the relation.
     * </pre>
     *
     * <code>repeated string pre_operations = 7;</code>
     *
     * @return A list containing the preOperations.
     */
    public com.google.protobuf.ProtocolStringList getPreOperationsList() {
      return preOperations_;
    }

    /**
     *
     *
     * <pre>
     * SQL statements to be executed before creating the relation.
     * </pre>
     *
     * <code>repeated string pre_operations = 7;</code>
     *
     * @return The count of preOperations.
     */
    public int getPreOperationsCount() {
      return preOperations_.size();
    }

    /**
     *
     *
     * <pre>
     * SQL statements to be executed before creating the relation.
     * </pre>
     *
     * <code>repeated string pre_operations = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The preOperations at the given index.
     */
    public java.lang.String getPreOperations(int index) {
      return preOperations_.get(index);
    }

    /**
     *
     *
     * <pre>
     * SQL statements to be executed before creating the relation.
     * </pre>
     *
     * <code>repeated string pre_operations = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the preOperations at the given index.
     */
    public com.google.protobuf.ByteString getPreOperationsBytes(int index) {
      return preOperations_.getByteString(index);
    }

    public static final int POST_OPERATIONS_FIELD_NUMBER = 8;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList postOperations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * SQL statements to be executed after creating the relation.
     * </pre>
     *
     * <code>repeated string post_operations = 8;</code>
     *
     * @return A list containing the postOperations.
     */
    public com.google.protobuf.ProtocolStringList getPostOperationsList() {
      return postOperations_;
    }

    /**
     *
     *
     * <pre>
     * SQL statements to be executed after creating the relation.
     * </pre>
     *
     * <code>repeated string post_operations = 8;</code>
     *
     * @return The count of postOperations.
     */
    public int getPostOperationsCount() {
      return postOperations_.size();
    }

    /**
     *
     *
     * <pre>
     * SQL statements to be executed after creating the relation.
     * </pre>
     *
     * <code>repeated string post_operations = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The postOperations at the given index.
     */
    public java.lang.String getPostOperations(int index) {
      return postOperations_.get(index);
    }

    /**
     *
     *
     * <pre>
     * SQL statements to be executed after creating the relation.
     * </pre>
     *
     * <code>repeated string post_operations = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the postOperations at the given index.
     */
    public com.google.protobuf.ByteString getPostOperationsBytes(int index) {
      return postOperations_.getByteString(index);
    }

    public static final int INCREMENTAL_TABLE_CONFIG_FIELD_NUMBER = 9;
    private com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
        incrementalTableConfig_;

    /**
     *
     *
     * <pre>
     * Configures `INCREMENTAL_TABLE` settings for this relation. Only set if
     * `relation_type` is `INCREMENTAL_TABLE`.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig incremental_table_config = 9;
     * </code>
     *
     * @return Whether the incrementalTableConfig field is set.
     */
    @java.lang.Override
    public boolean hasIncrementalTableConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Configures `INCREMENTAL_TABLE` settings for this relation. Only set if
     * `relation_type` is `INCREMENTAL_TABLE`.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig incremental_table_config = 9;
     * </code>
     *
     * @return The incrementalTableConfig.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
        getIncrementalTableConfig() {
      return incrementalTableConfig_ == null
          ? com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
              .getDefaultInstance()
          : incrementalTableConfig_;
    }

    /**
     *
     *
     * <pre>
     * Configures `INCREMENTAL_TABLE` settings for this relation. Only set if
     * `relation_type` is `INCREMENTAL_TABLE`.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig incremental_table_config = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.Relation
            .IncrementalTableConfigOrBuilder
        getIncrementalTableConfigOrBuilder() {
      return incrementalTableConfig_ == null
          ? com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
              .getDefaultInstance()
          : incrementalTableConfig_;
    }

    public static final int PARTITION_EXPRESSION_FIELD_NUMBER = 10;

    @SuppressWarnings("serial")
    private volatile java.lang.Object partitionExpression_ = "";

    /**
     *
     *
     * <pre>
     * The SQL expression used to partition the relation.
     * </pre>
     *
     * <code>string partition_expression = 10;</code>
     *
     * @return The partitionExpression.
     */
    @java.lang.Override
    public java.lang.String getPartitionExpression() {
      java.lang.Object ref = partitionExpression_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        partitionExpression_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The SQL expression used to partition the relation.
     * </pre>
     *
     * <code>string partition_expression = 10;</code>
     *
     * @return The bytes for partitionExpression.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPartitionExpressionBytes() {
      java.lang.Object ref = partitionExpression_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        partitionExpression_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CLUSTER_EXPRESSIONS_FIELD_NUMBER = 11;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList clusterExpressions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * A list of columns or SQL expressions used to cluster the table.
     * </pre>
     *
     * <code>repeated string cluster_expressions = 11;</code>
     *
     * @return A list containing the clusterExpressions.
     */
    public com.google.protobuf.ProtocolStringList getClusterExpressionsList() {
      return clusterExpressions_;
    }

    /**
     *
     *
     * <pre>
     * A list of columns or SQL expressions used to cluster the table.
     * </pre>
     *
     * <code>repeated string cluster_expressions = 11;</code>
     *
     * @return The count of clusterExpressions.
     */
    public int getClusterExpressionsCount() {
      return clusterExpressions_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of columns or SQL expressions used to cluster the table.
     * </pre>
     *
     * <code>repeated string cluster_expressions = 11;</code>
     *
     * @param index The index of the element to return.
     * @return The clusterExpressions at the given index.
     */
    public java.lang.String getClusterExpressions(int index) {
      return clusterExpressions_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of columns or SQL expressions used to cluster the table.
     * </pre>
     *
     * <code>repeated string cluster_expressions = 11;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the clusterExpressions at the given index.
     */
    public com.google.protobuf.ByteString getClusterExpressionsBytes(int index) {
      return clusterExpressions_.getByteString(index);
    }

    public static final int PARTITION_EXPIRATION_DAYS_FIELD_NUMBER = 12;
    private int partitionExpirationDays_ = 0;

    /**
     *
     *
     * <pre>
     * Sets the partition expiration in days.
     * </pre>
     *
     * <code>int32 partition_expiration_days = 12;</code>
     *
     * @return The partitionExpirationDays.
     */
    @java.lang.Override
    public int getPartitionExpirationDays() {
      return partitionExpirationDays_;
    }

    public static final int REQUIRE_PARTITION_FILTER_FIELD_NUMBER = 13;
    private boolean requirePartitionFilter_ = false;

    /**
     *
     *
     * <pre>
     * Specifies whether queries on this table must include a predicate filter
     * that filters on the partitioning column.
     * </pre>
     *
     * <code>bool require_partition_filter = 13;</code>
     *
     * @return The requirePartitionFilter.
     */
    @java.lang.Override
    public boolean getRequirePartitionFilter() {
      return requirePartitionFilter_;
    }

    public static final int ADDITIONAL_OPTIONS_FIELD_NUMBER = 14;

    private static final class AdditionalOptionsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.cloud.dataform.v1.DataformProto
                  .internal_static_google_cloud_dataform_v1_CompilationResultAction_Relation_AdditionalOptionsEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, java.lang.String> additionalOptions_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAdditionalOptions() {
      if (additionalOptions_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AdditionalOptionsDefaultEntryHolder.defaultEntry);
      }
      return additionalOptions_;
    }

    public int getAdditionalOptionsCount() {
      return internalGetAdditionalOptions().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Additional options that will be provided as key/value pairs into the
     * options clause of a create table/view statement. See
     * https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language
     * for more information on which options are supported.
     * </pre>
     *
     * <code>map&lt;string, string&gt; additional_options = 14;</code>
     */
    @java.lang.Override
    public boolean containsAdditionalOptions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAdditionalOptions().getMap().containsKey(key);
    }

    /** Use {@link #getAdditionalOptionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAdditionalOptions() {
      return getAdditionalOptionsMap();
    }

    /**
     *
     *
     * <pre>
     * Additional options that will be provided as key/value pairs into the
     * options clause of a create table/view statement. See
     * https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language
     * for more information on which options are supported.
     * </pre>
     *
     * <code>map&lt;string, string&gt; additional_options = 14;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAdditionalOptionsMap() {
      return internalGetAdditionalOptions().getMap();
    }

    /**
     *
     *
     * <pre>
     * Additional options that will be provided as key/value pairs into the
     * options clause of a create table/view statement. See
     * https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language
     * for more information on which options are supported.
     * </pre>
     *
     * <code>map&lt;string, string&gt; additional_options = 14;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAdditionalOptionsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetAdditionalOptions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Additional options that will be provided as key/value pairs into the
     * options clause of a create table/view statement. See
     * https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language
     * for more information on which options are supported.
     * </pre>
     *
     * <code>map&lt;string, string&gt; additional_options = 14;</code>
     */
    @java.lang.Override
    public java.lang.String getAdditionalOptionsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetAdditionalOptions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < dependencyTargets_.size(); i++) {
        output.writeMessage(1, dependencyTargets_.get(i));
      }
      if (disabled_ != false) {
        output.writeBool(2, disabled_);
      }
      for (int i = 0; i < tags_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, tags_.getRaw(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(4, getRelationDescriptor());
      }
      if (relationType_
          != com.google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType
              .RELATION_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(5, relationType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(selectQuery_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, selectQuery_);
      }
      for (int i = 0; i < preOperations_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, preOperations_.getRaw(i));
      }
      for (int i = 0; i < postOperations_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 8, postOperations_.getRaw(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(9, getIncrementalTableConfig());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(partitionExpression_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 10, partitionExpression_);
      }
      for (int i = 0; i < clusterExpressions_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 11, clusterExpressions_.getRaw(i));
      }
      if (partitionExpirationDays_ != 0) {
        output.writeInt32(12, partitionExpirationDays_);
      }
      if (requirePartitionFilter_ != false) {
        output.writeBool(13, requirePartitionFilter_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output,
          internalGetAdditionalOptions(),
          AdditionalOptionsDefaultEntryHolder.defaultEntry,
          14);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < dependencyTargets_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, dependencyTargets_.get(i));
      }
      if (disabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, disabled_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < tags_.size(); i++) {
          dataSize += computeStringSizeNoTag(tags_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getTagsList().size();
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRelationDescriptor());
      }
      if (relationType_
          != com.google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType
              .RELATION_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, relationType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(selectQuery_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, selectQuery_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < preOperations_.size(); i++) {
          dataSize += computeStringSizeNoTag(preOperations_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getPreOperationsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < postOperations_.size(); i++) {
          dataSize += computeStringSizeNoTag(postOperations_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getPostOperationsList().size();
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                9, getIncrementalTableConfig());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(partitionExpression_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, partitionExpression_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < clusterExpressions_.size(); i++) {
          dataSize += computeStringSizeNoTag(clusterExpressions_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getClusterExpressionsList().size();
      }
      if (partitionExpirationDays_ != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(12, partitionExpirationDays_);
      }
      if (requirePartitionFilter_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, requirePartitionFilter_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetAdditionalOptions().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> additionalOptions__ =
            AdditionalOptionsDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, additionalOptions__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataform.v1.CompilationResultAction.Relation)) {
        return super.equals(obj);
      }
      com.google.cloud.dataform.v1.CompilationResultAction.Relation other =
          (com.google.cloud.dataform.v1.CompilationResultAction.Relation) obj;

      if (!getDependencyTargetsList().equals(other.getDependencyTargetsList())) return false;
      if (getDisabled() != other.getDisabled()) return false;
      if (!getTagsList().equals(other.getTagsList())) return false;
      if (hasRelationDescriptor() != other.hasRelationDescriptor()) return false;
      if (hasRelationDescriptor()) {
        if (!getRelationDescriptor().equals(other.getRelationDescriptor())) return false;
      }
      if (relationType_ != other.relationType_) return false;
      if (!getSelectQuery().equals(other.getSelectQuery())) return false;
      if (!getPreOperationsList().equals(other.getPreOperationsList())) return false;
      if (!getPostOperationsList().equals(other.getPostOperationsList())) return false;
      if (hasIncrementalTableConfig() != other.hasIncrementalTableConfig()) return false;
      if (hasIncrementalTableConfig()) {
        if (!getIncrementalTableConfig().equals(other.getIncrementalTableConfig())) return false;
      }
      if (!getPartitionExpression().equals(other.getPartitionExpression())) return false;
      if (!getClusterExpressionsList().equals(other.getClusterExpressionsList())) return false;
      if (getPartitionExpirationDays() != other.getPartitionExpirationDays()) return false;
      if (getRequirePartitionFilter() != other.getRequirePartitionFilter()) return false;
      if (!internalGetAdditionalOptions().equals(other.internalGetAdditionalOptions()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDependencyTargetsCount() > 0) {
        hash = (37 * hash) + DEPENDENCY_TARGETS_FIELD_NUMBER;
        hash = (53 * hash) + getDependencyTargetsList().hashCode();
      }
      hash = (37 * hash) + DISABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
      if (getTagsCount() > 0) {
        hash = (37 * hash) + TAGS_FIELD_NUMBER;
        hash = (53 * hash) + getTagsList().hashCode();
      }
      if (hasRelationDescriptor()) {
        hash = (37 * hash) + RELATION_DESCRIPTOR_FIELD_NUMBER;
        hash = (53 * hash) + getRelationDescriptor().hashCode();
      }
      hash = (37 * hash) + RELATION_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + relationType_;
      hash = (37 * hash) + SELECT_QUERY_FIELD_NUMBER;
      hash = (53 * hash) + getSelectQuery().hashCode();
      if (getPreOperationsCount() > 0) {
        hash = (37 * hash) + PRE_OPERATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getPreOperationsList().hashCode();
      }
      if (getPostOperationsCount() > 0) {
        hash = (37 * hash) + POST_OPERATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getPostOperationsList().hashCode();
      }
      if (hasIncrementalTableConfig()) {
        hash = (37 * hash) + INCREMENTAL_TABLE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getIncrementalTableConfig().hashCode();
      }
      hash = (37 * hash) + PARTITION_EXPRESSION_FIELD_NUMBER;
      hash = (53 * hash) + getPartitionExpression().hashCode();
      if (getClusterExpressionsCount() > 0) {
        hash = (37 * hash) + CLUSTER_EXPRESSIONS_FIELD_NUMBER;
        hash = (53 * hash) + getClusterExpressionsList().hashCode();
      }
      hash = (37 * hash) + PARTITION_EXPIRATION_DAYS_FIELD_NUMBER;
      hash = (53 * hash) + getPartitionExpirationDays();
      hash = (37 * hash) + REQUIRE_PARTITION_FILTER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRequirePartitionFilter());
      if (!internalGetAdditionalOptions().getMap().isEmpty()) {
        hash = (37 * hash) + ADDITIONAL_OPTIONS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetAdditionalOptions().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Relation parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Relation parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Relation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Relation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Relation parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Relation parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Relation parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Relation parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Relation parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Relation parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Relation parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Relation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataform.v1.CompilationResultAction.Relation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Represents a database relation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction.Relation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.CompilationResultAction.Relation)
        com.google.cloud.dataform.v1.CompilationResultAction.RelationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_Relation_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 14:
            return internalGetAdditionalOptions();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 14:
            return internalGetMutableAdditionalOptions();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_Relation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.CompilationResultAction.Relation.class,
                com.google.cloud.dataform.v1.CompilationResultAction.Relation.Builder.class);
      }

      // Construct using com.google.cloud.dataform.v1.CompilationResultAction.Relation.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDependencyTargetsFieldBuilder();
          getRelationDescriptorFieldBuilder();
          getIncrementalTableConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (dependencyTargetsBuilder_ == null) {
          dependencyTargets_ = java.util.Collections.emptyList();
        } else {
          dependencyTargets_ = null;
          dependencyTargetsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        disabled_ = false;
        tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
        relationDescriptor_ = null;
        if (relationDescriptorBuilder_ != null) {
          relationDescriptorBuilder_.dispose();
          relationDescriptorBuilder_ = null;
        }
        relationType_ = 0;
        selectQuery_ = "";
        preOperations_ = com.google.protobuf.LazyStringArrayList.emptyList();
        postOperations_ = com.google.protobuf.LazyStringArrayList.emptyList();
        incrementalTableConfig_ = null;
        if (incrementalTableConfigBuilder_ != null) {
          incrementalTableConfigBuilder_.dispose();
          incrementalTableConfigBuilder_ = null;
        }
        partitionExpression_ = "";
        clusterExpressions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        partitionExpirationDays_ = 0;
        requirePartitionFilter_ = false;
        internalGetMutableAdditionalOptions().clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_Relation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.Relation
          getDefaultInstanceForType() {
        return com.google.cloud.dataform.v1.CompilationResultAction.Relation.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.Relation build() {
        com.google.cloud.dataform.v1.CompilationResultAction.Relation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.Relation buildPartial() {
        com.google.cloud.dataform.v1.CompilationResultAction.Relation result =
            new com.google.cloud.dataform.v1.CompilationResultAction.Relation(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dataform.v1.CompilationResultAction.Relation result) {
        if (dependencyTargetsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            dependencyTargets_ = java.util.Collections.unmodifiableList(dependencyTargets_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.dependencyTargets_ = dependencyTargets_;
        } else {
          result.dependencyTargets_ = dependencyTargetsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.dataform.v1.CompilationResultAction.Relation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.disabled_ = disabled_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          tags_.makeImmutable();
          result.tags_ = tags_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.relationDescriptor_ =
              relationDescriptorBuilder_ == null
                  ? relationDescriptor_
                  : relationDescriptorBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.relationType_ = relationType_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.selectQuery_ = selectQuery_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          preOperations_.makeImmutable();
          result.preOperations_ = preOperations_;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          postOperations_.makeImmutable();
          result.postOperations_ = postOperations_;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.incrementalTableConfig_ =
              incrementalTableConfigBuilder_ == null
                  ? incrementalTableConfig_
                  : incrementalTableConfigBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000200) != 0)) {
          result.partitionExpression_ = partitionExpression_;
        }
        if (((from_bitField0_ & 0x00000400) != 0)) {
          clusterExpressions_.makeImmutable();
          result.clusterExpressions_ = clusterExpressions_;
        }
        if (((from_bitField0_ & 0x00000800) != 0)) {
          result.partitionExpirationDays_ = partitionExpirationDays_;
        }
        if (((from_bitField0_ & 0x00001000) != 0)) {
          result.requirePartitionFilter_ = requirePartitionFilter_;
        }
        if (((from_bitField0_ & 0x00002000) != 0)) {
          result.additionalOptions_ = internalGetAdditionalOptions();
          result.additionalOptions_.makeImmutable();
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataform.v1.CompilationResultAction.Relation) {
          return mergeFrom((com.google.cloud.dataform.v1.CompilationResultAction.Relation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataform.v1.CompilationResultAction.Relation other) {
        if (other
            == com.google.cloud.dataform.v1.CompilationResultAction.Relation.getDefaultInstance())
          return this;
        if (dependencyTargetsBuilder_ == null) {
          if (!other.dependencyTargets_.isEmpty()) {
            if (dependencyTargets_.isEmpty()) {
              dependencyTargets_ = other.dependencyTargets_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureDependencyTargetsIsMutable();
              dependencyTargets_.addAll(other.dependencyTargets_);
            }
            onChanged();
          }
        } else {
          if (!other.dependencyTargets_.isEmpty()) {
            if (dependencyTargetsBuilder_.isEmpty()) {
              dependencyTargetsBuilder_.dispose();
              dependencyTargetsBuilder_ = null;
              dependencyTargets_ = other.dependencyTargets_;
              bitField0_ = (bitField0_ & ~0x00000001);
              dependencyTargetsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDependencyTargetsFieldBuilder()
                      : null;
            } else {
              dependencyTargetsBuilder_.addAllMessages(other.dependencyTargets_);
            }
          }
        }
        if (other.getDisabled() != false) {
          setDisabled(other.getDisabled());
        }
        if (!other.tags_.isEmpty()) {
          if (tags_.isEmpty()) {
            tags_ = other.tags_;
            bitField0_ |= 0x00000004;
          } else {
            ensureTagsIsMutable();
            tags_.addAll(other.tags_);
          }
          onChanged();
        }
        if (other.hasRelationDescriptor()) {
          mergeRelationDescriptor(other.getRelationDescriptor());
        }
        if (other.relationType_ != 0) {
          setRelationTypeValue(other.getRelationTypeValue());
        }
        if (!other.getSelectQuery().isEmpty()) {
          selectQuery_ = other.selectQuery_;
          bitField0_ |= 0x00000020;
          onChanged();
        }
        if (!other.preOperations_.isEmpty()) {
          if (preOperations_.isEmpty()) {
            preOperations_ = other.preOperations_;
            bitField0_ |= 0x00000040;
          } else {
            ensurePreOperationsIsMutable();
            preOperations_.addAll(other.preOperations_);
          }
          onChanged();
        }
        if (!other.postOperations_.isEmpty()) {
          if (postOperations_.isEmpty()) {
            postOperations_ = other.postOperations_;
            bitField0_ |= 0x00000080;
          } else {
            ensurePostOperationsIsMutable();
            postOperations_.addAll(other.postOperations_);
          }
          onChanged();
        }
        if (other.hasIncrementalTableConfig()) {
          mergeIncrementalTableConfig(other.getIncrementalTableConfig());
        }
        if (!other.getPartitionExpression().isEmpty()) {
          partitionExpression_ = other.partitionExpression_;
          bitField0_ |= 0x00000200;
          onChanged();
        }
        if (!other.clusterExpressions_.isEmpty()) {
          if (clusterExpressions_.isEmpty()) {
            clusterExpressions_ = other.clusterExpressions_;
            bitField0_ |= 0x00000400;
          } else {
            ensureClusterExpressionsIsMutable();
            clusterExpressions_.addAll(other.clusterExpressions_);
          }
          onChanged();
        }
        if (other.getPartitionExpirationDays() != 0) {
          setPartitionExpirationDays(other.getPartitionExpirationDays());
        }
        if (other.getRequirePartitionFilter() != false) {
          setRequirePartitionFilter(other.getRequirePartitionFilter());
        }
        internalGetMutableAdditionalOptions().mergeFrom(other.internalGetAdditionalOptions());
        bitField0_ |= 0x00002000;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.dataform.v1.Target m =
                      input.readMessage(
                          com.google.cloud.dataform.v1.Target.parser(), extensionRegistry);
                  if (dependencyTargetsBuilder_ == null) {
                    ensureDependencyTargetsIsMutable();
                    dependencyTargets_.add(m);
                  } else {
                    dependencyTargetsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 16:
                {
                  disabled_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureTagsIsMutable();
                  tags_.add(s);
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getRelationDescriptorFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 40:
                {
                  relationType_ = input.readEnum();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              case 50:
                {
                  selectQuery_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              case 58:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensurePreOperationsIsMutable();
                  preOperations_.add(s);
                  break;
                } // case 58
              case 66:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensurePostOperationsIsMutable();
                  postOperations_.add(s);
                  break;
                } // case 66
              case 74:
                {
                  input.readMessage(
                      getIncrementalTableConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000100;
                  break;
                } // case 74
              case 82:
                {
                  partitionExpression_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000200;
                  break;
                } // case 82
              case 90:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureClusterExpressionsIsMutable();
                  clusterExpressions_.add(s);
                  break;
                } // case 90
              case 96:
                {
                  partitionExpirationDays_ = input.readInt32();
                  bitField0_ |= 0x00000800;
                  break;
                } // case 96
              case 104:
                {
                  requirePartitionFilter_ = input.readBool();
                  bitField0_ |= 0x00001000;
                  break;
                } // case 104
              case 114:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                      additionalOptions__ =
                          input.readMessage(
                              AdditionalOptionsDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableAdditionalOptions()
                      .getMutableMap()
                      .put(additionalOptions__.getKey(), additionalOptions__.getValue());
                  bitField0_ |= 0x00002000;
                  break;
                } // case 114
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.dataform.v1.Target> dependencyTargets_ =
          java.util.Collections.emptyList();

      private void ensureDependencyTargetsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          dependencyTargets_ =
              new java.util.ArrayList<com.google.cloud.dataform.v1.Target>(dependencyTargets_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dataform.v1.Target,
              com.google.cloud.dataform.v1.Target.Builder,
              com.google.cloud.dataform.v1.TargetOrBuilder>
          dependencyTargetsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public java.util.List<com.google.cloud.dataform.v1.Target> getDependencyTargetsList() {
        if (dependencyTargetsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(dependencyTargets_);
        } else {
          return dependencyTargetsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public int getDependencyTargetsCount() {
        if (dependencyTargetsBuilder_ == null) {
          return dependencyTargets_.size();
        } else {
          return dependencyTargetsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target getDependencyTargets(int index) {
        if (dependencyTargetsBuilder_ == null) {
          return dependencyTargets_.get(index);
        } else {
          return dependencyTargetsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder setDependencyTargets(int index, com.google.cloud.dataform.v1.Target value) {
        if (dependencyTargetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.set(index, value);
          onChanged();
        } else {
          dependencyTargetsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder setDependencyTargets(
          int index, com.google.cloud.dataform.v1.Target.Builder builderForValue) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.set(index, builderForValue.build());
          onChanged();
        } else {
          dependencyTargetsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(com.google.cloud.dataform.v1.Target value) {
        if (dependencyTargetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(value);
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(int index, com.google.cloud.dataform.v1.Target value) {
        if (dependencyTargetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(index, value);
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(
          com.google.cloud.dataform.v1.Target.Builder builderForValue) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(builderForValue.build());
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(
          int index, com.google.cloud.dataform.v1.Target.Builder builderForValue) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(index, builderForValue.build());
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addAllDependencyTargets(
          java.lang.Iterable<? extends com.google.cloud.dataform.v1.Target> values) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dependencyTargets_);
          onChanged();
        } else {
          dependencyTargetsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder clearDependencyTargets() {
        if (dependencyTargetsBuilder_ == null) {
          dependencyTargets_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          dependencyTargetsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder removeDependencyTargets(int index) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.remove(index);
          onChanged();
        } else {
          dependencyTargetsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target.Builder getDependencyTargetsBuilder(int index) {
        return getDependencyTargetsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.TargetOrBuilder getDependencyTargetsOrBuilder(int index) {
        if (dependencyTargetsBuilder_ == null) {
          return dependencyTargets_.get(index);
        } else {
          return dependencyTargetsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public java.util.List<? extends com.google.cloud.dataform.v1.TargetOrBuilder>
          getDependencyTargetsOrBuilderList() {
        if (dependencyTargetsBuilder_ != null) {
          return dependencyTargetsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(dependencyTargets_);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target.Builder addDependencyTargetsBuilder() {
        return getDependencyTargetsFieldBuilder()
            .addBuilder(com.google.cloud.dataform.v1.Target.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target.Builder addDependencyTargetsBuilder(int index) {
        return getDependencyTargetsFieldBuilder()
            .addBuilder(index, com.google.cloud.dataform.v1.Target.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public java.util.List<com.google.cloud.dataform.v1.Target.Builder>
          getDependencyTargetsBuilderList() {
        return getDependencyTargetsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dataform.v1.Target,
              com.google.cloud.dataform.v1.Target.Builder,
              com.google.cloud.dataform.v1.TargetOrBuilder>
          getDependencyTargetsFieldBuilder() {
        if (dependencyTargetsBuilder_ == null) {
          dependencyTargetsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dataform.v1.Target,
                  com.google.cloud.dataform.v1.Target.Builder,
                  com.google.cloud.dataform.v1.TargetOrBuilder>(
                  dependencyTargets_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          dependencyTargets_ = null;
        }
        return dependencyTargetsBuilder_;
      }

      private boolean disabled_;

      /**
       *
       *
       * <pre>
       * Whether this action is disabled (i.e. should not be run).
       * </pre>
       *
       * <code>bool disabled = 2;</code>
       *
       * @return The disabled.
       */
      @java.lang.Override
      public boolean getDisabled() {
        return disabled_;
      }

      /**
       *
       *
       * <pre>
       * Whether this action is disabled (i.e. should not be run).
       * </pre>
       *
       * <code>bool disabled = 2;</code>
       *
       * @param value The disabled to set.
       * @return This builder for chaining.
       */
      public Builder setDisabled(boolean value) {

        disabled_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Whether this action is disabled (i.e. should not be run).
       * </pre>
       *
       * <code>bool disabled = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisabled() {
        bitField0_ = (bitField0_ & ~0x00000002);
        disabled_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList tags_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureTagsIsMutable() {
        if (!tags_.isModifiable()) {
          tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
        }
        bitField0_ |= 0x00000004;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @return A list containing the tags.
       */
      public com.google.protobuf.ProtocolStringList getTagsList() {
        tags_.makeImmutable();
        return tags_;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @return The count of tags.
       */
      public int getTagsCount() {
        return tags_.size();
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The tags at the given index.
       */
      public java.lang.String getTags(int index) {
        return tags_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the tags at the given index.
       */
      public com.google.protobuf.ByteString getTagsBytes(int index) {
        return tags_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The tags to set.
       * @return This builder for chaining.
       */
      public Builder setTags(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @param value The tags to add.
       * @return This builder for chaining.
       */
      public Builder addTags(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @param values The tags to add.
       * @return This builder for chaining.
       */
      public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
        ensureTagsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTags() {
        tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @param value The bytes of the tags to add.
       * @return This builder for chaining.
       */
      public Builder addTagsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureTagsIsMutable();
        tags_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.cloud.dataform.v1.RelationDescriptor relationDescriptor_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.RelationDescriptor,
              com.google.cloud.dataform.v1.RelationDescriptor.Builder,
              com.google.cloud.dataform.v1.RelationDescriptorOrBuilder>
          relationDescriptorBuilder_;

      /**
       *
       *
       * <pre>
       * Descriptor for the relation and its columns.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 4;</code>
       *
       * @return Whether the relationDescriptor field is set.
       */
      public boolean hasRelationDescriptor() {
        return ((bitField0_ & 0x00000008) != 0);
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the relation and its columns.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 4;</code>
       *
       * @return The relationDescriptor.
       */
      public com.google.cloud.dataform.v1.RelationDescriptor getRelationDescriptor() {
        if (relationDescriptorBuilder_ == null) {
          return relationDescriptor_ == null
              ? com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()
              : relationDescriptor_;
        } else {
          return relationDescriptorBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the relation and its columns.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 4;</code>
       */
      public Builder setRelationDescriptor(com.google.cloud.dataform.v1.RelationDescriptor value) {
        if (relationDescriptorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          relationDescriptor_ = value;
        } else {
          relationDescriptorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the relation and its columns.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 4;</code>
       */
      public Builder setRelationDescriptor(
          com.google.cloud.dataform.v1.RelationDescriptor.Builder builderForValue) {
        if (relationDescriptorBuilder_ == null) {
          relationDescriptor_ = builderForValue.build();
        } else {
          relationDescriptorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the relation and its columns.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 4;</code>
       */
      public Builder mergeRelationDescriptor(
          com.google.cloud.dataform.v1.RelationDescriptor value) {
        if (relationDescriptorBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && relationDescriptor_ != null
              && relationDescriptor_
                  != com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()) {
            getRelationDescriptorBuilder().mergeFrom(value);
          } else {
            relationDescriptor_ = value;
          }
        } else {
          relationDescriptorBuilder_.mergeFrom(value);
        }
        if (relationDescriptor_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the relation and its columns.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 4;</code>
       */
      public Builder clearRelationDescriptor() {
        bitField0_ = (bitField0_ & ~0x00000008);
        relationDescriptor_ = null;
        if (relationDescriptorBuilder_ != null) {
          relationDescriptorBuilder_.dispose();
          relationDescriptorBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the relation and its columns.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 4;</code>
       */
      public com.google.cloud.dataform.v1.RelationDescriptor.Builder
          getRelationDescriptorBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getRelationDescriptorFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the relation and its columns.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 4;</code>
       */
      public com.google.cloud.dataform.v1.RelationDescriptorOrBuilder
          getRelationDescriptorOrBuilder() {
        if (relationDescriptorBuilder_ != null) {
          return relationDescriptorBuilder_.getMessageOrBuilder();
        } else {
          return relationDescriptor_ == null
              ? com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()
              : relationDescriptor_;
        }
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the relation and its columns.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.RelationDescriptor,
              com.google.cloud.dataform.v1.RelationDescriptor.Builder,
              com.google.cloud.dataform.v1.RelationDescriptorOrBuilder>
          getRelationDescriptorFieldBuilder() {
        if (relationDescriptorBuilder_ == null) {
          relationDescriptorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dataform.v1.RelationDescriptor,
                  com.google.cloud.dataform.v1.RelationDescriptor.Builder,
                  com.google.cloud.dataform.v1.RelationDescriptorOrBuilder>(
                  getRelationDescriptor(), getParentForChildren(), isClean());
          relationDescriptor_ = null;
        }
        return relationDescriptorBuilder_;
      }

      private int relationType_ = 0;

      /**
       *
       *
       * <pre>
       * The type of this relation.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType relation_type = 5;
       * </code>
       *
       * @return The enum numeric value on the wire for relationType.
       */
      @java.lang.Override
      public int getRelationTypeValue() {
        return relationType_;
      }

      /**
       *
       *
       * <pre>
       * The type of this relation.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType relation_type = 5;
       * </code>
       *
       * @param value The enum numeric value on the wire for relationType to set.
       * @return This builder for chaining.
       */
      public Builder setRelationTypeValue(int value) {
        relationType_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of this relation.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType relation_type = 5;
       * </code>
       *
       * @return The relationType.
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType
          getRelationType() {
        com.google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType result =
            com.google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType.forNumber(
                relationType_);
        return result == null
            ? com.google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType
                .UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The type of this relation.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType relation_type = 5;
       * </code>
       *
       * @param value The relationType to set.
       * @return This builder for chaining.
       */
      public Builder setRelationType(
          com.google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        relationType_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of this relation.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.Relation.RelationType relation_type = 5;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRelationType() {
        bitField0_ = (bitField0_ & ~0x00000010);
        relationType_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object selectQuery_ = "";

      /**
       *
       *
       * <pre>
       * The SELECT query which returns rows which this relation should contain.
       * </pre>
       *
       * <code>string select_query = 6;</code>
       *
       * @return The selectQuery.
       */
      public java.lang.String getSelectQuery() {
        java.lang.Object ref = selectQuery_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          selectQuery_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The SELECT query which returns rows which this relation should contain.
       * </pre>
       *
       * <code>string select_query = 6;</code>
       *
       * @return The bytes for selectQuery.
       */
      public com.google.protobuf.ByteString getSelectQueryBytes() {
        java.lang.Object ref = selectQuery_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          selectQuery_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The SELECT query which returns rows which this relation should contain.
       * </pre>
       *
       * <code>string select_query = 6;</code>
       *
       * @param value The selectQuery to set.
       * @return This builder for chaining.
       */
      public Builder setSelectQuery(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        selectQuery_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The SELECT query which returns rows which this relation should contain.
       * </pre>
       *
       * <code>string select_query = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSelectQuery() {
        selectQuery_ = getDefaultInstance().getSelectQuery();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The SELECT query which returns rows which this relation should contain.
       * </pre>
       *
       * <code>string select_query = 6;</code>
       *
       * @param value The bytes for selectQuery to set.
       * @return This builder for chaining.
       */
      public Builder setSelectQueryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        selectQuery_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList preOperations_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensurePreOperationsIsMutable() {
        if (!preOperations_.isModifiable()) {
          preOperations_ = new com.google.protobuf.LazyStringArrayList(preOperations_);
        }
        bitField0_ |= 0x00000040;
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed before creating the relation.
       * </pre>
       *
       * <code>repeated string pre_operations = 7;</code>
       *
       * @return A list containing the preOperations.
       */
      public com.google.protobuf.ProtocolStringList getPreOperationsList() {
        preOperations_.makeImmutable();
        return preOperations_;
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed before creating the relation.
       * </pre>
       *
       * <code>repeated string pre_operations = 7;</code>
       *
       * @return The count of preOperations.
       */
      public int getPreOperationsCount() {
        return preOperations_.size();
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed before creating the relation.
       * </pre>
       *
       * <code>repeated string pre_operations = 7;</code>
       *
       * @param index The index of the element to return.
       * @return The preOperations at the given index.
       */
      public java.lang.String getPreOperations(int index) {
        return preOperations_.get(index);
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed before creating the relation.
       * </pre>
       *
       * <code>repeated string pre_operations = 7;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the preOperations at the given index.
       */
      public com.google.protobuf.ByteString getPreOperationsBytes(int index) {
        return preOperations_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed before creating the relation.
       * </pre>
       *
       * <code>repeated string pre_operations = 7;</code>
       *
       * @param index The index to set the value at.
       * @param value The preOperations to set.
       * @return This builder for chaining.
       */
      public Builder setPreOperations(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePreOperationsIsMutable();
        preOperations_.set(index, value);
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed before creating the relation.
       * </pre>
       *
       * <code>repeated string pre_operations = 7;</code>
       *
       * @param value The preOperations to add.
       * @return This builder for chaining.
       */
      public Builder addPreOperations(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePreOperationsIsMutable();
        preOperations_.add(value);
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed before creating the relation.
       * </pre>
       *
       * <code>repeated string pre_operations = 7;</code>
       *
       * @param values The preOperations to add.
       * @return This builder for chaining.
       */
      public Builder addAllPreOperations(java.lang.Iterable<java.lang.String> values) {
        ensurePreOperationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, preOperations_);
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed before creating the relation.
       * </pre>
       *
       * <code>repeated string pre_operations = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPreOperations() {
        preOperations_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed before creating the relation.
       * </pre>
       *
       * <code>repeated string pre_operations = 7;</code>
       *
       * @param value The bytes of the preOperations to add.
       * @return This builder for chaining.
       */
      public Builder addPreOperationsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensurePreOperationsIsMutable();
        preOperations_.add(value);
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList postOperations_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensurePostOperationsIsMutable() {
        if (!postOperations_.isModifiable()) {
          postOperations_ = new com.google.protobuf.LazyStringArrayList(postOperations_);
        }
        bitField0_ |= 0x00000080;
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed after creating the relation.
       * </pre>
       *
       * <code>repeated string post_operations = 8;</code>
       *
       * @return A list containing the postOperations.
       */
      public com.google.protobuf.ProtocolStringList getPostOperationsList() {
        postOperations_.makeImmutable();
        return postOperations_;
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed after creating the relation.
       * </pre>
       *
       * <code>repeated string post_operations = 8;</code>
       *
       * @return The count of postOperations.
       */
      public int getPostOperationsCount() {
        return postOperations_.size();
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed after creating the relation.
       * </pre>
       *
       * <code>repeated string post_operations = 8;</code>
       *
       * @param index The index of the element to return.
       * @return The postOperations at the given index.
       */
      public java.lang.String getPostOperations(int index) {
        return postOperations_.get(index);
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed after creating the relation.
       * </pre>
       *
       * <code>repeated string post_operations = 8;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the postOperations at the given index.
       */
      public com.google.protobuf.ByteString getPostOperationsBytes(int index) {
        return postOperations_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed after creating the relation.
       * </pre>
       *
       * <code>repeated string post_operations = 8;</code>
       *
       * @param index The index to set the value at.
       * @param value The postOperations to set.
       * @return This builder for chaining.
       */
      public Builder setPostOperations(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePostOperationsIsMutable();
        postOperations_.set(index, value);
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed after creating the relation.
       * </pre>
       *
       * <code>repeated string post_operations = 8;</code>
       *
       * @param value The postOperations to add.
       * @return This builder for chaining.
       */
      public Builder addPostOperations(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePostOperationsIsMutable();
        postOperations_.add(value);
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed after creating the relation.
       * </pre>
       *
       * <code>repeated string post_operations = 8;</code>
       *
       * @param values The postOperations to add.
       * @return This builder for chaining.
       */
      public Builder addAllPostOperations(java.lang.Iterable<java.lang.String> values) {
        ensurePostOperationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, postOperations_);
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed after creating the relation.
       * </pre>
       *
       * <code>repeated string post_operations = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPostOperations() {
        postOperations_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * SQL statements to be executed after creating the relation.
       * </pre>
       *
       * <code>repeated string post_operations = 8;</code>
       *
       * @param value The bytes of the postOperations to add.
       * @return This builder for chaining.
       */
      public Builder addPostOperationsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensurePostOperationsIsMutable();
        postOperations_.add(value);
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      private com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
          incrementalTableConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig,
              com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
                  .Builder,
              com.google.cloud.dataform.v1.CompilationResultAction.Relation
                  .IncrementalTableConfigOrBuilder>
          incrementalTableConfigBuilder_;

      /**
       *
       *
       * <pre>
       * Configures `INCREMENTAL_TABLE` settings for this relation. Only set if
       * `relation_type` is `INCREMENTAL_TABLE`.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig incremental_table_config = 9;
       * </code>
       *
       * @return Whether the incrementalTableConfig field is set.
       */
      public boolean hasIncrementalTableConfig() {
        return ((bitField0_ & 0x00000100) != 0);
      }

      /**
       *
       *
       * <pre>
       * Configures `INCREMENTAL_TABLE` settings for this relation. Only set if
       * `relation_type` is `INCREMENTAL_TABLE`.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig incremental_table_config = 9;
       * </code>
       *
       * @return The incrementalTableConfig.
       */
      public com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
          getIncrementalTableConfig() {
        if (incrementalTableConfigBuilder_ == null) {
          return incrementalTableConfig_ == null
              ? com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
                  .getDefaultInstance()
              : incrementalTableConfig_;
        } else {
          return incrementalTableConfigBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Configures `INCREMENTAL_TABLE` settings for this relation. Only set if
       * `relation_type` is `INCREMENTAL_TABLE`.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig incremental_table_config = 9;
       * </code>
       */
      public Builder setIncrementalTableConfig(
          com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
              value) {
        if (incrementalTableConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          incrementalTableConfig_ = value;
        } else {
          incrementalTableConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Configures `INCREMENTAL_TABLE` settings for this relation. Only set if
       * `relation_type` is `INCREMENTAL_TABLE`.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig incremental_table_config = 9;
       * </code>
       */
      public Builder setIncrementalTableConfig(
          com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
                  .Builder
              builderForValue) {
        if (incrementalTableConfigBuilder_ == null) {
          incrementalTableConfig_ = builderForValue.build();
        } else {
          incrementalTableConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Configures `INCREMENTAL_TABLE` settings for this relation. Only set if
       * `relation_type` is `INCREMENTAL_TABLE`.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig incremental_table_config = 9;
       * </code>
       */
      public Builder mergeIncrementalTableConfig(
          com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
              value) {
        if (incrementalTableConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0)
              && incrementalTableConfig_ != null
              && incrementalTableConfig_
                  != com.google.cloud.dataform.v1.CompilationResultAction.Relation
                      .IncrementalTableConfig.getDefaultInstance()) {
            getIncrementalTableConfigBuilder().mergeFrom(value);
          } else {
            incrementalTableConfig_ = value;
          }
        } else {
          incrementalTableConfigBuilder_.mergeFrom(value);
        }
        if (incrementalTableConfig_ != null) {
          bitField0_ |= 0x00000100;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Configures `INCREMENTAL_TABLE` settings for this relation. Only set if
       * `relation_type` is `INCREMENTAL_TABLE`.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig incremental_table_config = 9;
       * </code>
       */
      public Builder clearIncrementalTableConfig() {
        bitField0_ = (bitField0_ & ~0x00000100);
        incrementalTableConfig_ = null;
        if (incrementalTableConfigBuilder_ != null) {
          incrementalTableConfigBuilder_.dispose();
          incrementalTableConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Configures `INCREMENTAL_TABLE` settings for this relation. Only set if
       * `relation_type` is `INCREMENTAL_TABLE`.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig incremental_table_config = 9;
       * </code>
       */
      public com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
              .Builder
          getIncrementalTableConfigBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getIncrementalTableConfigFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Configures `INCREMENTAL_TABLE` settings for this relation. Only set if
       * `relation_type` is `INCREMENTAL_TABLE`.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig incremental_table_config = 9;
       * </code>
       */
      public com.google.cloud.dataform.v1.CompilationResultAction.Relation
              .IncrementalTableConfigOrBuilder
          getIncrementalTableConfigOrBuilder() {
        if (incrementalTableConfigBuilder_ != null) {
          return incrementalTableConfigBuilder_.getMessageOrBuilder();
        } else {
          return incrementalTableConfig_ == null
              ? com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
                  .getDefaultInstance()
              : incrementalTableConfig_;
        }
      }

      /**
       *
       *
       * <pre>
       * Configures `INCREMENTAL_TABLE` settings for this relation. Only set if
       * `relation_type` is `INCREMENTAL_TABLE`.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig incremental_table_config = 9;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig,
              com.google.cloud.dataform.v1.CompilationResultAction.Relation.IncrementalTableConfig
                  .Builder,
              com.google.cloud.dataform.v1.CompilationResultAction.Relation
                  .IncrementalTableConfigOrBuilder>
          getIncrementalTableConfigFieldBuilder() {
        if (incrementalTableConfigBuilder_ == null) {
          incrementalTableConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dataform.v1.CompilationResultAction.Relation
                      .IncrementalTableConfig,
                  com.google.cloud.dataform.v1.CompilationResultAction.Relation
                      .IncrementalTableConfig.Builder,
                  com.google.cloud.dataform.v1.CompilationResultAction.Relation
                      .IncrementalTableConfigOrBuilder>(
                  getIncrementalTableConfig(), getParentForChildren(), isClean());
          incrementalTableConfig_ = null;
        }
        return incrementalTableConfigBuilder_;
      }

      private java.lang.Object partitionExpression_ = "";

      /**
       *
       *
       * <pre>
       * The SQL expression used to partition the relation.
       * </pre>
       *
       * <code>string partition_expression = 10;</code>
       *
       * @return The partitionExpression.
       */
      public java.lang.String getPartitionExpression() {
        java.lang.Object ref = partitionExpression_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          partitionExpression_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The SQL expression used to partition the relation.
       * </pre>
       *
       * <code>string partition_expression = 10;</code>
       *
       * @return The bytes for partitionExpression.
       */
      public com.google.protobuf.ByteString getPartitionExpressionBytes() {
        java.lang.Object ref = partitionExpression_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          partitionExpression_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The SQL expression used to partition the relation.
       * </pre>
       *
       * <code>string partition_expression = 10;</code>
       *
       * @param value The partitionExpression to set.
       * @return This builder for chaining.
       */
      public Builder setPartitionExpression(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        partitionExpression_ = value;
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The SQL expression used to partition the relation.
       * </pre>
       *
       * <code>string partition_expression = 10;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPartitionExpression() {
        partitionExpression_ = getDefaultInstance().getPartitionExpression();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The SQL expression used to partition the relation.
       * </pre>
       *
       * <code>string partition_expression = 10;</code>
       *
       * @param value The bytes for partitionExpression to set.
       * @return This builder for chaining.
       */
      public Builder setPartitionExpressionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        partitionExpression_ = value;
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList clusterExpressions_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureClusterExpressionsIsMutable() {
        if (!clusterExpressions_.isModifiable()) {
          clusterExpressions_ = new com.google.protobuf.LazyStringArrayList(clusterExpressions_);
        }
        bitField0_ |= 0x00000400;
      }

      /**
       *
       *
       * <pre>
       * A list of columns or SQL expressions used to cluster the table.
       * </pre>
       *
       * <code>repeated string cluster_expressions = 11;</code>
       *
       * @return A list containing the clusterExpressions.
       */
      public com.google.protobuf.ProtocolStringList getClusterExpressionsList() {
        clusterExpressions_.makeImmutable();
        return clusterExpressions_;
      }

      /**
       *
       *
       * <pre>
       * A list of columns or SQL expressions used to cluster the table.
       * </pre>
       *
       * <code>repeated string cluster_expressions = 11;</code>
       *
       * @return The count of clusterExpressions.
       */
      public int getClusterExpressionsCount() {
        return clusterExpressions_.size();
      }

      /**
       *
       *
       * <pre>
       * A list of columns or SQL expressions used to cluster the table.
       * </pre>
       *
       * <code>repeated string cluster_expressions = 11;</code>
       *
       * @param index The index of the element to return.
       * @return The clusterExpressions at the given index.
       */
      public java.lang.String getClusterExpressions(int index) {
        return clusterExpressions_.get(index);
      }

      /**
       *
       *
       * <pre>
       * A list of columns or SQL expressions used to cluster the table.
       * </pre>
       *
       * <code>repeated string cluster_expressions = 11;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the clusterExpressions at the given index.
       */
      public com.google.protobuf.ByteString getClusterExpressionsBytes(int index) {
        return clusterExpressions_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * A list of columns or SQL expressions used to cluster the table.
       * </pre>
       *
       * <code>repeated string cluster_expressions = 11;</code>
       *
       * @param index The index to set the value at.
       * @param value The clusterExpressions to set.
       * @return This builder for chaining.
       */
      public Builder setClusterExpressions(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClusterExpressionsIsMutable();
        clusterExpressions_.set(index, value);
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of columns or SQL expressions used to cluster the table.
       * </pre>
       *
       * <code>repeated string cluster_expressions = 11;</code>
       *
       * @param value The clusterExpressions to add.
       * @return This builder for chaining.
       */
      public Builder addClusterExpressions(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClusterExpressionsIsMutable();
        clusterExpressions_.add(value);
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of columns or SQL expressions used to cluster the table.
       * </pre>
       *
       * <code>repeated string cluster_expressions = 11;</code>
       *
       * @param values The clusterExpressions to add.
       * @return This builder for chaining.
       */
      public Builder addAllClusterExpressions(java.lang.Iterable<java.lang.String> values) {
        ensureClusterExpressionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, clusterExpressions_);
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of columns or SQL expressions used to cluster the table.
       * </pre>
       *
       * <code>repeated string cluster_expressions = 11;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearClusterExpressions() {
        clusterExpressions_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of columns or SQL expressions used to cluster the table.
       * </pre>
       *
       * <code>repeated string cluster_expressions = 11;</code>
       *
       * @param value The bytes of the clusterExpressions to add.
       * @return This builder for chaining.
       */
      public Builder addClusterExpressionsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureClusterExpressionsIsMutable();
        clusterExpressions_.add(value);
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }

      private int partitionExpirationDays_;

      /**
       *
       *
       * <pre>
       * Sets the partition expiration in days.
       * </pre>
       *
       * <code>int32 partition_expiration_days = 12;</code>
       *
       * @return The partitionExpirationDays.
       */
      @java.lang.Override
      public int getPartitionExpirationDays() {
        return partitionExpirationDays_;
      }

      /**
       *
       *
       * <pre>
       * Sets the partition expiration in days.
       * </pre>
       *
       * <code>int32 partition_expiration_days = 12;</code>
       *
       * @param value The partitionExpirationDays to set.
       * @return This builder for chaining.
       */
      public Builder setPartitionExpirationDays(int value) {

        partitionExpirationDays_ = value;
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Sets the partition expiration in days.
       * </pre>
       *
       * <code>int32 partition_expiration_days = 12;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPartitionExpirationDays() {
        bitField0_ = (bitField0_ & ~0x00000800);
        partitionExpirationDays_ = 0;
        onChanged();
        return this;
      }

      private boolean requirePartitionFilter_;

      /**
       *
       *
       * <pre>
       * Specifies whether queries on this table must include a predicate filter
       * that filters on the partitioning column.
       * </pre>
       *
       * <code>bool require_partition_filter = 13;</code>
       *
       * @return The requirePartitionFilter.
       */
      @java.lang.Override
      public boolean getRequirePartitionFilter() {
        return requirePartitionFilter_;
      }

      /**
       *
       *
       * <pre>
       * Specifies whether queries on this table must include a predicate filter
       * that filters on the partitioning column.
       * </pre>
       *
       * <code>bool require_partition_filter = 13;</code>
       *
       * @param value The requirePartitionFilter to set.
       * @return This builder for chaining.
       */
      public Builder setRequirePartitionFilter(boolean value) {

        requirePartitionFilter_ = value;
        bitField0_ |= 0x00001000;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Specifies whether queries on this table must include a predicate filter
       * that filters on the partitioning column.
       * </pre>
       *
       * <code>bool require_partition_filter = 13;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRequirePartitionFilter() {
        bitField0_ = (bitField0_ & ~0x00001000);
        requirePartitionFilter_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> additionalOptions_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetAdditionalOptions() {
        if (additionalOptions_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              AdditionalOptionsDefaultEntryHolder.defaultEntry);
        }
        return additionalOptions_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableAdditionalOptions() {
        if (additionalOptions_ == null) {
          additionalOptions_ =
              com.google.protobuf.MapField.newMapField(
                  AdditionalOptionsDefaultEntryHolder.defaultEntry);
        }
        if (!additionalOptions_.isMutable()) {
          additionalOptions_ = additionalOptions_.copy();
        }
        bitField0_ |= 0x00002000;
        onChanged();
        return additionalOptions_;
      }

      public int getAdditionalOptionsCount() {
        return internalGetAdditionalOptions().getMap().size();
      }

      /**
       *
       *
       * <pre>
       * Additional options that will be provided as key/value pairs into the
       * options clause of a create table/view statement. See
       * https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language
       * for more information on which options are supported.
       * </pre>
       *
       * <code>map&lt;string, string&gt; additional_options = 14;</code>
       */
      @java.lang.Override
      public boolean containsAdditionalOptions(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetAdditionalOptions().getMap().containsKey(key);
      }

      /** Use {@link #getAdditionalOptionsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getAdditionalOptions() {
        return getAdditionalOptionsMap();
      }

      /**
       *
       *
       * <pre>
       * Additional options that will be provided as key/value pairs into the
       * options clause of a create table/view statement. See
       * https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language
       * for more information on which options are supported.
       * </pre>
       *
       * <code>map&lt;string, string&gt; additional_options = 14;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getAdditionalOptionsMap() {
        return internalGetAdditionalOptions().getMap();
      }

      /**
       *
       *
       * <pre>
       * Additional options that will be provided as key/value pairs into the
       * options clause of a create table/view statement. See
       * https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language
       * for more information on which options are supported.
       * </pre>
       *
       * <code>map&lt;string, string&gt; additional_options = 14;</code>
       */
      @java.lang.Override
      public /* nullable */ java.lang.String getAdditionalOptionsOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetAdditionalOptions().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }

      /**
       *
       *
       * <pre>
       * Additional options that will be provided as key/value pairs into the
       * options clause of a create table/view statement. See
       * https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language
       * for more information on which options are supported.
       * </pre>
       *
       * <code>map&lt;string, string&gt; additional_options = 14;</code>
       */
      @java.lang.Override
      public java.lang.String getAdditionalOptionsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetAdditionalOptions().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearAdditionalOptions() {
        bitField0_ = (bitField0_ & ~0x00002000);
        internalGetMutableAdditionalOptions().getMutableMap().clear();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Additional options that will be provided as key/value pairs into the
       * options clause of a create table/view statement. See
       * https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language
       * for more information on which options are supported.
       * </pre>
       *
       * <code>map&lt;string, string&gt; additional_options = 14;</code>
       */
      public Builder removeAdditionalOptions(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableAdditionalOptions().getMutableMap().remove(key);
        return this;
      }

      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableAdditionalOptions() {
        bitField0_ |= 0x00002000;
        return internalGetMutableAdditionalOptions().getMutableMap();
      }

      /**
       *
       *
       * <pre>
       * Additional options that will be provided as key/value pairs into the
       * options clause of a create table/view statement. See
       * https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language
       * for more information on which options are supported.
       * </pre>
       *
       * <code>map&lt;string, string&gt; additional_options = 14;</code>
       */
      public Builder putAdditionalOptions(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableAdditionalOptions().getMutableMap().put(key, value);
        bitField0_ |= 0x00002000;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Additional options that will be provided as key/value pairs into the
       * options clause of a create table/view statement. See
       * https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language
       * for more information on which options are supported.
       * </pre>
       *
       * <code>map&lt;string, string&gt; additional_options = 14;</code>
       */
      public Builder putAllAdditionalOptions(
          java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableAdditionalOptions().getMutableMap().putAll(values);
        bitField0_ |= 0x00002000;
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.CompilationResultAction.Relation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.CompilationResultAction.Relation)
    private static final com.google.cloud.dataform.v1.CompilationResultAction.Relation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.CompilationResultAction.Relation();
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Relation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Relation> PARSER =
        new com.google.protobuf.AbstractParser<Relation>() {
          @java.lang.Override
          public Relation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Relation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Relation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.Relation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface OperationsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.CompilationResultAction.Operations)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    java.util.List<com.google.cloud.dataform.v1.Target> getDependencyTargetsList();

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    com.google.cloud.dataform.v1.Target getDependencyTargets(int index);

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    int getDependencyTargetsCount();

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    java.util.List<? extends com.google.cloud.dataform.v1.TargetOrBuilder>
        getDependencyTargetsOrBuilderList();

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    com.google.cloud.dataform.v1.TargetOrBuilder getDependencyTargetsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Whether this action is disabled (i.e. should not be run).
     * </pre>
     *
     * <code>bool disabled = 2;</code>
     *
     * @return The disabled.
     */
    boolean getDisabled();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @return A list containing the tags.
     */
    java.util.List<java.lang.String> getTagsList();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @return The count of tags.
     */
    int getTagsCount();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    java.lang.String getTags(int index);

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    com.google.protobuf.ByteString getTagsBytes(int index);

    /**
     *
     *
     * <pre>
     * Descriptor for any output relation and its columns. Only set if
     * `has_output` is true.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
     *
     * @return Whether the relationDescriptor field is set.
     */
    boolean hasRelationDescriptor();

    /**
     *
     *
     * <pre>
     * Descriptor for any output relation and its columns. Only set if
     * `has_output` is true.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
     *
     * @return The relationDescriptor.
     */
    com.google.cloud.dataform.v1.RelationDescriptor getRelationDescriptor();

    /**
     *
     *
     * <pre>
     * Descriptor for any output relation and its columns. Only set if
     * `has_output` is true.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
     */
    com.google.cloud.dataform.v1.RelationDescriptorOrBuilder getRelationDescriptorOrBuilder();

    /**
     *
     *
     * <pre>
     * A list of arbitrary SQL statements that will be executed without
     * alteration.
     * </pre>
     *
     * <code>repeated string queries = 4;</code>
     *
     * @return A list containing the queries.
     */
    java.util.List<java.lang.String> getQueriesList();

    /**
     *
     *
     * <pre>
     * A list of arbitrary SQL statements that will be executed without
     * alteration.
     * </pre>
     *
     * <code>repeated string queries = 4;</code>
     *
     * @return The count of queries.
     */
    int getQueriesCount();

    /**
     *
     *
     * <pre>
     * A list of arbitrary SQL statements that will be executed without
     * alteration.
     * </pre>
     *
     * <code>repeated string queries = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The queries at the given index.
     */
    java.lang.String getQueries(int index);

    /**
     *
     *
     * <pre>
     * A list of arbitrary SQL statements that will be executed without
     * alteration.
     * </pre>
     *
     * <code>repeated string queries = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the queries at the given index.
     */
    com.google.protobuf.ByteString getQueriesBytes(int index);

    /**
     *
     *
     * <pre>
     * Whether these operations produce an output relation.
     * </pre>
     *
     * <code>bool has_output = 5;</code>
     *
     * @return The hasOutput.
     */
    boolean getHasOutput();
  }

  /**
   *
   *
   * <pre>
   * Represents a list of arbitrary database operations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction.Operations}
   */
  public static final class Operations extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.CompilationResultAction.Operations)
      OperationsOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Operations.newBuilder() to construct.
    private Operations(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Operations() {
      dependencyTargets_ = java.util.Collections.emptyList();
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      queries_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Operations();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_Operations_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_Operations_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.CompilationResultAction.Operations.class,
              com.google.cloud.dataform.v1.CompilationResultAction.Operations.Builder.class);
    }

    private int bitField0_;
    public static final int DEPENDENCY_TARGETS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.dataform.v1.Target> dependencyTargets_;

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dataform.v1.Target> getDependencyTargetsList() {
      return dependencyTargets_;
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.dataform.v1.TargetOrBuilder>
        getDependencyTargetsOrBuilderList() {
      return dependencyTargets_;
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public int getDependencyTargetsCount() {
      return dependencyTargets_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.Target getDependencyTargets(int index) {
      return dependencyTargets_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.TargetOrBuilder getDependencyTargetsOrBuilder(int index) {
      return dependencyTargets_.get(index);
    }

    public static final int DISABLED_FIELD_NUMBER = 2;
    private boolean disabled_ = false;

    /**
     *
     *
     * <pre>
     * Whether this action is disabled (i.e. should not be run).
     * </pre>
     *
     * <code>bool disabled = 2;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }

    public static final int TAGS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList tags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      return tags_;
    }

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }

    public static final int RELATION_DESCRIPTOR_FIELD_NUMBER = 6;
    private com.google.cloud.dataform.v1.RelationDescriptor relationDescriptor_;

    /**
     *
     *
     * <pre>
     * Descriptor for any output relation and its columns. Only set if
     * `has_output` is true.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
     *
     * @return Whether the relationDescriptor field is set.
     */
    @java.lang.Override
    public boolean hasRelationDescriptor() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Descriptor for any output relation and its columns. Only set if
     * `has_output` is true.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
     *
     * @return The relationDescriptor.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.RelationDescriptor getRelationDescriptor() {
      return relationDescriptor_ == null
          ? com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()
          : relationDescriptor_;
    }

    /**
     *
     *
     * <pre>
     * Descriptor for any output relation and its columns. Only set if
     * `has_output` is true.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.RelationDescriptorOrBuilder
        getRelationDescriptorOrBuilder() {
      return relationDescriptor_ == null
          ? com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()
          : relationDescriptor_;
    }

    public static final int QUERIES_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList queries_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * A list of arbitrary SQL statements that will be executed without
     * alteration.
     * </pre>
     *
     * <code>repeated string queries = 4;</code>
     *
     * @return A list containing the queries.
     */
    public com.google.protobuf.ProtocolStringList getQueriesList() {
      return queries_;
    }

    /**
     *
     *
     * <pre>
     * A list of arbitrary SQL statements that will be executed without
     * alteration.
     * </pre>
     *
     * <code>repeated string queries = 4;</code>
     *
     * @return The count of queries.
     */
    public int getQueriesCount() {
      return queries_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of arbitrary SQL statements that will be executed without
     * alteration.
     * </pre>
     *
     * <code>repeated string queries = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The queries at the given index.
     */
    public java.lang.String getQueries(int index) {
      return queries_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of arbitrary SQL statements that will be executed without
     * alteration.
     * </pre>
     *
     * <code>repeated string queries = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the queries at the given index.
     */
    public com.google.protobuf.ByteString getQueriesBytes(int index) {
      return queries_.getByteString(index);
    }

    public static final int HAS_OUTPUT_FIELD_NUMBER = 5;
    private boolean hasOutput_ = false;

    /**
     *
     *
     * <pre>
     * Whether these operations produce an output relation.
     * </pre>
     *
     * <code>bool has_output = 5;</code>
     *
     * @return The hasOutput.
     */
    @java.lang.Override
    public boolean getHasOutput() {
      return hasOutput_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < dependencyTargets_.size(); i++) {
        output.writeMessage(1, dependencyTargets_.get(i));
      }
      if (disabled_ != false) {
        output.writeBool(2, disabled_);
      }
      for (int i = 0; i < tags_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, tags_.getRaw(i));
      }
      for (int i = 0; i < queries_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, queries_.getRaw(i));
      }
      if (hasOutput_ != false) {
        output.writeBool(5, hasOutput_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(6, getRelationDescriptor());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < dependencyTargets_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, dependencyTargets_.get(i));
      }
      if (disabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, disabled_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < tags_.size(); i++) {
          dataSize += computeStringSizeNoTag(tags_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getTagsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < queries_.size(); i++) {
          dataSize += computeStringSizeNoTag(queries_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getQueriesList().size();
      }
      if (hasOutput_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, hasOutput_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(6, getRelationDescriptor());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataform.v1.CompilationResultAction.Operations)) {
        return super.equals(obj);
      }
      com.google.cloud.dataform.v1.CompilationResultAction.Operations other =
          (com.google.cloud.dataform.v1.CompilationResultAction.Operations) obj;

      if (!getDependencyTargetsList().equals(other.getDependencyTargetsList())) return false;
      if (getDisabled() != other.getDisabled()) return false;
      if (!getTagsList().equals(other.getTagsList())) return false;
      if (hasRelationDescriptor() != other.hasRelationDescriptor()) return false;
      if (hasRelationDescriptor()) {
        if (!getRelationDescriptor().equals(other.getRelationDescriptor())) return false;
      }
      if (!getQueriesList().equals(other.getQueriesList())) return false;
      if (getHasOutput() != other.getHasOutput()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDependencyTargetsCount() > 0) {
        hash = (37 * hash) + DEPENDENCY_TARGETS_FIELD_NUMBER;
        hash = (53 * hash) + getDependencyTargetsList().hashCode();
      }
      hash = (37 * hash) + DISABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
      if (getTagsCount() > 0) {
        hash = (37 * hash) + TAGS_FIELD_NUMBER;
        hash = (53 * hash) + getTagsList().hashCode();
      }
      if (hasRelationDescriptor()) {
        hash = (37 * hash) + RELATION_DESCRIPTOR_FIELD_NUMBER;
        hash = (53 * hash) + getRelationDescriptor().hashCode();
      }
      if (getQueriesCount() > 0) {
        hash = (37 * hash) + QUERIES_FIELD_NUMBER;
        hash = (53 * hash) + getQueriesList().hashCode();
      }
      hash = (37 * hash) + HAS_OUTPUT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getHasOutput());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Operations parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Operations parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Operations parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Operations parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Operations parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Operations parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Operations parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Operations parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Operations
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Operations
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Operations parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Operations parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataform.v1.CompilationResultAction.Operations prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Represents a list of arbitrary database operations.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction.Operations}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.CompilationResultAction.Operations)
        com.google.cloud.dataform.v1.CompilationResultAction.OperationsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_Operations_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_Operations_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.CompilationResultAction.Operations.class,
                com.google.cloud.dataform.v1.CompilationResultAction.Operations.Builder.class);
      }

      // Construct using
      // com.google.cloud.dataform.v1.CompilationResultAction.Operations.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDependencyTargetsFieldBuilder();
          getRelationDescriptorFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (dependencyTargetsBuilder_ == null) {
          dependencyTargets_ = java.util.Collections.emptyList();
        } else {
          dependencyTargets_ = null;
          dependencyTargetsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        disabled_ = false;
        tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
        relationDescriptor_ = null;
        if (relationDescriptorBuilder_ != null) {
          relationDescriptorBuilder_.dispose();
          relationDescriptorBuilder_ = null;
        }
        queries_ = com.google.protobuf.LazyStringArrayList.emptyList();
        hasOutput_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_Operations_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.Operations
          getDefaultInstanceForType() {
        return com.google.cloud.dataform.v1.CompilationResultAction.Operations.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.Operations build() {
        com.google.cloud.dataform.v1.CompilationResultAction.Operations result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.Operations buildPartial() {
        com.google.cloud.dataform.v1.CompilationResultAction.Operations result =
            new com.google.cloud.dataform.v1.CompilationResultAction.Operations(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dataform.v1.CompilationResultAction.Operations result) {
        if (dependencyTargetsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            dependencyTargets_ = java.util.Collections.unmodifiableList(dependencyTargets_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.dependencyTargets_ = dependencyTargets_;
        } else {
          result.dependencyTargets_ = dependencyTargetsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.dataform.v1.CompilationResultAction.Operations result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.disabled_ = disabled_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          tags_.makeImmutable();
          result.tags_ = tags_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.relationDescriptor_ =
              relationDescriptorBuilder_ == null
                  ? relationDescriptor_
                  : relationDescriptorBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          queries_.makeImmutable();
          result.queries_ = queries_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.hasOutput_ = hasOutput_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataform.v1.CompilationResultAction.Operations) {
          return mergeFrom((com.google.cloud.dataform.v1.CompilationResultAction.Operations) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataform.v1.CompilationResultAction.Operations other) {
        if (other
            == com.google.cloud.dataform.v1.CompilationResultAction.Operations.getDefaultInstance())
          return this;
        if (dependencyTargetsBuilder_ == null) {
          if (!other.dependencyTargets_.isEmpty()) {
            if (dependencyTargets_.isEmpty()) {
              dependencyTargets_ = other.dependencyTargets_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureDependencyTargetsIsMutable();
              dependencyTargets_.addAll(other.dependencyTargets_);
            }
            onChanged();
          }
        } else {
          if (!other.dependencyTargets_.isEmpty()) {
            if (dependencyTargetsBuilder_.isEmpty()) {
              dependencyTargetsBuilder_.dispose();
              dependencyTargetsBuilder_ = null;
              dependencyTargets_ = other.dependencyTargets_;
              bitField0_ = (bitField0_ & ~0x00000001);
              dependencyTargetsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDependencyTargetsFieldBuilder()
                      : null;
            } else {
              dependencyTargetsBuilder_.addAllMessages(other.dependencyTargets_);
            }
          }
        }
        if (other.getDisabled() != false) {
          setDisabled(other.getDisabled());
        }
        if (!other.tags_.isEmpty()) {
          if (tags_.isEmpty()) {
            tags_ = other.tags_;
            bitField0_ |= 0x00000004;
          } else {
            ensureTagsIsMutable();
            tags_.addAll(other.tags_);
          }
          onChanged();
        }
        if (other.hasRelationDescriptor()) {
          mergeRelationDescriptor(other.getRelationDescriptor());
        }
        if (!other.queries_.isEmpty()) {
          if (queries_.isEmpty()) {
            queries_ = other.queries_;
            bitField0_ |= 0x00000010;
          } else {
            ensureQueriesIsMutable();
            queries_.addAll(other.queries_);
          }
          onChanged();
        }
        if (other.getHasOutput() != false) {
          setHasOutput(other.getHasOutput());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.dataform.v1.Target m =
                      input.readMessage(
                          com.google.cloud.dataform.v1.Target.parser(), extensionRegistry);
                  if (dependencyTargetsBuilder_ == null) {
                    ensureDependencyTargetsIsMutable();
                    dependencyTargets_.add(m);
                  } else {
                    dependencyTargetsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 16:
                {
                  disabled_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureTagsIsMutable();
                  tags_.add(s);
                  break;
                } // case 26
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureQueriesIsMutable();
                  queries_.add(s);
                  break;
                } // case 34
              case 40:
                {
                  hasOutput_ = input.readBool();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 40
              case 50:
                {
                  input.readMessage(
                      getRelationDescriptorFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.dataform.v1.Target> dependencyTargets_ =
          java.util.Collections.emptyList();

      private void ensureDependencyTargetsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          dependencyTargets_ =
              new java.util.ArrayList<com.google.cloud.dataform.v1.Target>(dependencyTargets_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dataform.v1.Target,
              com.google.cloud.dataform.v1.Target.Builder,
              com.google.cloud.dataform.v1.TargetOrBuilder>
          dependencyTargetsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public java.util.List<com.google.cloud.dataform.v1.Target> getDependencyTargetsList() {
        if (dependencyTargetsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(dependencyTargets_);
        } else {
          return dependencyTargetsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public int getDependencyTargetsCount() {
        if (dependencyTargetsBuilder_ == null) {
          return dependencyTargets_.size();
        } else {
          return dependencyTargetsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target getDependencyTargets(int index) {
        if (dependencyTargetsBuilder_ == null) {
          return dependencyTargets_.get(index);
        } else {
          return dependencyTargetsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder setDependencyTargets(int index, com.google.cloud.dataform.v1.Target value) {
        if (dependencyTargetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.set(index, value);
          onChanged();
        } else {
          dependencyTargetsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder setDependencyTargets(
          int index, com.google.cloud.dataform.v1.Target.Builder builderForValue) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.set(index, builderForValue.build());
          onChanged();
        } else {
          dependencyTargetsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(com.google.cloud.dataform.v1.Target value) {
        if (dependencyTargetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(value);
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(int index, com.google.cloud.dataform.v1.Target value) {
        if (dependencyTargetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(index, value);
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(
          com.google.cloud.dataform.v1.Target.Builder builderForValue) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(builderForValue.build());
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(
          int index, com.google.cloud.dataform.v1.Target.Builder builderForValue) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(index, builderForValue.build());
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addAllDependencyTargets(
          java.lang.Iterable<? extends com.google.cloud.dataform.v1.Target> values) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dependencyTargets_);
          onChanged();
        } else {
          dependencyTargetsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder clearDependencyTargets() {
        if (dependencyTargetsBuilder_ == null) {
          dependencyTargets_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          dependencyTargetsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder removeDependencyTargets(int index) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.remove(index);
          onChanged();
        } else {
          dependencyTargetsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target.Builder getDependencyTargetsBuilder(int index) {
        return getDependencyTargetsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.TargetOrBuilder getDependencyTargetsOrBuilder(int index) {
        if (dependencyTargetsBuilder_ == null) {
          return dependencyTargets_.get(index);
        } else {
          return dependencyTargetsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public java.util.List<? extends com.google.cloud.dataform.v1.TargetOrBuilder>
          getDependencyTargetsOrBuilderList() {
        if (dependencyTargetsBuilder_ != null) {
          return dependencyTargetsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(dependencyTargets_);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target.Builder addDependencyTargetsBuilder() {
        return getDependencyTargetsFieldBuilder()
            .addBuilder(com.google.cloud.dataform.v1.Target.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target.Builder addDependencyTargetsBuilder(int index) {
        return getDependencyTargetsFieldBuilder()
            .addBuilder(index, com.google.cloud.dataform.v1.Target.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public java.util.List<com.google.cloud.dataform.v1.Target.Builder>
          getDependencyTargetsBuilderList() {
        return getDependencyTargetsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dataform.v1.Target,
              com.google.cloud.dataform.v1.Target.Builder,
              com.google.cloud.dataform.v1.TargetOrBuilder>
          getDependencyTargetsFieldBuilder() {
        if (dependencyTargetsBuilder_ == null) {
          dependencyTargetsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dataform.v1.Target,
                  com.google.cloud.dataform.v1.Target.Builder,
                  com.google.cloud.dataform.v1.TargetOrBuilder>(
                  dependencyTargets_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          dependencyTargets_ = null;
        }
        return dependencyTargetsBuilder_;
      }

      private boolean disabled_;

      /**
       *
       *
       * <pre>
       * Whether this action is disabled (i.e. should not be run).
       * </pre>
       *
       * <code>bool disabled = 2;</code>
       *
       * @return The disabled.
       */
      @java.lang.Override
      public boolean getDisabled() {
        return disabled_;
      }

      /**
       *
       *
       * <pre>
       * Whether this action is disabled (i.e. should not be run).
       * </pre>
       *
       * <code>bool disabled = 2;</code>
       *
       * @param value The disabled to set.
       * @return This builder for chaining.
       */
      public Builder setDisabled(boolean value) {

        disabled_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Whether this action is disabled (i.e. should not be run).
       * </pre>
       *
       * <code>bool disabled = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisabled() {
        bitField0_ = (bitField0_ & ~0x00000002);
        disabled_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList tags_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureTagsIsMutable() {
        if (!tags_.isModifiable()) {
          tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
        }
        bitField0_ |= 0x00000004;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @return A list containing the tags.
       */
      public com.google.protobuf.ProtocolStringList getTagsList() {
        tags_.makeImmutable();
        return tags_;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @return The count of tags.
       */
      public int getTagsCount() {
        return tags_.size();
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The tags at the given index.
       */
      public java.lang.String getTags(int index) {
        return tags_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the tags at the given index.
       */
      public com.google.protobuf.ByteString getTagsBytes(int index) {
        return tags_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The tags to set.
       * @return This builder for chaining.
       */
      public Builder setTags(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @param value The tags to add.
       * @return This builder for chaining.
       */
      public Builder addTags(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @param values The tags to add.
       * @return This builder for chaining.
       */
      public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
        ensureTagsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTags() {
        tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @param value The bytes of the tags to add.
       * @return This builder for chaining.
       */
      public Builder addTagsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureTagsIsMutable();
        tags_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.cloud.dataform.v1.RelationDescriptor relationDescriptor_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.RelationDescriptor,
              com.google.cloud.dataform.v1.RelationDescriptor.Builder,
              com.google.cloud.dataform.v1.RelationDescriptorOrBuilder>
          relationDescriptorBuilder_;

      /**
       *
       *
       * <pre>
       * Descriptor for any output relation and its columns. Only set if
       * `has_output` is true.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
       *
       * @return Whether the relationDescriptor field is set.
       */
      public boolean hasRelationDescriptor() {
        return ((bitField0_ & 0x00000008) != 0);
      }

      /**
       *
       *
       * <pre>
       * Descriptor for any output relation and its columns. Only set if
       * `has_output` is true.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
       *
       * @return The relationDescriptor.
       */
      public com.google.cloud.dataform.v1.RelationDescriptor getRelationDescriptor() {
        if (relationDescriptorBuilder_ == null) {
          return relationDescriptor_ == null
              ? com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()
              : relationDescriptor_;
        } else {
          return relationDescriptorBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Descriptor for any output relation and its columns. Only set if
       * `has_output` is true.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
       */
      public Builder setRelationDescriptor(com.google.cloud.dataform.v1.RelationDescriptor value) {
        if (relationDescriptorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          relationDescriptor_ = value;
        } else {
          relationDescriptorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Descriptor for any output relation and its columns. Only set if
       * `has_output` is true.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
       */
      public Builder setRelationDescriptor(
          com.google.cloud.dataform.v1.RelationDescriptor.Builder builderForValue) {
        if (relationDescriptorBuilder_ == null) {
          relationDescriptor_ = builderForValue.build();
        } else {
          relationDescriptorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Descriptor for any output relation and its columns. Only set if
       * `has_output` is true.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
       */
      public Builder mergeRelationDescriptor(
          com.google.cloud.dataform.v1.RelationDescriptor value) {
        if (relationDescriptorBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && relationDescriptor_ != null
              && relationDescriptor_
                  != com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()) {
            getRelationDescriptorBuilder().mergeFrom(value);
          } else {
            relationDescriptor_ = value;
          }
        } else {
          relationDescriptorBuilder_.mergeFrom(value);
        }
        if (relationDescriptor_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Descriptor for any output relation and its columns. Only set if
       * `has_output` is true.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
       */
      public Builder clearRelationDescriptor() {
        bitField0_ = (bitField0_ & ~0x00000008);
        relationDescriptor_ = null;
        if (relationDescriptorBuilder_ != null) {
          relationDescriptorBuilder_.dispose();
          relationDescriptorBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Descriptor for any output relation and its columns. Only set if
       * `has_output` is true.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
       */
      public com.google.cloud.dataform.v1.RelationDescriptor.Builder
          getRelationDescriptorBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getRelationDescriptorFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Descriptor for any output relation and its columns. Only set if
       * `has_output` is true.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
       */
      public com.google.cloud.dataform.v1.RelationDescriptorOrBuilder
          getRelationDescriptorOrBuilder() {
        if (relationDescriptorBuilder_ != null) {
          return relationDescriptorBuilder_.getMessageOrBuilder();
        } else {
          return relationDescriptor_ == null
              ? com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()
              : relationDescriptor_;
        }
      }

      /**
       *
       *
       * <pre>
       * Descriptor for any output relation and its columns. Only set if
       * `has_output` is true.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.RelationDescriptor,
              com.google.cloud.dataform.v1.RelationDescriptor.Builder,
              com.google.cloud.dataform.v1.RelationDescriptorOrBuilder>
          getRelationDescriptorFieldBuilder() {
        if (relationDescriptorBuilder_ == null) {
          relationDescriptorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dataform.v1.RelationDescriptor,
                  com.google.cloud.dataform.v1.RelationDescriptor.Builder,
                  com.google.cloud.dataform.v1.RelationDescriptorOrBuilder>(
                  getRelationDescriptor(), getParentForChildren(), isClean());
          relationDescriptor_ = null;
        }
        return relationDescriptorBuilder_;
      }

      private com.google.protobuf.LazyStringArrayList queries_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureQueriesIsMutable() {
        if (!queries_.isModifiable()) {
          queries_ = new com.google.protobuf.LazyStringArrayList(queries_);
        }
        bitField0_ |= 0x00000010;
      }

      /**
       *
       *
       * <pre>
       * A list of arbitrary SQL statements that will be executed without
       * alteration.
       * </pre>
       *
       * <code>repeated string queries = 4;</code>
       *
       * @return A list containing the queries.
       */
      public com.google.protobuf.ProtocolStringList getQueriesList() {
        queries_.makeImmutable();
        return queries_;
      }

      /**
       *
       *
       * <pre>
       * A list of arbitrary SQL statements that will be executed without
       * alteration.
       * </pre>
       *
       * <code>repeated string queries = 4;</code>
       *
       * @return The count of queries.
       */
      public int getQueriesCount() {
        return queries_.size();
      }

      /**
       *
       *
       * <pre>
       * A list of arbitrary SQL statements that will be executed without
       * alteration.
       * </pre>
       *
       * <code>repeated string queries = 4;</code>
       *
       * @param index The index of the element to return.
       * @return The queries at the given index.
       */
      public java.lang.String getQueries(int index) {
        return queries_.get(index);
      }

      /**
       *
       *
       * <pre>
       * A list of arbitrary SQL statements that will be executed without
       * alteration.
       * </pre>
       *
       * <code>repeated string queries = 4;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the queries at the given index.
       */
      public com.google.protobuf.ByteString getQueriesBytes(int index) {
        return queries_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * A list of arbitrary SQL statements that will be executed without
       * alteration.
       * </pre>
       *
       * <code>repeated string queries = 4;</code>
       *
       * @param index The index to set the value at.
       * @param value The queries to set.
       * @return This builder for chaining.
       */
      public Builder setQueries(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQueriesIsMutable();
        queries_.set(index, value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of arbitrary SQL statements that will be executed without
       * alteration.
       * </pre>
       *
       * <code>repeated string queries = 4;</code>
       *
       * @param value The queries to add.
       * @return This builder for chaining.
       */
      public Builder addQueries(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQueriesIsMutable();
        queries_.add(value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of arbitrary SQL statements that will be executed without
       * alteration.
       * </pre>
       *
       * <code>repeated string queries = 4;</code>
       *
       * @param values The queries to add.
       * @return This builder for chaining.
       */
      public Builder addAllQueries(java.lang.Iterable<java.lang.String> values) {
        ensureQueriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, queries_);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of arbitrary SQL statements that will be executed without
       * alteration.
       * </pre>
       *
       * <code>repeated string queries = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQueries() {
        queries_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of arbitrary SQL statements that will be executed without
       * alteration.
       * </pre>
       *
       * <code>repeated string queries = 4;</code>
       *
       * @param value The bytes of the queries to add.
       * @return This builder for chaining.
       */
      public Builder addQueriesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureQueriesIsMutable();
        queries_.add(value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private boolean hasOutput_;

      /**
       *
       *
       * <pre>
       * Whether these operations produce an output relation.
       * </pre>
       *
       * <code>bool has_output = 5;</code>
       *
       * @return The hasOutput.
       */
      @java.lang.Override
      public boolean getHasOutput() {
        return hasOutput_;
      }

      /**
       *
       *
       * <pre>
       * Whether these operations produce an output relation.
       * </pre>
       *
       * <code>bool has_output = 5;</code>
       *
       * @param value The hasOutput to set.
       * @return This builder for chaining.
       */
      public Builder setHasOutput(boolean value) {

        hasOutput_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Whether these operations produce an output relation.
       * </pre>
       *
       * <code>bool has_output = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHasOutput() {
        bitField0_ = (bitField0_ & ~0x00000020);
        hasOutput_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.CompilationResultAction.Operations)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.CompilationResultAction.Operations)
    private static final com.google.cloud.dataform.v1.CompilationResultAction.Operations
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.CompilationResultAction.Operations();
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Operations
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Operations> PARSER =
        new com.google.protobuf.AbstractParser<Operations>() {
          @java.lang.Override
          public Operations parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Operations> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Operations> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.Operations
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AssertionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.CompilationResultAction.Assertion)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    java.util.List<com.google.cloud.dataform.v1.Target> getDependencyTargetsList();

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    com.google.cloud.dataform.v1.Target getDependencyTargets(int index);

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    int getDependencyTargetsCount();

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    java.util.List<? extends com.google.cloud.dataform.v1.TargetOrBuilder>
        getDependencyTargetsOrBuilderList();

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    com.google.cloud.dataform.v1.TargetOrBuilder getDependencyTargetsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * The parent action of this assertion. Only set if this assertion was
     * automatically generated.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target parent_action = 5;</code>
     *
     * @return Whether the parentAction field is set.
     */
    boolean hasParentAction();

    /**
     *
     *
     * <pre>
     * The parent action of this assertion. Only set if this assertion was
     * automatically generated.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target parent_action = 5;</code>
     *
     * @return The parentAction.
     */
    com.google.cloud.dataform.v1.Target getParentAction();

    /**
     *
     *
     * <pre>
     * The parent action of this assertion. Only set if this assertion was
     * automatically generated.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target parent_action = 5;</code>
     */
    com.google.cloud.dataform.v1.TargetOrBuilder getParentActionOrBuilder();

    /**
     *
     *
     * <pre>
     * Whether this action is disabled (i.e. should not be run).
     * </pre>
     *
     * <code>bool disabled = 2;</code>
     *
     * @return The disabled.
     */
    boolean getDisabled();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @return A list containing the tags.
     */
    java.util.List<java.lang.String> getTagsList();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @return The count of tags.
     */
    int getTagsCount();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    java.lang.String getTags(int index);

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    com.google.protobuf.ByteString getTagsBytes(int index);

    /**
     *
     *
     * <pre>
     * The SELECT query which must return zero rows in order for this assertion
     * to succeed.
     * </pre>
     *
     * <code>string select_query = 4;</code>
     *
     * @return The selectQuery.
     */
    java.lang.String getSelectQuery();

    /**
     *
     *
     * <pre>
     * The SELECT query which must return zero rows in order for this assertion
     * to succeed.
     * </pre>
     *
     * <code>string select_query = 4;</code>
     *
     * @return The bytes for selectQuery.
     */
    com.google.protobuf.ByteString getSelectQueryBytes();

    /**
     *
     *
     * <pre>
     * Descriptor for the assertion's automatically-generated view and its
     * columns.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
     *
     * @return Whether the relationDescriptor field is set.
     */
    boolean hasRelationDescriptor();

    /**
     *
     *
     * <pre>
     * Descriptor for the assertion's automatically-generated view and its
     * columns.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
     *
     * @return The relationDescriptor.
     */
    com.google.cloud.dataform.v1.RelationDescriptor getRelationDescriptor();

    /**
     *
     *
     * <pre>
     * Descriptor for the assertion's automatically-generated view and its
     * columns.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
     */
    com.google.cloud.dataform.v1.RelationDescriptorOrBuilder getRelationDescriptorOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Represents an assertion upon a SQL query which is required return zero
   * rows.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction.Assertion}
   */
  public static final class Assertion extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.CompilationResultAction.Assertion)
      AssertionOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Assertion.newBuilder() to construct.
    private Assertion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Assertion() {
      dependencyTargets_ = java.util.Collections.emptyList();
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      selectQuery_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Assertion();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_Assertion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_Assertion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.CompilationResultAction.Assertion.class,
              com.google.cloud.dataform.v1.CompilationResultAction.Assertion.Builder.class);
    }

    private int bitField0_;
    public static final int DEPENDENCY_TARGETS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.dataform.v1.Target> dependencyTargets_;

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dataform.v1.Target> getDependencyTargetsList() {
      return dependencyTargets_;
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.dataform.v1.TargetOrBuilder>
        getDependencyTargetsOrBuilderList() {
      return dependencyTargets_;
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public int getDependencyTargetsCount() {
      return dependencyTargets_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.Target getDependencyTargets(int index) {
      return dependencyTargets_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.TargetOrBuilder getDependencyTargetsOrBuilder(int index) {
      return dependencyTargets_.get(index);
    }

    public static final int PARENT_ACTION_FIELD_NUMBER = 5;
    private com.google.cloud.dataform.v1.Target parentAction_;

    /**
     *
     *
     * <pre>
     * The parent action of this assertion. Only set if this assertion was
     * automatically generated.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target parent_action = 5;</code>
     *
     * @return Whether the parentAction field is set.
     */
    @java.lang.Override
    public boolean hasParentAction() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The parent action of this assertion. Only set if this assertion was
     * automatically generated.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target parent_action = 5;</code>
     *
     * @return The parentAction.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.Target getParentAction() {
      return parentAction_ == null
          ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
          : parentAction_;
    }

    /**
     *
     *
     * <pre>
     * The parent action of this assertion. Only set if this assertion was
     * automatically generated.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target parent_action = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.TargetOrBuilder getParentActionOrBuilder() {
      return parentAction_ == null
          ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
          : parentAction_;
    }

    public static final int DISABLED_FIELD_NUMBER = 2;
    private boolean disabled_ = false;

    /**
     *
     *
     * <pre>
     * Whether this action is disabled (i.e. should not be run).
     * </pre>
     *
     * <code>bool disabled = 2;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }

    public static final int TAGS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList tags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      return tags_;
    }

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }

    public static final int SELECT_QUERY_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object selectQuery_ = "";

    /**
     *
     *
     * <pre>
     * The SELECT query which must return zero rows in order for this assertion
     * to succeed.
     * </pre>
     *
     * <code>string select_query = 4;</code>
     *
     * @return The selectQuery.
     */
    @java.lang.Override
    public java.lang.String getSelectQuery() {
      java.lang.Object ref = selectQuery_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selectQuery_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The SELECT query which must return zero rows in order for this assertion
     * to succeed.
     * </pre>
     *
     * <code>string select_query = 4;</code>
     *
     * @return The bytes for selectQuery.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSelectQueryBytes() {
      java.lang.Object ref = selectQuery_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selectQuery_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RELATION_DESCRIPTOR_FIELD_NUMBER = 6;
    private com.google.cloud.dataform.v1.RelationDescriptor relationDescriptor_;

    /**
     *
     *
     * <pre>
     * Descriptor for the assertion's automatically-generated view and its
     * columns.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
     *
     * @return Whether the relationDescriptor field is set.
     */
    @java.lang.Override
    public boolean hasRelationDescriptor() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Descriptor for the assertion's automatically-generated view and its
     * columns.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
     *
     * @return The relationDescriptor.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.RelationDescriptor getRelationDescriptor() {
      return relationDescriptor_ == null
          ? com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()
          : relationDescriptor_;
    }

    /**
     *
     *
     * <pre>
     * Descriptor for the assertion's automatically-generated view and its
     * columns.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.RelationDescriptorOrBuilder
        getRelationDescriptorOrBuilder() {
      return relationDescriptor_ == null
          ? com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()
          : relationDescriptor_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < dependencyTargets_.size(); i++) {
        output.writeMessage(1, dependencyTargets_.get(i));
      }
      if (disabled_ != false) {
        output.writeBool(2, disabled_);
      }
      for (int i = 0; i < tags_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, tags_.getRaw(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(selectQuery_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, selectQuery_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(5, getParentAction());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(6, getRelationDescriptor());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < dependencyTargets_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, dependencyTargets_.get(i));
      }
      if (disabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, disabled_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < tags_.size(); i++) {
          dataSize += computeStringSizeNoTag(tags_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getTagsList().size();
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(selectQuery_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, selectQuery_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getParentAction());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(6, getRelationDescriptor());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataform.v1.CompilationResultAction.Assertion)) {
        return super.equals(obj);
      }
      com.google.cloud.dataform.v1.CompilationResultAction.Assertion other =
          (com.google.cloud.dataform.v1.CompilationResultAction.Assertion) obj;

      if (!getDependencyTargetsList().equals(other.getDependencyTargetsList())) return false;
      if (hasParentAction() != other.hasParentAction()) return false;
      if (hasParentAction()) {
        if (!getParentAction().equals(other.getParentAction())) return false;
      }
      if (getDisabled() != other.getDisabled()) return false;
      if (!getTagsList().equals(other.getTagsList())) return false;
      if (!getSelectQuery().equals(other.getSelectQuery())) return false;
      if (hasRelationDescriptor() != other.hasRelationDescriptor()) return false;
      if (hasRelationDescriptor()) {
        if (!getRelationDescriptor().equals(other.getRelationDescriptor())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDependencyTargetsCount() > 0) {
        hash = (37 * hash) + DEPENDENCY_TARGETS_FIELD_NUMBER;
        hash = (53 * hash) + getDependencyTargetsList().hashCode();
      }
      if (hasParentAction()) {
        hash = (37 * hash) + PARENT_ACTION_FIELD_NUMBER;
        hash = (53 * hash) + getParentAction().hashCode();
      }
      hash = (37 * hash) + DISABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
      if (getTagsCount() > 0) {
        hash = (37 * hash) + TAGS_FIELD_NUMBER;
        hash = (53 * hash) + getTagsList().hashCode();
      }
      hash = (37 * hash) + SELECT_QUERY_FIELD_NUMBER;
      hash = (53 * hash) + getSelectQuery().hashCode();
      if (hasRelationDescriptor()) {
        hash = (37 * hash) + RELATION_DESCRIPTOR_FIELD_NUMBER;
        hash = (53 * hash) + getRelationDescriptor().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Assertion parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Assertion parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Assertion parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Assertion parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Assertion parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Assertion parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Assertion parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Assertion parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Assertion parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Assertion parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Assertion parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Assertion parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataform.v1.CompilationResultAction.Assertion prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Represents an assertion upon a SQL query which is required return zero
     * rows.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction.Assertion}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.CompilationResultAction.Assertion)
        com.google.cloud.dataform.v1.CompilationResultAction.AssertionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_Assertion_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_Assertion_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.CompilationResultAction.Assertion.class,
                com.google.cloud.dataform.v1.CompilationResultAction.Assertion.Builder.class);
      }

      // Construct using com.google.cloud.dataform.v1.CompilationResultAction.Assertion.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDependencyTargetsFieldBuilder();
          getParentActionFieldBuilder();
          getRelationDescriptorFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (dependencyTargetsBuilder_ == null) {
          dependencyTargets_ = java.util.Collections.emptyList();
        } else {
          dependencyTargets_ = null;
          dependencyTargetsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        parentAction_ = null;
        if (parentActionBuilder_ != null) {
          parentActionBuilder_.dispose();
          parentActionBuilder_ = null;
        }
        disabled_ = false;
        tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
        selectQuery_ = "";
        relationDescriptor_ = null;
        if (relationDescriptorBuilder_ != null) {
          relationDescriptorBuilder_.dispose();
          relationDescriptorBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_Assertion_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.Assertion
          getDefaultInstanceForType() {
        return com.google.cloud.dataform.v1.CompilationResultAction.Assertion.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.Assertion build() {
        com.google.cloud.dataform.v1.CompilationResultAction.Assertion result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.Assertion buildPartial() {
        com.google.cloud.dataform.v1.CompilationResultAction.Assertion result =
            new com.google.cloud.dataform.v1.CompilationResultAction.Assertion(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dataform.v1.CompilationResultAction.Assertion result) {
        if (dependencyTargetsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            dependencyTargets_ = java.util.Collections.unmodifiableList(dependencyTargets_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.dependencyTargets_ = dependencyTargets_;
        } else {
          result.dependencyTargets_ = dependencyTargetsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.dataform.v1.CompilationResultAction.Assertion result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.parentAction_ =
              parentActionBuilder_ == null ? parentAction_ : parentActionBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.disabled_ = disabled_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          tags_.makeImmutable();
          result.tags_ = tags_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.selectQuery_ = selectQuery_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.relationDescriptor_ =
              relationDescriptorBuilder_ == null
                  ? relationDescriptor_
                  : relationDescriptorBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataform.v1.CompilationResultAction.Assertion) {
          return mergeFrom((com.google.cloud.dataform.v1.CompilationResultAction.Assertion) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataform.v1.CompilationResultAction.Assertion other) {
        if (other
            == com.google.cloud.dataform.v1.CompilationResultAction.Assertion.getDefaultInstance())
          return this;
        if (dependencyTargetsBuilder_ == null) {
          if (!other.dependencyTargets_.isEmpty()) {
            if (dependencyTargets_.isEmpty()) {
              dependencyTargets_ = other.dependencyTargets_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureDependencyTargetsIsMutable();
              dependencyTargets_.addAll(other.dependencyTargets_);
            }
            onChanged();
          }
        } else {
          if (!other.dependencyTargets_.isEmpty()) {
            if (dependencyTargetsBuilder_.isEmpty()) {
              dependencyTargetsBuilder_.dispose();
              dependencyTargetsBuilder_ = null;
              dependencyTargets_ = other.dependencyTargets_;
              bitField0_ = (bitField0_ & ~0x00000001);
              dependencyTargetsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDependencyTargetsFieldBuilder()
                      : null;
            } else {
              dependencyTargetsBuilder_.addAllMessages(other.dependencyTargets_);
            }
          }
        }
        if (other.hasParentAction()) {
          mergeParentAction(other.getParentAction());
        }
        if (other.getDisabled() != false) {
          setDisabled(other.getDisabled());
        }
        if (!other.tags_.isEmpty()) {
          if (tags_.isEmpty()) {
            tags_ = other.tags_;
            bitField0_ |= 0x00000008;
          } else {
            ensureTagsIsMutable();
            tags_.addAll(other.tags_);
          }
          onChanged();
        }
        if (!other.getSelectQuery().isEmpty()) {
          selectQuery_ = other.selectQuery_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (other.hasRelationDescriptor()) {
          mergeRelationDescriptor(other.getRelationDescriptor());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.dataform.v1.Target m =
                      input.readMessage(
                          com.google.cloud.dataform.v1.Target.parser(), extensionRegistry);
                  if (dependencyTargetsBuilder_ == null) {
                    ensureDependencyTargetsIsMutable();
                    dependencyTargets_.add(m);
                  } else {
                    dependencyTargetsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 16:
                {
                  disabled_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 16
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureTagsIsMutable();
                  tags_.add(s);
                  break;
                } // case 26
              case 34:
                {
                  selectQuery_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(getParentActionFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(
                      getRelationDescriptorFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.dataform.v1.Target> dependencyTargets_ =
          java.util.Collections.emptyList();

      private void ensureDependencyTargetsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          dependencyTargets_ =
              new java.util.ArrayList<com.google.cloud.dataform.v1.Target>(dependencyTargets_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dataform.v1.Target,
              com.google.cloud.dataform.v1.Target.Builder,
              com.google.cloud.dataform.v1.TargetOrBuilder>
          dependencyTargetsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public java.util.List<com.google.cloud.dataform.v1.Target> getDependencyTargetsList() {
        if (dependencyTargetsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(dependencyTargets_);
        } else {
          return dependencyTargetsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public int getDependencyTargetsCount() {
        if (dependencyTargetsBuilder_ == null) {
          return dependencyTargets_.size();
        } else {
          return dependencyTargetsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target getDependencyTargets(int index) {
        if (dependencyTargetsBuilder_ == null) {
          return dependencyTargets_.get(index);
        } else {
          return dependencyTargetsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder setDependencyTargets(int index, com.google.cloud.dataform.v1.Target value) {
        if (dependencyTargetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.set(index, value);
          onChanged();
        } else {
          dependencyTargetsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder setDependencyTargets(
          int index, com.google.cloud.dataform.v1.Target.Builder builderForValue) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.set(index, builderForValue.build());
          onChanged();
        } else {
          dependencyTargetsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(com.google.cloud.dataform.v1.Target value) {
        if (dependencyTargetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(value);
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(int index, com.google.cloud.dataform.v1.Target value) {
        if (dependencyTargetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(index, value);
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(
          com.google.cloud.dataform.v1.Target.Builder builderForValue) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(builderForValue.build());
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(
          int index, com.google.cloud.dataform.v1.Target.Builder builderForValue) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(index, builderForValue.build());
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addAllDependencyTargets(
          java.lang.Iterable<? extends com.google.cloud.dataform.v1.Target> values) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dependencyTargets_);
          onChanged();
        } else {
          dependencyTargetsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder clearDependencyTargets() {
        if (dependencyTargetsBuilder_ == null) {
          dependencyTargets_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          dependencyTargetsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder removeDependencyTargets(int index) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.remove(index);
          onChanged();
        } else {
          dependencyTargetsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target.Builder getDependencyTargetsBuilder(int index) {
        return getDependencyTargetsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.TargetOrBuilder getDependencyTargetsOrBuilder(int index) {
        if (dependencyTargetsBuilder_ == null) {
          return dependencyTargets_.get(index);
        } else {
          return dependencyTargetsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public java.util.List<? extends com.google.cloud.dataform.v1.TargetOrBuilder>
          getDependencyTargetsOrBuilderList() {
        if (dependencyTargetsBuilder_ != null) {
          return dependencyTargetsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(dependencyTargets_);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target.Builder addDependencyTargetsBuilder() {
        return getDependencyTargetsFieldBuilder()
            .addBuilder(com.google.cloud.dataform.v1.Target.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target.Builder addDependencyTargetsBuilder(int index) {
        return getDependencyTargetsFieldBuilder()
            .addBuilder(index, com.google.cloud.dataform.v1.Target.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public java.util.List<com.google.cloud.dataform.v1.Target.Builder>
          getDependencyTargetsBuilderList() {
        return getDependencyTargetsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dataform.v1.Target,
              com.google.cloud.dataform.v1.Target.Builder,
              com.google.cloud.dataform.v1.TargetOrBuilder>
          getDependencyTargetsFieldBuilder() {
        if (dependencyTargetsBuilder_ == null) {
          dependencyTargetsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dataform.v1.Target,
                  com.google.cloud.dataform.v1.Target.Builder,
                  com.google.cloud.dataform.v1.TargetOrBuilder>(
                  dependencyTargets_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          dependencyTargets_ = null;
        }
        return dependencyTargetsBuilder_;
      }

      private com.google.cloud.dataform.v1.Target parentAction_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.Target,
              com.google.cloud.dataform.v1.Target.Builder,
              com.google.cloud.dataform.v1.TargetOrBuilder>
          parentActionBuilder_;

      /**
       *
       *
       * <pre>
       * The parent action of this assertion. Only set if this assertion was
       * automatically generated.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target parent_action = 5;</code>
       *
       * @return Whether the parentAction field is set.
       */
      public boolean hasParentAction() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * The parent action of this assertion. Only set if this assertion was
       * automatically generated.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target parent_action = 5;</code>
       *
       * @return The parentAction.
       */
      public com.google.cloud.dataform.v1.Target getParentAction() {
        if (parentActionBuilder_ == null) {
          return parentAction_ == null
              ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
              : parentAction_;
        } else {
          return parentActionBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The parent action of this assertion. Only set if this assertion was
       * automatically generated.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target parent_action = 5;</code>
       */
      public Builder setParentAction(com.google.cloud.dataform.v1.Target value) {
        if (parentActionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          parentAction_ = value;
        } else {
          parentActionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The parent action of this assertion. Only set if this assertion was
       * automatically generated.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target parent_action = 5;</code>
       */
      public Builder setParentAction(com.google.cloud.dataform.v1.Target.Builder builderForValue) {
        if (parentActionBuilder_ == null) {
          parentAction_ = builderForValue.build();
        } else {
          parentActionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The parent action of this assertion. Only set if this assertion was
       * automatically generated.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target parent_action = 5;</code>
       */
      public Builder mergeParentAction(com.google.cloud.dataform.v1.Target value) {
        if (parentActionBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && parentAction_ != null
              && parentAction_ != com.google.cloud.dataform.v1.Target.getDefaultInstance()) {
            getParentActionBuilder().mergeFrom(value);
          } else {
            parentAction_ = value;
          }
        } else {
          parentActionBuilder_.mergeFrom(value);
        }
        if (parentAction_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The parent action of this assertion. Only set if this assertion was
       * automatically generated.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target parent_action = 5;</code>
       */
      public Builder clearParentAction() {
        bitField0_ = (bitField0_ & ~0x00000002);
        parentAction_ = null;
        if (parentActionBuilder_ != null) {
          parentActionBuilder_.dispose();
          parentActionBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The parent action of this assertion. Only set if this assertion was
       * automatically generated.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target parent_action = 5;</code>
       */
      public com.google.cloud.dataform.v1.Target.Builder getParentActionBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getParentActionFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The parent action of this assertion. Only set if this assertion was
       * automatically generated.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target parent_action = 5;</code>
       */
      public com.google.cloud.dataform.v1.TargetOrBuilder getParentActionOrBuilder() {
        if (parentActionBuilder_ != null) {
          return parentActionBuilder_.getMessageOrBuilder();
        } else {
          return parentAction_ == null
              ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
              : parentAction_;
        }
      }

      /**
       *
       *
       * <pre>
       * The parent action of this assertion. Only set if this assertion was
       * automatically generated.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target parent_action = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.Target,
              com.google.cloud.dataform.v1.Target.Builder,
              com.google.cloud.dataform.v1.TargetOrBuilder>
          getParentActionFieldBuilder() {
        if (parentActionBuilder_ == null) {
          parentActionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dataform.v1.Target,
                  com.google.cloud.dataform.v1.Target.Builder,
                  com.google.cloud.dataform.v1.TargetOrBuilder>(
                  getParentAction(), getParentForChildren(), isClean());
          parentAction_ = null;
        }
        return parentActionBuilder_;
      }

      private boolean disabled_;

      /**
       *
       *
       * <pre>
       * Whether this action is disabled (i.e. should not be run).
       * </pre>
       *
       * <code>bool disabled = 2;</code>
       *
       * @return The disabled.
       */
      @java.lang.Override
      public boolean getDisabled() {
        return disabled_;
      }

      /**
       *
       *
       * <pre>
       * Whether this action is disabled (i.e. should not be run).
       * </pre>
       *
       * <code>bool disabled = 2;</code>
       *
       * @param value The disabled to set.
       * @return This builder for chaining.
       */
      public Builder setDisabled(boolean value) {

        disabled_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Whether this action is disabled (i.e. should not be run).
       * </pre>
       *
       * <code>bool disabled = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisabled() {
        bitField0_ = (bitField0_ & ~0x00000004);
        disabled_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList tags_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureTagsIsMutable() {
        if (!tags_.isModifiable()) {
          tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
        }
        bitField0_ |= 0x00000008;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @return A list containing the tags.
       */
      public com.google.protobuf.ProtocolStringList getTagsList() {
        tags_.makeImmutable();
        return tags_;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @return The count of tags.
       */
      public int getTagsCount() {
        return tags_.size();
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The tags at the given index.
       */
      public java.lang.String getTags(int index) {
        return tags_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the tags at the given index.
       */
      public com.google.protobuf.ByteString getTagsBytes(int index) {
        return tags_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The tags to set.
       * @return This builder for chaining.
       */
      public Builder setTags(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.set(index, value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @param value The tags to add.
       * @return This builder for chaining.
       */
      public Builder addTags(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @param values The tags to add.
       * @return This builder for chaining.
       */
      public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
        ensureTagsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTags() {
        tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 3;</code>
       *
       * @param value The bytes of the tags to add.
       * @return This builder for chaining.
       */
      public Builder addTagsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureTagsIsMutable();
        tags_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object selectQuery_ = "";

      /**
       *
       *
       * <pre>
       * The SELECT query which must return zero rows in order for this assertion
       * to succeed.
       * </pre>
       *
       * <code>string select_query = 4;</code>
       *
       * @return The selectQuery.
       */
      public java.lang.String getSelectQuery() {
        java.lang.Object ref = selectQuery_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          selectQuery_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The SELECT query which must return zero rows in order for this assertion
       * to succeed.
       * </pre>
       *
       * <code>string select_query = 4;</code>
       *
       * @return The bytes for selectQuery.
       */
      public com.google.protobuf.ByteString getSelectQueryBytes() {
        java.lang.Object ref = selectQuery_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          selectQuery_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The SELECT query which must return zero rows in order for this assertion
       * to succeed.
       * </pre>
       *
       * <code>string select_query = 4;</code>
       *
       * @param value The selectQuery to set.
       * @return This builder for chaining.
       */
      public Builder setSelectQuery(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        selectQuery_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The SELECT query which must return zero rows in order for this assertion
       * to succeed.
       * </pre>
       *
       * <code>string select_query = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSelectQuery() {
        selectQuery_ = getDefaultInstance().getSelectQuery();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The SELECT query which must return zero rows in order for this assertion
       * to succeed.
       * </pre>
       *
       * <code>string select_query = 4;</code>
       *
       * @param value The bytes for selectQuery to set.
       * @return This builder for chaining.
       */
      public Builder setSelectQueryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        selectQuery_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private com.google.cloud.dataform.v1.RelationDescriptor relationDescriptor_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.RelationDescriptor,
              com.google.cloud.dataform.v1.RelationDescriptor.Builder,
              com.google.cloud.dataform.v1.RelationDescriptorOrBuilder>
          relationDescriptorBuilder_;

      /**
       *
       *
       * <pre>
       * Descriptor for the assertion's automatically-generated view and its
       * columns.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
       *
       * @return Whether the relationDescriptor field is set.
       */
      public boolean hasRelationDescriptor() {
        return ((bitField0_ & 0x00000020) != 0);
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the assertion's automatically-generated view and its
       * columns.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
       *
       * @return The relationDescriptor.
       */
      public com.google.cloud.dataform.v1.RelationDescriptor getRelationDescriptor() {
        if (relationDescriptorBuilder_ == null) {
          return relationDescriptor_ == null
              ? com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()
              : relationDescriptor_;
        } else {
          return relationDescriptorBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the assertion's automatically-generated view and its
       * columns.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
       */
      public Builder setRelationDescriptor(com.google.cloud.dataform.v1.RelationDescriptor value) {
        if (relationDescriptorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          relationDescriptor_ = value;
        } else {
          relationDescriptorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the assertion's automatically-generated view and its
       * columns.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
       */
      public Builder setRelationDescriptor(
          com.google.cloud.dataform.v1.RelationDescriptor.Builder builderForValue) {
        if (relationDescriptorBuilder_ == null) {
          relationDescriptor_ = builderForValue.build();
        } else {
          relationDescriptorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the assertion's automatically-generated view and its
       * columns.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
       */
      public Builder mergeRelationDescriptor(
          com.google.cloud.dataform.v1.RelationDescriptor value) {
        if (relationDescriptorBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && relationDescriptor_ != null
              && relationDescriptor_
                  != com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()) {
            getRelationDescriptorBuilder().mergeFrom(value);
          } else {
            relationDescriptor_ = value;
          }
        } else {
          relationDescriptorBuilder_.mergeFrom(value);
        }
        if (relationDescriptor_ != null) {
          bitField0_ |= 0x00000020;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the assertion's automatically-generated view and its
       * columns.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
       */
      public Builder clearRelationDescriptor() {
        bitField0_ = (bitField0_ & ~0x00000020);
        relationDescriptor_ = null;
        if (relationDescriptorBuilder_ != null) {
          relationDescriptorBuilder_.dispose();
          relationDescriptorBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the assertion's automatically-generated view and its
       * columns.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
       */
      public com.google.cloud.dataform.v1.RelationDescriptor.Builder
          getRelationDescriptorBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getRelationDescriptorFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the assertion's automatically-generated view and its
       * columns.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
       */
      public com.google.cloud.dataform.v1.RelationDescriptorOrBuilder
          getRelationDescriptorOrBuilder() {
        if (relationDescriptorBuilder_ != null) {
          return relationDescriptorBuilder_.getMessageOrBuilder();
        } else {
          return relationDescriptor_ == null
              ? com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()
              : relationDescriptor_;
        }
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the assertion's automatically-generated view and its
       * columns.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.RelationDescriptor,
              com.google.cloud.dataform.v1.RelationDescriptor.Builder,
              com.google.cloud.dataform.v1.RelationDescriptorOrBuilder>
          getRelationDescriptorFieldBuilder() {
        if (relationDescriptorBuilder_ == null) {
          relationDescriptorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dataform.v1.RelationDescriptor,
                  com.google.cloud.dataform.v1.RelationDescriptor.Builder,
                  com.google.cloud.dataform.v1.RelationDescriptorOrBuilder>(
                  getRelationDescriptor(), getParentForChildren(), isClean());
          relationDescriptor_ = null;
        }
        return relationDescriptorBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.CompilationResultAction.Assertion)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.CompilationResultAction.Assertion)
    private static final com.google.cloud.dataform.v1.CompilationResultAction.Assertion
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.CompilationResultAction.Assertion();
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Assertion
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Assertion> PARSER =
        new com.google.protobuf.AbstractParser<Assertion>() {
          @java.lang.Override
          public Assertion parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Assertion> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Assertion> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.Assertion
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeclarationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.CompilationResultAction.Declaration)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Descriptor for the relation and its columns. Used as documentation only,
     * i.e. values here will result in no changes to the relation's metadata.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 1;</code>
     *
     * @return Whether the relationDescriptor field is set.
     */
    boolean hasRelationDescriptor();

    /**
     *
     *
     * <pre>
     * Descriptor for the relation and its columns. Used as documentation only,
     * i.e. values here will result in no changes to the relation's metadata.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 1;</code>
     *
     * @return The relationDescriptor.
     */
    com.google.cloud.dataform.v1.RelationDescriptor getRelationDescriptor();

    /**
     *
     *
     * <pre>
     * Descriptor for the relation and its columns. Used as documentation only,
     * i.e. values here will result in no changes to the relation's metadata.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 1;</code>
     */
    com.google.cloud.dataform.v1.RelationDescriptorOrBuilder getRelationDescriptorOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Represents a relation which is not managed by Dataform but which may be
   * referenced by Dataform actions.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction.Declaration}
   */
  public static final class Declaration extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.CompilationResultAction.Declaration)
      DeclarationOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Declaration.newBuilder() to construct.
    private Declaration(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Declaration() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Declaration();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_Declaration_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_Declaration_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.CompilationResultAction.Declaration.class,
              com.google.cloud.dataform.v1.CompilationResultAction.Declaration.Builder.class);
    }

    private int bitField0_;
    public static final int RELATION_DESCRIPTOR_FIELD_NUMBER = 1;
    private com.google.cloud.dataform.v1.RelationDescriptor relationDescriptor_;

    /**
     *
     *
     * <pre>
     * Descriptor for the relation and its columns. Used as documentation only,
     * i.e. values here will result in no changes to the relation's metadata.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 1;</code>
     *
     * @return Whether the relationDescriptor field is set.
     */
    @java.lang.Override
    public boolean hasRelationDescriptor() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Descriptor for the relation and its columns. Used as documentation only,
     * i.e. values here will result in no changes to the relation's metadata.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 1;</code>
     *
     * @return The relationDescriptor.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.RelationDescriptor getRelationDescriptor() {
      return relationDescriptor_ == null
          ? com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()
          : relationDescriptor_;
    }

    /**
     *
     *
     * <pre>
     * Descriptor for the relation and its columns. Used as documentation only,
     * i.e. values here will result in no changes to the relation's metadata.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.RelationDescriptorOrBuilder
        getRelationDescriptorOrBuilder() {
      return relationDescriptor_ == null
          ? com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()
          : relationDescriptor_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getRelationDescriptor());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, getRelationDescriptor());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataform.v1.CompilationResultAction.Declaration)) {
        return super.equals(obj);
      }
      com.google.cloud.dataform.v1.CompilationResultAction.Declaration other =
          (com.google.cloud.dataform.v1.CompilationResultAction.Declaration) obj;

      if (hasRelationDescriptor() != other.hasRelationDescriptor()) return false;
      if (hasRelationDescriptor()) {
        if (!getRelationDescriptor().equals(other.getRelationDescriptor())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRelationDescriptor()) {
        hash = (37 * hash) + RELATION_DESCRIPTOR_FIELD_NUMBER;
        hash = (53 * hash) + getRelationDescriptor().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Declaration parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Declaration parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Declaration parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Declaration parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Declaration parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Declaration parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Declaration parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Declaration parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Declaration
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Declaration
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Declaration parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Declaration parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataform.v1.CompilationResultAction.Declaration prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Represents a relation which is not managed by Dataform but which may be
     * referenced by Dataform actions.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction.Declaration}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.CompilationResultAction.Declaration)
        com.google.cloud.dataform.v1.CompilationResultAction.DeclarationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_Declaration_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_Declaration_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.CompilationResultAction.Declaration.class,
                com.google.cloud.dataform.v1.CompilationResultAction.Declaration.Builder.class);
      }

      // Construct using
      // com.google.cloud.dataform.v1.CompilationResultAction.Declaration.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getRelationDescriptorFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        relationDescriptor_ = null;
        if (relationDescriptorBuilder_ != null) {
          relationDescriptorBuilder_.dispose();
          relationDescriptorBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_Declaration_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.Declaration
          getDefaultInstanceForType() {
        return com.google.cloud.dataform.v1.CompilationResultAction.Declaration
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.Declaration build() {
        com.google.cloud.dataform.v1.CompilationResultAction.Declaration result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.Declaration buildPartial() {
        com.google.cloud.dataform.v1.CompilationResultAction.Declaration result =
            new com.google.cloud.dataform.v1.CompilationResultAction.Declaration(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dataform.v1.CompilationResultAction.Declaration result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.relationDescriptor_ =
              relationDescriptorBuilder_ == null
                  ? relationDescriptor_
                  : relationDescriptorBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataform.v1.CompilationResultAction.Declaration) {
          return mergeFrom(
              (com.google.cloud.dataform.v1.CompilationResultAction.Declaration) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataform.v1.CompilationResultAction.Declaration other) {
        if (other
            == com.google.cloud.dataform.v1.CompilationResultAction.Declaration
                .getDefaultInstance()) return this;
        if (other.hasRelationDescriptor()) {
          mergeRelationDescriptor(other.getRelationDescriptor());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getRelationDescriptorFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.dataform.v1.RelationDescriptor relationDescriptor_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.RelationDescriptor,
              com.google.cloud.dataform.v1.RelationDescriptor.Builder,
              com.google.cloud.dataform.v1.RelationDescriptorOrBuilder>
          relationDescriptorBuilder_;

      /**
       *
       *
       * <pre>
       * Descriptor for the relation and its columns. Used as documentation only,
       * i.e. values here will result in no changes to the relation's metadata.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 1;</code>
       *
       * @return Whether the relationDescriptor field is set.
       */
      public boolean hasRelationDescriptor() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the relation and its columns. Used as documentation only,
       * i.e. values here will result in no changes to the relation's metadata.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 1;</code>
       *
       * @return The relationDescriptor.
       */
      public com.google.cloud.dataform.v1.RelationDescriptor getRelationDescriptor() {
        if (relationDescriptorBuilder_ == null) {
          return relationDescriptor_ == null
              ? com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()
              : relationDescriptor_;
        } else {
          return relationDescriptorBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the relation and its columns. Used as documentation only,
       * i.e. values here will result in no changes to the relation's metadata.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 1;</code>
       */
      public Builder setRelationDescriptor(com.google.cloud.dataform.v1.RelationDescriptor value) {
        if (relationDescriptorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          relationDescriptor_ = value;
        } else {
          relationDescriptorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the relation and its columns. Used as documentation only,
       * i.e. values here will result in no changes to the relation's metadata.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 1;</code>
       */
      public Builder setRelationDescriptor(
          com.google.cloud.dataform.v1.RelationDescriptor.Builder builderForValue) {
        if (relationDescriptorBuilder_ == null) {
          relationDescriptor_ = builderForValue.build();
        } else {
          relationDescriptorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the relation and its columns. Used as documentation only,
       * i.e. values here will result in no changes to the relation's metadata.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 1;</code>
       */
      public Builder mergeRelationDescriptor(
          com.google.cloud.dataform.v1.RelationDescriptor value) {
        if (relationDescriptorBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && relationDescriptor_ != null
              && relationDescriptor_
                  != com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()) {
            getRelationDescriptorBuilder().mergeFrom(value);
          } else {
            relationDescriptor_ = value;
          }
        } else {
          relationDescriptorBuilder_.mergeFrom(value);
        }
        if (relationDescriptor_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the relation and its columns. Used as documentation only,
       * i.e. values here will result in no changes to the relation's metadata.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 1;</code>
       */
      public Builder clearRelationDescriptor() {
        bitField0_ = (bitField0_ & ~0x00000001);
        relationDescriptor_ = null;
        if (relationDescriptorBuilder_ != null) {
          relationDescriptorBuilder_.dispose();
          relationDescriptorBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the relation and its columns. Used as documentation only,
       * i.e. values here will result in no changes to the relation's metadata.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 1;</code>
       */
      public com.google.cloud.dataform.v1.RelationDescriptor.Builder
          getRelationDescriptorBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getRelationDescriptorFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the relation and its columns. Used as documentation only,
       * i.e. values here will result in no changes to the relation's metadata.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 1;</code>
       */
      public com.google.cloud.dataform.v1.RelationDescriptorOrBuilder
          getRelationDescriptorOrBuilder() {
        if (relationDescriptorBuilder_ != null) {
          return relationDescriptorBuilder_.getMessageOrBuilder();
        } else {
          return relationDescriptor_ == null
              ? com.google.cloud.dataform.v1.RelationDescriptor.getDefaultInstance()
              : relationDescriptor_;
        }
      }

      /**
       *
       *
       * <pre>
       * Descriptor for the relation and its columns. Used as documentation only,
       * i.e. values here will result in no changes to the relation's metadata.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.RelationDescriptor relation_descriptor = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.RelationDescriptor,
              com.google.cloud.dataform.v1.RelationDescriptor.Builder,
              com.google.cloud.dataform.v1.RelationDescriptorOrBuilder>
          getRelationDescriptorFieldBuilder() {
        if (relationDescriptorBuilder_ == null) {
          relationDescriptorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dataform.v1.RelationDescriptor,
                  com.google.cloud.dataform.v1.RelationDescriptor.Builder,
                  com.google.cloud.dataform.v1.RelationDescriptorOrBuilder>(
                  getRelationDescriptor(), getParentForChildren(), isClean());
          relationDescriptor_ = null;
        }
        return relationDescriptorBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.CompilationResultAction.Declaration)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.CompilationResultAction.Declaration)
    private static final com.google.cloud.dataform.v1.CompilationResultAction.Declaration
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.CompilationResultAction.Declaration();
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Declaration
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Declaration> PARSER =
        new com.google.protobuf.AbstractParser<Declaration>() {
          @java.lang.Override
          public Declaration parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Declaration> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Declaration> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.Declaration
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NotebookOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.CompilationResultAction.Notebook)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    java.util.List<com.google.cloud.dataform.v1.Target> getDependencyTargetsList();

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    com.google.cloud.dataform.v1.Target getDependencyTargets(int index);

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    int getDependencyTargetsCount();

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    java.util.List<? extends com.google.cloud.dataform.v1.TargetOrBuilder>
        getDependencyTargetsOrBuilderList();

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    com.google.cloud.dataform.v1.TargetOrBuilder getDependencyTargetsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Whether this action is disabled (i.e. should not be run).
     * </pre>
     *
     * <code>bool disabled = 2;</code>
     *
     * @return The disabled.
     */
    boolean getDisabled();

    /**
     *
     *
     * <pre>
     * The contents of the notebook.
     * </pre>
     *
     * <code>string contents = 3;</code>
     *
     * @return The contents.
     */
    java.lang.String getContents();

    /**
     *
     *
     * <pre>
     * The contents of the notebook.
     * </pre>
     *
     * <code>string contents = 3;</code>
     *
     * @return The bytes for contents.
     */
    com.google.protobuf.ByteString getContentsBytes();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @return A list containing the tags.
     */
    java.util.List<java.lang.String> getTagsList();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @return The count of tags.
     */
    int getTagsCount();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    java.lang.String getTags(int index);

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    com.google.protobuf.ByteString getTagsBytes(int index);
  }

  /**
   *
   *
   * <pre>
   * Represents a notebook.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction.Notebook}
   */
  public static final class Notebook extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.CompilationResultAction.Notebook)
      NotebookOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Notebook.newBuilder() to construct.
    private Notebook(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Notebook() {
      dependencyTargets_ = java.util.Collections.emptyList();
      contents_ = "";
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Notebook();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_Notebook_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_Notebook_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.CompilationResultAction.Notebook.class,
              com.google.cloud.dataform.v1.CompilationResultAction.Notebook.Builder.class);
    }

    public static final int DEPENDENCY_TARGETS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.dataform.v1.Target> dependencyTargets_;

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dataform.v1.Target> getDependencyTargetsList() {
      return dependencyTargets_;
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.dataform.v1.TargetOrBuilder>
        getDependencyTargetsOrBuilderList() {
      return dependencyTargets_;
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public int getDependencyTargetsCount() {
      return dependencyTargets_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.Target getDependencyTargets(int index) {
      return dependencyTargets_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.TargetOrBuilder getDependencyTargetsOrBuilder(int index) {
      return dependencyTargets_.get(index);
    }

    public static final int DISABLED_FIELD_NUMBER = 2;
    private boolean disabled_ = false;

    /**
     *
     *
     * <pre>
     * Whether this action is disabled (i.e. should not be run).
     * </pre>
     *
     * <code>bool disabled = 2;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }

    public static final int CONTENTS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object contents_ = "";

    /**
     *
     *
     * <pre>
     * The contents of the notebook.
     * </pre>
     *
     * <code>string contents = 3;</code>
     *
     * @return The contents.
     */
    @java.lang.Override
    public java.lang.String getContents() {
      java.lang.Object ref = contents_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        contents_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The contents of the notebook.
     * </pre>
     *
     * <code>string contents = 3;</code>
     *
     * @return The bytes for contents.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getContentsBytes() {
      java.lang.Object ref = contents_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        contents_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TAGS_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList tags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      return tags_;
    }

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < dependencyTargets_.size(); i++) {
        output.writeMessage(1, dependencyTargets_.get(i));
      }
      if (disabled_ != false) {
        output.writeBool(2, disabled_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contents_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, contents_);
      }
      for (int i = 0; i < tags_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, tags_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < dependencyTargets_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, dependencyTargets_.get(i));
      }
      if (disabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, disabled_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contents_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, contents_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < tags_.size(); i++) {
          dataSize += computeStringSizeNoTag(tags_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getTagsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataform.v1.CompilationResultAction.Notebook)) {
        return super.equals(obj);
      }
      com.google.cloud.dataform.v1.CompilationResultAction.Notebook other =
          (com.google.cloud.dataform.v1.CompilationResultAction.Notebook) obj;

      if (!getDependencyTargetsList().equals(other.getDependencyTargetsList())) return false;
      if (getDisabled() != other.getDisabled()) return false;
      if (!getContents().equals(other.getContents())) return false;
      if (!getTagsList().equals(other.getTagsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDependencyTargetsCount() > 0) {
        hash = (37 * hash) + DEPENDENCY_TARGETS_FIELD_NUMBER;
        hash = (53 * hash) + getDependencyTargetsList().hashCode();
      }
      hash = (37 * hash) + DISABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
      hash = (37 * hash) + CONTENTS_FIELD_NUMBER;
      hash = (53 * hash) + getContents().hashCode();
      if (getTagsCount() > 0) {
        hash = (37 * hash) + TAGS_FIELD_NUMBER;
        hash = (53 * hash) + getTagsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Notebook parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Notebook parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Notebook parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Notebook parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Notebook parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Notebook parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Notebook parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Notebook parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Notebook parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Notebook parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Notebook parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Notebook parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataform.v1.CompilationResultAction.Notebook prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Represents a notebook.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction.Notebook}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.CompilationResultAction.Notebook)
        com.google.cloud.dataform.v1.CompilationResultAction.NotebookOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_Notebook_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_Notebook_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.CompilationResultAction.Notebook.class,
                com.google.cloud.dataform.v1.CompilationResultAction.Notebook.Builder.class);
      }

      // Construct using com.google.cloud.dataform.v1.CompilationResultAction.Notebook.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (dependencyTargetsBuilder_ == null) {
          dependencyTargets_ = java.util.Collections.emptyList();
        } else {
          dependencyTargets_ = null;
          dependencyTargetsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        disabled_ = false;
        contents_ = "";
        tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_Notebook_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.Notebook
          getDefaultInstanceForType() {
        return com.google.cloud.dataform.v1.CompilationResultAction.Notebook.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.Notebook build() {
        com.google.cloud.dataform.v1.CompilationResultAction.Notebook result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.Notebook buildPartial() {
        com.google.cloud.dataform.v1.CompilationResultAction.Notebook result =
            new com.google.cloud.dataform.v1.CompilationResultAction.Notebook(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dataform.v1.CompilationResultAction.Notebook result) {
        if (dependencyTargetsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            dependencyTargets_ = java.util.Collections.unmodifiableList(dependencyTargets_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.dependencyTargets_ = dependencyTargets_;
        } else {
          result.dependencyTargets_ = dependencyTargetsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.dataform.v1.CompilationResultAction.Notebook result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.disabled_ = disabled_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.contents_ = contents_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          tags_.makeImmutable();
          result.tags_ = tags_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataform.v1.CompilationResultAction.Notebook) {
          return mergeFrom((com.google.cloud.dataform.v1.CompilationResultAction.Notebook) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataform.v1.CompilationResultAction.Notebook other) {
        if (other
            == com.google.cloud.dataform.v1.CompilationResultAction.Notebook.getDefaultInstance())
          return this;
        if (dependencyTargetsBuilder_ == null) {
          if (!other.dependencyTargets_.isEmpty()) {
            if (dependencyTargets_.isEmpty()) {
              dependencyTargets_ = other.dependencyTargets_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureDependencyTargetsIsMutable();
              dependencyTargets_.addAll(other.dependencyTargets_);
            }
            onChanged();
          }
        } else {
          if (!other.dependencyTargets_.isEmpty()) {
            if (dependencyTargetsBuilder_.isEmpty()) {
              dependencyTargetsBuilder_.dispose();
              dependencyTargetsBuilder_ = null;
              dependencyTargets_ = other.dependencyTargets_;
              bitField0_ = (bitField0_ & ~0x00000001);
              dependencyTargetsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDependencyTargetsFieldBuilder()
                      : null;
            } else {
              dependencyTargetsBuilder_.addAllMessages(other.dependencyTargets_);
            }
          }
        }
        if (other.getDisabled() != false) {
          setDisabled(other.getDisabled());
        }
        if (!other.getContents().isEmpty()) {
          contents_ = other.contents_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.tags_.isEmpty()) {
          if (tags_.isEmpty()) {
            tags_ = other.tags_;
            bitField0_ |= 0x00000008;
          } else {
            ensureTagsIsMutable();
            tags_.addAll(other.tags_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.dataform.v1.Target m =
                      input.readMessage(
                          com.google.cloud.dataform.v1.Target.parser(), extensionRegistry);
                  if (dependencyTargetsBuilder_ == null) {
                    ensureDependencyTargetsIsMutable();
                    dependencyTargets_.add(m);
                  } else {
                    dependencyTargetsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 16:
                {
                  disabled_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  contents_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureTagsIsMutable();
                  tags_.add(s);
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.dataform.v1.Target> dependencyTargets_ =
          java.util.Collections.emptyList();

      private void ensureDependencyTargetsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          dependencyTargets_ =
              new java.util.ArrayList<com.google.cloud.dataform.v1.Target>(dependencyTargets_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dataform.v1.Target,
              com.google.cloud.dataform.v1.Target.Builder,
              com.google.cloud.dataform.v1.TargetOrBuilder>
          dependencyTargetsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public java.util.List<com.google.cloud.dataform.v1.Target> getDependencyTargetsList() {
        if (dependencyTargetsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(dependencyTargets_);
        } else {
          return dependencyTargetsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public int getDependencyTargetsCount() {
        if (dependencyTargetsBuilder_ == null) {
          return dependencyTargets_.size();
        } else {
          return dependencyTargetsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target getDependencyTargets(int index) {
        if (dependencyTargetsBuilder_ == null) {
          return dependencyTargets_.get(index);
        } else {
          return dependencyTargetsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder setDependencyTargets(int index, com.google.cloud.dataform.v1.Target value) {
        if (dependencyTargetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.set(index, value);
          onChanged();
        } else {
          dependencyTargetsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder setDependencyTargets(
          int index, com.google.cloud.dataform.v1.Target.Builder builderForValue) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.set(index, builderForValue.build());
          onChanged();
        } else {
          dependencyTargetsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(com.google.cloud.dataform.v1.Target value) {
        if (dependencyTargetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(value);
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(int index, com.google.cloud.dataform.v1.Target value) {
        if (dependencyTargetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(index, value);
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(
          com.google.cloud.dataform.v1.Target.Builder builderForValue) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(builderForValue.build());
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(
          int index, com.google.cloud.dataform.v1.Target.Builder builderForValue) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(index, builderForValue.build());
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addAllDependencyTargets(
          java.lang.Iterable<? extends com.google.cloud.dataform.v1.Target> values) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dependencyTargets_);
          onChanged();
        } else {
          dependencyTargetsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder clearDependencyTargets() {
        if (dependencyTargetsBuilder_ == null) {
          dependencyTargets_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          dependencyTargetsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder removeDependencyTargets(int index) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.remove(index);
          onChanged();
        } else {
          dependencyTargetsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target.Builder getDependencyTargetsBuilder(int index) {
        return getDependencyTargetsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.TargetOrBuilder getDependencyTargetsOrBuilder(int index) {
        if (dependencyTargetsBuilder_ == null) {
          return dependencyTargets_.get(index);
        } else {
          return dependencyTargetsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public java.util.List<? extends com.google.cloud.dataform.v1.TargetOrBuilder>
          getDependencyTargetsOrBuilderList() {
        if (dependencyTargetsBuilder_ != null) {
          return dependencyTargetsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(dependencyTargets_);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target.Builder addDependencyTargetsBuilder() {
        return getDependencyTargetsFieldBuilder()
            .addBuilder(com.google.cloud.dataform.v1.Target.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target.Builder addDependencyTargetsBuilder(int index) {
        return getDependencyTargetsFieldBuilder()
            .addBuilder(index, com.google.cloud.dataform.v1.Target.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public java.util.List<com.google.cloud.dataform.v1.Target.Builder>
          getDependencyTargetsBuilderList() {
        return getDependencyTargetsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dataform.v1.Target,
              com.google.cloud.dataform.v1.Target.Builder,
              com.google.cloud.dataform.v1.TargetOrBuilder>
          getDependencyTargetsFieldBuilder() {
        if (dependencyTargetsBuilder_ == null) {
          dependencyTargetsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dataform.v1.Target,
                  com.google.cloud.dataform.v1.Target.Builder,
                  com.google.cloud.dataform.v1.TargetOrBuilder>(
                  dependencyTargets_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          dependencyTargets_ = null;
        }
        return dependencyTargetsBuilder_;
      }

      private boolean disabled_;

      /**
       *
       *
       * <pre>
       * Whether this action is disabled (i.e. should not be run).
       * </pre>
       *
       * <code>bool disabled = 2;</code>
       *
       * @return The disabled.
       */
      @java.lang.Override
      public boolean getDisabled() {
        return disabled_;
      }

      /**
       *
       *
       * <pre>
       * Whether this action is disabled (i.e. should not be run).
       * </pre>
       *
       * <code>bool disabled = 2;</code>
       *
       * @param value The disabled to set.
       * @return This builder for chaining.
       */
      public Builder setDisabled(boolean value) {

        disabled_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Whether this action is disabled (i.e. should not be run).
       * </pre>
       *
       * <code>bool disabled = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisabled() {
        bitField0_ = (bitField0_ & ~0x00000002);
        disabled_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object contents_ = "";

      /**
       *
       *
       * <pre>
       * The contents of the notebook.
       * </pre>
       *
       * <code>string contents = 3;</code>
       *
       * @return The contents.
       */
      public java.lang.String getContents() {
        java.lang.Object ref = contents_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          contents_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The contents of the notebook.
       * </pre>
       *
       * <code>string contents = 3;</code>
       *
       * @return The bytes for contents.
       */
      public com.google.protobuf.ByteString getContentsBytes() {
        java.lang.Object ref = contents_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          contents_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The contents of the notebook.
       * </pre>
       *
       * <code>string contents = 3;</code>
       *
       * @param value The contents to set.
       * @return This builder for chaining.
       */
      public Builder setContents(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        contents_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The contents of the notebook.
       * </pre>
       *
       * <code>string contents = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContents() {
        contents_ = getDefaultInstance().getContents();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The contents of the notebook.
       * </pre>
       *
       * <code>string contents = 3;</code>
       *
       * @param value The bytes for contents to set.
       * @return This builder for chaining.
       */
      public Builder setContentsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        contents_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList tags_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureTagsIsMutable() {
        if (!tags_.isModifiable()) {
          tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
        }
        bitField0_ |= 0x00000008;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 4;</code>
       *
       * @return A list containing the tags.
       */
      public com.google.protobuf.ProtocolStringList getTagsList() {
        tags_.makeImmutable();
        return tags_;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 4;</code>
       *
       * @return The count of tags.
       */
      public int getTagsCount() {
        return tags_.size();
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 4;</code>
       *
       * @param index The index of the element to return.
       * @return The tags at the given index.
       */
      public java.lang.String getTags(int index) {
        return tags_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 4;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the tags at the given index.
       */
      public com.google.protobuf.ByteString getTagsBytes(int index) {
        return tags_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 4;</code>
       *
       * @param index The index to set the value at.
       * @param value The tags to set.
       * @return This builder for chaining.
       */
      public Builder setTags(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.set(index, value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 4;</code>
       *
       * @param value The tags to add.
       * @return This builder for chaining.
       */
      public Builder addTags(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 4;</code>
       *
       * @param values The tags to add.
       * @return This builder for chaining.
       */
      public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
        ensureTagsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTags() {
        tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 4;</code>
       *
       * @param value The bytes of the tags to add.
       * @return This builder for chaining.
       */
      public Builder addTagsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureTagsIsMutable();
        tags_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.CompilationResultAction.Notebook)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.CompilationResultAction.Notebook)
    private static final com.google.cloud.dataform.v1.CompilationResultAction.Notebook
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.CompilationResultAction.Notebook();
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.Notebook
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Notebook> PARSER =
        new com.google.protobuf.AbstractParser<Notebook>() {
          @java.lang.Override
          public Notebook parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Notebook> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Notebook> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.Notebook
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DataPreparationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.CompilationResultAction.DataPreparation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The data preparation definition, stored as a YAML string.
     * </pre>
     *
     * <code>string contents_yaml = 5;</code>
     *
     * @return Whether the contentsYaml field is set.
     */
    boolean hasContentsYaml();

    /**
     *
     *
     * <pre>
     * The data preparation definition, stored as a YAML string.
     * </pre>
     *
     * <code>string contents_yaml = 5;</code>
     *
     * @return The contentsYaml.
     */
    java.lang.String getContentsYaml();

    /**
     *
     *
     * <pre>
     * The data preparation definition, stored as a YAML string.
     * </pre>
     *
     * <code>string contents_yaml = 5;</code>
     *
     * @return The bytes for contentsYaml.
     */
    com.google.protobuf.ByteString getContentsYamlBytes();

    /**
     *
     *
     * <pre>
     * SQL definition for a Data Preparation. Contains a SQL query and
     * additional context information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition contents_sql = 6;
     * </code>
     *
     * @return Whether the contentsSql field is set.
     */
    boolean hasContentsSql();

    /**
     *
     *
     * <pre>
     * SQL definition for a Data Preparation. Contains a SQL query and
     * additional context information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition contents_sql = 6;
     * </code>
     *
     * @return The contentsSql.
     */
    com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
        getContentsSql();

    /**
     *
     *
     * <pre>
     * SQL definition for a Data Preparation. Contains a SQL query and
     * additional context information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition contents_sql = 6;
     * </code>
     */
    com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinitionOrBuilder
        getContentsSqlOrBuilder();

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    java.util.List<com.google.cloud.dataform.v1.Target> getDependencyTargetsList();

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    com.google.cloud.dataform.v1.Target getDependencyTargets(int index);

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    int getDependencyTargetsCount();

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    java.util.List<? extends com.google.cloud.dataform.v1.TargetOrBuilder>
        getDependencyTargetsOrBuilderList();

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    com.google.cloud.dataform.v1.TargetOrBuilder getDependencyTargetsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Whether this action is disabled (i.e. should not be run).
     * </pre>
     *
     * <code>bool disabled = 2;</code>
     *
     * @return The disabled.
     */
    boolean getDisabled();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @return A list containing the tags.
     */
    java.util.List<java.lang.String> getTagsList();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @return The count of tags.
     */
    int getTagsCount();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    java.lang.String getTags(int index);

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    com.google.protobuf.ByteString getTagsBytes(int index);

    com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.DefinitionCase
        getDefinitionCase();
  }

  /**
   *
   *
   * <pre>
   * Defines a compiled Data Preparation entity
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction.DataPreparation}
   */
  public static final class DataPreparation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.CompilationResultAction.DataPreparation)
      DataPreparationOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use DataPreparation.newBuilder() to construct.
    private DataPreparation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DataPreparation() {
      dependencyTargets_ = java.util.Collections.emptyList();
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DataPreparation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_DataPreparation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_DataPreparation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.class,
              com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.Builder.class);
    }

    public interface SqlDefinitionOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The SQL query representing the data preparation steps. Formatted as a
       * Pipe SQL query statement.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @return The query.
       */
      java.lang.String getQuery();

      /**
       *
       *
       * <pre>
       * The SQL query representing the data preparation steps. Formatted as a
       * Pipe SQL query statement.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @return The bytes for query.
       */
      com.google.protobuf.ByteString getQueryBytes();

      /**
       *
       *
       * <pre>
       * Error table configuration,
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable error_table = 2;
       * </code>
       *
       * @return Whether the errorTable field is set.
       */
      boolean hasErrorTable();

      /**
       *
       *
       * <pre>
       * Error table configuration,
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable error_table = 2;
       * </code>
       *
       * @return The errorTable.
       */
      com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
          getErrorTable();

      /**
       *
       *
       * <pre>
       * Error table configuration,
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable error_table = 2;
       * </code>
       */
      com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTableOrBuilder
          getErrorTableOrBuilder();

      /**
       *
       *
       * <pre>
       * Load configuration.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.LoadConfig load = 3;</code>
       *
       * @return Whether the load field is set.
       */
      boolean hasLoad();

      /**
       *
       *
       * <pre>
       * Load configuration.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.LoadConfig load = 3;</code>
       *
       * @return The load.
       */
      com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig getLoad();

      /**
       *
       *
       * <pre>
       * Load configuration.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.LoadConfig load = 3;</code>
       */
      com.google.cloud.dataform.v1.CompilationResultAction.LoadConfigOrBuilder getLoadOrBuilder();
    }

    /**
     *
     *
     * <pre>
     * Definition of a SQL Data Preparation
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition}
     */
    public static final class SqlDefinition extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition)
        SqlDefinitionOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use SqlDefinition.newBuilder() to construct.
      private SqlDefinition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SqlDefinition() {
        query_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SqlDefinition();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_DataPreparation_SqlDefinition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_DataPreparation_SqlDefinition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
                    .class,
                com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
                    .Builder.class);
      }

      private int bitField0_;
      public static final int QUERY_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object query_ = "";

      /**
       *
       *
       * <pre>
       * The SQL query representing the data preparation steps. Formatted as a
       * Pipe SQL query statement.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @return The query.
       */
      @java.lang.Override
      public java.lang.String getQuery() {
        java.lang.Object ref = query_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          query_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * The SQL query representing the data preparation steps. Formatted as a
       * Pipe SQL query statement.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @return The bytes for query.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getQueryBytes() {
        java.lang.Object ref = query_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          query_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ERROR_TABLE_FIELD_NUMBER = 2;
      private com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
          errorTable_;

      /**
       *
       *
       * <pre>
       * Error table configuration,
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable error_table = 2;
       * </code>
       *
       * @return Whether the errorTable field is set.
       */
      @java.lang.Override
      public boolean hasErrorTable() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Error table configuration,
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable error_table = 2;
       * </code>
       *
       * @return The errorTable.
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
          getErrorTable() {
        return errorTable_ == null
            ? com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
                .getDefaultInstance()
            : errorTable_;
      }

      /**
       *
       *
       * <pre>
       * Error table configuration,
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable error_table = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
              .ErrorTableOrBuilder
          getErrorTableOrBuilder() {
        return errorTable_ == null
            ? com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
                .getDefaultInstance()
            : errorTable_;
      }

      public static final int LOAD_FIELD_NUMBER = 3;
      private com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig load_;

      /**
       *
       *
       * <pre>
       * Load configuration.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.LoadConfig load = 3;</code>
       *
       * @return Whether the load field is set.
       */
      @java.lang.Override
      public boolean hasLoad() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Load configuration.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.LoadConfig load = 3;</code>
       *
       * @return The load.
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig getLoad() {
        return load_ == null
            ? com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig.getDefaultInstance()
            : load_;
      }

      /**
       *
       *
       * <pre>
       * Load configuration.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.LoadConfig load = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.LoadConfigOrBuilder
          getLoadOrBuilder() {
        return load_ == null
            ? com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig.getDefaultInstance()
            : load_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, query_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(2, getErrorTable());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(3, getLoad());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, query_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getErrorTable());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getLoad());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition)) {
          return super.equals(obj);
        }
        com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition other =
            (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition)
                obj;

        if (!getQuery().equals(other.getQuery())) return false;
        if (hasErrorTable() != other.hasErrorTable()) return false;
        if (hasErrorTable()) {
          if (!getErrorTable().equals(other.getErrorTable())) return false;
        }
        if (hasLoad() != other.hasLoad()) return false;
        if (hasLoad()) {
          if (!getLoad().equals(other.getLoad())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getQuery().hashCode();
        if (hasErrorTable()) {
          hash = (37 * hash) + ERROR_TABLE_FIELD_NUMBER;
          hash = (53 * hash) + getErrorTable().hashCode();
        }
        if (hasLoad()) {
          hash = (37 * hash) + LOAD_FIELD_NUMBER;
          hash = (53 * hash) + getLoad().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
              .SqlDefinition
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
              .SqlDefinition
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
              .SqlDefinition
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
              .SqlDefinition
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
              .SqlDefinition
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
              .SqlDefinition
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
              .SqlDefinition
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
              .SqlDefinition
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
              .SqlDefinition
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
              .SqlDefinition
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
              .SqlDefinition
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
              .SqlDefinition
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Definition of a SQL Data Preparation
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition)
          com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
              .SqlDefinitionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_CompilationResultAction_DataPreparation_SqlDefinition_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_CompilationResultAction_DataPreparation_SqlDefinition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
                      .class,
                  com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getErrorTableFieldBuilder();
            getLoadFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          query_ = "";
          errorTable_ = null;
          if (errorTableBuilder_ != null) {
            errorTableBuilder_.dispose();
            errorTableBuilder_ = null;
          }
          load_ = null;
          if (loadBuilder_ != null) {
            loadBuilder_.dispose();
            loadBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_CompilationResultAction_DataPreparation_SqlDefinition_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
            getDefaultInstanceForType() {
          return com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
            build() {
          com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
            buildPartial() {
          com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
              result =
                  new com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
                      .SqlDefinition(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.query_ = query_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.errorTable_ =
                errorTableBuilder_ == null ? errorTable_ : errorTableBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.load_ = loadBuilder_ == null ? load_ : loadBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition) {
            return mergeFrom(
                (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
                other) {
          if (other
              == com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
                  .getDefaultInstance()) return this;
          if (!other.getQuery().isEmpty()) {
            query_ = other.query_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasErrorTable()) {
            mergeErrorTable(other.getErrorTable());
          }
          if (other.hasLoad()) {
            mergeLoad(other.getLoad());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    query_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getErrorTableFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(getLoadFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object query_ = "";

        /**
         *
         *
         * <pre>
         * The SQL query representing the data preparation steps. Formatted as a
         * Pipe SQL query statement.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @return The query.
         */
        public java.lang.String getQuery() {
          java.lang.Object ref = query_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            query_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * The SQL query representing the data preparation steps. Formatted as a
         * Pipe SQL query statement.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @return The bytes for query.
         */
        public com.google.protobuf.ByteString getQueryBytes() {
          java.lang.Object ref = query_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            query_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * The SQL query representing the data preparation steps. Formatted as a
         * Pipe SQL query statement.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @param value The query to set.
         * @return This builder for chaining.
         */
        public Builder setQuery(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          query_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The SQL query representing the data preparation steps. Formatted as a
         * Pipe SQL query statement.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearQuery() {
          query_ = getDefaultInstance().getQuery();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The SQL query representing the data preparation steps. Formatted as a
         * Pipe SQL query statement.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @param value The bytes for query to set.
         * @return This builder for chaining.
         */
        public Builder setQueryBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          query_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
            errorTable_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable,
                com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
                    .Builder,
                com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
                    .ErrorTableOrBuilder>
            errorTableBuilder_;

        /**
         *
         *
         * <pre>
         * Error table configuration,
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable error_table = 2;
         * </code>
         *
         * @return Whether the errorTable field is set.
         */
        public boolean hasErrorTable() {
          return ((bitField0_ & 0x00000002) != 0);
        }

        /**
         *
         *
         * <pre>
         * Error table configuration,
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable error_table = 2;
         * </code>
         *
         * @return The errorTable.
         */
        public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
            getErrorTable() {
          if (errorTableBuilder_ == null) {
            return errorTable_ == null
                ? com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
                    .getDefaultInstance()
                : errorTable_;
          } else {
            return errorTableBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Error table configuration,
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable error_table = 2;
         * </code>
         */
        public Builder setErrorTable(
            com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable value) {
          if (errorTableBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            errorTable_ = value;
          } else {
            errorTableBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Error table configuration,
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable error_table = 2;
         * </code>
         */
        public Builder setErrorTable(
            com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable.Builder
                builderForValue) {
          if (errorTableBuilder_ == null) {
            errorTable_ = builderForValue.build();
          } else {
            errorTableBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Error table configuration,
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable error_table = 2;
         * </code>
         */
        public Builder mergeErrorTable(
            com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable value) {
          if (errorTableBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && errorTable_ != null
                && errorTable_
                    != com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
                        .ErrorTable.getDefaultInstance()) {
              getErrorTableBuilder().mergeFrom(value);
            } else {
              errorTable_ = value;
            }
          } else {
            errorTableBuilder_.mergeFrom(value);
          }
          if (errorTable_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Error table configuration,
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable error_table = 2;
         * </code>
         */
        public Builder clearErrorTable() {
          bitField0_ = (bitField0_ & ~0x00000002);
          errorTable_ = null;
          if (errorTableBuilder_ != null) {
            errorTableBuilder_.dispose();
            errorTableBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Error table configuration,
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable error_table = 2;
         * </code>
         */
        public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
                .Builder
            getErrorTableBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getErrorTableFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Error table configuration,
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable error_table = 2;
         * </code>
         */
        public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
                .ErrorTableOrBuilder
            getErrorTableOrBuilder() {
          if (errorTableBuilder_ != null) {
            return errorTableBuilder_.getMessageOrBuilder();
          } else {
            return errorTable_ == null
                ? com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
                    .getDefaultInstance()
                : errorTable_;
          }
        }

        /**
         *
         *
         * <pre>
         * Error table configuration,
         * </pre>
         *
         * <code>
         * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable error_table = 2;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable,
                com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
                    .Builder,
                com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
                    .ErrorTableOrBuilder>
            getErrorTableFieldBuilder() {
          if (errorTableBuilder_ == null) {
            errorTableBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable,
                    com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
                        .Builder,
                    com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
                        .ErrorTableOrBuilder>(getErrorTable(), getParentForChildren(), isClean());
            errorTable_ = null;
          }
          return errorTableBuilder_;
        }

        private com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig load_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig,
                com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig.Builder,
                com.google.cloud.dataform.v1.CompilationResultAction.LoadConfigOrBuilder>
            loadBuilder_;

        /**
         *
         *
         * <pre>
         * Load configuration.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.CompilationResultAction.LoadConfig load = 3;</code>
         *
         * @return Whether the load field is set.
         */
        public boolean hasLoad() {
          return ((bitField0_ & 0x00000004) != 0);
        }

        /**
         *
         *
         * <pre>
         * Load configuration.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.CompilationResultAction.LoadConfig load = 3;</code>
         *
         * @return The load.
         */
        public com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig getLoad() {
          if (loadBuilder_ == null) {
            return load_ == null
                ? com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig
                    .getDefaultInstance()
                : load_;
          } else {
            return loadBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Load configuration.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.CompilationResultAction.LoadConfig load = 3;</code>
         */
        public Builder setLoad(
            com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig value) {
          if (loadBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            load_ = value;
          } else {
            loadBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Load configuration.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.CompilationResultAction.LoadConfig load = 3;</code>
         */
        public Builder setLoad(
            com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig.Builder
                builderForValue) {
          if (loadBuilder_ == null) {
            load_ = builderForValue.build();
          } else {
            loadBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Load configuration.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.CompilationResultAction.LoadConfig load = 3;</code>
         */
        public Builder mergeLoad(
            com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig value) {
          if (loadBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && load_ != null
                && load_
                    != com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig
                        .getDefaultInstance()) {
              getLoadBuilder().mergeFrom(value);
            } else {
              load_ = value;
            }
          } else {
            loadBuilder_.mergeFrom(value);
          }
          if (load_ != null) {
            bitField0_ |= 0x00000004;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Load configuration.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.CompilationResultAction.LoadConfig load = 3;</code>
         */
        public Builder clearLoad() {
          bitField0_ = (bitField0_ & ~0x00000004);
          load_ = null;
          if (loadBuilder_ != null) {
            loadBuilder_.dispose();
            loadBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Load configuration.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.CompilationResultAction.LoadConfig load = 3;</code>
         */
        public com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig.Builder
            getLoadBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getLoadFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Load configuration.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.CompilationResultAction.LoadConfig load = 3;</code>
         */
        public com.google.cloud.dataform.v1.CompilationResultAction.LoadConfigOrBuilder
            getLoadOrBuilder() {
          if (loadBuilder_ != null) {
            return loadBuilder_.getMessageOrBuilder();
          } else {
            return load_ == null
                ? com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig
                    .getDefaultInstance()
                : load_;
          }
        }

        /**
         *
         *
         * <pre>
         * Load configuration.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.CompilationResultAction.LoadConfig load = 3;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig,
                com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig.Builder,
                com.google.cloud.dataform.v1.CompilationResultAction.LoadConfigOrBuilder>
            getLoadFieldBuilder() {
          if (loadBuilder_ == null) {
            loadBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig,
                    com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig.Builder,
                    com.google.cloud.dataform.v1.CompilationResultAction.LoadConfigOrBuilder>(
                    getLoad(), getParentForChildren(), isClean());
            load_ = null;
          }
          return loadBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition)
      private static final com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
              .SqlDefinition
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
                .SqlDefinition();
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
              .SqlDefinition
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SqlDefinition> PARSER =
          new com.google.protobuf.AbstractParser<SqlDefinition>() {
            @java.lang.Override
            public SqlDefinition parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SqlDefinition> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SqlDefinition> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ErrorTableOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Error Table target.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target target = 1;</code>
       *
       * @return Whether the target field is set.
       */
      boolean hasTarget();

      /**
       *
       *
       * <pre>
       * Error Table target.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target target = 1;</code>
       *
       * @return The target.
       */
      com.google.cloud.dataform.v1.Target getTarget();

      /**
       *
       *
       * <pre>
       * Error Table target.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target target = 1;</code>
       */
      com.google.cloud.dataform.v1.TargetOrBuilder getTargetOrBuilder();

      /**
       *
       *
       * <pre>
       * Error table partition expiration in days. Only positive values are
       * allowed.
       * </pre>
       *
       * <code>int32 retention_days = 2;</code>
       *
       * @return The retentionDays.
       */
      int getRetentionDays();
    }

    /**
     *
     *
     * <pre>
     * Error table information, used to write error data into a BigQuery
     * table.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable}
     */
    public static final class ErrorTable extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable)
        ErrorTableOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use ErrorTable.newBuilder() to construct.
      private ErrorTable(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ErrorTable() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ErrorTable();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_DataPreparation_ErrorTable_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_DataPreparation_ErrorTable_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
                    .class,
                com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
                    .Builder.class);
      }

      private int bitField0_;
      public static final int TARGET_FIELD_NUMBER = 1;
      private com.google.cloud.dataform.v1.Target target_;

      /**
       *
       *
       * <pre>
       * Error Table target.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target target = 1;</code>
       *
       * @return Whether the target field is set.
       */
      @java.lang.Override
      public boolean hasTarget() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Error Table target.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target target = 1;</code>
       *
       * @return The target.
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.Target getTarget() {
        return target_ == null ? com.google.cloud.dataform.v1.Target.getDefaultInstance() : target_;
      }

      /**
       *
       *
       * <pre>
       * Error Table target.
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.Target target = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.TargetOrBuilder getTargetOrBuilder() {
        return target_ == null ? com.google.cloud.dataform.v1.Target.getDefaultInstance() : target_;
      }

      public static final int RETENTION_DAYS_FIELD_NUMBER = 2;
      private int retentionDays_ = 0;

      /**
       *
       *
       * <pre>
       * Error table partition expiration in days. Only positive values are
       * allowed.
       * </pre>
       *
       * <code>int32 retention_days = 2;</code>
       *
       * @return The retentionDays.
       */
      @java.lang.Override
      public int getRetentionDays() {
        return retentionDays_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getTarget());
        }
        if (retentionDays_ != 0) {
          output.writeInt32(2, retentionDays_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTarget());
        }
        if (retentionDays_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, retentionDays_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable)) {
          return super.equals(obj);
        }
        com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable other =
            (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable) obj;

        if (hasTarget() != other.hasTarget()) return false;
        if (hasTarget()) {
          if (!getTarget().equals(other.getTarget())) return false;
        }
        if (getRetentionDays() != other.getRetentionDays()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasTarget()) {
          hash = (37 * hash) + TARGET_FIELD_NUMBER;
          hash = (53 * hash) + getTarget().hashCode();
        }
        hash = (37 * hash) + RETENTION_DAYS_FIELD_NUMBER;
        hash = (53 * hash) + getRetentionDays();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Error table information, used to write error data into a BigQuery
       * table.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable)
          com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTableOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_CompilationResultAction_DataPreparation_ErrorTable_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_CompilationResultAction_DataPreparation_ErrorTable_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
                      .class,
                  com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getTargetFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          target_ = null;
          if (targetBuilder_ != null) {
            targetBuilder_.dispose();
            targetBuilder_ = null;
          }
          retentionDays_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dataform.v1.DataformProto
              .internal_static_google_cloud_dataform_v1_CompilationResultAction_DataPreparation_ErrorTable_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
            getDefaultInstanceForType() {
          return com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
            build() {
          com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
            buildPartial() {
          com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable result =
              new com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
                result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.target_ = targetBuilder_ == null ? target_ : targetBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.retentionDays_ = retentionDays_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable) {
            return mergeFrom(
                (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable other) {
          if (other
              == com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
                  .getDefaultInstance()) return this;
          if (other.hasTarget()) {
            mergeTarget(other.getTarget());
          }
          if (other.getRetentionDays() != 0) {
            setRetentionDays(other.getRetentionDays());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getTargetFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 16:
                  {
                    retentionDays_ = input.readInt32();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.dataform.v1.Target target_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.Target,
                com.google.cloud.dataform.v1.Target.Builder,
                com.google.cloud.dataform.v1.TargetOrBuilder>
            targetBuilder_;

        /**
         *
         *
         * <pre>
         * Error Table target.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.Target target = 1;</code>
         *
         * @return Whether the target field is set.
         */
        public boolean hasTarget() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * Error Table target.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.Target target = 1;</code>
         *
         * @return The target.
         */
        public com.google.cloud.dataform.v1.Target getTarget() {
          if (targetBuilder_ == null) {
            return target_ == null
                ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
                : target_;
          } else {
            return targetBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Error Table target.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.Target target = 1;</code>
         */
        public Builder setTarget(com.google.cloud.dataform.v1.Target value) {
          if (targetBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            target_ = value;
          } else {
            targetBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Error Table target.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.Target target = 1;</code>
         */
        public Builder setTarget(com.google.cloud.dataform.v1.Target.Builder builderForValue) {
          if (targetBuilder_ == null) {
            target_ = builderForValue.build();
          } else {
            targetBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Error Table target.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.Target target = 1;</code>
         */
        public Builder mergeTarget(com.google.cloud.dataform.v1.Target value) {
          if (targetBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && target_ != null
                && target_ != com.google.cloud.dataform.v1.Target.getDefaultInstance()) {
              getTargetBuilder().mergeFrom(value);
            } else {
              target_ = value;
            }
          } else {
            targetBuilder_.mergeFrom(value);
          }
          if (target_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Error Table target.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.Target target = 1;</code>
         */
        public Builder clearTarget() {
          bitField0_ = (bitField0_ & ~0x00000001);
          target_ = null;
          if (targetBuilder_ != null) {
            targetBuilder_.dispose();
            targetBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Error Table target.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.Target target = 1;</code>
         */
        public com.google.cloud.dataform.v1.Target.Builder getTargetBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getTargetFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Error Table target.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.Target target = 1;</code>
         */
        public com.google.cloud.dataform.v1.TargetOrBuilder getTargetOrBuilder() {
          if (targetBuilder_ != null) {
            return targetBuilder_.getMessageOrBuilder();
          } else {
            return target_ == null
                ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
                : target_;
          }
        }

        /**
         *
         *
         * <pre>
         * Error Table target.
         * </pre>
         *
         * <code>.google.cloud.dataform.v1.Target target = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.Target,
                com.google.cloud.dataform.v1.Target.Builder,
                com.google.cloud.dataform.v1.TargetOrBuilder>
            getTargetFieldBuilder() {
          if (targetBuilder_ == null) {
            targetBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.dataform.v1.Target,
                    com.google.cloud.dataform.v1.Target.Builder,
                    com.google.cloud.dataform.v1.TargetOrBuilder>(
                    getTarget(), getParentForChildren(), isClean());
            target_ = null;
          }
          return targetBuilder_;
        }

        private int retentionDays_;

        /**
         *
         *
         * <pre>
         * Error table partition expiration in days. Only positive values are
         * allowed.
         * </pre>
         *
         * <code>int32 retention_days = 2;</code>
         *
         * @return The retentionDays.
         */
        @java.lang.Override
        public int getRetentionDays() {
          return retentionDays_;
        }

        /**
         *
         *
         * <pre>
         * Error table partition expiration in days. Only positive values are
         * allowed.
         * </pre>
         *
         * <code>int32 retention_days = 2;</code>
         *
         * @param value The retentionDays to set.
         * @return This builder for chaining.
         */
        public Builder setRetentionDays(int value) {

          retentionDays_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Error table partition expiration in days. Only positive values are
         * allowed.
         * </pre>
         *
         * <code>int32 retention_days = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRetentionDays() {
          bitField0_ = (bitField0_ & ~0x00000002);
          retentionDays_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable)
      private static final com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
              .ErrorTable
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable();
      }

      public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ErrorTable> PARSER =
          new com.google.protobuf.AbstractParser<ErrorTable>() {
            @java.lang.Override
            public ErrorTable parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ErrorTable> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ErrorTable> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.ErrorTable
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int definitionCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object definition_;

    public enum DefinitionCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      CONTENTS_YAML(5),
      CONTENTS_SQL(6),
      DEFINITION_NOT_SET(0);
      private final int value;

      private DefinitionCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DefinitionCase valueOf(int value) {
        return forNumber(value);
      }

      public static DefinitionCase forNumber(int value) {
        switch (value) {
          case 5:
            return CONTENTS_YAML;
          case 6:
            return CONTENTS_SQL;
          case 0:
            return DEFINITION_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DefinitionCase getDefinitionCase() {
      return DefinitionCase.forNumber(definitionCase_);
    }

    public static final int CONTENTS_YAML_FIELD_NUMBER = 5;

    /**
     *
     *
     * <pre>
     * The data preparation definition, stored as a YAML string.
     * </pre>
     *
     * <code>string contents_yaml = 5;</code>
     *
     * @return Whether the contentsYaml field is set.
     */
    public boolean hasContentsYaml() {
      return definitionCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * The data preparation definition, stored as a YAML string.
     * </pre>
     *
     * <code>string contents_yaml = 5;</code>
     *
     * @return The contentsYaml.
     */
    public java.lang.String getContentsYaml() {
      java.lang.Object ref = "";
      if (definitionCase_ == 5) {
        ref = definition_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (definitionCase_ == 5) {
          definition_ = s;
        }
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The data preparation definition, stored as a YAML string.
     * </pre>
     *
     * <code>string contents_yaml = 5;</code>
     *
     * @return The bytes for contentsYaml.
     */
    public com.google.protobuf.ByteString getContentsYamlBytes() {
      java.lang.Object ref = "";
      if (definitionCase_ == 5) {
        ref = definition_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (definitionCase_ == 5) {
          definition_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONTENTS_SQL_FIELD_NUMBER = 6;

    /**
     *
     *
     * <pre>
     * SQL definition for a Data Preparation. Contains a SQL query and
     * additional context information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition contents_sql = 6;
     * </code>
     *
     * @return Whether the contentsSql field is set.
     */
    @java.lang.Override
    public boolean hasContentsSql() {
      return definitionCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * SQL definition for a Data Preparation. Contains a SQL query and
     * additional context information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition contents_sql = 6;
     * </code>
     *
     * @return The contentsSql.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
        getContentsSql() {
      if (definitionCase_ == 6) {
        return (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition)
            definition_;
      }
      return com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * SQL definition for a Data Preparation. Contains a SQL query and
     * additional context information.
     * </pre>
     *
     * <code>
     * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition contents_sql = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
            .SqlDefinitionOrBuilder
        getContentsSqlOrBuilder() {
      if (definitionCase_ == 6) {
        return (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition)
            definition_;
      }
      return com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
          .getDefaultInstance();
    }

    public static final int DEPENDENCY_TARGETS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.dataform.v1.Target> dependencyTargets_;

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.dataform.v1.Target> getDependencyTargetsList() {
      return dependencyTargets_;
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.dataform.v1.TargetOrBuilder>
        getDependencyTargetsOrBuilderList() {
      return dependencyTargets_;
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public int getDependencyTargetsCount() {
      return dependencyTargets_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.Target getDependencyTargets(int index) {
      return dependencyTargets_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of actions that this action depends on.
     * </pre>
     *
     * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.TargetOrBuilder getDependencyTargetsOrBuilder(int index) {
      return dependencyTargets_.get(index);
    }

    public static final int DISABLED_FIELD_NUMBER = 2;
    private boolean disabled_ = false;

    /**
     *
     *
     * <pre>
     * Whether this action is disabled (i.e. should not be run).
     * </pre>
     *
     * <code>bool disabled = 2;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }

    public static final int TAGS_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList tags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      return tags_;
    }

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Arbitrary, user-defined tags on this action.
     * </pre>
     *
     * <code>repeated string tags = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < dependencyTargets_.size(); i++) {
        output.writeMessage(1, dependencyTargets_.get(i));
      }
      if (disabled_ != false) {
        output.writeBool(2, disabled_);
      }
      for (int i = 0; i < tags_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, tags_.getRaw(i));
      }
      if (definitionCase_ == 5) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, definition_);
      }
      if (definitionCase_ == 6) {
        output.writeMessage(
            6,
            (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition)
                definition_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < dependencyTargets_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, dependencyTargets_.get(i));
      }
      if (disabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, disabled_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < tags_.size(); i++) {
          dataSize += computeStringSizeNoTag(tags_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getTagsList().size();
      }
      if (definitionCase_ == 5) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, definition_);
      }
      if (definitionCase_ == 6) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                6,
                (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition)
                    definition_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation)) {
        return super.equals(obj);
      }
      com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation other =
          (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation) obj;

      if (!getDependencyTargetsList().equals(other.getDependencyTargetsList())) return false;
      if (getDisabled() != other.getDisabled()) return false;
      if (!getTagsList().equals(other.getTagsList())) return false;
      if (!getDefinitionCase().equals(other.getDefinitionCase())) return false;
      switch (definitionCase_) {
        case 5:
          if (!getContentsYaml().equals(other.getContentsYaml())) return false;
          break;
        case 6:
          if (!getContentsSql().equals(other.getContentsSql())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDependencyTargetsCount() > 0) {
        hash = (37 * hash) + DEPENDENCY_TARGETS_FIELD_NUMBER;
        hash = (53 * hash) + getDependencyTargetsList().hashCode();
      }
      hash = (37 * hash) + DISABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
      if (getTagsCount() > 0) {
        hash = (37 * hash) + TAGS_FIELD_NUMBER;
        hash = (53 * hash) + getTagsList().hashCode();
      }
      switch (definitionCase_) {
        case 5:
          hash = (37 * hash) + CONTENTS_YAML_FIELD_NUMBER;
          hash = (53 * hash) + getContentsYaml().hashCode();
          break;
        case 6:
          hash = (37 * hash) + CONTENTS_SQL_FIELD_NUMBER;
          hash = (53 * hash) + getContentsSql().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Defines a compiled Data Preparation entity
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction.DataPreparation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.CompilationResultAction.DataPreparation)
        com.google.cloud.dataform.v1.CompilationResultAction.DataPreparationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_DataPreparation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_DataPreparation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.class,
                com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.Builder.class);
      }

      // Construct using
      // com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (contentsSqlBuilder_ != null) {
          contentsSqlBuilder_.clear();
        }
        if (dependencyTargetsBuilder_ == null) {
          dependencyTargets_ = java.util.Collections.emptyList();
        } else {
          dependencyTargets_ = null;
          dependencyTargetsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        disabled_ = false;
        tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
        definitionCase_ = 0;
        definition_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_DataPreparation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
          getDefaultInstanceForType() {
        return com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation build() {
        com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation buildPartial() {
        com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation result =
            new com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation result) {
        if (dependencyTargetsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            dependencyTargets_ = java.util.Collections.unmodifiableList(dependencyTargets_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.dependencyTargets_ = dependencyTargets_;
        } else {
          result.dependencyTargets_ = dependencyTargetsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.disabled_ = disabled_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          tags_.makeImmutable();
          result.tags_ = tags_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation result) {
        result.definitionCase_ = definitionCase_;
        result.definition_ = this.definition_;
        if (definitionCase_ == 6 && contentsSqlBuilder_ != null) {
          result.definition_ = contentsSqlBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation) {
          return mergeFrom(
              (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation other) {
        if (other
            == com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
                .getDefaultInstance()) return this;
        if (dependencyTargetsBuilder_ == null) {
          if (!other.dependencyTargets_.isEmpty()) {
            if (dependencyTargets_.isEmpty()) {
              dependencyTargets_ = other.dependencyTargets_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureDependencyTargetsIsMutable();
              dependencyTargets_.addAll(other.dependencyTargets_);
            }
            onChanged();
          }
        } else {
          if (!other.dependencyTargets_.isEmpty()) {
            if (dependencyTargetsBuilder_.isEmpty()) {
              dependencyTargetsBuilder_.dispose();
              dependencyTargetsBuilder_ = null;
              dependencyTargets_ = other.dependencyTargets_;
              bitField0_ = (bitField0_ & ~0x00000004);
              dependencyTargetsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDependencyTargetsFieldBuilder()
                      : null;
            } else {
              dependencyTargetsBuilder_.addAllMessages(other.dependencyTargets_);
            }
          }
        }
        if (other.getDisabled() != false) {
          setDisabled(other.getDisabled());
        }
        if (!other.tags_.isEmpty()) {
          if (tags_.isEmpty()) {
            tags_ = other.tags_;
            bitField0_ |= 0x00000010;
          } else {
            ensureTagsIsMutable();
            tags_.addAll(other.tags_);
          }
          onChanged();
        }
        switch (other.getDefinitionCase()) {
          case CONTENTS_YAML:
            {
              definitionCase_ = 5;
              definition_ = other.definition_;
              onChanged();
              break;
            }
          case CONTENTS_SQL:
            {
              mergeContentsSql(other.getContentsSql());
              break;
            }
          case DEFINITION_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.dataform.v1.Target m =
                      input.readMessage(
                          com.google.cloud.dataform.v1.Target.parser(), extensionRegistry);
                  if (dependencyTargetsBuilder_ == null) {
                    ensureDependencyTargetsIsMutable();
                    dependencyTargets_.add(m);
                  } else {
                    dependencyTargetsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 16:
                {
                  disabled_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 16
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureTagsIsMutable();
                  tags_.add(s);
                  break;
                } // case 34
              case 42:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  definitionCase_ = 5;
                  definition_ = s;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(getContentsSqlFieldBuilder().getBuilder(), extensionRegistry);
                  definitionCase_ = 6;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int definitionCase_ = 0;
      private java.lang.Object definition_;

      public DefinitionCase getDefinitionCase() {
        return DefinitionCase.forNumber(definitionCase_);
      }

      public Builder clearDefinition() {
        definitionCase_ = 0;
        definition_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * The data preparation definition, stored as a YAML string.
       * </pre>
       *
       * <code>string contents_yaml = 5;</code>
       *
       * @return Whether the contentsYaml field is set.
       */
      @java.lang.Override
      public boolean hasContentsYaml() {
        return definitionCase_ == 5;
      }

      /**
       *
       *
       * <pre>
       * The data preparation definition, stored as a YAML string.
       * </pre>
       *
       * <code>string contents_yaml = 5;</code>
       *
       * @return The contentsYaml.
       */
      @java.lang.Override
      public java.lang.String getContentsYaml() {
        java.lang.Object ref = "";
        if (definitionCase_ == 5) {
          ref = definition_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (definitionCase_ == 5) {
            definition_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The data preparation definition, stored as a YAML string.
       * </pre>
       *
       * <code>string contents_yaml = 5;</code>
       *
       * @return The bytes for contentsYaml.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getContentsYamlBytes() {
        java.lang.Object ref = "";
        if (definitionCase_ == 5) {
          ref = definition_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (definitionCase_ == 5) {
            definition_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The data preparation definition, stored as a YAML string.
       * </pre>
       *
       * <code>string contents_yaml = 5;</code>
       *
       * @param value The contentsYaml to set.
       * @return This builder for chaining.
       */
      public Builder setContentsYaml(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        definitionCase_ = 5;
        definition_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The data preparation definition, stored as a YAML string.
       * </pre>
       *
       * <code>string contents_yaml = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContentsYaml() {
        if (definitionCase_ == 5) {
          definitionCase_ = 0;
          definition_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The data preparation definition, stored as a YAML string.
       * </pre>
       *
       * <code>string contents_yaml = 5;</code>
       *
       * @param value The bytes for contentsYaml to set.
       * @return This builder for chaining.
       */
      public Builder setContentsYamlBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        definitionCase_ = 5;
        definition_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition,
              com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
                  .Builder,
              com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
                  .SqlDefinitionOrBuilder>
          contentsSqlBuilder_;

      /**
       *
       *
       * <pre>
       * SQL definition for a Data Preparation. Contains a SQL query and
       * additional context information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition contents_sql = 6;
       * </code>
       *
       * @return Whether the contentsSql field is set.
       */
      @java.lang.Override
      public boolean hasContentsSql() {
        return definitionCase_ == 6;
      }

      /**
       *
       *
       * <pre>
       * SQL definition for a Data Preparation. Contains a SQL query and
       * additional context information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition contents_sql = 6;
       * </code>
       *
       * @return The contentsSql.
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
          getContentsSql() {
        if (contentsSqlBuilder_ == null) {
          if (definitionCase_ == 6) {
            return (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
                    .SqlDefinition)
                definition_;
          }
          return com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
              .getDefaultInstance();
        } else {
          if (definitionCase_ == 6) {
            return contentsSqlBuilder_.getMessage();
          }
          return com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * SQL definition for a Data Preparation. Contains a SQL query and
       * additional context information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition contents_sql = 6;
       * </code>
       */
      public Builder setContentsSql(
          com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
              value) {
        if (contentsSqlBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          definition_ = value;
          onChanged();
        } else {
          contentsSqlBuilder_.setMessage(value);
        }
        definitionCase_ = 6;
        return this;
      }

      /**
       *
       *
       * <pre>
       * SQL definition for a Data Preparation. Contains a SQL query and
       * additional context information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition contents_sql = 6;
       * </code>
       */
      public Builder setContentsSql(
          com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition.Builder
              builderForValue) {
        if (contentsSqlBuilder_ == null) {
          definition_ = builderForValue.build();
          onChanged();
        } else {
          contentsSqlBuilder_.setMessage(builderForValue.build());
        }
        definitionCase_ = 6;
        return this;
      }

      /**
       *
       *
       * <pre>
       * SQL definition for a Data Preparation. Contains a SQL query and
       * additional context information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition contents_sql = 6;
       * </code>
       */
      public Builder mergeContentsSql(
          com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
              value) {
        if (contentsSqlBuilder_ == null) {
          if (definitionCase_ == 6
              && definition_
                  != com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
                      .SqlDefinition.getDefaultInstance()) {
            definition_ =
                com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
                    .newBuilder(
                        (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
                                .SqlDefinition)
                            definition_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            definition_ = value;
          }
          onChanged();
        } else {
          if (definitionCase_ == 6) {
            contentsSqlBuilder_.mergeFrom(value);
          } else {
            contentsSqlBuilder_.setMessage(value);
          }
        }
        definitionCase_ = 6;
        return this;
      }

      /**
       *
       *
       * <pre>
       * SQL definition for a Data Preparation. Contains a SQL query and
       * additional context information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition contents_sql = 6;
       * </code>
       */
      public Builder clearContentsSql() {
        if (contentsSqlBuilder_ == null) {
          if (definitionCase_ == 6) {
            definitionCase_ = 0;
            definition_ = null;
            onChanged();
          }
        } else {
          if (definitionCase_ == 6) {
            definitionCase_ = 0;
            definition_ = null;
          }
          contentsSqlBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * SQL definition for a Data Preparation. Contains a SQL query and
       * additional context information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition contents_sql = 6;
       * </code>
       */
      public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
              .Builder
          getContentsSqlBuilder() {
        return getContentsSqlFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * SQL definition for a Data Preparation. Contains a SQL query and
       * additional context information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition contents_sql = 6;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
              .SqlDefinitionOrBuilder
          getContentsSqlOrBuilder() {
        if ((definitionCase_ == 6) && (contentsSqlBuilder_ != null)) {
          return contentsSqlBuilder_.getMessageOrBuilder();
        } else {
          if (definitionCase_ == 6) {
            return (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
                    .SqlDefinition)
                definition_;
          }
          return com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * SQL definition for a Data Preparation. Contains a SQL query and
       * additional context information.
       * </pre>
       *
       * <code>
       * .google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition contents_sql = 6;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition,
              com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
                  .Builder,
              com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
                  .SqlDefinitionOrBuilder>
          getContentsSqlFieldBuilder() {
        if (contentsSqlBuilder_ == null) {
          if (!(definitionCase_ == 6)) {
            definition_ =
                com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
                    .getDefaultInstance();
          }
          contentsSqlBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
                      .SqlDefinition,
                  com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.SqlDefinition
                      .Builder,
                  com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
                      .SqlDefinitionOrBuilder>(
                  (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
                          .SqlDefinition)
                      definition_,
                  getParentForChildren(),
                  isClean());
          definition_ = null;
        }
        definitionCase_ = 6;
        onChanged();
        return contentsSqlBuilder_;
      }

      private java.util.List<com.google.cloud.dataform.v1.Target> dependencyTargets_ =
          java.util.Collections.emptyList();

      private void ensureDependencyTargetsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          dependencyTargets_ =
              new java.util.ArrayList<com.google.cloud.dataform.v1.Target>(dependencyTargets_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dataform.v1.Target,
              com.google.cloud.dataform.v1.Target.Builder,
              com.google.cloud.dataform.v1.TargetOrBuilder>
          dependencyTargetsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public java.util.List<com.google.cloud.dataform.v1.Target> getDependencyTargetsList() {
        if (dependencyTargetsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(dependencyTargets_);
        } else {
          return dependencyTargetsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public int getDependencyTargetsCount() {
        if (dependencyTargetsBuilder_ == null) {
          return dependencyTargets_.size();
        } else {
          return dependencyTargetsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target getDependencyTargets(int index) {
        if (dependencyTargetsBuilder_ == null) {
          return dependencyTargets_.get(index);
        } else {
          return dependencyTargetsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder setDependencyTargets(int index, com.google.cloud.dataform.v1.Target value) {
        if (dependencyTargetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.set(index, value);
          onChanged();
        } else {
          dependencyTargetsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder setDependencyTargets(
          int index, com.google.cloud.dataform.v1.Target.Builder builderForValue) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.set(index, builderForValue.build());
          onChanged();
        } else {
          dependencyTargetsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(com.google.cloud.dataform.v1.Target value) {
        if (dependencyTargetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(value);
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(int index, com.google.cloud.dataform.v1.Target value) {
        if (dependencyTargetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(index, value);
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(
          com.google.cloud.dataform.v1.Target.Builder builderForValue) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(builderForValue.build());
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addDependencyTargets(
          int index, com.google.cloud.dataform.v1.Target.Builder builderForValue) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.add(index, builderForValue.build());
          onChanged();
        } else {
          dependencyTargetsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder addAllDependencyTargets(
          java.lang.Iterable<? extends com.google.cloud.dataform.v1.Target> values) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dependencyTargets_);
          onChanged();
        } else {
          dependencyTargetsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder clearDependencyTargets() {
        if (dependencyTargetsBuilder_ == null) {
          dependencyTargets_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          dependencyTargetsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public Builder removeDependencyTargets(int index) {
        if (dependencyTargetsBuilder_ == null) {
          ensureDependencyTargetsIsMutable();
          dependencyTargets_.remove(index);
          onChanged();
        } else {
          dependencyTargetsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target.Builder getDependencyTargetsBuilder(int index) {
        return getDependencyTargetsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.TargetOrBuilder getDependencyTargetsOrBuilder(int index) {
        if (dependencyTargetsBuilder_ == null) {
          return dependencyTargets_.get(index);
        } else {
          return dependencyTargetsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public java.util.List<? extends com.google.cloud.dataform.v1.TargetOrBuilder>
          getDependencyTargetsOrBuilderList() {
        if (dependencyTargetsBuilder_ != null) {
          return dependencyTargetsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(dependencyTargets_);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target.Builder addDependencyTargetsBuilder() {
        return getDependencyTargetsFieldBuilder()
            .addBuilder(com.google.cloud.dataform.v1.Target.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public com.google.cloud.dataform.v1.Target.Builder addDependencyTargetsBuilder(int index) {
        return getDependencyTargetsFieldBuilder()
            .addBuilder(index, com.google.cloud.dataform.v1.Target.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * A list of actions that this action depends on.
       * </pre>
       *
       * <code>repeated .google.cloud.dataform.v1.Target dependency_targets = 1;</code>
       */
      public java.util.List<com.google.cloud.dataform.v1.Target.Builder>
          getDependencyTargetsBuilderList() {
        return getDependencyTargetsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dataform.v1.Target,
              com.google.cloud.dataform.v1.Target.Builder,
              com.google.cloud.dataform.v1.TargetOrBuilder>
          getDependencyTargetsFieldBuilder() {
        if (dependencyTargetsBuilder_ == null) {
          dependencyTargetsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dataform.v1.Target,
                  com.google.cloud.dataform.v1.Target.Builder,
                  com.google.cloud.dataform.v1.TargetOrBuilder>(
                  dependencyTargets_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          dependencyTargets_ = null;
        }
        return dependencyTargetsBuilder_;
      }

      private boolean disabled_;

      /**
       *
       *
       * <pre>
       * Whether this action is disabled (i.e. should not be run).
       * </pre>
       *
       * <code>bool disabled = 2;</code>
       *
       * @return The disabled.
       */
      @java.lang.Override
      public boolean getDisabled() {
        return disabled_;
      }

      /**
       *
       *
       * <pre>
       * Whether this action is disabled (i.e. should not be run).
       * </pre>
       *
       * <code>bool disabled = 2;</code>
       *
       * @param value The disabled to set.
       * @return This builder for chaining.
       */
      public Builder setDisabled(boolean value) {

        disabled_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Whether this action is disabled (i.e. should not be run).
       * </pre>
       *
       * <code>bool disabled = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisabled() {
        bitField0_ = (bitField0_ & ~0x00000008);
        disabled_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList tags_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureTagsIsMutable() {
        if (!tags_.isModifiable()) {
          tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
        }
        bitField0_ |= 0x00000010;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 4;</code>
       *
       * @return A list containing the tags.
       */
      public com.google.protobuf.ProtocolStringList getTagsList() {
        tags_.makeImmutable();
        return tags_;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 4;</code>
       *
       * @return The count of tags.
       */
      public int getTagsCount() {
        return tags_.size();
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 4;</code>
       *
       * @param index The index of the element to return.
       * @return The tags at the given index.
       */
      public java.lang.String getTags(int index) {
        return tags_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 4;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the tags at the given index.
       */
      public com.google.protobuf.ByteString getTagsBytes(int index) {
        return tags_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 4;</code>
       *
       * @param index The index to set the value at.
       * @param value The tags to set.
       * @return This builder for chaining.
       */
      public Builder setTags(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.set(index, value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 4;</code>
       *
       * @param value The tags to add.
       * @return This builder for chaining.
       */
      public Builder addTags(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.add(value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 4;</code>
       *
       * @param values The tags to add.
       * @return This builder for chaining.
       */
      public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
        ensureTagsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTags() {
        tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Arbitrary, user-defined tags on this action.
       * </pre>
       *
       * <code>repeated string tags = 4;</code>
       *
       * @param value The bytes of the tags to add.
       * @return This builder for chaining.
       */
      public Builder addTagsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureTagsIsMutable();
        tags_.add(value);
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.CompilationResultAction.DataPreparation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.CompilationResultAction.DataPreparation)
    private static final com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation();
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DataPreparation> PARSER =
        new com.google.protobuf.AbstractParser<DataPreparation>() {
          @java.lang.Override
          public DataPreparation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DataPreparation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DataPreparation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface LoadConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.CompilationResultAction.LoadConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Replace destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode replace = 1;</code>
     *
     * @return Whether the replace field is set.
     */
    boolean hasReplace();

    /**
     *
     *
     * <pre>
     * Replace destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode replace = 1;</code>
     *
     * @return The replace.
     */
    com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode getReplace();

    /**
     *
     *
     * <pre>
     * Replace destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode replace = 1;</code>
     */
    com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadModeOrBuilder
        getReplaceOrBuilder();

    /**
     *
     *
     * <pre>
     * Append into destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode append = 2;</code>
     *
     * @return Whether the append field is set.
     */
    boolean hasAppend();

    /**
     *
     *
     * <pre>
     * Append into destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode append = 2;</code>
     *
     * @return The append.
     */
    com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode getAppend();

    /**
     *
     *
     * <pre>
     * Append into destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode append = 2;</code>
     */
    com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadModeOrBuilder
        getAppendOrBuilder();

    /**
     *
     *
     * <pre>
     * Insert records where the value exceeds the previous maximum value for a
     * column in the destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode maximum = 3;
     * </code>
     *
     * @return Whether the maximum field is set.
     */
    boolean hasMaximum();

    /**
     *
     *
     * <pre>
     * Insert records where the value exceeds the previous maximum value for a
     * column in the destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode maximum = 3;
     * </code>
     *
     * @return The maximum.
     */
    com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode getMaximum();

    /**
     *
     *
     * <pre>
     * Insert records where the value exceeds the previous maximum value for a
     * column in the destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode maximum = 3;
     * </code>
     */
    com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadModeOrBuilder
        getMaximumOrBuilder();

    /**
     *
     *
     * <pre>
     * Insert records where the value of a column is not already present in
     * the destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode unique = 4;
     * </code>
     *
     * @return Whether the unique field is set.
     */
    boolean hasUnique();

    /**
     *
     *
     * <pre>
     * Insert records where the value of a column is not already present in
     * the destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode unique = 4;
     * </code>
     *
     * @return The unique.
     */
    com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode getUnique();

    /**
     *
     *
     * <pre>
     * Insert records where the value of a column is not already present in
     * the destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode unique = 4;
     * </code>
     */
    com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadModeOrBuilder
        getUniqueOrBuilder();

    com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig.ModeCase getModeCase();
  }

  /**
   *
   *
   * <pre>
   * Simplified load configuration for actions
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction.LoadConfig}
   */
  public static final class LoadConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.CompilationResultAction.LoadConfig)
      LoadConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use LoadConfig.newBuilder() to construct.
    private LoadConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LoadConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LoadConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_LoadConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_LoadConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig.class,
              com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig.Builder.class);
    }

    private int modeCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object mode_;

    public enum ModeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      REPLACE(1),
      APPEND(2),
      MAXIMUM(3),
      UNIQUE(4),
      MODE_NOT_SET(0);
      private final int value;

      private ModeCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ModeCase valueOf(int value) {
        return forNumber(value);
      }

      public static ModeCase forNumber(int value) {
        switch (value) {
          case 1:
            return REPLACE;
          case 2:
            return APPEND;
          case 3:
            return MAXIMUM;
          case 4:
            return UNIQUE;
          case 0:
            return MODE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ModeCase getModeCase() {
      return ModeCase.forNumber(modeCase_);
    }

    public static final int REPLACE_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * Replace destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode replace = 1;</code>
     *
     * @return Whether the replace field is set.
     */
    @java.lang.Override
    public boolean hasReplace() {
      return modeCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Replace destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode replace = 1;</code>
     *
     * @return The replace.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode getReplace() {
      if (modeCase_ == 1) {
        return (com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode) mode_;
      }
      return com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Replace destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode replace = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadModeOrBuilder
        getReplaceOrBuilder() {
      if (modeCase_ == 1) {
        return (com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode) mode_;
      }
      return com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
          .getDefaultInstance();
    }

    public static final int APPEND_FIELD_NUMBER = 2;

    /**
     *
     *
     * <pre>
     * Append into destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode append = 2;</code>
     *
     * @return Whether the append field is set.
     */
    @java.lang.Override
    public boolean hasAppend() {
      return modeCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Append into destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode append = 2;</code>
     *
     * @return The append.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode getAppend() {
      if (modeCase_ == 2) {
        return (com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode) mode_;
      }
      return com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Append into destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode append = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadModeOrBuilder
        getAppendOrBuilder() {
      if (modeCase_ == 2) {
        return (com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode) mode_;
      }
      return com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
          .getDefaultInstance();
    }

    public static final int MAXIMUM_FIELD_NUMBER = 3;

    /**
     *
     *
     * <pre>
     * Insert records where the value exceeds the previous maximum value for a
     * column in the destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode maximum = 3;
     * </code>
     *
     * @return Whether the maximum field is set.
     */
    @java.lang.Override
    public boolean hasMaximum() {
      return modeCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Insert records where the value exceeds the previous maximum value for a
     * column in the destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode maximum = 3;
     * </code>
     *
     * @return The maximum.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode getMaximum() {
      if (modeCase_ == 3) {
        return (com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode) mode_;
      }
      return com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Insert records where the value exceeds the previous maximum value for a
     * column in the destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode maximum = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadModeOrBuilder
        getMaximumOrBuilder() {
      if (modeCase_ == 3) {
        return (com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode) mode_;
      }
      return com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
          .getDefaultInstance();
    }

    public static final int UNIQUE_FIELD_NUMBER = 4;

    /**
     *
     *
     * <pre>
     * Insert records where the value of a column is not already present in
     * the destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode unique = 4;
     * </code>
     *
     * @return Whether the unique field is set.
     */
    @java.lang.Override
    public boolean hasUnique() {
      return modeCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Insert records where the value of a column is not already present in
     * the destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode unique = 4;
     * </code>
     *
     * @return The unique.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode getUnique() {
      if (modeCase_ == 4) {
        return (com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode) mode_;
      }
      return com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Insert records where the value of a column is not already present in
     * the destination table
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode unique = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadModeOrBuilder
        getUniqueOrBuilder() {
      if (modeCase_ == 4) {
        return (com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode) mode_;
      }
      return com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (modeCase_ == 1) {
        output.writeMessage(
            1, (com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode) mode_);
      }
      if (modeCase_ == 2) {
        output.writeMessage(
            2, (com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode) mode_);
      }
      if (modeCase_ == 3) {
        output.writeMessage(
            3, (com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode) mode_);
      }
      if (modeCase_ == 4) {
        output.writeMessage(
            4, (com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode) mode_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (modeCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode) mode_);
      }
      if (modeCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode) mode_);
      }
      if (modeCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3,
                (com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode) mode_);
      }
      if (modeCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4,
                (com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode) mode_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig other =
          (com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig) obj;

      if (!getModeCase().equals(other.getModeCase())) return false;
      switch (modeCase_) {
        case 1:
          if (!getReplace().equals(other.getReplace())) return false;
          break;
        case 2:
          if (!getAppend().equals(other.getAppend())) return false;
          break;
        case 3:
          if (!getMaximum().equals(other.getMaximum())) return false;
          break;
        case 4:
          if (!getUnique().equals(other.getUnique())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (modeCase_) {
        case 1:
          hash = (37 * hash) + REPLACE_FIELD_NUMBER;
          hash = (53 * hash) + getReplace().hashCode();
          break;
        case 2:
          hash = (37 * hash) + APPEND_FIELD_NUMBER;
          hash = (53 * hash) + getAppend().hashCode();
          break;
        case 3:
          hash = (37 * hash) + MAXIMUM_FIELD_NUMBER;
          hash = (53 * hash) + getMaximum().hashCode();
          break;
        case 4:
          hash = (37 * hash) + UNIQUE_FIELD_NUMBER;
          hash = (53 * hash) + getUnique().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Simplified load configuration for actions
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction.LoadConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.CompilationResultAction.LoadConfig)
        com.google.cloud.dataform.v1.CompilationResultAction.LoadConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_LoadConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_LoadConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig.class,
                com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (replaceBuilder_ != null) {
          replaceBuilder_.clear();
        }
        if (appendBuilder_ != null) {
          appendBuilder_.clear();
        }
        if (maximumBuilder_ != null) {
          maximumBuilder_.clear();
        }
        if (uniqueBuilder_ != null) {
          uniqueBuilder_.clear();
        }
        modeCase_ = 0;
        mode_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_LoadConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig build() {
        com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig buildPartial() {
        com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig result =
            new com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig result) {
        result.modeCase_ = modeCase_;
        result.mode_ = this.mode_;
        if (modeCase_ == 1 && replaceBuilder_ != null) {
          result.mode_ = replaceBuilder_.build();
        }
        if (modeCase_ == 2 && appendBuilder_ != null) {
          result.mode_ = appendBuilder_.build();
        }
        if (modeCase_ == 3 && maximumBuilder_ != null) {
          result.mode_ = maximumBuilder_.build();
        }
        if (modeCase_ == 4 && uniqueBuilder_ != null) {
          result.mode_ = uniqueBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig) {
          return mergeFrom((com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig other) {
        if (other
            == com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig.getDefaultInstance())
          return this;
        switch (other.getModeCase()) {
          case REPLACE:
            {
              mergeReplace(other.getReplace());
              break;
            }
          case APPEND:
            {
              mergeAppend(other.getAppend());
              break;
            }
          case MAXIMUM:
            {
              mergeMaximum(other.getMaximum());
              break;
            }
          case UNIQUE:
            {
              mergeUnique(other.getUnique());
              break;
            }
          case MODE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getReplaceFieldBuilder().getBuilder(), extensionRegistry);
                  modeCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getAppendFieldBuilder().getBuilder(), extensionRegistry);
                  modeCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getMaximumFieldBuilder().getBuilder(), extensionRegistry);
                  modeCase_ = 3;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getUniqueFieldBuilder().getBuilder(), extensionRegistry);
                  modeCase_ = 4;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int modeCase_ = 0;
      private java.lang.Object mode_;

      public ModeCase getModeCase() {
        return ModeCase.forNumber(modeCase_);
      }

      public Builder clearMode() {
        modeCase_ = 0;
        mode_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode,
              com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode.Builder,
              com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadModeOrBuilder>
          replaceBuilder_;

      /**
       *
       *
       * <pre>
       * Replace destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode replace = 1;</code>
       *
       * @return Whether the replace field is set.
       */
      @java.lang.Override
      public boolean hasReplace() {
        return modeCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Replace destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode replace = 1;</code>
       *
       * @return The replace.
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode getReplace() {
        if (replaceBuilder_ == null) {
          if (modeCase_ == 1) {
            return (com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode) mode_;
          }
          return com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
              .getDefaultInstance();
        } else {
          if (modeCase_ == 1) {
            return replaceBuilder_.getMessage();
          }
          return com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Replace destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode replace = 1;</code>
       */
      public Builder setReplace(
          com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode value) {
        if (replaceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          mode_ = value;
          onChanged();
        } else {
          replaceBuilder_.setMessage(value);
        }
        modeCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Replace destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode replace = 1;</code>
       */
      public Builder setReplace(
          com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode.Builder
              builderForValue) {
        if (replaceBuilder_ == null) {
          mode_ = builderForValue.build();
          onChanged();
        } else {
          replaceBuilder_.setMessage(builderForValue.build());
        }
        modeCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Replace destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode replace = 1;</code>
       */
      public Builder mergeReplace(
          com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode value) {
        if (replaceBuilder_ == null) {
          if (modeCase_ == 1
              && mode_
                  != com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
                      .getDefaultInstance()) {
            mode_ =
                com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode.newBuilder(
                        (com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode) mode_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            mode_ = value;
          }
          onChanged();
        } else {
          if (modeCase_ == 1) {
            replaceBuilder_.mergeFrom(value);
          } else {
            replaceBuilder_.setMessage(value);
          }
        }
        modeCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Replace destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode replace = 1;</code>
       */
      public Builder clearReplace() {
        if (replaceBuilder_ == null) {
          if (modeCase_ == 1) {
            modeCase_ = 0;
            mode_ = null;
            onChanged();
          }
        } else {
          if (modeCase_ == 1) {
            modeCase_ = 0;
            mode_ = null;
          }
          replaceBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Replace destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode replace = 1;</code>
       */
      public com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode.Builder
          getReplaceBuilder() {
        return getReplaceFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Replace destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode replace = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadModeOrBuilder
          getReplaceOrBuilder() {
        if ((modeCase_ == 1) && (replaceBuilder_ != null)) {
          return replaceBuilder_.getMessageOrBuilder();
        } else {
          if (modeCase_ == 1) {
            return (com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode) mode_;
          }
          return com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Replace destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode replace = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode,
              com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode.Builder,
              com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadModeOrBuilder>
          getReplaceFieldBuilder() {
        if (replaceBuilder_ == null) {
          if (!(modeCase_ == 1)) {
            mode_ =
                com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
                    .getDefaultInstance();
          }
          replaceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode,
                  com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode.Builder,
                  com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadModeOrBuilder>(
                  (com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode) mode_,
                  getParentForChildren(),
                  isClean());
          mode_ = null;
        }
        modeCase_ = 1;
        onChanged();
        return replaceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode,
              com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode.Builder,
              com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadModeOrBuilder>
          appendBuilder_;

      /**
       *
       *
       * <pre>
       * Append into destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode append = 2;</code>
       *
       * @return Whether the append field is set.
       */
      @java.lang.Override
      public boolean hasAppend() {
        return modeCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Append into destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode append = 2;</code>
       *
       * @return The append.
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode getAppend() {
        if (appendBuilder_ == null) {
          if (modeCase_ == 2) {
            return (com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode) mode_;
          }
          return com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
              .getDefaultInstance();
        } else {
          if (modeCase_ == 2) {
            return appendBuilder_.getMessage();
          }
          return com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Append into destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode append = 2;</code>
       */
      public Builder setAppend(
          com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode value) {
        if (appendBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          mode_ = value;
          onChanged();
        } else {
          appendBuilder_.setMessage(value);
        }
        modeCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Append into destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode append = 2;</code>
       */
      public Builder setAppend(
          com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode.Builder
              builderForValue) {
        if (appendBuilder_ == null) {
          mode_ = builderForValue.build();
          onChanged();
        } else {
          appendBuilder_.setMessage(builderForValue.build());
        }
        modeCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Append into destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode append = 2;</code>
       */
      public Builder mergeAppend(
          com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode value) {
        if (appendBuilder_ == null) {
          if (modeCase_ == 2
              && mode_
                  != com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
                      .getDefaultInstance()) {
            mode_ =
                com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode.newBuilder(
                        (com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode) mode_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            mode_ = value;
          }
          onChanged();
        } else {
          if (modeCase_ == 2) {
            appendBuilder_.mergeFrom(value);
          } else {
            appendBuilder_.setMessage(value);
          }
        }
        modeCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Append into destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode append = 2;</code>
       */
      public Builder clearAppend() {
        if (appendBuilder_ == null) {
          if (modeCase_ == 2) {
            modeCase_ = 0;
            mode_ = null;
            onChanged();
          }
        } else {
          if (modeCase_ == 2) {
            modeCase_ = 0;
            mode_ = null;
          }
          appendBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Append into destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode append = 2;</code>
       */
      public com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode.Builder
          getAppendBuilder() {
        return getAppendFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Append into destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode append = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadModeOrBuilder
          getAppendOrBuilder() {
        if ((modeCase_ == 2) && (appendBuilder_ != null)) {
          return appendBuilder_.getMessageOrBuilder();
        } else {
          if (modeCase_ == 2) {
            return (com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode) mode_;
          }
          return com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Append into destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode append = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode,
              com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode.Builder,
              com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadModeOrBuilder>
          getAppendFieldBuilder() {
        if (appendBuilder_ == null) {
          if (!(modeCase_ == 2)) {
            mode_ =
                com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
                    .getDefaultInstance();
          }
          appendBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode,
                  com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode.Builder,
                  com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadModeOrBuilder>(
                  (com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode) mode_,
                  getParentForChildren(),
                  isClean());
          mode_ = null;
        }
        modeCase_ = 2;
        onChanged();
        return appendBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode,
              com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode.Builder,
              com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadModeOrBuilder>
          maximumBuilder_;

      /**
       *
       *
       * <pre>
       * Insert records where the value exceeds the previous maximum value for a
       * column in the destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode maximum = 3;
       * </code>
       *
       * @return Whether the maximum field is set.
       */
      @java.lang.Override
      public boolean hasMaximum() {
        return modeCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value exceeds the previous maximum value for a
       * column in the destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode maximum = 3;
       * </code>
       *
       * @return The maximum.
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode getMaximum() {
        if (maximumBuilder_ == null) {
          if (modeCase_ == 3) {
            return (com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode) mode_;
          }
          return com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
              .getDefaultInstance();
        } else {
          if (modeCase_ == 3) {
            return maximumBuilder_.getMessage();
          }
          return com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value exceeds the previous maximum value for a
       * column in the destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode maximum = 3;
       * </code>
       */
      public Builder setMaximum(
          com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode value) {
        if (maximumBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          mode_ = value;
          onChanged();
        } else {
          maximumBuilder_.setMessage(value);
        }
        modeCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value exceeds the previous maximum value for a
       * column in the destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode maximum = 3;
       * </code>
       */
      public Builder setMaximum(
          com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode.Builder
              builderForValue) {
        if (maximumBuilder_ == null) {
          mode_ = builderForValue.build();
          onChanged();
        } else {
          maximumBuilder_.setMessage(builderForValue.build());
        }
        modeCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value exceeds the previous maximum value for a
       * column in the destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode maximum = 3;
       * </code>
       */
      public Builder mergeMaximum(
          com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode value) {
        if (maximumBuilder_ == null) {
          if (modeCase_ == 3
              && mode_
                  != com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
                      .getDefaultInstance()) {
            mode_ =
                com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode.newBuilder(
                        (com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode)
                            mode_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            mode_ = value;
          }
          onChanged();
        } else {
          if (modeCase_ == 3) {
            maximumBuilder_.mergeFrom(value);
          } else {
            maximumBuilder_.setMessage(value);
          }
        }
        modeCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value exceeds the previous maximum value for a
       * column in the destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode maximum = 3;
       * </code>
       */
      public Builder clearMaximum() {
        if (maximumBuilder_ == null) {
          if (modeCase_ == 3) {
            modeCase_ = 0;
            mode_ = null;
            onChanged();
          }
        } else {
          if (modeCase_ == 3) {
            modeCase_ = 0;
            mode_ = null;
          }
          maximumBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value exceeds the previous maximum value for a
       * column in the destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode maximum = 3;
       * </code>
       */
      public com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode.Builder
          getMaximumBuilder() {
        return getMaximumFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value exceeds the previous maximum value for a
       * column in the destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode maximum = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadModeOrBuilder
          getMaximumOrBuilder() {
        if ((modeCase_ == 3) && (maximumBuilder_ != null)) {
          return maximumBuilder_.getMessageOrBuilder();
        } else {
          if (modeCase_ == 3) {
            return (com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode) mode_;
          }
          return com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value exceeds the previous maximum value for a
       * column in the destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode maximum = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode,
              com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode.Builder,
              com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadModeOrBuilder>
          getMaximumFieldBuilder() {
        if (maximumBuilder_ == null) {
          if (!(modeCase_ == 3)) {
            mode_ =
                com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
                    .getDefaultInstance();
          }
          maximumBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode,
                  com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode.Builder,
                  com.google.cloud.dataform.v1.CompilationResultAction
                      .IncrementalLoadModeOrBuilder>(
                  (com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode) mode_,
                  getParentForChildren(),
                  isClean());
          mode_ = null;
        }
        modeCase_ = 3;
        onChanged();
        return maximumBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode,
              com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode.Builder,
              com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadModeOrBuilder>
          uniqueBuilder_;

      /**
       *
       *
       * <pre>
       * Insert records where the value of a column is not already present in
       * the destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode unique = 4;
       * </code>
       *
       * @return Whether the unique field is set.
       */
      @java.lang.Override
      public boolean hasUnique() {
        return modeCase_ == 4;
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value of a column is not already present in
       * the destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode unique = 4;
       * </code>
       *
       * @return The unique.
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode getUnique() {
        if (uniqueBuilder_ == null) {
          if (modeCase_ == 4) {
            return (com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode) mode_;
          }
          return com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
              .getDefaultInstance();
        } else {
          if (modeCase_ == 4) {
            return uniqueBuilder_.getMessage();
          }
          return com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value of a column is not already present in
       * the destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode unique = 4;
       * </code>
       */
      public Builder setUnique(
          com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode value) {
        if (uniqueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          mode_ = value;
          onChanged();
        } else {
          uniqueBuilder_.setMessage(value);
        }
        modeCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value of a column is not already present in
       * the destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode unique = 4;
       * </code>
       */
      public Builder setUnique(
          com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode.Builder
              builderForValue) {
        if (uniqueBuilder_ == null) {
          mode_ = builderForValue.build();
          onChanged();
        } else {
          uniqueBuilder_.setMessage(builderForValue.build());
        }
        modeCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value of a column is not already present in
       * the destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode unique = 4;
       * </code>
       */
      public Builder mergeUnique(
          com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode value) {
        if (uniqueBuilder_ == null) {
          if (modeCase_ == 4
              && mode_
                  != com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
                      .getDefaultInstance()) {
            mode_ =
                com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode.newBuilder(
                        (com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode)
                            mode_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            mode_ = value;
          }
          onChanged();
        } else {
          if (modeCase_ == 4) {
            uniqueBuilder_.mergeFrom(value);
          } else {
            uniqueBuilder_.setMessage(value);
          }
        }
        modeCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value of a column is not already present in
       * the destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode unique = 4;
       * </code>
       */
      public Builder clearUnique() {
        if (uniqueBuilder_ == null) {
          if (modeCase_ == 4) {
            modeCase_ = 0;
            mode_ = null;
            onChanged();
          }
        } else {
          if (modeCase_ == 4) {
            modeCase_ = 0;
            mode_ = null;
          }
          uniqueBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value of a column is not already present in
       * the destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode unique = 4;
       * </code>
       */
      public com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode.Builder
          getUniqueBuilder() {
        return getUniqueFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value of a column is not already present in
       * the destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode unique = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadModeOrBuilder
          getUniqueOrBuilder() {
        if ((modeCase_ == 4) && (uniqueBuilder_ != null)) {
          return uniqueBuilder_.getMessageOrBuilder();
        } else {
          if (modeCase_ == 4) {
            return (com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode) mode_;
          }
          return com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Insert records where the value of a column is not already present in
       * the destination table
       * </pre>
       *
       * <code>.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode unique = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode,
              com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode.Builder,
              com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadModeOrBuilder>
          getUniqueFieldBuilder() {
        if (uniqueBuilder_ == null) {
          if (!(modeCase_ == 4)) {
            mode_ =
                com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
                    .getDefaultInstance();
          }
          uniqueBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode,
                  com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode.Builder,
                  com.google.cloud.dataform.v1.CompilationResultAction
                      .IncrementalLoadModeOrBuilder>(
                  (com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode) mode_,
                  getParentForChildren(),
                  isClean());
          mode_ = null;
        }
        modeCase_ = 4;
        onChanged();
        return uniqueBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.CompilationResultAction.LoadConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.CompilationResultAction.LoadConfig)
    private static final com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig();
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LoadConfig> PARSER =
        new com.google.protobuf.AbstractParser<LoadConfig>() {
          @java.lang.Override
          public LoadConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LoadConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LoadConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.LoadConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SimpleLoadModeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode)
      com.google.protobuf.MessageOrBuilder {}

  /**
   *
   *
   * <pre>
   * Simple load definition
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode}
   */
  public static final class SimpleLoadMode extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode)
      SimpleLoadModeOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use SimpleLoadMode.newBuilder() to construct.
    private SimpleLoadMode(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SimpleLoadMode() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SimpleLoadMode();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_SimpleLoadMode_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_SimpleLoadMode_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode.class,
              com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode)) {
        return super.equals(obj);
      }
      com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode other =
          (com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Simple load definition
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode)
        com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadModeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_SimpleLoadMode_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_SimpleLoadMode_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode.class,
                com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode.Builder.class);
      }

      // Construct using
      // com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_SimpleLoadMode_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
          getDefaultInstanceForType() {
        return com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode build() {
        com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode buildPartial() {
        com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode result =
            new com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode) {
          return mergeFrom(
              (com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode other) {
        if (other
            == com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
                .getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode)
    private static final com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode();
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SimpleLoadMode> PARSER =
        new com.google.protobuf.AbstractParser<SimpleLoadMode>() {
          @java.lang.Override
          public SimpleLoadMode parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SimpleLoadMode> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SimpleLoadMode> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.SimpleLoadMode
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IncrementalLoadModeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Column name for incremental load modes
     * </pre>
     *
     * <code>string column = 1;</code>
     *
     * @return The column.
     */
    java.lang.String getColumn();

    /**
     *
     *
     * <pre>
     * Column name for incremental load modes
     * </pre>
     *
     * <code>string column = 1;</code>
     *
     * @return The bytes for column.
     */
    com.google.protobuf.ByteString getColumnBytes();
  }

  /**
   *
   *
   * <pre>
   * Load definition for incremental load modes
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode}
   */
  public static final class IncrementalLoadMode extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode)
      IncrementalLoadModeOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use IncrementalLoadMode.newBuilder() to construct.
    private IncrementalLoadMode(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IncrementalLoadMode() {
      column_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new IncrementalLoadMode();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_IncrementalLoadMode_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_IncrementalLoadMode_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode.class,
              com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode.Builder
                  .class);
    }

    public static final int COLUMN_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object column_ = "";

    /**
     *
     *
     * <pre>
     * Column name for incremental load modes
     * </pre>
     *
     * <code>string column = 1;</code>
     *
     * @return The column.
     */
    @java.lang.Override
    public java.lang.String getColumn() {
      java.lang.Object ref = column_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        column_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Column name for incremental load modes
     * </pre>
     *
     * <code>string column = 1;</code>
     *
     * @return The bytes for column.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getColumnBytes() {
      java.lang.Object ref = column_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        column_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(column_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, column_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(column_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, column_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode)) {
        return super.equals(obj);
      }
      com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode other =
          (com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode) obj;

      if (!getColumn().equals(other.getColumn())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + COLUMN_FIELD_NUMBER;
      hash = (53 * hash) + getColumn().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Load definition for incremental load modes
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode)
        com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadModeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_IncrementalLoadMode_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_IncrementalLoadMode_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode.class,
                com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        column_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataform.v1.DataformProto
            .internal_static_google_cloud_dataform_v1_CompilationResultAction_IncrementalLoadMode_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
          getDefaultInstanceForType() {
        return com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode build() {
        com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
          buildPartial() {
        com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode result =
            new com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.column_ = column_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode) {
          return mergeFrom(
              (com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode other) {
        if (other
            == com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
                .getDefaultInstance()) return this;
        if (!other.getColumn().isEmpty()) {
          column_ = other.column_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  column_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object column_ = "";

      /**
       *
       *
       * <pre>
       * Column name for incremental load modes
       * </pre>
       *
       * <code>string column = 1;</code>
       *
       * @return The column.
       */
      public java.lang.String getColumn() {
        java.lang.Object ref = column_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          column_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Column name for incremental load modes
       * </pre>
       *
       * <code>string column = 1;</code>
       *
       * @return The bytes for column.
       */
      public com.google.protobuf.ByteString getColumnBytes() {
        java.lang.Object ref = column_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          column_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Column name for incremental load modes
       * </pre>
       *
       * <code>string column = 1;</code>
       *
       * @param value The column to set.
       * @return This builder for chaining.
       */
      public Builder setColumn(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        column_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Column name for incremental load modes
       * </pre>
       *
       * <code>string column = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearColumn() {
        column_ = getDefaultInstance().getColumn();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Column name for incremental load modes
       * </pre>
       *
       * <code>string column = 1;</code>
       *
       * @param value The bytes for column to set.
       * @return This builder for chaining.
       */
      public Builder setColumnBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        column_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode)
    private static final com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode();
    }

    public static com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IncrementalLoadMode> PARSER =
        new com.google.protobuf.AbstractParser<IncrementalLoadMode>() {
          @java.lang.Override
          public IncrementalLoadMode parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<IncrementalLoadMode> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IncrementalLoadMode> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.IncrementalLoadMode
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int compiledObjectCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object compiledObject_;

  public enum CompiledObjectCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    RELATION(4),
    OPERATIONS(5),
    ASSERTION(6),
    DECLARATION(7),
    NOTEBOOK(8),
    DATA_PREPARATION(9),
    COMPILEDOBJECT_NOT_SET(0);
    private final int value;

    private CompiledObjectCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CompiledObjectCase valueOf(int value) {
      return forNumber(value);
    }

    public static CompiledObjectCase forNumber(int value) {
      switch (value) {
        case 4:
          return RELATION;
        case 5:
          return OPERATIONS;
        case 6:
          return ASSERTION;
        case 7:
          return DECLARATION;
        case 8:
          return NOTEBOOK;
        case 9:
          return DATA_PREPARATION;
        case 0:
          return COMPILEDOBJECT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public CompiledObjectCase getCompiledObjectCase() {
    return CompiledObjectCase.forNumber(compiledObjectCase_);
  }

  public static final int RELATION_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * The database relation created/updated by this action.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.CompilationResultAction.Relation relation = 4;</code>
   *
   * @return Whether the relation field is set.
   */
  @java.lang.Override
  public boolean hasRelation() {
    return compiledObjectCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * The database relation created/updated by this action.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.CompilationResultAction.Relation relation = 4;</code>
   *
   * @return The relation.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.CompilationResultAction.Relation getRelation() {
    if (compiledObjectCase_ == 4) {
      return (com.google.cloud.dataform.v1.CompilationResultAction.Relation) compiledObject_;
    }
    return com.google.cloud.dataform.v1.CompilationResultAction.Relation.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The database relation created/updated by this action.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.CompilationResultAction.Relation relation = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.CompilationResultAction.RelationOrBuilder
      getRelationOrBuilder() {
    if (compiledObjectCase_ == 4) {
      return (com.google.cloud.dataform.v1.CompilationResultAction.Relation) compiledObject_;
    }
    return com.google.cloud.dataform.v1.CompilationResultAction.Relation.getDefaultInstance();
  }

  public static final int OPERATIONS_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * The database operations executed by this action.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.CompilationResultAction.Operations operations = 5;</code>
   *
   * @return Whether the operations field is set.
   */
  @java.lang.Override
  public boolean hasOperations() {
    return compiledObjectCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * The database operations executed by this action.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.CompilationResultAction.Operations operations = 5;</code>
   *
   * @return The operations.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.CompilationResultAction.Operations getOperations() {
    if (compiledObjectCase_ == 5) {
      return (com.google.cloud.dataform.v1.CompilationResultAction.Operations) compiledObject_;
    }
    return com.google.cloud.dataform.v1.CompilationResultAction.Operations.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The database operations executed by this action.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.CompilationResultAction.Operations operations = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.CompilationResultAction.OperationsOrBuilder
      getOperationsOrBuilder() {
    if (compiledObjectCase_ == 5) {
      return (com.google.cloud.dataform.v1.CompilationResultAction.Operations) compiledObject_;
    }
    return com.google.cloud.dataform.v1.CompilationResultAction.Operations.getDefaultInstance();
  }

  public static final int ASSERTION_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * The assertion executed by this action.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.CompilationResultAction.Assertion assertion = 6;</code>
   *
   * @return Whether the assertion field is set.
   */
  @java.lang.Override
  public boolean hasAssertion() {
    return compiledObjectCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * The assertion executed by this action.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.CompilationResultAction.Assertion assertion = 6;</code>
   *
   * @return The assertion.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.CompilationResultAction.Assertion getAssertion() {
    if (compiledObjectCase_ == 6) {
      return (com.google.cloud.dataform.v1.CompilationResultAction.Assertion) compiledObject_;
    }
    return com.google.cloud.dataform.v1.CompilationResultAction.Assertion.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The assertion executed by this action.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.CompilationResultAction.Assertion assertion = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.CompilationResultAction.AssertionOrBuilder
      getAssertionOrBuilder() {
    if (compiledObjectCase_ == 6) {
      return (com.google.cloud.dataform.v1.CompilationResultAction.Assertion) compiledObject_;
    }
    return com.google.cloud.dataform.v1.CompilationResultAction.Assertion.getDefaultInstance();
  }

  public static final int DECLARATION_FIELD_NUMBER = 7;

  /**
   *
   *
   * <pre>
   * The declaration declared by this action.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.CompilationResultAction.Declaration declaration = 7;</code>
   *
   * @return Whether the declaration field is set.
   */
  @java.lang.Override
  public boolean hasDeclaration() {
    return compiledObjectCase_ == 7;
  }

  /**
   *
   *
   * <pre>
   * The declaration declared by this action.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.CompilationResultAction.Declaration declaration = 7;</code>
   *
   * @return The declaration.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.CompilationResultAction.Declaration getDeclaration() {
    if (compiledObjectCase_ == 7) {
      return (com.google.cloud.dataform.v1.CompilationResultAction.Declaration) compiledObject_;
    }
    return com.google.cloud.dataform.v1.CompilationResultAction.Declaration.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The declaration declared by this action.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.CompilationResultAction.Declaration declaration = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.CompilationResultAction.DeclarationOrBuilder
      getDeclarationOrBuilder() {
    if (compiledObjectCase_ == 7) {
      return (com.google.cloud.dataform.v1.CompilationResultAction.Declaration) compiledObject_;
    }
    return com.google.cloud.dataform.v1.CompilationResultAction.Declaration.getDefaultInstance();
  }

  public static final int NOTEBOOK_FIELD_NUMBER = 8;

  /**
   *
   *
   * <pre>
   * The notebook executed by this action.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.CompilationResultAction.Notebook notebook = 8;</code>
   *
   * @return Whether the notebook field is set.
   */
  @java.lang.Override
  public boolean hasNotebook() {
    return compiledObjectCase_ == 8;
  }

  /**
   *
   *
   * <pre>
   * The notebook executed by this action.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.CompilationResultAction.Notebook notebook = 8;</code>
   *
   * @return The notebook.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.CompilationResultAction.Notebook getNotebook() {
    if (compiledObjectCase_ == 8) {
      return (com.google.cloud.dataform.v1.CompilationResultAction.Notebook) compiledObject_;
    }
    return com.google.cloud.dataform.v1.CompilationResultAction.Notebook.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The notebook executed by this action.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.CompilationResultAction.Notebook notebook = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.CompilationResultAction.NotebookOrBuilder
      getNotebookOrBuilder() {
    if (compiledObjectCase_ == 8) {
      return (com.google.cloud.dataform.v1.CompilationResultAction.Notebook) compiledObject_;
    }
    return com.google.cloud.dataform.v1.CompilationResultAction.Notebook.getDefaultInstance();
  }

  public static final int DATA_PREPARATION_FIELD_NUMBER = 9;

  /**
   *
   *
   * <pre>
   * The data preparation executed by this action.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.CompilationResultAction.DataPreparation data_preparation = 9;
   * </code>
   *
   * @return Whether the dataPreparation field is set.
   */
  @java.lang.Override
  public boolean hasDataPreparation() {
    return compiledObjectCase_ == 9;
  }

  /**
   *
   *
   * <pre>
   * The data preparation executed by this action.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.CompilationResultAction.DataPreparation data_preparation = 9;
   * </code>
   *
   * @return The dataPreparation.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation getDataPreparation() {
    if (compiledObjectCase_ == 9) {
      return (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation) compiledObject_;
    }
    return com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The data preparation executed by this action.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.CompilationResultAction.DataPreparation data_preparation = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparationOrBuilder
      getDataPreparationOrBuilder() {
    if (compiledObjectCase_ == 9) {
      return (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation) compiledObject_;
    }
    return com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
        .getDefaultInstance();
  }

  public static final int TARGET_FIELD_NUMBER = 1;
  private com.google.cloud.dataform.v1.Target target_;

  /**
   *
   *
   * <pre>
   * This action's identifier. Unique within the compilation result.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.Target target = 1;</code>
   *
   * @return Whether the target field is set.
   */
  @java.lang.Override
  public boolean hasTarget() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * This action's identifier. Unique within the compilation result.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.Target target = 1;</code>
   *
   * @return The target.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.Target getTarget() {
    return target_ == null ? com.google.cloud.dataform.v1.Target.getDefaultInstance() : target_;
  }

  /**
   *
   *
   * <pre>
   * This action's identifier. Unique within the compilation result.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.Target target = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.TargetOrBuilder getTargetOrBuilder() {
    return target_ == null ? com.google.cloud.dataform.v1.Target.getDefaultInstance() : target_;
  }

  public static final int CANONICAL_TARGET_FIELD_NUMBER = 2;
  private com.google.cloud.dataform.v1.Target canonicalTarget_;

  /**
   *
   *
   * <pre>
   * The action's identifier if the project had been compiled without any
   * overrides configured. Unique within the compilation result.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.Target canonical_target = 2;</code>
   *
   * @return Whether the canonicalTarget field is set.
   */
  @java.lang.Override
  public boolean hasCanonicalTarget() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The action's identifier if the project had been compiled without any
   * overrides configured. Unique within the compilation result.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.Target canonical_target = 2;</code>
   *
   * @return The canonicalTarget.
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.Target getCanonicalTarget() {
    return canonicalTarget_ == null
        ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
        : canonicalTarget_;
  }

  /**
   *
   *
   * <pre>
   * The action's identifier if the project had been compiled without any
   * overrides configured. Unique within the compilation result.
   * </pre>
   *
   * <code>.google.cloud.dataform.v1.Target canonical_target = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dataform.v1.TargetOrBuilder getCanonicalTargetOrBuilder() {
    return canonicalTarget_ == null
        ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
        : canonicalTarget_;
  }

  public static final int FILE_PATH_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filePath_ = "";

  /**
   *
   *
   * <pre>
   * The full path including filename in which this action is located, relative
   * to the workspace root.
   * </pre>
   *
   * <code>string file_path = 3;</code>
   *
   * @return The filePath.
   */
  @java.lang.Override
  public java.lang.String getFilePath() {
    java.lang.Object ref = filePath_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filePath_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The full path including filename in which this action is located, relative
   * to the workspace root.
   * </pre>
   *
   * <code>string file_path = 3;</code>
   *
   * @return The bytes for filePath.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilePathBytes() {
    java.lang.Object ref = filePath_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filePath_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INTERNAL_METADATA_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object internalMetadata_ = "";

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the internalMetadata field is set.
   */
  @java.lang.Override
  public boolean hasInternalMetadata() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The internalMetadata.
   */
  @java.lang.Override
  public java.lang.String getInternalMetadata() {
    java.lang.Object ref = internalMetadata_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      internalMetadata_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. All the metadata information that is used internally to serve
   * the resource. For example: timestamps, flags, status fields, etc. The
   * format of this field is a JSON string.
   * </pre>
   *
   * <code>optional string internal_metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for internalMetadata.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInternalMetadataBytes() {
    java.lang.Object ref = internalMetadata_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      internalMetadata_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getTarget());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getCanonicalTarget());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filePath_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, filePath_);
    }
    if (compiledObjectCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.dataform.v1.CompilationResultAction.Relation) compiledObject_);
    }
    if (compiledObjectCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.dataform.v1.CompilationResultAction.Operations) compiledObject_);
    }
    if (compiledObjectCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.dataform.v1.CompilationResultAction.Assertion) compiledObject_);
    }
    if (compiledObjectCase_ == 7) {
      output.writeMessage(
          7, (com.google.cloud.dataform.v1.CompilationResultAction.Declaration) compiledObject_);
    }
    if (compiledObjectCase_ == 8) {
      output.writeMessage(
          8, (com.google.cloud.dataform.v1.CompilationResultAction.Notebook) compiledObject_);
    }
    if (compiledObjectCase_ == 9) {
      output.writeMessage(
          9,
          (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation) compiledObject_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, internalMetadata_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTarget());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCanonicalTarget());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filePath_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, filePath_);
    }
    if (compiledObjectCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.dataform.v1.CompilationResultAction.Relation) compiledObject_);
    }
    if (compiledObjectCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.dataform.v1.CompilationResultAction.Operations) compiledObject_);
    }
    if (compiledObjectCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.dataform.v1.CompilationResultAction.Assertion) compiledObject_);
    }
    if (compiledObjectCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7,
              (com.google.cloud.dataform.v1.CompilationResultAction.Declaration) compiledObject_);
    }
    if (compiledObjectCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.dataform.v1.CompilationResultAction.Notebook) compiledObject_);
    }
    if (compiledObjectCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9,
              (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation)
                  compiledObject_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, internalMetadata_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataform.v1.CompilationResultAction)) {
      return super.equals(obj);
    }
    com.google.cloud.dataform.v1.CompilationResultAction other =
        (com.google.cloud.dataform.v1.CompilationResultAction) obj;

    if (hasTarget() != other.hasTarget()) return false;
    if (hasTarget()) {
      if (!getTarget().equals(other.getTarget())) return false;
    }
    if (hasCanonicalTarget() != other.hasCanonicalTarget()) return false;
    if (hasCanonicalTarget()) {
      if (!getCanonicalTarget().equals(other.getCanonicalTarget())) return false;
    }
    if (!getFilePath().equals(other.getFilePath())) return false;
    if (hasInternalMetadata() != other.hasInternalMetadata()) return false;
    if (hasInternalMetadata()) {
      if (!getInternalMetadata().equals(other.getInternalMetadata())) return false;
    }
    if (!getCompiledObjectCase().equals(other.getCompiledObjectCase())) return false;
    switch (compiledObjectCase_) {
      case 4:
        if (!getRelation().equals(other.getRelation())) return false;
        break;
      case 5:
        if (!getOperations().equals(other.getOperations())) return false;
        break;
      case 6:
        if (!getAssertion().equals(other.getAssertion())) return false;
        break;
      case 7:
        if (!getDeclaration().equals(other.getDeclaration())) return false;
        break;
      case 8:
        if (!getNotebook().equals(other.getNotebook())) return false;
        break;
      case 9:
        if (!getDataPreparation().equals(other.getDataPreparation())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasTarget()) {
      hash = (37 * hash) + TARGET_FIELD_NUMBER;
      hash = (53 * hash) + getTarget().hashCode();
    }
    if (hasCanonicalTarget()) {
      hash = (37 * hash) + CANONICAL_TARGET_FIELD_NUMBER;
      hash = (53 * hash) + getCanonicalTarget().hashCode();
    }
    hash = (37 * hash) + FILE_PATH_FIELD_NUMBER;
    hash = (53 * hash) + getFilePath().hashCode();
    if (hasInternalMetadata()) {
      hash = (37 * hash) + INTERNAL_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getInternalMetadata().hashCode();
    }
    switch (compiledObjectCase_) {
      case 4:
        hash = (37 * hash) + RELATION_FIELD_NUMBER;
        hash = (53 * hash) + getRelation().hashCode();
        break;
      case 5:
        hash = (37 * hash) + OPERATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getOperations().hashCode();
        break;
      case 6:
        hash = (37 * hash) + ASSERTION_FIELD_NUMBER;
        hash = (53 * hash) + getAssertion().hashCode();
        break;
      case 7:
        hash = (37 * hash) + DECLARATION_FIELD_NUMBER;
        hash = (53 * hash) + getDeclaration().hashCode();
        break;
      case 8:
        hash = (37 * hash) + NOTEBOOK_FIELD_NUMBER;
        hash = (53 * hash) + getNotebook().hashCode();
        break;
      case 9:
        hash = (37 * hash) + DATA_PREPARATION_FIELD_NUMBER;
        hash = (53 * hash) + getDataPreparation().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataform.v1.CompilationResultAction parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.CompilationResultAction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.CompilationResultAction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.CompilationResultAction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.CompilationResultAction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataform.v1.CompilationResultAction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.CompilationResultAction parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.CompilationResultAction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.CompilationResultAction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.CompilationResultAction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataform.v1.CompilationResultAction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataform.v1.CompilationResultAction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataform.v1.CompilationResultAction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a single Dataform action in a compilation result.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataform.v1.CompilationResultAction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataform.v1.CompilationResultAction)
      com.google.cloud.dataform.v1.CompilationResultActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataform.v1.CompilationResultAction.class,
              com.google.cloud.dataform.v1.CompilationResultAction.Builder.class);
    }

    // Construct using com.google.cloud.dataform.v1.CompilationResultAction.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTargetFieldBuilder();
        getCanonicalTargetFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (relationBuilder_ != null) {
        relationBuilder_.clear();
      }
      if (operationsBuilder_ != null) {
        operationsBuilder_.clear();
      }
      if (assertionBuilder_ != null) {
        assertionBuilder_.clear();
      }
      if (declarationBuilder_ != null) {
        declarationBuilder_.clear();
      }
      if (notebookBuilder_ != null) {
        notebookBuilder_.clear();
      }
      if (dataPreparationBuilder_ != null) {
        dataPreparationBuilder_.clear();
      }
      target_ = null;
      if (targetBuilder_ != null) {
        targetBuilder_.dispose();
        targetBuilder_ = null;
      }
      canonicalTarget_ = null;
      if (canonicalTargetBuilder_ != null) {
        canonicalTargetBuilder_.dispose();
        canonicalTargetBuilder_ = null;
      }
      filePath_ = "";
      internalMetadata_ = "";
      compiledObjectCase_ = 0;
      compiledObject_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataform.v1.DataformProto
          .internal_static_google_cloud_dataform_v1_CompilationResultAction_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction getDefaultInstanceForType() {
      return com.google.cloud.dataform.v1.CompilationResultAction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction build() {
      com.google.cloud.dataform.v1.CompilationResultAction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction buildPartial() {
      com.google.cloud.dataform.v1.CompilationResultAction result =
          new com.google.cloud.dataform.v1.CompilationResultAction(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataform.v1.CompilationResultAction result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.target_ = targetBuilder_ == null ? target_ : targetBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.canonicalTarget_ =
            canonicalTargetBuilder_ == null ? canonicalTarget_ : canonicalTargetBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.filePath_ = filePath_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.internalMetadata_ = internalMetadata_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.dataform.v1.CompilationResultAction result) {
      result.compiledObjectCase_ = compiledObjectCase_;
      result.compiledObject_ = this.compiledObject_;
      if (compiledObjectCase_ == 4 && relationBuilder_ != null) {
        result.compiledObject_ = relationBuilder_.build();
      }
      if (compiledObjectCase_ == 5 && operationsBuilder_ != null) {
        result.compiledObject_ = operationsBuilder_.build();
      }
      if (compiledObjectCase_ == 6 && assertionBuilder_ != null) {
        result.compiledObject_ = assertionBuilder_.build();
      }
      if (compiledObjectCase_ == 7 && declarationBuilder_ != null) {
        result.compiledObject_ = declarationBuilder_.build();
      }
      if (compiledObjectCase_ == 8 && notebookBuilder_ != null) {
        result.compiledObject_ = notebookBuilder_.build();
      }
      if (compiledObjectCase_ == 9 && dataPreparationBuilder_ != null) {
        result.compiledObject_ = dataPreparationBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataform.v1.CompilationResultAction) {
        return mergeFrom((com.google.cloud.dataform.v1.CompilationResultAction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataform.v1.CompilationResultAction other) {
      if (other == com.google.cloud.dataform.v1.CompilationResultAction.getDefaultInstance())
        return this;
      if (other.hasTarget()) {
        mergeTarget(other.getTarget());
      }
      if (other.hasCanonicalTarget()) {
        mergeCanonicalTarget(other.getCanonicalTarget());
      }
      if (!other.getFilePath().isEmpty()) {
        filePath_ = other.filePath_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasInternalMetadata()) {
        internalMetadata_ = other.internalMetadata_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      switch (other.getCompiledObjectCase()) {
        case RELATION:
          {
            mergeRelation(other.getRelation());
            break;
          }
        case OPERATIONS:
          {
            mergeOperations(other.getOperations());
            break;
          }
        case ASSERTION:
          {
            mergeAssertion(other.getAssertion());
            break;
          }
        case DECLARATION:
          {
            mergeDeclaration(other.getDeclaration());
            break;
          }
        case NOTEBOOK:
          {
            mergeNotebook(other.getNotebook());
            break;
          }
        case DATA_PREPARATION:
          {
            mergeDataPreparation(other.getDataPreparation());
            break;
          }
        case COMPILEDOBJECT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getTargetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCanonicalTargetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 18
            case 26:
              {
                filePath_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getRelationFieldBuilder().getBuilder(), extensionRegistry);
                compiledObjectCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getOperationsFieldBuilder().getBuilder(), extensionRegistry);
                compiledObjectCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getAssertionFieldBuilder().getBuilder(), extensionRegistry);
                compiledObjectCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getDeclarationFieldBuilder().getBuilder(), extensionRegistry);
                compiledObjectCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getNotebookFieldBuilder().getBuilder(), extensionRegistry);
                compiledObjectCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getDataPreparationFieldBuilder().getBuilder(), extensionRegistry);
                compiledObjectCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                internalMetadata_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int compiledObjectCase_ = 0;
    private java.lang.Object compiledObject_;

    public CompiledObjectCase getCompiledObjectCase() {
      return CompiledObjectCase.forNumber(compiledObjectCase_);
    }

    public Builder clearCompiledObject() {
      compiledObjectCase_ = 0;
      compiledObject_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.CompilationResultAction.Relation,
            com.google.cloud.dataform.v1.CompilationResultAction.Relation.Builder,
            com.google.cloud.dataform.v1.CompilationResultAction.RelationOrBuilder>
        relationBuilder_;

    /**
     *
     *
     * <pre>
     * The database relation created/updated by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Relation relation = 4;</code>
     *
     * @return Whether the relation field is set.
     */
    @java.lang.Override
    public boolean hasRelation() {
      return compiledObjectCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * The database relation created/updated by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Relation relation = 4;</code>
     *
     * @return The relation.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.Relation getRelation() {
      if (relationBuilder_ == null) {
        if (compiledObjectCase_ == 4) {
          return (com.google.cloud.dataform.v1.CompilationResultAction.Relation) compiledObject_;
        }
        return com.google.cloud.dataform.v1.CompilationResultAction.Relation.getDefaultInstance();
      } else {
        if (compiledObjectCase_ == 4) {
          return relationBuilder_.getMessage();
        }
        return com.google.cloud.dataform.v1.CompilationResultAction.Relation.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The database relation created/updated by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Relation relation = 4;</code>
     */
    public Builder setRelation(
        com.google.cloud.dataform.v1.CompilationResultAction.Relation value) {
      if (relationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        compiledObject_ = value;
        onChanged();
      } else {
        relationBuilder_.setMessage(value);
      }
      compiledObjectCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The database relation created/updated by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Relation relation = 4;</code>
     */
    public Builder setRelation(
        com.google.cloud.dataform.v1.CompilationResultAction.Relation.Builder builderForValue) {
      if (relationBuilder_ == null) {
        compiledObject_ = builderForValue.build();
        onChanged();
      } else {
        relationBuilder_.setMessage(builderForValue.build());
      }
      compiledObjectCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The database relation created/updated by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Relation relation = 4;</code>
     */
    public Builder mergeRelation(
        com.google.cloud.dataform.v1.CompilationResultAction.Relation value) {
      if (relationBuilder_ == null) {
        if (compiledObjectCase_ == 4
            && compiledObject_
                != com.google.cloud.dataform.v1.CompilationResultAction.Relation
                    .getDefaultInstance()) {
          compiledObject_ =
              com.google.cloud.dataform.v1.CompilationResultAction.Relation.newBuilder(
                      (com.google.cloud.dataform.v1.CompilationResultAction.Relation)
                          compiledObject_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          compiledObject_ = value;
        }
        onChanged();
      } else {
        if (compiledObjectCase_ == 4) {
          relationBuilder_.mergeFrom(value);
        } else {
          relationBuilder_.setMessage(value);
        }
      }
      compiledObjectCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The database relation created/updated by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Relation relation = 4;</code>
     */
    public Builder clearRelation() {
      if (relationBuilder_ == null) {
        if (compiledObjectCase_ == 4) {
          compiledObjectCase_ = 0;
          compiledObject_ = null;
          onChanged();
        }
      } else {
        if (compiledObjectCase_ == 4) {
          compiledObjectCase_ = 0;
          compiledObject_ = null;
        }
        relationBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The database relation created/updated by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Relation relation = 4;</code>
     */
    public com.google.cloud.dataform.v1.CompilationResultAction.Relation.Builder
        getRelationBuilder() {
      return getRelationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The database relation created/updated by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Relation relation = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.RelationOrBuilder
        getRelationOrBuilder() {
      if ((compiledObjectCase_ == 4) && (relationBuilder_ != null)) {
        return relationBuilder_.getMessageOrBuilder();
      } else {
        if (compiledObjectCase_ == 4) {
          return (com.google.cloud.dataform.v1.CompilationResultAction.Relation) compiledObject_;
        }
        return com.google.cloud.dataform.v1.CompilationResultAction.Relation.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The database relation created/updated by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Relation relation = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.CompilationResultAction.Relation,
            com.google.cloud.dataform.v1.CompilationResultAction.Relation.Builder,
            com.google.cloud.dataform.v1.CompilationResultAction.RelationOrBuilder>
        getRelationFieldBuilder() {
      if (relationBuilder_ == null) {
        if (!(compiledObjectCase_ == 4)) {
          compiledObject_ =
              com.google.cloud.dataform.v1.CompilationResultAction.Relation.getDefaultInstance();
        }
        relationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.CompilationResultAction.Relation,
                com.google.cloud.dataform.v1.CompilationResultAction.Relation.Builder,
                com.google.cloud.dataform.v1.CompilationResultAction.RelationOrBuilder>(
                (com.google.cloud.dataform.v1.CompilationResultAction.Relation) compiledObject_,
                getParentForChildren(),
                isClean());
        compiledObject_ = null;
      }
      compiledObjectCase_ = 4;
      onChanged();
      return relationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.CompilationResultAction.Operations,
            com.google.cloud.dataform.v1.CompilationResultAction.Operations.Builder,
            com.google.cloud.dataform.v1.CompilationResultAction.OperationsOrBuilder>
        operationsBuilder_;

    /**
     *
     *
     * <pre>
     * The database operations executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Operations operations = 5;</code>
     *
     * @return Whether the operations field is set.
     */
    @java.lang.Override
    public boolean hasOperations() {
      return compiledObjectCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * The database operations executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Operations operations = 5;</code>
     *
     * @return The operations.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.Operations getOperations() {
      if (operationsBuilder_ == null) {
        if (compiledObjectCase_ == 5) {
          return (com.google.cloud.dataform.v1.CompilationResultAction.Operations) compiledObject_;
        }
        return com.google.cloud.dataform.v1.CompilationResultAction.Operations.getDefaultInstance();
      } else {
        if (compiledObjectCase_ == 5) {
          return operationsBuilder_.getMessage();
        }
        return com.google.cloud.dataform.v1.CompilationResultAction.Operations.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The database operations executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Operations operations = 5;</code>
     */
    public Builder setOperations(
        com.google.cloud.dataform.v1.CompilationResultAction.Operations value) {
      if (operationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        compiledObject_ = value;
        onChanged();
      } else {
        operationsBuilder_.setMessage(value);
      }
      compiledObjectCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The database operations executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Operations operations = 5;</code>
     */
    public Builder setOperations(
        com.google.cloud.dataform.v1.CompilationResultAction.Operations.Builder builderForValue) {
      if (operationsBuilder_ == null) {
        compiledObject_ = builderForValue.build();
        onChanged();
      } else {
        operationsBuilder_.setMessage(builderForValue.build());
      }
      compiledObjectCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The database operations executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Operations operations = 5;</code>
     */
    public Builder mergeOperations(
        com.google.cloud.dataform.v1.CompilationResultAction.Operations value) {
      if (operationsBuilder_ == null) {
        if (compiledObjectCase_ == 5
            && compiledObject_
                != com.google.cloud.dataform.v1.CompilationResultAction.Operations
                    .getDefaultInstance()) {
          compiledObject_ =
              com.google.cloud.dataform.v1.CompilationResultAction.Operations.newBuilder(
                      (com.google.cloud.dataform.v1.CompilationResultAction.Operations)
                          compiledObject_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          compiledObject_ = value;
        }
        onChanged();
      } else {
        if (compiledObjectCase_ == 5) {
          operationsBuilder_.mergeFrom(value);
        } else {
          operationsBuilder_.setMessage(value);
        }
      }
      compiledObjectCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The database operations executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Operations operations = 5;</code>
     */
    public Builder clearOperations() {
      if (operationsBuilder_ == null) {
        if (compiledObjectCase_ == 5) {
          compiledObjectCase_ = 0;
          compiledObject_ = null;
          onChanged();
        }
      } else {
        if (compiledObjectCase_ == 5) {
          compiledObjectCase_ = 0;
          compiledObject_ = null;
        }
        operationsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The database operations executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Operations operations = 5;</code>
     */
    public com.google.cloud.dataform.v1.CompilationResultAction.Operations.Builder
        getOperationsBuilder() {
      return getOperationsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The database operations executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Operations operations = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.OperationsOrBuilder
        getOperationsOrBuilder() {
      if ((compiledObjectCase_ == 5) && (operationsBuilder_ != null)) {
        return operationsBuilder_.getMessageOrBuilder();
      } else {
        if (compiledObjectCase_ == 5) {
          return (com.google.cloud.dataform.v1.CompilationResultAction.Operations) compiledObject_;
        }
        return com.google.cloud.dataform.v1.CompilationResultAction.Operations.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The database operations executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Operations operations = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.CompilationResultAction.Operations,
            com.google.cloud.dataform.v1.CompilationResultAction.Operations.Builder,
            com.google.cloud.dataform.v1.CompilationResultAction.OperationsOrBuilder>
        getOperationsFieldBuilder() {
      if (operationsBuilder_ == null) {
        if (!(compiledObjectCase_ == 5)) {
          compiledObject_ =
              com.google.cloud.dataform.v1.CompilationResultAction.Operations.getDefaultInstance();
        }
        operationsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.CompilationResultAction.Operations,
                com.google.cloud.dataform.v1.CompilationResultAction.Operations.Builder,
                com.google.cloud.dataform.v1.CompilationResultAction.OperationsOrBuilder>(
                (com.google.cloud.dataform.v1.CompilationResultAction.Operations) compiledObject_,
                getParentForChildren(),
                isClean());
        compiledObject_ = null;
      }
      compiledObjectCase_ = 5;
      onChanged();
      return operationsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.CompilationResultAction.Assertion,
            com.google.cloud.dataform.v1.CompilationResultAction.Assertion.Builder,
            com.google.cloud.dataform.v1.CompilationResultAction.AssertionOrBuilder>
        assertionBuilder_;

    /**
     *
     *
     * <pre>
     * The assertion executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Assertion assertion = 6;</code>
     *
     * @return Whether the assertion field is set.
     */
    @java.lang.Override
    public boolean hasAssertion() {
      return compiledObjectCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * The assertion executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Assertion assertion = 6;</code>
     *
     * @return The assertion.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.Assertion getAssertion() {
      if (assertionBuilder_ == null) {
        if (compiledObjectCase_ == 6) {
          return (com.google.cloud.dataform.v1.CompilationResultAction.Assertion) compiledObject_;
        }
        return com.google.cloud.dataform.v1.CompilationResultAction.Assertion.getDefaultInstance();
      } else {
        if (compiledObjectCase_ == 6) {
          return assertionBuilder_.getMessage();
        }
        return com.google.cloud.dataform.v1.CompilationResultAction.Assertion.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The assertion executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Assertion assertion = 6;</code>
     */
    public Builder setAssertion(
        com.google.cloud.dataform.v1.CompilationResultAction.Assertion value) {
      if (assertionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        compiledObject_ = value;
        onChanged();
      } else {
        assertionBuilder_.setMessage(value);
      }
      compiledObjectCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The assertion executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Assertion assertion = 6;</code>
     */
    public Builder setAssertion(
        com.google.cloud.dataform.v1.CompilationResultAction.Assertion.Builder builderForValue) {
      if (assertionBuilder_ == null) {
        compiledObject_ = builderForValue.build();
        onChanged();
      } else {
        assertionBuilder_.setMessage(builderForValue.build());
      }
      compiledObjectCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The assertion executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Assertion assertion = 6;</code>
     */
    public Builder mergeAssertion(
        com.google.cloud.dataform.v1.CompilationResultAction.Assertion value) {
      if (assertionBuilder_ == null) {
        if (compiledObjectCase_ == 6
            && compiledObject_
                != com.google.cloud.dataform.v1.CompilationResultAction.Assertion
                    .getDefaultInstance()) {
          compiledObject_ =
              com.google.cloud.dataform.v1.CompilationResultAction.Assertion.newBuilder(
                      (com.google.cloud.dataform.v1.CompilationResultAction.Assertion)
                          compiledObject_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          compiledObject_ = value;
        }
        onChanged();
      } else {
        if (compiledObjectCase_ == 6) {
          assertionBuilder_.mergeFrom(value);
        } else {
          assertionBuilder_.setMessage(value);
        }
      }
      compiledObjectCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The assertion executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Assertion assertion = 6;</code>
     */
    public Builder clearAssertion() {
      if (assertionBuilder_ == null) {
        if (compiledObjectCase_ == 6) {
          compiledObjectCase_ = 0;
          compiledObject_ = null;
          onChanged();
        }
      } else {
        if (compiledObjectCase_ == 6) {
          compiledObjectCase_ = 0;
          compiledObject_ = null;
        }
        assertionBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The assertion executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Assertion assertion = 6;</code>
     */
    public com.google.cloud.dataform.v1.CompilationResultAction.Assertion.Builder
        getAssertionBuilder() {
      return getAssertionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The assertion executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Assertion assertion = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.AssertionOrBuilder
        getAssertionOrBuilder() {
      if ((compiledObjectCase_ == 6) && (assertionBuilder_ != null)) {
        return assertionBuilder_.getMessageOrBuilder();
      } else {
        if (compiledObjectCase_ == 6) {
          return (com.google.cloud.dataform.v1.CompilationResultAction.Assertion) compiledObject_;
        }
        return com.google.cloud.dataform.v1.CompilationResultAction.Assertion.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The assertion executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Assertion assertion = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.CompilationResultAction.Assertion,
            com.google.cloud.dataform.v1.CompilationResultAction.Assertion.Builder,
            com.google.cloud.dataform.v1.CompilationResultAction.AssertionOrBuilder>
        getAssertionFieldBuilder() {
      if (assertionBuilder_ == null) {
        if (!(compiledObjectCase_ == 6)) {
          compiledObject_ =
              com.google.cloud.dataform.v1.CompilationResultAction.Assertion.getDefaultInstance();
        }
        assertionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.CompilationResultAction.Assertion,
                com.google.cloud.dataform.v1.CompilationResultAction.Assertion.Builder,
                com.google.cloud.dataform.v1.CompilationResultAction.AssertionOrBuilder>(
                (com.google.cloud.dataform.v1.CompilationResultAction.Assertion) compiledObject_,
                getParentForChildren(),
                isClean());
        compiledObject_ = null;
      }
      compiledObjectCase_ = 6;
      onChanged();
      return assertionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.CompilationResultAction.Declaration,
            com.google.cloud.dataform.v1.CompilationResultAction.Declaration.Builder,
            com.google.cloud.dataform.v1.CompilationResultAction.DeclarationOrBuilder>
        declarationBuilder_;

    /**
     *
     *
     * <pre>
     * The declaration declared by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Declaration declaration = 7;</code>
     *
     * @return Whether the declaration field is set.
     */
    @java.lang.Override
    public boolean hasDeclaration() {
      return compiledObjectCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * The declaration declared by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Declaration declaration = 7;</code>
     *
     * @return The declaration.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.Declaration getDeclaration() {
      if (declarationBuilder_ == null) {
        if (compiledObjectCase_ == 7) {
          return (com.google.cloud.dataform.v1.CompilationResultAction.Declaration) compiledObject_;
        }
        return com.google.cloud.dataform.v1.CompilationResultAction.Declaration
            .getDefaultInstance();
      } else {
        if (compiledObjectCase_ == 7) {
          return declarationBuilder_.getMessage();
        }
        return com.google.cloud.dataform.v1.CompilationResultAction.Declaration
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The declaration declared by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Declaration declaration = 7;</code>
     */
    public Builder setDeclaration(
        com.google.cloud.dataform.v1.CompilationResultAction.Declaration value) {
      if (declarationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        compiledObject_ = value;
        onChanged();
      } else {
        declarationBuilder_.setMessage(value);
      }
      compiledObjectCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The declaration declared by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Declaration declaration = 7;</code>
     */
    public Builder setDeclaration(
        com.google.cloud.dataform.v1.CompilationResultAction.Declaration.Builder builderForValue) {
      if (declarationBuilder_ == null) {
        compiledObject_ = builderForValue.build();
        onChanged();
      } else {
        declarationBuilder_.setMessage(builderForValue.build());
      }
      compiledObjectCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The declaration declared by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Declaration declaration = 7;</code>
     */
    public Builder mergeDeclaration(
        com.google.cloud.dataform.v1.CompilationResultAction.Declaration value) {
      if (declarationBuilder_ == null) {
        if (compiledObjectCase_ == 7
            && compiledObject_
                != com.google.cloud.dataform.v1.CompilationResultAction.Declaration
                    .getDefaultInstance()) {
          compiledObject_ =
              com.google.cloud.dataform.v1.CompilationResultAction.Declaration.newBuilder(
                      (com.google.cloud.dataform.v1.CompilationResultAction.Declaration)
                          compiledObject_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          compiledObject_ = value;
        }
        onChanged();
      } else {
        if (compiledObjectCase_ == 7) {
          declarationBuilder_.mergeFrom(value);
        } else {
          declarationBuilder_.setMessage(value);
        }
      }
      compiledObjectCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The declaration declared by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Declaration declaration = 7;</code>
     */
    public Builder clearDeclaration() {
      if (declarationBuilder_ == null) {
        if (compiledObjectCase_ == 7) {
          compiledObjectCase_ = 0;
          compiledObject_ = null;
          onChanged();
        }
      } else {
        if (compiledObjectCase_ == 7) {
          compiledObjectCase_ = 0;
          compiledObject_ = null;
        }
        declarationBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The declaration declared by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Declaration declaration = 7;</code>
     */
    public com.google.cloud.dataform.v1.CompilationResultAction.Declaration.Builder
        getDeclarationBuilder() {
      return getDeclarationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The declaration declared by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Declaration declaration = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.DeclarationOrBuilder
        getDeclarationOrBuilder() {
      if ((compiledObjectCase_ == 7) && (declarationBuilder_ != null)) {
        return declarationBuilder_.getMessageOrBuilder();
      } else {
        if (compiledObjectCase_ == 7) {
          return (com.google.cloud.dataform.v1.CompilationResultAction.Declaration) compiledObject_;
        }
        return com.google.cloud.dataform.v1.CompilationResultAction.Declaration
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The declaration declared by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Declaration declaration = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.CompilationResultAction.Declaration,
            com.google.cloud.dataform.v1.CompilationResultAction.Declaration.Builder,
            com.google.cloud.dataform.v1.CompilationResultAction.DeclarationOrBuilder>
        getDeclarationFieldBuilder() {
      if (declarationBuilder_ == null) {
        if (!(compiledObjectCase_ == 7)) {
          compiledObject_ =
              com.google.cloud.dataform.v1.CompilationResultAction.Declaration.getDefaultInstance();
        }
        declarationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.CompilationResultAction.Declaration,
                com.google.cloud.dataform.v1.CompilationResultAction.Declaration.Builder,
                com.google.cloud.dataform.v1.CompilationResultAction.DeclarationOrBuilder>(
                (com.google.cloud.dataform.v1.CompilationResultAction.Declaration) compiledObject_,
                getParentForChildren(),
                isClean());
        compiledObject_ = null;
      }
      compiledObjectCase_ = 7;
      onChanged();
      return declarationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.CompilationResultAction.Notebook,
            com.google.cloud.dataform.v1.CompilationResultAction.Notebook.Builder,
            com.google.cloud.dataform.v1.CompilationResultAction.NotebookOrBuilder>
        notebookBuilder_;

    /**
     *
     *
     * <pre>
     * The notebook executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Notebook notebook = 8;</code>
     *
     * @return Whether the notebook field is set.
     */
    @java.lang.Override
    public boolean hasNotebook() {
      return compiledObjectCase_ == 8;
    }

    /**
     *
     *
     * <pre>
     * The notebook executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Notebook notebook = 8;</code>
     *
     * @return The notebook.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.Notebook getNotebook() {
      if (notebookBuilder_ == null) {
        if (compiledObjectCase_ == 8) {
          return (com.google.cloud.dataform.v1.CompilationResultAction.Notebook) compiledObject_;
        }
        return com.google.cloud.dataform.v1.CompilationResultAction.Notebook.getDefaultInstance();
      } else {
        if (compiledObjectCase_ == 8) {
          return notebookBuilder_.getMessage();
        }
        return com.google.cloud.dataform.v1.CompilationResultAction.Notebook.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The notebook executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Notebook notebook = 8;</code>
     */
    public Builder setNotebook(
        com.google.cloud.dataform.v1.CompilationResultAction.Notebook value) {
      if (notebookBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        compiledObject_ = value;
        onChanged();
      } else {
        notebookBuilder_.setMessage(value);
      }
      compiledObjectCase_ = 8;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The notebook executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Notebook notebook = 8;</code>
     */
    public Builder setNotebook(
        com.google.cloud.dataform.v1.CompilationResultAction.Notebook.Builder builderForValue) {
      if (notebookBuilder_ == null) {
        compiledObject_ = builderForValue.build();
        onChanged();
      } else {
        notebookBuilder_.setMessage(builderForValue.build());
      }
      compiledObjectCase_ = 8;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The notebook executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Notebook notebook = 8;</code>
     */
    public Builder mergeNotebook(
        com.google.cloud.dataform.v1.CompilationResultAction.Notebook value) {
      if (notebookBuilder_ == null) {
        if (compiledObjectCase_ == 8
            && compiledObject_
                != com.google.cloud.dataform.v1.CompilationResultAction.Notebook
                    .getDefaultInstance()) {
          compiledObject_ =
              com.google.cloud.dataform.v1.CompilationResultAction.Notebook.newBuilder(
                      (com.google.cloud.dataform.v1.CompilationResultAction.Notebook)
                          compiledObject_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          compiledObject_ = value;
        }
        onChanged();
      } else {
        if (compiledObjectCase_ == 8) {
          notebookBuilder_.mergeFrom(value);
        } else {
          notebookBuilder_.setMessage(value);
        }
      }
      compiledObjectCase_ = 8;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The notebook executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Notebook notebook = 8;</code>
     */
    public Builder clearNotebook() {
      if (notebookBuilder_ == null) {
        if (compiledObjectCase_ == 8) {
          compiledObjectCase_ = 0;
          compiledObject_ = null;
          onChanged();
        }
      } else {
        if (compiledObjectCase_ == 8) {
          compiledObjectCase_ = 0;
          compiledObject_ = null;
        }
        notebookBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The notebook executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Notebook notebook = 8;</code>
     */
    public com.google.cloud.dataform.v1.CompilationResultAction.Notebook.Builder
        getNotebookBuilder() {
      return getNotebookFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The notebook executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Notebook notebook = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.NotebookOrBuilder
        getNotebookOrBuilder() {
      if ((compiledObjectCase_ == 8) && (notebookBuilder_ != null)) {
        return notebookBuilder_.getMessageOrBuilder();
      } else {
        if (compiledObjectCase_ == 8) {
          return (com.google.cloud.dataform.v1.CompilationResultAction.Notebook) compiledObject_;
        }
        return com.google.cloud.dataform.v1.CompilationResultAction.Notebook.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The notebook executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.Notebook notebook = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.CompilationResultAction.Notebook,
            com.google.cloud.dataform.v1.CompilationResultAction.Notebook.Builder,
            com.google.cloud.dataform.v1.CompilationResultAction.NotebookOrBuilder>
        getNotebookFieldBuilder() {
      if (notebookBuilder_ == null) {
        if (!(compiledObjectCase_ == 8)) {
          compiledObject_ =
              com.google.cloud.dataform.v1.CompilationResultAction.Notebook.getDefaultInstance();
        }
        notebookBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.CompilationResultAction.Notebook,
                com.google.cloud.dataform.v1.CompilationResultAction.Notebook.Builder,
                com.google.cloud.dataform.v1.CompilationResultAction.NotebookOrBuilder>(
                (com.google.cloud.dataform.v1.CompilationResultAction.Notebook) compiledObject_,
                getParentForChildren(),
                isClean());
        compiledObject_ = null;
      }
      compiledObjectCase_ = 8;
      onChanged();
      return notebookBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation,
            com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.Builder,
            com.google.cloud.dataform.v1.CompilationResultAction.DataPreparationOrBuilder>
        dataPreparationBuilder_;

    /**
     *
     *
     * <pre>
     * The data preparation executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.DataPreparation data_preparation = 9;
     * </code>
     *
     * @return Whether the dataPreparation field is set.
     */
    @java.lang.Override
    public boolean hasDataPreparation() {
      return compiledObjectCase_ == 9;
    }

    /**
     *
     *
     * <pre>
     * The data preparation executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.DataPreparation data_preparation = 9;
     * </code>
     *
     * @return The dataPreparation.
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
        getDataPreparation() {
      if (dataPreparationBuilder_ == null) {
        if (compiledObjectCase_ == 9) {
          return (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation)
              compiledObject_;
        }
        return com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
            .getDefaultInstance();
      } else {
        if (compiledObjectCase_ == 9) {
          return dataPreparationBuilder_.getMessage();
        }
        return com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The data preparation executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.DataPreparation data_preparation = 9;
     * </code>
     */
    public Builder setDataPreparation(
        com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation value) {
      if (dataPreparationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        compiledObject_ = value;
        onChanged();
      } else {
        dataPreparationBuilder_.setMessage(value);
      }
      compiledObjectCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The data preparation executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.DataPreparation data_preparation = 9;
     * </code>
     */
    public Builder setDataPreparation(
        com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.Builder
            builderForValue) {
      if (dataPreparationBuilder_ == null) {
        compiledObject_ = builderForValue.build();
        onChanged();
      } else {
        dataPreparationBuilder_.setMessage(builderForValue.build());
      }
      compiledObjectCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The data preparation executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.DataPreparation data_preparation = 9;
     * </code>
     */
    public Builder mergeDataPreparation(
        com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation value) {
      if (dataPreparationBuilder_ == null) {
        if (compiledObjectCase_ == 9
            && compiledObject_
                != com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
                    .getDefaultInstance()) {
          compiledObject_ =
              com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.newBuilder(
                      (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation)
                          compiledObject_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          compiledObject_ = value;
        }
        onChanged();
      } else {
        if (compiledObjectCase_ == 9) {
          dataPreparationBuilder_.mergeFrom(value);
        } else {
          dataPreparationBuilder_.setMessage(value);
        }
      }
      compiledObjectCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The data preparation executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.DataPreparation data_preparation = 9;
     * </code>
     */
    public Builder clearDataPreparation() {
      if (dataPreparationBuilder_ == null) {
        if (compiledObjectCase_ == 9) {
          compiledObjectCase_ = 0;
          compiledObject_ = null;
          onChanged();
        }
      } else {
        if (compiledObjectCase_ == 9) {
          compiledObjectCase_ = 0;
          compiledObject_ = null;
        }
        dataPreparationBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The data preparation executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.DataPreparation data_preparation = 9;
     * </code>
     */
    public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.Builder
        getDataPreparationBuilder() {
      return getDataPreparationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The data preparation executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.DataPreparation data_preparation = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataform.v1.CompilationResultAction.DataPreparationOrBuilder
        getDataPreparationOrBuilder() {
      if ((compiledObjectCase_ == 9) && (dataPreparationBuilder_ != null)) {
        return dataPreparationBuilder_.getMessageOrBuilder();
      } else {
        if (compiledObjectCase_ == 9) {
          return (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation)
              compiledObject_;
        }
        return com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The data preparation executed by this action.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.CompilationResultAction.DataPreparation data_preparation = 9;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation,
            com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.Builder,
            com.google.cloud.dataform.v1.CompilationResultAction.DataPreparationOrBuilder>
        getDataPreparationFieldBuilder() {
      if (dataPreparationBuilder_ == null) {
        if (!(compiledObjectCase_ == 9)) {
          compiledObject_ =
              com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation
                  .getDefaultInstance();
        }
        dataPreparationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation,
                com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation.Builder,
                com.google.cloud.dataform.v1.CompilationResultAction.DataPreparationOrBuilder>(
                (com.google.cloud.dataform.v1.CompilationResultAction.DataPreparation)
                    compiledObject_,
                getParentForChildren(),
                isClean());
        compiledObject_ = null;
      }
      compiledObjectCase_ = 9;
      onChanged();
      return dataPreparationBuilder_;
    }

    private com.google.cloud.dataform.v1.Target target_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.Target,
            com.google.cloud.dataform.v1.Target.Builder,
            com.google.cloud.dataform.v1.TargetOrBuilder>
        targetBuilder_;

    /**
     *
     *
     * <pre>
     * This action's identifier. Unique within the compilation result.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target target = 1;</code>
     *
     * @return Whether the target field is set.
     */
    public boolean hasTarget() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * This action's identifier. Unique within the compilation result.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target target = 1;</code>
     *
     * @return The target.
     */
    public com.google.cloud.dataform.v1.Target getTarget() {
      if (targetBuilder_ == null) {
        return target_ == null ? com.google.cloud.dataform.v1.Target.getDefaultInstance() : target_;
      } else {
        return targetBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * This action's identifier. Unique within the compilation result.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target target = 1;</code>
     */
    public Builder setTarget(com.google.cloud.dataform.v1.Target value) {
      if (targetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        target_ = value;
      } else {
        targetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This action's identifier. Unique within the compilation result.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target target = 1;</code>
     */
    public Builder setTarget(com.google.cloud.dataform.v1.Target.Builder builderForValue) {
      if (targetBuilder_ == null) {
        target_ = builderForValue.build();
      } else {
        targetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This action's identifier. Unique within the compilation result.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target target = 1;</code>
     */
    public Builder mergeTarget(com.google.cloud.dataform.v1.Target value) {
      if (targetBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && target_ != null
            && target_ != com.google.cloud.dataform.v1.Target.getDefaultInstance()) {
          getTargetBuilder().mergeFrom(value);
        } else {
          target_ = value;
        }
      } else {
        targetBuilder_.mergeFrom(value);
      }
      if (target_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * This action's identifier. Unique within the compilation result.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target target = 1;</code>
     */
    public Builder clearTarget() {
      bitField0_ = (bitField0_ & ~0x00000040);
      target_ = null;
      if (targetBuilder_ != null) {
        targetBuilder_.dispose();
        targetBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This action's identifier. Unique within the compilation result.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target target = 1;</code>
     */
    public com.google.cloud.dataform.v1.Target.Builder getTargetBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getTargetFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * This action's identifier. Unique within the compilation result.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target target = 1;</code>
     */
    public com.google.cloud.dataform.v1.TargetOrBuilder getTargetOrBuilder() {
      if (targetBuilder_ != null) {
        return targetBuilder_.getMessageOrBuilder();
      } else {
        return target_ == null ? com.google.cloud.dataform.v1.Target.getDefaultInstance() : target_;
      }
    }

    /**
     *
     *
     * <pre>
     * This action's identifier. Unique within the compilation result.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target target = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.Target,
            com.google.cloud.dataform.v1.Target.Builder,
            com.google.cloud.dataform.v1.TargetOrBuilder>
        getTargetFieldBuilder() {
      if (targetBuilder_ == null) {
        targetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.Target,
                com.google.cloud.dataform.v1.Target.Builder,
                com.google.cloud.dataform.v1.TargetOrBuilder>(
                getTarget(), getParentForChildren(), isClean());
        target_ = null;
      }
      return targetBuilder_;
    }

    private com.google.cloud.dataform.v1.Target canonicalTarget_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.Target,
            com.google.cloud.dataform.v1.Target.Builder,
            com.google.cloud.dataform.v1.TargetOrBuilder>
        canonicalTargetBuilder_;

    /**
     *
     *
     * <pre>
     * The action's identifier if the project had been compiled without any
     * overrides configured. Unique within the compilation result.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target canonical_target = 2;</code>
     *
     * @return Whether the canonicalTarget field is set.
     */
    public boolean hasCanonicalTarget() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * The action's identifier if the project had been compiled without any
     * overrides configured. Unique within the compilation result.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target canonical_target = 2;</code>
     *
     * @return The canonicalTarget.
     */
    public com.google.cloud.dataform.v1.Target getCanonicalTarget() {
      if (canonicalTargetBuilder_ == null) {
        return canonicalTarget_ == null
            ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
            : canonicalTarget_;
      } else {
        return canonicalTargetBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The action's identifier if the project had been compiled without any
     * overrides configured. Unique within the compilation result.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target canonical_target = 2;</code>
     */
    public Builder setCanonicalTarget(com.google.cloud.dataform.v1.Target value) {
      if (canonicalTargetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        canonicalTarget_ = value;
      } else {
        canonicalTargetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The action's identifier if the project had been compiled without any
     * overrides configured. Unique within the compilation result.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target canonical_target = 2;</code>
     */
    public Builder setCanonicalTarget(com.google.cloud.dataform.v1.Target.Builder builderForValue) {
      if (canonicalTargetBuilder_ == null) {
        canonicalTarget_ = builderForValue.build();
      } else {
        canonicalTargetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The action's identifier if the project had been compiled without any
     * overrides configured. Unique within the compilation result.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target canonical_target = 2;</code>
     */
    public Builder mergeCanonicalTarget(com.google.cloud.dataform.v1.Target value) {
      if (canonicalTargetBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && canonicalTarget_ != null
            && canonicalTarget_ != com.google.cloud.dataform.v1.Target.getDefaultInstance()) {
          getCanonicalTargetBuilder().mergeFrom(value);
        } else {
          canonicalTarget_ = value;
        }
      } else {
        canonicalTargetBuilder_.mergeFrom(value);
      }
      if (canonicalTarget_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The action's identifier if the project had been compiled without any
     * overrides configured. Unique within the compilation result.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target canonical_target = 2;</code>
     */
    public Builder clearCanonicalTarget() {
      bitField0_ = (bitField0_ & ~0x00000080);
      canonicalTarget_ = null;
      if (canonicalTargetBuilder_ != null) {
        canonicalTargetBuilder_.dispose();
        canonicalTargetBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The action's identifier if the project had been compiled without any
     * overrides configured. Unique within the compilation result.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target canonical_target = 2;</code>
     */
    public com.google.cloud.dataform.v1.Target.Builder getCanonicalTargetBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCanonicalTargetFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The action's identifier if the project had been compiled without any
     * overrides configured. Unique within the compilation result.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target canonical_target = 2;</code>
     */
    public com.google.cloud.dataform.v1.TargetOrBuilder getCanonicalTargetOrBuilder() {
      if (canonicalTargetBuilder_ != null) {
        return canonicalTargetBuilder_.getMessageOrBuilder();
      } else {
        return canonicalTarget_ == null
            ? com.google.cloud.dataform.v1.Target.getDefaultInstance()
            : canonicalTarget_;
      }
    }

    /**
     *
     *
     * <pre>
     * The action's identifier if the project had been compiled without any
     * overrides configured. Unique within the compilation result.
     * </pre>
     *
     * <code>.google.cloud.dataform.v1.Target canonical_target = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataform.v1.Target,
            com.google.cloud.dataform.v1.Target.Builder,
            com.google.cloud.dataform.v1.TargetOrBuilder>
        getCanonicalTargetFieldBuilder() {
      if (canonicalTargetBuilder_ == null) {
        canonicalTargetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataform.v1.Target,
                com.google.cloud.dataform.v1.Target.Builder,
                com.google.cloud.dataform.v1.TargetOrBuilder>(
                getCanonicalTarget(), getParentForChildren(), isClean());
        canonicalTarget_ = null;
      }
      return canonicalTargetBuilder_;
    }

    private java.lang.Object filePath_ = "";

    /**
     *
     *
     * <pre>
     * The full path including filename in which this action is located, relative
     * to the workspace root.
     * </pre>
     *
     * <code>string file_path = 3;</code>
     *
     * @return The filePath.
     */
    public java.lang.String getFilePath() {
      java.lang.Object ref = filePath_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filePath_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The full path including filename in which this action is located, relative
     * to the workspace root.
     * </pre>
     *
     * <code>string file_path = 3;</code>
     *
     * @return The bytes for filePath.
     */
    public com.google.protobuf.ByteString getFilePathBytes() {
      java.lang.Object ref = filePath_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filePath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The full path including filename in which this action is located, relative
     * to the workspace root.
     * </pre>
     *
     * <code>string file_path = 3;</code>
     *
     * @param value The filePath to set.
     * @return This builder for chaining.
     */
    public Builder setFilePath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filePath_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The full path including filename in which this action is located, relative
     * to the workspace root.
     * </pre>
     *
     * <code>string file_path = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilePath() {
      filePath_ = getDefaultInstance().getFilePath();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The full path including filename in which this action is located, relative
     * to the workspace root.
     * </pre>
     *
     * <code>string file_path = 3;</code>
     *
     * @param value The bytes for filePath to set.
     * @return This builder for chaining.
     */
    public Builder setFilePathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filePath_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object internalMetadata_ = "";

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the internalMetadata field is set.
     */
    public boolean hasInternalMetadata() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The internalMetadata.
     */
    public java.lang.String getInternalMetadata() {
      java.lang.Object ref = internalMetadata_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        internalMetadata_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for internalMetadata.
     */
    public com.google.protobuf.ByteString getInternalMetadataBytes() {
      java.lang.Object ref = internalMetadata_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        internalMetadata_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The internalMetadata to set.
     * @return This builder for chaining.
     */
    public Builder setInternalMetadata(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      internalMetadata_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInternalMetadata() {
      internalMetadata_ = getDefaultInstance().getInternalMetadata();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. All the metadata information that is used internally to serve
     * the resource. For example: timestamps, flags, status fields, etc. The
     * format of this field is a JSON string.
     * </pre>
     *
     * <code>optional string internal_metadata = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for internalMetadata to set.
     * @return This builder for chaining.
     */
    public Builder setInternalMetadataBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      internalMetadata_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataform.v1.CompilationResultAction)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataform.v1.CompilationResultAction)
  private static final com.google.cloud.dataform.v1.CompilationResultAction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataform.v1.CompilationResultAction();
  }

  public static com.google.cloud.dataform.v1.CompilationResultAction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CompilationResultAction> PARSER =
      new com.google.protobuf.AbstractParser<CompilationResultAction>() {
        @java.lang.Override
        public CompilationResultAction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CompilationResultAction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CompilationResultAction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataform.v1.CompilationResultAction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
