/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1/datacatalog.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.datacatalog.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [SetConfig][google.cloud.datacatalog.v1.DataCatalog.SetConfig].
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1.SetConfigRequest}
 */
public final class SetConfigRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.SetConfigRequest)
    SetConfigRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SetConfigRequest.newBuilder() to construct.
  private SetConfigRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SetConfigRequest() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SetConfigRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_SetConfigRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_SetConfigRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1.SetConfigRequest.class,
            com.google.cloud.datacatalog.v1.SetConfigRequest.Builder.class);
  }

  private int configurationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object configuration_;

  public enum ConfigurationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TAG_TEMPLATE_MIGRATION(2),
    CATALOG_UI_EXPERIENCE(3),
    CONFIGURATION_NOT_SET(0);
    private final int value;

    private ConfigurationCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConfigurationCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConfigurationCase forNumber(int value) {
      switch (value) {
        case 2:
          return TAG_TEMPLATE_MIGRATION;
        case 3:
          return CATALOG_UI_EXPERIENCE;
        case 0:
          return CONFIGURATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConfigurationCase getConfigurationCase() {
    return ConfigurationCase.forNumber(configurationCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Required. The organization or project whose config is being specified.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The organization or project whose config is being specified.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TAG_TEMPLATE_MIGRATION_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Opt-in status for the migration of Tag Templates to Dataplex.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.TagTemplateMigration tag_template_migration = 2;</code>
   *
   * @return Whether the tagTemplateMigration field is set.
   */
  public boolean hasTagTemplateMigration() {
    return configurationCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Opt-in status for the migration of Tag Templates to Dataplex.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.TagTemplateMigration tag_template_migration = 2;</code>
   *
   * @return The enum numeric value on the wire for tagTemplateMigration.
   */
  public int getTagTemplateMigrationValue() {
    if (configurationCase_ == 2) {
      return (java.lang.Integer) configuration_;
    }
    return 0;
  }

  /**
   *
   *
   * <pre>
   * Opt-in status for the migration of Tag Templates to Dataplex.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.TagTemplateMigration tag_template_migration = 2;</code>
   *
   * @return The tagTemplateMigration.
   */
  public com.google.cloud.datacatalog.v1.TagTemplateMigration getTagTemplateMigration() {
    if (configurationCase_ == 2) {
      com.google.cloud.datacatalog.v1.TagTemplateMigration result =
          com.google.cloud.datacatalog.v1.TagTemplateMigration.forNumber(
              (java.lang.Integer) configuration_);
      return result == null
          ? com.google.cloud.datacatalog.v1.TagTemplateMigration.UNRECOGNIZED
          : result;
    }
    return com.google.cloud.datacatalog.v1.TagTemplateMigration.TAG_TEMPLATE_MIGRATION_UNSPECIFIED;
  }

  public static final int CATALOG_UI_EXPERIENCE_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Opt-in status for the UI switch to Dataplex.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.CatalogUIExperience catalog_ui_experience = 3;</code>
   *
   * @return Whether the catalogUiExperience field is set.
   */
  public boolean hasCatalogUiExperience() {
    return configurationCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Opt-in status for the UI switch to Dataplex.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.CatalogUIExperience catalog_ui_experience = 3;</code>
   *
   * @return The enum numeric value on the wire for catalogUiExperience.
   */
  public int getCatalogUiExperienceValue() {
    if (configurationCase_ == 3) {
      return (java.lang.Integer) configuration_;
    }
    return 0;
  }

  /**
   *
   *
   * <pre>
   * Opt-in status for the UI switch to Dataplex.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.CatalogUIExperience catalog_ui_experience = 3;</code>
   *
   * @return The catalogUiExperience.
   */
  public com.google.cloud.datacatalog.v1.CatalogUIExperience getCatalogUiExperience() {
    if (configurationCase_ == 3) {
      com.google.cloud.datacatalog.v1.CatalogUIExperience result =
          com.google.cloud.datacatalog.v1.CatalogUIExperience.forNumber(
              (java.lang.Integer) configuration_);
      return result == null
          ? com.google.cloud.datacatalog.v1.CatalogUIExperience.UNRECOGNIZED
          : result;
    }
    return com.google.cloud.datacatalog.v1.CatalogUIExperience.CATALOG_UI_EXPERIENCE_UNSPECIFIED;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (configurationCase_ == 2) {
      output.writeEnum(2, ((java.lang.Integer) configuration_));
    }
    if (configurationCase_ == 3) {
      output.writeEnum(3, ((java.lang.Integer) configuration_));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (configurationCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(
              2, ((java.lang.Integer) configuration_));
    }
    if (configurationCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(
              3, ((java.lang.Integer) configuration_));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1.SetConfigRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1.SetConfigRequest other =
        (com.google.cloud.datacatalog.v1.SetConfigRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getConfigurationCase().equals(other.getConfigurationCase())) return false;
    switch (configurationCase_) {
      case 2:
        if (getTagTemplateMigrationValue() != other.getTagTemplateMigrationValue()) return false;
        break;
      case 3:
        if (getCatalogUiExperienceValue() != other.getCatalogUiExperienceValue()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    switch (configurationCase_) {
      case 2:
        hash = (37 * hash) + TAG_TEMPLATE_MIGRATION_FIELD_NUMBER;
        hash = (53 * hash) + getTagTemplateMigrationValue();
        break;
      case 3:
        hash = (37 * hash) + CATALOG_UI_EXPERIENCE_FIELD_NUMBER;
        hash = (53 * hash) + getCatalogUiExperienceValue();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1.SetConfigRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.SetConfigRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.SetConfigRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.SetConfigRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.SetConfigRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.SetConfigRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.SetConfigRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.SetConfigRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.SetConfigRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.SetConfigRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.SetConfigRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.SetConfigRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1.SetConfigRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [SetConfig][google.cloud.datacatalog.v1.DataCatalog.SetConfig].
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.SetConfigRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.SetConfigRequest)
      com.google.cloud.datacatalog.v1.SetConfigRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_SetConfigRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_SetConfigRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.SetConfigRequest.class,
              com.google.cloud.datacatalog.v1.SetConfigRequest.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1.SetConfigRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      configurationCase_ = 0;
      configuration_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_SetConfigRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.SetConfigRequest getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1.SetConfigRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.SetConfigRequest build() {
      com.google.cloud.datacatalog.v1.SetConfigRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.SetConfigRequest buildPartial() {
      com.google.cloud.datacatalog.v1.SetConfigRequest result =
          new com.google.cloud.datacatalog.v1.SetConfigRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1.SetConfigRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.datacatalog.v1.SetConfigRequest result) {
      result.configurationCase_ = configurationCase_;
      result.configuration_ = this.configuration_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1.SetConfigRequest) {
        return mergeFrom((com.google.cloud.datacatalog.v1.SetConfigRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1.SetConfigRequest other) {
      if (other == com.google.cloud.datacatalog.v1.SetConfigRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      switch (other.getConfigurationCase()) {
        case TAG_TEMPLATE_MIGRATION:
          {
            setTagTemplateMigrationValue(other.getTagTemplateMigrationValue());
            break;
          }
        case CATALOG_UI_EXPERIENCE:
          {
            setCatalogUiExperienceValue(other.getCatalogUiExperienceValue());
            break;
          }
        case CONFIGURATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                int rawValue = input.readEnum();
                configurationCase_ = 2;
                configuration_ = rawValue;
                break;
              } // case 16
            case 24:
              {
                int rawValue = input.readEnum();
                configurationCase_ = 3;
                configuration_ = rawValue;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int configurationCase_ = 0;
    private java.lang.Object configuration_;

    public ConfigurationCase getConfigurationCase() {
      return ConfigurationCase.forNumber(configurationCase_);
    }

    public Builder clearConfiguration() {
      configurationCase_ = 0;
      configuration_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Required. The organization or project whose config is being specified.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The organization or project whose config is being specified.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The organization or project whose config is being specified.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The organization or project whose config is being specified.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The organization or project whose config is being specified.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Opt-in status for the migration of Tag Templates to Dataplex.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.TagTemplateMigration tag_template_migration = 2;</code>
     *
     * @return Whether the tagTemplateMigration field is set.
     */
    @java.lang.Override
    public boolean hasTagTemplateMigration() {
      return configurationCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Opt-in status for the migration of Tag Templates to Dataplex.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.TagTemplateMigration tag_template_migration = 2;</code>
     *
     * @return The enum numeric value on the wire for tagTemplateMigration.
     */
    @java.lang.Override
    public int getTagTemplateMigrationValue() {
      if (configurationCase_ == 2) {
        return ((java.lang.Integer) configuration_).intValue();
      }
      return 0;
    }

    /**
     *
     *
     * <pre>
     * Opt-in status for the migration of Tag Templates to Dataplex.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.TagTemplateMigration tag_template_migration = 2;</code>
     *
     * @param value The enum numeric value on the wire for tagTemplateMigration to set.
     * @return This builder for chaining.
     */
    public Builder setTagTemplateMigrationValue(int value) {
      configurationCase_ = 2;
      configuration_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Opt-in status for the migration of Tag Templates to Dataplex.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.TagTemplateMigration tag_template_migration = 2;</code>
     *
     * @return The tagTemplateMigration.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.TagTemplateMigration getTagTemplateMigration() {
      if (configurationCase_ == 2) {
        com.google.cloud.datacatalog.v1.TagTemplateMigration result =
            com.google.cloud.datacatalog.v1.TagTemplateMigration.forNumber(
                (java.lang.Integer) configuration_);
        return result == null
            ? com.google.cloud.datacatalog.v1.TagTemplateMigration.UNRECOGNIZED
            : result;
      }
      return com.google.cloud.datacatalog.v1.TagTemplateMigration
          .TAG_TEMPLATE_MIGRATION_UNSPECIFIED;
    }

    /**
     *
     *
     * <pre>
     * Opt-in status for the migration of Tag Templates to Dataplex.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.TagTemplateMigration tag_template_migration = 2;</code>
     *
     * @param value The tagTemplateMigration to set.
     * @return This builder for chaining.
     */
    public Builder setTagTemplateMigration(
        com.google.cloud.datacatalog.v1.TagTemplateMigration value) {
      if (value == null) {
        throw new NullPointerException();
      }
      configurationCase_ = 2;
      configuration_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Opt-in status for the migration of Tag Templates to Dataplex.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.TagTemplateMigration tag_template_migration = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTagTemplateMigration() {
      if (configurationCase_ == 2) {
        configurationCase_ = 0;
        configuration_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Opt-in status for the UI switch to Dataplex.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.CatalogUIExperience catalog_ui_experience = 3;</code>
     *
     * @return Whether the catalogUiExperience field is set.
     */
    @java.lang.Override
    public boolean hasCatalogUiExperience() {
      return configurationCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Opt-in status for the UI switch to Dataplex.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.CatalogUIExperience catalog_ui_experience = 3;</code>
     *
     * @return The enum numeric value on the wire for catalogUiExperience.
     */
    @java.lang.Override
    public int getCatalogUiExperienceValue() {
      if (configurationCase_ == 3) {
        return ((java.lang.Integer) configuration_).intValue();
      }
      return 0;
    }

    /**
     *
     *
     * <pre>
     * Opt-in status for the UI switch to Dataplex.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.CatalogUIExperience catalog_ui_experience = 3;</code>
     *
     * @param value The enum numeric value on the wire for catalogUiExperience to set.
     * @return This builder for chaining.
     */
    public Builder setCatalogUiExperienceValue(int value) {
      configurationCase_ = 3;
      configuration_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Opt-in status for the UI switch to Dataplex.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.CatalogUIExperience catalog_ui_experience = 3;</code>
     *
     * @return The catalogUiExperience.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.CatalogUIExperience getCatalogUiExperience() {
      if (configurationCase_ == 3) {
        com.google.cloud.datacatalog.v1.CatalogUIExperience result =
            com.google.cloud.datacatalog.v1.CatalogUIExperience.forNumber(
                (java.lang.Integer) configuration_);
        return result == null
            ? com.google.cloud.datacatalog.v1.CatalogUIExperience.UNRECOGNIZED
            : result;
      }
      return com.google.cloud.datacatalog.v1.CatalogUIExperience.CATALOG_UI_EXPERIENCE_UNSPECIFIED;
    }

    /**
     *
     *
     * <pre>
     * Opt-in status for the UI switch to Dataplex.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.CatalogUIExperience catalog_ui_experience = 3;</code>
     *
     * @param value The catalogUiExperience to set.
     * @return This builder for chaining.
     */
    public Builder setCatalogUiExperience(
        com.google.cloud.datacatalog.v1.CatalogUIExperience value) {
      if (value == null) {
        throw new NullPointerException();
      }
      configurationCase_ = 3;
      configuration_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Opt-in status for the UI switch to Dataplex.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.CatalogUIExperience catalog_ui_experience = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCatalogUiExperience() {
      if (configurationCase_ == 3) {
        configurationCase_ = 0;
        configuration_ = null;
        onChanged();
      }
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.SetConfigRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.SetConfigRequest)
  private static final com.google.cloud.datacatalog.v1.SetConfigRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.SetConfigRequest();
  }

  public static com.google.cloud.datacatalog.v1.SetConfigRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SetConfigRequest> PARSER =
      new com.google.protobuf.AbstractParser<SetConfigRequest>() {
        @java.lang.Override
        public SetConfigRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SetConfigRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SetConfigRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1.SetConfigRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
