/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1/bigquery.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.datacatalog.v1;

/**
 *
 *
 * <pre>
 * Specification for the BigQuery connection to a Cloud SQL instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec}
 */
public final class CloudSqlBigQueryConnectionSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec)
    CloudSqlBigQueryConnectionSpecOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CloudSqlBigQueryConnectionSpec.newBuilder() to construct.
  private CloudSqlBigQueryConnectionSpec(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloudSqlBigQueryConnectionSpec() {
    instanceId_ = "";
    database_ = "";
    type_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloudSqlBigQueryConnectionSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1.BigQueryProto
        .internal_static_google_cloud_datacatalog_v1_CloudSqlBigQueryConnectionSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1.BigQueryProto
        .internal_static_google_cloud_datacatalog_v1_CloudSqlBigQueryConnectionSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.class,
            com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Supported Cloud SQL database types.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType}
   */
  public enum DatabaseType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified database type.
     * </pre>
     *
     * <code>DATABASE_TYPE_UNSPECIFIED = 0;</code>
     */
    DATABASE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Cloud SQL for PostgreSQL.
     * </pre>
     *
     * <code>POSTGRES = 1;</code>
     */
    POSTGRES(1),
    /**
     *
     *
     * <pre>
     * Cloud SQL for MySQL.
     * </pre>
     *
     * <code>MYSQL = 2;</code>
     */
    MYSQL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified database type.
     * </pre>
     *
     * <code>DATABASE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int DATABASE_TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Cloud SQL for PostgreSQL.
     * </pre>
     *
     * <code>POSTGRES = 1;</code>
     */
    public static final int POSTGRES_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Cloud SQL for MySQL.
     * </pre>
     *
     * <code>MYSQL = 2;</code>
     */
    public static final int MYSQL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DatabaseType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DatabaseType forNumber(int value) {
      switch (value) {
        case 0:
          return DATABASE_TYPE_UNSPECIFIED;
        case 1:
          return POSTGRES;
        case 2:
          return MYSQL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DatabaseType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DatabaseType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DatabaseType>() {
          public DatabaseType findValueByNumber(int number) {
            return DatabaseType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final DatabaseType[] VALUES = values();

    public static DatabaseType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DatabaseType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType)
  }

  public static final int INSTANCE_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instanceId_ = "";

  /**
   *
   *
   * <pre>
   * Cloud SQL instance ID in the format of `project:location:instance`.
   * </pre>
   *
   * <code>string instance_id = 1;</code>
   *
   * @return The instanceId.
   */
  @java.lang.Override
  public java.lang.String getInstanceId() {
    java.lang.Object ref = instanceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instanceId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Cloud SQL instance ID in the format of `project:location:instance`.
   * </pre>
   *
   * <code>string instance_id = 1;</code>
   *
   * @return The bytes for instanceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceIdBytes() {
    java.lang.Object ref = instanceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instanceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATABASE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object database_ = "";

  /**
   *
   *
   * <pre>
   * Database name.
   * </pre>
   *
   * <code>string database = 2;</code>
   *
   * @return The database.
   */
  @java.lang.Override
  public java.lang.String getDatabase() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      database_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Database name.
   * </pre>
   *
   * <code>string database = 2;</code>
   *
   * @return The bytes for database.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseBytes() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      database_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 3;
  private int type_ = 0;

  /**
   *
   *
   * <pre>
   * Type of the Cloud SQL database.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType type = 3;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }

  /**
   *
   *
   * <pre>
   * Type of the Cloud SQL database.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType type = 3;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType getType() {
    com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType result =
        com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType.forNumber(
            type_);
    return result == null
        ? com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, instanceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, database_);
    }
    if (type_
        != com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType
            .DATABASE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, type_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, instanceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, database_);
    }
    if (type_
        != com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType
            .DATABASE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, type_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec other =
        (com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec) obj;

    if (!getInstanceId().equals(other.getInstanceId())) return false;
    if (!getDatabase().equals(other.getDatabase())) return false;
    if (type_ != other.type_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INSTANCE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getInstanceId().hashCode();
    hash = (37 * hash) + DATABASE_FIELD_NUMBER;
    hash = (53 * hash) + getDatabase().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Specification for the BigQuery connection to a Cloud SQL instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec)
      com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.BigQueryProto
          .internal_static_google_cloud_datacatalog_v1_CloudSqlBigQueryConnectionSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.BigQueryProto
          .internal_static_google_cloud_datacatalog_v1_CloudSqlBigQueryConnectionSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.class,
              com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      instanceId_ = "";
      database_ = "";
      type_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1.BigQueryProto
          .internal_static_google_cloud_datacatalog_v1_CloudSqlBigQueryConnectionSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec
        getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec build() {
      com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec buildPartial() {
      com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec result =
          new com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.instanceId_ = instanceId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.database_ = database_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.type_ = type_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec) {
        return mergeFrom((com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec other) {
      if (other
          == com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.getDefaultInstance())
        return this;
      if (!other.getInstanceId().isEmpty()) {
        instanceId_ = other.instanceId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDatabase().isEmpty()) {
        database_ = other.database_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                instanceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                database_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object instanceId_ = "";

    /**
     *
     *
     * <pre>
     * Cloud SQL instance ID in the format of `project:location:instance`.
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @return The instanceId.
     */
    public java.lang.String getInstanceId() {
      java.lang.Object ref = instanceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Cloud SQL instance ID in the format of `project:location:instance`.
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @return The bytes for instanceId.
     */
    public com.google.protobuf.ByteString getInstanceIdBytes() {
      java.lang.Object ref = instanceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Cloud SQL instance ID in the format of `project:location:instance`.
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @param value The instanceId to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instanceId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cloud SQL instance ID in the format of `project:location:instance`.
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceId() {
      instanceId_ = getDefaultInstance().getInstanceId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cloud SQL instance ID in the format of `project:location:instance`.
     * </pre>
     *
     * <code>string instance_id = 1;</code>
     *
     * @param value The bytes for instanceId to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instanceId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object database_ = "";

    /**
     *
     *
     * <pre>
     * Database name.
     * </pre>
     *
     * <code>string database = 2;</code>
     *
     * @return The database.
     */
    public java.lang.String getDatabase() {
      java.lang.Object ref = database_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        database_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Database name.
     * </pre>
     *
     * <code>string database = 2;</code>
     *
     * @return The bytes for database.
     */
    public com.google.protobuf.ByteString getDatabaseBytes() {
      java.lang.Object ref = database_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        database_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Database name.
     * </pre>
     *
     * <code>string database = 2;</code>
     *
     * @param value The database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      database_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Database name.
     * </pre>
     *
     * <code>string database = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabase() {
      database_ = getDefaultInstance().getDatabase();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Database name.
     * </pre>
     *
     * <code>string database = 2;</code>
     *
     * @param value The bytes for database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      database_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int type_ = 0;

    /**
     *
     *
     * <pre>
     * Type of the Cloud SQL database.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType type = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }

    /**
     *
     *
     * <pre>
     * Type of the Cloud SQL database.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType type = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Type of the Cloud SQL database.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType type = 3;
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType getType() {
      com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType result =
          com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType.forNumber(
              type_);
      return result == null
          ? com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Type of the Cloud SQL database.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType type = 3;
     * </code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(
        com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      type_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Type of the Cloud SQL database.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec.DatabaseType type = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      type_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec)
  private static final com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec();
  }

  public static com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloudSqlBigQueryConnectionSpec> PARSER =
      new com.google.protobuf.AbstractParser<CloudSqlBigQueryConnectionSpec>() {
        @java.lang.Override
        public CloudSqlBigQueryConnectionSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloudSqlBigQueryConnectionSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloudSqlBigQueryConnectionSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1.CloudSqlBigQueryConnectionSpec
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
