/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1/datacatalog.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.datacatalog.v1;

/**
 *
 *
 * <pre>
 * Specification that applies to
 * entries that are part `LOOKER` system
 * (user_specified_type)
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1.LookerSystemSpec}
 */
public final class LookerSystemSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.LookerSystemSpec)
    LookerSystemSpecOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use LookerSystemSpec.newBuilder() to construct.
  private LookerSystemSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LookerSystemSpec() {
    parentInstanceId_ = "";
    parentInstanceDisplayName_ = "";
    parentModelId_ = "";
    parentModelDisplayName_ = "";
    parentViewId_ = "";
    parentViewDisplayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LookerSystemSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_LookerSystemSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_LookerSystemSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1.LookerSystemSpec.class,
            com.google.cloud.datacatalog.v1.LookerSystemSpec.Builder.class);
  }

  public static final int PARENT_INSTANCE_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parentInstanceId_ = "";

  /**
   *
   *
   * <pre>
   * ID of the parent Looker Instance. Empty if it does not exist.
   * Example value: `someinstance.looker.com`
   * </pre>
   *
   * <code>string parent_instance_id = 1;</code>
   *
   * @return The parentInstanceId.
   */
  @java.lang.Override
  public java.lang.String getParentInstanceId() {
    java.lang.Object ref = parentInstanceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parentInstanceId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * ID of the parent Looker Instance. Empty if it does not exist.
   * Example value: `someinstance.looker.com`
   * </pre>
   *
   * <code>string parent_instance_id = 1;</code>
   *
   * @return The bytes for parentInstanceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentInstanceIdBytes() {
    java.lang.Object ref = parentInstanceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parentInstanceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_INSTANCE_DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parentInstanceDisplayName_ = "";

  /**
   *
   *
   * <pre>
   * Name of the parent Looker Instance. Empty if it does not exist.
   * </pre>
   *
   * <code>string parent_instance_display_name = 2;</code>
   *
   * @return The parentInstanceDisplayName.
   */
  @java.lang.Override
  public java.lang.String getParentInstanceDisplayName() {
    java.lang.Object ref = parentInstanceDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parentInstanceDisplayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the parent Looker Instance. Empty if it does not exist.
   * </pre>
   *
   * <code>string parent_instance_display_name = 2;</code>
   *
   * @return The bytes for parentInstanceDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentInstanceDisplayNameBytes() {
    java.lang.Object ref = parentInstanceDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parentInstanceDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_MODEL_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parentModelId_ = "";

  /**
   *
   *
   * <pre>
   * ID of the parent Model. Empty if it does not exist.
   * </pre>
   *
   * <code>string parent_model_id = 3;</code>
   *
   * @return The parentModelId.
   */
  @java.lang.Override
  public java.lang.String getParentModelId() {
    java.lang.Object ref = parentModelId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parentModelId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * ID of the parent Model. Empty if it does not exist.
   * </pre>
   *
   * <code>string parent_model_id = 3;</code>
   *
   * @return The bytes for parentModelId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentModelIdBytes() {
    java.lang.Object ref = parentModelId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parentModelId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_MODEL_DISPLAY_NAME_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parentModelDisplayName_ = "";

  /**
   *
   *
   * <pre>
   * Name of the parent Model. Empty if it does not exist.
   * </pre>
   *
   * <code>string parent_model_display_name = 4;</code>
   *
   * @return The parentModelDisplayName.
   */
  @java.lang.Override
  public java.lang.String getParentModelDisplayName() {
    java.lang.Object ref = parentModelDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parentModelDisplayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the parent Model. Empty if it does not exist.
   * </pre>
   *
   * <code>string parent_model_display_name = 4;</code>
   *
   * @return The bytes for parentModelDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentModelDisplayNameBytes() {
    java.lang.Object ref = parentModelDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parentModelDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_VIEW_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parentViewId_ = "";

  /**
   *
   *
   * <pre>
   * ID of the parent View. Empty if it does not exist.
   * </pre>
   *
   * <code>string parent_view_id = 5;</code>
   *
   * @return The parentViewId.
   */
  @java.lang.Override
  public java.lang.String getParentViewId() {
    java.lang.Object ref = parentViewId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parentViewId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * ID of the parent View. Empty if it does not exist.
   * </pre>
   *
   * <code>string parent_view_id = 5;</code>
   *
   * @return The bytes for parentViewId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentViewIdBytes() {
    java.lang.Object ref = parentViewId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parentViewId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_VIEW_DISPLAY_NAME_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parentViewDisplayName_ = "";

  /**
   *
   *
   * <pre>
   * Name of the parent View. Empty if it does not exist.
   * </pre>
   *
   * <code>string parent_view_display_name = 6;</code>
   *
   * @return The parentViewDisplayName.
   */
  @java.lang.Override
  public java.lang.String getParentViewDisplayName() {
    java.lang.Object ref = parentViewDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parentViewDisplayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the parent View. Empty if it does not exist.
   * </pre>
   *
   * <code>string parent_view_display_name = 6;</code>
   *
   * @return The bytes for parentViewDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentViewDisplayNameBytes() {
    java.lang.Object ref = parentViewDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parentViewDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentInstanceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parentInstanceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentInstanceDisplayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, parentInstanceDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentModelId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, parentModelId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentModelDisplayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, parentModelDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentViewId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, parentViewId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentViewDisplayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, parentViewDisplayName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentInstanceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parentInstanceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentInstanceDisplayName_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(2, parentInstanceDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentModelId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, parentModelId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentModelDisplayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, parentModelDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentViewId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, parentViewId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentViewDisplayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, parentViewDisplayName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1.LookerSystemSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1.LookerSystemSpec other =
        (com.google.cloud.datacatalog.v1.LookerSystemSpec) obj;

    if (!getParentInstanceId().equals(other.getParentInstanceId())) return false;
    if (!getParentInstanceDisplayName().equals(other.getParentInstanceDisplayName())) return false;
    if (!getParentModelId().equals(other.getParentModelId())) return false;
    if (!getParentModelDisplayName().equals(other.getParentModelDisplayName())) return false;
    if (!getParentViewId().equals(other.getParentViewId())) return false;
    if (!getParentViewDisplayName().equals(other.getParentViewDisplayName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_INSTANCE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getParentInstanceId().hashCode();
    hash = (37 * hash) + PARENT_INSTANCE_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getParentInstanceDisplayName().hashCode();
    hash = (37 * hash) + PARENT_MODEL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getParentModelId().hashCode();
    hash = (37 * hash) + PARENT_MODEL_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getParentModelDisplayName().hashCode();
    hash = (37 * hash) + PARENT_VIEW_ID_FIELD_NUMBER;
    hash = (53 * hash) + getParentViewId().hashCode();
    hash = (37 * hash) + PARENT_VIEW_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getParentViewDisplayName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1.LookerSystemSpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.LookerSystemSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.LookerSystemSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.LookerSystemSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.LookerSystemSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.LookerSystemSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.LookerSystemSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.LookerSystemSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.LookerSystemSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.LookerSystemSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.LookerSystemSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.LookerSystemSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1.LookerSystemSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Specification that applies to
   * entries that are part `LOOKER` system
   * (user_specified_type)
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.LookerSystemSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.LookerSystemSpec)
      com.google.cloud.datacatalog.v1.LookerSystemSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_LookerSystemSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_LookerSystemSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.LookerSystemSpec.class,
              com.google.cloud.datacatalog.v1.LookerSystemSpec.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1.LookerSystemSpec.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parentInstanceId_ = "";
      parentInstanceDisplayName_ = "";
      parentModelId_ = "";
      parentModelDisplayName_ = "";
      parentViewId_ = "";
      parentViewDisplayName_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_LookerSystemSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.LookerSystemSpec getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1.LookerSystemSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.LookerSystemSpec build() {
      com.google.cloud.datacatalog.v1.LookerSystemSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.LookerSystemSpec buildPartial() {
      com.google.cloud.datacatalog.v1.LookerSystemSpec result =
          new com.google.cloud.datacatalog.v1.LookerSystemSpec(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1.LookerSystemSpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parentInstanceId_ = parentInstanceId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.parentInstanceDisplayName_ = parentInstanceDisplayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.parentModelId_ = parentModelId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.parentModelDisplayName_ = parentModelDisplayName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.parentViewId_ = parentViewId_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.parentViewDisplayName_ = parentViewDisplayName_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1.LookerSystemSpec) {
        return mergeFrom((com.google.cloud.datacatalog.v1.LookerSystemSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1.LookerSystemSpec other) {
      if (other == com.google.cloud.datacatalog.v1.LookerSystemSpec.getDefaultInstance())
        return this;
      if (!other.getParentInstanceId().isEmpty()) {
        parentInstanceId_ = other.parentInstanceId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getParentInstanceDisplayName().isEmpty()) {
        parentInstanceDisplayName_ = other.parentInstanceDisplayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getParentModelId().isEmpty()) {
        parentModelId_ = other.parentModelId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getParentModelDisplayName().isEmpty()) {
        parentModelDisplayName_ = other.parentModelDisplayName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getParentViewId().isEmpty()) {
        parentViewId_ = other.parentViewId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getParentViewDisplayName().isEmpty()) {
        parentViewDisplayName_ = other.parentViewDisplayName_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parentInstanceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                parentInstanceDisplayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                parentModelId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                parentModelDisplayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                parentViewId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                parentViewDisplayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parentInstanceId_ = "";

    /**
     *
     *
     * <pre>
     * ID of the parent Looker Instance. Empty if it does not exist.
     * Example value: `someinstance.looker.com`
     * </pre>
     *
     * <code>string parent_instance_id = 1;</code>
     *
     * @return The parentInstanceId.
     */
    public java.lang.String getParentInstanceId() {
      java.lang.Object ref = parentInstanceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parentInstanceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * ID of the parent Looker Instance. Empty if it does not exist.
     * Example value: `someinstance.looker.com`
     * </pre>
     *
     * <code>string parent_instance_id = 1;</code>
     *
     * @return The bytes for parentInstanceId.
     */
    public com.google.protobuf.ByteString getParentInstanceIdBytes() {
      java.lang.Object ref = parentInstanceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parentInstanceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * ID of the parent Looker Instance. Empty if it does not exist.
     * Example value: `someinstance.looker.com`
     * </pre>
     *
     * <code>string parent_instance_id = 1;</code>
     *
     * @param value The parentInstanceId to set.
     * @return This builder for chaining.
     */
    public Builder setParentInstanceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parentInstanceId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * ID of the parent Looker Instance. Empty if it does not exist.
     * Example value: `someinstance.looker.com`
     * </pre>
     *
     * <code>string parent_instance_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentInstanceId() {
      parentInstanceId_ = getDefaultInstance().getParentInstanceId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * ID of the parent Looker Instance. Empty if it does not exist.
     * Example value: `someinstance.looker.com`
     * </pre>
     *
     * <code>string parent_instance_id = 1;</code>
     *
     * @param value The bytes for parentInstanceId to set.
     * @return This builder for chaining.
     */
    public Builder setParentInstanceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parentInstanceId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object parentInstanceDisplayName_ = "";

    /**
     *
     *
     * <pre>
     * Name of the parent Looker Instance. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_instance_display_name = 2;</code>
     *
     * @return The parentInstanceDisplayName.
     */
    public java.lang.String getParentInstanceDisplayName() {
      java.lang.Object ref = parentInstanceDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parentInstanceDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the parent Looker Instance. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_instance_display_name = 2;</code>
     *
     * @return The bytes for parentInstanceDisplayName.
     */
    public com.google.protobuf.ByteString getParentInstanceDisplayNameBytes() {
      java.lang.Object ref = parentInstanceDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parentInstanceDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the parent Looker Instance. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_instance_display_name = 2;</code>
     *
     * @param value The parentInstanceDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setParentInstanceDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parentInstanceDisplayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the parent Looker Instance. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_instance_display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentInstanceDisplayName() {
      parentInstanceDisplayName_ = getDefaultInstance().getParentInstanceDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the parent Looker Instance. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_instance_display_name = 2;</code>
     *
     * @param value The bytes for parentInstanceDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setParentInstanceDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parentInstanceDisplayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object parentModelId_ = "";

    /**
     *
     *
     * <pre>
     * ID of the parent Model. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_model_id = 3;</code>
     *
     * @return The parentModelId.
     */
    public java.lang.String getParentModelId() {
      java.lang.Object ref = parentModelId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parentModelId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * ID of the parent Model. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_model_id = 3;</code>
     *
     * @return The bytes for parentModelId.
     */
    public com.google.protobuf.ByteString getParentModelIdBytes() {
      java.lang.Object ref = parentModelId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parentModelId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * ID of the parent Model. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_model_id = 3;</code>
     *
     * @param value The parentModelId to set.
     * @return This builder for chaining.
     */
    public Builder setParentModelId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parentModelId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * ID of the parent Model. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_model_id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentModelId() {
      parentModelId_ = getDefaultInstance().getParentModelId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * ID of the parent Model. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_model_id = 3;</code>
     *
     * @param value The bytes for parentModelId to set.
     * @return This builder for chaining.
     */
    public Builder setParentModelIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parentModelId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object parentModelDisplayName_ = "";

    /**
     *
     *
     * <pre>
     * Name of the parent Model. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_model_display_name = 4;</code>
     *
     * @return The parentModelDisplayName.
     */
    public java.lang.String getParentModelDisplayName() {
      java.lang.Object ref = parentModelDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parentModelDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the parent Model. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_model_display_name = 4;</code>
     *
     * @return The bytes for parentModelDisplayName.
     */
    public com.google.protobuf.ByteString getParentModelDisplayNameBytes() {
      java.lang.Object ref = parentModelDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parentModelDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the parent Model. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_model_display_name = 4;</code>
     *
     * @param value The parentModelDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setParentModelDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parentModelDisplayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the parent Model. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_model_display_name = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentModelDisplayName() {
      parentModelDisplayName_ = getDefaultInstance().getParentModelDisplayName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the parent Model. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_model_display_name = 4;</code>
     *
     * @param value The bytes for parentModelDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setParentModelDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parentModelDisplayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object parentViewId_ = "";

    /**
     *
     *
     * <pre>
     * ID of the parent View. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_view_id = 5;</code>
     *
     * @return The parentViewId.
     */
    public java.lang.String getParentViewId() {
      java.lang.Object ref = parentViewId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parentViewId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * ID of the parent View. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_view_id = 5;</code>
     *
     * @return The bytes for parentViewId.
     */
    public com.google.protobuf.ByteString getParentViewIdBytes() {
      java.lang.Object ref = parentViewId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parentViewId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * ID of the parent View. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_view_id = 5;</code>
     *
     * @param value The parentViewId to set.
     * @return This builder for chaining.
     */
    public Builder setParentViewId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parentViewId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * ID of the parent View. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_view_id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentViewId() {
      parentViewId_ = getDefaultInstance().getParentViewId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * ID of the parent View. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_view_id = 5;</code>
     *
     * @param value The bytes for parentViewId to set.
     * @return This builder for chaining.
     */
    public Builder setParentViewIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parentViewId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object parentViewDisplayName_ = "";

    /**
     *
     *
     * <pre>
     * Name of the parent View. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_view_display_name = 6;</code>
     *
     * @return The parentViewDisplayName.
     */
    public java.lang.String getParentViewDisplayName() {
      java.lang.Object ref = parentViewDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parentViewDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the parent View. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_view_display_name = 6;</code>
     *
     * @return The bytes for parentViewDisplayName.
     */
    public com.google.protobuf.ByteString getParentViewDisplayNameBytes() {
      java.lang.Object ref = parentViewDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parentViewDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the parent View. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_view_display_name = 6;</code>
     *
     * @param value The parentViewDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setParentViewDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parentViewDisplayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the parent View. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_view_display_name = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentViewDisplayName() {
      parentViewDisplayName_ = getDefaultInstance().getParentViewDisplayName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the parent View. Empty if it does not exist.
     * </pre>
     *
     * <code>string parent_view_display_name = 6;</code>
     *
     * @param value The bytes for parentViewDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setParentViewDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parentViewDisplayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.LookerSystemSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.LookerSystemSpec)
  private static final com.google.cloud.datacatalog.v1.LookerSystemSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.LookerSystemSpec();
  }

  public static com.google.cloud.datacatalog.v1.LookerSystemSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LookerSystemSpec> PARSER =
      new com.google.protobuf.AbstractParser<LookerSystemSpec>() {
        @java.lang.Override
        public LookerSystemSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LookerSystemSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LookerSystemSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1.LookerSystemSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
