/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1/schema.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.datacatalog.v1;

/**
 *
 *
 * <pre>
 * A column within a schema. Columns can be nested inside
 * other columns.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1.ColumnSchema}
 */
public final class ColumnSchema extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.ColumnSchema)
    ColumnSchemaOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ColumnSchema.newBuilder() to construct.
  private ColumnSchema(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ColumnSchema() {
    column_ = "";
    type_ = "";
    description_ = "";
    mode_ = "";
    defaultValue_ = "";
    highestIndexingType_ = 0;
    subcolumns_ = java.util.Collections.emptyList();
    gcRule_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ColumnSchema();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1.SchemaOuterClass
        .internal_static_google_cloud_datacatalog_v1_ColumnSchema_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1.SchemaOuterClass
        .internal_static_google_cloud_datacatalog_v1_ColumnSchema_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1.ColumnSchema.class,
            com.google.cloud.datacatalog.v1.ColumnSchema.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies inclusion of the column in an index
   * </pre>
   *
   * Protobuf enum {@code google.cloud.datacatalog.v1.ColumnSchema.IndexingType}
   */
  public enum IndexingType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>INDEXING_TYPE_UNSPECIFIED = 0;</code>
     */
    INDEXING_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Column not a part of an index.
     * </pre>
     *
     * <code>INDEXING_TYPE_NONE = 1;</code>
     */
    INDEXING_TYPE_NONE(1),
    /**
     *
     *
     * <pre>
     * Column Part of non unique index.
     * </pre>
     *
     * <code>INDEXING_TYPE_NON_UNIQUE = 2;</code>
     */
    INDEXING_TYPE_NON_UNIQUE(2),
    /**
     *
     *
     * <pre>
     * Column part of unique index.
     * </pre>
     *
     * <code>INDEXING_TYPE_UNIQUE = 3;</code>
     */
    INDEXING_TYPE_UNIQUE(3),
    /**
     *
     *
     * <pre>
     * Column part of the primary key.
     * </pre>
     *
     * <code>INDEXING_TYPE_PRIMARY_KEY = 4;</code>
     */
    INDEXING_TYPE_PRIMARY_KEY(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>INDEXING_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int INDEXING_TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Column not a part of an index.
     * </pre>
     *
     * <code>INDEXING_TYPE_NONE = 1;</code>
     */
    public static final int INDEXING_TYPE_NONE_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Column Part of non unique index.
     * </pre>
     *
     * <code>INDEXING_TYPE_NON_UNIQUE = 2;</code>
     */
    public static final int INDEXING_TYPE_NON_UNIQUE_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Column part of unique index.
     * </pre>
     *
     * <code>INDEXING_TYPE_UNIQUE = 3;</code>
     */
    public static final int INDEXING_TYPE_UNIQUE_VALUE = 3;

    /**
     *
     *
     * <pre>
     * Column part of the primary key.
     * </pre>
     *
     * <code>INDEXING_TYPE_PRIMARY_KEY = 4;</code>
     */
    public static final int INDEXING_TYPE_PRIMARY_KEY_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IndexingType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IndexingType forNumber(int value) {
      switch (value) {
        case 0:
          return INDEXING_TYPE_UNSPECIFIED;
        case 1:
          return INDEXING_TYPE_NONE;
        case 2:
          return INDEXING_TYPE_NON_UNIQUE;
        case 3:
          return INDEXING_TYPE_UNIQUE;
        case 4:
          return INDEXING_TYPE_PRIMARY_KEY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IndexingType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IndexingType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<IndexingType>() {
          public IndexingType findValueByNumber(int number) {
            return IndexingType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.ColumnSchema.getDescriptor().getEnumTypes().get(0);
    }

    private static final IndexingType[] VALUES = values();

    public static IndexingType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IndexingType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.datacatalog.v1.ColumnSchema.IndexingType)
  }

  public interface LookerColumnSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Looker specific column type of this column.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType type = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();

    /**
     *
     *
     * <pre>
     * Looker specific column type of this column.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType type = 1;
     * </code>
     *
     * @return The type.
     */
    com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType getType();
  }

  /**
   *
   *
   * <pre>
   * Column info specific to Looker System.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec}
   */
  public static final class LookerColumnSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec)
      LookerColumnSpecOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use LookerColumnSpec.newBuilder() to construct.
    private LookerColumnSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LookerColumnSpec() {
      type_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LookerColumnSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.SchemaOuterClass
          .internal_static_google_cloud_datacatalog_v1_ColumnSchema_LookerColumnSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.SchemaOuterClass
          .internal_static_google_cloud_datacatalog_v1_ColumnSchema_LookerColumnSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.class,
              com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Column type in Looker.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType}
     */
    public enum LookerColumnType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified.
       * </pre>
       *
       * <code>LOOKER_COLUMN_TYPE_UNSPECIFIED = 0;</code>
       */
      LOOKER_COLUMN_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Dimension.
       * </pre>
       *
       * <code>DIMENSION = 1;</code>
       */
      DIMENSION(1),
      /**
       *
       *
       * <pre>
       * Dimension group - parent for Dimension.
       * </pre>
       *
       * <code>DIMENSION_GROUP = 2;</code>
       */
      DIMENSION_GROUP(2),
      /**
       *
       *
       * <pre>
       * Filter.
       * </pre>
       *
       * <code>FILTER = 3;</code>
       */
      FILTER(3),
      /**
       *
       *
       * <pre>
       * Measure.
       * </pre>
       *
       * <code>MEASURE = 4;</code>
       */
      MEASURE(4),
      /**
       *
       *
       * <pre>
       * Parameter.
       * </pre>
       *
       * <code>PARAMETER = 5;</code>
       */
      PARAMETER(5),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified.
       * </pre>
       *
       * <code>LOOKER_COLUMN_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int LOOKER_COLUMN_TYPE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Dimension.
       * </pre>
       *
       * <code>DIMENSION = 1;</code>
       */
      public static final int DIMENSION_VALUE = 1;

      /**
       *
       *
       * <pre>
       * Dimension group - parent for Dimension.
       * </pre>
       *
       * <code>DIMENSION_GROUP = 2;</code>
       */
      public static final int DIMENSION_GROUP_VALUE = 2;

      /**
       *
       *
       * <pre>
       * Filter.
       * </pre>
       *
       * <code>FILTER = 3;</code>
       */
      public static final int FILTER_VALUE = 3;

      /**
       *
       *
       * <pre>
       * Measure.
       * </pre>
       *
       * <code>MEASURE = 4;</code>
       */
      public static final int MEASURE_VALUE = 4;

      /**
       *
       *
       * <pre>
       * Parameter.
       * </pre>
       *
       * <code>PARAMETER = 5;</code>
       */
      public static final int PARAMETER_VALUE = 5;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static LookerColumnType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static LookerColumnType forNumber(int value) {
        switch (value) {
          case 0:
            return LOOKER_COLUMN_TYPE_UNSPECIFIED;
          case 1:
            return DIMENSION;
          case 2:
            return DIMENSION_GROUP;
          case 3:
            return FILTER;
          case 4:
            return MEASURE;
          case 5:
            return PARAMETER;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<LookerColumnType>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<LookerColumnType>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<LookerColumnType>() {
                public LookerColumnType findValueByNumber(int number) {
                  return LookerColumnType.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final LookerColumnType[] VALUES = values();

      public static LookerColumnType valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private LookerColumnType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType)
    }

    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_ = 0;

    /**
     *
     *
     * <pre>
     * Looker specific column type of this column.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType type = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }

    /**
     *
     *
     * <pre>
     * Looker specific column type of this column.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType type = 1;
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType
        getType() {
      com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType result =
          com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType.forNumber(
              type_);
      return result == null
          ? com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (type_
          != com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType
              .LOOKER_COLUMN_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, type_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (type_
          != com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType
              .LOOKER_COLUMN_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec other =
          (com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec) obj;

      if (type_ != other.type_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Column info specific to Looker System.
     * </pre>
     *
     * Protobuf type {@code google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec)
        com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datacatalog.v1.SchemaOuterClass
            .internal_static_google_cloud_datacatalog_v1_ColumnSchema_LookerColumnSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datacatalog.v1.SchemaOuterClass
            .internal_static_google_cloud_datacatalog_v1_ColumnSchema_LookerColumnSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.class,
                com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.Builder.class);
      }

      // Construct using com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datacatalog.v1.SchemaOuterClass
            .internal_static_google_cloud_datacatalog_v1_ColumnSchema_LookerColumnSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec
          getDefaultInstanceForType() {
        return com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec build() {
        com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec buildPartial() {
        com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec result =
            new com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec) {
          return mergeFrom((com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec other) {
        if (other
            == com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.getDefaultInstance())
          return this;
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  type_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int type_ = 0;

      /**
       *
       *
       * <pre>
       * Looker specific column type of this column.
       * </pre>
       *
       * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType type = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }

      /**
       *
       *
       * <pre>
       * Looker specific column type of this column.
       * </pre>
       *
       * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType type = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Looker specific column type of this column.
       * </pre>
       *
       * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType type = 1;
       * </code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType
          getType() {
        com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType result =
            com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType
                .forNumber(type_);
        return result == null
            ? com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType
                .UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Looker specific column type of this column.
       * </pre>
       *
       * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType type = 1;
       * </code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(
          com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Looker specific column type of this column.
       * </pre>
       *
       * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType type = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec)
    private static final com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec();
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LookerColumnSpec> PARSER =
        new com.google.protobuf.AbstractParser<LookerColumnSpec>() {
          @java.lang.Override
          public LookerColumnSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LookerColumnSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LookerColumnSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FieldElementTypeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datacatalog.v1.ColumnSchema.FieldElementType)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The type of a field element. See
     * [ColumnSchema.type][google.cloud.datacatalog.v1.ColumnSchema.type].
     * </pre>
     *
     * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The type.
     */
    java.lang.String getType();

    /**
     *
     *
     * <pre>
     * Required. The type of a field element. See
     * [ColumnSchema.type][google.cloud.datacatalog.v1.ColumnSchema.type].
     * </pre>
     *
     * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for type.
     */
    com.google.protobuf.ByteString getTypeBytes();
  }

  /**
   *
   *
   * <pre>
   * Represents the type of a field element.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.ColumnSchema.FieldElementType}
   */
  public static final class FieldElementType extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.ColumnSchema.FieldElementType)
      FieldElementTypeOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use FieldElementType.newBuilder() to construct.
    private FieldElementType(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FieldElementType() {
      type_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FieldElementType();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.SchemaOuterClass
          .internal_static_google_cloud_datacatalog_v1_ColumnSchema_FieldElementType_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.SchemaOuterClass
          .internal_static_google_cloud_datacatalog_v1_ColumnSchema_FieldElementType_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType.class,
              com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType.Builder.class);
    }

    public static final int TYPE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object type_ = "";

    /**
     *
     *
     * <pre>
     * Required. The type of a field element. See
     * [ColumnSchema.type][google.cloud.datacatalog.v1.ColumnSchema.type].
     * </pre>
     *
     * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The type of a field element. See
     * [ColumnSchema.type][google.cloud.datacatalog.v1.ColumnSchema.type].
     * </pre>
     *
     * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for type.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType)) {
        return super.equals(obj);
      }
      com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType other =
          (com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType) obj;

      if (!getType().equals(other.getType())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Represents the type of a field element.
     * </pre>
     *
     * Protobuf type {@code google.cloud.datacatalog.v1.ColumnSchema.FieldElementType}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.ColumnSchema.FieldElementType)
        com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementTypeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datacatalog.v1.SchemaOuterClass
            .internal_static_google_cloud_datacatalog_v1_ColumnSchema_FieldElementType_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datacatalog.v1.SchemaOuterClass
            .internal_static_google_cloud_datacatalog_v1_ColumnSchema_FieldElementType_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType.class,
                com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType.Builder.class);
      }

      // Construct using com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datacatalog.v1.SchemaOuterClass
            .internal_static_google_cloud_datacatalog_v1_ColumnSchema_FieldElementType_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType
          getDefaultInstanceForType() {
        return com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType build() {
        com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType buildPartial() {
        com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType result =
            new com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType) {
          return mergeFrom((com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType other) {
        if (other
            == com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType.getDefaultInstance())
          return this;
        if (!other.getType().isEmpty()) {
          type_ = other.type_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  type_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object type_ = "";

      /**
       *
       *
       * <pre>
       * Required. The type of a field element. See
       * [ColumnSchema.type][google.cloud.datacatalog.v1.ColumnSchema.type].
       * </pre>
       *
       * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The type.
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          type_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The type of a field element. See
       * [ColumnSchema.type][google.cloud.datacatalog.v1.ColumnSchema.type].
       * </pre>
       *
       * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for type.
       */
      public com.google.protobuf.ByteString getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The type of a field element. See
       * [ColumnSchema.type][google.cloud.datacatalog.v1.ColumnSchema.type].
       * </pre>
       *
       * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The type of a field element. See
       * [ColumnSchema.type][google.cloud.datacatalog.v1.ColumnSchema.type].
       * </pre>
       *
       * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        type_ = getDefaultInstance().getType();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The type of a field element. See
       * [ColumnSchema.type][google.cloud.datacatalog.v1.ColumnSchema.type].
       * </pre>
       *
       * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        type_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.ColumnSchema.FieldElementType)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.ColumnSchema.FieldElementType)
    private static final com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType();
    }

    public static com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FieldElementType> PARSER =
        new com.google.protobuf.AbstractParser<FieldElementType>() {
          @java.lang.Override
          public FieldElementType parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FieldElementType> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FieldElementType> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int systemSpecCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object systemSpec_;

  public enum SystemSpecCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    LOOKER_COLUMN_SPEC(18),
    SYSTEMSPEC_NOT_SET(0);
    private final int value;

    private SystemSpecCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SystemSpecCase valueOf(int value) {
      return forNumber(value);
    }

    public static SystemSpecCase forNumber(int value) {
      switch (value) {
        case 18:
          return LOOKER_COLUMN_SPEC;
        case 0:
          return SYSTEMSPEC_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SystemSpecCase getSystemSpecCase() {
    return SystemSpecCase.forNumber(systemSpecCase_);
  }

  public static final int COLUMN_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object column_ = "";

  /**
   *
   *
   * <pre>
   * Required. Name of the column.
   *
   * Must be a UTF-8 string without dots (.).
   * The maximum size is 64 bytes.
   * </pre>
   *
   * <code>string column = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The column.
   */
  @java.lang.Override
  public java.lang.String getColumn() {
    java.lang.Object ref = column_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      column_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Name of the column.
   *
   * Must be a UTF-8 string without dots (.).
   * The maximum size is 64 bytes.
   * </pre>
   *
   * <code>string column = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for column.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getColumnBytes() {
    java.lang.Object ref = column_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      column_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";

  /**
   *
   *
   * <pre>
   * Required. Type of the column.
   *
   * Must be a UTF-8 string with the maximum size of 128 bytes.
   * </pre>
   *
   * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Type of the column.
   *
   * Must be a UTF-8 string with the maximum size of 128 bytes.
   * </pre>
   *
   * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Description of the column. Default value is an empty string.
   *
   * The description must be a UTF-8 string with the maximum size of 2000
   * bytes.
   * </pre>
   *
   * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Description of the column. Default value is an empty string.
   *
   * The description must be a UTF-8 string with the maximum size of 2000
   * bytes.
   * </pre>
   *
   * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object mode_ = "";

  /**
   *
   *
   * <pre>
   * Optional. A column's mode indicates whether values in this column are
   * required, nullable, or repeated.
   *
   * Only `NULLABLE`, `REQUIRED`, and `REPEATED` values are supported.
   * Default mode is `NULLABLE`.
   * </pre>
   *
   * <code>string mode = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The mode.
   */
  @java.lang.Override
  public java.lang.String getMode() {
    java.lang.Object ref = mode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      mode_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. A column's mode indicates whether values in this column are
   * required, nullable, or repeated.
   *
   * Only `NULLABLE`, `REQUIRED`, and `REPEATED` values are supported.
   * Default mode is `NULLABLE`.
   * </pre>
   *
   * <code>string mode = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for mode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModeBytes() {
    java.lang.Object ref = mode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      mode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFAULT_VALUE_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultValue_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Default value for the column.
   * </pre>
   *
   * <code>string default_value = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The defaultValue.
   */
  @java.lang.Override
  public java.lang.String getDefaultValue() {
    java.lang.Object ref = defaultValue_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultValue_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Default value for the column.
   * </pre>
   *
   * <code>string default_value = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for defaultValue.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultValueBytes() {
    java.lang.Object ref = defaultValue_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultValue_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORDINAL_POSITION_FIELD_NUMBER = 9;
  private int ordinalPosition_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Ordinal position
   * </pre>
   *
   * <code>int32 ordinal_position = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The ordinalPosition.
   */
  @java.lang.Override
  public int getOrdinalPosition() {
    return ordinalPosition_;
  }

  public static final int HIGHEST_INDEXING_TYPE_FIELD_NUMBER = 10;
  private int highestIndexingType_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Most important inclusion of this column.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.ColumnSchema.IndexingType highest_indexing_type = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for highestIndexingType.
   */
  @java.lang.Override
  public int getHighestIndexingTypeValue() {
    return highestIndexingType_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Most important inclusion of this column.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.ColumnSchema.IndexingType highest_indexing_type = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The highestIndexingType.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.ColumnSchema.IndexingType getHighestIndexingType() {
    com.google.cloud.datacatalog.v1.ColumnSchema.IndexingType result =
        com.google.cloud.datacatalog.v1.ColumnSchema.IndexingType.forNumber(highestIndexingType_);
    return result == null
        ? com.google.cloud.datacatalog.v1.ColumnSchema.IndexingType.UNRECOGNIZED
        : result;
  }

  public static final int SUBCOLUMNS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.datacatalog.v1.ColumnSchema> subcolumns_;

  /**
   *
   *
   * <pre>
   * Optional. Schema of sub-columns. A column can have zero or more
   * sub-columns.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datacatalog.v1.ColumnSchema> getSubcolumnsList() {
    return subcolumns_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Schema of sub-columns. A column can have zero or more
   * sub-columns.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.datacatalog.v1.ColumnSchemaOrBuilder>
      getSubcolumnsOrBuilderList() {
    return subcolumns_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Schema of sub-columns. A column can have zero or more
   * sub-columns.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getSubcolumnsCount() {
    return subcolumns_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Schema of sub-columns. A column can have zero or more
   * sub-columns.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.ColumnSchema getSubcolumns(int index) {
    return subcolumns_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Schema of sub-columns. A column can have zero or more
   * sub-columns.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.ColumnSchemaOrBuilder getSubcolumnsOrBuilder(int index) {
    return subcolumns_.get(index);
  }

  public static final int LOOKER_COLUMN_SPEC_FIELD_NUMBER = 18;

  /**
   *
   *
   * <pre>
   * Looker specific column info of this column.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec looker_column_spec = 18;
   * </code>
   *
   * @return Whether the lookerColumnSpec field is set.
   */
  @java.lang.Override
  public boolean hasLookerColumnSpec() {
    return systemSpecCase_ == 18;
  }

  /**
   *
   *
   * <pre>
   * Looker specific column info of this column.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec looker_column_spec = 18;
   * </code>
   *
   * @return The lookerColumnSpec.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec getLookerColumnSpec() {
    if (systemSpecCase_ == 18) {
      return (com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec) systemSpec_;
    }
    return com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Looker specific column info of this column.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec looker_column_spec = 18;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpecOrBuilder
      getLookerColumnSpecOrBuilder() {
    if (systemSpecCase_ == 18) {
      return (com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec) systemSpec_;
    }
    return com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.getDefaultInstance();
  }

  public static final int RANGE_ELEMENT_TYPE_FIELD_NUMBER = 19;
  private com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType rangeElementType_;

  /**
   *
   *
   * <pre>
   * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
   * the type is RANGE, this field is required. Possible values for the field
   * element type of a RANGE include:
   * * DATE
   * * DATETIME
   * * TIMESTAMP
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.ColumnSchema.FieldElementType range_element_type = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the rangeElementType field is set.
   */
  @java.lang.Override
  public boolean hasRangeElementType() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
   * the type is RANGE, this field is required. Possible values for the field
   * element type of a RANGE include:
   * * DATE
   * * DATETIME
   * * TIMESTAMP
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.ColumnSchema.FieldElementType range_element_type = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The rangeElementType.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType getRangeElementType() {
    return rangeElementType_ == null
        ? com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType.getDefaultInstance()
        : rangeElementType_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
   * the type is RANGE, this field is required. Possible values for the field
   * element type of a RANGE include:
   * * DATE
   * * DATETIME
   * * TIMESTAMP
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.ColumnSchema.FieldElementType range_element_type = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementTypeOrBuilder
      getRangeElementTypeOrBuilder() {
    return rangeElementType_ == null
        ? com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType.getDefaultInstance()
        : rangeElementType_;
  }

  public static final int GC_RULE_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object gcRule_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Garbage collection policy for the column or column family.
   * Applies to systems like Cloud Bigtable.
   * </pre>
   *
   * <code>string gc_rule = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The gcRule.
   */
  @java.lang.Override
  public java.lang.String getGcRule() {
    java.lang.Object ref = gcRule_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      gcRule_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Garbage collection policy for the column or column family.
   * Applies to systems like Cloud Bigtable.
   * </pre>
   *
   * <code>string gc_rule = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for gcRule.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGcRuleBytes() {
    java.lang.Object ref = gcRule_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      gcRule_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, mode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(column_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, column_);
    }
    for (int i = 0; i < subcolumns_.size(); i++) {
      output.writeMessage(7, subcolumns_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultValue_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, defaultValue_);
    }
    if (ordinalPosition_ != 0) {
      output.writeInt32(9, ordinalPosition_);
    }
    if (highestIndexingType_
        != com.google.cloud.datacatalog.v1.ColumnSchema.IndexingType.INDEXING_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, highestIndexingType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcRule_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, gcRule_);
    }
    if (systemSpecCase_ == 18) {
      output.writeMessage(
          18, (com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec) systemSpec_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(19, getRangeElementType());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, mode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(column_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, column_);
    }
    for (int i = 0; i < subcolumns_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, subcolumns_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultValue_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, defaultValue_);
    }
    if (ordinalPosition_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(9, ordinalPosition_);
    }
    if (highestIndexingType_
        != com.google.cloud.datacatalog.v1.ColumnSchema.IndexingType.INDEXING_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, highestIndexingType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcRule_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, gcRule_);
    }
    if (systemSpecCase_ == 18) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18, (com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec) systemSpec_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, getRangeElementType());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1.ColumnSchema)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1.ColumnSchema other =
        (com.google.cloud.datacatalog.v1.ColumnSchema) obj;

    if (!getColumn().equals(other.getColumn())) return false;
    if (!getType().equals(other.getType())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getMode().equals(other.getMode())) return false;
    if (!getDefaultValue().equals(other.getDefaultValue())) return false;
    if (getOrdinalPosition() != other.getOrdinalPosition()) return false;
    if (highestIndexingType_ != other.highestIndexingType_) return false;
    if (!getSubcolumnsList().equals(other.getSubcolumnsList())) return false;
    if (hasRangeElementType() != other.hasRangeElementType()) return false;
    if (hasRangeElementType()) {
      if (!getRangeElementType().equals(other.getRangeElementType())) return false;
    }
    if (!getGcRule().equals(other.getGcRule())) return false;
    if (!getSystemSpecCase().equals(other.getSystemSpecCase())) return false;
    switch (systemSpecCase_) {
      case 18:
        if (!getLookerColumnSpec().equals(other.getLookerColumnSpec())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + COLUMN_FIELD_NUMBER;
    hash = (53 * hash) + getColumn().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + MODE_FIELD_NUMBER;
    hash = (53 * hash) + getMode().hashCode();
    hash = (37 * hash) + DEFAULT_VALUE_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultValue().hashCode();
    hash = (37 * hash) + ORDINAL_POSITION_FIELD_NUMBER;
    hash = (53 * hash) + getOrdinalPosition();
    hash = (37 * hash) + HIGHEST_INDEXING_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + highestIndexingType_;
    if (getSubcolumnsCount() > 0) {
      hash = (37 * hash) + SUBCOLUMNS_FIELD_NUMBER;
      hash = (53 * hash) + getSubcolumnsList().hashCode();
    }
    if (hasRangeElementType()) {
      hash = (37 * hash) + RANGE_ELEMENT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getRangeElementType().hashCode();
    }
    hash = (37 * hash) + GC_RULE_FIELD_NUMBER;
    hash = (53 * hash) + getGcRule().hashCode();
    switch (systemSpecCase_) {
      case 18:
        hash = (37 * hash) + LOOKER_COLUMN_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getLookerColumnSpec().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1.ColumnSchema parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.ColumnSchema parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ColumnSchema parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.ColumnSchema parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ColumnSchema parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.ColumnSchema parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ColumnSchema parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.ColumnSchema parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ColumnSchema parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.ColumnSchema parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ColumnSchema parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.ColumnSchema parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1.ColumnSchema prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A column within a schema. Columns can be nested inside
   * other columns.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.ColumnSchema}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.ColumnSchema)
      com.google.cloud.datacatalog.v1.ColumnSchemaOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.SchemaOuterClass
          .internal_static_google_cloud_datacatalog_v1_ColumnSchema_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.SchemaOuterClass
          .internal_static_google_cloud_datacatalog_v1_ColumnSchema_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.ColumnSchema.class,
              com.google.cloud.datacatalog.v1.ColumnSchema.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1.ColumnSchema.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSubcolumnsFieldBuilder();
        getRangeElementTypeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      column_ = "";
      type_ = "";
      description_ = "";
      mode_ = "";
      defaultValue_ = "";
      ordinalPosition_ = 0;
      highestIndexingType_ = 0;
      if (subcolumnsBuilder_ == null) {
        subcolumns_ = java.util.Collections.emptyList();
      } else {
        subcolumns_ = null;
        subcolumnsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      if (lookerColumnSpecBuilder_ != null) {
        lookerColumnSpecBuilder_.clear();
      }
      rangeElementType_ = null;
      if (rangeElementTypeBuilder_ != null) {
        rangeElementTypeBuilder_.dispose();
        rangeElementTypeBuilder_ = null;
      }
      gcRule_ = "";
      systemSpecCase_ = 0;
      systemSpec_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1.SchemaOuterClass
          .internal_static_google_cloud_datacatalog_v1_ColumnSchema_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.ColumnSchema getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1.ColumnSchema.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.ColumnSchema build() {
      com.google.cloud.datacatalog.v1.ColumnSchema result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.ColumnSchema buildPartial() {
      com.google.cloud.datacatalog.v1.ColumnSchema result =
          new com.google.cloud.datacatalog.v1.ColumnSchema(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.datacatalog.v1.ColumnSchema result) {
      if (subcolumnsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          subcolumns_ = java.util.Collections.unmodifiableList(subcolumns_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.subcolumns_ = subcolumns_;
      } else {
        result.subcolumns_ = subcolumnsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1.ColumnSchema result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.column_ = column_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.mode_ = mode_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.defaultValue_ = defaultValue_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.ordinalPosition_ = ordinalPosition_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.highestIndexingType_ = highestIndexingType_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.rangeElementType_ =
            rangeElementTypeBuilder_ == null ? rangeElementType_ : rangeElementTypeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.gcRule_ = gcRule_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.datacatalog.v1.ColumnSchema result) {
      result.systemSpecCase_ = systemSpecCase_;
      result.systemSpec_ = this.systemSpec_;
      if (systemSpecCase_ == 18 && lookerColumnSpecBuilder_ != null) {
        result.systemSpec_ = lookerColumnSpecBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1.ColumnSchema) {
        return mergeFrom((com.google.cloud.datacatalog.v1.ColumnSchema) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1.ColumnSchema other) {
      if (other == com.google.cloud.datacatalog.v1.ColumnSchema.getDefaultInstance()) return this;
      if (!other.getColumn().isEmpty()) {
        column_ = other.column_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getMode().isEmpty()) {
        mode_ = other.mode_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDefaultValue().isEmpty()) {
        defaultValue_ = other.defaultValue_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getOrdinalPosition() != 0) {
        setOrdinalPosition(other.getOrdinalPosition());
      }
      if (other.highestIndexingType_ != 0) {
        setHighestIndexingTypeValue(other.getHighestIndexingTypeValue());
      }
      if (subcolumnsBuilder_ == null) {
        if (!other.subcolumns_.isEmpty()) {
          if (subcolumns_.isEmpty()) {
            subcolumns_ = other.subcolumns_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureSubcolumnsIsMutable();
            subcolumns_.addAll(other.subcolumns_);
          }
          onChanged();
        }
      } else {
        if (!other.subcolumns_.isEmpty()) {
          if (subcolumnsBuilder_.isEmpty()) {
            subcolumnsBuilder_.dispose();
            subcolumnsBuilder_ = null;
            subcolumns_ = other.subcolumns_;
            bitField0_ = (bitField0_ & ~0x00000080);
            subcolumnsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSubcolumnsFieldBuilder()
                    : null;
          } else {
            subcolumnsBuilder_.addAllMessages(other.subcolumns_);
          }
        }
      }
      if (other.hasRangeElementType()) {
        mergeRangeElementType(other.getRangeElementType());
      }
      if (!other.getGcRule().isEmpty()) {
        gcRule_ = other.gcRule_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      switch (other.getSystemSpecCase()) {
        case LOOKER_COLUMN_SPEC:
          {
            mergeLookerColumnSpec(other.getLookerColumnSpec());
            break;
          }
        case SYSTEMSPEC_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                mode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 50:
              {
                column_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 50
            case 58:
              {
                com.google.cloud.datacatalog.v1.ColumnSchema m =
                    input.readMessage(
                        com.google.cloud.datacatalog.v1.ColumnSchema.parser(), extensionRegistry);
                if (subcolumnsBuilder_ == null) {
                  ensureSubcolumnsIsMutable();
                  subcolumns_.add(m);
                } else {
                  subcolumnsBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                defaultValue_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 66
            case 72:
              {
                ordinalPosition_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 72
            case 80:
              {
                highestIndexingType_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 80
            case 90:
              {
                gcRule_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 146:
              {
                input.readMessage(
                    getLookerColumnSpecFieldBuilder().getBuilder(), extensionRegistry);
                systemSpecCase_ = 18;
                break;
              } // case 146
            case 154:
              {
                input.readMessage(
                    getRangeElementTypeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 154
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int systemSpecCase_ = 0;
    private java.lang.Object systemSpec_;

    public SystemSpecCase getSystemSpecCase() {
      return SystemSpecCase.forNumber(systemSpecCase_);
    }

    public Builder clearSystemSpec() {
      systemSpecCase_ = 0;
      systemSpec_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object column_ = "";

    /**
     *
     *
     * <pre>
     * Required. Name of the column.
     *
     * Must be a UTF-8 string without dots (.).
     * The maximum size is 64 bytes.
     * </pre>
     *
     * <code>string column = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The column.
     */
    public java.lang.String getColumn() {
      java.lang.Object ref = column_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        column_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the column.
     *
     * Must be a UTF-8 string without dots (.).
     * The maximum size is 64 bytes.
     * </pre>
     *
     * <code>string column = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for column.
     */
    public com.google.protobuf.ByteString getColumnBytes() {
      java.lang.Object ref = column_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        column_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the column.
     *
     * Must be a UTF-8 string without dots (.).
     * The maximum size is 64 bytes.
     * </pre>
     *
     * <code>string column = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The column to set.
     * @return This builder for chaining.
     */
    public Builder setColumn(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      column_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the column.
     *
     * Must be a UTF-8 string without dots (.).
     * The maximum size is 64 bytes.
     * </pre>
     *
     * <code>string column = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearColumn() {
      column_ = getDefaultInstance().getColumn();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the column.
     *
     * Must be a UTF-8 string without dots (.).
     * The maximum size is 64 bytes.
     * </pre>
     *
     * <code>string column = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for column to set.
     * @return This builder for chaining.
     */
    public Builder setColumnBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      column_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";

    /**
     *
     *
     * <pre>
     * Required. Type of the column.
     *
     * Must be a UTF-8 string with the maximum size of 128 bytes.
     * </pre>
     *
     * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Type of the column.
     *
     * Must be a UTF-8 string with the maximum size of 128 bytes.
     * </pre>
     *
     * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Type of the column.
     *
     * Must be a UTF-8 string with the maximum size of 128 bytes.
     * </pre>
     *
     * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Type of the column.
     *
     * Must be a UTF-8 string with the maximum size of 128 bytes.
     * </pre>
     *
     * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Type of the column.
     *
     * Must be a UTF-8 string with the maximum size of 128 bytes.
     * </pre>
     *
     * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Description of the column. Default value is an empty string.
     *
     * The description must be a UTF-8 string with the maximum size of 2000
     * bytes.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Description of the column. Default value is an empty string.
     *
     * The description must be a UTF-8 string with the maximum size of 2000
     * bytes.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Description of the column. Default value is an empty string.
     *
     * The description must be a UTF-8 string with the maximum size of 2000
     * bytes.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Description of the column. Default value is an empty string.
     *
     * The description must be a UTF-8 string with the maximum size of 2000
     * bytes.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Description of the column. Default value is an empty string.
     *
     * The description must be a UTF-8 string with the maximum size of 2000
     * bytes.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object mode_ = "";

    /**
     *
     *
     * <pre>
     * Optional. A column's mode indicates whether values in this column are
     * required, nullable, or repeated.
     *
     * Only `NULLABLE`, `REQUIRED`, and `REPEATED` values are supported.
     * Default mode is `NULLABLE`.
     * </pre>
     *
     * <code>string mode = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The mode.
     */
    public java.lang.String getMode() {
      java.lang.Object ref = mode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A column's mode indicates whether values in this column are
     * required, nullable, or repeated.
     *
     * Only `NULLABLE`, `REQUIRED`, and `REPEATED` values are supported.
     * Default mode is `NULLABLE`.
     * </pre>
     *
     * <code>string mode = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for mode.
     */
    public com.google.protobuf.ByteString getModeBytes() {
      java.lang.Object ref = mode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A column's mode indicates whether values in this column are
     * required, nullable, or repeated.
     *
     * Only `NULLABLE`, `REQUIRED`, and `REPEATED` values are supported.
     * Default mode is `NULLABLE`.
     * </pre>
     *
     * <code>string mode = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The mode to set.
     * @return This builder for chaining.
     */
    public Builder setMode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      mode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A column's mode indicates whether values in this column are
     * required, nullable, or repeated.
     *
     * Only `NULLABLE`, `REQUIRED`, and `REPEATED` values are supported.
     * Default mode is `NULLABLE`.
     * </pre>
     *
     * <code>string mode = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMode() {
      mode_ = getDefaultInstance().getMode();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A column's mode indicates whether values in this column are
     * required, nullable, or repeated.
     *
     * Only `NULLABLE`, `REQUIRED`, and `REPEATED` values are supported.
     * Default mode is `NULLABLE`.
     * </pre>
     *
     * <code>string mode = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for mode to set.
     * @return This builder for chaining.
     */
    public Builder setModeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      mode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object defaultValue_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Default value for the column.
     * </pre>
     *
     * <code>string default_value = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The defaultValue.
     */
    public java.lang.String getDefaultValue() {
      java.lang.Object ref = defaultValue_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultValue_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Default value for the column.
     * </pre>
     *
     * <code>string default_value = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for defaultValue.
     */
    public com.google.protobuf.ByteString getDefaultValueBytes() {
      java.lang.Object ref = defaultValue_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultValue_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Default value for the column.
     * </pre>
     *
     * <code>string default_value = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The defaultValue to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultValue_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Default value for the column.
     * </pre>
     *
     * <code>string default_value = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultValue() {
      defaultValue_ = getDefaultInstance().getDefaultValue();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Default value for the column.
     * </pre>
     *
     * <code>string default_value = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for defaultValue to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultValue_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int ordinalPosition_;

    /**
     *
     *
     * <pre>
     * Optional. Ordinal position
     * </pre>
     *
     * <code>int32 ordinal_position = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The ordinalPosition.
     */
    @java.lang.Override
    public int getOrdinalPosition() {
      return ordinalPosition_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Ordinal position
     * </pre>
     *
     * <code>int32 ordinal_position = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The ordinalPosition to set.
     * @return This builder for chaining.
     */
    public Builder setOrdinalPosition(int value) {

      ordinalPosition_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Ordinal position
     * </pre>
     *
     * <code>int32 ordinal_position = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrdinalPosition() {
      bitField0_ = (bitField0_ & ~0x00000020);
      ordinalPosition_ = 0;
      onChanged();
      return this;
    }

    private int highestIndexingType_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. Most important inclusion of this column.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.ColumnSchema.IndexingType highest_indexing_type = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for highestIndexingType.
     */
    @java.lang.Override
    public int getHighestIndexingTypeValue() {
      return highestIndexingType_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Most important inclusion of this column.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.ColumnSchema.IndexingType highest_indexing_type = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for highestIndexingType to set.
     * @return This builder for chaining.
     */
    public Builder setHighestIndexingTypeValue(int value) {
      highestIndexingType_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Most important inclusion of this column.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.ColumnSchema.IndexingType highest_indexing_type = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The highestIndexingType.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.ColumnSchema.IndexingType getHighestIndexingType() {
      com.google.cloud.datacatalog.v1.ColumnSchema.IndexingType result =
          com.google.cloud.datacatalog.v1.ColumnSchema.IndexingType.forNumber(highestIndexingType_);
      return result == null
          ? com.google.cloud.datacatalog.v1.ColumnSchema.IndexingType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. Most important inclusion of this column.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.ColumnSchema.IndexingType highest_indexing_type = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The highestIndexingType to set.
     * @return This builder for chaining.
     */
    public Builder setHighestIndexingType(
        com.google.cloud.datacatalog.v1.ColumnSchema.IndexingType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      highestIndexingType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Most important inclusion of this column.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.ColumnSchema.IndexingType highest_indexing_type = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHighestIndexingType() {
      bitField0_ = (bitField0_ & ~0x00000040);
      highestIndexingType_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.datacatalog.v1.ColumnSchema> subcolumns_ =
        java.util.Collections.emptyList();

    private void ensureSubcolumnsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        subcolumns_ =
            new java.util.ArrayList<com.google.cloud.datacatalog.v1.ColumnSchema>(subcolumns_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1.ColumnSchema,
            com.google.cloud.datacatalog.v1.ColumnSchema.Builder,
            com.google.cloud.datacatalog.v1.ColumnSchemaOrBuilder>
        subcolumnsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Schema of sub-columns. A column can have zero or more
     * sub-columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.datacatalog.v1.ColumnSchema> getSubcolumnsList() {
      if (subcolumnsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(subcolumns_);
      } else {
        return subcolumnsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Schema of sub-columns. A column can have zero or more
     * sub-columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getSubcolumnsCount() {
      if (subcolumnsBuilder_ == null) {
        return subcolumns_.size();
      } else {
        return subcolumnsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Schema of sub-columns. A column can have zero or more
     * sub-columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.ColumnSchema getSubcolumns(int index) {
      if (subcolumnsBuilder_ == null) {
        return subcolumns_.get(index);
      } else {
        return subcolumnsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Schema of sub-columns. A column can have zero or more
     * sub-columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSubcolumns(int index, com.google.cloud.datacatalog.v1.ColumnSchema value) {
      if (subcolumnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubcolumnsIsMutable();
        subcolumns_.set(index, value);
        onChanged();
      } else {
        subcolumnsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Schema of sub-columns. A column can have zero or more
     * sub-columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSubcolumns(
        int index, com.google.cloud.datacatalog.v1.ColumnSchema.Builder builderForValue) {
      if (subcolumnsBuilder_ == null) {
        ensureSubcolumnsIsMutable();
        subcolumns_.set(index, builderForValue.build());
        onChanged();
      } else {
        subcolumnsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Schema of sub-columns. A column can have zero or more
     * sub-columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSubcolumns(com.google.cloud.datacatalog.v1.ColumnSchema value) {
      if (subcolumnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubcolumnsIsMutable();
        subcolumns_.add(value);
        onChanged();
      } else {
        subcolumnsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Schema of sub-columns. A column can have zero or more
     * sub-columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSubcolumns(int index, com.google.cloud.datacatalog.v1.ColumnSchema value) {
      if (subcolumnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSubcolumnsIsMutable();
        subcolumns_.add(index, value);
        onChanged();
      } else {
        subcolumnsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Schema of sub-columns. A column can have zero or more
     * sub-columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSubcolumns(
        com.google.cloud.datacatalog.v1.ColumnSchema.Builder builderForValue) {
      if (subcolumnsBuilder_ == null) {
        ensureSubcolumnsIsMutable();
        subcolumns_.add(builderForValue.build());
        onChanged();
      } else {
        subcolumnsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Schema of sub-columns. A column can have zero or more
     * sub-columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSubcolumns(
        int index, com.google.cloud.datacatalog.v1.ColumnSchema.Builder builderForValue) {
      if (subcolumnsBuilder_ == null) {
        ensureSubcolumnsIsMutable();
        subcolumns_.add(index, builderForValue.build());
        onChanged();
      } else {
        subcolumnsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Schema of sub-columns. A column can have zero or more
     * sub-columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllSubcolumns(
        java.lang.Iterable<? extends com.google.cloud.datacatalog.v1.ColumnSchema> values) {
      if (subcolumnsBuilder_ == null) {
        ensureSubcolumnsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, subcolumns_);
        onChanged();
      } else {
        subcolumnsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Schema of sub-columns. A column can have zero or more
     * sub-columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSubcolumns() {
      if (subcolumnsBuilder_ == null) {
        subcolumns_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        subcolumnsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Schema of sub-columns. A column can have zero or more
     * sub-columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeSubcolumns(int index) {
      if (subcolumnsBuilder_ == null) {
        ensureSubcolumnsIsMutable();
        subcolumns_.remove(index);
        onChanged();
      } else {
        subcolumnsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Schema of sub-columns. A column can have zero or more
     * sub-columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.ColumnSchema.Builder getSubcolumnsBuilder(int index) {
      return getSubcolumnsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Schema of sub-columns. A column can have zero or more
     * sub-columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.ColumnSchemaOrBuilder getSubcolumnsOrBuilder(int index) {
      if (subcolumnsBuilder_ == null) {
        return subcolumns_.get(index);
      } else {
        return subcolumnsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Schema of sub-columns. A column can have zero or more
     * sub-columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.datacatalog.v1.ColumnSchemaOrBuilder>
        getSubcolumnsOrBuilderList() {
      if (subcolumnsBuilder_ != null) {
        return subcolumnsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(subcolumns_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Schema of sub-columns. A column can have zero or more
     * sub-columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.ColumnSchema.Builder addSubcolumnsBuilder() {
      return getSubcolumnsFieldBuilder()
          .addBuilder(com.google.cloud.datacatalog.v1.ColumnSchema.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Schema of sub-columns. A column can have zero or more
     * sub-columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.ColumnSchema.Builder addSubcolumnsBuilder(int index) {
      return getSubcolumnsFieldBuilder()
          .addBuilder(index, com.google.cloud.datacatalog.v1.ColumnSchema.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Schema of sub-columns. A column can have zero or more
     * sub-columns.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.ColumnSchema subcolumns = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.datacatalog.v1.ColumnSchema.Builder>
        getSubcolumnsBuilderList() {
      return getSubcolumnsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1.ColumnSchema,
            com.google.cloud.datacatalog.v1.ColumnSchema.Builder,
            com.google.cloud.datacatalog.v1.ColumnSchemaOrBuilder>
        getSubcolumnsFieldBuilder() {
      if (subcolumnsBuilder_ == null) {
        subcolumnsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datacatalog.v1.ColumnSchema,
                com.google.cloud.datacatalog.v1.ColumnSchema.Builder,
                com.google.cloud.datacatalog.v1.ColumnSchemaOrBuilder>(
                subcolumns_, ((bitField0_ & 0x00000080) != 0), getParentForChildren(), isClean());
        subcolumns_ = null;
      }
      return subcolumnsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec,
            com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.Builder,
            com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpecOrBuilder>
        lookerColumnSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Looker specific column info of this column.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec looker_column_spec = 18;
     * </code>
     *
     * @return Whether the lookerColumnSpec field is set.
     */
    @java.lang.Override
    public boolean hasLookerColumnSpec() {
      return systemSpecCase_ == 18;
    }

    /**
     *
     *
     * <pre>
     * Looker specific column info of this column.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec looker_column_spec = 18;
     * </code>
     *
     * @return The lookerColumnSpec.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec getLookerColumnSpec() {
      if (lookerColumnSpecBuilder_ == null) {
        if (systemSpecCase_ == 18) {
          return (com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec) systemSpec_;
        }
        return com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.getDefaultInstance();
      } else {
        if (systemSpecCase_ == 18) {
          return lookerColumnSpecBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Looker specific column info of this column.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec looker_column_spec = 18;
     * </code>
     */
    public Builder setLookerColumnSpec(
        com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec value) {
      if (lookerColumnSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        systemSpec_ = value;
        onChanged();
      } else {
        lookerColumnSpecBuilder_.setMessage(value);
      }
      systemSpecCase_ = 18;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Looker specific column info of this column.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec looker_column_spec = 18;
     * </code>
     */
    public Builder setLookerColumnSpec(
        com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.Builder builderForValue) {
      if (lookerColumnSpecBuilder_ == null) {
        systemSpec_ = builderForValue.build();
        onChanged();
      } else {
        lookerColumnSpecBuilder_.setMessage(builderForValue.build());
      }
      systemSpecCase_ = 18;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Looker specific column info of this column.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec looker_column_spec = 18;
     * </code>
     */
    public Builder mergeLookerColumnSpec(
        com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec value) {
      if (lookerColumnSpecBuilder_ == null) {
        if (systemSpecCase_ == 18
            && systemSpec_
                != com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec
                    .getDefaultInstance()) {
          systemSpec_ =
              com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.newBuilder(
                      (com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec) systemSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          systemSpec_ = value;
        }
        onChanged();
      } else {
        if (systemSpecCase_ == 18) {
          lookerColumnSpecBuilder_.mergeFrom(value);
        } else {
          lookerColumnSpecBuilder_.setMessage(value);
        }
      }
      systemSpecCase_ = 18;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Looker specific column info of this column.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec looker_column_spec = 18;
     * </code>
     */
    public Builder clearLookerColumnSpec() {
      if (lookerColumnSpecBuilder_ == null) {
        if (systemSpecCase_ == 18) {
          systemSpecCase_ = 0;
          systemSpec_ = null;
          onChanged();
        }
      } else {
        if (systemSpecCase_ == 18) {
          systemSpecCase_ = 0;
          systemSpec_ = null;
        }
        lookerColumnSpecBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Looker specific column info of this column.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec looker_column_spec = 18;
     * </code>
     */
    public com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.Builder
        getLookerColumnSpecBuilder() {
      return getLookerColumnSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Looker specific column info of this column.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec looker_column_spec = 18;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpecOrBuilder
        getLookerColumnSpecOrBuilder() {
      if ((systemSpecCase_ == 18) && (lookerColumnSpecBuilder_ != null)) {
        return lookerColumnSpecBuilder_.getMessageOrBuilder();
      } else {
        if (systemSpecCase_ == 18) {
          return (com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec) systemSpec_;
        }
        return com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Looker specific column info of this column.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec looker_column_spec = 18;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec,
            com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.Builder,
            com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpecOrBuilder>
        getLookerColumnSpecFieldBuilder() {
      if (lookerColumnSpecBuilder_ == null) {
        if (!(systemSpecCase_ == 18)) {
          systemSpec_ =
              com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.getDefaultInstance();
        }
        lookerColumnSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec,
                com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.Builder,
                com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpecOrBuilder>(
                (com.google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec) systemSpec_,
                getParentForChildren(),
                isClean());
        systemSpec_ = null;
      }
      systemSpecCase_ = 18;
      onChanged();
      return lookerColumnSpecBuilder_;
    }

    private com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType rangeElementType_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType,
            com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType.Builder,
            com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementTypeOrBuilder>
        rangeElementTypeBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
     * the type is RANGE, this field is required. Possible values for the field
     * element type of a RANGE include:
     * * DATE
     * * DATETIME
     * * TIMESTAMP
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.ColumnSchema.FieldElementType range_element_type = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the rangeElementType field is set.
     */
    public boolean hasRangeElementType() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
     * the type is RANGE, this field is required. Possible values for the field
     * element type of a RANGE include:
     * * DATE
     * * DATETIME
     * * TIMESTAMP
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.ColumnSchema.FieldElementType range_element_type = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The rangeElementType.
     */
    public com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType getRangeElementType() {
      if (rangeElementTypeBuilder_ == null) {
        return rangeElementType_ == null
            ? com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType.getDefaultInstance()
            : rangeElementType_;
      } else {
        return rangeElementTypeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
     * the type is RANGE, this field is required. Possible values for the field
     * element type of a RANGE include:
     * * DATE
     * * DATETIME
     * * TIMESTAMP
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.ColumnSchema.FieldElementType range_element_type = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRangeElementType(
        com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType value) {
      if (rangeElementTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rangeElementType_ = value;
      } else {
        rangeElementTypeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
     * the type is RANGE, this field is required. Possible values for the field
     * element type of a RANGE include:
     * * DATE
     * * DATETIME
     * * TIMESTAMP
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.ColumnSchema.FieldElementType range_element_type = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRangeElementType(
        com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType.Builder builderForValue) {
      if (rangeElementTypeBuilder_ == null) {
        rangeElementType_ = builderForValue.build();
      } else {
        rangeElementTypeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
     * the type is RANGE, this field is required. Possible values for the field
     * element type of a RANGE include:
     * * DATE
     * * DATETIME
     * * TIMESTAMP
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.ColumnSchema.FieldElementType range_element_type = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRangeElementType(
        com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType value) {
      if (rangeElementTypeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && rangeElementType_ != null
            && rangeElementType_
                != com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType
                    .getDefaultInstance()) {
          getRangeElementTypeBuilder().mergeFrom(value);
        } else {
          rangeElementType_ = value;
        }
      } else {
        rangeElementTypeBuilder_.mergeFrom(value);
      }
      if (rangeElementType_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
     * the type is RANGE, this field is required. Possible values for the field
     * element type of a RANGE include:
     * * DATE
     * * DATETIME
     * * TIMESTAMP
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.ColumnSchema.FieldElementType range_element_type = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRangeElementType() {
      bitField0_ = (bitField0_ & ~0x00000200);
      rangeElementType_ = null;
      if (rangeElementTypeBuilder_ != null) {
        rangeElementTypeBuilder_.dispose();
        rangeElementTypeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
     * the type is RANGE, this field is required. Possible values for the field
     * element type of a RANGE include:
     * * DATE
     * * DATETIME
     * * TIMESTAMP
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.ColumnSchema.FieldElementType range_element_type = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType.Builder
        getRangeElementTypeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getRangeElementTypeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
     * the type is RANGE, this field is required. Possible values for the field
     * element type of a RANGE include:
     * * DATE
     * * DATETIME
     * * TIMESTAMP
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.ColumnSchema.FieldElementType range_element_type = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementTypeOrBuilder
        getRangeElementTypeOrBuilder() {
      if (rangeElementTypeBuilder_ != null) {
        return rangeElementTypeBuilder_.getMessageOrBuilder();
      } else {
        return rangeElementType_ == null
            ? com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType.getDefaultInstance()
            : rangeElementType_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
     * the type is RANGE, this field is required. Possible values for the field
     * element type of a RANGE include:
     * * DATE
     * * DATETIME
     * * TIMESTAMP
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.ColumnSchema.FieldElementType range_element_type = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType,
            com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType.Builder,
            com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementTypeOrBuilder>
        getRangeElementTypeFieldBuilder() {
      if (rangeElementTypeBuilder_ == null) {
        rangeElementTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType,
                com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementType.Builder,
                com.google.cloud.datacatalog.v1.ColumnSchema.FieldElementTypeOrBuilder>(
                getRangeElementType(), getParentForChildren(), isClean());
        rangeElementType_ = null;
      }
      return rangeElementTypeBuilder_;
    }

    private java.lang.Object gcRule_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Garbage collection policy for the column or column family.
     * Applies to systems like Cloud Bigtable.
     * </pre>
     *
     * <code>string gc_rule = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The gcRule.
     */
    public java.lang.String getGcRule() {
      java.lang.Object ref = gcRule_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcRule_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Garbage collection policy for the column or column family.
     * Applies to systems like Cloud Bigtable.
     * </pre>
     *
     * <code>string gc_rule = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for gcRule.
     */
    public com.google.protobuf.ByteString getGcRuleBytes() {
      java.lang.Object ref = gcRule_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcRule_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Garbage collection policy for the column or column family.
     * Applies to systems like Cloud Bigtable.
     * </pre>
     *
     * <code>string gc_rule = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The gcRule to set.
     * @return This builder for chaining.
     */
    public Builder setGcRule(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      gcRule_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Garbage collection policy for the column or column family.
     * Applies to systems like Cloud Bigtable.
     * </pre>
     *
     * <code>string gc_rule = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGcRule() {
      gcRule_ = getDefaultInstance().getGcRule();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Garbage collection policy for the column or column family.
     * Applies to systems like Cloud Bigtable.
     * </pre>
     *
     * <code>string gc_rule = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for gcRule to set.
     * @return This builder for chaining.
     */
    public Builder setGcRuleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      gcRule_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.ColumnSchema)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.ColumnSchema)
  private static final com.google.cloud.datacatalog.v1.ColumnSchema DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.ColumnSchema();
  }

  public static com.google.cloud.datacatalog.v1.ColumnSchema getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ColumnSchema> PARSER =
      new com.google.protobuf.AbstractParser<ColumnSchema>() {
        @java.lang.Override
        public ColumnSchema parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ColumnSchema> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ColumnSchema> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1.ColumnSchema getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
