/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1/datacatalog.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.datacatalog.v1;

/**
 *
 *
 * <pre>
 * Specification that applies to Instance
 * entries that are part of `CLOUD_BIGTABLE` system.
 * (user_specified_type)
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1.CloudBigtableInstanceSpec}
 */
public final class CloudBigtableInstanceSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.CloudBigtableInstanceSpec)
    CloudBigtableInstanceSpecOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CloudBigtableInstanceSpec.newBuilder() to construct.
  private CloudBigtableInstanceSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloudBigtableInstanceSpec() {
    cloudBigtableClusterSpecs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloudBigtableInstanceSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_CloudBigtableInstanceSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_CloudBigtableInstanceSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.class,
            com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.Builder.class);
  }

  public interface CloudBigtableClusterSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Name of the cluster.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();

    /**
     *
     *
     * <pre>
     * Name of the cluster.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * Location of the cluster, typically a Cloud zone.
     * </pre>
     *
     * <code>string location = 2;</code>
     *
     * @return The location.
     */
    java.lang.String getLocation();

    /**
     *
     *
     * <pre>
     * Location of the cluster, typically a Cloud zone.
     * </pre>
     *
     * <code>string location = 2;</code>
     *
     * @return The bytes for location.
     */
    com.google.protobuf.ByteString getLocationBytes();

    /**
     *
     *
     * <pre>
     * Type of the resource. For a cluster this would be "CLUSTER".
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @return The type.
     */
    java.lang.String getType();

    /**
     *
     *
     * <pre>
     * Type of the resource. For a cluster this would be "CLUSTER".
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @return The bytes for type.
     */
    com.google.protobuf.ByteString getTypeBytes();

    /**
     *
     *
     * <pre>
     * A link back to the parent resource, in this case Instance.
     * </pre>
     *
     * <code>string linked_resource = 4;</code>
     *
     * @return The linkedResource.
     */
    java.lang.String getLinkedResource();

    /**
     *
     *
     * <pre>
     * A link back to the parent resource, in this case Instance.
     * </pre>
     *
     * <code>string linked_resource = 4;</code>
     *
     * @return The bytes for linkedResource.
     */
    com.google.protobuf.ByteString getLinkedResourceBytes();
  }

  /**
   *
   *
   * <pre>
   * Spec that applies to clusters of an Instance of Cloud Bigtable.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec}
   */
  public static final class CloudBigtableClusterSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec)
      CloudBigtableClusterSpecOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use CloudBigtableClusterSpec.newBuilder() to construct.
    private CloudBigtableClusterSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CloudBigtableClusterSpec() {
      displayName_ = "";
      location_ = "";
      type_ = "";
      linkedResource_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CloudBigtableClusterSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_CloudBigtableInstanceSpec_CloudBigtableClusterSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_CloudBigtableInstanceSpec_CloudBigtableClusterSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
                  .class,
              com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
                  .Builder.class);
    }

    public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Name of the cluster.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the cluster.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LOCATION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object location_ = "";

    /**
     *
     *
     * <pre>
     * Location of the cluster, typically a Cloud zone.
     * </pre>
     *
     * <code>string location = 2;</code>
     *
     * @return The location.
     */
    @java.lang.Override
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Location of the cluster, typically a Cloud zone.
     * </pre>
     *
     * <code>string location = 2;</code>
     *
     * @return The bytes for location.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TYPE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object type_ = "";

    /**
     *
     *
     * <pre>
     * Type of the resource. For a cluster this would be "CLUSTER".
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Type of the resource. For a cluster this would be "CLUSTER".
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @return The bytes for type.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LINKED_RESOURCE_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object linkedResource_ = "";

    /**
     *
     *
     * <pre>
     * A link back to the parent resource, in this case Instance.
     * </pre>
     *
     * <code>string linked_resource = 4;</code>
     *
     * @return The linkedResource.
     */
    @java.lang.Override
    public java.lang.String getLinkedResource() {
      java.lang.Object ref = linkedResource_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        linkedResource_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * A link back to the parent resource, in this case Instance.
     * </pre>
     *
     * <code>string linked_resource = 4;</code>
     *
     * @return The bytes for linkedResource.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLinkedResourceBytes() {
      java.lang.Object ref = linkedResource_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        linkedResource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, location_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, type_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(linkedResource_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, linkedResource_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, location_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, type_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(linkedResource_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, linkedResource_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec other =
          (com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec) obj;

      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (!getLocation().equals(other.getLocation())) return false;
      if (!getType().equals(other.getType())) return false;
      if (!getLinkedResource().equals(other.getLinkedResource())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
      hash = (37 * hash) + LINKED_RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getLinkedResource().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Spec that applies to clusters of an Instance of Cloud Bigtable.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec)
        com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec
            .CloudBigtableClusterSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datacatalog.v1.Datacatalog
            .internal_static_google_cloud_datacatalog_v1_CloudBigtableInstanceSpec_CloudBigtableClusterSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datacatalog.v1.Datacatalog
            .internal_static_google_cloud_datacatalog_v1_CloudBigtableInstanceSpec_CloudBigtableClusterSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
                    .class,
                com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        displayName_ = "";
        location_ = "";
        type_ = "";
        linkedResource_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datacatalog.v1.Datacatalog
            .internal_static_google_cloud_datacatalog_v1_CloudBigtableInstanceSpec_CloudBigtableClusterSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
          getDefaultInstanceForType() {
        return com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
          build() {
        com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
          buildPartial() {
        com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec result =
            new com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.displayName_ = displayName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.location_ = location_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.type_ = type_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.linkedResource_ = linkedResource_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec) {
          return mergeFrom(
              (com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
              other) {
        if (other
            == com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
                .getDefaultInstance()) return this;
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getLocation().isEmpty()) {
          location_ = other.location_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getType().isEmpty()) {
          type_ = other.type_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getLinkedResource().isEmpty()) {
          linkedResource_ = other.linkedResource_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  displayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  location_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  type_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  linkedResource_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object displayName_ = "";

      /**
       *
       *
       * <pre>
       * Name of the cluster.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Name of the cluster.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Name of the cluster.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        displayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Name of the cluster.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {
        displayName_ = getDefaultInstance().getDisplayName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Name of the cluster.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        displayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object location_ = "";

      /**
       *
       *
       * <pre>
       * Location of the cluster, typically a Cloud zone.
       * </pre>
       *
       * <code>string location = 2;</code>
       *
       * @return The location.
       */
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Location of the cluster, typically a Cloud zone.
       * </pre>
       *
       * <code>string location = 2;</code>
       *
       * @return The bytes for location.
       */
      public com.google.protobuf.ByteString getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Location of the cluster, typically a Cloud zone.
       * </pre>
       *
       * <code>string location = 2;</code>
       *
       * @param value The location to set.
       * @return This builder for chaining.
       */
      public Builder setLocation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        location_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Location of the cluster, typically a Cloud zone.
       * </pre>
       *
       * <code>string location = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLocation() {
        location_ = getDefaultInstance().getLocation();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Location of the cluster, typically a Cloud zone.
       * </pre>
       *
       * <code>string location = 2;</code>
       *
       * @param value The bytes for location to set.
       * @return This builder for chaining.
       */
      public Builder setLocationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        location_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object type_ = "";

      /**
       *
       *
       * <pre>
       * Type of the resource. For a cluster this would be "CLUSTER".
       * </pre>
       *
       * <code>string type = 3;</code>
       *
       * @return The type.
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          type_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Type of the resource. For a cluster this would be "CLUSTER".
       * </pre>
       *
       * <code>string type = 3;</code>
       *
       * @return The bytes for type.
       */
      public com.google.protobuf.ByteString getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Type of the resource. For a cluster this would be "CLUSTER".
       * </pre>
       *
       * <code>string type = 3;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Type of the resource. For a cluster this would be "CLUSTER".
       * </pre>
       *
       * <code>string type = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        type_ = getDefaultInstance().getType();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Type of the resource. For a cluster this would be "CLUSTER".
       * </pre>
       *
       * <code>string type = 3;</code>
       *
       * @param value The bytes for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        type_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object linkedResource_ = "";

      /**
       *
       *
       * <pre>
       * A link back to the parent resource, in this case Instance.
       * </pre>
       *
       * <code>string linked_resource = 4;</code>
       *
       * @return The linkedResource.
       */
      public java.lang.String getLinkedResource() {
        java.lang.Object ref = linkedResource_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          linkedResource_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * A link back to the parent resource, in this case Instance.
       * </pre>
       *
       * <code>string linked_resource = 4;</code>
       *
       * @return The bytes for linkedResource.
       */
      public com.google.protobuf.ByteString getLinkedResourceBytes() {
        java.lang.Object ref = linkedResource_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          linkedResource_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * A link back to the parent resource, in this case Instance.
       * </pre>
       *
       * <code>string linked_resource = 4;</code>
       *
       * @param value The linkedResource to set.
       * @return This builder for chaining.
       */
      public Builder setLinkedResource(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        linkedResource_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A link back to the parent resource, in this case Instance.
       * </pre>
       *
       * <code>string linked_resource = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLinkedResource() {
        linkedResource_ = getDefaultInstance().getLinkedResource();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A link back to the parent resource, in this case Instance.
       * </pre>
       *
       * <code>string linked_resource = 4;</code>
       *
       * @param value The bytes for linkedResource to set.
       * @return This builder for chaining.
       */
      public Builder setLinkedResourceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        linkedResource_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec)
    private static final com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec
            .CloudBigtableClusterSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec();
    }

    public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CloudBigtableClusterSpec> PARSER =
        new com.google.protobuf.AbstractParser<CloudBigtableClusterSpec>() {
          @java.lang.Override
          public CloudBigtableClusterSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CloudBigtableClusterSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CloudBigtableClusterSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int CLOUD_BIGTABLE_CLUSTER_SPECS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec>
      cloudBigtableClusterSpecs_;

  /**
   *
   *
   * <pre>
   * The list of clusters for the Instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec>
      getCloudBigtableClusterSpecsList() {
    return cloudBigtableClusterSpecs_;
  }

  /**
   *
   *
   * <pre>
   * The list of clusters for the Instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec
                  .CloudBigtableClusterSpecOrBuilder>
      getCloudBigtableClusterSpecsOrBuilderList() {
    return cloudBigtableClusterSpecs_;
  }

  /**
   *
   *
   * <pre>
   * The list of clusters for the Instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
   * </code>
   */
  @java.lang.Override
  public int getCloudBigtableClusterSpecsCount() {
    return cloudBigtableClusterSpecs_.size();
  }

  /**
   *
   *
   * <pre>
   * The list of clusters for the Instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
      getCloudBigtableClusterSpecs(int index) {
    return cloudBigtableClusterSpecs_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The list of clusters for the Instance.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpecOrBuilder
      getCloudBigtableClusterSpecsOrBuilder(int index) {
    return cloudBigtableClusterSpecs_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < cloudBigtableClusterSpecs_.size(); i++) {
      output.writeMessage(1, cloudBigtableClusterSpecs_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < cloudBigtableClusterSpecs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, cloudBigtableClusterSpecs_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec other =
        (com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec) obj;

    if (!getCloudBigtableClusterSpecsList().equals(other.getCloudBigtableClusterSpecsList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getCloudBigtableClusterSpecsCount() > 0) {
      hash = (37 * hash) + CLOUD_BIGTABLE_CLUSTER_SPECS_FIELD_NUMBER;
      hash = (53 * hash) + getCloudBigtableClusterSpecsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Specification that applies to Instance
   * entries that are part of `CLOUD_BIGTABLE` system.
   * (user_specified_type)
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.CloudBigtableInstanceSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.CloudBigtableInstanceSpec)
      com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_CloudBigtableInstanceSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_CloudBigtableInstanceSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.class,
              com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (cloudBigtableClusterSpecsBuilder_ == null) {
        cloudBigtableClusterSpecs_ = java.util.Collections.emptyList();
      } else {
        cloudBigtableClusterSpecs_ = null;
        cloudBigtableClusterSpecsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_CloudBigtableInstanceSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec build() {
      com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec buildPartial() {
      com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec result =
          new com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec result) {
      if (cloudBigtableClusterSpecsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          cloudBigtableClusterSpecs_ =
              java.util.Collections.unmodifiableList(cloudBigtableClusterSpecs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.cloudBigtableClusterSpecs_ = cloudBigtableClusterSpecs_;
      } else {
        result.cloudBigtableClusterSpecs_ = cloudBigtableClusterSpecsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec) {
        return mergeFrom((com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec other) {
      if (other == com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.getDefaultInstance())
        return this;
      if (cloudBigtableClusterSpecsBuilder_ == null) {
        if (!other.cloudBigtableClusterSpecs_.isEmpty()) {
          if (cloudBigtableClusterSpecs_.isEmpty()) {
            cloudBigtableClusterSpecs_ = other.cloudBigtableClusterSpecs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureCloudBigtableClusterSpecsIsMutable();
            cloudBigtableClusterSpecs_.addAll(other.cloudBigtableClusterSpecs_);
          }
          onChanged();
        }
      } else {
        if (!other.cloudBigtableClusterSpecs_.isEmpty()) {
          if (cloudBigtableClusterSpecsBuilder_.isEmpty()) {
            cloudBigtableClusterSpecsBuilder_.dispose();
            cloudBigtableClusterSpecsBuilder_ = null;
            cloudBigtableClusterSpecs_ = other.cloudBigtableClusterSpecs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            cloudBigtableClusterSpecsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCloudBigtableClusterSpecsFieldBuilder()
                    : null;
          } else {
            cloudBigtableClusterSpecsBuilder_.addAllMessages(other.cloudBigtableClusterSpecs_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
                    m =
                        input.readMessage(
                            com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec
                                .CloudBigtableClusterSpec.parser(),
                            extensionRegistry);
                if (cloudBigtableClusterSpecsBuilder_ == null) {
                  ensureCloudBigtableClusterSpecsIsMutable();
                  cloudBigtableClusterSpecs_.add(m);
                } else {
                  cloudBigtableClusterSpecsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec>
        cloudBigtableClusterSpecs_ = java.util.Collections.emptyList();

    private void ensureCloudBigtableClusterSpecsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        cloudBigtableClusterSpecs_ =
            new java.util.ArrayList<
                com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec>(
                cloudBigtableClusterSpecs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec,
            com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
                .Builder,
            com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec
                .CloudBigtableClusterSpecOrBuilder>
        cloudBigtableClusterSpecsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of clusters for the Instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec>
        getCloudBigtableClusterSpecsList() {
      if (cloudBigtableClusterSpecsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(cloudBigtableClusterSpecs_);
      } else {
        return cloudBigtableClusterSpecsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The list of clusters for the Instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
     * </code>
     */
    public int getCloudBigtableClusterSpecsCount() {
      if (cloudBigtableClusterSpecsBuilder_ == null) {
        return cloudBigtableClusterSpecs_.size();
      } else {
        return cloudBigtableClusterSpecsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The list of clusters for the Instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
     * </code>
     */
    public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
        getCloudBigtableClusterSpecs(int index) {
      if (cloudBigtableClusterSpecsBuilder_ == null) {
        return cloudBigtableClusterSpecs_.get(index);
      } else {
        return cloudBigtableClusterSpecsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of clusters for the Instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
     * </code>
     */
    public Builder setCloudBigtableClusterSpecs(
        int index,
        com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec value) {
      if (cloudBigtableClusterSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCloudBigtableClusterSpecsIsMutable();
        cloudBigtableClusterSpecs_.set(index, value);
        onChanged();
      } else {
        cloudBigtableClusterSpecsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of clusters for the Instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
     * </code>
     */
    public Builder setCloudBigtableClusterSpecs(
        int index,
        com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec.Builder
            builderForValue) {
      if (cloudBigtableClusterSpecsBuilder_ == null) {
        ensureCloudBigtableClusterSpecsIsMutable();
        cloudBigtableClusterSpecs_.set(index, builderForValue.build());
        onChanged();
      } else {
        cloudBigtableClusterSpecsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of clusters for the Instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
     * </code>
     */
    public Builder addCloudBigtableClusterSpecs(
        com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec value) {
      if (cloudBigtableClusterSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCloudBigtableClusterSpecsIsMutable();
        cloudBigtableClusterSpecs_.add(value);
        onChanged();
      } else {
        cloudBigtableClusterSpecsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of clusters for the Instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
     * </code>
     */
    public Builder addCloudBigtableClusterSpecs(
        int index,
        com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec value) {
      if (cloudBigtableClusterSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCloudBigtableClusterSpecsIsMutable();
        cloudBigtableClusterSpecs_.add(index, value);
        onChanged();
      } else {
        cloudBigtableClusterSpecsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of clusters for the Instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
     * </code>
     */
    public Builder addCloudBigtableClusterSpecs(
        com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec.Builder
            builderForValue) {
      if (cloudBigtableClusterSpecsBuilder_ == null) {
        ensureCloudBigtableClusterSpecsIsMutable();
        cloudBigtableClusterSpecs_.add(builderForValue.build());
        onChanged();
      } else {
        cloudBigtableClusterSpecsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of clusters for the Instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
     * </code>
     */
    public Builder addCloudBigtableClusterSpecs(
        int index,
        com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec.Builder
            builderForValue) {
      if (cloudBigtableClusterSpecsBuilder_ == null) {
        ensureCloudBigtableClusterSpecsIsMutable();
        cloudBigtableClusterSpecs_.add(index, builderForValue.build());
        onChanged();
      } else {
        cloudBigtableClusterSpecsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of clusters for the Instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
     * </code>
     */
    public Builder addAllCloudBigtableClusterSpecs(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec
                        .CloudBigtableClusterSpec>
            values) {
      if (cloudBigtableClusterSpecsBuilder_ == null) {
        ensureCloudBigtableClusterSpecsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, cloudBigtableClusterSpecs_);
        onChanged();
      } else {
        cloudBigtableClusterSpecsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of clusters for the Instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
     * </code>
     */
    public Builder clearCloudBigtableClusterSpecs() {
      if (cloudBigtableClusterSpecsBuilder_ == null) {
        cloudBigtableClusterSpecs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        cloudBigtableClusterSpecsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of clusters for the Instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
     * </code>
     */
    public Builder removeCloudBigtableClusterSpecs(int index) {
      if (cloudBigtableClusterSpecsBuilder_ == null) {
        ensureCloudBigtableClusterSpecsIsMutable();
        cloudBigtableClusterSpecs_.remove(index);
        onChanged();
      } else {
        cloudBigtableClusterSpecsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of clusters for the Instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
     * </code>
     */
    public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
            .Builder
        getCloudBigtableClusterSpecsBuilder(int index) {
      return getCloudBigtableClusterSpecsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The list of clusters for the Instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
     * </code>
     */
    public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec
            .CloudBigtableClusterSpecOrBuilder
        getCloudBigtableClusterSpecsOrBuilder(int index) {
      if (cloudBigtableClusterSpecsBuilder_ == null) {
        return cloudBigtableClusterSpecs_.get(index);
      } else {
        return cloudBigtableClusterSpecsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of clusters for the Instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec
                    .CloudBigtableClusterSpecOrBuilder>
        getCloudBigtableClusterSpecsOrBuilderList() {
      if (cloudBigtableClusterSpecsBuilder_ != null) {
        return cloudBigtableClusterSpecsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(cloudBigtableClusterSpecs_);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of clusters for the Instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
     * </code>
     */
    public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
            .Builder
        addCloudBigtableClusterSpecsBuilder() {
      return getCloudBigtableClusterSpecsFieldBuilder()
          .addBuilder(
              com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The list of clusters for the Instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
     * </code>
     */
    public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
            .Builder
        addCloudBigtableClusterSpecsBuilder(int index) {
      return getCloudBigtableClusterSpecsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The list of clusters for the Instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec cloud_bigtable_cluster_specs = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
                .Builder>
        getCloudBigtableClusterSpecsBuilderList() {
      return getCloudBigtableClusterSpecsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec,
            com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
                .Builder,
            com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec
                .CloudBigtableClusterSpecOrBuilder>
        getCloudBigtableClusterSpecsFieldBuilder() {
      if (cloudBigtableClusterSpecsBuilder_ == null) {
        cloudBigtableClusterSpecsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec,
                com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.CloudBigtableClusterSpec
                    .Builder,
                com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec
                    .CloudBigtableClusterSpecOrBuilder>(
                cloudBigtableClusterSpecs_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        cloudBigtableClusterSpecs_ = null;
      }
      return cloudBigtableClusterSpecsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.CloudBigtableInstanceSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.CloudBigtableInstanceSpec)
  private static final com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec();
  }

  public static com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloudBigtableInstanceSpec> PARSER =
      new com.google.protobuf.AbstractParser<CloudBigtableInstanceSpec>() {
        @java.lang.Override
        public CloudBigtableInstanceSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloudBigtableInstanceSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloudBigtableInstanceSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
