/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a rule that describes one or more match conditions along with the action to be taken when traffic matches this condition (allow or deny).
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.SecurityPolicyRule}
 */
public final class SecurityPolicyRule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.SecurityPolicyRule)
    SecurityPolicyRuleOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SecurityPolicyRule.newBuilder() to construct.
  private SecurityPolicyRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SecurityPolicyRule() {
    action_ = "";
    description_ = "";
    kind_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SecurityPolicyRule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SecurityPolicyRule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SecurityPolicyRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.SecurityPolicyRule.class,
            com.google.cloud.compute.v1.SecurityPolicyRule.Builder.class);
  }

  private int bitField0_;
  public static final int ACTION_FIELD_NUMBER = 187661878;

  @SuppressWarnings("serial")
  private volatile java.lang.Object action_ = "";

  /**
   *
   *
   * <pre>
   * The Action to perform when the rule is matched. The following are the valid actions: - allow: allow access to target. - deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for `STATUS` are 403, 404, and 502. - rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rate_limit_options to be set. - redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR. - throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rate_limit_options to be set for this. - fairshare (preview only): when traffic reaches the threshold limit, requests from the clients matching this rule begin to be rate-limited using the Fair Share algorithm. This action is only allowed in security policies of type `CLOUD_ARMOR_INTERNAL_SERVICE`.
   * </pre>
   *
   * <code>optional string action = 187661878;</code>
   *
   * @return Whether the action field is set.
   */
  @java.lang.Override
  public boolean hasAction() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The Action to perform when the rule is matched. The following are the valid actions: - allow: allow access to target. - deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for `STATUS` are 403, 404, and 502. - rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rate_limit_options to be set. - redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR. - throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rate_limit_options to be set for this. - fairshare (preview only): when traffic reaches the threshold limit, requests from the clients matching this rule begin to be rate-limited using the Fair Share algorithm. This action is only allowed in security policies of type `CLOUD_ARMOR_INTERNAL_SERVICE`.
   * </pre>
   *
   * <code>optional string action = 187661878;</code>
   *
   * @return The action.
   */
  @java.lang.Override
  public java.lang.String getAction() {
    java.lang.Object ref = action_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      action_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The Action to perform when the rule is matched. The following are the valid actions: - allow: allow access to target. - deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for `STATUS` are 403, 404, and 502. - rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rate_limit_options to be set. - redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR. - throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rate_limit_options to be set for this. - fairshare (preview only): when traffic reaches the threshold limit, requests from the clients matching this rule begin to be rate-limited using the Fair Share algorithm. This action is only allowed in security policies of type `CLOUD_ARMOR_INTERNAL_SERVICE`.
   * </pre>
   *
   * <code>optional string action = 187661878;</code>
   *
   * @return The bytes for action.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getActionBytes() {
    java.lang.Object ref = action_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      action_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEADER_ACTION_FIELD_NUMBER = 328077352;
  private com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction headerAction_;

  /**
   *
   *
   * <pre>
   * Optional, additional actions that are performed on headers. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction header_action = 328077352;
   * </code>
   *
   * @return Whether the headerAction field is set.
   */
  @java.lang.Override
  public boolean hasHeaderAction() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional, additional actions that are performed on headers. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction header_action = 328077352;
   * </code>
   *
   * @return The headerAction.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction getHeaderAction() {
    return headerAction_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction.getDefaultInstance()
        : headerAction_;
  }

  /**
   *
   *
   * <pre>
   * Optional, additional actions that are performed on headers. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction header_action = 328077352;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderActionOrBuilder
      getHeaderActionOrBuilder() {
    return headerAction_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction.getDefaultInstance()
        : headerAction_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output only] Type of the resource. Always compute#securityPolicyRule for security policy rules
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output only] Type of the resource. Always compute#securityPolicyRule for security policy rules
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output only] Type of the resource. Always compute#securityPolicyRule for security policy rules
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MATCH_FIELD_NUMBER = 103668165;
  private com.google.cloud.compute.v1.SecurityPolicyRuleMatcher match_;

  /**
   *
   *
   * <pre>
   * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcher match = 103668165;</code>
   *
   * @return Whether the match field is set.
   */
  @java.lang.Override
  public boolean hasMatch() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcher match = 103668165;</code>
   *
   * @return The match.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleMatcher getMatch() {
    return match_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleMatcher.getDefaultInstance()
        : match_;
  }

  /**
   *
   *
   * <pre>
   * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcher match = 103668165;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleMatcherOrBuilder getMatchOrBuilder() {
    return match_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleMatcher.getDefaultInstance()
        : match_;
  }

  public static final int NETWORK_MATCH_FIELD_NUMBER = 463387764;
  private com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher networkMatch_;

  /**
   *
   *
   * <pre>
   * A match condition that incoming packets are evaluated against for CLOUD_ARMOR_NETWORK security policies. If it matches, the corresponding 'action' is enforced. The match criteria for a rule consists of built-in match fields (like 'srcIpRanges') and potentially multiple user-defined match fields ('userDefinedFields'). Field values may be extracted directly from the packet or derived from it (e.g. 'srcRegionCodes'). Some fields may not be present in every packet (e.g. 'srcPorts'). A user-defined field is only present if the base header is found in the packet and the entire field is in bounds. Each match field may specify which values can match it, listing one or more ranges, prefixes, or exact values that are considered a match for the field. A field value must be present in order to match a specified match field. If no match values are specified for a match field, then any field value is considered to match it, and it's not required to be present. For strings specifying '*' is also equivalent to match all. For a packet to match a rule, all specified match fields must match the corresponding field values derived from the packet. Example: networkMatch: srcIpRanges: - "192.0.2.0/24" - "198.51.100.0/24" userDefinedFields: - name: "ipv4_fragment_offset" values: - "1-0x1fff" The above match condition matches packets with a source IP in 192.0.2.0/24 or 198.51.100.0/24 and a user-defined field named "ipv4_fragment_offset" with a value between 1 and 0x1fff inclusive.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher network_match = 463387764;
   * </code>
   *
   * @return Whether the networkMatch field is set.
   */
  @java.lang.Override
  public boolean hasNetworkMatch() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * A match condition that incoming packets are evaluated against for CLOUD_ARMOR_NETWORK security policies. If it matches, the corresponding 'action' is enforced. The match criteria for a rule consists of built-in match fields (like 'srcIpRanges') and potentially multiple user-defined match fields ('userDefinedFields'). Field values may be extracted directly from the packet or derived from it (e.g. 'srcRegionCodes'). Some fields may not be present in every packet (e.g. 'srcPorts'). A user-defined field is only present if the base header is found in the packet and the entire field is in bounds. Each match field may specify which values can match it, listing one or more ranges, prefixes, or exact values that are considered a match for the field. A field value must be present in order to match a specified match field. If no match values are specified for a match field, then any field value is considered to match it, and it's not required to be present. For strings specifying '*' is also equivalent to match all. For a packet to match a rule, all specified match fields must match the corresponding field values derived from the packet. Example: networkMatch: srcIpRanges: - "192.0.2.0/24" - "198.51.100.0/24" userDefinedFields: - name: "ipv4_fragment_offset" values: - "1-0x1fff" The above match condition matches packets with a source IP in 192.0.2.0/24 or 198.51.100.0/24 and a user-defined field named "ipv4_fragment_offset" with a value between 1 and 0x1fff inclusive.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher network_match = 463387764;
   * </code>
   *
   * @return The networkMatch.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher getNetworkMatch() {
    return networkMatch_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher.getDefaultInstance()
        : networkMatch_;
  }

  /**
   *
   *
   * <pre>
   * A match condition that incoming packets are evaluated against for CLOUD_ARMOR_NETWORK security policies. If it matches, the corresponding 'action' is enforced. The match criteria for a rule consists of built-in match fields (like 'srcIpRanges') and potentially multiple user-defined match fields ('userDefinedFields'). Field values may be extracted directly from the packet or derived from it (e.g. 'srcRegionCodes'). Some fields may not be present in every packet (e.g. 'srcPorts'). A user-defined field is only present if the base header is found in the packet and the entire field is in bounds. Each match field may specify which values can match it, listing one or more ranges, prefixes, or exact values that are considered a match for the field. A field value must be present in order to match a specified match field. If no match values are specified for a match field, then any field value is considered to match it, and it's not required to be present. For strings specifying '*' is also equivalent to match all. For a packet to match a rule, all specified match fields must match the corresponding field values derived from the packet. Example: networkMatch: srcIpRanges: - "192.0.2.0/24" - "198.51.100.0/24" userDefinedFields: - name: "ipv4_fragment_offset" values: - "1-0x1fff" The above match condition matches packets with a source IP in 192.0.2.0/24 or 198.51.100.0/24 and a user-defined field named "ipv4_fragment_offset" with a value between 1 and 0x1fff inclusive.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher network_match = 463387764;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherOrBuilder
      getNetworkMatchOrBuilder() {
    return networkMatch_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher.getDefaultInstance()
        : networkMatch_;
  }

  public static final int PRECONFIGURED_WAF_CONFIG_FIELD_NUMBER = 117805027;
  private com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig
      preconfiguredWafConfig_;

  /**
   *
   *
   * <pre>
   * Preconfigured WAF configuration to be applied for the rule. If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig preconfigured_waf_config = 117805027;
   * </code>
   *
   * @return Whether the preconfiguredWafConfig field is set.
   */
  @java.lang.Override
  public boolean hasPreconfiguredWafConfig() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Preconfigured WAF configuration to be applied for the rule. If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig preconfigured_waf_config = 117805027;
   * </code>
   *
   * @return The preconfiguredWafConfig.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig
      getPreconfiguredWafConfig() {
    return preconfiguredWafConfig_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig.getDefaultInstance()
        : preconfiguredWafConfig_;
  }

  /**
   *
   *
   * <pre>
   * Preconfigured WAF configuration to be applied for the rule. If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig preconfigured_waf_config = 117805027;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfigOrBuilder
      getPreconfiguredWafConfigOrBuilder() {
    return preconfiguredWafConfig_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig.getDefaultInstance()
        : preconfiguredWafConfig_;
  }

  public static final int PREVIEW_FIELD_NUMBER = 218686408;
  private boolean preview_ = false;

  /**
   *
   *
   * <pre>
   * If set to true, the specified action is not enforced.
   * </pre>
   *
   * <code>optional bool preview = 218686408;</code>
   *
   * @return Whether the preview field is set.
   */
  @java.lang.Override
  public boolean hasPreview() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * If set to true, the specified action is not enforced.
   * </pre>
   *
   * <code>optional bool preview = 218686408;</code>
   *
   * @return The preview.
   */
  @java.lang.Override
  public boolean getPreview() {
    return preview_;
  }

  public static final int PRIORITY_FIELD_NUMBER = 445151652;
  private int priority_ = 0;

  /**
   *
   *
   * <pre>
   * An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
   * </pre>
   *
   * <code>optional int32 priority = 445151652;</code>
   *
   * @return Whether the priority field is set.
   */
  @java.lang.Override
  public boolean hasPriority() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
   * </pre>
   *
   * <code>optional int32 priority = 445151652;</code>
   *
   * @return The priority.
   */
  @java.lang.Override
  public int getPriority() {
    return priority_;
  }

  public static final int RATE_LIMIT_OPTIONS_FIELD_NUMBER = 67544315;
  private com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions rateLimitOptions_;

  /**
   *
   *
   * <pre>
   * Must be specified if the action is "rate_based_ban" or "throttle" or "fairshare". Cannot be specified for any other actions.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions rate_limit_options = 67544315;
   * </code>
   *
   * @return Whether the rateLimitOptions field is set.
   */
  @java.lang.Override
  public boolean hasRateLimitOptions() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * Must be specified if the action is "rate_based_ban" or "throttle" or "fairshare". Cannot be specified for any other actions.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions rate_limit_options = 67544315;
   * </code>
   *
   * @return The rateLimitOptions.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions getRateLimitOptions() {
    return rateLimitOptions_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions.getDefaultInstance()
        : rateLimitOptions_;
  }

  /**
   *
   *
   * <pre>
   * Must be specified if the action is "rate_based_ban" or "throttle" or "fairshare". Cannot be specified for any other actions.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions rate_limit_options = 67544315;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsOrBuilder
      getRateLimitOptionsOrBuilder() {
    return rateLimitOptions_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions.getDefaultInstance()
        : rateLimitOptions_;
  }

  public static final int REDIRECT_OPTIONS_FIELD_NUMBER = 163285307;
  private com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions redirectOptions_;

  /**
   *
   *
   * <pre>
   * Parameters defining the redirect action. Cannot be specified for any other actions. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions redirect_options = 163285307;
   * </code>
   *
   * @return Whether the redirectOptions field is set.
   */
  @java.lang.Override
  public boolean hasRedirectOptions() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * Parameters defining the redirect action. Cannot be specified for any other actions. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions redirect_options = 163285307;
   * </code>
   *
   * @return The redirectOptions.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions getRedirectOptions() {
    return redirectOptions_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions.getDefaultInstance()
        : redirectOptions_;
  }

  /**
   *
   *
   * <pre>
   * Parameters defining the redirect action. Cannot be specified for any other actions. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions redirect_options = 163285307;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptionsOrBuilder
      getRedirectOptionsOrBuilder() {
    return redirectOptions_ == null
        ? com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions.getDefaultInstance()
        : redirectOptions_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(67544315, getRateLimitOptions());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(103668165, getMatch());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(117805027, getPreconfiguredWafConfig());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(163285307, getRedirectOptions());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 187661878, action_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeBool(218686408, preview_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(328077352, getHeaderAction());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeInt32(445151652, priority_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(463387764, getNetworkMatch());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(67544315, getRateLimitOptions());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(103668165, getMatch());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              117805027, getPreconfiguredWafConfig());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(163285307, getRedirectOptions());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(187661878, action_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(218686408, preview_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(328077352, getHeaderAction());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(445151652, priority_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(463387764, getNetworkMatch());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.SecurityPolicyRule)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.SecurityPolicyRule other =
        (com.google.cloud.compute.v1.SecurityPolicyRule) obj;

    if (hasAction() != other.hasAction()) return false;
    if (hasAction()) {
      if (!getAction().equals(other.getAction())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasHeaderAction() != other.hasHeaderAction()) return false;
    if (hasHeaderAction()) {
      if (!getHeaderAction().equals(other.getHeaderAction())) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasMatch() != other.hasMatch()) return false;
    if (hasMatch()) {
      if (!getMatch().equals(other.getMatch())) return false;
    }
    if (hasNetworkMatch() != other.hasNetworkMatch()) return false;
    if (hasNetworkMatch()) {
      if (!getNetworkMatch().equals(other.getNetworkMatch())) return false;
    }
    if (hasPreconfiguredWafConfig() != other.hasPreconfiguredWafConfig()) return false;
    if (hasPreconfiguredWafConfig()) {
      if (!getPreconfiguredWafConfig().equals(other.getPreconfiguredWafConfig())) return false;
    }
    if (hasPreview() != other.hasPreview()) return false;
    if (hasPreview()) {
      if (getPreview() != other.getPreview()) return false;
    }
    if (hasPriority() != other.hasPriority()) return false;
    if (hasPriority()) {
      if (getPriority() != other.getPriority()) return false;
    }
    if (hasRateLimitOptions() != other.hasRateLimitOptions()) return false;
    if (hasRateLimitOptions()) {
      if (!getRateLimitOptions().equals(other.getRateLimitOptions())) return false;
    }
    if (hasRedirectOptions() != other.hasRedirectOptions()) return false;
    if (hasRedirectOptions()) {
      if (!getRedirectOptions().equals(other.getRedirectOptions())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAction()) {
      hash = (37 * hash) + ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getAction().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasHeaderAction()) {
      hash = (37 * hash) + HEADER_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getHeaderAction().hashCode();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasMatch()) {
      hash = (37 * hash) + MATCH_FIELD_NUMBER;
      hash = (53 * hash) + getMatch().hashCode();
    }
    if (hasNetworkMatch()) {
      hash = (37 * hash) + NETWORK_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkMatch().hashCode();
    }
    if (hasPreconfiguredWafConfig()) {
      hash = (37 * hash) + PRECONFIGURED_WAF_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPreconfiguredWafConfig().hashCode();
    }
    if (hasPreview()) {
      hash = (37 * hash) + PREVIEW_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPreview());
    }
    if (hasPriority()) {
      hash = (37 * hash) + PRIORITY_FIELD_NUMBER;
      hash = (53 * hash) + getPriority();
    }
    if (hasRateLimitOptions()) {
      hash = (37 * hash) + RATE_LIMIT_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getRateLimitOptions().hashCode();
    }
    if (hasRedirectOptions()) {
      hash = (37 * hash) + REDIRECT_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getRedirectOptions().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRule parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.SecurityPolicyRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a rule that describes one or more match conditions along with the action to be taken when traffic matches this condition (allow or deny).
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.SecurityPolicyRule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.SecurityPolicyRule)
      com.google.cloud.compute.v1.SecurityPolicyRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SecurityPolicyRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SecurityPolicyRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.SecurityPolicyRule.class,
              com.google.cloud.compute.v1.SecurityPolicyRule.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.SecurityPolicyRule.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getHeaderActionFieldBuilder();
        getMatchFieldBuilder();
        getNetworkMatchFieldBuilder();
        getPreconfiguredWafConfigFieldBuilder();
        getRateLimitOptionsFieldBuilder();
        getRedirectOptionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      action_ = "";
      description_ = "";
      headerAction_ = null;
      if (headerActionBuilder_ != null) {
        headerActionBuilder_.dispose();
        headerActionBuilder_ = null;
      }
      kind_ = "";
      match_ = null;
      if (matchBuilder_ != null) {
        matchBuilder_.dispose();
        matchBuilder_ = null;
      }
      networkMatch_ = null;
      if (networkMatchBuilder_ != null) {
        networkMatchBuilder_.dispose();
        networkMatchBuilder_ = null;
      }
      preconfiguredWafConfig_ = null;
      if (preconfiguredWafConfigBuilder_ != null) {
        preconfiguredWafConfigBuilder_.dispose();
        preconfiguredWafConfigBuilder_ = null;
      }
      preview_ = false;
      priority_ = 0;
      rateLimitOptions_ = null;
      if (rateLimitOptionsBuilder_ != null) {
        rateLimitOptionsBuilder_.dispose();
        rateLimitOptionsBuilder_ = null;
      }
      redirectOptions_ = null;
      if (redirectOptionsBuilder_ != null) {
        redirectOptionsBuilder_.dispose();
        redirectOptionsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SecurityPolicyRule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SecurityPolicyRule getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.SecurityPolicyRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SecurityPolicyRule build() {
      com.google.cloud.compute.v1.SecurityPolicyRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SecurityPolicyRule buildPartial() {
      com.google.cloud.compute.v1.SecurityPolicyRule result =
          new com.google.cloud.compute.v1.SecurityPolicyRule(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.SecurityPolicyRule result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.action_ = action_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.headerAction_ =
            headerActionBuilder_ == null ? headerAction_ : headerActionBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.match_ = matchBuilder_ == null ? match_ : matchBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.networkMatch_ =
            networkMatchBuilder_ == null ? networkMatch_ : networkMatchBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.preconfiguredWafConfig_ =
            preconfiguredWafConfigBuilder_ == null
                ? preconfiguredWafConfig_
                : preconfiguredWafConfigBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.preview_ = preview_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.priority_ = priority_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.rateLimitOptions_ =
            rateLimitOptionsBuilder_ == null ? rateLimitOptions_ : rateLimitOptionsBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.redirectOptions_ =
            redirectOptionsBuilder_ == null ? redirectOptions_ : redirectOptionsBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.SecurityPolicyRule) {
        return mergeFrom((com.google.cloud.compute.v1.SecurityPolicyRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.SecurityPolicyRule other) {
      if (other == com.google.cloud.compute.v1.SecurityPolicyRule.getDefaultInstance()) return this;
      if (other.hasAction()) {
        action_ = other.action_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasHeaderAction()) {
        mergeHeaderAction(other.getHeaderAction());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasMatch()) {
        mergeMatch(other.getMatch());
      }
      if (other.hasNetworkMatch()) {
        mergeNetworkMatch(other.getNetworkMatch());
      }
      if (other.hasPreconfiguredWafConfig()) {
        mergePreconfiguredWafConfig(other.getPreconfiguredWafConfig());
      }
      if (other.hasPreview()) {
        setPreview(other.getPreview());
      }
      if (other.hasPriority()) {
        setPriority(other.getPriority());
      }
      if (other.hasRateLimitOptions()) {
        mergeRateLimitOptions(other.getRateLimitOptions());
      }
      if (other.hasRedirectOptions()) {
        mergeRedirectOptions(other.getRedirectOptions());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 26336418
            case 540354522:
              {
                input.readMessage(
                    getRateLimitOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 540354522
            case 829345322:
              {
                input.readMessage(getMatchFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 829345322
            case 942440218:
              {
                input.readMessage(
                    getPreconfiguredWafConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 942440218
            case 1306282458:
              {
                input.readMessage(getRedirectOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 1306282458
            case 1501295026:
              {
                action_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 1501295026
            case 1749491264:
              {
                preview_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 1749491264
            case -1670348478:
              {
                input.readMessage(getHeaderActionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case -1670348478
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -911466526
            case -733754080:
              {
                priority_ = input.readInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case -733754080
            case -587865182:
              {
                input.readMessage(getNetworkMatchFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case -587865182
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object action_ = "";

    /**
     *
     *
     * <pre>
     * The Action to perform when the rule is matched. The following are the valid actions: - allow: allow access to target. - deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for `STATUS` are 403, 404, and 502. - rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rate_limit_options to be set. - redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR. - throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rate_limit_options to be set for this. - fairshare (preview only): when traffic reaches the threshold limit, requests from the clients matching this rule begin to be rate-limited using the Fair Share algorithm. This action is only allowed in security policies of type `CLOUD_ARMOR_INTERNAL_SERVICE`.
     * </pre>
     *
     * <code>optional string action = 187661878;</code>
     *
     * @return Whether the action field is set.
     */
    public boolean hasAction() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The Action to perform when the rule is matched. The following are the valid actions: - allow: allow access to target. - deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for `STATUS` are 403, 404, and 502. - rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rate_limit_options to be set. - redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR. - throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rate_limit_options to be set for this. - fairshare (preview only): when traffic reaches the threshold limit, requests from the clients matching this rule begin to be rate-limited using the Fair Share algorithm. This action is only allowed in security policies of type `CLOUD_ARMOR_INTERNAL_SERVICE`.
     * </pre>
     *
     * <code>optional string action = 187661878;</code>
     *
     * @return The action.
     */
    public java.lang.String getAction() {
      java.lang.Object ref = action_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        action_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The Action to perform when the rule is matched. The following are the valid actions: - allow: allow access to target. - deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for `STATUS` are 403, 404, and 502. - rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rate_limit_options to be set. - redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR. - throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rate_limit_options to be set for this. - fairshare (preview only): when traffic reaches the threshold limit, requests from the clients matching this rule begin to be rate-limited using the Fair Share algorithm. This action is only allowed in security policies of type `CLOUD_ARMOR_INTERNAL_SERVICE`.
     * </pre>
     *
     * <code>optional string action = 187661878;</code>
     *
     * @return The bytes for action.
     */
    public com.google.protobuf.ByteString getActionBytes() {
      java.lang.Object ref = action_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        action_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The Action to perform when the rule is matched. The following are the valid actions: - allow: allow access to target. - deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for `STATUS` are 403, 404, and 502. - rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rate_limit_options to be set. - redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR. - throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rate_limit_options to be set for this. - fairshare (preview only): when traffic reaches the threshold limit, requests from the clients matching this rule begin to be rate-limited using the Fair Share algorithm. This action is only allowed in security policies of type `CLOUD_ARMOR_INTERNAL_SERVICE`.
     * </pre>
     *
     * <code>optional string action = 187661878;</code>
     *
     * @param value The action to set.
     * @return This builder for chaining.
     */
    public Builder setAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      action_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Action to perform when the rule is matched. The following are the valid actions: - allow: allow access to target. - deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for `STATUS` are 403, 404, and 502. - rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rate_limit_options to be set. - redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR. - throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rate_limit_options to be set for this. - fairshare (preview only): when traffic reaches the threshold limit, requests from the clients matching this rule begin to be rate-limited using the Fair Share algorithm. This action is only allowed in security policies of type `CLOUD_ARMOR_INTERNAL_SERVICE`.
     * </pre>
     *
     * <code>optional string action = 187661878;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAction() {
      action_ = getDefaultInstance().getAction();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Action to perform when the rule is matched. The following are the valid actions: - allow: allow access to target. - deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for `STATUS` are 403, 404, and 502. - rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rate_limit_options to be set. - redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR. - throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rate_limit_options to be set for this. - fairshare (preview only): when traffic reaches the threshold limit, requests from the clients matching this rule begin to be rate-limited using the Fair Share algorithm. This action is only allowed in security policies of type `CLOUD_ARMOR_INTERNAL_SERVICE`.
     * </pre>
     *
     * <code>optional string action = 187661878;</code>
     *
     * @param value The bytes for action to set.
     * @return This builder for chaining.
     */
    public Builder setActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      action_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction headerAction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction,
            com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderActionOrBuilder>
        headerActionBuilder_;

    /**
     *
     *
     * <pre>
     * Optional, additional actions that are performed on headers. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction header_action = 328077352;
     * </code>
     *
     * @return Whether the headerAction field is set.
     */
    public boolean hasHeaderAction() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional, additional actions that are performed on headers. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction header_action = 328077352;
     * </code>
     *
     * @return The headerAction.
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction getHeaderAction() {
      if (headerActionBuilder_ == null) {
        return headerAction_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction.getDefaultInstance()
            : headerAction_;
      } else {
        return headerActionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional, additional actions that are performed on headers. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction header_action = 328077352;
     * </code>
     */
    public Builder setHeaderAction(
        com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction value) {
      if (headerActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        headerAction_ = value;
      } else {
        headerActionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional, additional actions that are performed on headers. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction header_action = 328077352;
     * </code>
     */
    public Builder setHeaderAction(
        com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction.Builder builderForValue) {
      if (headerActionBuilder_ == null) {
        headerAction_ = builderForValue.build();
      } else {
        headerActionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional, additional actions that are performed on headers. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction header_action = 328077352;
     * </code>
     */
    public Builder mergeHeaderAction(
        com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction value) {
      if (headerActionBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && headerAction_ != null
            && headerAction_
                != com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction
                    .getDefaultInstance()) {
          getHeaderActionBuilder().mergeFrom(value);
        } else {
          headerAction_ = value;
        }
      } else {
        headerActionBuilder_.mergeFrom(value);
      }
      if (headerAction_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional, additional actions that are performed on headers. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction header_action = 328077352;
     * </code>
     */
    public Builder clearHeaderAction() {
      bitField0_ = (bitField0_ & ~0x00000004);
      headerAction_ = null;
      if (headerActionBuilder_ != null) {
        headerActionBuilder_.dispose();
        headerActionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional, additional actions that are performed on headers. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction header_action = 328077352;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction.Builder
        getHeaderActionBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getHeaderActionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional, additional actions that are performed on headers. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction header_action = 328077352;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderActionOrBuilder
        getHeaderActionOrBuilder() {
      if (headerActionBuilder_ != null) {
        return headerActionBuilder_.getMessageOrBuilder();
      } else {
        return headerAction_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction.getDefaultInstance()
            : headerAction_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional, additional actions that are performed on headers. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction header_action = 328077352;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction,
            com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderActionOrBuilder>
        getHeaderActionFieldBuilder() {
      if (headerActionBuilder_ == null) {
        headerActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction,
                com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderAction.Builder,
                com.google.cloud.compute.v1.SecurityPolicyRuleHttpHeaderActionOrBuilder>(
                getHeaderAction(), getParentForChildren(), isClean());
        headerAction_ = null;
      }
      return headerActionBuilder_;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output only] Type of the resource. Always compute#securityPolicyRule for security policy rules
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output only] Type of the resource. Always compute#securityPolicyRule for security policy rules
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] Type of the resource. Always compute#securityPolicyRule for security policy rules
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] Type of the resource. Always compute#securityPolicyRule for security policy rules
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] Type of the resource. Always compute#securityPolicyRule for security policy rules
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] Type of the resource. Always compute#securityPolicyRule for security policy rules
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.SecurityPolicyRuleMatcher match_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcher,
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcher.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcherOrBuilder>
        matchBuilder_;

    /**
     *
     *
     * <pre>
     * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcher match = 103668165;</code>
     *
     * @return Whether the match field is set.
     */
    public boolean hasMatch() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcher match = 103668165;</code>
     *
     * @return The match.
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleMatcher getMatch() {
      if (matchBuilder_ == null) {
        return match_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleMatcher.getDefaultInstance()
            : match_;
      } else {
        return matchBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcher match = 103668165;</code>
     */
    public Builder setMatch(com.google.cloud.compute.v1.SecurityPolicyRuleMatcher value) {
      if (matchBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        match_ = value;
      } else {
        matchBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcher match = 103668165;</code>
     */
    public Builder setMatch(
        com.google.cloud.compute.v1.SecurityPolicyRuleMatcher.Builder builderForValue) {
      if (matchBuilder_ == null) {
        match_ = builderForValue.build();
      } else {
        matchBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcher match = 103668165;</code>
     */
    public Builder mergeMatch(com.google.cloud.compute.v1.SecurityPolicyRuleMatcher value) {
      if (matchBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && match_ != null
            && match_
                != com.google.cloud.compute.v1.SecurityPolicyRuleMatcher.getDefaultInstance()) {
          getMatchBuilder().mergeFrom(value);
        } else {
          match_ = value;
        }
      } else {
        matchBuilder_.mergeFrom(value);
      }
      if (match_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcher match = 103668165;</code>
     */
    public Builder clearMatch() {
      bitField0_ = (bitField0_ & ~0x00000010);
      match_ = null;
      if (matchBuilder_ != null) {
        matchBuilder_.dispose();
        matchBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcher match = 103668165;</code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleMatcher.Builder getMatchBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getMatchFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcher match = 103668165;</code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleMatcherOrBuilder getMatchOrBuilder() {
      if (matchBuilder_ != null) {
        return matchBuilder_.getMessageOrBuilder();
      } else {
        return match_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleMatcher.getDefaultInstance()
            : match_;
      }
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.SecurityPolicyRuleMatcher match = 103668165;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcher,
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcher.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleMatcherOrBuilder>
        getMatchFieldBuilder() {
      if (matchBuilder_ == null) {
        matchBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SecurityPolicyRuleMatcher,
                com.google.cloud.compute.v1.SecurityPolicyRuleMatcher.Builder,
                com.google.cloud.compute.v1.SecurityPolicyRuleMatcherOrBuilder>(
                getMatch(), getParentForChildren(), isClean());
        match_ = null;
      }
      return matchBuilder_;
    }

    private com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher networkMatch_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher,
            com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherOrBuilder>
        networkMatchBuilder_;

    /**
     *
     *
     * <pre>
     * A match condition that incoming packets are evaluated against for CLOUD_ARMOR_NETWORK security policies. If it matches, the corresponding 'action' is enforced. The match criteria for a rule consists of built-in match fields (like 'srcIpRanges') and potentially multiple user-defined match fields ('userDefinedFields'). Field values may be extracted directly from the packet or derived from it (e.g. 'srcRegionCodes'). Some fields may not be present in every packet (e.g. 'srcPorts'). A user-defined field is only present if the base header is found in the packet and the entire field is in bounds. Each match field may specify which values can match it, listing one or more ranges, prefixes, or exact values that are considered a match for the field. A field value must be present in order to match a specified match field. If no match values are specified for a match field, then any field value is considered to match it, and it's not required to be present. For strings specifying '*' is also equivalent to match all. For a packet to match a rule, all specified match fields must match the corresponding field values derived from the packet. Example: networkMatch: srcIpRanges: - "192.0.2.0/24" - "198.51.100.0/24" userDefinedFields: - name: "ipv4_fragment_offset" values: - "1-0x1fff" The above match condition matches packets with a source IP in 192.0.2.0/24 or 198.51.100.0/24 and a user-defined field named "ipv4_fragment_offset" with a value between 1 and 0x1fff inclusive.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher network_match = 463387764;
     * </code>
     *
     * @return Whether the networkMatch field is set.
     */
    public boolean hasNetworkMatch() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming packets are evaluated against for CLOUD_ARMOR_NETWORK security policies. If it matches, the corresponding 'action' is enforced. The match criteria for a rule consists of built-in match fields (like 'srcIpRanges') and potentially multiple user-defined match fields ('userDefinedFields'). Field values may be extracted directly from the packet or derived from it (e.g. 'srcRegionCodes'). Some fields may not be present in every packet (e.g. 'srcPorts'). A user-defined field is only present if the base header is found in the packet and the entire field is in bounds. Each match field may specify which values can match it, listing one or more ranges, prefixes, or exact values that are considered a match for the field. A field value must be present in order to match a specified match field. If no match values are specified for a match field, then any field value is considered to match it, and it's not required to be present. For strings specifying '*' is also equivalent to match all. For a packet to match a rule, all specified match fields must match the corresponding field values derived from the packet. Example: networkMatch: srcIpRanges: - "192.0.2.0/24" - "198.51.100.0/24" userDefinedFields: - name: "ipv4_fragment_offset" values: - "1-0x1fff" The above match condition matches packets with a source IP in 192.0.2.0/24 or 198.51.100.0/24 and a user-defined field named "ipv4_fragment_offset" with a value between 1 and 0x1fff inclusive.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher network_match = 463387764;
     * </code>
     *
     * @return The networkMatch.
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher getNetworkMatch() {
      if (networkMatchBuilder_ == null) {
        return networkMatch_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher.getDefaultInstance()
            : networkMatch_;
      } else {
        return networkMatchBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming packets are evaluated against for CLOUD_ARMOR_NETWORK security policies. If it matches, the corresponding 'action' is enforced. The match criteria for a rule consists of built-in match fields (like 'srcIpRanges') and potentially multiple user-defined match fields ('userDefinedFields'). Field values may be extracted directly from the packet or derived from it (e.g. 'srcRegionCodes'). Some fields may not be present in every packet (e.g. 'srcPorts'). A user-defined field is only present if the base header is found in the packet and the entire field is in bounds. Each match field may specify which values can match it, listing one or more ranges, prefixes, or exact values that are considered a match for the field. A field value must be present in order to match a specified match field. If no match values are specified for a match field, then any field value is considered to match it, and it's not required to be present. For strings specifying '*' is also equivalent to match all. For a packet to match a rule, all specified match fields must match the corresponding field values derived from the packet. Example: networkMatch: srcIpRanges: - "192.0.2.0/24" - "198.51.100.0/24" userDefinedFields: - name: "ipv4_fragment_offset" values: - "1-0x1fff" The above match condition matches packets with a source IP in 192.0.2.0/24 or 198.51.100.0/24 and a user-defined field named "ipv4_fragment_offset" with a value between 1 and 0x1fff inclusive.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher network_match = 463387764;
     * </code>
     */
    public Builder setNetworkMatch(
        com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher value) {
      if (networkMatchBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        networkMatch_ = value;
      } else {
        networkMatchBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming packets are evaluated against for CLOUD_ARMOR_NETWORK security policies. If it matches, the corresponding 'action' is enforced. The match criteria for a rule consists of built-in match fields (like 'srcIpRanges') and potentially multiple user-defined match fields ('userDefinedFields'). Field values may be extracted directly from the packet or derived from it (e.g. 'srcRegionCodes'). Some fields may not be present in every packet (e.g. 'srcPorts'). A user-defined field is only present if the base header is found in the packet and the entire field is in bounds. Each match field may specify which values can match it, listing one or more ranges, prefixes, or exact values that are considered a match for the field. A field value must be present in order to match a specified match field. If no match values are specified for a match field, then any field value is considered to match it, and it's not required to be present. For strings specifying '*' is also equivalent to match all. For a packet to match a rule, all specified match fields must match the corresponding field values derived from the packet. Example: networkMatch: srcIpRanges: - "192.0.2.0/24" - "198.51.100.0/24" userDefinedFields: - name: "ipv4_fragment_offset" values: - "1-0x1fff" The above match condition matches packets with a source IP in 192.0.2.0/24 or 198.51.100.0/24 and a user-defined field named "ipv4_fragment_offset" with a value between 1 and 0x1fff inclusive.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher network_match = 463387764;
     * </code>
     */
    public Builder setNetworkMatch(
        com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher.Builder builderForValue) {
      if (networkMatchBuilder_ == null) {
        networkMatch_ = builderForValue.build();
      } else {
        networkMatchBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming packets are evaluated against for CLOUD_ARMOR_NETWORK security policies. If it matches, the corresponding 'action' is enforced. The match criteria for a rule consists of built-in match fields (like 'srcIpRanges') and potentially multiple user-defined match fields ('userDefinedFields'). Field values may be extracted directly from the packet or derived from it (e.g. 'srcRegionCodes'). Some fields may not be present in every packet (e.g. 'srcPorts'). A user-defined field is only present if the base header is found in the packet and the entire field is in bounds. Each match field may specify which values can match it, listing one or more ranges, prefixes, or exact values that are considered a match for the field. A field value must be present in order to match a specified match field. If no match values are specified for a match field, then any field value is considered to match it, and it's not required to be present. For strings specifying '*' is also equivalent to match all. For a packet to match a rule, all specified match fields must match the corresponding field values derived from the packet. Example: networkMatch: srcIpRanges: - "192.0.2.0/24" - "198.51.100.0/24" userDefinedFields: - name: "ipv4_fragment_offset" values: - "1-0x1fff" The above match condition matches packets with a source IP in 192.0.2.0/24 or 198.51.100.0/24 and a user-defined field named "ipv4_fragment_offset" with a value between 1 and 0x1fff inclusive.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher network_match = 463387764;
     * </code>
     */
    public Builder mergeNetworkMatch(
        com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher value) {
      if (networkMatchBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && networkMatch_ != null
            && networkMatch_
                != com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher
                    .getDefaultInstance()) {
          getNetworkMatchBuilder().mergeFrom(value);
        } else {
          networkMatch_ = value;
        }
      } else {
        networkMatchBuilder_.mergeFrom(value);
      }
      if (networkMatch_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming packets are evaluated against for CLOUD_ARMOR_NETWORK security policies. If it matches, the corresponding 'action' is enforced. The match criteria for a rule consists of built-in match fields (like 'srcIpRanges') and potentially multiple user-defined match fields ('userDefinedFields'). Field values may be extracted directly from the packet or derived from it (e.g. 'srcRegionCodes'). Some fields may not be present in every packet (e.g. 'srcPorts'). A user-defined field is only present if the base header is found in the packet and the entire field is in bounds. Each match field may specify which values can match it, listing one or more ranges, prefixes, or exact values that are considered a match for the field. A field value must be present in order to match a specified match field. If no match values are specified for a match field, then any field value is considered to match it, and it's not required to be present. For strings specifying '*' is also equivalent to match all. For a packet to match a rule, all specified match fields must match the corresponding field values derived from the packet. Example: networkMatch: srcIpRanges: - "192.0.2.0/24" - "198.51.100.0/24" userDefinedFields: - name: "ipv4_fragment_offset" values: - "1-0x1fff" The above match condition matches packets with a source IP in 192.0.2.0/24 or 198.51.100.0/24 and a user-defined field named "ipv4_fragment_offset" with a value between 1 and 0x1fff inclusive.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher network_match = 463387764;
     * </code>
     */
    public Builder clearNetworkMatch() {
      bitField0_ = (bitField0_ & ~0x00000020);
      networkMatch_ = null;
      if (networkMatchBuilder_ != null) {
        networkMatchBuilder_.dispose();
        networkMatchBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming packets are evaluated against for CLOUD_ARMOR_NETWORK security policies. If it matches, the corresponding 'action' is enforced. The match criteria for a rule consists of built-in match fields (like 'srcIpRanges') and potentially multiple user-defined match fields ('userDefinedFields'). Field values may be extracted directly from the packet or derived from it (e.g. 'srcRegionCodes'). Some fields may not be present in every packet (e.g. 'srcPorts'). A user-defined field is only present if the base header is found in the packet and the entire field is in bounds. Each match field may specify which values can match it, listing one or more ranges, prefixes, or exact values that are considered a match for the field. A field value must be present in order to match a specified match field. If no match values are specified for a match field, then any field value is considered to match it, and it's not required to be present. For strings specifying '*' is also equivalent to match all. For a packet to match a rule, all specified match fields must match the corresponding field values derived from the packet. Example: networkMatch: srcIpRanges: - "192.0.2.0/24" - "198.51.100.0/24" userDefinedFields: - name: "ipv4_fragment_offset" values: - "1-0x1fff" The above match condition matches packets with a source IP in 192.0.2.0/24 or 198.51.100.0/24 and a user-defined field named "ipv4_fragment_offset" with a value between 1 and 0x1fff inclusive.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher network_match = 463387764;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher.Builder
        getNetworkMatchBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getNetworkMatchFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming packets are evaluated against for CLOUD_ARMOR_NETWORK security policies. If it matches, the corresponding 'action' is enforced. The match criteria for a rule consists of built-in match fields (like 'srcIpRanges') and potentially multiple user-defined match fields ('userDefinedFields'). Field values may be extracted directly from the packet or derived from it (e.g. 'srcRegionCodes'). Some fields may not be present in every packet (e.g. 'srcPorts'). A user-defined field is only present if the base header is found in the packet and the entire field is in bounds. Each match field may specify which values can match it, listing one or more ranges, prefixes, or exact values that are considered a match for the field. A field value must be present in order to match a specified match field. If no match values are specified for a match field, then any field value is considered to match it, and it's not required to be present. For strings specifying '*' is also equivalent to match all. For a packet to match a rule, all specified match fields must match the corresponding field values derived from the packet. Example: networkMatch: srcIpRanges: - "192.0.2.0/24" - "198.51.100.0/24" userDefinedFields: - name: "ipv4_fragment_offset" values: - "1-0x1fff" The above match condition matches packets with a source IP in 192.0.2.0/24 or 198.51.100.0/24 and a user-defined field named "ipv4_fragment_offset" with a value between 1 and 0x1fff inclusive.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher network_match = 463387764;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherOrBuilder
        getNetworkMatchOrBuilder() {
      if (networkMatchBuilder_ != null) {
        return networkMatchBuilder_.getMessageOrBuilder();
      } else {
        return networkMatch_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher.getDefaultInstance()
            : networkMatch_;
      }
    }

    /**
     *
     *
     * <pre>
     * A match condition that incoming packets are evaluated against for CLOUD_ARMOR_NETWORK security policies. If it matches, the corresponding 'action' is enforced. The match criteria for a rule consists of built-in match fields (like 'srcIpRanges') and potentially multiple user-defined match fields ('userDefinedFields'). Field values may be extracted directly from the packet or derived from it (e.g. 'srcRegionCodes'). Some fields may not be present in every packet (e.g. 'srcPorts'). A user-defined field is only present if the base header is found in the packet and the entire field is in bounds. Each match field may specify which values can match it, listing one or more ranges, prefixes, or exact values that are considered a match for the field. A field value must be present in order to match a specified match field. If no match values are specified for a match field, then any field value is considered to match it, and it's not required to be present. For strings specifying '*' is also equivalent to match all. For a packet to match a rule, all specified match fields must match the corresponding field values derived from the packet. Example: networkMatch: srcIpRanges: - "192.0.2.0/24" - "198.51.100.0/24" userDefinedFields: - name: "ipv4_fragment_offset" values: - "1-0x1fff" The above match condition matches packets with a source IP in 192.0.2.0/24 or 198.51.100.0/24 and a user-defined field named "ipv4_fragment_offset" with a value between 1 and 0x1fff inclusive.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher network_match = 463387764;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher,
            com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherOrBuilder>
        getNetworkMatchFieldBuilder() {
      if (networkMatchBuilder_ == null) {
        networkMatchBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher,
                com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcher.Builder,
                com.google.cloud.compute.v1.SecurityPolicyRuleNetworkMatcherOrBuilder>(
                getNetworkMatch(), getParentForChildren(), isClean());
        networkMatch_ = null;
      }
      return networkMatchBuilder_;
    }

    private com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig
        preconfiguredWafConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig,
            com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfigOrBuilder>
        preconfiguredWafConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Preconfigured WAF configuration to be applied for the rule. If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig preconfigured_waf_config = 117805027;
     * </code>
     *
     * @return Whether the preconfiguredWafConfig field is set.
     */
    public boolean hasPreconfiguredWafConfig() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Preconfigured WAF configuration to be applied for the rule. If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig preconfigured_waf_config = 117805027;
     * </code>
     *
     * @return The preconfiguredWafConfig.
     */
    public com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig
        getPreconfiguredWafConfig() {
      if (preconfiguredWafConfigBuilder_ == null) {
        return preconfiguredWafConfig_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig
                .getDefaultInstance()
            : preconfiguredWafConfig_;
      } else {
        return preconfiguredWafConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Preconfigured WAF configuration to be applied for the rule. If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig preconfigured_waf_config = 117805027;
     * </code>
     */
    public Builder setPreconfiguredWafConfig(
        com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig value) {
      if (preconfiguredWafConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        preconfiguredWafConfig_ = value;
      } else {
        preconfiguredWafConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Preconfigured WAF configuration to be applied for the rule. If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig preconfigured_waf_config = 117805027;
     * </code>
     */
    public Builder setPreconfiguredWafConfig(
        com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig.Builder
            builderForValue) {
      if (preconfiguredWafConfigBuilder_ == null) {
        preconfiguredWafConfig_ = builderForValue.build();
      } else {
        preconfiguredWafConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Preconfigured WAF configuration to be applied for the rule. If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig preconfigured_waf_config = 117805027;
     * </code>
     */
    public Builder mergePreconfiguredWafConfig(
        com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig value) {
      if (preconfiguredWafConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && preconfiguredWafConfig_ != null
            && preconfiguredWafConfig_
                != com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig
                    .getDefaultInstance()) {
          getPreconfiguredWafConfigBuilder().mergeFrom(value);
        } else {
          preconfiguredWafConfig_ = value;
        }
      } else {
        preconfiguredWafConfigBuilder_.mergeFrom(value);
      }
      if (preconfiguredWafConfig_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Preconfigured WAF configuration to be applied for the rule. If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig preconfigured_waf_config = 117805027;
     * </code>
     */
    public Builder clearPreconfiguredWafConfig() {
      bitField0_ = (bitField0_ & ~0x00000040);
      preconfiguredWafConfig_ = null;
      if (preconfiguredWafConfigBuilder_ != null) {
        preconfiguredWafConfigBuilder_.dispose();
        preconfiguredWafConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Preconfigured WAF configuration to be applied for the rule. If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig preconfigured_waf_config = 117805027;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig.Builder
        getPreconfiguredWafConfigBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getPreconfiguredWafConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Preconfigured WAF configuration to be applied for the rule. If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig preconfigured_waf_config = 117805027;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfigOrBuilder
        getPreconfiguredWafConfigOrBuilder() {
      if (preconfiguredWafConfigBuilder_ != null) {
        return preconfiguredWafConfigBuilder_.getMessageOrBuilder();
      } else {
        return preconfiguredWafConfig_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig
                .getDefaultInstance()
            : preconfiguredWafConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Preconfigured WAF configuration to be applied for the rule. If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig preconfigured_waf_config = 117805027;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig,
            com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfigOrBuilder>
        getPreconfiguredWafConfigFieldBuilder() {
      if (preconfiguredWafConfigBuilder_ == null) {
        preconfiguredWafConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig,
                com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfig.Builder,
                com.google.cloud.compute.v1.SecurityPolicyRulePreconfiguredWafConfigOrBuilder>(
                getPreconfiguredWafConfig(), getParentForChildren(), isClean());
        preconfiguredWafConfig_ = null;
      }
      return preconfiguredWafConfigBuilder_;
    }

    private boolean preview_;

    /**
     *
     *
     * <pre>
     * If set to true, the specified action is not enforced.
     * </pre>
     *
     * <code>optional bool preview = 218686408;</code>
     *
     * @return Whether the preview field is set.
     */
    @java.lang.Override
    public boolean hasPreview() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * If set to true, the specified action is not enforced.
     * </pre>
     *
     * <code>optional bool preview = 218686408;</code>
     *
     * @return The preview.
     */
    @java.lang.Override
    public boolean getPreview() {
      return preview_;
    }

    /**
     *
     *
     * <pre>
     * If set to true, the specified action is not enforced.
     * </pre>
     *
     * <code>optional bool preview = 218686408;</code>
     *
     * @param value The preview to set.
     * @return This builder for chaining.
     */
    public Builder setPreview(boolean value) {

      preview_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If set to true, the specified action is not enforced.
     * </pre>
     *
     * <code>optional bool preview = 218686408;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPreview() {
      bitField0_ = (bitField0_ & ~0x00000080);
      preview_ = false;
      onChanged();
      return this;
    }

    private int priority_;

    /**
     *
     *
     * <pre>
     * An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
     * </pre>
     *
     * <code>optional int32 priority = 445151652;</code>
     *
     * @return Whether the priority field is set.
     */
    @java.lang.Override
    public boolean hasPriority() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
     * </pre>
     *
     * <code>optional int32 priority = 445151652;</code>
     *
     * @return The priority.
     */
    @java.lang.Override
    public int getPriority() {
      return priority_;
    }

    /**
     *
     *
     * <pre>
     * An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
     * </pre>
     *
     * <code>optional int32 priority = 445151652;</code>
     *
     * @param value The priority to set.
     * @return This builder for chaining.
     */
    public Builder setPriority(int value) {

      priority_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
     * </pre>
     *
     * <code>optional int32 priority = 445151652;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPriority() {
      bitField0_ = (bitField0_ & ~0x00000100);
      priority_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions rateLimitOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions,
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsOrBuilder>
        rateLimitOptionsBuilder_;

    /**
     *
     *
     * <pre>
     * Must be specified if the action is "rate_based_ban" or "throttle" or "fairshare". Cannot be specified for any other actions.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions rate_limit_options = 67544315;
     * </code>
     *
     * @return Whether the rateLimitOptions field is set.
     */
    public boolean hasRateLimitOptions() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Must be specified if the action is "rate_based_ban" or "throttle" or "fairshare". Cannot be specified for any other actions.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions rate_limit_options = 67544315;
     * </code>
     *
     * @return The rateLimitOptions.
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions getRateLimitOptions() {
      if (rateLimitOptionsBuilder_ == null) {
        return rateLimitOptions_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions.getDefaultInstance()
            : rateLimitOptions_;
      } else {
        return rateLimitOptionsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Must be specified if the action is "rate_based_ban" or "throttle" or "fairshare". Cannot be specified for any other actions.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions rate_limit_options = 67544315;
     * </code>
     */
    public Builder setRateLimitOptions(
        com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions value) {
      if (rateLimitOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rateLimitOptions_ = value;
      } else {
        rateLimitOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Must be specified if the action is "rate_based_ban" or "throttle" or "fairshare". Cannot be specified for any other actions.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions rate_limit_options = 67544315;
     * </code>
     */
    public Builder setRateLimitOptions(
        com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions.Builder builderForValue) {
      if (rateLimitOptionsBuilder_ == null) {
        rateLimitOptions_ = builderForValue.build();
      } else {
        rateLimitOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Must be specified if the action is "rate_based_ban" or "throttle" or "fairshare". Cannot be specified for any other actions.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions rate_limit_options = 67544315;
     * </code>
     */
    public Builder mergeRateLimitOptions(
        com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions value) {
      if (rateLimitOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && rateLimitOptions_ != null
            && rateLimitOptions_
                != com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions
                    .getDefaultInstance()) {
          getRateLimitOptionsBuilder().mergeFrom(value);
        } else {
          rateLimitOptions_ = value;
        }
      } else {
        rateLimitOptionsBuilder_.mergeFrom(value);
      }
      if (rateLimitOptions_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Must be specified if the action is "rate_based_ban" or "throttle" or "fairshare". Cannot be specified for any other actions.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions rate_limit_options = 67544315;
     * </code>
     */
    public Builder clearRateLimitOptions() {
      bitField0_ = (bitField0_ & ~0x00000200);
      rateLimitOptions_ = null;
      if (rateLimitOptionsBuilder_ != null) {
        rateLimitOptionsBuilder_.dispose();
        rateLimitOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Must be specified if the action is "rate_based_ban" or "throttle" or "fairshare". Cannot be specified for any other actions.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions rate_limit_options = 67544315;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions.Builder
        getRateLimitOptionsBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getRateLimitOptionsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Must be specified if the action is "rate_based_ban" or "throttle" or "fairshare". Cannot be specified for any other actions.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions rate_limit_options = 67544315;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsOrBuilder
        getRateLimitOptionsOrBuilder() {
      if (rateLimitOptionsBuilder_ != null) {
        return rateLimitOptionsBuilder_.getMessageOrBuilder();
      } else {
        return rateLimitOptions_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions.getDefaultInstance()
            : rateLimitOptions_;
      }
    }

    /**
     *
     *
     * <pre>
     * Must be specified if the action is "rate_based_ban" or "throttle" or "fairshare". Cannot be specified for any other actions.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions rate_limit_options = 67544315;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions,
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsOrBuilder>
        getRateLimitOptionsFieldBuilder() {
      if (rateLimitOptionsBuilder_ == null) {
        rateLimitOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions,
                com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptions.Builder,
                com.google.cloud.compute.v1.SecurityPolicyRuleRateLimitOptionsOrBuilder>(
                getRateLimitOptions(), getParentForChildren(), isClean());
        rateLimitOptions_ = null;
      }
      return rateLimitOptionsBuilder_;
    }

    private com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions redirectOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions,
            com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptionsOrBuilder>
        redirectOptionsBuilder_;

    /**
     *
     *
     * <pre>
     * Parameters defining the redirect action. Cannot be specified for any other actions. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions redirect_options = 163285307;
     * </code>
     *
     * @return Whether the redirectOptions field is set.
     */
    public boolean hasRedirectOptions() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Parameters defining the redirect action. Cannot be specified for any other actions. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions redirect_options = 163285307;
     * </code>
     *
     * @return The redirectOptions.
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions getRedirectOptions() {
      if (redirectOptionsBuilder_ == null) {
        return redirectOptions_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions.getDefaultInstance()
            : redirectOptions_;
      } else {
        return redirectOptionsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Parameters defining the redirect action. Cannot be specified for any other actions. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions redirect_options = 163285307;
     * </code>
     */
    public Builder setRedirectOptions(
        com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions value) {
      if (redirectOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        redirectOptions_ = value;
      } else {
        redirectOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters defining the redirect action. Cannot be specified for any other actions. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions redirect_options = 163285307;
     * </code>
     */
    public Builder setRedirectOptions(
        com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions.Builder builderForValue) {
      if (redirectOptionsBuilder_ == null) {
        redirectOptions_ = builderForValue.build();
      } else {
        redirectOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters defining the redirect action. Cannot be specified for any other actions. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions redirect_options = 163285307;
     * </code>
     */
    public Builder mergeRedirectOptions(
        com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions value) {
      if (redirectOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && redirectOptions_ != null
            && redirectOptions_
                != com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions
                    .getDefaultInstance()) {
          getRedirectOptionsBuilder().mergeFrom(value);
        } else {
          redirectOptions_ = value;
        }
      } else {
        redirectOptionsBuilder_.mergeFrom(value);
      }
      if (redirectOptions_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters defining the redirect action. Cannot be specified for any other actions. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions redirect_options = 163285307;
     * </code>
     */
    public Builder clearRedirectOptions() {
      bitField0_ = (bitField0_ & ~0x00000400);
      redirectOptions_ = null;
      if (redirectOptionsBuilder_ != null) {
        redirectOptionsBuilder_.dispose();
        redirectOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters defining the redirect action. Cannot be specified for any other actions. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions redirect_options = 163285307;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions.Builder
        getRedirectOptionsBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getRedirectOptionsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Parameters defining the redirect action. Cannot be specified for any other actions. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions redirect_options = 163285307;
     * </code>
     */
    public com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptionsOrBuilder
        getRedirectOptionsOrBuilder() {
      if (redirectOptionsBuilder_ != null) {
        return redirectOptionsBuilder_.getMessageOrBuilder();
      } else {
        return redirectOptions_ == null
            ? com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions.getDefaultInstance()
            : redirectOptions_;
      }
    }

    /**
     *
     *
     * <pre>
     * Parameters defining the redirect action. Cannot be specified for any other actions. This field is only supported in Global Security Policies of type CLOUD_ARMOR.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions redirect_options = 163285307;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions,
            com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions.Builder,
            com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptionsOrBuilder>
        getRedirectOptionsFieldBuilder() {
      if (redirectOptionsBuilder_ == null) {
        redirectOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions,
                com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptions.Builder,
                com.google.cloud.compute.v1.SecurityPolicyRuleRedirectOptionsOrBuilder>(
                getRedirectOptions(), getParentForChildren(), isClean());
        redirectOptions_ = null;
      }
      return redirectOptionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.SecurityPolicyRule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.SecurityPolicyRule)
  private static final com.google.cloud.compute.v1.SecurityPolicyRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.SecurityPolicyRule();
  }

  public static com.google.cloud.compute.v1.SecurityPolicyRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SecurityPolicyRule> PARSER =
      new com.google.protobuf.AbstractParser<SecurityPolicyRule>() {
        @java.lang.Override
        public SecurityPolicyRule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SecurityPolicyRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SecurityPolicyRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.SecurityPolicyRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
