/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Next free: 7
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.PacketIntervals}
 */
public final class PacketIntervals extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.PacketIntervals)
    PacketIntervalsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use PacketIntervals.newBuilder() to construct.
  private PacketIntervals(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PacketIntervals() {
    duration_ = "";
    type_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PacketIntervals();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_PacketIntervals_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_PacketIntervals_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.PacketIntervals.class,
            com.google.cloud.compute.v1.PacketIntervals.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * From how long ago in the past these intervals were observed.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.PacketIntervals.Duration}
   */
  public enum Duration implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_DURATION = 0;</code>
     */
    UNDEFINED_DURATION(0),
    /** <code>DURATION_UNSPECIFIED = 529071340;</code> */
    DURATION_UNSPECIFIED(529071340),
    /** <code>HOUR = 2223588;</code> */
    HOUR(2223588),
    /**
     *
     *
     * <pre>
     * From BfdSession object creation time.
     * </pre>
     *
     * <code>MAX = 76100;</code>
     */
    MAX(76100),
    /** <code>MINUTE = 126786068;</code> */
    MINUTE(126786068),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_DURATION = 0;</code>
     */
    public static final int UNDEFINED_DURATION_VALUE = 0;

    /** <code>DURATION_UNSPECIFIED = 529071340;</code> */
    public static final int DURATION_UNSPECIFIED_VALUE = 529071340;

    /** <code>HOUR = 2223588;</code> */
    public static final int HOUR_VALUE = 2223588;

    /**
     *
     *
     * <pre>
     * From BfdSession object creation time.
     * </pre>
     *
     * <code>MAX = 76100;</code>
     */
    public static final int MAX_VALUE = 76100;

    /** <code>MINUTE = 126786068;</code> */
    public static final int MINUTE_VALUE = 126786068;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Duration valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Duration forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_DURATION;
        case 529071340:
          return DURATION_UNSPECIFIED;
        case 2223588:
          return HOUR;
        case 76100:
          return MAX;
        case 126786068:
          return MINUTE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Duration> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Duration> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Duration>() {
          public Duration findValueByNumber(int number) {
            return Duration.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.PacketIntervals.getDescriptor().getEnumTypes().get(0);
    }

    private static final Duration[] VALUES = values();

    public static Duration valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Duration(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.PacketIntervals.Duration)
  }

  /**
   *
   *
   * <pre>
   * The type of packets for which inter-packet intervals were computed.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.PacketIntervals.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    UNDEFINED_TYPE(0),
    /**
     *
     *
     * <pre>
     * Only applies to Echo packets. This shows the intervals between sending and receiving the same packet.
     * </pre>
     *
     * <code>LOOPBACK = 356174219;</code>
     */
    LOOPBACK(356174219),
    /**
     *
     *
     * <pre>
     * Intervals between received packets.
     * </pre>
     *
     * <code>RECEIVE = 189660867;</code>
     */
    RECEIVE(189660867),
    /**
     *
     *
     * <pre>
     * Intervals between transmitted packets.
     * </pre>
     *
     * <code>TRANSMIT = 452903600;</code>
     */
    TRANSMIT(452903600),
    /** <code>TYPE_UNSPECIFIED = 437714322;</code> */
    TYPE_UNSPECIFIED(437714322),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    public static final int UNDEFINED_TYPE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Only applies to Echo packets. This shows the intervals between sending and receiving the same packet.
     * </pre>
     *
     * <code>LOOPBACK = 356174219;</code>
     */
    public static final int LOOPBACK_VALUE = 356174219;

    /**
     *
     *
     * <pre>
     * Intervals between received packets.
     * </pre>
     *
     * <code>RECEIVE = 189660867;</code>
     */
    public static final int RECEIVE_VALUE = 189660867;

    /**
     *
     *
     * <pre>
     * Intervals between transmitted packets.
     * </pre>
     *
     * <code>TRANSMIT = 452903600;</code>
     */
    public static final int TRANSMIT_VALUE = 452903600;

    /** <code>TYPE_UNSPECIFIED = 437714322;</code> */
    public static final int TYPE_UNSPECIFIED_VALUE = 437714322;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_TYPE;
        case 356174219:
          return LOOPBACK;
        case 189660867:
          return RECEIVE;
        case 452903600:
          return TRANSMIT;
        case 437714322:
          return TYPE_UNSPECIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.PacketIntervals.getDescriptor().getEnumTypes().get(1);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.PacketIntervals.Type)
  }

  private int bitField0_;
  public static final int AVG_MS_FIELD_NUMBER = 204811827;
  private long avgMs_ = 0L;

  /**
   *
   *
   * <pre>
   * Average observed inter-packet interval in milliseconds.
   * </pre>
   *
   * <code>optional int64 avg_ms = 204811827;</code>
   *
   * @return Whether the avgMs field is set.
   */
  @java.lang.Override
  public boolean hasAvgMs() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Average observed inter-packet interval in milliseconds.
   * </pre>
   *
   * <code>optional int64 avg_ms = 204811827;</code>
   *
   * @return The avgMs.
   */
  @java.lang.Override
  public long getAvgMs() {
    return avgMs_;
  }

  public static final int DURATION_FIELD_NUMBER = 155471252;

  @SuppressWarnings("serial")
  private volatile java.lang.Object duration_ = "";

  /**
   *
   *
   * <pre>
   * From how long ago in the past these intervals were observed.
   * Check the Duration enum for the list of possible values.
   * </pre>
   *
   * <code>optional string duration = 155471252;</code>
   *
   * @return Whether the duration field is set.
   */
  @java.lang.Override
  public boolean hasDuration() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * From how long ago in the past these intervals were observed.
   * Check the Duration enum for the list of possible values.
   * </pre>
   *
   * <code>optional string duration = 155471252;</code>
   *
   * @return The duration.
   */
  @java.lang.Override
  public java.lang.String getDuration() {
    java.lang.Object ref = duration_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      duration_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * From how long ago in the past these intervals were observed.
   * Check the Duration enum for the list of possible values.
   * </pre>
   *
   * <code>optional string duration = 155471252;</code>
   *
   * @return The bytes for duration.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDurationBytes() {
    java.lang.Object ref = duration_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      duration_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_MS_FIELD_NUMBER = 529474145;
  private long maxMs_ = 0L;

  /**
   *
   *
   * <pre>
   * Maximum observed inter-packet interval in milliseconds.
   * </pre>
   *
   * <code>optional int64 max_ms = 529474145;</code>
   *
   * @return Whether the maxMs field is set.
   */
  @java.lang.Override
  public boolean hasMaxMs() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Maximum observed inter-packet interval in milliseconds.
   * </pre>
   *
   * <code>optional int64 max_ms = 529474145;</code>
   *
   * @return The maxMs.
   */
  @java.lang.Override
  public long getMaxMs() {
    return maxMs_;
  }

  public static final int MIN_MS_FIELD_NUMBER = 536564403;
  private long minMs_ = 0L;

  /**
   *
   *
   * <pre>
   * Minimum observed inter-packet interval in milliseconds.
   * </pre>
   *
   * <code>optional int64 min_ms = 536564403;</code>
   *
   * @return Whether the minMs field is set.
   */
  @java.lang.Override
  public boolean hasMinMs() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Minimum observed inter-packet interval in milliseconds.
   * </pre>
   *
   * <code>optional int64 min_ms = 536564403;</code>
   *
   * @return The minMs.
   */
  @java.lang.Override
  public long getMinMs() {
    return minMs_;
  }

  public static final int NUM_INTERVALS_FIELD_NUMBER = 186329813;
  private long numIntervals_ = 0L;

  /**
   *
   *
   * <pre>
   * Number of inter-packet intervals from which these statistics were derived.
   * </pre>
   *
   * <code>optional int64 num_intervals = 186329813;</code>
   *
   * @return Whether the numIntervals field is set.
   */
  @java.lang.Override
  public boolean hasNumIntervals() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Number of inter-packet intervals from which these statistics were derived.
   * </pre>
   *
   * <code>optional int64 num_intervals = 186329813;</code>
   *
   * @return The numIntervals.
   */
  @java.lang.Override
  public long getNumIntervals() {
    return numIntervals_;
  }

  public static final int TYPE_FIELD_NUMBER = 3575610;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";

  /**
   *
   *
   * <pre>
   * The type of packets for which inter-packet intervals were computed.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return Whether the type field is set.
   */
  @java.lang.Override
  public boolean hasType() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * The type of packets for which inter-packet intervals were computed.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The type of packets for which inter-packet intervals were computed.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3575610, type_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 155471252, duration_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt64(186329813, numIntervals_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt64(204811827, avgMs_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt64(529474145, maxMs_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt64(536564403, minMs_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3575610, type_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(155471252, duration_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(186329813, numIntervals_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(204811827, avgMs_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(529474145, maxMs_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(536564403, minMs_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.PacketIntervals)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.PacketIntervals other =
        (com.google.cloud.compute.v1.PacketIntervals) obj;

    if (hasAvgMs() != other.hasAvgMs()) return false;
    if (hasAvgMs()) {
      if (getAvgMs() != other.getAvgMs()) return false;
    }
    if (hasDuration() != other.hasDuration()) return false;
    if (hasDuration()) {
      if (!getDuration().equals(other.getDuration())) return false;
    }
    if (hasMaxMs() != other.hasMaxMs()) return false;
    if (hasMaxMs()) {
      if (getMaxMs() != other.getMaxMs()) return false;
    }
    if (hasMinMs() != other.hasMinMs()) return false;
    if (hasMinMs()) {
      if (getMinMs() != other.getMinMs()) return false;
    }
    if (hasNumIntervals() != other.hasNumIntervals()) return false;
    if (hasNumIntervals()) {
      if (getNumIntervals() != other.getNumIntervals()) return false;
    }
    if (hasType() != other.hasType()) return false;
    if (hasType()) {
      if (!getType().equals(other.getType())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAvgMs()) {
      hash = (37 * hash) + AVG_MS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAvgMs());
    }
    if (hasDuration()) {
      hash = (37 * hash) + DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getDuration().hashCode();
    }
    if (hasMaxMs()) {
      hash = (37 * hash) + MAX_MS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxMs());
    }
    if (hasMinMs()) {
      hash = (37 * hash) + MIN_MS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMinMs());
    }
    if (hasNumIntervals()) {
      hash = (37 * hash) + NUM_INTERVALS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getNumIntervals());
    }
    if (hasType()) {
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.PacketIntervals parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PacketIntervals parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PacketIntervals parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PacketIntervals parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PacketIntervals parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PacketIntervals parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PacketIntervals parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PacketIntervals parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PacketIntervals parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PacketIntervals parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PacketIntervals parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PacketIntervals parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.PacketIntervals prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Next free: 7
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.PacketIntervals}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.PacketIntervals)
      com.google.cloud.compute.v1.PacketIntervalsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PacketIntervals_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PacketIntervals_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.PacketIntervals.class,
              com.google.cloud.compute.v1.PacketIntervals.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.PacketIntervals.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      avgMs_ = 0L;
      duration_ = "";
      maxMs_ = 0L;
      minMs_ = 0L;
      numIntervals_ = 0L;
      type_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PacketIntervals_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PacketIntervals getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.PacketIntervals.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PacketIntervals build() {
      com.google.cloud.compute.v1.PacketIntervals result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PacketIntervals buildPartial() {
      com.google.cloud.compute.v1.PacketIntervals result =
          new com.google.cloud.compute.v1.PacketIntervals(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.PacketIntervals result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.avgMs_ = avgMs_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.duration_ = duration_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.maxMs_ = maxMs_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.minMs_ = minMs_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.numIntervals_ = numIntervals_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.type_ = type_;
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.PacketIntervals) {
        return mergeFrom((com.google.cloud.compute.v1.PacketIntervals) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.PacketIntervals other) {
      if (other == com.google.cloud.compute.v1.PacketIntervals.getDefaultInstance()) return this;
      if (other.hasAvgMs()) {
        setAvgMs(other.getAvgMs());
      }
      if (other.hasDuration()) {
        duration_ = other.duration_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasMaxMs()) {
        setMaxMs(other.getMaxMs());
      }
      if (other.hasMinMs()) {
        setMinMs(other.getMinMs());
      }
      if (other.hasNumIntervals()) {
        setNumIntervals(other.getNumIntervals());
      }
      if (other.hasType()) {
        type_ = other.type_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 28604882:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 28604882
            case 1243770018:
              {
                duration_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 1243770018
            case 1490638504:
              {
                numIntervals_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 1490638504
            case 1638494616:
              {
                avgMs_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 1638494616
            case -59174136:
              {
                maxMs_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case -59174136
            case -2452072:
              {
                minMs_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case -2452072
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private long avgMs_;

    /**
     *
     *
     * <pre>
     * Average observed inter-packet interval in milliseconds.
     * </pre>
     *
     * <code>optional int64 avg_ms = 204811827;</code>
     *
     * @return Whether the avgMs field is set.
     */
    @java.lang.Override
    public boolean hasAvgMs() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Average observed inter-packet interval in milliseconds.
     * </pre>
     *
     * <code>optional int64 avg_ms = 204811827;</code>
     *
     * @return The avgMs.
     */
    @java.lang.Override
    public long getAvgMs() {
      return avgMs_;
    }

    /**
     *
     *
     * <pre>
     * Average observed inter-packet interval in milliseconds.
     * </pre>
     *
     * <code>optional int64 avg_ms = 204811827;</code>
     *
     * @param value The avgMs to set.
     * @return This builder for chaining.
     */
    public Builder setAvgMs(long value) {

      avgMs_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Average observed inter-packet interval in milliseconds.
     * </pre>
     *
     * <code>optional int64 avg_ms = 204811827;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvgMs() {
      bitField0_ = (bitField0_ & ~0x00000001);
      avgMs_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object duration_ = "";

    /**
     *
     *
     * <pre>
     * From how long ago in the past these intervals were observed.
     * Check the Duration enum for the list of possible values.
     * </pre>
     *
     * <code>optional string duration = 155471252;</code>
     *
     * @return Whether the duration field is set.
     */
    public boolean hasDuration() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * From how long ago in the past these intervals were observed.
     * Check the Duration enum for the list of possible values.
     * </pre>
     *
     * <code>optional string duration = 155471252;</code>
     *
     * @return The duration.
     */
    public java.lang.String getDuration() {
      java.lang.Object ref = duration_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        duration_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * From how long ago in the past these intervals were observed.
     * Check the Duration enum for the list of possible values.
     * </pre>
     *
     * <code>optional string duration = 155471252;</code>
     *
     * @return The bytes for duration.
     */
    public com.google.protobuf.ByteString getDurationBytes() {
      java.lang.Object ref = duration_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        duration_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * From how long ago in the past these intervals were observed.
     * Check the Duration enum for the list of possible values.
     * </pre>
     *
     * <code>optional string duration = 155471252;</code>
     *
     * @param value The duration to set.
     * @return This builder for chaining.
     */
    public Builder setDuration(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      duration_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * From how long ago in the past these intervals were observed.
     * Check the Duration enum for the list of possible values.
     * </pre>
     *
     * <code>optional string duration = 155471252;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDuration() {
      duration_ = getDefaultInstance().getDuration();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * From how long ago in the past these intervals were observed.
     * Check the Duration enum for the list of possible values.
     * </pre>
     *
     * <code>optional string duration = 155471252;</code>
     *
     * @param value The bytes for duration to set.
     * @return This builder for chaining.
     */
    public Builder setDurationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      duration_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private long maxMs_;

    /**
     *
     *
     * <pre>
     * Maximum observed inter-packet interval in milliseconds.
     * </pre>
     *
     * <code>optional int64 max_ms = 529474145;</code>
     *
     * @return Whether the maxMs field is set.
     */
    @java.lang.Override
    public boolean hasMaxMs() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Maximum observed inter-packet interval in milliseconds.
     * </pre>
     *
     * <code>optional int64 max_ms = 529474145;</code>
     *
     * @return The maxMs.
     */
    @java.lang.Override
    public long getMaxMs() {
      return maxMs_;
    }

    /**
     *
     *
     * <pre>
     * Maximum observed inter-packet interval in milliseconds.
     * </pre>
     *
     * <code>optional int64 max_ms = 529474145;</code>
     *
     * @param value The maxMs to set.
     * @return This builder for chaining.
     */
    public Builder setMaxMs(long value) {

      maxMs_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Maximum observed inter-packet interval in milliseconds.
     * </pre>
     *
     * <code>optional int64 max_ms = 529474145;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxMs() {
      bitField0_ = (bitField0_ & ~0x00000004);
      maxMs_ = 0L;
      onChanged();
      return this;
    }

    private long minMs_;

    /**
     *
     *
     * <pre>
     * Minimum observed inter-packet interval in milliseconds.
     * </pre>
     *
     * <code>optional int64 min_ms = 536564403;</code>
     *
     * @return Whether the minMs field is set.
     */
    @java.lang.Override
    public boolean hasMinMs() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Minimum observed inter-packet interval in milliseconds.
     * </pre>
     *
     * <code>optional int64 min_ms = 536564403;</code>
     *
     * @return The minMs.
     */
    @java.lang.Override
    public long getMinMs() {
      return minMs_;
    }

    /**
     *
     *
     * <pre>
     * Minimum observed inter-packet interval in milliseconds.
     * </pre>
     *
     * <code>optional int64 min_ms = 536564403;</code>
     *
     * @param value The minMs to set.
     * @return This builder for chaining.
     */
    public Builder setMinMs(long value) {

      minMs_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Minimum observed inter-packet interval in milliseconds.
     * </pre>
     *
     * <code>optional int64 min_ms = 536564403;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinMs() {
      bitField0_ = (bitField0_ & ~0x00000008);
      minMs_ = 0L;
      onChanged();
      return this;
    }

    private long numIntervals_;

    /**
     *
     *
     * <pre>
     * Number of inter-packet intervals from which these statistics were derived.
     * </pre>
     *
     * <code>optional int64 num_intervals = 186329813;</code>
     *
     * @return Whether the numIntervals field is set.
     */
    @java.lang.Override
    public boolean hasNumIntervals() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Number of inter-packet intervals from which these statistics were derived.
     * </pre>
     *
     * <code>optional int64 num_intervals = 186329813;</code>
     *
     * @return The numIntervals.
     */
    @java.lang.Override
    public long getNumIntervals() {
      return numIntervals_;
    }

    /**
     *
     *
     * <pre>
     * Number of inter-packet intervals from which these statistics were derived.
     * </pre>
     *
     * <code>optional int64 num_intervals = 186329813;</code>
     *
     * @param value The numIntervals to set.
     * @return This builder for chaining.
     */
    public Builder setNumIntervals(long value) {

      numIntervals_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Number of inter-packet intervals from which these statistics were derived.
     * </pre>
     *
     * <code>optional int64 num_intervals = 186329813;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNumIntervals() {
      bitField0_ = (bitField0_ & ~0x00000010);
      numIntervals_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";

    /**
     *
     *
     * <pre>
     * The type of packets for which inter-packet intervals were computed.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return Whether the type field is set.
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * The type of packets for which inter-packet intervals were computed.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The type of packets for which inter-packet intervals were computed.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The type of packets for which inter-packet intervals were computed.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of packets for which inter-packet intervals were computed.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of packets for which inter-packet intervals were computed.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.PacketIntervals)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.PacketIntervals)
  private static final com.google.cloud.compute.v1.PacketIntervals DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.PacketIntervals();
  }

  public static com.google.cloud.compute.v1.PacketIntervals getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PacketIntervals> PARSER =
      new com.google.protobuf.AbstractParser<PacketIntervals>() {
        @java.lang.Override
        public PacketIntervals parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PacketIntervals> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PacketIntervals> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.PacketIntervals getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
