/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a collection of network endpoints. A network endpoint group (NEG) defines how a set of endpoints should be reached, whether they are reachable, and where they are located. For more information about using NEGs for different use cases, see Network endpoint groups overview.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.NetworkEndpointGroup}
 */
public final class NetworkEndpointGroup extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.NetworkEndpointGroup)
    NetworkEndpointGroupOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use NetworkEndpointGroup.newBuilder() to construct.
  private NetworkEndpointGroup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NetworkEndpointGroup() {
    creationTimestamp_ = "";
    description_ = "";
    kind_ = "";
    name_ = "";
    network_ = "";
    networkEndpointType_ = "";
    pscTargetService_ = "";
    region_ = "";
    selfLink_ = "";
    subnetwork_ = "";
    zone_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NetworkEndpointGroup();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_NetworkEndpointGroup_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 112032548:
        return internalGetAnnotations();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_NetworkEndpointGroup_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.NetworkEndpointGroup.class,
            com.google.cloud.compute.v1.NetworkEndpointGroup.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type of network endpoints in this network endpoint group. Can be one of GCE_VM_IP, GCE_VM_IP_PORT, NON_GCP_PRIVATE_IP_PORT, INTERNET_FQDN_PORT, INTERNET_IP_PORT, SERVERLESS, PRIVATE_SERVICE_CONNECT, GCE_VM_IP_PORTMAP.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.NetworkEndpointGroup.NetworkEndpointType}
   */
  public enum NetworkEndpointType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_NETWORK_ENDPOINT_TYPE = 0;</code>
     */
    UNDEFINED_NETWORK_ENDPOINT_TYPE(0),
    /**
     *
     *
     * <pre>
     * The network endpoint is represented by an IP address.
     * </pre>
     *
     * <code>GCE_VM_IP = 401880793;</code>
     */
    GCE_VM_IP(401880793),
    /**
     *
     *
     * <pre>
     * The network endpoint is represented by IP address and port pair.
     * </pre>
     *
     * <code>GCE_VM_IP_PORT = 501838375;</code>
     */
    GCE_VM_IP_PORT(501838375),
    /**
     *
     *
     * <pre>
     * The network endpoint is represented by an IP, Port and Client Destination Port.
     * </pre>
     *
     * <code>GCE_VM_IP_PORTMAP = 22819253;</code>
     */
    GCE_VM_IP_PORTMAP(22819253),
    /**
     *
     *
     * <pre>
     * The network endpoint is represented by fully qualified domain name and port.
     * </pre>
     *
     * <code>INTERNET_FQDN_PORT = 404154477;</code>
     */
    INTERNET_FQDN_PORT(404154477),
    /**
     *
     *
     * <pre>
     * The network endpoint is represented by an internet IP address and port.
     * </pre>
     *
     * <code>INTERNET_IP_PORT = 477719963;</code>
     */
    INTERNET_IP_PORT(477719963),
    /**
     *
     *
     * <pre>
     * The network endpoint is represented by an IP address and port. The endpoint belongs to a VM or pod running in a customer's on-premises.
     * </pre>
     *
     * <code>NON_GCP_PRIVATE_IP_PORT = 336447968;</code>
     */
    NON_GCP_PRIVATE_IP_PORT(336447968),
    /**
     *
     *
     * <pre>
     * The network endpoint is either public Google APIs or services exposed by other GCP Project with a Service Attachment. The connection is set up by private service connect
     * </pre>
     *
     * <code>PRIVATE_SERVICE_CONNECT = 48134724;</code>
     */
    PRIVATE_SERVICE_CONNECT(48134724),
    /**
     *
     *
     * <pre>
     * The network endpoint is handled by specified serverless infrastructure.
     * </pre>
     *
     * <code>SERVERLESS = 270492508;</code>
     */
    SERVERLESS(270492508),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_NETWORK_ENDPOINT_TYPE = 0;</code>
     */
    public static final int UNDEFINED_NETWORK_ENDPOINT_TYPE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The network endpoint is represented by an IP address.
     * </pre>
     *
     * <code>GCE_VM_IP = 401880793;</code>
     */
    public static final int GCE_VM_IP_VALUE = 401880793;

    /**
     *
     *
     * <pre>
     * The network endpoint is represented by IP address and port pair.
     * </pre>
     *
     * <code>GCE_VM_IP_PORT = 501838375;</code>
     */
    public static final int GCE_VM_IP_PORT_VALUE = 501838375;

    /**
     *
     *
     * <pre>
     * The network endpoint is represented by an IP, Port and Client Destination Port.
     * </pre>
     *
     * <code>GCE_VM_IP_PORTMAP = 22819253;</code>
     */
    public static final int GCE_VM_IP_PORTMAP_VALUE = 22819253;

    /**
     *
     *
     * <pre>
     * The network endpoint is represented by fully qualified domain name and port.
     * </pre>
     *
     * <code>INTERNET_FQDN_PORT = 404154477;</code>
     */
    public static final int INTERNET_FQDN_PORT_VALUE = 404154477;

    /**
     *
     *
     * <pre>
     * The network endpoint is represented by an internet IP address and port.
     * </pre>
     *
     * <code>INTERNET_IP_PORT = 477719963;</code>
     */
    public static final int INTERNET_IP_PORT_VALUE = 477719963;

    /**
     *
     *
     * <pre>
     * The network endpoint is represented by an IP address and port. The endpoint belongs to a VM or pod running in a customer's on-premises.
     * </pre>
     *
     * <code>NON_GCP_PRIVATE_IP_PORT = 336447968;</code>
     */
    public static final int NON_GCP_PRIVATE_IP_PORT_VALUE = 336447968;

    /**
     *
     *
     * <pre>
     * The network endpoint is either public Google APIs or services exposed by other GCP Project with a Service Attachment. The connection is set up by private service connect
     * </pre>
     *
     * <code>PRIVATE_SERVICE_CONNECT = 48134724;</code>
     */
    public static final int PRIVATE_SERVICE_CONNECT_VALUE = 48134724;

    /**
     *
     *
     * <pre>
     * The network endpoint is handled by specified serverless infrastructure.
     * </pre>
     *
     * <code>SERVERLESS = 270492508;</code>
     */
    public static final int SERVERLESS_VALUE = 270492508;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NetworkEndpointType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static NetworkEndpointType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_NETWORK_ENDPOINT_TYPE;
        case 401880793:
          return GCE_VM_IP;
        case 501838375:
          return GCE_VM_IP_PORT;
        case 22819253:
          return GCE_VM_IP_PORTMAP;
        case 404154477:
          return INTERNET_FQDN_PORT;
        case 477719963:
          return INTERNET_IP_PORT;
        case 336447968:
          return NON_GCP_PRIVATE_IP_PORT;
        case 48134724:
          return PRIVATE_SERVICE_CONNECT;
        case 270492508:
          return SERVERLESS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<NetworkEndpointType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<NetworkEndpointType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<NetworkEndpointType>() {
              public NetworkEndpointType findValueByNumber(int number) {
                return NetworkEndpointType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.NetworkEndpointGroup.getDescriptor().getEnumTypes().get(0);
    }

    private static final NetworkEndpointType[] VALUES = values();

    public static NetworkEndpointType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private NetworkEndpointType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.NetworkEndpointGroup.NetworkEndpointType)
  }

  private int bitField0_;
  public static final int ANNOTATIONS_FIELD_NUMBER = 112032548;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_NetworkEndpointGroup_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Metadata defined as annotations on the network endpoint group.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 112032548;</code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }

  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Metadata defined as annotations on the network endpoint group.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 112032548;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Metadata defined as annotations on the network endpoint group.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 112032548;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. Metadata defined as annotations on the network endpoint group.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 112032548;</code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int APP_ENGINE_FIELD_NUMBER = 340788768;
  private com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine appEngine_;

  /**
   *
   *
   * <pre>
   * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupAppEngine app_engine = 340788768;
   * </code>
   *
   * @return Whether the appEngine field is set.
   */
  @java.lang.Override
  public boolean hasAppEngine() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupAppEngine app_engine = 340788768;
   * </code>
   *
   * @return The appEngine.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine getAppEngine() {
    return appEngine_ == null
        ? com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine.getDefaultInstance()
        : appEngine_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupAppEngine app_engine = 340788768;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkEndpointGroupAppEngineOrBuilder
      getAppEngineOrBuilder() {
    return appEngine_ == null
        ? com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine.getDefaultInstance()
        : appEngine_;
  }

  public static final int CLOUD_FUNCTION_FIELD_NUMBER = 519893666;
  private com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction cloudFunction_;

  /**
   *
   *
   * <pre>
   * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.NetworkEndpointGroupCloudFunction cloud_function = 519893666;
   * </code>
   *
   * @return Whether the cloudFunction field is set.
   */
  @java.lang.Override
  public boolean hasCloudFunction() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.NetworkEndpointGroupCloudFunction cloud_function = 519893666;
   * </code>
   *
   * @return The cloudFunction.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction getCloudFunction() {
    return cloudFunction_ == null
        ? com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction.getDefaultInstance()
        : cloudFunction_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.NetworkEndpointGroupCloudFunction cloud_function = 519893666;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunctionOrBuilder
      getCloudFunctionOrBuilder() {
    return cloudFunction_ == null
        ? com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction.getDefaultInstance()
        : cloudFunction_;
  }

  public static final int CLOUD_RUN_FIELD_NUMBER = 111060353;
  private com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun cloudRun_;

  /**
   *
   *
   * <pre>
   * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupCloudRun cloud_run = 111060353;
   * </code>
   *
   * @return Whether the cloudRun field is set.
   */
  @java.lang.Override
  public boolean hasCloudRun() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupCloudRun cloud_run = 111060353;
   * </code>
   *
   * @return The cloudRun.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun getCloudRun() {
    return cloudRun_ == null
        ? com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun.getDefaultInstance()
        : cloudRun_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupCloudRun cloud_run = 111060353;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkEndpointGroupCloudRunOrBuilder getCloudRunOrBuilder() {
    return cloudRun_ == null
        ? com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun.getDefaultInstance()
        : cloudRun_;
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFAULT_PORT_FIELD_NUMBER = 423377855;
  private int defaultPort_ = 0;

  /**
   *
   *
   * <pre>
   * The default port used if the port number is not specified in the network endpoint. Optional. If the network endpoint type is either GCE_VM_IP, SERVERLESS or PRIVATE_SERVICE_CONNECT, this field must not be specified.
   * </pre>
   *
   * <code>optional int32 default_port = 423377855;</code>
   *
   * @return Whether the defaultPort field is set.
   */
  @java.lang.Override
  public boolean hasDefaultPort() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * The default port used if the port number is not specified in the network endpoint. Optional. If the network endpoint type is either GCE_VM_IP, SERVERLESS or PRIVATE_SERVICE_CONNECT, this field must not be specified.
   * </pre>
   *
   * <code>optional int32 default_port = 423377855;</code>
   *
   * @return The defaultPort.
   */
  @java.lang.Override
  public int getDefaultPort() {
    return defaultPort_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#networkEndpointGroup for network endpoint group.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#networkEndpointGroup for network endpoint group.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#networkEndpointGroup for network endpoint group.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_FIELD_NUMBER = 232872494;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";

  /**
   *
   *
   * <pre>
   * The URL of the network to which all network endpoints in the NEG belong. Uses default project network if unspecified.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return Whether the network field is set.
   */
  @java.lang.Override
  public boolean hasNetwork() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * The URL of the network to which all network endpoints in the NEG belong. Uses default project network if unspecified.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The URL of the network to which all network endpoints in the NEG belong. Uses default project network if unspecified.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_ENDPOINT_TYPE_FIELD_NUMBER = 118301523;

  @SuppressWarnings("serial")
  private volatile java.lang.Object networkEndpointType_ = "";

  /**
   *
   *
   * <pre>
   * Type of network endpoints in this network endpoint group. Can be one of GCE_VM_IP, GCE_VM_IP_PORT, NON_GCP_PRIVATE_IP_PORT, INTERNET_FQDN_PORT, INTERNET_IP_PORT, SERVERLESS, PRIVATE_SERVICE_CONNECT, GCE_VM_IP_PORTMAP.
   * Check the NetworkEndpointType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string network_endpoint_type = 118301523;</code>
   *
   * @return Whether the networkEndpointType field is set.
   */
  @java.lang.Override
  public boolean hasNetworkEndpointType() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * Type of network endpoints in this network endpoint group. Can be one of GCE_VM_IP, GCE_VM_IP_PORT, NON_GCP_PRIVATE_IP_PORT, INTERNET_FQDN_PORT, INTERNET_IP_PORT, SERVERLESS, PRIVATE_SERVICE_CONNECT, GCE_VM_IP_PORTMAP.
   * Check the NetworkEndpointType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string network_endpoint_type = 118301523;</code>
   *
   * @return The networkEndpointType.
   */
  @java.lang.Override
  public java.lang.String getNetworkEndpointType() {
    java.lang.Object ref = networkEndpointType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      networkEndpointType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Type of network endpoints in this network endpoint group. Can be one of GCE_VM_IP, GCE_VM_IP_PORT, NON_GCP_PRIVATE_IP_PORT, INTERNET_FQDN_PORT, INTERNET_IP_PORT, SERVERLESS, PRIVATE_SERVICE_CONNECT, GCE_VM_IP_PORTMAP.
   * Check the NetworkEndpointType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string network_endpoint_type = 118301523;</code>
   *
   * @return The bytes for networkEndpointType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkEndpointTypeBytes() {
    java.lang.Object ref = networkEndpointType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      networkEndpointType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PSC_DATA_FIELD_NUMBER = 71937481;
  private com.google.cloud.compute.v1.NetworkEndpointGroupPscData pscData_;

  /**
   *
   *
   * <pre>
   * Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupPscData psc_data = 71937481;</code>
   *
   * @return Whether the pscData field is set.
   */
  @java.lang.Override
  public boolean hasPscData() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupPscData psc_data = 71937481;</code>
   *
   * @return The pscData.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkEndpointGroupPscData getPscData() {
    return pscData_ == null
        ? com.google.cloud.compute.v1.NetworkEndpointGroupPscData.getDefaultInstance()
        : pscData_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupPscData psc_data = 71937481;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkEndpointGroupPscDataOrBuilder getPscDataOrBuilder() {
    return pscData_ == null
        ? com.google.cloud.compute.v1.NetworkEndpointGroupPscData.getDefaultInstance()
        : pscData_;
  }

  public static final int PSC_TARGET_SERVICE_FIELD_NUMBER = 269132134;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pscTargetService_ = "";

  /**
   *
   *
   * <pre>
   * The target service url used to set up private service connection to a Google API or a PSC Producer Service Attachment. An example value is: asia-northeast3-cloudkms.googleapis.com. Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
   * </pre>
   *
   * <code>optional string psc_target_service = 269132134;</code>
   *
   * @return Whether the pscTargetService field is set.
   */
  @java.lang.Override
  public boolean hasPscTargetService() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * The target service url used to set up private service connection to a Google API or a PSC Producer Service Attachment. An example value is: asia-northeast3-cloudkms.googleapis.com. Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
   * </pre>
   *
   * <code>optional string psc_target_service = 269132134;</code>
   *
   * @return The pscTargetService.
   */
  @java.lang.Override
  public java.lang.String getPscTargetService() {
    java.lang.Object ref = pscTargetService_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pscTargetService_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The target service url used to set up private service connection to a Google API or a PSC Producer Service Attachment. An example value is: asia-northeast3-cloudkms.googleapis.com. Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
   * </pre>
   *
   * <code>optional string psc_target_service = 269132134;</code>
   *
   * @return The bytes for pscTargetService.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPscTargetServiceBytes() {
    java.lang.Object ref = pscTargetService_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pscTargetService_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the region where the network endpoint group is located.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  @java.lang.Override
  public boolean hasRegion() {
    return ((bitField0_ & 0x00002000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the region where the network endpoint group is located.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the region where the network endpoint group is located.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00004000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SIZE_FIELD_NUMBER = 3530753;
  private int size_ = 0;

  /**
   *
   *
   * <pre>
   * [Output only] Number of network endpoints in the network endpoint group.
   * </pre>
   *
   * <code>optional int32 size = 3530753;</code>
   *
   * @return Whether the size field is set.
   */
  @java.lang.Override
  public boolean hasSize() {
    return ((bitField0_ & 0x00008000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output only] Number of network endpoints in the network endpoint group.
   * </pre>
   *
   * <code>optional int32 size = 3530753;</code>
   *
   * @return The size.
   */
  @java.lang.Override
  public int getSize() {
    return size_;
  }

  public static final int SUBNETWORK_FIELD_NUMBER = 307827694;

  @SuppressWarnings("serial")
  private volatile java.lang.Object subnetwork_ = "";

  /**
   *
   *
   * <pre>
   * Optional URL of the subnetwork to which all network endpoints in the NEG belong.
   * </pre>
   *
   * <code>optional string subnetwork = 307827694;</code>
   *
   * @return Whether the subnetwork field is set.
   */
  @java.lang.Override
  public boolean hasSubnetwork() {
    return ((bitField0_ & 0x00010000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional URL of the subnetwork to which all network endpoints in the NEG belong.
   * </pre>
   *
   * <code>optional string subnetwork = 307827694;</code>
   *
   * @return The subnetwork.
   */
  @java.lang.Override
  public java.lang.String getSubnetwork() {
    java.lang.Object ref = subnetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subnetwork_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional URL of the subnetwork to which all network endpoints in the NEG belong.
   * </pre>
   *
   * <code>optional string subnetwork = 307827694;</code>
   *
   * @return The bytes for subnetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubnetworkBytes() {
    java.lang.Object ref = subnetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subnetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONE_FIELD_NUMBER = 3744684;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the zone where the network endpoint group is located.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return Whether the zone field is set.
   */
  @java.lang.Override
  public boolean hasZone() {
    return ((bitField0_ & 0x00020000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the zone where the network endpoint group is located.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The zone.
   */
  @java.lang.Override
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the zone where the network endpoint group is located.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The bytes for zone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeInt32(3530753, size_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3744684, zone_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(71937481, getPscData());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(111060353, getCloudRun());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 112032548);
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 118301523, networkEndpointType_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 232872494, network_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 269132134, pscTargetService_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 307827694, subnetwork_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(340788768, getAppEngine());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt32(423377855, defaultPort_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(519893666, getCloudFunction());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3530753, size_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3744684, zone_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(71937481, getPscData());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(111060353, getCloudRun());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(112032548, annotations__);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(118301523, networkEndpointType_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(232872494, network_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(269132134, pscTargetService_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(307827694, subnetwork_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(340788768, getAppEngine());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(423377855, defaultPort_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(519893666, getCloudFunction());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.NetworkEndpointGroup)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.NetworkEndpointGroup other =
        (com.google.cloud.compute.v1.NetworkEndpointGroup) obj;

    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (hasAppEngine() != other.hasAppEngine()) return false;
    if (hasAppEngine()) {
      if (!getAppEngine().equals(other.getAppEngine())) return false;
    }
    if (hasCloudFunction() != other.hasCloudFunction()) return false;
    if (hasCloudFunction()) {
      if (!getCloudFunction().equals(other.getCloudFunction())) return false;
    }
    if (hasCloudRun() != other.hasCloudRun()) return false;
    if (hasCloudRun()) {
      if (!getCloudRun().equals(other.getCloudRun())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDefaultPort() != other.hasDefaultPort()) return false;
    if (hasDefaultPort()) {
      if (getDefaultPort() != other.getDefaultPort()) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasNetwork() != other.hasNetwork()) return false;
    if (hasNetwork()) {
      if (!getNetwork().equals(other.getNetwork())) return false;
    }
    if (hasNetworkEndpointType() != other.hasNetworkEndpointType()) return false;
    if (hasNetworkEndpointType()) {
      if (!getNetworkEndpointType().equals(other.getNetworkEndpointType())) return false;
    }
    if (hasPscData() != other.hasPscData()) return false;
    if (hasPscData()) {
      if (!getPscData().equals(other.getPscData())) return false;
    }
    if (hasPscTargetService() != other.hasPscTargetService()) return false;
    if (hasPscTargetService()) {
      if (!getPscTargetService().equals(other.getPscTargetService())) return false;
    }
    if (hasRegion() != other.hasRegion()) return false;
    if (hasRegion()) {
      if (!getRegion().equals(other.getRegion())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasSize() != other.hasSize()) return false;
    if (hasSize()) {
      if (getSize() != other.getSize()) return false;
    }
    if (hasSubnetwork() != other.hasSubnetwork()) return false;
    if (hasSubnetwork()) {
      if (!getSubnetwork().equals(other.getSubnetwork())) return false;
    }
    if (hasZone() != other.hasZone()) return false;
    if (hasZone()) {
      if (!getZone().equals(other.getZone())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    if (hasAppEngine()) {
      hash = (37 * hash) + APP_ENGINE_FIELD_NUMBER;
      hash = (53 * hash) + getAppEngine().hashCode();
    }
    if (hasCloudFunction()) {
      hash = (37 * hash) + CLOUD_FUNCTION_FIELD_NUMBER;
      hash = (53 * hash) + getCloudFunction().hashCode();
    }
    if (hasCloudRun()) {
      hash = (37 * hash) + CLOUD_RUN_FIELD_NUMBER;
      hash = (53 * hash) + getCloudRun().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDefaultPort()) {
      hash = (37 * hash) + DEFAULT_PORT_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultPort();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasNetwork()) {
      hash = (37 * hash) + NETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getNetwork().hashCode();
    }
    if (hasNetworkEndpointType()) {
      hash = (37 * hash) + NETWORK_ENDPOINT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkEndpointType().hashCode();
    }
    if (hasPscData()) {
      hash = (37 * hash) + PSC_DATA_FIELD_NUMBER;
      hash = (53 * hash) + getPscData().hashCode();
    }
    if (hasPscTargetService()) {
      hash = (37 * hash) + PSC_TARGET_SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getPscTargetService().hashCode();
    }
    if (hasRegion()) {
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasSize()) {
      hash = (37 * hash) + SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getSize();
    }
    if (hasSubnetwork()) {
      hash = (37 * hash) + SUBNETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getSubnetwork().hashCode();
    }
    if (hasZone()) {
      hash = (37 * hash) + ZONE_FIELD_NUMBER;
      hash = (53 * hash) + getZone().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.NetworkEndpointGroup parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NetworkEndpointGroup parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkEndpointGroup parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NetworkEndpointGroup parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkEndpointGroup parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.NetworkEndpointGroup parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkEndpointGroup parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NetworkEndpointGroup parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkEndpointGroup parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NetworkEndpointGroup parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.NetworkEndpointGroup parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.NetworkEndpointGroup parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.NetworkEndpointGroup prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a collection of network endpoints. A network endpoint group (NEG) defines how a set of endpoints should be reached, whether they are reachable, and where they are located. For more information about using NEGs for different use cases, see Network endpoint groups overview.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.NetworkEndpointGroup}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.NetworkEndpointGroup)
      com.google.cloud.compute.v1.NetworkEndpointGroupOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NetworkEndpointGroup_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 112032548:
          return internalGetAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 112032548:
          return internalGetMutableAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NetworkEndpointGroup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.NetworkEndpointGroup.class,
              com.google.cloud.compute.v1.NetworkEndpointGroup.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.NetworkEndpointGroup.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAppEngineFieldBuilder();
        getCloudFunctionFieldBuilder();
        getCloudRunFieldBuilder();
        getPscDataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      internalGetMutableAnnotations().clear();
      appEngine_ = null;
      if (appEngineBuilder_ != null) {
        appEngineBuilder_.dispose();
        appEngineBuilder_ = null;
      }
      cloudFunction_ = null;
      if (cloudFunctionBuilder_ != null) {
        cloudFunctionBuilder_.dispose();
        cloudFunctionBuilder_ = null;
      }
      cloudRun_ = null;
      if (cloudRunBuilder_ != null) {
        cloudRunBuilder_.dispose();
        cloudRunBuilder_ = null;
      }
      creationTimestamp_ = "";
      defaultPort_ = 0;
      description_ = "";
      id_ = 0L;
      kind_ = "";
      name_ = "";
      network_ = "";
      networkEndpointType_ = "";
      pscData_ = null;
      if (pscDataBuilder_ != null) {
        pscDataBuilder_.dispose();
        pscDataBuilder_ = null;
      }
      pscTargetService_ = "";
      region_ = "";
      selfLink_ = "";
      size_ = 0;
      subnetwork_ = "";
      zone_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_NetworkEndpointGroup_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NetworkEndpointGroup getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.NetworkEndpointGroup.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NetworkEndpointGroup build() {
      com.google.cloud.compute.v1.NetworkEndpointGroup result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.NetworkEndpointGroup buildPartial() {
      com.google.cloud.compute.v1.NetworkEndpointGroup result =
          new com.google.cloud.compute.v1.NetworkEndpointGroup(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.NetworkEndpointGroup result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.appEngine_ = appEngineBuilder_ == null ? appEngine_ : appEngineBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.cloudFunction_ =
            cloudFunctionBuilder_ == null ? cloudFunction_ : cloudFunctionBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.cloudRun_ = cloudRunBuilder_ == null ? cloudRun_ : cloudRunBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.defaultPort_ = defaultPort_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.network_ = network_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.networkEndpointType_ = networkEndpointType_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.pscData_ = pscDataBuilder_ == null ? pscData_ : pscDataBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.pscTargetService_ = pscTargetService_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.region_ = region_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.size_ = size_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.subnetwork_ = subnetwork_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.zone_ = zone_;
        to_bitField0_ |= 0x00020000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.NetworkEndpointGroup) {
        return mergeFrom((com.google.cloud.compute.v1.NetworkEndpointGroup) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.NetworkEndpointGroup other) {
      if (other == com.google.cloud.compute.v1.NetworkEndpointGroup.getDefaultInstance())
        return this;
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000001;
      if (other.hasAppEngine()) {
        mergeAppEngine(other.getAppEngine());
      }
      if (other.hasCloudFunction()) {
        mergeCloudFunction(other.getCloudFunction());
      }
      if (other.hasCloudRun()) {
        mergeCloudRun(other.getCloudRun());
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasDefaultPort()) {
        setDefaultPort(other.getDefaultPort());
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasNetwork()) {
        network_ = other.network_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasNetworkEndpointType()) {
        networkEndpointType_ = other.networkEndpointType_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasPscData()) {
        mergePscData(other.getPscData());
      }
      if (other.hasPscTargetService()) {
        pscTargetService_ = other.pscTargetService_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasRegion()) {
        region_ = other.region_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasSize()) {
        setSize(other.getSize());
      }
      if (other.hasSubnetwork()) {
        subnetwork_ = other.subnetwork_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasZone()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 26989658
            case 28246024:
              {
                size_ = input.readInt32();
                bitField0_ |= 0x00010000;
                break;
              } // case 28246024
            case 29957474:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case 29957474
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 244202930
            case 575499850:
              {
                input.readMessage(getPscDataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 575499850
            case 888482826:
              {
                input.readMessage(getCloudRunFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 888482826
            case 896260386:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000001;
                break;
              } // case 896260386
            case 946412186:
              {
                networkEndpointType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 946412186
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 1111570338
            case 1862979954:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 1862979954
            case -2141910222:
              {
                pscTargetService_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case -2141910222
            case -1832345742:
              {
                subnetwork_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case -1832345742
            case -1568657150:
              {
                input.readMessage(getAppEngineFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case -1568657150
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case -911466526
            case -907944456:
              {
                defaultPort_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case -907944456
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case -645248918
            case -135817966:
              {
                input.readMessage(getCloudFunctionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case -135817966
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata defined as annotations on the network endpoint group.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 112032548;</code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }

    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata defined as annotations on the network endpoint group.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 112032548;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata defined as annotations on the network endpoint group.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 112032548;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata defined as annotations on the network endpoint group.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 112032548;</code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata defined as annotations on the network endpoint group.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 112032548;</code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000001;
      return internalGetMutableAnnotations().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata defined as annotations on the network endpoint group.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 112032548;</code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000001;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata defined as annotations on the network endpoint group.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 112032548;</code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000001;
      return this;
    }

    private com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine appEngine_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine,
            com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine.Builder,
            com.google.cloud.compute.v1.NetworkEndpointGroupAppEngineOrBuilder>
        appEngineBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupAppEngine app_engine = 340788768;
     * </code>
     *
     * @return Whether the appEngine field is set.
     */
    public boolean hasAppEngine() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupAppEngine app_engine = 340788768;
     * </code>
     *
     * @return The appEngine.
     */
    public com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine getAppEngine() {
      if (appEngineBuilder_ == null) {
        return appEngine_ == null
            ? com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine.getDefaultInstance()
            : appEngine_;
      } else {
        return appEngineBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupAppEngine app_engine = 340788768;
     * </code>
     */
    public Builder setAppEngine(com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine value) {
      if (appEngineBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        appEngine_ = value;
      } else {
        appEngineBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupAppEngine app_engine = 340788768;
     * </code>
     */
    public Builder setAppEngine(
        com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine.Builder builderForValue) {
      if (appEngineBuilder_ == null) {
        appEngine_ = builderForValue.build();
      } else {
        appEngineBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupAppEngine app_engine = 340788768;
     * </code>
     */
    public Builder mergeAppEngine(com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine value) {
      if (appEngineBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && appEngine_ != null
            && appEngine_
                != com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine.getDefaultInstance()) {
          getAppEngineBuilder().mergeFrom(value);
        } else {
          appEngine_ = value;
        }
      } else {
        appEngineBuilder_.mergeFrom(value);
      }
      if (appEngine_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupAppEngine app_engine = 340788768;
     * </code>
     */
    public Builder clearAppEngine() {
      bitField0_ = (bitField0_ & ~0x00000002);
      appEngine_ = null;
      if (appEngineBuilder_ != null) {
        appEngineBuilder_.dispose();
        appEngineBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupAppEngine app_engine = 340788768;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine.Builder getAppEngineBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getAppEngineFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupAppEngine app_engine = 340788768;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkEndpointGroupAppEngineOrBuilder
        getAppEngineOrBuilder() {
      if (appEngineBuilder_ != null) {
        return appEngineBuilder_.getMessageOrBuilder();
      } else {
        return appEngine_ == null
            ? com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine.getDefaultInstance()
            : appEngine_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupAppEngine app_engine = 340788768;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine,
            com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine.Builder,
            com.google.cloud.compute.v1.NetworkEndpointGroupAppEngineOrBuilder>
        getAppEngineFieldBuilder() {
      if (appEngineBuilder_ == null) {
        appEngineBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine,
                com.google.cloud.compute.v1.NetworkEndpointGroupAppEngine.Builder,
                com.google.cloud.compute.v1.NetworkEndpointGroupAppEngineOrBuilder>(
                getAppEngine(), getParentForChildren(), isClean());
        appEngine_ = null;
      }
      return appEngineBuilder_;
    }

    private com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction cloudFunction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction,
            com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction.Builder,
            com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunctionOrBuilder>
        cloudFunctionBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkEndpointGroupCloudFunction cloud_function = 519893666;
     * </code>
     *
     * @return Whether the cloudFunction field is set.
     */
    public boolean hasCloudFunction() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkEndpointGroupCloudFunction cloud_function = 519893666;
     * </code>
     *
     * @return The cloudFunction.
     */
    public com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction getCloudFunction() {
      if (cloudFunctionBuilder_ == null) {
        return cloudFunction_ == null
            ? com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction.getDefaultInstance()
            : cloudFunction_;
      } else {
        return cloudFunctionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkEndpointGroupCloudFunction cloud_function = 519893666;
     * </code>
     */
    public Builder setCloudFunction(
        com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction value) {
      if (cloudFunctionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cloudFunction_ = value;
      } else {
        cloudFunctionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkEndpointGroupCloudFunction cloud_function = 519893666;
     * </code>
     */
    public Builder setCloudFunction(
        com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction.Builder builderForValue) {
      if (cloudFunctionBuilder_ == null) {
        cloudFunction_ = builderForValue.build();
      } else {
        cloudFunctionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkEndpointGroupCloudFunction cloud_function = 519893666;
     * </code>
     */
    public Builder mergeCloudFunction(
        com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction value) {
      if (cloudFunctionBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && cloudFunction_ != null
            && cloudFunction_
                != com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction
                    .getDefaultInstance()) {
          getCloudFunctionBuilder().mergeFrom(value);
        } else {
          cloudFunction_ = value;
        }
      } else {
        cloudFunctionBuilder_.mergeFrom(value);
      }
      if (cloudFunction_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkEndpointGroupCloudFunction cloud_function = 519893666;
     * </code>
     */
    public Builder clearCloudFunction() {
      bitField0_ = (bitField0_ & ~0x00000004);
      cloudFunction_ = null;
      if (cloudFunctionBuilder_ != null) {
        cloudFunctionBuilder_.dispose();
        cloudFunctionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkEndpointGroupCloudFunction cloud_function = 519893666;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction.Builder
        getCloudFunctionBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCloudFunctionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkEndpointGroupCloudFunction cloud_function = 519893666;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunctionOrBuilder
        getCloudFunctionOrBuilder() {
      if (cloudFunctionBuilder_ != null) {
        return cloudFunctionBuilder_.getMessageOrBuilder();
      } else {
        return cloudFunction_ == null
            ? com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction.getDefaultInstance()
            : cloudFunction_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkEndpointGroupCloudFunction cloud_function = 519893666;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction,
            com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction.Builder,
            com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunctionOrBuilder>
        getCloudFunctionFieldBuilder() {
      if (cloudFunctionBuilder_ == null) {
        cloudFunctionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction,
                com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunction.Builder,
                com.google.cloud.compute.v1.NetworkEndpointGroupCloudFunctionOrBuilder>(
                getCloudFunction(), getParentForChildren(), isClean());
        cloudFunction_ = null;
      }
      return cloudFunctionBuilder_;
    }

    private com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun cloudRun_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun,
            com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun.Builder,
            com.google.cloud.compute.v1.NetworkEndpointGroupCloudRunOrBuilder>
        cloudRunBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupCloudRun cloud_run = 111060353;
     * </code>
     *
     * @return Whether the cloudRun field is set.
     */
    public boolean hasCloudRun() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupCloudRun cloud_run = 111060353;
     * </code>
     *
     * @return The cloudRun.
     */
    public com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun getCloudRun() {
      if (cloudRunBuilder_ == null) {
        return cloudRun_ == null
            ? com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun.getDefaultInstance()
            : cloudRun_;
      } else {
        return cloudRunBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupCloudRun cloud_run = 111060353;
     * </code>
     */
    public Builder setCloudRun(com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun value) {
      if (cloudRunBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cloudRun_ = value;
      } else {
        cloudRunBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupCloudRun cloud_run = 111060353;
     * </code>
     */
    public Builder setCloudRun(
        com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun.Builder builderForValue) {
      if (cloudRunBuilder_ == null) {
        cloudRun_ = builderForValue.build();
      } else {
        cloudRunBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupCloudRun cloud_run = 111060353;
     * </code>
     */
    public Builder mergeCloudRun(com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun value) {
      if (cloudRunBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && cloudRun_ != null
            && cloudRun_
                != com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun.getDefaultInstance()) {
          getCloudRunBuilder().mergeFrom(value);
        } else {
          cloudRun_ = value;
        }
      } else {
        cloudRunBuilder_.mergeFrom(value);
      }
      if (cloudRun_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupCloudRun cloud_run = 111060353;
     * </code>
     */
    public Builder clearCloudRun() {
      bitField0_ = (bitField0_ & ~0x00000008);
      cloudRun_ = null;
      if (cloudRunBuilder_ != null) {
        cloudRunBuilder_.dispose();
        cloudRunBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupCloudRun cloud_run = 111060353;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun.Builder getCloudRunBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCloudRunFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupCloudRun cloud_run = 111060353;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkEndpointGroupCloudRunOrBuilder
        getCloudRunOrBuilder() {
      if (cloudRunBuilder_ != null) {
        return cloudRunBuilder_.getMessageOrBuilder();
      } else {
        return cloudRun_ == null
            ? com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun.getDefaultInstance()
            : cloudRun_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is SERVERLESS. Only one of cloudRun, appEngine or cloudFunction may be set.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupCloudRun cloud_run = 111060353;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun,
            com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun.Builder,
            com.google.cloud.compute.v1.NetworkEndpointGroupCloudRunOrBuilder>
        getCloudRunFieldBuilder() {
      if (cloudRunBuilder_ == null) {
        cloudRunBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun,
                com.google.cloud.compute.v1.NetworkEndpointGroupCloudRun.Builder,
                com.google.cloud.compute.v1.NetworkEndpointGroupCloudRunOrBuilder>(
                getCloudRun(), getParentForChildren(), isClean());
        cloudRun_ = null;
      }
      return cloudRunBuilder_;
    }

    private java.lang.Object creationTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int defaultPort_;

    /**
     *
     *
     * <pre>
     * The default port used if the port number is not specified in the network endpoint. Optional. If the network endpoint type is either GCE_VM_IP, SERVERLESS or PRIVATE_SERVICE_CONNECT, this field must not be specified.
     * </pre>
     *
     * <code>optional int32 default_port = 423377855;</code>
     *
     * @return Whether the defaultPort field is set.
     */
    @java.lang.Override
    public boolean hasDefaultPort() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * The default port used if the port number is not specified in the network endpoint. Optional. If the network endpoint type is either GCE_VM_IP, SERVERLESS or PRIVATE_SERVICE_CONNECT, this field must not be specified.
     * </pre>
     *
     * <code>optional int32 default_port = 423377855;</code>
     *
     * @return The defaultPort.
     */
    @java.lang.Override
    public int getDefaultPort() {
      return defaultPort_;
    }

    /**
     *
     *
     * <pre>
     * The default port used if the port number is not specified in the network endpoint. Optional. If the network endpoint type is either GCE_VM_IP, SERVERLESS or PRIVATE_SERVICE_CONNECT, this field must not be specified.
     * </pre>
     *
     * <code>optional int32 default_port = 423377855;</code>
     *
     * @param value The defaultPort to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultPort(int value) {

      defaultPort_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The default port used if the port number is not specified in the network endpoint. Optional. If the network endpoint type is either GCE_VM_IP, SERVERLESS or PRIVATE_SERVICE_CONNECT, this field must not be specified.
     * </pre>
     *
     * <code>optional int32 default_port = 423377855;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultPort() {
      bitField0_ = (bitField0_ & ~0x00000020);
      defaultPort_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private long id_;

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000080);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#networkEndpointGroup for network endpoint group.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#networkEndpointGroup for network endpoint group.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#networkEndpointGroup for network endpoint group.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#networkEndpointGroup for network endpoint group.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#networkEndpointGroup for network endpoint group.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#networkEndpointGroup for network endpoint group.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object network_ = "";

    /**
     *
     *
     * <pre>
     * The URL of the network to which all network endpoints in the NEG belong. Uses default project network if unspecified.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return Whether the network field is set.
     */
    public boolean hasNetwork() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * The URL of the network to which all network endpoints in the NEG belong. Uses default project network if unspecified.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The URL of the network to which all network endpoints in the NEG belong. Uses default project network if unspecified.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The URL of the network to which all network endpoints in the NEG belong. Uses default project network if unspecified.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URL of the network to which all network endpoints in the NEG belong. Uses default project network if unspecified.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URL of the network to which all network endpoints in the NEG belong. Uses default project network if unspecified.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object networkEndpointType_ = "";

    /**
     *
     *
     * <pre>
     * Type of network endpoints in this network endpoint group. Can be one of GCE_VM_IP, GCE_VM_IP_PORT, NON_GCP_PRIVATE_IP_PORT, INTERNET_FQDN_PORT, INTERNET_IP_PORT, SERVERLESS, PRIVATE_SERVICE_CONNECT, GCE_VM_IP_PORTMAP.
     * Check the NetworkEndpointType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_endpoint_type = 118301523;</code>
     *
     * @return Whether the networkEndpointType field is set.
     */
    public boolean hasNetworkEndpointType() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Type of network endpoints in this network endpoint group. Can be one of GCE_VM_IP, GCE_VM_IP_PORT, NON_GCP_PRIVATE_IP_PORT, INTERNET_FQDN_PORT, INTERNET_IP_PORT, SERVERLESS, PRIVATE_SERVICE_CONNECT, GCE_VM_IP_PORTMAP.
     * Check the NetworkEndpointType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_endpoint_type = 118301523;</code>
     *
     * @return The networkEndpointType.
     */
    public java.lang.String getNetworkEndpointType() {
      java.lang.Object ref = networkEndpointType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        networkEndpointType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Type of network endpoints in this network endpoint group. Can be one of GCE_VM_IP, GCE_VM_IP_PORT, NON_GCP_PRIVATE_IP_PORT, INTERNET_FQDN_PORT, INTERNET_IP_PORT, SERVERLESS, PRIVATE_SERVICE_CONNECT, GCE_VM_IP_PORTMAP.
     * Check the NetworkEndpointType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_endpoint_type = 118301523;</code>
     *
     * @return The bytes for networkEndpointType.
     */
    public com.google.protobuf.ByteString getNetworkEndpointTypeBytes() {
      java.lang.Object ref = networkEndpointType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        networkEndpointType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Type of network endpoints in this network endpoint group. Can be one of GCE_VM_IP, GCE_VM_IP_PORT, NON_GCP_PRIVATE_IP_PORT, INTERNET_FQDN_PORT, INTERNET_IP_PORT, SERVERLESS, PRIVATE_SERVICE_CONNECT, GCE_VM_IP_PORTMAP.
     * Check the NetworkEndpointType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_endpoint_type = 118301523;</code>
     *
     * @param value The networkEndpointType to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkEndpointType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      networkEndpointType_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Type of network endpoints in this network endpoint group. Can be one of GCE_VM_IP, GCE_VM_IP_PORT, NON_GCP_PRIVATE_IP_PORT, INTERNET_FQDN_PORT, INTERNET_IP_PORT, SERVERLESS, PRIVATE_SERVICE_CONNECT, GCE_VM_IP_PORTMAP.
     * Check the NetworkEndpointType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_endpoint_type = 118301523;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkEndpointType() {
      networkEndpointType_ = getDefaultInstance().getNetworkEndpointType();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Type of network endpoints in this network endpoint group. Can be one of GCE_VM_IP, GCE_VM_IP_PORT, NON_GCP_PRIVATE_IP_PORT, INTERNET_FQDN_PORT, INTERNET_IP_PORT, SERVERLESS, PRIVATE_SERVICE_CONNECT, GCE_VM_IP_PORTMAP.
     * Check the NetworkEndpointType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_endpoint_type = 118301523;</code>
     *
     * @param value The bytes for networkEndpointType to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkEndpointTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      networkEndpointType_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.NetworkEndpointGroupPscData pscData_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkEndpointGroupPscData,
            com.google.cloud.compute.v1.NetworkEndpointGroupPscData.Builder,
            com.google.cloud.compute.v1.NetworkEndpointGroupPscDataOrBuilder>
        pscDataBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupPscData psc_data = 71937481;
     * </code>
     *
     * @return Whether the pscData field is set.
     */
    public boolean hasPscData() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupPscData psc_data = 71937481;
     * </code>
     *
     * @return The pscData.
     */
    public com.google.cloud.compute.v1.NetworkEndpointGroupPscData getPscData() {
      if (pscDataBuilder_ == null) {
        return pscData_ == null
            ? com.google.cloud.compute.v1.NetworkEndpointGroupPscData.getDefaultInstance()
            : pscData_;
      } else {
        return pscDataBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupPscData psc_data = 71937481;
     * </code>
     */
    public Builder setPscData(com.google.cloud.compute.v1.NetworkEndpointGroupPscData value) {
      if (pscDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pscData_ = value;
      } else {
        pscDataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupPscData psc_data = 71937481;
     * </code>
     */
    public Builder setPscData(
        com.google.cloud.compute.v1.NetworkEndpointGroupPscData.Builder builderForValue) {
      if (pscDataBuilder_ == null) {
        pscData_ = builderForValue.build();
      } else {
        pscDataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupPscData psc_data = 71937481;
     * </code>
     */
    public Builder mergePscData(com.google.cloud.compute.v1.NetworkEndpointGroupPscData value) {
      if (pscDataBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && pscData_ != null
            && pscData_
                != com.google.cloud.compute.v1.NetworkEndpointGroupPscData.getDefaultInstance()) {
          getPscDataBuilder().mergeFrom(value);
        } else {
          pscData_ = value;
        }
      } else {
        pscDataBuilder_.mergeFrom(value);
      }
      if (pscData_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupPscData psc_data = 71937481;
     * </code>
     */
    public Builder clearPscData() {
      bitField0_ = (bitField0_ & ~0x00001000);
      pscData_ = null;
      if (pscDataBuilder_ != null) {
        pscDataBuilder_.dispose();
        pscDataBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupPscData psc_data = 71937481;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkEndpointGroupPscData.Builder getPscDataBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getPscDataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupPscData psc_data = 71937481;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkEndpointGroupPscDataOrBuilder getPscDataOrBuilder() {
      if (pscDataBuilder_ != null) {
        return pscDataBuilder_.getMessageOrBuilder();
      } else {
        return pscData_ == null
            ? com.google.cloud.compute.v1.NetworkEndpointGroupPscData.getDefaultInstance()
            : pscData_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.NetworkEndpointGroupPscData psc_data = 71937481;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkEndpointGroupPscData,
            com.google.cloud.compute.v1.NetworkEndpointGroupPscData.Builder,
            com.google.cloud.compute.v1.NetworkEndpointGroupPscDataOrBuilder>
        getPscDataFieldBuilder() {
      if (pscDataBuilder_ == null) {
        pscDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.NetworkEndpointGroupPscData,
                com.google.cloud.compute.v1.NetworkEndpointGroupPscData.Builder,
                com.google.cloud.compute.v1.NetworkEndpointGroupPscDataOrBuilder>(
                getPscData(), getParentForChildren(), isClean());
        pscData_ = null;
      }
      return pscDataBuilder_;
    }

    private java.lang.Object pscTargetService_ = "";

    /**
     *
     *
     * <pre>
     * The target service url used to set up private service connection to a Google API or a PSC Producer Service Attachment. An example value is: asia-northeast3-cloudkms.googleapis.com. Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
     * </pre>
     *
     * <code>optional string psc_target_service = 269132134;</code>
     *
     * @return Whether the pscTargetService field is set.
     */
    public boolean hasPscTargetService() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * The target service url used to set up private service connection to a Google API or a PSC Producer Service Attachment. An example value is: asia-northeast3-cloudkms.googleapis.com. Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
     * </pre>
     *
     * <code>optional string psc_target_service = 269132134;</code>
     *
     * @return The pscTargetService.
     */
    public java.lang.String getPscTargetService() {
      java.lang.Object ref = pscTargetService_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pscTargetService_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The target service url used to set up private service connection to a Google API or a PSC Producer Service Attachment. An example value is: asia-northeast3-cloudkms.googleapis.com. Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
     * </pre>
     *
     * <code>optional string psc_target_service = 269132134;</code>
     *
     * @return The bytes for pscTargetService.
     */
    public com.google.protobuf.ByteString getPscTargetServiceBytes() {
      java.lang.Object ref = pscTargetService_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pscTargetService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The target service url used to set up private service connection to a Google API or a PSC Producer Service Attachment. An example value is: asia-northeast3-cloudkms.googleapis.com. Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
     * </pre>
     *
     * <code>optional string psc_target_service = 269132134;</code>
     *
     * @param value The pscTargetService to set.
     * @return This builder for chaining.
     */
    public Builder setPscTargetService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pscTargetService_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The target service url used to set up private service connection to a Google API or a PSC Producer Service Attachment. An example value is: asia-northeast3-cloudkms.googleapis.com. Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
     * </pre>
     *
     * <code>optional string psc_target_service = 269132134;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPscTargetService() {
      pscTargetService_ = getDefaultInstance().getPscTargetService();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The target service url used to set up private service connection to a Google API or a PSC Producer Service Attachment. An example value is: asia-northeast3-cloudkms.googleapis.com. Optional. Only valid when networkEndpointType is PRIVATE_SERVICE_CONNECT.
     * </pre>
     *
     * <code>optional string psc_target_service = 269132134;</code>
     *
     * @param value The bytes for pscTargetService to set.
     * @return This builder for chaining.
     */
    public Builder setPscTargetServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pscTargetService_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object region_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the region where the network endpoint group is located.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return Whether the region field is set.
     */
    public boolean hasRegion() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the region where the network endpoint group is located.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the region where the network endpoint group is located.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the region where the network endpoint group is located.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the region where the network endpoint group is located.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the region where the network endpoint group is located.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00008000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private int size_;

    /**
     *
     *
     * <pre>
     * [Output only] Number of network endpoints in the network endpoint group.
     * </pre>
     *
     * <code>optional int32 size = 3530753;</code>
     *
     * @return Whether the size field is set.
     */
    @java.lang.Override
    public boolean hasSize() {
      return ((bitField0_ & 0x00010000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output only] Number of network endpoints in the network endpoint group.
     * </pre>
     *
     * <code>optional int32 size = 3530753;</code>
     *
     * @return The size.
     */
    @java.lang.Override
    public int getSize() {
      return size_;
    }

    /**
     *
     *
     * <pre>
     * [Output only] Number of network endpoints in the network endpoint group.
     * </pre>
     *
     * <code>optional int32 size = 3530753;</code>
     *
     * @param value The size to set.
     * @return This builder for chaining.
     */
    public Builder setSize(int value) {

      size_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] Number of network endpoints in the network endpoint group.
     * </pre>
     *
     * <code>optional int32 size = 3530753;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSize() {
      bitField0_ = (bitField0_ & ~0x00010000);
      size_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object subnetwork_ = "";

    /**
     *
     *
     * <pre>
     * Optional URL of the subnetwork to which all network endpoints in the NEG belong.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @return Whether the subnetwork field is set.
     */
    public boolean hasSubnetwork() {
      return ((bitField0_ & 0x00020000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional URL of the subnetwork to which all network endpoints in the NEG belong.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @return The subnetwork.
     */
    public java.lang.String getSubnetwork() {
      java.lang.Object ref = subnetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subnetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional URL of the subnetwork to which all network endpoints in the NEG belong.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @return The bytes for subnetwork.
     */
    public com.google.protobuf.ByteString getSubnetworkBytes() {
      java.lang.Object ref = subnetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subnetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional URL of the subnetwork to which all network endpoints in the NEG belong.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @param value The subnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      subnetwork_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional URL of the subnetwork to which all network endpoints in the NEG belong.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubnetwork() {
      subnetwork_ = getDefaultInstance().getSubnetwork();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional URL of the subnetwork to which all network endpoints in the NEG belong.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @param value The bytes for subnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      subnetwork_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private java.lang.Object zone_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the zone where the network endpoint group is located.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return Whether the zone field is set.
     */
    public boolean hasZone() {
      return ((bitField0_ & 0x00040000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the zone where the network endpoint group is located.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The zone.
     */
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the zone where the network endpoint group is located.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The bytes for zone.
     */
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the zone where the network endpoint group is located.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the zone where the network endpoint group is located.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the zone where the network endpoint group is located.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.NetworkEndpointGroup)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.NetworkEndpointGroup)
  private static final com.google.cloud.compute.v1.NetworkEndpointGroup DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.NetworkEndpointGroup();
  }

  public static com.google.cloud.compute.v1.NetworkEndpointGroup getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NetworkEndpointGroup> PARSER =
      new com.google.protobuf.AbstractParser<NetworkEndpointGroup>() {
        @java.lang.Override
        public NetworkEndpointGroup parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NetworkEndpointGroup> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NetworkEndpointGroup> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkEndpointGroup getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
