/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a Machine Type resource. You can use specific machine types for your VM instances based on performance and pricing requirements. For more information, read Machine Types.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.MachineType}
 */
public final class MachineType extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.MachineType)
    MachineTypeOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use MachineType.newBuilder() to construct.
  private MachineType(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MachineType() {
    accelerators_ = java.util.Collections.emptyList();
    architecture_ = "";
    creationTimestamp_ = "";
    description_ = "";
    kind_ = "";
    name_ = "";
    selfLink_ = "";
    zone_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MachineType();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_MachineType_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_MachineType_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.MachineType.class,
            com.google.cloud.compute.v1.MachineType.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The architecture of the machine type.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.MachineType.Architecture}
   */
  public enum Architecture implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ARCHITECTURE = 0;</code>
     */
    UNDEFINED_ARCHITECTURE(0),
    /**
     *
     *
     * <pre>
     * Default value indicating Architecture is not set.
     * </pre>
     *
     * <code>ARCHITECTURE_UNSPECIFIED = 394750507;</code>
     */
    ARCHITECTURE_UNSPECIFIED(394750507),
    /**
     *
     *
     * <pre>
     * Machines with architecture ARM64
     * </pre>
     *
     * <code>ARM64 = 62547450;</code>
     */
    ARM64(62547450),
    /**
     *
     *
     * <pre>
     * Machines with architecture X86_64
     * </pre>
     *
     * <code>X86_64 = 425300551;</code>
     */
    X86_64(425300551),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ARCHITECTURE = 0;</code>
     */
    public static final int UNDEFINED_ARCHITECTURE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Default value indicating Architecture is not set.
     * </pre>
     *
     * <code>ARCHITECTURE_UNSPECIFIED = 394750507;</code>
     */
    public static final int ARCHITECTURE_UNSPECIFIED_VALUE = 394750507;

    /**
     *
     *
     * <pre>
     * Machines with architecture ARM64
     * </pre>
     *
     * <code>ARM64 = 62547450;</code>
     */
    public static final int ARM64_VALUE = 62547450;

    /**
     *
     *
     * <pre>
     * Machines with architecture X86_64
     * </pre>
     *
     * <code>X86_64 = 425300551;</code>
     */
    public static final int X86_64_VALUE = 425300551;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Architecture valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Architecture forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ARCHITECTURE;
        case 394750507:
          return ARCHITECTURE_UNSPECIFIED;
        case 62547450:
          return ARM64;
        case 425300551:
          return X86_64;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Architecture> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Architecture> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Architecture>() {
          public Architecture findValueByNumber(int number) {
            return Architecture.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.MachineType.getDescriptor().getEnumTypes().get(0);
    }

    private static final Architecture[] VALUES = values();

    public static Architecture valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Architecture(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.MachineType.Architecture)
  }

  private int bitField0_;
  public static final int ACCELERATORS_FIELD_NUMBER = 269577064;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.Accelerators> accelerators_;

  /**
   *
   *
   * <pre>
   * [Output Only] A list of accelerator configurations assigned to this machine type.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.Accelerators> getAcceleratorsList() {
    return accelerators_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A list of accelerator configurations assigned to this machine type.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.AcceleratorsOrBuilder>
      getAcceleratorsOrBuilderList() {
    return accelerators_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A list of accelerator configurations assigned to this machine type.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
   */
  @java.lang.Override
  public int getAcceleratorsCount() {
    return accelerators_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A list of accelerator configurations assigned to this machine type.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Accelerators getAccelerators(int index) {
    return accelerators_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A list of accelerator configurations assigned to this machine type.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AcceleratorsOrBuilder getAcceleratorsOrBuilder(int index) {
    return accelerators_.get(index);
  }

  public static final int ARCHITECTURE_FIELD_NUMBER = 302803283;

  @SuppressWarnings("serial")
  private volatile java.lang.Object architecture_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The architecture of the machine type.
   * Check the Architecture enum for the list of possible values.
   * </pre>
   *
   * <code>optional string architecture = 302803283;</code>
   *
   * @return Whether the architecture field is set.
   */
  @java.lang.Override
  public boolean hasArchitecture() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The architecture of the machine type.
   * Check the Architecture enum for the list of possible values.
   * </pre>
   *
   * <code>optional string architecture = 302803283;</code>
   *
   * @return The architecture.
   */
  @java.lang.Override
  public java.lang.String getArchitecture() {
    java.lang.Object ref = architecture_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      architecture_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The architecture of the machine type.
   * Check the Architecture enum for the list of possible values.
   * </pre>
   *
   * <code>optional string architecture = 302803283;</code>
   *
   * @return The bytes for architecture.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getArchitectureBytes() {
    java.lang.Object ref = architecture_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      architecture_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPRECATED_FIELD_NUMBER = 515138995;
  private com.google.cloud.compute.v1.DeprecationStatus deprecated_;

  /**
   *
   *
   * <pre>
   * [Output Only] The deprecation status associated with this machine type. Only applicable if the machine type is unavailable.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
   *
   * @return Whether the deprecated field is set.
   */
  @java.lang.Override
  public boolean hasDeprecated() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The deprecation status associated with this machine type. Only applicable if the machine type is unavailable.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
   *
   * @return The deprecated.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DeprecationStatus getDeprecated() {
    return deprecated_ == null
        ? com.google.cloud.compute.v1.DeprecationStatus.getDefaultInstance()
        : deprecated_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The deprecation status associated with this machine type. Only applicable if the machine type is unavailable.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DeprecationStatusOrBuilder getDeprecatedOrBuilder() {
    return deprecated_ == null
        ? com.google.cloud.compute.v1.DeprecationStatus.getDefaultInstance()
        : deprecated_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] An optional textual description of the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] An optional textual description of the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] An optional textual description of the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GUEST_CPUS_FIELD_NUMBER = 393356754;
  private int guestCpus_ = 0;

  /**
   *
   *
   * <pre>
   * [Output Only] The number of virtual CPUs that are available to the instance.
   * </pre>
   *
   * <code>optional int32 guest_cpus = 393356754;</code>
   *
   * @return Whether the guestCpus field is set.
   */
  @java.lang.Override
  public boolean hasGuestCpus() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The number of virtual CPUs that are available to the instance.
   * </pre>
   *
   * <code>optional int32 guest_cpus = 393356754;</code>
   *
   * @return The guestCpus.
   */
  @java.lang.Override
  public int getGuestCpus() {
    return guestCpus_;
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int IMAGE_SPACE_GB_FIELD_NUMBER = 75331864;
  private int imageSpaceGb_ = 0;

  /**
   *
   *
   * <pre>
   * [Deprecated] This property is deprecated and will never be populated with any relevant values.
   * </pre>
   *
   * <code>optional int32 image_space_gb = 75331864;</code>
   *
   * @return Whether the imageSpaceGb field is set.
   */
  @java.lang.Override
  public boolean hasImageSpaceGb() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Deprecated] This property is deprecated and will never be populated with any relevant values.
   * </pre>
   *
   * <code>optional int32 image_space_gb = 75331864;</code>
   *
   * @return The imageSpaceGb.
   */
  @java.lang.Override
  public int getImageSpaceGb() {
    return imageSpaceGb_;
  }

  public static final int IS_SHARED_CPU_FIELD_NUMBER = 521399555;
  private boolean isSharedCpu_ = false;

  /**
   *
   *
   * <pre>
   * [Output Only] Whether this machine type has a shared CPU. See Shared-core machine types for more information.
   * </pre>
   *
   * <code>optional bool is_shared_cpu = 521399555;</code>
   *
   * @return Whether the isSharedCpu field is set.
   */
  @java.lang.Override
  public boolean hasIsSharedCpu() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Whether this machine type has a shared CPU. See Shared-core machine types for more information.
   * </pre>
   *
   * <code>optional bool is_shared_cpu = 521399555;</code>
   *
   * @return The isSharedCpu.
   */
  @java.lang.Override
  public boolean getIsSharedCpu() {
    return isSharedCpu_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The type of the resource. Always compute#machineType for machine types.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The type of the resource. Always compute#machineType for machine types.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The type of the resource. Always compute#machineType for machine types.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAXIMUM_PERSISTENT_DISKS_FIELD_NUMBER = 496220941;
  private int maximumPersistentDisks_ = 0;

  /**
   *
   *
   * <pre>
   * [Output Only] Maximum persistent disks allowed.
   * </pre>
   *
   * <code>optional int32 maximum_persistent_disks = 496220941;</code>
   *
   * @return Whether the maximumPersistentDisks field is set.
   */
  @java.lang.Override
  public boolean hasMaximumPersistentDisks() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Maximum persistent disks allowed.
   * </pre>
   *
   * <code>optional int32 maximum_persistent_disks = 496220941;</code>
   *
   * @return The maximumPersistentDisks.
   */
  @java.lang.Override
  public int getMaximumPersistentDisks() {
    return maximumPersistentDisks_;
  }

  public static final int MAXIMUM_PERSISTENT_DISKS_SIZE_GB_FIELD_NUMBER = 154274471;
  private long maximumPersistentDisksSizeGb_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] Maximum total persistent disks size (GB) allowed.
   * </pre>
   *
   * <code>optional int64 maximum_persistent_disks_size_gb = 154274471;</code>
   *
   * @return Whether the maximumPersistentDisksSizeGb field is set.
   */
  @java.lang.Override
  public boolean hasMaximumPersistentDisksSizeGb() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Maximum total persistent disks size (GB) allowed.
   * </pre>
   *
   * <code>optional int64 maximum_persistent_disks_size_gb = 154274471;</code>
   *
   * @return The maximumPersistentDisksSizeGb.
   */
  @java.lang.Override
  public long getMaximumPersistentDisksSizeGb() {
    return maximumPersistentDisksSizeGb_;
  }

  public static final int MEMORY_MB_FIELD_NUMBER = 116001171;
  private int memoryMb_ = 0;

  /**
   *
   *
   * <pre>
   * [Output Only] The amount of physical memory available to the instance, defined in MB.
   * </pre>
   *
   * <code>optional int32 memory_mb = 116001171;</code>
   *
   * @return Whether the memoryMb field is set.
   */
  @java.lang.Override
  public boolean hasMemoryMb() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The amount of physical memory available to the instance, defined in MB.
   * </pre>
   *
   * <code>optional int32 memory_mb = 116001171;</code>
   *
   * @return The memoryMb.
   */
  @java.lang.Override
  public int getMemoryMb() {
    return memoryMb_;
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Name of the resource.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Name of the resource.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Name of the resource.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00002000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONE_FIELD_NUMBER = 3744684;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The name of the zone where the machine type resides, such as us-central1-a.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return Whether the zone field is set.
   */
  @java.lang.Override
  public boolean hasZone() {
    return ((bitField0_ & 0x00004000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The name of the zone where the machine type resides, such as us-central1-a.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The zone.
   */
  @java.lang.Override
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The name of the zone where the machine type resides, such as us-central1-a.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The bytes for zone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3744684, zone_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeInt32(75331864, imageSpaceGb_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeInt32(116001171, memoryMb_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeInt64(154274471, maximumPersistentDisksSizeGb_);
    }
    for (int i = 0; i < accelerators_.size(); i++) {
      output.writeMessage(269577064, accelerators_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 302803283, architecture_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt32(393356754, guestCpus_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeInt32(496220941, maximumPersistentDisks_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(515138995, getDeprecated());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeBool(521399555, isSharedCpu_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3744684, zone_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(75331864, imageSpaceGb_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(116001171, memoryMb_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              154274471, maximumPersistentDisksSizeGb_);
    }
    for (int i = 0; i < accelerators_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(269577064, accelerators_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(302803283, architecture_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(393356754, guestCpus_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              496220941, maximumPersistentDisks_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(515138995, getDeprecated());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(521399555, isSharedCpu_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.MachineType)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.MachineType other = (com.google.cloud.compute.v1.MachineType) obj;

    if (!getAcceleratorsList().equals(other.getAcceleratorsList())) return false;
    if (hasArchitecture() != other.hasArchitecture()) return false;
    if (hasArchitecture()) {
      if (!getArchitecture().equals(other.getArchitecture())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDeprecated() != other.hasDeprecated()) return false;
    if (hasDeprecated()) {
      if (!getDeprecated().equals(other.getDeprecated())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasGuestCpus() != other.hasGuestCpus()) return false;
    if (hasGuestCpus()) {
      if (getGuestCpus() != other.getGuestCpus()) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasImageSpaceGb() != other.hasImageSpaceGb()) return false;
    if (hasImageSpaceGb()) {
      if (getImageSpaceGb() != other.getImageSpaceGb()) return false;
    }
    if (hasIsSharedCpu() != other.hasIsSharedCpu()) return false;
    if (hasIsSharedCpu()) {
      if (getIsSharedCpu() != other.getIsSharedCpu()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasMaximumPersistentDisks() != other.hasMaximumPersistentDisks()) return false;
    if (hasMaximumPersistentDisks()) {
      if (getMaximumPersistentDisks() != other.getMaximumPersistentDisks()) return false;
    }
    if (hasMaximumPersistentDisksSizeGb() != other.hasMaximumPersistentDisksSizeGb()) return false;
    if (hasMaximumPersistentDisksSizeGb()) {
      if (getMaximumPersistentDisksSizeGb() != other.getMaximumPersistentDisksSizeGb())
        return false;
    }
    if (hasMemoryMb() != other.hasMemoryMb()) return false;
    if (hasMemoryMb()) {
      if (getMemoryMb() != other.getMemoryMb()) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasZone() != other.hasZone()) return false;
    if (hasZone()) {
      if (!getZone().equals(other.getZone())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAcceleratorsCount() > 0) {
      hash = (37 * hash) + ACCELERATORS_FIELD_NUMBER;
      hash = (53 * hash) + getAcceleratorsList().hashCode();
    }
    if (hasArchitecture()) {
      hash = (37 * hash) + ARCHITECTURE_FIELD_NUMBER;
      hash = (53 * hash) + getArchitecture().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDeprecated()) {
      hash = (37 * hash) + DEPRECATED_FIELD_NUMBER;
      hash = (53 * hash) + getDeprecated().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasGuestCpus()) {
      hash = (37 * hash) + GUEST_CPUS_FIELD_NUMBER;
      hash = (53 * hash) + getGuestCpus();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasImageSpaceGb()) {
      hash = (37 * hash) + IMAGE_SPACE_GB_FIELD_NUMBER;
      hash = (53 * hash) + getImageSpaceGb();
    }
    if (hasIsSharedCpu()) {
      hash = (37 * hash) + IS_SHARED_CPU_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsSharedCpu());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasMaximumPersistentDisks()) {
      hash = (37 * hash) + MAXIMUM_PERSISTENT_DISKS_FIELD_NUMBER;
      hash = (53 * hash) + getMaximumPersistentDisks();
    }
    if (hasMaximumPersistentDisksSizeGb()) {
      hash = (37 * hash) + MAXIMUM_PERSISTENT_DISKS_SIZE_GB_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaximumPersistentDisksSizeGb());
    }
    if (hasMemoryMb()) {
      hash = (37 * hash) + MEMORY_MB_FIELD_NUMBER;
      hash = (53 * hash) + getMemoryMb();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasZone()) {
      hash = (37 * hash) + ZONE_FIELD_NUMBER;
      hash = (53 * hash) + getZone().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.MachineType parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.MachineType parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.MachineType parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.MachineType parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.MachineType parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.MachineType parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.MachineType parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.MachineType parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.MachineType parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.MachineType parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.MachineType parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.MachineType parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.MachineType prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a Machine Type resource. You can use specific machine types for your VM instances based on performance and pricing requirements. For more information, read Machine Types.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.MachineType}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.MachineType)
      com.google.cloud.compute.v1.MachineTypeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_MachineType_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_MachineType_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.MachineType.class,
              com.google.cloud.compute.v1.MachineType.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.MachineType.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAcceleratorsFieldBuilder();
        getDeprecatedFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (acceleratorsBuilder_ == null) {
        accelerators_ = java.util.Collections.emptyList();
      } else {
        accelerators_ = null;
        acceleratorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      architecture_ = "";
      creationTimestamp_ = "";
      deprecated_ = null;
      if (deprecatedBuilder_ != null) {
        deprecatedBuilder_.dispose();
        deprecatedBuilder_ = null;
      }
      description_ = "";
      guestCpus_ = 0;
      id_ = 0L;
      imageSpaceGb_ = 0;
      isSharedCpu_ = false;
      kind_ = "";
      maximumPersistentDisks_ = 0;
      maximumPersistentDisksSizeGb_ = 0L;
      memoryMb_ = 0;
      name_ = "";
      selfLink_ = "";
      zone_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_MachineType_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.MachineType getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.MachineType.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.MachineType build() {
      com.google.cloud.compute.v1.MachineType result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.MachineType buildPartial() {
      com.google.cloud.compute.v1.MachineType result =
          new com.google.cloud.compute.v1.MachineType(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.MachineType result) {
      if (acceleratorsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          accelerators_ = java.util.Collections.unmodifiableList(accelerators_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.accelerators_ = accelerators_;
      } else {
        result.accelerators_ = acceleratorsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.MachineType result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.architecture_ = architecture_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.deprecated_ = deprecatedBuilder_ == null ? deprecated_ : deprecatedBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.guestCpus_ = guestCpus_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.imageSpaceGb_ = imageSpaceGb_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.isSharedCpu_ = isSharedCpu_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.maximumPersistentDisks_ = maximumPersistentDisks_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.maximumPersistentDisksSizeGb_ = maximumPersistentDisksSizeGb_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.memoryMb_ = memoryMb_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.zone_ = zone_;
        to_bitField0_ |= 0x00004000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.MachineType) {
        return mergeFrom((com.google.cloud.compute.v1.MachineType) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.MachineType other) {
      if (other == com.google.cloud.compute.v1.MachineType.getDefaultInstance()) return this;
      if (acceleratorsBuilder_ == null) {
        if (!other.accelerators_.isEmpty()) {
          if (accelerators_.isEmpty()) {
            accelerators_ = other.accelerators_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAcceleratorsIsMutable();
            accelerators_.addAll(other.accelerators_);
          }
          onChanged();
        }
      } else {
        if (!other.accelerators_.isEmpty()) {
          if (acceleratorsBuilder_.isEmpty()) {
            acceleratorsBuilder_.dispose();
            acceleratorsBuilder_ = null;
            accelerators_ = other.accelerators_;
            bitField0_ = (bitField0_ & ~0x00000001);
            acceleratorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAcceleratorsFieldBuilder()
                    : null;
          } else {
            acceleratorsBuilder_.addAllMessages(other.accelerators_);
          }
        }
      }
      if (other.hasArchitecture()) {
        architecture_ = other.architecture_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasDeprecated()) {
        mergeDeprecated(other.getDeprecated());
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasGuestCpus()) {
        setGuestCpus(other.getGuestCpus());
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasImageSpaceGb()) {
        setImageSpaceGb(other.getImageSpaceGb());
      }
      if (other.hasIsSharedCpu()) {
        setIsSharedCpu(other.getIsSharedCpu());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasMaximumPersistentDisks()) {
        setMaximumPersistentDisks(other.getMaximumPersistentDisks());
      }
      if (other.hasMaximumPersistentDisksSizeGb()) {
        setMaximumPersistentDisksSizeGb(other.getMaximumPersistentDisksSizeGb());
      }
      if (other.hasMemoryMb()) {
        setMemoryMb(other.getMemoryMb());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasZone()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 26989658
            case 29957474:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 29957474
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 244202930
            case 602654912:
              {
                imageSpaceGb_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 602654912
            case 928009368:
              {
                memoryMb_ = input.readInt32();
                bitField0_ |= 0x00001000;
                break;
              } // case 928009368
            case 1234195768:
              {
                maximumPersistentDisksSizeGb_ = input.readInt64();
                bitField0_ |= 0x00000800;
                break;
              } // case 1234195768
            case -2138350782:
              {
                com.google.cloud.compute.v1.Accelerators m =
                    input.readMessage(
                        com.google.cloud.compute.v1.Accelerators.parser(), extensionRegistry);
                if (acceleratorsBuilder_ == null) {
                  ensureAcceleratorsIsMutable();
                  accelerators_.add(m);
                } else {
                  acceleratorsBuilder_.addMessage(m);
                }
                break;
              } // case -2138350782
            case -1872541030:
              {
                architecture_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -1872541030
            case -1148113264:
              {
                guestCpus_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case -1148113264
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -911466526
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case -645248918
            case -325199768:
              {
                maximumPersistentDisks_ = input.readInt32();
                bitField0_ |= 0x00000400;
                break;
              } // case -325199768
            case -173855334:
              {
                input.readMessage(getDeprecatedFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case -173855334
            case -123770856:
              {
                isSharedCpu_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case -123770856
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.compute.v1.Accelerators> accelerators_ =
        java.util.Collections.emptyList();

    private void ensureAcceleratorsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        accelerators_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.Accelerators>(accelerators_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Accelerators,
            com.google.cloud.compute.v1.Accelerators.Builder,
            com.google.cloud.compute.v1.AcceleratorsOrBuilder>
        acceleratorsBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] A list of accelerator configurations assigned to this machine type.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Accelerators> getAcceleratorsList() {
      if (acceleratorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(accelerators_);
      } else {
        return acceleratorsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of accelerator configurations assigned to this machine type.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
     */
    public int getAcceleratorsCount() {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.size();
      } else {
        return acceleratorsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of accelerator configurations assigned to this machine type.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
     */
    public com.google.cloud.compute.v1.Accelerators getAccelerators(int index) {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.get(index);
      } else {
        return acceleratorsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of accelerator configurations assigned to this machine type.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
     */
    public Builder setAccelerators(int index, com.google.cloud.compute.v1.Accelerators value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.set(index, value);
        onChanged();
      } else {
        acceleratorsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of accelerator configurations assigned to this machine type.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
     */
    public Builder setAccelerators(
        int index, com.google.cloud.compute.v1.Accelerators.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.set(index, builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of accelerator configurations assigned to this machine type.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
     */
    public Builder addAccelerators(com.google.cloud.compute.v1.Accelerators value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.add(value);
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of accelerator configurations assigned to this machine type.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
     */
    public Builder addAccelerators(int index, com.google.cloud.compute.v1.Accelerators value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.add(index, value);
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of accelerator configurations assigned to this machine type.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
     */
    public Builder addAccelerators(
        com.google.cloud.compute.v1.Accelerators.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.add(builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of accelerator configurations assigned to this machine type.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
     */
    public Builder addAccelerators(
        int index, com.google.cloud.compute.v1.Accelerators.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.add(index, builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of accelerator configurations assigned to this machine type.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
     */
    public Builder addAllAccelerators(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.Accelerators> values) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, accelerators_);
        onChanged();
      } else {
        acceleratorsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of accelerator configurations assigned to this machine type.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
     */
    public Builder clearAccelerators() {
      if (acceleratorsBuilder_ == null) {
        accelerators_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        acceleratorsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of accelerator configurations assigned to this machine type.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
     */
    public Builder removeAccelerators(int index) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.remove(index);
        onChanged();
      } else {
        acceleratorsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of accelerator configurations assigned to this machine type.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
     */
    public com.google.cloud.compute.v1.Accelerators.Builder getAcceleratorsBuilder(int index) {
      return getAcceleratorsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of accelerator configurations assigned to this machine type.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
     */
    public com.google.cloud.compute.v1.AcceleratorsOrBuilder getAcceleratorsOrBuilder(int index) {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.get(index);
      } else {
        return acceleratorsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of accelerator configurations assigned to this machine type.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.AcceleratorsOrBuilder>
        getAcceleratorsOrBuilderList() {
      if (acceleratorsBuilder_ != null) {
        return acceleratorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(accelerators_);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of accelerator configurations assigned to this machine type.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
     */
    public com.google.cloud.compute.v1.Accelerators.Builder addAcceleratorsBuilder() {
      return getAcceleratorsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.Accelerators.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of accelerator configurations assigned to this machine type.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
     */
    public com.google.cloud.compute.v1.Accelerators.Builder addAcceleratorsBuilder(int index) {
      return getAcceleratorsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.Accelerators.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A list of accelerator configurations assigned to this machine type.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Accelerators accelerators = 269577064;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Accelerators.Builder>
        getAcceleratorsBuilderList() {
      return getAcceleratorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Accelerators,
            com.google.cloud.compute.v1.Accelerators.Builder,
            com.google.cloud.compute.v1.AcceleratorsOrBuilder>
        getAcceleratorsFieldBuilder() {
      if (acceleratorsBuilder_ == null) {
        acceleratorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.Accelerators,
                com.google.cloud.compute.v1.Accelerators.Builder,
                com.google.cloud.compute.v1.AcceleratorsOrBuilder>(
                accelerators_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        accelerators_ = null;
      }
      return acceleratorsBuilder_;
    }

    private java.lang.Object architecture_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the machine type.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return Whether the architecture field is set.
     */
    public boolean hasArchitecture() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the machine type.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return The architecture.
     */
    public java.lang.String getArchitecture() {
      java.lang.Object ref = architecture_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        architecture_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the machine type.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return The bytes for architecture.
     */
    public com.google.protobuf.ByteString getArchitectureBytes() {
      java.lang.Object ref = architecture_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        architecture_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the machine type.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @param value The architecture to set.
     * @return This builder for chaining.
     */
    public Builder setArchitecture(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      architecture_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the machine type.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArchitecture() {
      architecture_ = getDefaultInstance().getArchitecture();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the machine type.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @param value The bytes for architecture to set.
     * @return This builder for chaining.
     */
    public Builder setArchitectureBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      architecture_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.DeprecationStatus deprecated_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.DeprecationStatus,
            com.google.cloud.compute.v1.DeprecationStatus.Builder,
            com.google.cloud.compute.v1.DeprecationStatusOrBuilder>
        deprecatedBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] The deprecation status associated with this machine type. Only applicable if the machine type is unavailable.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     *
     * @return Whether the deprecated field is set.
     */
    public boolean hasDeprecated() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The deprecation status associated with this machine type. Only applicable if the machine type is unavailable.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     *
     * @return The deprecated.
     */
    public com.google.cloud.compute.v1.DeprecationStatus getDeprecated() {
      if (deprecatedBuilder_ == null) {
        return deprecated_ == null
            ? com.google.cloud.compute.v1.DeprecationStatus.getDefaultInstance()
            : deprecated_;
      } else {
        return deprecatedBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The deprecation status associated with this machine type. Only applicable if the machine type is unavailable.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     */
    public Builder setDeprecated(com.google.cloud.compute.v1.DeprecationStatus value) {
      if (deprecatedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deprecated_ = value;
      } else {
        deprecatedBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The deprecation status associated with this machine type. Only applicable if the machine type is unavailable.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     */
    public Builder setDeprecated(
        com.google.cloud.compute.v1.DeprecationStatus.Builder builderForValue) {
      if (deprecatedBuilder_ == null) {
        deprecated_ = builderForValue.build();
      } else {
        deprecatedBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The deprecation status associated with this machine type. Only applicable if the machine type is unavailable.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     */
    public Builder mergeDeprecated(com.google.cloud.compute.v1.DeprecationStatus value) {
      if (deprecatedBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && deprecated_ != null
            && deprecated_ != com.google.cloud.compute.v1.DeprecationStatus.getDefaultInstance()) {
          getDeprecatedBuilder().mergeFrom(value);
        } else {
          deprecated_ = value;
        }
      } else {
        deprecatedBuilder_.mergeFrom(value);
      }
      if (deprecated_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The deprecation status associated with this machine type. Only applicable if the machine type is unavailable.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     */
    public Builder clearDeprecated() {
      bitField0_ = (bitField0_ & ~0x00000008);
      deprecated_ = null;
      if (deprecatedBuilder_ != null) {
        deprecatedBuilder_.dispose();
        deprecatedBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The deprecation status associated with this machine type. Only applicable if the machine type is unavailable.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     */
    public com.google.cloud.compute.v1.DeprecationStatus.Builder getDeprecatedBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getDeprecatedFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The deprecation status associated with this machine type. Only applicable if the machine type is unavailable.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     */
    public com.google.cloud.compute.v1.DeprecationStatusOrBuilder getDeprecatedOrBuilder() {
      if (deprecatedBuilder_ != null) {
        return deprecatedBuilder_.getMessageOrBuilder();
      } else {
        return deprecated_ == null
            ? com.google.cloud.compute.v1.DeprecationStatus.getDefaultInstance()
            : deprecated_;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The deprecation status associated with this machine type. Only applicable if the machine type is unavailable.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.DeprecationStatus,
            com.google.cloud.compute.v1.DeprecationStatus.Builder,
            com.google.cloud.compute.v1.DeprecationStatusOrBuilder>
        getDeprecatedFieldBuilder() {
      if (deprecatedBuilder_ == null) {
        deprecatedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.DeprecationStatus,
                com.google.cloud.compute.v1.DeprecationStatus.Builder,
                com.google.cloud.compute.v1.DeprecationStatusOrBuilder>(
                getDeprecated(), getParentForChildren(), isClean());
        deprecated_ = null;
      }
      return deprecatedBuilder_;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] An optional textual description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional textual description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional textual description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional textual description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional textual description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] An optional textual description of the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int guestCpus_;

    /**
     *
     *
     * <pre>
     * [Output Only] The number of virtual CPUs that are available to the instance.
     * </pre>
     *
     * <code>optional int32 guest_cpus = 393356754;</code>
     *
     * @return Whether the guestCpus field is set.
     */
    @java.lang.Override
    public boolean hasGuestCpus() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The number of virtual CPUs that are available to the instance.
     * </pre>
     *
     * <code>optional int32 guest_cpus = 393356754;</code>
     *
     * @return The guestCpus.
     */
    @java.lang.Override
    public int getGuestCpus() {
      return guestCpus_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The number of virtual CPUs that are available to the instance.
     * </pre>
     *
     * <code>optional int32 guest_cpus = 393356754;</code>
     *
     * @param value The guestCpus to set.
     * @return This builder for chaining.
     */
    public Builder setGuestCpus(int value) {

      guestCpus_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The number of virtual CPUs that are available to the instance.
     * </pre>
     *
     * <code>optional int32 guest_cpus = 393356754;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGuestCpus() {
      bitField0_ = (bitField0_ & ~0x00000020);
      guestCpus_ = 0;
      onChanged();
      return this;
    }

    private long id_;

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000040);
      id_ = 0L;
      onChanged();
      return this;
    }

    private int imageSpaceGb_;

    /**
     *
     *
     * <pre>
     * [Deprecated] This property is deprecated and will never be populated with any relevant values.
     * </pre>
     *
     * <code>optional int32 image_space_gb = 75331864;</code>
     *
     * @return Whether the imageSpaceGb field is set.
     */
    @java.lang.Override
    public boolean hasImageSpaceGb() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Deprecated] This property is deprecated and will never be populated with any relevant values.
     * </pre>
     *
     * <code>optional int32 image_space_gb = 75331864;</code>
     *
     * @return The imageSpaceGb.
     */
    @java.lang.Override
    public int getImageSpaceGb() {
      return imageSpaceGb_;
    }

    /**
     *
     *
     * <pre>
     * [Deprecated] This property is deprecated and will never be populated with any relevant values.
     * </pre>
     *
     * <code>optional int32 image_space_gb = 75331864;</code>
     *
     * @param value The imageSpaceGb to set.
     * @return This builder for chaining.
     */
    public Builder setImageSpaceGb(int value) {

      imageSpaceGb_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Deprecated] This property is deprecated and will never be populated with any relevant values.
     * </pre>
     *
     * <code>optional int32 image_space_gb = 75331864;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImageSpaceGb() {
      bitField0_ = (bitField0_ & ~0x00000080);
      imageSpaceGb_ = 0;
      onChanged();
      return this;
    }

    private boolean isSharedCpu_;

    /**
     *
     *
     * <pre>
     * [Output Only] Whether this machine type has a shared CPU. See Shared-core machine types for more information.
     * </pre>
     *
     * <code>optional bool is_shared_cpu = 521399555;</code>
     *
     * @return Whether the isSharedCpu field is set.
     */
    @java.lang.Override
    public boolean hasIsSharedCpu() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Whether this machine type has a shared CPU. See Shared-core machine types for more information.
     * </pre>
     *
     * <code>optional bool is_shared_cpu = 521399555;</code>
     *
     * @return The isSharedCpu.
     */
    @java.lang.Override
    public boolean getIsSharedCpu() {
      return isSharedCpu_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Whether this machine type has a shared CPU. See Shared-core machine types for more information.
     * </pre>
     *
     * <code>optional bool is_shared_cpu = 521399555;</code>
     *
     * @param value The isSharedCpu to set.
     * @return This builder for chaining.
     */
    public Builder setIsSharedCpu(boolean value) {

      isSharedCpu_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Whether this machine type has a shared CPU. See Shared-core machine types for more information.
     * </pre>
     *
     * <code>optional bool is_shared_cpu = 521399555;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsSharedCpu() {
      bitField0_ = (bitField0_ & ~0x00000100);
      isSharedCpu_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The type of the resource. Always compute#machineType for machine types.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The type of the resource. Always compute#machineType for machine types.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The type of the resource. Always compute#machineType for machine types.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The type of the resource. Always compute#machineType for machine types.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The type of the resource. Always compute#machineType for machine types.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The type of the resource. Always compute#machineType for machine types.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private int maximumPersistentDisks_;

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum persistent disks allowed.
     * </pre>
     *
     * <code>optional int32 maximum_persistent_disks = 496220941;</code>
     *
     * @return Whether the maximumPersistentDisks field is set.
     */
    @java.lang.Override
    public boolean hasMaximumPersistentDisks() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum persistent disks allowed.
     * </pre>
     *
     * <code>optional int32 maximum_persistent_disks = 496220941;</code>
     *
     * @return The maximumPersistentDisks.
     */
    @java.lang.Override
    public int getMaximumPersistentDisks() {
      return maximumPersistentDisks_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum persistent disks allowed.
     * </pre>
     *
     * <code>optional int32 maximum_persistent_disks = 496220941;</code>
     *
     * @param value The maximumPersistentDisks to set.
     * @return This builder for chaining.
     */
    public Builder setMaximumPersistentDisks(int value) {

      maximumPersistentDisks_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum persistent disks allowed.
     * </pre>
     *
     * <code>optional int32 maximum_persistent_disks = 496220941;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaximumPersistentDisks() {
      bitField0_ = (bitField0_ & ~0x00000400);
      maximumPersistentDisks_ = 0;
      onChanged();
      return this;
    }

    private long maximumPersistentDisksSizeGb_;

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum total persistent disks size (GB) allowed.
     * </pre>
     *
     * <code>optional int64 maximum_persistent_disks_size_gb = 154274471;</code>
     *
     * @return Whether the maximumPersistentDisksSizeGb field is set.
     */
    @java.lang.Override
    public boolean hasMaximumPersistentDisksSizeGb() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum total persistent disks size (GB) allowed.
     * </pre>
     *
     * <code>optional int64 maximum_persistent_disks_size_gb = 154274471;</code>
     *
     * @return The maximumPersistentDisksSizeGb.
     */
    @java.lang.Override
    public long getMaximumPersistentDisksSizeGb() {
      return maximumPersistentDisksSizeGb_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum total persistent disks size (GB) allowed.
     * </pre>
     *
     * <code>optional int64 maximum_persistent_disks_size_gb = 154274471;</code>
     *
     * @param value The maximumPersistentDisksSizeGb to set.
     * @return This builder for chaining.
     */
    public Builder setMaximumPersistentDisksSizeGb(long value) {

      maximumPersistentDisksSizeGb_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Maximum total persistent disks size (GB) allowed.
     * </pre>
     *
     * <code>optional int64 maximum_persistent_disks_size_gb = 154274471;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaximumPersistentDisksSizeGb() {
      bitField0_ = (bitField0_ & ~0x00000800);
      maximumPersistentDisksSizeGb_ = 0L;
      onChanged();
      return this;
    }

    private int memoryMb_;

    /**
     *
     *
     * <pre>
     * [Output Only] The amount of physical memory available to the instance, defined in MB.
     * </pre>
     *
     * <code>optional int32 memory_mb = 116001171;</code>
     *
     * @return Whether the memoryMb field is set.
     */
    @java.lang.Override
    public boolean hasMemoryMb() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The amount of physical memory available to the instance, defined in MB.
     * </pre>
     *
     * <code>optional int32 memory_mb = 116001171;</code>
     *
     * @return The memoryMb.
     */
    @java.lang.Override
    public int getMemoryMb() {
      return memoryMb_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The amount of physical memory available to the instance, defined in MB.
     * </pre>
     *
     * <code>optional int32 memory_mb = 116001171;</code>
     *
     * @param value The memoryMb to set.
     * @return This builder for chaining.
     */
    public Builder setMemoryMb(int value) {

      memoryMb_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The amount of physical memory available to the instance, defined in MB.
     * </pre>
     *
     * <code>optional int32 memory_mb = 116001171;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMemoryMb() {
      bitField0_ = (bitField0_ & ~0x00001000);
      memoryMb_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Name of the resource.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object zone_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The name of the zone where the machine type resides, such as us-central1-a.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return Whether the zone field is set.
     */
    public boolean hasZone() {
      return ((bitField0_ & 0x00008000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The name of the zone where the machine type resides, such as us-central1-a.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The zone.
     */
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The name of the zone where the machine type resides, such as us-central1-a.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The bytes for zone.
     */
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The name of the zone where the machine type resides, such as us-central1-a.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The name of the zone where the machine type resides, such as us-central1-a.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The name of the zone where the machine type resides, such as us-central1-a.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.MachineType)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.MachineType)
  private static final com.google.cloud.compute.v1.MachineType DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.MachineType();
  }

  public static com.google.cloud.compute.v1.MachineType getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MachineType> PARSER =
      new com.google.protobuf.AbstractParser<MachineType>() {
        @java.lang.Override
        public MachineType parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MachineType> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MachineType> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.MachineType getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
