/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

public interface MachineImageOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.compute.v1.MachineImage)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * [Output Only] The creation timestamp for this machine image in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  boolean hasCreationTimestamp();

  /**
   *
   *
   * <pre>
   * [Output Only] The creation timestamp for this machine image in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  java.lang.String getCreationTimestamp();

  /**
   *
   *
   * <pre>
   * [Output Only] The creation timestamp for this machine image in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  com.google.protobuf.ByteString getCreationTimestampBytes();

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  boolean hasDescription();

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * [Input Only] Whether to attempt an application consistent machine image by informing the OS to prepare for the snapshot process.
   * </pre>
   *
   * <code>optional bool guest_flush = 385550813;</code>
   *
   * @return Whether the guestFlush field is set.
   */
  boolean hasGuestFlush();

  /**
   *
   *
   * <pre>
   * [Input Only] Whether to attempt an application consistent machine image by informing the OS to prepare for the snapshot process.
   * </pre>
   *
   * <code>optional bool guest_flush = 385550813;</code>
   *
   * @return The guestFlush.
   */
  boolean getGuestFlush();

  /**
   *
   *
   * <pre>
   * [Output Only] A unique identifier for this machine image. The server defines this identifier.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  boolean hasId();

  /**
   *
   *
   * <pre>
   * [Output Only] A unique identifier for this machine image. The server defines this identifier.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  long getId();

  /**
   *
   *
   * <pre>
   * [Output Only] Properties of source instance
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
   * </code>
   *
   * @return Whether the instanceProperties field is set.
   */
  boolean hasInstanceProperties();

  /**
   *
   *
   * <pre>
   * [Output Only] Properties of source instance
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
   * </code>
   *
   * @return The instanceProperties.
   */
  com.google.cloud.compute.v1.InstanceProperties getInstanceProperties();

  /**
   *
   *
   * <pre>
   * [Output Only] Properties of source instance
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InstanceProperties instance_properties = 215355165;
   * </code>
   */
  com.google.cloud.compute.v1.InstancePropertiesOrBuilder getInstancePropertiesOrBuilder();

  /**
   *
   *
   * <pre>
   * [Output Only] The resource type, which is always compute#machineImage for machine image.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  boolean hasKind();

  /**
   *
   *
   * <pre>
   * [Output Only] The resource type, which is always compute#machineImage for machine image.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  java.lang.String getKind();

  /**
   *
   *
   * <pre>
   * [Output Only] The resource type, which is always compute#machineImage for machine image.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  com.google.protobuf.ByteString getKindBytes();

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this machine image, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the machine image.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return Whether the labelFingerprint field is set.
   */
  boolean hasLabelFingerprint();

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this machine image, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the machine image.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The labelFingerprint.
   */
  java.lang.String getLabelFingerprint();

  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this machine image, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels. To see the latest fingerprint, make get() request to the machine image.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The bytes for labelFingerprint.
   */
  com.google.protobuf.ByteString getLabelFingerprintBytes();

  /**
   *
   *
   * <pre>
   * Labels to apply to this machine image. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  int getLabelsCount();

  /**
   *
   *
   * <pre>
   * Labels to apply to this machine image. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  boolean containsLabels(java.lang.String key);

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();

  /**
   *
   *
   * <pre>
   * Labels to apply to this machine image. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();

  /**
   *
   *
   * <pre>
   * Labels to apply to this machine image. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);

  /**
   *
   *
   * <pre>
   * Labels to apply to this machine image. These can be later modified by the setLabels method.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Encrypts the machine image using a customer-supplied encryption key. After you encrypt a machine image using a customer-supplied key, you must provide the same key if you use the machine image later. For example, you must provide the encryption key when you create an instance from the encrypted machine image in a future request. Customer-supplied encryption keys do not protect access to metadata of the machine image. If you do not provide an encryption key when creating the machine image, then the machine image will be encrypted using an automatically generated key and you do not need to provide a key to use the machine image later.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey machine_image_encryption_key = 528089087;
   * </code>
   *
   * @return Whether the machineImageEncryptionKey field is set.
   */
  boolean hasMachineImageEncryptionKey();

  /**
   *
   *
   * <pre>
   * Encrypts the machine image using a customer-supplied encryption key. After you encrypt a machine image using a customer-supplied key, you must provide the same key if you use the machine image later. For example, you must provide the encryption key when you create an instance from the encrypted machine image in a future request. Customer-supplied encryption keys do not protect access to metadata of the machine image. If you do not provide an encryption key when creating the machine image, then the machine image will be encrypted using an automatically generated key and you do not need to provide a key to use the machine image later.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey machine_image_encryption_key = 528089087;
   * </code>
   *
   * @return The machineImageEncryptionKey.
   */
  com.google.cloud.compute.v1.CustomerEncryptionKey getMachineImageEncryptionKey();

  /**
   *
   *
   * <pre>
   * Encrypts the machine image using a customer-supplied encryption key. After you encrypt a machine image using a customer-supplied key, you must provide the same key if you use the machine image later. For example, you must provide the encryption key when you create an instance from the encrypted machine image in a future request. Customer-supplied encryption keys do not protect access to metadata of the machine image. If you do not provide an encryption key when creating the machine image, then the machine image will be encrypted using an automatically generated key and you do not need to provide a key to use the machine image later.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey machine_image_encryption_key = 528089087;
   * </code>
   */
  com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
      getMachineImageEncryptionKeyOrBuilder();

  /**
   *
   *
   * <pre>
   * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  boolean hasName();

  /**
   *
   *
   * <pre>
   * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzi = 480964257;</code>
   *
   * @return Whether the satisfiesPzi field is set.
   */
  boolean hasSatisfiesPzi();

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzi = 480964257;</code>
   *
   * @return The satisfiesPzi.
   */
  boolean getSatisfiesPzi();

  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return Whether the satisfiesPzs field is set.
   */
  boolean hasSatisfiesPzs();

  /**
   *
   *
   * <pre>
   * [Output Only] Reserved for future use.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return The satisfiesPzs.
   */
  boolean getSatisfiesPzs();

  /**
   *
   *
   * <pre>
   * An array of Machine Image specific properties for disks attached to the source instance
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
   */
  java.util.List<com.google.cloud.compute.v1.SavedDisk> getSavedDisksList();

  /**
   *
   *
   * <pre>
   * An array of Machine Image specific properties for disks attached to the source instance
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
   */
  com.google.cloud.compute.v1.SavedDisk getSavedDisks(int index);

  /**
   *
   *
   * <pre>
   * An array of Machine Image specific properties for disks attached to the source instance
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
   */
  int getSavedDisksCount();

  /**
   *
   *
   * <pre>
   * An array of Machine Image specific properties for disks attached to the source instance
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
   */
  java.util.List<? extends com.google.cloud.compute.v1.SavedDiskOrBuilder>
      getSavedDisksOrBuilderList();

  /**
   *
   *
   * <pre>
   * An array of Machine Image specific properties for disks attached to the source instance
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.SavedDisk saved_disks = 397424318;</code>
   */
  com.google.cloud.compute.v1.SavedDiskOrBuilder getSavedDisksOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * [Output Only] The URL for this machine image. The server defines this URL.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  boolean hasSelfLink();

  /**
   *
   *
   * <pre>
   * [Output Only] The URL for this machine image. The server defines this URL.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  java.lang.String getSelfLink();

  /**
   *
   *
   * <pre>
   * [Output Only] The URL for this machine image. The server defines this URL.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  com.google.protobuf.ByteString getSelfLinkBytes();

  /**
   *
   *
   * <pre>
   * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
   * </code>
   */
  java.util.List<com.google.cloud.compute.v1.SourceDiskEncryptionKey>
      getSourceDiskEncryptionKeysList();

  /**
   *
   *
   * <pre>
   * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
   * </code>
   */
  com.google.cloud.compute.v1.SourceDiskEncryptionKey getSourceDiskEncryptionKeys(int index);

  /**
   *
   *
   * <pre>
   * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
   * </code>
   */
  int getSourceDiskEncryptionKeysCount();

  /**
   *
   *
   * <pre>
   * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
   * </code>
   */
  java.util.List<? extends com.google.cloud.compute.v1.SourceDiskEncryptionKeyOrBuilder>
      getSourceDiskEncryptionKeysOrBuilderList();

  /**
   *
   *
   * <pre>
   * [Input Only] The customer-supplied encryption key of the disks attached to the source instance. Required if the source disk is protected by a customer-supplied encryption key.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.SourceDiskEncryptionKey source_disk_encryption_keys = 370408498;
   * </code>
   */
  com.google.cloud.compute.v1.SourceDiskEncryptionKeyOrBuilder getSourceDiskEncryptionKeysOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * The source instance used to create the machine image. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instances/instance - projects/project/zones/zone/instances/instance
   * </pre>
   *
   * <code>optional string source_instance = 396315705;</code>
   *
   * @return Whether the sourceInstance field is set.
   */
  boolean hasSourceInstance();

  /**
   *
   *
   * <pre>
   * The source instance used to create the machine image. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instances/instance - projects/project/zones/zone/instances/instance
   * </pre>
   *
   * <code>optional string source_instance = 396315705;</code>
   *
   * @return The sourceInstance.
   */
  java.lang.String getSourceInstance();

  /**
   *
   *
   * <pre>
   * The source instance used to create the machine image. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instances/instance - projects/project/zones/zone/instances/instance
   * </pre>
   *
   * <code>optional string source_instance = 396315705;</code>
   *
   * @return The bytes for sourceInstance.
   */
  com.google.protobuf.ByteString getSourceInstanceBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] DEPRECATED: Please use instance_properties instead for source instance related properties. New properties will not be added to this field.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SourceInstanceProperties source_instance_properties = 475195641;
   * </code>
   *
   * @return Whether the sourceInstanceProperties field is set.
   */
  boolean hasSourceInstanceProperties();

  /**
   *
   *
   * <pre>
   * [Output Only] DEPRECATED: Please use instance_properties instead for source instance related properties. New properties will not be added to this field.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SourceInstanceProperties source_instance_properties = 475195641;
   * </code>
   *
   * @return The sourceInstanceProperties.
   */
  com.google.cloud.compute.v1.SourceInstanceProperties getSourceInstanceProperties();

  /**
   *
   *
   * <pre>
   * [Output Only] DEPRECATED: Please use instance_properties instead for source instance related properties. New properties will not be added to this field.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.SourceInstanceProperties source_instance_properties = 475195641;
   * </code>
   */
  com.google.cloud.compute.v1.SourceInstancePropertiesOrBuilder
      getSourceInstancePropertiesOrBuilder();

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the machine image. One of the following values: INVALID, CREATING, READY, DELETING, and UPLOADING.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  boolean hasStatus();

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the machine image. One of the following values: INVALID, CREATING, READY, DELETING, and UPLOADING.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  java.lang.String getStatus();

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the machine image. One of the following values: INVALID, CREATING, READY, DELETING, and UPLOADING.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  com.google.protobuf.ByteString getStatusBytes();

  /**
   *
   *
   * <pre>
   * The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
   * </pre>
   *
   * <code>repeated string storage_locations = 328005274;</code>
   *
   * @return A list containing the storageLocations.
   */
  java.util.List<java.lang.String> getStorageLocationsList();

  /**
   *
   *
   * <pre>
   * The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
   * </pre>
   *
   * <code>repeated string storage_locations = 328005274;</code>
   *
   * @return The count of storageLocations.
   */
  int getStorageLocationsCount();

  /**
   *
   *
   * <pre>
   * The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
   * </pre>
   *
   * <code>repeated string storage_locations = 328005274;</code>
   *
   * @param index The index of the element to return.
   * @return The storageLocations at the given index.
   */
  java.lang.String getStorageLocations(int index);

  /**
   *
   *
   * <pre>
   * The regional or multi-regional Cloud Storage bucket location where the machine image is stored.
   * </pre>
   *
   * <code>repeated string storage_locations = 328005274;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the storageLocations at the given index.
   */
  com.google.protobuf.ByteString getStorageLocationsBytes(int index);

  /**
   *
   *
   * <pre>
   * [Output Only] Total size of the storage used by the machine image.
   * </pre>
   *
   * <code>optional int64 total_storage_bytes = 81855468;</code>
   *
   * @return Whether the totalStorageBytes field is set.
   */
  boolean hasTotalStorageBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Total size of the storage used by the machine image.
   * </pre>
   *
   * <code>optional int64 total_storage_bytes = 81855468;</code>
   *
   * @return The totalStorageBytes.
   */
  long getTotalStorageBytes();
}
