/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a License resource. A License represents billing and aggregate usage data for public and marketplace images. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.License}
 */
public final class License extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.License)
    LicenseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use License.newBuilder() to construct.
  private License(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private License() {
    allowedReplacementLicenses_ = com.google.protobuf.LazyStringArrayList.emptyList();
    creationTimestamp_ = "";
    description_ = "";
    incompatibleLicenses_ = com.google.protobuf.LazyStringArrayList.emptyList();
    kind_ = "";
    name_ = "";
    requiredCoattachedLicenses_ = com.google.protobuf.LazyStringArrayList.emptyList();
    selfLink_ = "";
    selfLinkWithId_ = "";
    updateTimestamp_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new License();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_License_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_License_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.License.class,
            com.google.cloud.compute.v1.License.Builder.class);
  }

  private int bitField0_;
  public static final int ALLOWED_REPLACEMENT_LICENSES_FIELD_NUMBER = 195677718;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList allowedReplacementLicenses_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are allowed even if removable_from_disk is false.
   * </pre>
   *
   * <code>repeated string allowed_replacement_licenses = 195677718;</code>
   *
   * @return A list containing the allowedReplacementLicenses.
   */
  public com.google.protobuf.ProtocolStringList getAllowedReplacementLicensesList() {
    return allowedReplacementLicenses_;
  }

  /**
   *
   *
   * <pre>
   * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are allowed even if removable_from_disk is false.
   * </pre>
   *
   * <code>repeated string allowed_replacement_licenses = 195677718;</code>
   *
   * @return The count of allowedReplacementLicenses.
   */
  public int getAllowedReplacementLicensesCount() {
    return allowedReplacementLicenses_.size();
  }

  /**
   *
   *
   * <pre>
   * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are allowed even if removable_from_disk is false.
   * </pre>
   *
   * <code>repeated string allowed_replacement_licenses = 195677718;</code>
   *
   * @param index The index of the element to return.
   * @return The allowedReplacementLicenses at the given index.
   */
  public java.lang.String getAllowedReplacementLicenses(int index) {
    return allowedReplacementLicenses_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are allowed even if removable_from_disk is false.
   * </pre>
   *
   * <code>repeated string allowed_replacement_licenses = 195677718;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the allowedReplacementLicenses at the given index.
   */
  public com.google.protobuf.ByteString getAllowedReplacementLicensesBytes(int index) {
    return allowedReplacementLicenses_.getByteString(index);
  }

  public static final int APPENDABLE_TO_DISK_FIELD_NUMBER = 16959254;
  private boolean appendableToDisk_ = false;

  /**
   *
   *
   * <pre>
   * If true, this license can be appended to an existing disk's set of licenses.
   * </pre>
   *
   * <code>optional bool appendable_to_disk = 16959254;</code>
   *
   * @return Whether the appendableToDisk field is set.
   */
  @java.lang.Override
  public boolean hasAppendableToDisk() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * If true, this license can be appended to an existing disk's set of licenses.
   * </pre>
   *
   * <code>optional bool appendable_to_disk = 16959254;</code>
   *
   * @return The appendableToDisk.
   */
  @java.lang.Override
  public boolean getAppendableToDisk() {
    return appendableToDisk_;
  }

  public static final int CHARGES_USE_FEE_FIELD_NUMBER = 372412622;
  private boolean chargesUseFee_ = false;

  /**
   *
   *
   * <pre>
   * [Output Only] Deprecated. This field no longer reflects whether a license charges a usage fee.
   * </pre>
   *
   * <code>optional bool charges_use_fee = 372412622;</code>
   *
   * @return Whether the chargesUseFee field is set.
   */
  @java.lang.Override
  public boolean hasChargesUseFee() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Deprecated. This field no longer reflects whether a license charges a usage fee.
   * </pre>
   *
   * <code>optional bool charges_use_fee = 372412622;</code>
   *
   * @return The chargesUseFee.
   */
  @java.lang.Override
  public boolean getChargesUseFee() {
    return chargesUseFee_;
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional textual description of the resource; provided by the client when the resource is created.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional textual description of the resource; provided by the client when the resource is created.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional textual description of the resource; provided by the client when the resource is created.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int INCOMPATIBLE_LICENSES_FIELD_NUMBER = 334239768;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList incompatibleLicenses_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Specifies licenseCodes of licenses that are incompatible with this license. If a license is incompatible with this license, it cannot be attached to the same disk or image.
   * </pre>
   *
   * <code>repeated string incompatible_licenses = 334239768;</code>
   *
   * @return A list containing the incompatibleLicenses.
   */
  public com.google.protobuf.ProtocolStringList getIncompatibleLicensesList() {
    return incompatibleLicenses_;
  }

  /**
   *
   *
   * <pre>
   * Specifies licenseCodes of licenses that are incompatible with this license. If a license is incompatible with this license, it cannot be attached to the same disk or image.
   * </pre>
   *
   * <code>repeated string incompatible_licenses = 334239768;</code>
   *
   * @return The count of incompatibleLicenses.
   */
  public int getIncompatibleLicensesCount() {
    return incompatibleLicenses_.size();
  }

  /**
   *
   *
   * <pre>
   * Specifies licenseCodes of licenses that are incompatible with this license. If a license is incompatible with this license, it cannot be attached to the same disk or image.
   * </pre>
   *
   * <code>repeated string incompatible_licenses = 334239768;</code>
   *
   * @param index The index of the element to return.
   * @return The incompatibleLicenses at the given index.
   */
  public java.lang.String getIncompatibleLicenses(int index) {
    return incompatibleLicenses_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Specifies licenseCodes of licenses that are incompatible with this license. If a license is incompatible with this license, it cannot be attached to the same disk or image.
   * </pre>
   *
   * <code>repeated string incompatible_licenses = 334239768;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the incompatibleLicenses at the given index.
   */
  public com.google.protobuf.ByteString getIncompatibleLicensesBytes(int index) {
    return incompatibleLicenses_.getByteString(index);
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Type of resource. Always compute#license for licenses.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of resource. Always compute#license for licenses.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of resource. Always compute#license for licenses.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LICENSE_CODE_FIELD_NUMBER = 1467179;
  private long licenseCode_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] The unique code used to attach this license to images, snapshots, and disks.
   * </pre>
   *
   * <code>optional uint64 license_code = 1467179;</code>
   *
   * @return Whether the licenseCode field is set.
   */
  @java.lang.Override
  public boolean hasLicenseCode() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique code used to attach this license to images, snapshots, and disks.
   * </pre>
   *
   * <code>optional uint64 license_code = 1467179;</code>
   *
   * @return The licenseCode.
   */
  @java.lang.Override
  public long getLicenseCode() {
    return licenseCode_;
  }

  public static final int MINIMUM_RETENTION_FIELD_NUMBER = 155398189;
  private com.google.cloud.compute.v1.Duration minimumRetention_;

  /**
   *
   *
   * <pre>
   * If set, this license will be unable to be removed or replaced once attached to a disk until the minimum_retention period has passed.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration minimum_retention = 155398189;</code>
   *
   * @return Whether the minimumRetention field is set.
   */
  @java.lang.Override
  public boolean hasMinimumRetention() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * If set, this license will be unable to be removed or replaced once attached to a disk until the minimum_retention period has passed.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration minimum_retention = 155398189;</code>
   *
   * @return The minimumRetention.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Duration getMinimumRetention() {
    return minimumRetention_ == null
        ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
        : minimumRetention_;
  }

  /**
   *
   *
   * <pre>
   * If set, this license will be unable to be removed or replaced once attached to a disk until the minimum_retention period has passed.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration minimum_retention = 155398189;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DurationOrBuilder getMinimumRetentionOrBuilder() {
    return minimumRetention_ == null
        ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
        : minimumRetention_;
  }

  public static final int MULTI_TENANT_ONLY_FIELD_NUMBER = 274395163;
  private boolean multiTenantOnly_ = false;

  /**
   *
   *
   * <pre>
   * If true, this license can only be used on VMs on multi tenant nodes.
   * </pre>
   *
   * <code>optional bool multi_tenant_only = 274395163;</code>
   *
   * @return Whether the multiTenantOnly field is set.
   */
  @java.lang.Override
  public boolean hasMultiTenantOnly() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * If true, this license can only be used on VMs on multi tenant nodes.
   * </pre>
   *
   * <code>optional bool multi_tenant_only = 274395163;</code>
   *
   * @return The multiTenantOnly.
   */
  @java.lang.Override
  public boolean getMultiTenantOnly() {
    return multiTenantOnly_;
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Name of the resource. The name must be 1-63 characters long and comply with RFC1035.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * Name of the resource. The name must be 1-63 characters long and comply with RFC1035.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the resource. The name must be 1-63 characters long and comply with RFC1035.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OS_LICENSE_FIELD_NUMBER = 487986406;
  private boolean osLicense_ = false;

  /**
   *
   *
   * <pre>
   * If true, indicates this is an OS license. Only one OS license can be attached to a disk or image at a time.
   * </pre>
   *
   * <code>optional bool os_license = 487986406;</code>
   *
   * @return Whether the osLicense field is set.
   */
  @java.lang.Override
  public boolean hasOsLicense() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * If true, indicates this is an OS license. Only one OS license can be attached to a disk or image at a time.
   * </pre>
   *
   * <code>optional bool os_license = 487986406;</code>
   *
   * @return The osLicense.
   */
  @java.lang.Override
  public boolean getOsLicense() {
    return osLicense_;
  }

  public static final int REMOVABLE_FROM_DISK_FIELD_NUMBER = 25854638;
  private boolean removableFromDisk_ = false;

  /**
   *
   *
   * <pre>
   * If true, this license can be removed from a disk's set of licenses, with no replacement license needed.
   * </pre>
   *
   * <code>optional bool removable_from_disk = 25854638;</code>
   *
   * @return Whether the removableFromDisk field is set.
   */
  @java.lang.Override
  public boolean hasRemovableFromDisk() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * If true, this license can be removed from a disk's set of licenses, with no replacement license needed.
   * </pre>
   *
   * <code>optional bool removable_from_disk = 25854638;</code>
   *
   * @return The removableFromDisk.
   */
  @java.lang.Override
  public boolean getRemovableFromDisk() {
    return removableFromDisk_;
  }

  public static final int REQUIRED_COATTACHED_LICENSES_FIELD_NUMBER = 129195265;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList requiredCoattachedLicenses_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the coattachment requirement of this license. At least one license from the set must be attached to the same disk or image as this license.
   * </pre>
   *
   * <code>repeated string required_coattached_licenses = 129195265;</code>
   *
   * @return A list containing the requiredCoattachedLicenses.
   */
  public com.google.protobuf.ProtocolStringList getRequiredCoattachedLicensesList() {
    return requiredCoattachedLicenses_;
  }

  /**
   *
   *
   * <pre>
   * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the coattachment requirement of this license. At least one license from the set must be attached to the same disk or image as this license.
   * </pre>
   *
   * <code>repeated string required_coattached_licenses = 129195265;</code>
   *
   * @return The count of requiredCoattachedLicenses.
   */
  public int getRequiredCoattachedLicensesCount() {
    return requiredCoattachedLicenses_.size();
  }

  /**
   *
   *
   * <pre>
   * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the coattachment requirement of this license. At least one license from the set must be attached to the same disk or image as this license.
   * </pre>
   *
   * <code>repeated string required_coattached_licenses = 129195265;</code>
   *
   * @param index The index of the element to return.
   * @return The requiredCoattachedLicenses at the given index.
   */
  public java.lang.String getRequiredCoattachedLicenses(int index) {
    return requiredCoattachedLicenses_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the coattachment requirement of this license. At least one license from the set must be attached to the same disk or image as this license.
   * </pre>
   *
   * <code>repeated string required_coattached_licenses = 129195265;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the requiredCoattachedLicenses at the given index.
   */
  public com.google.protobuf.ByteString getRequiredCoattachedLicensesBytes(int index) {
    return requiredCoattachedLicenses_.getByteString(index);
  }

  public static final int RESOURCE_REQUIREMENTS_FIELD_NUMBER = 214292769;
  private com.google.cloud.compute.v1.LicenseResourceRequirements resourceRequirements_;

  /**
   *
   *
   * <pre>
   * [Input Only] Deprecated.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.LicenseResourceRequirements resource_requirements = 214292769;
   * </code>
   *
   * @return Whether the resourceRequirements field is set.
   */
  @java.lang.Override
  public boolean hasResourceRequirements() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Input Only] Deprecated.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.LicenseResourceRequirements resource_requirements = 214292769;
   * </code>
   *
   * @return The resourceRequirements.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.LicenseResourceRequirements getResourceRequirements() {
    return resourceRequirements_ == null
        ? com.google.cloud.compute.v1.LicenseResourceRequirements.getDefaultInstance()
        : resourceRequirements_;
  }

  /**
   *
   *
   * <pre>
   * [Input Only] Deprecated.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.LicenseResourceRequirements resource_requirements = 214292769;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.LicenseResourceRequirementsOrBuilder
      getResourceRequirementsOrBuilder() {
    return resourceRequirements_ == null
        ? com.google.cloud.compute.v1.LicenseResourceRequirements.getDefaultInstance()
        : resourceRequirements_;
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00002000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_WITH_ID_FIELD_NUMBER = 44520962;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLinkWithId_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for this resource with the resource id.
   * </pre>
   *
   * <code>optional string self_link_with_id = 44520962;</code>
   *
   * @return Whether the selfLinkWithId field is set.
   */
  @java.lang.Override
  public boolean hasSelfLinkWithId() {
    return ((bitField0_ & 0x00004000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for this resource with the resource id.
   * </pre>
   *
   * <code>optional string self_link_with_id = 44520962;</code>
   *
   * @return The selfLinkWithId.
   */
  @java.lang.Override
  public java.lang.String getSelfLinkWithId() {
    java.lang.Object ref = selfLinkWithId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLinkWithId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for this resource with the resource id.
   * </pre>
   *
   * <code>optional string self_link_with_id = 44520962;</code>
   *
   * @return The bytes for selfLinkWithId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkWithIdBytes() {
    java.lang.Object ref = selfLinkWithId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLinkWithId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOLE_TENANT_ONLY_FIELD_NUMBER = 427525559;
  private boolean soleTenantOnly_ = false;

  /**
   *
   *
   * <pre>
   * If true, this license can only be used on VMs on sole tenant nodes.
   * </pre>
   *
   * <code>optional bool sole_tenant_only = 427525559;</code>
   *
   * @return Whether the soleTenantOnly field is set.
   */
  @java.lang.Override
  public boolean hasSoleTenantOnly() {
    return ((bitField0_ & 0x00008000) != 0);
  }

  /**
   *
   *
   * <pre>
   * If true, this license can only be used on VMs on sole tenant nodes.
   * </pre>
   *
   * <code>optional bool sole_tenant_only = 427525559;</code>
   *
   * @return The soleTenantOnly.
   */
  @java.lang.Override
  public boolean getSoleTenantOnly() {
    return soleTenantOnly_;
  }

  public static final int TRANSFERABLE_FIELD_NUMBER = 4349893;
  private boolean transferable_ = false;

  /**
   *
   *
   * <pre>
   * If false, licenses will not be copied from the source resource when creating an image from a disk, disk from snapshot, or snapshot from disk.
   * </pre>
   *
   * <code>optional bool transferable = 4349893;</code>
   *
   * @return Whether the transferable field is set.
   */
  @java.lang.Override
  public boolean hasTransferable() {
    return ((bitField0_ & 0x00010000) != 0);
  }

  /**
   *
   *
   * <pre>
   * If false, licenses will not be copied from the source resource when creating an image from a disk, disk from snapshot, or snapshot from disk.
   * </pre>
   *
   * <code>optional bool transferable = 4349893;</code>
   *
   * @return The transferable.
   */
  @java.lang.Override
  public boolean getTransferable() {
    return transferable_;
  }

  public static final int UPDATE_TIMESTAMP_FIELD_NUMBER = 120894752;

  @SuppressWarnings("serial")
  private volatile java.lang.Object updateTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Last update timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string update_timestamp = 120894752;</code>
   *
   * @return Whether the updateTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTimestamp() {
    return ((bitField0_ & 0x00020000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Last update timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string update_timestamp = 120894752;</code>
   *
   * @return The updateTimestamp.
   */
  @java.lang.Override
  public java.lang.String getUpdateTimestamp() {
    java.lang.Object ref = updateTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      updateTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Last update timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string update_timestamp = 120894752;</code>
   *
   * @return The bytes for updateTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUpdateTimestampBytes() {
    java.lang.Object ref = updateTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      updateTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeUInt64(1467179, licenseCode_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      output.writeBool(4349893, transferable_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(16959254, appendableToDisk_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeBool(25854638, removableFromDisk_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 44520962, selfLinkWithId_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 120894752, updateTimestamp_);
    }
    for (int i = 0; i < requiredCoattachedLicenses_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 129195265, requiredCoattachedLicenses_.getRaw(i));
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(155398189, getMinimumRetention());
    }
    for (int i = 0; i < allowedReplacementLicenses_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 195677718, allowedReplacementLicenses_.getRaw(i));
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeMessage(214292769, getResourceRequirements());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeBool(274395163, multiTenantOnly_);
    }
    for (int i = 0; i < incompatibleLicenses_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 334239768, incompatibleLicenses_.getRaw(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(372412622, chargesUseFee_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeBool(427525559, soleTenantOnly_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeBool(487986406, osLicense_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(1467179, licenseCode_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4349893, transferable_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(16959254, appendableToDisk_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(25854638, removableFromDisk_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(44520962, selfLinkWithId_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(120894752, updateTimestamp_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < requiredCoattachedLicenses_.size(); i++) {
        dataSize += computeStringSizeNoTag(requiredCoattachedLicenses_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getRequiredCoattachedLicensesList().size();
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              155398189, getMinimumRetention());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < allowedReplacementLicenses_.size(); i++) {
        dataSize += computeStringSizeNoTag(allowedReplacementLicenses_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getAllowedReplacementLicensesList().size();
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              214292769, getResourceRequirements());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(274395163, multiTenantOnly_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < incompatibleLicenses_.size(); i++) {
        dataSize += computeStringSizeNoTag(incompatibleLicenses_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getIncompatibleLicensesList().size();
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(372412622, chargesUseFee_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(427525559, soleTenantOnly_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(487986406, osLicense_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.License)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.License other = (com.google.cloud.compute.v1.License) obj;

    if (!getAllowedReplacementLicensesList().equals(other.getAllowedReplacementLicensesList()))
      return false;
    if (hasAppendableToDisk() != other.hasAppendableToDisk()) return false;
    if (hasAppendableToDisk()) {
      if (getAppendableToDisk() != other.getAppendableToDisk()) return false;
    }
    if (hasChargesUseFee() != other.hasChargesUseFee()) return false;
    if (hasChargesUseFee()) {
      if (getChargesUseFee() != other.getChargesUseFee()) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (!getIncompatibleLicensesList().equals(other.getIncompatibleLicensesList())) return false;
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasLicenseCode() != other.hasLicenseCode()) return false;
    if (hasLicenseCode()) {
      if (getLicenseCode() != other.getLicenseCode()) return false;
    }
    if (hasMinimumRetention() != other.hasMinimumRetention()) return false;
    if (hasMinimumRetention()) {
      if (!getMinimumRetention().equals(other.getMinimumRetention())) return false;
    }
    if (hasMultiTenantOnly() != other.hasMultiTenantOnly()) return false;
    if (hasMultiTenantOnly()) {
      if (getMultiTenantOnly() != other.getMultiTenantOnly()) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasOsLicense() != other.hasOsLicense()) return false;
    if (hasOsLicense()) {
      if (getOsLicense() != other.getOsLicense()) return false;
    }
    if (hasRemovableFromDisk() != other.hasRemovableFromDisk()) return false;
    if (hasRemovableFromDisk()) {
      if (getRemovableFromDisk() != other.getRemovableFromDisk()) return false;
    }
    if (!getRequiredCoattachedLicensesList().equals(other.getRequiredCoattachedLicensesList()))
      return false;
    if (hasResourceRequirements() != other.hasResourceRequirements()) return false;
    if (hasResourceRequirements()) {
      if (!getResourceRequirements().equals(other.getResourceRequirements())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasSelfLinkWithId() != other.hasSelfLinkWithId()) return false;
    if (hasSelfLinkWithId()) {
      if (!getSelfLinkWithId().equals(other.getSelfLinkWithId())) return false;
    }
    if (hasSoleTenantOnly() != other.hasSoleTenantOnly()) return false;
    if (hasSoleTenantOnly()) {
      if (getSoleTenantOnly() != other.getSoleTenantOnly()) return false;
    }
    if (hasTransferable() != other.hasTransferable()) return false;
    if (hasTransferable()) {
      if (getTransferable() != other.getTransferable()) return false;
    }
    if (hasUpdateTimestamp() != other.hasUpdateTimestamp()) return false;
    if (hasUpdateTimestamp()) {
      if (!getUpdateTimestamp().equals(other.getUpdateTimestamp())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAllowedReplacementLicensesCount() > 0) {
      hash = (37 * hash) + ALLOWED_REPLACEMENT_LICENSES_FIELD_NUMBER;
      hash = (53 * hash) + getAllowedReplacementLicensesList().hashCode();
    }
    if (hasAppendableToDisk()) {
      hash = (37 * hash) + APPENDABLE_TO_DISK_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAppendableToDisk());
    }
    if (hasChargesUseFee()) {
      hash = (37 * hash) + CHARGES_USE_FEE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getChargesUseFee());
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (getIncompatibleLicensesCount() > 0) {
      hash = (37 * hash) + INCOMPATIBLE_LICENSES_FIELD_NUMBER;
      hash = (53 * hash) + getIncompatibleLicensesList().hashCode();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasLicenseCode()) {
      hash = (37 * hash) + LICENSE_CODE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getLicenseCode());
    }
    if (hasMinimumRetention()) {
      hash = (37 * hash) + MINIMUM_RETENTION_FIELD_NUMBER;
      hash = (53 * hash) + getMinimumRetention().hashCode();
    }
    if (hasMultiTenantOnly()) {
      hash = (37 * hash) + MULTI_TENANT_ONLY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getMultiTenantOnly());
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasOsLicense()) {
      hash = (37 * hash) + OS_LICENSE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getOsLicense());
    }
    if (hasRemovableFromDisk()) {
      hash = (37 * hash) + REMOVABLE_FROM_DISK_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRemovableFromDisk());
    }
    if (getRequiredCoattachedLicensesCount() > 0) {
      hash = (37 * hash) + REQUIRED_COATTACHED_LICENSES_FIELD_NUMBER;
      hash = (53 * hash) + getRequiredCoattachedLicensesList().hashCode();
    }
    if (hasResourceRequirements()) {
      hash = (37 * hash) + RESOURCE_REQUIREMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getResourceRequirements().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasSelfLinkWithId()) {
      hash = (37 * hash) + SELF_LINK_WITH_ID_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLinkWithId().hashCode();
    }
    if (hasSoleTenantOnly()) {
      hash = (37 * hash) + SOLE_TENANT_ONLY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSoleTenantOnly());
    }
    if (hasTransferable()) {
      hash = (37 * hash) + TRANSFERABLE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getTransferable());
    }
    if (hasUpdateTimestamp()) {
      hash = (37 * hash) + UPDATE_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTimestamp().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.License parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.License parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.License parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.License parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.License parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.License parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.License parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.License parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.License parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.License parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.License parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.License parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.License prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a License resource. A License represents billing and aggregate usage data for public and marketplace images. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.License}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.License)
      com.google.cloud.compute.v1.LicenseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_License_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_License_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.License.class,
              com.google.cloud.compute.v1.License.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.License.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMinimumRetentionFieldBuilder();
        getResourceRequirementsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      allowedReplacementLicenses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      appendableToDisk_ = false;
      chargesUseFee_ = false;
      creationTimestamp_ = "";
      description_ = "";
      id_ = 0L;
      incompatibleLicenses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      kind_ = "";
      licenseCode_ = 0L;
      minimumRetention_ = null;
      if (minimumRetentionBuilder_ != null) {
        minimumRetentionBuilder_.dispose();
        minimumRetentionBuilder_ = null;
      }
      multiTenantOnly_ = false;
      name_ = "";
      osLicense_ = false;
      removableFromDisk_ = false;
      requiredCoattachedLicenses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      resourceRequirements_ = null;
      if (resourceRequirementsBuilder_ != null) {
        resourceRequirementsBuilder_.dispose();
        resourceRequirementsBuilder_ = null;
      }
      selfLink_ = "";
      selfLinkWithId_ = "";
      soleTenantOnly_ = false;
      transferable_ = false;
      updateTimestamp_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_License_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.License getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.License.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.License build() {
      com.google.cloud.compute.v1.License result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.License buildPartial() {
      com.google.cloud.compute.v1.License result = new com.google.cloud.compute.v1.License(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.License result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        allowedReplacementLicenses_.makeImmutable();
        result.allowedReplacementLicenses_ = allowedReplacementLicenses_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.appendableToDisk_ = appendableToDisk_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.chargesUseFee_ = chargesUseFee_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        incompatibleLicenses_.makeImmutable();
        result.incompatibleLicenses_ = incompatibleLicenses_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.licenseCode_ = licenseCode_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.minimumRetention_ =
            minimumRetentionBuilder_ == null ? minimumRetention_ : minimumRetentionBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.multiTenantOnly_ = multiTenantOnly_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.osLicense_ = osLicense_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.removableFromDisk_ = removableFromDisk_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        requiredCoattachedLicenses_.makeImmutable();
        result.requiredCoattachedLicenses_ = requiredCoattachedLicenses_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.resourceRequirements_ =
            resourceRequirementsBuilder_ == null
                ? resourceRequirements_
                : resourceRequirementsBuilder_.build();
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.selfLinkWithId_ = selfLinkWithId_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.soleTenantOnly_ = soleTenantOnly_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.transferable_ = transferable_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.updateTimestamp_ = updateTimestamp_;
        to_bitField0_ |= 0x00020000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.License) {
        return mergeFrom((com.google.cloud.compute.v1.License) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.License other) {
      if (other == com.google.cloud.compute.v1.License.getDefaultInstance()) return this;
      if (!other.allowedReplacementLicenses_.isEmpty()) {
        if (allowedReplacementLicenses_.isEmpty()) {
          allowedReplacementLicenses_ = other.allowedReplacementLicenses_;
          bitField0_ |= 0x00000001;
        } else {
          ensureAllowedReplacementLicensesIsMutable();
          allowedReplacementLicenses_.addAll(other.allowedReplacementLicenses_);
        }
        onChanged();
      }
      if (other.hasAppendableToDisk()) {
        setAppendableToDisk(other.getAppendableToDisk());
      }
      if (other.hasChargesUseFee()) {
        setChargesUseFee(other.getChargesUseFee());
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (!other.incompatibleLicenses_.isEmpty()) {
        if (incompatibleLicenses_.isEmpty()) {
          incompatibleLicenses_ = other.incompatibleLicenses_;
          bitField0_ |= 0x00000040;
        } else {
          ensureIncompatibleLicensesIsMutable();
          incompatibleLicenses_.addAll(other.incompatibleLicenses_);
        }
        onChanged();
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasLicenseCode()) {
        setLicenseCode(other.getLicenseCode());
      }
      if (other.hasMinimumRetention()) {
        mergeMinimumRetention(other.getMinimumRetention());
      }
      if (other.hasMultiTenantOnly()) {
        setMultiTenantOnly(other.getMultiTenantOnly());
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasOsLicense()) {
        setOsLicense(other.getOsLicense());
      }
      if (other.hasRemovableFromDisk()) {
        setRemovableFromDisk(other.getRemovableFromDisk());
      }
      if (!other.requiredCoattachedLicenses_.isEmpty()) {
        if (requiredCoattachedLicenses_.isEmpty()) {
          requiredCoattachedLicenses_ = other.requiredCoattachedLicenses_;
          bitField0_ |= 0x00004000;
        } else {
          ensureRequiredCoattachedLicensesIsMutable();
          requiredCoattachedLicenses_.addAll(other.requiredCoattachedLicenses_);
        }
        onChanged();
      }
      if (other.hasResourceRequirements()) {
        mergeResourceRequirements(other.getResourceRequirements());
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.hasSelfLinkWithId()) {
        selfLinkWithId_ = other.selfLinkWithId_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasSoleTenantOnly()) {
        setSoleTenantOnly(other.getSoleTenantOnly());
      }
      if (other.hasTransferable()) {
        setTransferable(other.getTransferable());
      }
      if (other.hasUpdateTimestamp()) {
        updateTimestamp_ = other.updateTimestamp_;
        bitField0_ |= 0x00100000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 26840
            case 11737432:
              {
                licenseCode_ = input.readUInt64();
                bitField0_ |= 0x00000100;
                break;
              } // case 11737432
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 26989658
            case 34799144:
              {
                transferable_ = input.readBool();
                bitField0_ |= 0x00080000;
                break;
              } // case 34799144
            case 135674032:
              {
                appendableToDisk_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 135674032
            case 206837104:
              {
                removableFromDisk_ = input.readBool();
                bitField0_ |= 0x00002000;
                break;
              } // case 206837104
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 244202930
            case 356167698:
              {
                selfLinkWithId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 356167698
            case 967158018:
              {
                updateTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00100000;
                break;
              } // case 967158018
            case 1033562122:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRequiredCoattachedLicensesIsMutable();
                requiredCoattachedLicenses_.add(s);
                break;
              } // case 1033562122
            case 1243185514:
              {
                input.readMessage(
                    getMinimumRetentionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 1243185514
            case 1565421746:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAllowedReplacementLicensesIsMutable();
                allowedReplacementLicenses_.add(s);
                break;
              } // case 1565421746
            case 1714342154:
              {
                input.readMessage(
                    getResourceRequirementsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 1714342154
            case -2099805992:
              {
                multiTenantOnly_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case -2099805992
            case -1621049150:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIncompatibleLicensesIsMutable();
                incompatibleLicenses_.add(s);
                break;
              } // case -1621049150
            case -1315666320:
              {
                chargesUseFee_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case -1315666320
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -911466526
            case -874762824:
              {
                soleTenantOnly_ = input.readBool();
                bitField0_ |= 0x00040000;
                break;
              } // case -874762824
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case -645248918
            case -391076048:
              {
                osLicense_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case -391076048
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList allowedReplacementLicenses_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAllowedReplacementLicensesIsMutable() {
      if (!allowedReplacementLicenses_.isModifiable()) {
        allowedReplacementLicenses_ =
            new com.google.protobuf.LazyStringArrayList(allowedReplacementLicenses_);
      }
      bitField0_ |= 0x00000001;
    }

    /**
     *
     *
     * <pre>
     * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are allowed even if removable_from_disk is false.
     * </pre>
     *
     * <code>repeated string allowed_replacement_licenses = 195677718;</code>
     *
     * @return A list containing the allowedReplacementLicenses.
     */
    public com.google.protobuf.ProtocolStringList getAllowedReplacementLicensesList() {
      allowedReplacementLicenses_.makeImmutable();
      return allowedReplacementLicenses_;
    }

    /**
     *
     *
     * <pre>
     * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are allowed even if removable_from_disk is false.
     * </pre>
     *
     * <code>repeated string allowed_replacement_licenses = 195677718;</code>
     *
     * @return The count of allowedReplacementLicenses.
     */
    public int getAllowedReplacementLicensesCount() {
      return allowedReplacementLicenses_.size();
    }

    /**
     *
     *
     * <pre>
     * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are allowed even if removable_from_disk is false.
     * </pre>
     *
     * <code>repeated string allowed_replacement_licenses = 195677718;</code>
     *
     * @param index The index of the element to return.
     * @return The allowedReplacementLicenses at the given index.
     */
    public java.lang.String getAllowedReplacementLicenses(int index) {
      return allowedReplacementLicenses_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are allowed even if removable_from_disk is false.
     * </pre>
     *
     * <code>repeated string allowed_replacement_licenses = 195677718;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowedReplacementLicenses at the given index.
     */
    public com.google.protobuf.ByteString getAllowedReplacementLicensesBytes(int index) {
      return allowedReplacementLicenses_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are allowed even if removable_from_disk is false.
     * </pre>
     *
     * <code>repeated string allowed_replacement_licenses = 195677718;</code>
     *
     * @param index The index to set the value at.
     * @param value The allowedReplacementLicenses to set.
     * @return This builder for chaining.
     */
    public Builder setAllowedReplacementLicenses(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedReplacementLicensesIsMutable();
      allowedReplacementLicenses_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are allowed even if removable_from_disk is false.
     * </pre>
     *
     * <code>repeated string allowed_replacement_licenses = 195677718;</code>
     *
     * @param value The allowedReplacementLicenses to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedReplacementLicenses(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedReplacementLicensesIsMutable();
      allowedReplacementLicenses_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are allowed even if removable_from_disk is false.
     * </pre>
     *
     * <code>repeated string allowed_replacement_licenses = 195677718;</code>
     *
     * @param values The allowedReplacementLicenses to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowedReplacementLicenses(java.lang.Iterable<java.lang.String> values) {
      ensureAllowedReplacementLicensesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedReplacementLicenses_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are allowed even if removable_from_disk is false.
     * </pre>
     *
     * <code>repeated string allowed_replacement_licenses = 195677718;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowedReplacementLicenses() {
      allowedReplacementLicenses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are allowed even if removable_from_disk is false.
     * </pre>
     *
     * <code>repeated string allowed_replacement_licenses = 195677718;</code>
     *
     * @param value The bytes of the allowedReplacementLicenses to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedReplacementLicensesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAllowedReplacementLicensesIsMutable();
      allowedReplacementLicenses_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean appendableToDisk_;

    /**
     *
     *
     * <pre>
     * If true, this license can be appended to an existing disk's set of licenses.
     * </pre>
     *
     * <code>optional bool appendable_to_disk = 16959254;</code>
     *
     * @return Whether the appendableToDisk field is set.
     */
    @java.lang.Override
    public boolean hasAppendableToDisk() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * If true, this license can be appended to an existing disk's set of licenses.
     * </pre>
     *
     * <code>optional bool appendable_to_disk = 16959254;</code>
     *
     * @return The appendableToDisk.
     */
    @java.lang.Override
    public boolean getAppendableToDisk() {
      return appendableToDisk_;
    }

    /**
     *
     *
     * <pre>
     * If true, this license can be appended to an existing disk's set of licenses.
     * </pre>
     *
     * <code>optional bool appendable_to_disk = 16959254;</code>
     *
     * @param value The appendableToDisk to set.
     * @return This builder for chaining.
     */
    public Builder setAppendableToDisk(boolean value) {

      appendableToDisk_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If true, this license can be appended to an existing disk's set of licenses.
     * </pre>
     *
     * <code>optional bool appendable_to_disk = 16959254;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAppendableToDisk() {
      bitField0_ = (bitField0_ & ~0x00000002);
      appendableToDisk_ = false;
      onChanged();
      return this;
    }

    private boolean chargesUseFee_;

    /**
     *
     *
     * <pre>
     * [Output Only] Deprecated. This field no longer reflects whether a license charges a usage fee.
     * </pre>
     *
     * <code>optional bool charges_use_fee = 372412622;</code>
     *
     * @return Whether the chargesUseFee field is set.
     */
    @java.lang.Override
    public boolean hasChargesUseFee() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Deprecated. This field no longer reflects whether a license charges a usage fee.
     * </pre>
     *
     * <code>optional bool charges_use_fee = 372412622;</code>
     *
     * @return The chargesUseFee.
     */
    @java.lang.Override
    public boolean getChargesUseFee() {
      return chargesUseFee_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Deprecated. This field no longer reflects whether a license charges a usage fee.
     * </pre>
     *
     * <code>optional bool charges_use_fee = 372412622;</code>
     *
     * @param value The chargesUseFee to set.
     * @return This builder for chaining.
     */
    public Builder setChargesUseFee(boolean value) {

      chargesUseFee_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Deprecated. This field no longer reflects whether a license charges a usage fee.
     * </pre>
     *
     * <code>optional bool charges_use_fee = 372412622;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChargesUseFee() {
      bitField0_ = (bitField0_ & ~0x00000004);
      chargesUseFee_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional textual description of the resource; provided by the client when the resource is created.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional textual description of the resource; provided by the client when the resource is created.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional textual description of the resource; provided by the client when the resource is created.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional textual description of the resource; provided by the client when the resource is created.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional textual description of the resource; provided by the client when the resource is created.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional textual description of the resource; provided by the client when the resource is created.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private long id_;

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000020);
      id_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList incompatibleLicenses_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIncompatibleLicensesIsMutable() {
      if (!incompatibleLicenses_.isModifiable()) {
        incompatibleLicenses_ = new com.google.protobuf.LazyStringArrayList(incompatibleLicenses_);
      }
      bitField0_ |= 0x00000040;
    }

    /**
     *
     *
     * <pre>
     * Specifies licenseCodes of licenses that are incompatible with this license. If a license is incompatible with this license, it cannot be attached to the same disk or image.
     * </pre>
     *
     * <code>repeated string incompatible_licenses = 334239768;</code>
     *
     * @return A list containing the incompatibleLicenses.
     */
    public com.google.protobuf.ProtocolStringList getIncompatibleLicensesList() {
      incompatibleLicenses_.makeImmutable();
      return incompatibleLicenses_;
    }

    /**
     *
     *
     * <pre>
     * Specifies licenseCodes of licenses that are incompatible with this license. If a license is incompatible with this license, it cannot be attached to the same disk or image.
     * </pre>
     *
     * <code>repeated string incompatible_licenses = 334239768;</code>
     *
     * @return The count of incompatibleLicenses.
     */
    public int getIncompatibleLicensesCount() {
      return incompatibleLicenses_.size();
    }

    /**
     *
     *
     * <pre>
     * Specifies licenseCodes of licenses that are incompatible with this license. If a license is incompatible with this license, it cannot be attached to the same disk or image.
     * </pre>
     *
     * <code>repeated string incompatible_licenses = 334239768;</code>
     *
     * @param index The index of the element to return.
     * @return The incompatibleLicenses at the given index.
     */
    public java.lang.String getIncompatibleLicenses(int index) {
      return incompatibleLicenses_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies licenseCodes of licenses that are incompatible with this license. If a license is incompatible with this license, it cannot be attached to the same disk or image.
     * </pre>
     *
     * <code>repeated string incompatible_licenses = 334239768;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the incompatibleLicenses at the given index.
     */
    public com.google.protobuf.ByteString getIncompatibleLicensesBytes(int index) {
      return incompatibleLicenses_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies licenseCodes of licenses that are incompatible with this license. If a license is incompatible with this license, it cannot be attached to the same disk or image.
     * </pre>
     *
     * <code>repeated string incompatible_licenses = 334239768;</code>
     *
     * @param index The index to set the value at.
     * @param value The incompatibleLicenses to set.
     * @return This builder for chaining.
     */
    public Builder setIncompatibleLicenses(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncompatibleLicensesIsMutable();
      incompatibleLicenses_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies licenseCodes of licenses that are incompatible with this license. If a license is incompatible with this license, it cannot be attached to the same disk or image.
     * </pre>
     *
     * <code>repeated string incompatible_licenses = 334239768;</code>
     *
     * @param value The incompatibleLicenses to add.
     * @return This builder for chaining.
     */
    public Builder addIncompatibleLicenses(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncompatibleLicensesIsMutable();
      incompatibleLicenses_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies licenseCodes of licenses that are incompatible with this license. If a license is incompatible with this license, it cannot be attached to the same disk or image.
     * </pre>
     *
     * <code>repeated string incompatible_licenses = 334239768;</code>
     *
     * @param values The incompatibleLicenses to add.
     * @return This builder for chaining.
     */
    public Builder addAllIncompatibleLicenses(java.lang.Iterable<java.lang.String> values) {
      ensureIncompatibleLicensesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, incompatibleLicenses_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies licenseCodes of licenses that are incompatible with this license. If a license is incompatible with this license, it cannot be attached to the same disk or image.
     * </pre>
     *
     * <code>repeated string incompatible_licenses = 334239768;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncompatibleLicenses() {
      incompatibleLicenses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies licenseCodes of licenses that are incompatible with this license. If a license is incompatible with this license, it cannot be attached to the same disk or image.
     * </pre>
     *
     * <code>repeated string incompatible_licenses = 334239768;</code>
     *
     * @param value The bytes of the incompatibleLicenses to add.
     * @return This builder for chaining.
     */
    public Builder addIncompatibleLicensesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIncompatibleLicensesIsMutable();
      incompatibleLicenses_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#license for licenses.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#license for licenses.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#license for licenses.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#license for licenses.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#license for licenses.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of resource. Always compute#license for licenses.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private long licenseCode_;

    /**
     *
     *
     * <pre>
     * [Output Only] The unique code used to attach this license to images, snapshots, and disks.
     * </pre>
     *
     * <code>optional uint64 license_code = 1467179;</code>
     *
     * @return Whether the licenseCode field is set.
     */
    @java.lang.Override
    public boolean hasLicenseCode() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique code used to attach this license to images, snapshots, and disks.
     * </pre>
     *
     * <code>optional uint64 license_code = 1467179;</code>
     *
     * @return The licenseCode.
     */
    @java.lang.Override
    public long getLicenseCode() {
      return licenseCode_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique code used to attach this license to images, snapshots, and disks.
     * </pre>
     *
     * <code>optional uint64 license_code = 1467179;</code>
     *
     * @param value The licenseCode to set.
     * @return This builder for chaining.
     */
    public Builder setLicenseCode(long value) {

      licenseCode_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique code used to attach this license to images, snapshots, and disks.
     * </pre>
     *
     * <code>optional uint64 license_code = 1467179;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLicenseCode() {
      bitField0_ = (bitField0_ & ~0x00000100);
      licenseCode_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.Duration minimumRetention_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        minimumRetentionBuilder_;

    /**
     *
     *
     * <pre>
     * If set, this license will be unable to be removed or replaced once attached to a disk until the minimum_retention period has passed.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration minimum_retention = 155398189;</code>
     *
     * @return Whether the minimumRetention field is set.
     */
    public boolean hasMinimumRetention() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * If set, this license will be unable to be removed or replaced once attached to a disk until the minimum_retention period has passed.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration minimum_retention = 155398189;</code>
     *
     * @return The minimumRetention.
     */
    public com.google.cloud.compute.v1.Duration getMinimumRetention() {
      if (minimumRetentionBuilder_ == null) {
        return minimumRetention_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : minimumRetention_;
      } else {
        return minimumRetentionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * If set, this license will be unable to be removed or replaced once attached to a disk until the minimum_retention period has passed.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration minimum_retention = 155398189;</code>
     */
    public Builder setMinimumRetention(com.google.cloud.compute.v1.Duration value) {
      if (minimumRetentionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        minimumRetention_ = value;
      } else {
        minimumRetentionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If set, this license will be unable to be removed or replaced once attached to a disk until the minimum_retention period has passed.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration minimum_retention = 155398189;</code>
     */
    public Builder setMinimumRetention(
        com.google.cloud.compute.v1.Duration.Builder builderForValue) {
      if (minimumRetentionBuilder_ == null) {
        minimumRetention_ = builderForValue.build();
      } else {
        minimumRetentionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If set, this license will be unable to be removed or replaced once attached to a disk until the minimum_retention period has passed.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration minimum_retention = 155398189;</code>
     */
    public Builder mergeMinimumRetention(com.google.cloud.compute.v1.Duration value) {
      if (minimumRetentionBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && minimumRetention_ != null
            && minimumRetention_ != com.google.cloud.compute.v1.Duration.getDefaultInstance()) {
          getMinimumRetentionBuilder().mergeFrom(value);
        } else {
          minimumRetention_ = value;
        }
      } else {
        minimumRetentionBuilder_.mergeFrom(value);
      }
      if (minimumRetention_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If set, this license will be unable to be removed or replaced once attached to a disk until the minimum_retention period has passed.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration minimum_retention = 155398189;</code>
     */
    public Builder clearMinimumRetention() {
      bitField0_ = (bitField0_ & ~0x00000200);
      minimumRetention_ = null;
      if (minimumRetentionBuilder_ != null) {
        minimumRetentionBuilder_.dispose();
        minimumRetentionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If set, this license will be unable to be removed or replaced once attached to a disk until the minimum_retention period has passed.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration minimum_retention = 155398189;</code>
     */
    public com.google.cloud.compute.v1.Duration.Builder getMinimumRetentionBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getMinimumRetentionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * If set, this license will be unable to be removed or replaced once attached to a disk until the minimum_retention period has passed.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration minimum_retention = 155398189;</code>
     */
    public com.google.cloud.compute.v1.DurationOrBuilder getMinimumRetentionOrBuilder() {
      if (minimumRetentionBuilder_ != null) {
        return minimumRetentionBuilder_.getMessageOrBuilder();
      } else {
        return minimumRetention_ == null
            ? com.google.cloud.compute.v1.Duration.getDefaultInstance()
            : minimumRetention_;
      }
    }

    /**
     *
     *
     * <pre>
     * If set, this license will be unable to be removed or replaced once attached to a disk until the minimum_retention period has passed.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Duration minimum_retention = 155398189;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Duration,
            com.google.cloud.compute.v1.Duration.Builder,
            com.google.cloud.compute.v1.DurationOrBuilder>
        getMinimumRetentionFieldBuilder() {
      if (minimumRetentionBuilder_ == null) {
        minimumRetentionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Duration,
                com.google.cloud.compute.v1.Duration.Builder,
                com.google.cloud.compute.v1.DurationOrBuilder>(
                getMinimumRetention(), getParentForChildren(), isClean());
        minimumRetention_ = null;
      }
      return minimumRetentionBuilder_;
    }

    private boolean multiTenantOnly_;

    /**
     *
     *
     * <pre>
     * If true, this license can only be used on VMs on multi tenant nodes.
     * </pre>
     *
     * <code>optional bool multi_tenant_only = 274395163;</code>
     *
     * @return Whether the multiTenantOnly field is set.
     */
    @java.lang.Override
    public boolean hasMultiTenantOnly() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * If true, this license can only be used on VMs on multi tenant nodes.
     * </pre>
     *
     * <code>optional bool multi_tenant_only = 274395163;</code>
     *
     * @return The multiTenantOnly.
     */
    @java.lang.Override
    public boolean getMultiTenantOnly() {
      return multiTenantOnly_;
    }

    /**
     *
     *
     * <pre>
     * If true, this license can only be used on VMs on multi tenant nodes.
     * </pre>
     *
     * <code>optional bool multi_tenant_only = 274395163;</code>
     *
     * @param value The multiTenantOnly to set.
     * @return This builder for chaining.
     */
    public Builder setMultiTenantOnly(boolean value) {

      multiTenantOnly_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If true, this license can only be used on VMs on multi tenant nodes.
     * </pre>
     *
     * <code>optional bool multi_tenant_only = 274395163;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMultiTenantOnly() {
      bitField0_ = (bitField0_ & ~0x00000400);
      multiTenantOnly_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Name of the resource. The name must be 1-63 characters long and comply with RFC1035.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. The name must be 1-63 characters long and comply with RFC1035.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. The name must be 1-63 characters long and comply with RFC1035.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. The name must be 1-63 characters long and comply with RFC1035.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. The name must be 1-63 characters long and comply with RFC1035.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. The name must be 1-63 characters long and comply with RFC1035.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private boolean osLicense_;

    /**
     *
     *
     * <pre>
     * If true, indicates this is an OS license. Only one OS license can be attached to a disk or image at a time.
     * </pre>
     *
     * <code>optional bool os_license = 487986406;</code>
     *
     * @return Whether the osLicense field is set.
     */
    @java.lang.Override
    public boolean hasOsLicense() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * If true, indicates this is an OS license. Only one OS license can be attached to a disk or image at a time.
     * </pre>
     *
     * <code>optional bool os_license = 487986406;</code>
     *
     * @return The osLicense.
     */
    @java.lang.Override
    public boolean getOsLicense() {
      return osLicense_;
    }

    /**
     *
     *
     * <pre>
     * If true, indicates this is an OS license. Only one OS license can be attached to a disk or image at a time.
     * </pre>
     *
     * <code>optional bool os_license = 487986406;</code>
     *
     * @param value The osLicense to set.
     * @return This builder for chaining.
     */
    public Builder setOsLicense(boolean value) {

      osLicense_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If true, indicates this is an OS license. Only one OS license can be attached to a disk or image at a time.
     * </pre>
     *
     * <code>optional bool os_license = 487986406;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOsLicense() {
      bitField0_ = (bitField0_ & ~0x00001000);
      osLicense_ = false;
      onChanged();
      return this;
    }

    private boolean removableFromDisk_;

    /**
     *
     *
     * <pre>
     * If true, this license can be removed from a disk's set of licenses, with no replacement license needed.
     * </pre>
     *
     * <code>optional bool removable_from_disk = 25854638;</code>
     *
     * @return Whether the removableFromDisk field is set.
     */
    @java.lang.Override
    public boolean hasRemovableFromDisk() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * If true, this license can be removed from a disk's set of licenses, with no replacement license needed.
     * </pre>
     *
     * <code>optional bool removable_from_disk = 25854638;</code>
     *
     * @return The removableFromDisk.
     */
    @java.lang.Override
    public boolean getRemovableFromDisk() {
      return removableFromDisk_;
    }

    /**
     *
     *
     * <pre>
     * If true, this license can be removed from a disk's set of licenses, with no replacement license needed.
     * </pre>
     *
     * <code>optional bool removable_from_disk = 25854638;</code>
     *
     * @param value The removableFromDisk to set.
     * @return This builder for chaining.
     */
    public Builder setRemovableFromDisk(boolean value) {

      removableFromDisk_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If true, this license can be removed from a disk's set of licenses, with no replacement license needed.
     * </pre>
     *
     * <code>optional bool removable_from_disk = 25854638;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRemovableFromDisk() {
      bitField0_ = (bitField0_ & ~0x00002000);
      removableFromDisk_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList requiredCoattachedLicenses_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureRequiredCoattachedLicensesIsMutable() {
      if (!requiredCoattachedLicenses_.isModifiable()) {
        requiredCoattachedLicenses_ =
            new com.google.protobuf.LazyStringArrayList(requiredCoattachedLicenses_);
      }
      bitField0_ |= 0x00004000;
    }

    /**
     *
     *
     * <pre>
     * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the coattachment requirement of this license. At least one license from the set must be attached to the same disk or image as this license.
     * </pre>
     *
     * <code>repeated string required_coattached_licenses = 129195265;</code>
     *
     * @return A list containing the requiredCoattachedLicenses.
     */
    public com.google.protobuf.ProtocolStringList getRequiredCoattachedLicensesList() {
      requiredCoattachedLicenses_.makeImmutable();
      return requiredCoattachedLicenses_;
    }

    /**
     *
     *
     * <pre>
     * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the coattachment requirement of this license. At least one license from the set must be attached to the same disk or image as this license.
     * </pre>
     *
     * <code>repeated string required_coattached_licenses = 129195265;</code>
     *
     * @return The count of requiredCoattachedLicenses.
     */
    public int getRequiredCoattachedLicensesCount() {
      return requiredCoattachedLicenses_.size();
    }

    /**
     *
     *
     * <pre>
     * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the coattachment requirement of this license. At least one license from the set must be attached to the same disk or image as this license.
     * </pre>
     *
     * <code>repeated string required_coattached_licenses = 129195265;</code>
     *
     * @param index The index of the element to return.
     * @return The requiredCoattachedLicenses at the given index.
     */
    public java.lang.String getRequiredCoattachedLicenses(int index) {
      return requiredCoattachedLicenses_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the coattachment requirement of this license. At least one license from the set must be attached to the same disk or image as this license.
     * </pre>
     *
     * <code>repeated string required_coattached_licenses = 129195265;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the requiredCoattachedLicenses at the given index.
     */
    public com.google.protobuf.ByteString getRequiredCoattachedLicensesBytes(int index) {
      return requiredCoattachedLicenses_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the coattachment requirement of this license. At least one license from the set must be attached to the same disk or image as this license.
     * </pre>
     *
     * <code>repeated string required_coattached_licenses = 129195265;</code>
     *
     * @param index The index to set the value at.
     * @param value The requiredCoattachedLicenses to set.
     * @return This builder for chaining.
     */
    public Builder setRequiredCoattachedLicenses(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequiredCoattachedLicensesIsMutable();
      requiredCoattachedLicenses_.set(index, value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the coattachment requirement of this license. At least one license from the set must be attached to the same disk or image as this license.
     * </pre>
     *
     * <code>repeated string required_coattached_licenses = 129195265;</code>
     *
     * @param value The requiredCoattachedLicenses to add.
     * @return This builder for chaining.
     */
    public Builder addRequiredCoattachedLicenses(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequiredCoattachedLicensesIsMutable();
      requiredCoattachedLicenses_.add(value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the coattachment requirement of this license. At least one license from the set must be attached to the same disk or image as this license.
     * </pre>
     *
     * <code>repeated string required_coattached_licenses = 129195265;</code>
     *
     * @param values The requiredCoattachedLicenses to add.
     * @return This builder for chaining.
     */
    public Builder addAllRequiredCoattachedLicenses(java.lang.Iterable<java.lang.String> values) {
      ensureRequiredCoattachedLicensesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, requiredCoattachedLicenses_);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the coattachment requirement of this license. At least one license from the set must be attached to the same disk or image as this license.
     * </pre>
     *
     * <code>repeated string required_coattached_licenses = 129195265;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequiredCoattachedLicenses() {
      requiredCoattachedLicenses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00004000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the coattachment requirement of this license. At least one license from the set must be attached to the same disk or image as this license.
     * </pre>
     *
     * <code>repeated string required_coattached_licenses = 129195265;</code>
     *
     * @param value The bytes of the requiredCoattachedLicenses to add.
     * @return This builder for chaining.
     */
    public Builder addRequiredCoattachedLicensesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRequiredCoattachedLicensesIsMutable();
      requiredCoattachedLicenses_.add(value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.LicenseResourceRequirements resourceRequirements_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.LicenseResourceRequirements,
            com.google.cloud.compute.v1.LicenseResourceRequirements.Builder,
            com.google.cloud.compute.v1.LicenseResourceRequirementsOrBuilder>
        resourceRequirementsBuilder_;

    /**
     *
     *
     * <pre>
     * [Input Only] Deprecated.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.LicenseResourceRequirements resource_requirements = 214292769;
     * </code>
     *
     * @return Whether the resourceRequirements field is set.
     */
    public boolean hasResourceRequirements() {
      return ((bitField0_ & 0x00008000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Input Only] Deprecated.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.LicenseResourceRequirements resource_requirements = 214292769;
     * </code>
     *
     * @return The resourceRequirements.
     */
    public com.google.cloud.compute.v1.LicenseResourceRequirements getResourceRequirements() {
      if (resourceRequirementsBuilder_ == null) {
        return resourceRequirements_ == null
            ? com.google.cloud.compute.v1.LicenseResourceRequirements.getDefaultInstance()
            : resourceRequirements_;
      } else {
        return resourceRequirementsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * [Input Only] Deprecated.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.LicenseResourceRequirements resource_requirements = 214292769;
     * </code>
     */
    public Builder setResourceRequirements(
        com.google.cloud.compute.v1.LicenseResourceRequirements value) {
      if (resourceRequirementsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceRequirements_ = value;
      } else {
        resourceRequirementsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Input Only] Deprecated.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.LicenseResourceRequirements resource_requirements = 214292769;
     * </code>
     */
    public Builder setResourceRequirements(
        com.google.cloud.compute.v1.LicenseResourceRequirements.Builder builderForValue) {
      if (resourceRequirementsBuilder_ == null) {
        resourceRequirements_ = builderForValue.build();
      } else {
        resourceRequirementsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Input Only] Deprecated.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.LicenseResourceRequirements resource_requirements = 214292769;
     * </code>
     */
    public Builder mergeResourceRequirements(
        com.google.cloud.compute.v1.LicenseResourceRequirements value) {
      if (resourceRequirementsBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && resourceRequirements_ != null
            && resourceRequirements_
                != com.google.cloud.compute.v1.LicenseResourceRequirements.getDefaultInstance()) {
          getResourceRequirementsBuilder().mergeFrom(value);
        } else {
          resourceRequirements_ = value;
        }
      } else {
        resourceRequirementsBuilder_.mergeFrom(value);
      }
      if (resourceRequirements_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Input Only] Deprecated.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.LicenseResourceRequirements resource_requirements = 214292769;
     * </code>
     */
    public Builder clearResourceRequirements() {
      bitField0_ = (bitField0_ & ~0x00008000);
      resourceRequirements_ = null;
      if (resourceRequirementsBuilder_ != null) {
        resourceRequirementsBuilder_.dispose();
        resourceRequirementsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Input Only] Deprecated.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.LicenseResourceRequirements resource_requirements = 214292769;
     * </code>
     */
    public com.google.cloud.compute.v1.LicenseResourceRequirements.Builder
        getResourceRequirementsBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getResourceRequirementsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * [Input Only] Deprecated.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.LicenseResourceRequirements resource_requirements = 214292769;
     * </code>
     */
    public com.google.cloud.compute.v1.LicenseResourceRequirementsOrBuilder
        getResourceRequirementsOrBuilder() {
      if (resourceRequirementsBuilder_ != null) {
        return resourceRequirementsBuilder_.getMessageOrBuilder();
      } else {
        return resourceRequirements_ == null
            ? com.google.cloud.compute.v1.LicenseResourceRequirements.getDefaultInstance()
            : resourceRequirements_;
      }
    }

    /**
     *
     *
     * <pre>
     * [Input Only] Deprecated.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.LicenseResourceRequirements resource_requirements = 214292769;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.LicenseResourceRequirements,
            com.google.cloud.compute.v1.LicenseResourceRequirements.Builder,
            com.google.cloud.compute.v1.LicenseResourceRequirementsOrBuilder>
        getResourceRequirementsFieldBuilder() {
      if (resourceRequirementsBuilder_ == null) {
        resourceRequirementsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.LicenseResourceRequirements,
                com.google.cloud.compute.v1.LicenseResourceRequirements.Builder,
                com.google.cloud.compute.v1.LicenseResourceRequirementsOrBuilder>(
                getResourceRequirements(), getParentForChildren(), isClean());
        resourceRequirements_ = null;
      }
      return resourceRequirementsBuilder_;
    }

    private java.lang.Object selfLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00010000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private java.lang.Object selfLinkWithId_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @return Whether the selfLinkWithId field is set.
     */
    public boolean hasSelfLinkWithId() {
      return ((bitField0_ & 0x00020000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @return The selfLinkWithId.
     */
    public java.lang.String getSelfLinkWithId() {
      java.lang.Object ref = selfLinkWithId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLinkWithId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @return The bytes for selfLinkWithId.
     */
    public com.google.protobuf.ByteString getSelfLinkWithIdBytes() {
      java.lang.Object ref = selfLinkWithId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLinkWithId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @param value The selfLinkWithId to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkWithId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLinkWithId_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLinkWithId() {
      selfLinkWithId_ = getDefaultInstance().getSelfLinkWithId();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for this resource with the resource id.
     * </pre>
     *
     * <code>optional string self_link_with_id = 44520962;</code>
     *
     * @param value The bytes for selfLinkWithId to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkWithIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLinkWithId_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private boolean soleTenantOnly_;

    /**
     *
     *
     * <pre>
     * If true, this license can only be used on VMs on sole tenant nodes.
     * </pre>
     *
     * <code>optional bool sole_tenant_only = 427525559;</code>
     *
     * @return Whether the soleTenantOnly field is set.
     */
    @java.lang.Override
    public boolean hasSoleTenantOnly() {
      return ((bitField0_ & 0x00040000) != 0);
    }

    /**
     *
     *
     * <pre>
     * If true, this license can only be used on VMs on sole tenant nodes.
     * </pre>
     *
     * <code>optional bool sole_tenant_only = 427525559;</code>
     *
     * @return The soleTenantOnly.
     */
    @java.lang.Override
    public boolean getSoleTenantOnly() {
      return soleTenantOnly_;
    }

    /**
     *
     *
     * <pre>
     * If true, this license can only be used on VMs on sole tenant nodes.
     * </pre>
     *
     * <code>optional bool sole_tenant_only = 427525559;</code>
     *
     * @param value The soleTenantOnly to set.
     * @return This builder for chaining.
     */
    public Builder setSoleTenantOnly(boolean value) {

      soleTenantOnly_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If true, this license can only be used on VMs on sole tenant nodes.
     * </pre>
     *
     * <code>optional bool sole_tenant_only = 427525559;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSoleTenantOnly() {
      bitField0_ = (bitField0_ & ~0x00040000);
      soleTenantOnly_ = false;
      onChanged();
      return this;
    }

    private boolean transferable_;

    /**
     *
     *
     * <pre>
     * If false, licenses will not be copied from the source resource when creating an image from a disk, disk from snapshot, or snapshot from disk.
     * </pre>
     *
     * <code>optional bool transferable = 4349893;</code>
     *
     * @return Whether the transferable field is set.
     */
    @java.lang.Override
    public boolean hasTransferable() {
      return ((bitField0_ & 0x00080000) != 0);
    }

    /**
     *
     *
     * <pre>
     * If false, licenses will not be copied from the source resource when creating an image from a disk, disk from snapshot, or snapshot from disk.
     * </pre>
     *
     * <code>optional bool transferable = 4349893;</code>
     *
     * @return The transferable.
     */
    @java.lang.Override
    public boolean getTransferable() {
      return transferable_;
    }

    /**
     *
     *
     * <pre>
     * If false, licenses will not be copied from the source resource when creating an image from a disk, disk from snapshot, or snapshot from disk.
     * </pre>
     *
     * <code>optional bool transferable = 4349893;</code>
     *
     * @param value The transferable to set.
     * @return This builder for chaining.
     */
    public Builder setTransferable(boolean value) {

      transferable_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If false, licenses will not be copied from the source resource when creating an image from a disk, disk from snapshot, or snapshot from disk.
     * </pre>
     *
     * <code>optional bool transferable = 4349893;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransferable() {
      bitField0_ = (bitField0_ & ~0x00080000);
      transferable_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object updateTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Last update timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string update_timestamp = 120894752;</code>
     *
     * @return Whether the updateTimestamp field is set.
     */
    public boolean hasUpdateTimestamp() {
      return ((bitField0_ & 0x00100000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last update timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string update_timestamp = 120894752;</code>
     *
     * @return The updateTimestamp.
     */
    public java.lang.String getUpdateTimestamp() {
      java.lang.Object ref = updateTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        updateTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last update timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string update_timestamp = 120894752;</code>
     *
     * @return The bytes for updateTimestamp.
     */
    public com.google.protobuf.ByteString getUpdateTimestampBytes() {
      java.lang.Object ref = updateTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        updateTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last update timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string update_timestamp = 120894752;</code>
     *
     * @param value The updateTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setUpdateTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      updateTimestamp_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last update timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string update_timestamp = 120894752;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUpdateTimestamp() {
      updateTimestamp_ = getDefaultInstance().getUpdateTimestamp();
      bitField0_ = (bitField0_ & ~0x00100000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Last update timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string update_timestamp = 120894752;</code>
     *
     * @param value The bytes for updateTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setUpdateTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      updateTimestamp_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.License)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.License)
  private static final com.google.cloud.compute.v1.License DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.License();
  }

  public static com.google.cloud.compute.v1.License getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<License> PARSER =
      new com.google.protobuf.AbstractParser<License>() {
        @java.lang.Override
        public License parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<License> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<License> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.License getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
