/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * The status of one Interconnect in the group. The order is arbitrary.
 * </pre>
 *
 * Protobuf type {@code
 * google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus}
 */
public final class InterconnectGroupsOperationalStatusInterconnectStatus
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus)
    InterconnectGroupsOperationalStatusInterconnectStatusOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use InterconnectGroupsOperationalStatusInterconnectStatus.newBuilder() to construct.
  private InterconnectGroupsOperationalStatusInterconnectStatus(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InterconnectGroupsOperationalStatusInterconnectStatus() {
    interconnect_ = "";
    isActive_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InterconnectGroupsOperationalStatusInterconnectStatus();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectGroupsOperationalStatusInterconnectStatus_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectGroupsOperationalStatusInterconnectStatus_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus.class,
            com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
                .Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Whether this interconnect is participating in the redundant configuration.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus.IsActive}
   */
  public enum IsActive implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_IS_ACTIVE = 0;</code>
     */
    UNDEFINED_IS_ACTIVE(0),
    /** <code>ACTIVE = 314733318;</code> */
    ACTIVE(314733318),
    /** <code>INACTIVE = 270421099;</code> */
    INACTIVE(270421099),
    /** <code>IS_ACTIVE_UNSPECIFIED = 274948243;</code> */
    IS_ACTIVE_UNSPECIFIED(274948243),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_IS_ACTIVE = 0;</code>
     */
    public static final int UNDEFINED_IS_ACTIVE_VALUE = 0;

    /** <code>ACTIVE = 314733318;</code> */
    public static final int ACTIVE_VALUE = 314733318;

    /** <code>INACTIVE = 270421099;</code> */
    public static final int INACTIVE_VALUE = 270421099;

    /** <code>IS_ACTIVE_UNSPECIFIED = 274948243;</code> */
    public static final int IS_ACTIVE_UNSPECIFIED_VALUE = 274948243;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IsActive valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IsActive forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_IS_ACTIVE;
        case 314733318:
          return ACTIVE;
        case 270421099:
          return INACTIVE;
        case 274948243:
          return IS_ACTIVE_UNSPECIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IsActive> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IsActive> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<IsActive>() {
          public IsActive findValueByNumber(int number) {
            return IsActive.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
          .getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final IsActive[] VALUES = values();

    public static IsActive valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IsActive(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus.IsActive)
  }

  private int bitField0_;
  public static final int ADMIN_ENABLED_FIELD_NUMBER = 445675089;
  private boolean adminEnabled_ = false;

  /**
   *
   *
   * <pre>
   * Whether the Interconnect is enabled.
   * </pre>
   *
   * <code>optional bool admin_enabled = 445675089;</code>
   *
   * @return Whether the adminEnabled field is set.
   */
  @java.lang.Override
  public boolean hasAdminEnabled() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Whether the Interconnect is enabled.
   * </pre>
   *
   * <code>optional bool admin_enabled = 445675089;</code>
   *
   * @return The adminEnabled.
   */
  @java.lang.Override
  public boolean getAdminEnabled() {
    return adminEnabled_;
  }

  public static final int DIAGNOSTICS_FIELD_NUMBER = 333355436;
  private com.google.cloud.compute.v1.InterconnectDiagnostics diagnostics_;

  /**
   *
   *
   * <pre>
   * The diagnostics of the Interconnect, as returned by the existing get-diagnostics method.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InterconnectDiagnostics diagnostics = 333355436;</code>
   *
   * @return Whether the diagnostics field is set.
   */
  @java.lang.Override
  public boolean hasDiagnostics() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The diagnostics of the Interconnect, as returned by the existing get-diagnostics method.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InterconnectDiagnostics diagnostics = 333355436;</code>
   *
   * @return The diagnostics.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectDiagnostics getDiagnostics() {
    return diagnostics_ == null
        ? com.google.cloud.compute.v1.InterconnectDiagnostics.getDefaultInstance()
        : diagnostics_;
  }

  /**
   *
   *
   * <pre>
   * The diagnostics of the Interconnect, as returned by the existing get-diagnostics method.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InterconnectDiagnostics diagnostics = 333355436;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectDiagnosticsOrBuilder getDiagnosticsOrBuilder() {
    return diagnostics_ == null
        ? com.google.cloud.compute.v1.InterconnectDiagnostics.getDefaultInstance()
        : diagnostics_;
  }

  public static final int INTERCONNECT_FIELD_NUMBER = 224601230;

  @SuppressWarnings("serial")
  private volatile java.lang.Object interconnect_ = "";

  /**
   *
   *
   * <pre>
   * The URL of the Interconnect being described.
   * </pre>
   *
   * <code>optional string interconnect = 224601230;</code>
   *
   * @return Whether the interconnect field is set.
   */
  @java.lang.Override
  public boolean hasInterconnect() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * The URL of the Interconnect being described.
   * </pre>
   *
   * <code>optional string interconnect = 224601230;</code>
   *
   * @return The interconnect.
   */
  @java.lang.Override
  public java.lang.String getInterconnect() {
    java.lang.Object ref = interconnect_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      interconnect_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The URL of the Interconnect being described.
   * </pre>
   *
   * <code>optional string interconnect = 224601230;</code>
   *
   * @return The bytes for interconnect.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInterconnectBytes() {
    java.lang.Object ref = interconnect_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      interconnect_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IS_ACTIVE_FIELD_NUMBER = 114830267;

  @SuppressWarnings("serial")
  private volatile java.lang.Object isActive_ = "";

  /**
   *
   *
   * <pre>
   * Whether this interconnect is participating in the redundant configuration.
   * Check the IsActive enum for the list of possible values.
   * </pre>
   *
   * <code>optional string is_active = 114830267;</code>
   *
   * @return Whether the isActive field is set.
   */
  @java.lang.Override
  public boolean hasIsActive() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Whether this interconnect is participating in the redundant configuration.
   * Check the IsActive enum for the list of possible values.
   * </pre>
   *
   * <code>optional string is_active = 114830267;</code>
   *
   * @return The isActive.
   */
  @java.lang.Override
  public java.lang.String getIsActive() {
    java.lang.Object ref = isActive_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      isActive_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Whether this interconnect is participating in the redundant configuration.
   * Check the IsActive enum for the list of possible values.
   * </pre>
   *
   * <code>optional string is_active = 114830267;</code>
   *
   * @return The bytes for isActive.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIsActiveBytes() {
    java.lang.Object ref = isActive_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      isActive_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 114830267, isActive_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 224601230, interconnect_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(333355436, getDiagnostics());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(445675089, adminEnabled_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(114830267, isActive_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(224601230, interconnect_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(333355436, getDiagnostics());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(445675089, adminEnabled_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus other =
        (com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus) obj;

    if (hasAdminEnabled() != other.hasAdminEnabled()) return false;
    if (hasAdminEnabled()) {
      if (getAdminEnabled() != other.getAdminEnabled()) return false;
    }
    if (hasDiagnostics() != other.hasDiagnostics()) return false;
    if (hasDiagnostics()) {
      if (!getDiagnostics().equals(other.getDiagnostics())) return false;
    }
    if (hasInterconnect() != other.hasInterconnect()) return false;
    if (hasInterconnect()) {
      if (!getInterconnect().equals(other.getInterconnect())) return false;
    }
    if (hasIsActive() != other.hasIsActive()) return false;
    if (hasIsActive()) {
      if (!getIsActive().equals(other.getIsActive())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAdminEnabled()) {
      hash = (37 * hash) + ADMIN_ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAdminEnabled());
    }
    if (hasDiagnostics()) {
      hash = (37 * hash) + DIAGNOSTICS_FIELD_NUMBER;
      hash = (53 * hash) + getDiagnostics().hashCode();
    }
    if (hasInterconnect()) {
      hash = (37 * hash) + INTERCONNECT_FIELD_NUMBER;
      hash = (53 * hash) + getInterconnect().hashCode();
    }
    if (hasIsActive()) {
      hash = (37 * hash) + IS_ACTIVE_FIELD_NUMBER;
      hash = (53 * hash) + getIsActive().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The status of one Interconnect in the group. The order is arbitrary.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus)
      com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatusOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectGroupsOperationalStatusInterconnectStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectGroupsOperationalStatusInterconnectStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
                  .class,
              com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
                  .Builder.class);
    }

    // Construct using
    // com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDiagnosticsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      adminEnabled_ = false;
      diagnostics_ = null;
      if (diagnosticsBuilder_ != null) {
        diagnosticsBuilder_.dispose();
        diagnosticsBuilder_ = null;
      }
      interconnect_ = "";
      isActive_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectGroupsOperationalStatusInterconnectStatus_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
        build() {
      com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
        buildPartial() {
      com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus result =
          new com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus(
              this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.adminEnabled_ = adminEnabled_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.diagnostics_ =
            diagnosticsBuilder_ == null ? diagnostics_ : diagnosticsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.interconnect_ = interconnect_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.isActive_ = isActive_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus) {
        return mergeFrom(
            (com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus other) {
      if (other
          == com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
              .getDefaultInstance()) return this;
      if (other.hasAdminEnabled()) {
        setAdminEnabled(other.getAdminEnabled());
      }
      if (other.hasDiagnostics()) {
        mergeDiagnostics(other.getDiagnostics());
      }
      if (other.hasInterconnect()) {
        interconnect_ = other.interconnect_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasIsActive()) {
        isActive_ = other.isActive_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 918642138:
              {
                isActive_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 918642138
            case 1796809842:
              {
                interconnect_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 1796809842
            case -1628123806:
              {
                input.readMessage(getDiagnosticsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case -1628123806
            case -729566584:
              {
                adminEnabled_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case -729566584
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean adminEnabled_;

    /**
     *
     *
     * <pre>
     * Whether the Interconnect is enabled.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @return Whether the adminEnabled field is set.
     */
    @java.lang.Override
    public boolean hasAdminEnabled() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Whether the Interconnect is enabled.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @return The adminEnabled.
     */
    @java.lang.Override
    public boolean getAdminEnabled() {
      return adminEnabled_;
    }

    /**
     *
     *
     * <pre>
     * Whether the Interconnect is enabled.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @param value The adminEnabled to set.
     * @return This builder for chaining.
     */
    public Builder setAdminEnabled(boolean value) {

      adminEnabled_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether the Interconnect is enabled.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdminEnabled() {
      bitField0_ = (bitField0_ & ~0x00000001);
      adminEnabled_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.InterconnectDiagnostics diagnostics_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectDiagnostics,
            com.google.cloud.compute.v1.InterconnectDiagnostics.Builder,
            com.google.cloud.compute.v1.InterconnectDiagnosticsOrBuilder>
        diagnosticsBuilder_;

    /**
     *
     *
     * <pre>
     * The diagnostics of the Interconnect, as returned by the existing get-diagnostics method.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InterconnectDiagnostics diagnostics = 333355436;
     * </code>
     *
     * @return Whether the diagnostics field is set.
     */
    public boolean hasDiagnostics() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The diagnostics of the Interconnect, as returned by the existing get-diagnostics method.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InterconnectDiagnostics diagnostics = 333355436;
     * </code>
     *
     * @return The diagnostics.
     */
    public com.google.cloud.compute.v1.InterconnectDiagnostics getDiagnostics() {
      if (diagnosticsBuilder_ == null) {
        return diagnostics_ == null
            ? com.google.cloud.compute.v1.InterconnectDiagnostics.getDefaultInstance()
            : diagnostics_;
      } else {
        return diagnosticsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The diagnostics of the Interconnect, as returned by the existing get-diagnostics method.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InterconnectDiagnostics diagnostics = 333355436;
     * </code>
     */
    public Builder setDiagnostics(com.google.cloud.compute.v1.InterconnectDiagnostics value) {
      if (diagnosticsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        diagnostics_ = value;
      } else {
        diagnosticsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The diagnostics of the Interconnect, as returned by the existing get-diagnostics method.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InterconnectDiagnostics diagnostics = 333355436;
     * </code>
     */
    public Builder setDiagnostics(
        com.google.cloud.compute.v1.InterconnectDiagnostics.Builder builderForValue) {
      if (diagnosticsBuilder_ == null) {
        diagnostics_ = builderForValue.build();
      } else {
        diagnosticsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The diagnostics of the Interconnect, as returned by the existing get-diagnostics method.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InterconnectDiagnostics diagnostics = 333355436;
     * </code>
     */
    public Builder mergeDiagnostics(com.google.cloud.compute.v1.InterconnectDiagnostics value) {
      if (diagnosticsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && diagnostics_ != null
            && diagnostics_
                != com.google.cloud.compute.v1.InterconnectDiagnostics.getDefaultInstance()) {
          getDiagnosticsBuilder().mergeFrom(value);
        } else {
          diagnostics_ = value;
        }
      } else {
        diagnosticsBuilder_.mergeFrom(value);
      }
      if (diagnostics_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The diagnostics of the Interconnect, as returned by the existing get-diagnostics method.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InterconnectDiagnostics diagnostics = 333355436;
     * </code>
     */
    public Builder clearDiagnostics() {
      bitField0_ = (bitField0_ & ~0x00000002);
      diagnostics_ = null;
      if (diagnosticsBuilder_ != null) {
        diagnosticsBuilder_.dispose();
        diagnosticsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The diagnostics of the Interconnect, as returned by the existing get-diagnostics method.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InterconnectDiagnostics diagnostics = 333355436;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnostics.Builder getDiagnosticsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDiagnosticsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The diagnostics of the Interconnect, as returned by the existing get-diagnostics method.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InterconnectDiagnostics diagnostics = 333355436;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectDiagnosticsOrBuilder getDiagnosticsOrBuilder() {
      if (diagnosticsBuilder_ != null) {
        return diagnosticsBuilder_.getMessageOrBuilder();
      } else {
        return diagnostics_ == null
            ? com.google.cloud.compute.v1.InterconnectDiagnostics.getDefaultInstance()
            : diagnostics_;
      }
    }

    /**
     *
     *
     * <pre>
     * The diagnostics of the Interconnect, as returned by the existing get-diagnostics method.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InterconnectDiagnostics diagnostics = 333355436;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectDiagnostics,
            com.google.cloud.compute.v1.InterconnectDiagnostics.Builder,
            com.google.cloud.compute.v1.InterconnectDiagnosticsOrBuilder>
        getDiagnosticsFieldBuilder() {
      if (diagnosticsBuilder_ == null) {
        diagnosticsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectDiagnostics,
                com.google.cloud.compute.v1.InterconnectDiagnostics.Builder,
                com.google.cloud.compute.v1.InterconnectDiagnosticsOrBuilder>(
                getDiagnostics(), getParentForChildren(), isClean());
        diagnostics_ = null;
      }
      return diagnosticsBuilder_;
    }

    private java.lang.Object interconnect_ = "";

    /**
     *
     *
     * <pre>
     * The URL of the Interconnect being described.
     * </pre>
     *
     * <code>optional string interconnect = 224601230;</code>
     *
     * @return Whether the interconnect field is set.
     */
    public boolean hasInterconnect() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The URL of the Interconnect being described.
     * </pre>
     *
     * <code>optional string interconnect = 224601230;</code>
     *
     * @return The interconnect.
     */
    public java.lang.String getInterconnect() {
      java.lang.Object ref = interconnect_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        interconnect_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The URL of the Interconnect being described.
     * </pre>
     *
     * <code>optional string interconnect = 224601230;</code>
     *
     * @return The bytes for interconnect.
     */
    public com.google.protobuf.ByteString getInterconnectBytes() {
      java.lang.Object ref = interconnect_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        interconnect_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The URL of the Interconnect being described.
     * </pre>
     *
     * <code>optional string interconnect = 224601230;</code>
     *
     * @param value The interconnect to set.
     * @return This builder for chaining.
     */
    public Builder setInterconnect(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      interconnect_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URL of the Interconnect being described.
     * </pre>
     *
     * <code>optional string interconnect = 224601230;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInterconnect() {
      interconnect_ = getDefaultInstance().getInterconnect();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URL of the Interconnect being described.
     * </pre>
     *
     * <code>optional string interconnect = 224601230;</code>
     *
     * @param value The bytes for interconnect to set.
     * @return This builder for chaining.
     */
    public Builder setInterconnectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      interconnect_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object isActive_ = "";

    /**
     *
     *
     * <pre>
     * Whether this interconnect is participating in the redundant configuration.
     * Check the IsActive enum for the list of possible values.
     * </pre>
     *
     * <code>optional string is_active = 114830267;</code>
     *
     * @return Whether the isActive field is set.
     */
    public boolean hasIsActive() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Whether this interconnect is participating in the redundant configuration.
     * Check the IsActive enum for the list of possible values.
     * </pre>
     *
     * <code>optional string is_active = 114830267;</code>
     *
     * @return The isActive.
     */
    public java.lang.String getIsActive() {
      java.lang.Object ref = isActive_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        isActive_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Whether this interconnect is participating in the redundant configuration.
     * Check the IsActive enum for the list of possible values.
     * </pre>
     *
     * <code>optional string is_active = 114830267;</code>
     *
     * @return The bytes for isActive.
     */
    public com.google.protobuf.ByteString getIsActiveBytes() {
      java.lang.Object ref = isActive_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        isActive_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Whether this interconnect is participating in the redundant configuration.
     * Check the IsActive enum for the list of possible values.
     * </pre>
     *
     * <code>optional string is_active = 114830267;</code>
     *
     * @param value The isActive to set.
     * @return This builder for chaining.
     */
    public Builder setIsActive(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      isActive_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether this interconnect is participating in the redundant configuration.
     * Check the IsActive enum for the list of possible values.
     * </pre>
     *
     * <code>optional string is_active = 114830267;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsActive() {
      isActive_ = getDefaultInstance().getIsActive();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether this interconnect is participating in the redundant configuration.
     * Check the IsActive enum for the list of possible values.
     * </pre>
     *
     * <code>optional string is_active = 114830267;</code>
     *
     * @param value The bytes for isActive to set.
     * @return This builder for chaining.
     */
    public Builder setIsActiveBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      isActive_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus)
  private static final com.google.cloud.compute.v1
          .InterconnectGroupsOperationalStatusInterconnectStatus
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus();
  }

  public static com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<
          InterconnectGroupsOperationalStatusInterconnectStatus>
      PARSER =
          new com.google.protobuf.AbstractParser<
              InterconnectGroupsOperationalStatusInterconnectStatus>() {
            @java.lang.Override
            public InterconnectGroupsOperationalStatusInterconnectStatus parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<InterconnectGroupsOperationalStatusInterconnectStatus>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InterconnectGroupsOperationalStatusInterconnectStatus>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectGroupsOperationalStatusInterconnectStatus
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
