/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * [Output Only] Reasons why configuration.availabilitySLA.sla differs from intent.availabilitySLA. This list is empty if and only if those are the same.
 * </pre>
 *
 * Protobuf type {@code
 * google.cloud.compute.v1.InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers}
 */
public final class InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers)
    InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockersOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers.newBuilder() to
  // construct.
  private InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers() {
    attachments_ = com.google.protobuf.LazyStringArrayList.emptyList();
    blockerType_ = "";
    documentationLink_ = "";
    explanation_ = "";
    metros_ = com.google.protobuf.LazyStringArrayList.emptyList();
    regions_ = com.google.protobuf.LazyStringArrayList.emptyList();
    zones_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1
                .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers.class,
            com.google.cloud.compute.v1
                .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers.Builder
                .class);
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers.BlockerType}
   */
  public enum BlockerType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BLOCKER_TYPE = 0;</code>
     */
    UNDEFINED_BLOCKER_TYPE(0),
    /** <code>BLOCKER_TYPE_UNSPECIFIED = 429793623;</code> */
    BLOCKER_TYPE_UNSPECIFIED(429793623),
    /** <code>INCOMPATIBLE_METROS = 290410432;</code> */
    INCOMPATIBLE_METROS(290410432),
    /** <code>INCOMPATIBLE_REGIONS = 6195033;</code> */
    INCOMPATIBLE_REGIONS(6195033),
    /** <code>MISSING_GLOBAL_ROUTING = 165913635;</code> */
    MISSING_GLOBAL_ROUTING(165913635),
    /** <code>NO_ATTACHMENTS = 456535570;</code> */
    NO_ATTACHMENTS(456535570),
    /** <code>NO_ATTACHMENTS_IN_METRO_AND_ZONE = 51684135;</code> */
    NO_ATTACHMENTS_IN_METRO_AND_ZONE(51684135),
    /** <code>OTHER = 75532016;</code> */
    OTHER(75532016),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_BLOCKER_TYPE = 0;</code>
     */
    public static final int UNDEFINED_BLOCKER_TYPE_VALUE = 0;

    /** <code>BLOCKER_TYPE_UNSPECIFIED = 429793623;</code> */
    public static final int BLOCKER_TYPE_UNSPECIFIED_VALUE = 429793623;

    /** <code>INCOMPATIBLE_METROS = 290410432;</code> */
    public static final int INCOMPATIBLE_METROS_VALUE = 290410432;

    /** <code>INCOMPATIBLE_REGIONS = 6195033;</code> */
    public static final int INCOMPATIBLE_REGIONS_VALUE = 6195033;

    /** <code>MISSING_GLOBAL_ROUTING = 165913635;</code> */
    public static final int MISSING_GLOBAL_ROUTING_VALUE = 165913635;

    /** <code>NO_ATTACHMENTS = 456535570;</code> */
    public static final int NO_ATTACHMENTS_VALUE = 456535570;

    /** <code>NO_ATTACHMENTS_IN_METRO_AND_ZONE = 51684135;</code> */
    public static final int NO_ATTACHMENTS_IN_METRO_AND_ZONE_VALUE = 51684135;

    /** <code>OTHER = 75532016;</code> */
    public static final int OTHER_VALUE = 75532016;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BlockerType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static BlockerType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_BLOCKER_TYPE;
        case 429793623:
          return BLOCKER_TYPE_UNSPECIFIED;
        case 290410432:
          return INCOMPATIBLE_METROS;
        case 6195033:
          return INCOMPATIBLE_REGIONS;
        case 165913635:
          return MISSING_GLOBAL_ROUTING;
        case 456535570:
          return NO_ATTACHMENTS;
        case 51684135:
          return NO_ATTACHMENTS_IN_METRO_AND_ZONE;
        case 75532016:
          return OTHER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<BlockerType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<BlockerType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<BlockerType>() {
          public BlockerType findValueByNumber(int number) {
            return BlockerType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1
          .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final BlockerType[] VALUES = values();

    public static BlockerType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private BlockerType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers.BlockerType)
  }

  private int bitField0_;
  public static final int ATTACHMENTS_FIELD_NUMBER = 334744496;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList attachments_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * [Output Only] URLs of any particular Attachments to explain this blocker in more detail.
   * </pre>
   *
   * <code>repeated string attachments = 334744496;</code>
   *
   * @return A list containing the attachments.
   */
  public com.google.protobuf.ProtocolStringList getAttachmentsList() {
    return attachments_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] URLs of any particular Attachments to explain this blocker in more detail.
   * </pre>
   *
   * <code>repeated string attachments = 334744496;</code>
   *
   * @return The count of attachments.
   */
  public int getAttachmentsCount() {
    return attachments_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output Only] URLs of any particular Attachments to explain this blocker in more detail.
   * </pre>
   *
   * <code>repeated string attachments = 334744496;</code>
   *
   * @param index The index of the element to return.
   * @return The attachments at the given index.
   */
  public java.lang.String getAttachments(int index) {
    return attachments_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] URLs of any particular Attachments to explain this blocker in more detail.
   * </pre>
   *
   * <code>repeated string attachments = 334744496;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the attachments at the given index.
   */
  public com.google.protobuf.ByteString getAttachmentsBytes(int index) {
    return attachments_.getByteString(index);
  }

  public static final int BLOCKER_TYPE_FIELD_NUMBER = 381194847;

  @SuppressWarnings("serial")
  private volatile java.lang.Object blockerType_ = "";

  /**
   *
   *
   * <pre>
   *
   * Check the BlockerType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string blocker_type = 381194847;</code>
   *
   * @return Whether the blockerType field is set.
   */
  @java.lang.Override
  public boolean hasBlockerType() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   *
   * Check the BlockerType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string blocker_type = 381194847;</code>
   *
   * @return The blockerType.
   */
  @java.lang.Override
  public java.lang.String getBlockerType() {
    java.lang.Object ref = blockerType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      blockerType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   *
   * Check the BlockerType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string blocker_type = 381194847;</code>
   *
   * @return The bytes for blockerType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBlockerTypeBytes() {
    java.lang.Object ref = blockerType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      blockerType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCUMENTATION_LINK_FIELD_NUMBER = 93465183;

  @SuppressWarnings("serial")
  private volatile java.lang.Object documentationLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
   * </pre>
   *
   * <code>optional string documentation_link = 93465183;</code>
   *
   * @return Whether the documentationLink field is set.
   */
  @java.lang.Override
  public boolean hasDocumentationLink() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
   * </pre>
   *
   * <code>optional string documentation_link = 93465183;</code>
   *
   * @return The documentationLink.
   */
  @java.lang.Override
  public java.lang.String getDocumentationLink() {
    java.lang.Object ref = documentationLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      documentationLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
   * </pre>
   *
   * <code>optional string documentation_link = 93465183;</code>
   *
   * @return The bytes for documentationLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDocumentationLinkBytes() {
    java.lang.Object ref = documentationLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      documentationLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPLANATION_FIELD_NUMBER = 504745497;

  @SuppressWarnings("serial")
  private volatile java.lang.Object explanation_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
   * </pre>
   *
   * <code>optional string explanation = 504745497;</code>
   *
   * @return Whether the explanation field is set.
   */
  @java.lang.Override
  public boolean hasExplanation() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
   * </pre>
   *
   * <code>optional string explanation = 504745497;</code>
   *
   * @return The explanation.
   */
  @java.lang.Override
  public java.lang.String getExplanation() {
    java.lang.Object ref = explanation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      explanation_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
   * </pre>
   *
   * <code>optional string explanation = 504745497;</code>
   *
   * @return The bytes for explanation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExplanationBytes() {
    java.lang.Object ref = explanation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      explanation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METROS_FIELD_NUMBER = 533067386;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList metros_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". This will be set for some blockers (like NO_ATTACHMENTS_IN_METRO_AND_ZONE) but does not apply to others.
   * </pre>
   *
   * <code>repeated string metros = 533067386;</code>
   *
   * @return A list containing the metros.
   */
  public com.google.protobuf.ProtocolStringList getMetrosList() {
    return metros_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". This will be set for some blockers (like NO_ATTACHMENTS_IN_METRO_AND_ZONE) but does not apply to others.
   * </pre>
   *
   * <code>repeated string metros = 533067386;</code>
   *
   * @return The count of metros.
   */
  public int getMetrosCount() {
    return metros_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". This will be set for some blockers (like NO_ATTACHMENTS_IN_METRO_AND_ZONE) but does not apply to others.
   * </pre>
   *
   * <code>repeated string metros = 533067386;</code>
   *
   * @param index The index of the element to return.
   * @return The metros at the given index.
   */
  public java.lang.String getMetros(int index) {
    return metros_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". This will be set for some blockers (like NO_ATTACHMENTS_IN_METRO_AND_ZONE) but does not apply to others.
   * </pre>
   *
   * <code>repeated string metros = 533067386;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the metros at the given index.
   */
  public com.google.protobuf.ByteString getMetrosBytes(int index) {
    return metros_.getByteString(index);
  }

  public static final int REGIONS_FIELD_NUMBER = 12367871;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList regions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * [Output Only] Regions used to explain this blocker in more detail. These are region names formatted like "us-central1". This will be set for some blockers (like INCOMPATIBLE_REGIONS) but does not apply to others.
   * </pre>
   *
   * <code>repeated string regions = 12367871;</code>
   *
   * @return A list containing the regions.
   */
  public com.google.protobuf.ProtocolStringList getRegionsList() {
    return regions_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Regions used to explain this blocker in more detail. These are region names formatted like "us-central1". This will be set for some blockers (like INCOMPATIBLE_REGIONS) but does not apply to others.
   * </pre>
   *
   * <code>repeated string regions = 12367871;</code>
   *
   * @return The count of regions.
   */
  public int getRegionsCount() {
    return regions_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Regions used to explain this blocker in more detail. These are region names formatted like "us-central1". This will be set for some blockers (like INCOMPATIBLE_REGIONS) but does not apply to others.
   * </pre>
   *
   * <code>repeated string regions = 12367871;</code>
   *
   * @param index The index of the element to return.
   * @return The regions at the given index.
   */
  public java.lang.String getRegions(int index) {
    return regions_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Regions used to explain this blocker in more detail. These are region names formatted like "us-central1". This will be set for some blockers (like INCOMPATIBLE_REGIONS) but does not apply to others.
   * </pre>
   *
   * <code>repeated string regions = 12367871;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the regions at the given index.
   */
  public com.google.protobuf.ByteString getRegionsBytes(int index) {
    return regions_.getByteString(index);
  }

  public static final int ZONES_FIELD_NUMBER = 116085319;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList zones_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * [Output Only] Zones used to explain this blocker in more detail. Format is "zone1" and/or "zone2". This will be set for some blockers (like MISSING_ZONE) but does not apply to others.
   * </pre>
   *
   * <code>repeated string zones = 116085319;</code>
   *
   * @return A list containing the zones.
   */
  public com.google.protobuf.ProtocolStringList getZonesList() {
    return zones_;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Zones used to explain this blocker in more detail. Format is "zone1" and/or "zone2". This will be set for some blockers (like MISSING_ZONE) but does not apply to others.
   * </pre>
   *
   * <code>repeated string zones = 116085319;</code>
   *
   * @return The count of zones.
   */
  public int getZonesCount() {
    return zones_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Zones used to explain this blocker in more detail. Format is "zone1" and/or "zone2". This will be set for some blockers (like MISSING_ZONE) but does not apply to others.
   * </pre>
   *
   * <code>repeated string zones = 116085319;</code>
   *
   * @param index The index of the element to return.
   * @return The zones at the given index.
   */
  public java.lang.String getZones(int index) {
    return zones_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Zones used to explain this blocker in more detail. Format is "zone1" and/or "zone2". This will be set for some blockers (like MISSING_ZONE) but does not apply to others.
   * </pre>
   *
   * <code>repeated string zones = 116085319;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the zones at the given index.
   */
  public com.google.protobuf.ByteString getZonesBytes(int index) {
    return zones_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < regions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12367871, regions_.getRaw(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 93465183, documentationLink_);
    }
    for (int i = 0; i < zones_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 116085319, zones_.getRaw(i));
    }
    for (int i = 0; i < attachments_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 334744496, attachments_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 381194847, blockerType_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 504745497, explanation_);
    }
    for (int i = 0; i < metros_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 533067386, metros_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < regions_.size(); i++) {
        dataSize += computeStringSizeNoTag(regions_.getRaw(i));
      }
      size += dataSize;
      size += 4 * getRegionsList().size();
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(93465183, documentationLink_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < zones_.size(); i++) {
        dataSize += computeStringSizeNoTag(zones_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getZonesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < attachments_.size(); i++) {
        dataSize += computeStringSizeNoTag(attachments_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getAttachmentsList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(381194847, blockerType_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(504745497, explanation_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < metros_.size(); i++) {
        dataSize += computeStringSizeNoTag(metros_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getMetrosList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.compute.v1
            .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1
            .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
        other =
            (com.google.cloud.compute.v1
                    .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers)
                obj;

    if (!getAttachmentsList().equals(other.getAttachmentsList())) return false;
    if (hasBlockerType() != other.hasBlockerType()) return false;
    if (hasBlockerType()) {
      if (!getBlockerType().equals(other.getBlockerType())) return false;
    }
    if (hasDocumentationLink() != other.hasDocumentationLink()) return false;
    if (hasDocumentationLink()) {
      if (!getDocumentationLink().equals(other.getDocumentationLink())) return false;
    }
    if (hasExplanation() != other.hasExplanation()) return false;
    if (hasExplanation()) {
      if (!getExplanation().equals(other.getExplanation())) return false;
    }
    if (!getMetrosList().equals(other.getMetrosList())) return false;
    if (!getRegionsList().equals(other.getRegionsList())) return false;
    if (!getZonesList().equals(other.getZonesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAttachmentsCount() > 0) {
      hash = (37 * hash) + ATTACHMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getAttachmentsList().hashCode();
    }
    if (hasBlockerType()) {
      hash = (37 * hash) + BLOCKER_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getBlockerType().hashCode();
    }
    if (hasDocumentationLink()) {
      hash = (37 * hash) + DOCUMENTATION_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentationLink().hashCode();
    }
    if (hasExplanation()) {
      hash = (37 * hash) + EXPLANATION_FIELD_NUMBER;
      hash = (53 * hash) + getExplanation().hashCode();
    }
    if (getMetrosCount() > 0) {
      hash = (37 * hash) + METROS_FIELD_NUMBER;
      hash = (53 * hash) + getMetrosList().hashCode();
    }
    if (getRegionsCount() > 0) {
      hash = (37 * hash) + REGIONS_FIELD_NUMBER;
      hash = (53 * hash) + getRegionsList().hashCode();
    }
    if (getZonesCount() > 0) {
      hash = (37 * hash) + ZONES_FIELD_NUMBER;
      hash = (53 * hash) + getZonesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1
              .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
          prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Reasons why configuration.availabilitySLA.sla differs from intent.availabilitySLA. This list is empty if and only if those are the same.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.compute.v1.InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers)
      com.google.cloud.compute.v1
          .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockersOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1
                  .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers.class,
              com.google.cloud.compute.v1
                  .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.compute.v1.InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      attachments_ = com.google.protobuf.LazyStringArrayList.emptyList();
      blockerType_ = "";
      documentationLink_ = "";
      explanation_ = "";
      metros_ = com.google.protobuf.LazyStringArrayList.emptyList();
      regions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      zones_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1
            .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1
          .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1
            .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
        build() {
      com.google.cloud.compute.v1
              .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
          result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1
            .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
        buildPartial() {
      com.google.cloud.compute.v1
              .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
          result =
              new com.google.cloud.compute.v1
                  .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1
                .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
            result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        attachments_.makeImmutable();
        result.attachments_ = attachments_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.blockerType_ = blockerType_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.documentationLink_ = documentationLink_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.explanation_ = explanation_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        metros_.makeImmutable();
        result.metros_ = metros_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        regions_.makeImmutable();
        result.regions_ = regions_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        zones_.makeImmutable();
        result.zones_ = zones_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.compute.v1
              .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers) {
        return mergeFrom(
            (com.google.cloud.compute.v1
                    .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1
                .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
            other) {
      if (other
          == com.google.cloud.compute.v1
              .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
              .getDefaultInstance()) return this;
      if (!other.attachments_.isEmpty()) {
        if (attachments_.isEmpty()) {
          attachments_ = other.attachments_;
          bitField0_ |= 0x00000001;
        } else {
          ensureAttachmentsIsMutable();
          attachments_.addAll(other.attachments_);
        }
        onChanged();
      }
      if (other.hasBlockerType()) {
        blockerType_ = other.blockerType_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDocumentationLink()) {
        documentationLink_ = other.documentationLink_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasExplanation()) {
        explanation_ = other.explanation_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.metros_.isEmpty()) {
        if (metros_.isEmpty()) {
          metros_ = other.metros_;
          bitField0_ |= 0x00000010;
        } else {
          ensureMetrosIsMutable();
          metros_.addAll(other.metros_);
        }
        onChanged();
      }
      if (!other.regions_.isEmpty()) {
        if (regions_.isEmpty()) {
          regions_ = other.regions_;
          bitField0_ |= 0x00000020;
        } else {
          ensureRegionsIsMutable();
          regions_.addAll(other.regions_);
        }
        onChanged();
      }
      if (!other.zones_.isEmpty()) {
        if (zones_.isEmpty()) {
          zones_ = other.zones_;
          bitField0_ |= 0x00000040;
        } else {
          ensureZonesIsMutable();
          zones_.addAll(other.zones_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 98942970:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRegionsIsMutable();
                regions_.add(s);
                break;
              } // case 98942970
            case 747721466:
              {
                documentationLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 747721466
            case 928682554:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureZonesIsMutable();
                zones_.add(s);
                break;
              } // case 928682554
            case -1617011326:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAttachmentsIsMutable();
                attachments_.add(s);
                break;
              } // case -1617011326
            case -1245408518:
              {
                blockerType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -1245408518
            case -257003318:
              {
                explanation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -257003318
            case -30428206:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureMetrosIsMutable();
                metros_.add(s);
                break;
              } // case -30428206
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList attachments_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAttachmentsIsMutable() {
      if (!attachments_.isModifiable()) {
        attachments_ = new com.google.protobuf.LazyStringArrayList(attachments_);
      }
      bitField0_ |= 0x00000001;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URLs of any particular Attachments to explain this blocker in more detail.
     * </pre>
     *
     * <code>repeated string attachments = 334744496;</code>
     *
     * @return A list containing the attachments.
     */
    public com.google.protobuf.ProtocolStringList getAttachmentsList() {
      attachments_.makeImmutable();
      return attachments_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URLs of any particular Attachments to explain this blocker in more detail.
     * </pre>
     *
     * <code>repeated string attachments = 334744496;</code>
     *
     * @return The count of attachments.
     */
    public int getAttachmentsCount() {
      return attachments_.size();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URLs of any particular Attachments to explain this blocker in more detail.
     * </pre>
     *
     * <code>repeated string attachments = 334744496;</code>
     *
     * @param index The index of the element to return.
     * @return The attachments at the given index.
     */
    public java.lang.String getAttachments(int index) {
      return attachments_.get(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URLs of any particular Attachments to explain this blocker in more detail.
     * </pre>
     *
     * <code>repeated string attachments = 334744496;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the attachments at the given index.
     */
    public com.google.protobuf.ByteString getAttachmentsBytes(int index) {
      return attachments_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URLs of any particular Attachments to explain this blocker in more detail.
     * </pre>
     *
     * <code>repeated string attachments = 334744496;</code>
     *
     * @param index The index to set the value at.
     * @param value The attachments to set.
     * @return This builder for chaining.
     */
    public Builder setAttachments(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAttachmentsIsMutable();
      attachments_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URLs of any particular Attachments to explain this blocker in more detail.
     * </pre>
     *
     * <code>repeated string attachments = 334744496;</code>
     *
     * @param value The attachments to add.
     * @return This builder for chaining.
     */
    public Builder addAttachments(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAttachmentsIsMutable();
      attachments_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URLs of any particular Attachments to explain this blocker in more detail.
     * </pre>
     *
     * <code>repeated string attachments = 334744496;</code>
     *
     * @param values The attachments to add.
     * @return This builder for chaining.
     */
    public Builder addAllAttachments(java.lang.Iterable<java.lang.String> values) {
      ensureAttachmentsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, attachments_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URLs of any particular Attachments to explain this blocker in more detail.
     * </pre>
     *
     * <code>repeated string attachments = 334744496;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAttachments() {
      attachments_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URLs of any particular Attachments to explain this blocker in more detail.
     * </pre>
     *
     * <code>repeated string attachments = 334744496;</code>
     *
     * @param value The bytes of the attachments to add.
     * @return This builder for chaining.
     */
    public Builder addAttachmentsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAttachmentsIsMutable();
      attachments_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object blockerType_ = "";

    /**
     *
     *
     * <pre>
     *
     * Check the BlockerType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string blocker_type = 381194847;</code>
     *
     * @return Whether the blockerType field is set.
     */
    public boolean hasBlockerType() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     *
     * Check the BlockerType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string blocker_type = 381194847;</code>
     *
     * @return The blockerType.
     */
    public java.lang.String getBlockerType() {
      java.lang.Object ref = blockerType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        blockerType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     *
     * Check the BlockerType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string blocker_type = 381194847;</code>
     *
     * @return The bytes for blockerType.
     */
    public com.google.protobuf.ByteString getBlockerTypeBytes() {
      java.lang.Object ref = blockerType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        blockerType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     *
     * Check the BlockerType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string blocker_type = 381194847;</code>
     *
     * @param value The blockerType to set.
     * @return This builder for chaining.
     */
    public Builder setBlockerType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      blockerType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     *
     * Check the BlockerType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string blocker_type = 381194847;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBlockerType() {
      blockerType_ = getDefaultInstance().getBlockerType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     *
     * Check the BlockerType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string blocker_type = 381194847;</code>
     *
     * @param value The bytes for blockerType to set.
     * @return This builder for chaining.
     */
    public Builder setBlockerTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      blockerType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object documentationLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string documentation_link = 93465183;</code>
     *
     * @return Whether the documentationLink field is set.
     */
    public boolean hasDocumentationLink() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string documentation_link = 93465183;</code>
     *
     * @return The documentationLink.
     */
    public java.lang.String getDocumentationLink() {
      java.lang.Object ref = documentationLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        documentationLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string documentation_link = 93465183;</code>
     *
     * @return The bytes for documentationLink.
     */
    public com.google.protobuf.ByteString getDocumentationLinkBytes() {
      java.lang.Object ref = documentationLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        documentationLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string documentation_link = 93465183;</code>
     *
     * @param value The documentationLink to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentationLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      documentationLink_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string documentation_link = 93465183;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDocumentationLink() {
      documentationLink_ = getDefaultInstance().getDocumentationLink();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The url of Google Cloud public documentation explaining this requirement. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string documentation_link = 93465183;</code>
     *
     * @param value The bytes for documentationLink to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentationLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      documentationLink_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object explanation_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string explanation = 504745497;</code>
     *
     * @return Whether the explanation field is set.
     */
    public boolean hasExplanation() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string explanation = 504745497;</code>
     *
     * @return The explanation.
     */
    public java.lang.String getExplanation() {
      java.lang.Object ref = explanation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        explanation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string explanation = 504745497;</code>
     *
     * @return The bytes for explanation.
     */
    public com.google.protobuf.ByteString getExplanationBytes() {
      java.lang.Object ref = explanation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        explanation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string explanation = 504745497;</code>
     *
     * @param value The explanation to set.
     * @return This builder for chaining.
     */
    public Builder setExplanation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      explanation_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string explanation = 504745497;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExplanation() {
      explanation_ = getDefaultInstance().getExplanation();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] A human-readable explanation of this requirement and why it's not met. This is set for every type of requirement.
     * </pre>
     *
     * <code>optional string explanation = 504745497;</code>
     *
     * @param value The bytes for explanation to set.
     * @return This builder for chaining.
     */
    public Builder setExplanationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      explanation_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList metros_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureMetrosIsMutable() {
      if (!metros_.isModifiable()) {
        metros_ = new com.google.protobuf.LazyStringArrayList(metros_);
      }
      bitField0_ |= 0x00000010;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". This will be set for some blockers (like NO_ATTACHMENTS_IN_METRO_AND_ZONE) but does not apply to others.
     * </pre>
     *
     * <code>repeated string metros = 533067386;</code>
     *
     * @return A list containing the metros.
     */
    public com.google.protobuf.ProtocolStringList getMetrosList() {
      metros_.makeImmutable();
      return metros_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". This will be set for some blockers (like NO_ATTACHMENTS_IN_METRO_AND_ZONE) but does not apply to others.
     * </pre>
     *
     * <code>repeated string metros = 533067386;</code>
     *
     * @return The count of metros.
     */
    public int getMetrosCount() {
      return metros_.size();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". This will be set for some blockers (like NO_ATTACHMENTS_IN_METRO_AND_ZONE) but does not apply to others.
     * </pre>
     *
     * <code>repeated string metros = 533067386;</code>
     *
     * @param index The index of the element to return.
     * @return The metros at the given index.
     */
    public java.lang.String getMetros(int index) {
      return metros_.get(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". This will be set for some blockers (like NO_ATTACHMENTS_IN_METRO_AND_ZONE) but does not apply to others.
     * </pre>
     *
     * <code>repeated string metros = 533067386;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the metros at the given index.
     */
    public com.google.protobuf.ByteString getMetrosBytes(int index) {
      return metros_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". This will be set for some blockers (like NO_ATTACHMENTS_IN_METRO_AND_ZONE) but does not apply to others.
     * </pre>
     *
     * <code>repeated string metros = 533067386;</code>
     *
     * @param index The index to set the value at.
     * @param value The metros to set.
     * @return This builder for chaining.
     */
    public Builder setMetros(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMetrosIsMutable();
      metros_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". This will be set for some blockers (like NO_ATTACHMENTS_IN_METRO_AND_ZONE) but does not apply to others.
     * </pre>
     *
     * <code>repeated string metros = 533067386;</code>
     *
     * @param value The metros to add.
     * @return This builder for chaining.
     */
    public Builder addMetros(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMetrosIsMutable();
      metros_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". This will be set for some blockers (like NO_ATTACHMENTS_IN_METRO_AND_ZONE) but does not apply to others.
     * </pre>
     *
     * <code>repeated string metros = 533067386;</code>
     *
     * @param values The metros to add.
     * @return This builder for chaining.
     */
    public Builder addAllMetros(java.lang.Iterable<java.lang.String> values) {
      ensureMetrosIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metros_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". This will be set for some blockers (like NO_ATTACHMENTS_IN_METRO_AND_ZONE) but does not apply to others.
     * </pre>
     *
     * <code>repeated string metros = 533067386;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetros() {
      metros_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Metros used to explain this blocker in more detail. These are three-letter lowercase strings like "iad". This will be set for some blockers (like NO_ATTACHMENTS_IN_METRO_AND_ZONE) but does not apply to others.
     * </pre>
     *
     * <code>repeated string metros = 533067386;</code>
     *
     * @param value The bytes of the metros to add.
     * @return This builder for chaining.
     */
    public Builder addMetrosBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureMetrosIsMutable();
      metros_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList regions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureRegionsIsMutable() {
      if (!regions_.isModifiable()) {
        regions_ = new com.google.protobuf.LazyStringArrayList(regions_);
      }
      bitField0_ |= 0x00000020;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Regions used to explain this blocker in more detail. These are region names formatted like "us-central1". This will be set for some blockers (like INCOMPATIBLE_REGIONS) but does not apply to others.
     * </pre>
     *
     * <code>repeated string regions = 12367871;</code>
     *
     * @return A list containing the regions.
     */
    public com.google.protobuf.ProtocolStringList getRegionsList() {
      regions_.makeImmutable();
      return regions_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Regions used to explain this blocker in more detail. These are region names formatted like "us-central1". This will be set for some blockers (like INCOMPATIBLE_REGIONS) but does not apply to others.
     * </pre>
     *
     * <code>repeated string regions = 12367871;</code>
     *
     * @return The count of regions.
     */
    public int getRegionsCount() {
      return regions_.size();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Regions used to explain this blocker in more detail. These are region names formatted like "us-central1". This will be set for some blockers (like INCOMPATIBLE_REGIONS) but does not apply to others.
     * </pre>
     *
     * <code>repeated string regions = 12367871;</code>
     *
     * @param index The index of the element to return.
     * @return The regions at the given index.
     */
    public java.lang.String getRegions(int index) {
      return regions_.get(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Regions used to explain this blocker in more detail. These are region names formatted like "us-central1". This will be set for some blockers (like INCOMPATIBLE_REGIONS) but does not apply to others.
     * </pre>
     *
     * <code>repeated string regions = 12367871;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the regions at the given index.
     */
    public com.google.protobuf.ByteString getRegionsBytes(int index) {
      return regions_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Regions used to explain this blocker in more detail. These are region names formatted like "us-central1". This will be set for some blockers (like INCOMPATIBLE_REGIONS) but does not apply to others.
     * </pre>
     *
     * <code>repeated string regions = 12367871;</code>
     *
     * @param index The index to set the value at.
     * @param value The regions to set.
     * @return This builder for chaining.
     */
    public Builder setRegions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRegionsIsMutable();
      regions_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Regions used to explain this blocker in more detail. These are region names formatted like "us-central1". This will be set for some blockers (like INCOMPATIBLE_REGIONS) but does not apply to others.
     * </pre>
     *
     * <code>repeated string regions = 12367871;</code>
     *
     * @param value The regions to add.
     * @return This builder for chaining.
     */
    public Builder addRegions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRegionsIsMutable();
      regions_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Regions used to explain this blocker in more detail. These are region names formatted like "us-central1". This will be set for some blockers (like INCOMPATIBLE_REGIONS) but does not apply to others.
     * </pre>
     *
     * <code>repeated string regions = 12367871;</code>
     *
     * @param values The regions to add.
     * @return This builder for chaining.
     */
    public Builder addAllRegions(java.lang.Iterable<java.lang.String> values) {
      ensureRegionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, regions_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Regions used to explain this blocker in more detail. These are region names formatted like "us-central1". This will be set for some blockers (like INCOMPATIBLE_REGIONS) but does not apply to others.
     * </pre>
     *
     * <code>repeated string regions = 12367871;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegions() {
      regions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Regions used to explain this blocker in more detail. These are region names formatted like "us-central1". This will be set for some blockers (like INCOMPATIBLE_REGIONS) but does not apply to others.
     * </pre>
     *
     * <code>repeated string regions = 12367871;</code>
     *
     * @param value The bytes of the regions to add.
     * @return This builder for chaining.
     */
    public Builder addRegionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRegionsIsMutable();
      regions_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList zones_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureZonesIsMutable() {
      if (!zones_.isModifiable()) {
        zones_ = new com.google.protobuf.LazyStringArrayList(zones_);
      }
      bitField0_ |= 0x00000040;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zones used to explain this blocker in more detail. Format is "zone1" and/or "zone2". This will be set for some blockers (like MISSING_ZONE) but does not apply to others.
     * </pre>
     *
     * <code>repeated string zones = 116085319;</code>
     *
     * @return A list containing the zones.
     */
    public com.google.protobuf.ProtocolStringList getZonesList() {
      zones_.makeImmutable();
      return zones_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zones used to explain this blocker in more detail. Format is "zone1" and/or "zone2". This will be set for some blockers (like MISSING_ZONE) but does not apply to others.
     * </pre>
     *
     * <code>repeated string zones = 116085319;</code>
     *
     * @return The count of zones.
     */
    public int getZonesCount() {
      return zones_.size();
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zones used to explain this blocker in more detail. Format is "zone1" and/or "zone2". This will be set for some blockers (like MISSING_ZONE) but does not apply to others.
     * </pre>
     *
     * <code>repeated string zones = 116085319;</code>
     *
     * @param index The index of the element to return.
     * @return The zones at the given index.
     */
    public java.lang.String getZones(int index) {
      return zones_.get(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zones used to explain this blocker in more detail. Format is "zone1" and/or "zone2". This will be set for some blockers (like MISSING_ZONE) but does not apply to others.
     * </pre>
     *
     * <code>repeated string zones = 116085319;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the zones at the given index.
     */
    public com.google.protobuf.ByteString getZonesBytes(int index) {
      return zones_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zones used to explain this blocker in more detail. Format is "zone1" and/or "zone2". This will be set for some blockers (like MISSING_ZONE) but does not apply to others.
     * </pre>
     *
     * <code>repeated string zones = 116085319;</code>
     *
     * @param index The index to set the value at.
     * @param value The zones to set.
     * @return This builder for chaining.
     */
    public Builder setZones(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureZonesIsMutable();
      zones_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zones used to explain this blocker in more detail. Format is "zone1" and/or "zone2". This will be set for some blockers (like MISSING_ZONE) but does not apply to others.
     * </pre>
     *
     * <code>repeated string zones = 116085319;</code>
     *
     * @param value The zones to add.
     * @return This builder for chaining.
     */
    public Builder addZones(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureZonesIsMutable();
      zones_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zones used to explain this blocker in more detail. Format is "zone1" and/or "zone2". This will be set for some blockers (like MISSING_ZONE) but does not apply to others.
     * </pre>
     *
     * <code>repeated string zones = 116085319;</code>
     *
     * @param values The zones to add.
     * @return This builder for chaining.
     */
    public Builder addAllZones(java.lang.Iterable<java.lang.String> values) {
      ensureZonesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, zones_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zones used to explain this blocker in more detail. Format is "zone1" and/or "zone2". This will be set for some blockers (like MISSING_ZONE) but does not apply to others.
     * </pre>
     *
     * <code>repeated string zones = 116085319;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZones() {
      zones_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Zones used to explain this blocker in more detail. Format is "zone1" and/or "zone2". This will be set for some blockers (like MISSING_ZONE) but does not apply to others.
     * </pre>
     *
     * <code>repeated string zones = 116085319;</code>
     *
     * @param value The bytes of the zones to add.
     * @return This builder for chaining.
     */
    public Builder addZonesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureZonesIsMutable();
      zones_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers)
  private static final com.google.cloud.compute.v1
          .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.compute.v1
            .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers();
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<
          InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers>
      PARSER =
          new com.google.protobuf.AbstractParser<
              InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers>() {
            @java.lang.Override
            public InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
                parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<
          InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<
          InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1
          .InterconnectAttachmentGroupConfiguredAvailabilitySLAIntendedSlaBlockers
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
