/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Configuration information for application awareness on this Cloud Interconnect.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.InterconnectApplicationAwareInterconnect}
 */
public final class InterconnectApplicationAwareInterconnect
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InterconnectApplicationAwareInterconnect)
    InterconnectApplicationAwareInterconnectOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use InterconnectApplicationAwareInterconnect.newBuilder() to construct.
  private InterconnectApplicationAwareInterconnect(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InterconnectApplicationAwareInterconnect() {
    profileDescription_ = "";
    shapeAveragePercentages_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InterconnectApplicationAwareInterconnect();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectApplicationAwareInterconnect_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectApplicationAwareInterconnect_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect.class,
            com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect.Builder.class);
  }

  private int bitField0_;
  public static final int BANDWIDTH_PERCENTAGE_POLICY_FIELD_NUMBER = 187018857;
  private com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy
      bandwidthPercentagePolicy_;

  /**
   * <code>
   * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy bandwidth_percentage_policy = 187018857;
   * </code>
   *
   * @return Whether the bandwidthPercentagePolicy field is set.
   */
  @java.lang.Override
  public boolean hasBandwidthPercentagePolicy() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy bandwidth_percentage_policy = 187018857;
   * </code>
   *
   * @return The bandwidthPercentagePolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy
      getBandwidthPercentagePolicy() {
    return bandwidthPercentagePolicy_ == null
        ? com.google.cloud.compute.v1
            .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy.getDefaultInstance()
        : bandwidthPercentagePolicy_;
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy bandwidth_percentage_policy = 187018857;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicyOrBuilder
      getBandwidthPercentagePolicyOrBuilder() {
    return bandwidthPercentagePolicy_ == null
        ? com.google.cloud.compute.v1
            .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy.getDefaultInstance()
        : bandwidthPercentagePolicy_;
  }

  public static final int PROFILE_DESCRIPTION_FIELD_NUMBER = 262813286;

  @SuppressWarnings("serial")
  private volatile java.lang.Object profileDescription_ = "";

  /**
   *
   *
   * <pre>
   * Description for the application awareness profile on this Cloud Interconnect.
   * </pre>
   *
   * <code>optional string profile_description = 262813286;</code>
   *
   * @return Whether the profileDescription field is set.
   */
  @java.lang.Override
  public boolean hasProfileDescription() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Description for the application awareness profile on this Cloud Interconnect.
   * </pre>
   *
   * <code>optional string profile_description = 262813286;</code>
   *
   * @return The profileDescription.
   */
  @java.lang.Override
  public java.lang.String getProfileDescription() {
    java.lang.Object ref = profileDescription_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      profileDescription_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Description for the application awareness profile on this Cloud Interconnect.
   * </pre>
   *
   * <code>optional string profile_description = 262813286;</code>
   *
   * @return The bytes for profileDescription.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProfileDescriptionBytes() {
    java.lang.Object ref = profileDescription_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      profileDescription_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SHAPE_AVERAGE_PERCENTAGES_FIELD_NUMBER = 259857497;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage>
      shapeAveragePercentages_;

  /**
   *
   *
   * <pre>
   * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage>
      getShapeAveragePercentagesList() {
    return shapeAveragePercentages_;
  }

  /**
   *
   *
   * <pre>
   * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.compute.v1
                  .InterconnectApplicationAwareInterconnectBandwidthPercentageOrBuilder>
      getShapeAveragePercentagesOrBuilderList() {
    return shapeAveragePercentages_;
  }

  /**
   *
   *
   * <pre>
   * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
   * </code>
   */
  @java.lang.Override
  public int getShapeAveragePercentagesCount() {
    return shapeAveragePercentages_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
      getShapeAveragePercentages(int index) {
    return shapeAveragePercentages_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectBandwidthPercentageOrBuilder
      getShapeAveragePercentagesOrBuilder(int index) {
    return shapeAveragePercentages_.get(index);
  }

  public static final int STRICT_PRIORITY_POLICY_FIELD_NUMBER = 145083063;
  private com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy
      strictPriorityPolicy_;

  /**
   * <code>
   * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy strict_priority_policy = 145083063;
   * </code>
   *
   * @return Whether the strictPriorityPolicy field is set.
   */
  @java.lang.Override
  public boolean hasStrictPriorityPolicy() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy strict_priority_policy = 145083063;
   * </code>
   *
   * @return The strictPriorityPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy
      getStrictPriorityPolicy() {
    return strictPriorityPolicy_ == null
        ? com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy
            .getDefaultInstance()
        : strictPriorityPolicy_;
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy strict_priority_policy = 145083063;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1
          .InterconnectApplicationAwareInterconnectStrictPriorityPolicyOrBuilder
      getStrictPriorityPolicyOrBuilder() {
    return strictPriorityPolicy_ == null
        ? com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy
            .getDefaultInstance()
        : strictPriorityPolicy_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(145083063, getStrictPriorityPolicy());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(187018857, getBandwidthPercentagePolicy());
    }
    for (int i = 0; i < shapeAveragePercentages_.size(); i++) {
      output.writeMessage(259857497, shapeAveragePercentages_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 262813286, profileDescription_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              145083063, getStrictPriorityPolicy());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              187018857, getBandwidthPercentagePolicy());
    }
    for (int i = 0; i < shapeAveragePercentages_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              259857497, shapeAveragePercentages_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(262813286, profileDescription_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect other =
        (com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect) obj;

    if (hasBandwidthPercentagePolicy() != other.hasBandwidthPercentagePolicy()) return false;
    if (hasBandwidthPercentagePolicy()) {
      if (!getBandwidthPercentagePolicy().equals(other.getBandwidthPercentagePolicy()))
        return false;
    }
    if (hasProfileDescription() != other.hasProfileDescription()) return false;
    if (hasProfileDescription()) {
      if (!getProfileDescription().equals(other.getProfileDescription())) return false;
    }
    if (!getShapeAveragePercentagesList().equals(other.getShapeAveragePercentagesList()))
      return false;
    if (hasStrictPriorityPolicy() != other.hasStrictPriorityPolicy()) return false;
    if (hasStrictPriorityPolicy()) {
      if (!getStrictPriorityPolicy().equals(other.getStrictPriorityPolicy())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasBandwidthPercentagePolicy()) {
      hash = (37 * hash) + BANDWIDTH_PERCENTAGE_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getBandwidthPercentagePolicy().hashCode();
    }
    if (hasProfileDescription()) {
      hash = (37 * hash) + PROFILE_DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getProfileDescription().hashCode();
    }
    if (getShapeAveragePercentagesCount() > 0) {
      hash = (37 * hash) + SHAPE_AVERAGE_PERCENTAGES_FIELD_NUMBER;
      hash = (53 * hash) + getShapeAveragePercentagesList().hashCode();
    }
    if (hasStrictPriorityPolicy()) {
      hash = (37 * hash) + STRICT_PRIORITY_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getStrictPriorityPolicy().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Configuration information for application awareness on this Cloud Interconnect.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.InterconnectApplicationAwareInterconnect}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InterconnectApplicationAwareInterconnect)
      com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectApplicationAwareInterconnect_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectApplicationAwareInterconnect_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect.class,
              com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect.Builder.class);
    }

    // Construct using
    // com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getBandwidthPercentagePolicyFieldBuilder();
        getShapeAveragePercentagesFieldBuilder();
        getStrictPriorityPolicyFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bandwidthPercentagePolicy_ = null;
      if (bandwidthPercentagePolicyBuilder_ != null) {
        bandwidthPercentagePolicyBuilder_.dispose();
        bandwidthPercentagePolicyBuilder_ = null;
      }
      profileDescription_ = "";
      if (shapeAveragePercentagesBuilder_ == null) {
        shapeAveragePercentages_ = java.util.Collections.emptyList();
      } else {
        shapeAveragePercentages_ = null;
        shapeAveragePercentagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      strictPriorityPolicy_ = null;
      if (strictPriorityPolicyBuilder_ != null) {
        strictPriorityPolicyBuilder_.dispose();
        strictPriorityPolicyBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectApplicationAwareInterconnect_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect build() {
      com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect buildPartial() {
      com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect result =
          new com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect result) {
      if (shapeAveragePercentagesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          shapeAveragePercentages_ =
              java.util.Collections.unmodifiableList(shapeAveragePercentages_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.shapeAveragePercentages_ = shapeAveragePercentages_;
      } else {
        result.shapeAveragePercentages_ = shapeAveragePercentagesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.bandwidthPercentagePolicy_ =
            bandwidthPercentagePolicyBuilder_ == null
                ? bandwidthPercentagePolicy_
                : bandwidthPercentagePolicyBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.profileDescription_ = profileDescription_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.strictPriorityPolicy_ =
            strictPriorityPolicyBuilder_ == null
                ? strictPriorityPolicy_
                : strictPriorityPolicyBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect) {
        return mergeFrom(
            (com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect other) {
      if (other
          == com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect
              .getDefaultInstance()) return this;
      if (other.hasBandwidthPercentagePolicy()) {
        mergeBandwidthPercentagePolicy(other.getBandwidthPercentagePolicy());
      }
      if (other.hasProfileDescription()) {
        profileDescription_ = other.profileDescription_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (shapeAveragePercentagesBuilder_ == null) {
        if (!other.shapeAveragePercentages_.isEmpty()) {
          if (shapeAveragePercentages_.isEmpty()) {
            shapeAveragePercentages_ = other.shapeAveragePercentages_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureShapeAveragePercentagesIsMutable();
            shapeAveragePercentages_.addAll(other.shapeAveragePercentages_);
          }
          onChanged();
        }
      } else {
        if (!other.shapeAveragePercentages_.isEmpty()) {
          if (shapeAveragePercentagesBuilder_.isEmpty()) {
            shapeAveragePercentagesBuilder_.dispose();
            shapeAveragePercentagesBuilder_ = null;
            shapeAveragePercentages_ = other.shapeAveragePercentages_;
            bitField0_ = (bitField0_ & ~0x00000004);
            shapeAveragePercentagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getShapeAveragePercentagesFieldBuilder()
                    : null;
          } else {
            shapeAveragePercentagesBuilder_.addAllMessages(other.shapeAveragePercentages_);
          }
        }
      }
      if (other.hasStrictPriorityPolicy()) {
        mergeStrictPriorityPolicy(other.getStrictPriorityPolicy());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 1160664506:
              {
                input.readMessage(
                    getStrictPriorityPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 1160664506
            case 1496150858:
              {
                input.readMessage(
                    getBandwidthPercentagePolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 1496150858
            case 2078859978:
              {
                com.google.cloud.compute.v1
                        .InterconnectApplicationAwareInterconnectBandwidthPercentage
                    m =
                        input.readMessage(
                            com.google.cloud.compute.v1
                                .InterconnectApplicationAwareInterconnectBandwidthPercentage
                                .parser(),
                            extensionRegistry);
                if (shapeAveragePercentagesBuilder_ == null) {
                  ensureShapeAveragePercentagesIsMutable();
                  shapeAveragePercentages_.add(m);
                } else {
                  shapeAveragePercentagesBuilder_.addMessage(m);
                }
                break;
              } // case 2078859978
            case 2102506290:
              {
                profileDescription_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 2102506290
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.compute.v1
            .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy
        bandwidthPercentagePolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1
                .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy,
            com.google.cloud.compute.v1
                .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy.Builder,
            com.google.cloud.compute.v1
                .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicyOrBuilder>
        bandwidthPercentagePolicyBuilder_;

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy bandwidth_percentage_policy = 187018857;
     * </code>
     *
     * @return Whether the bandwidthPercentagePolicy field is set.
     */
    public boolean hasBandwidthPercentagePolicy() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy bandwidth_percentage_policy = 187018857;
     * </code>
     *
     * @return The bandwidthPercentagePolicy.
     */
    public com.google.cloud.compute.v1
            .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy
        getBandwidthPercentagePolicy() {
      if (bandwidthPercentagePolicyBuilder_ == null) {
        return bandwidthPercentagePolicy_ == null
            ? com.google.cloud.compute.v1
                .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy
                .getDefaultInstance()
            : bandwidthPercentagePolicy_;
      } else {
        return bandwidthPercentagePolicyBuilder_.getMessage();
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy bandwidth_percentage_policy = 187018857;
     * </code>
     */
    public Builder setBandwidthPercentagePolicy(
        com.google.cloud.compute.v1
                .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy
            value) {
      if (bandwidthPercentagePolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bandwidthPercentagePolicy_ = value;
      } else {
        bandwidthPercentagePolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy bandwidth_percentage_policy = 187018857;
     * </code>
     */
    public Builder setBandwidthPercentagePolicy(
        com.google.cloud.compute.v1
                .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy.Builder
            builderForValue) {
      if (bandwidthPercentagePolicyBuilder_ == null) {
        bandwidthPercentagePolicy_ = builderForValue.build();
      } else {
        bandwidthPercentagePolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy bandwidth_percentage_policy = 187018857;
     * </code>
     */
    public Builder mergeBandwidthPercentagePolicy(
        com.google.cloud.compute.v1
                .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy
            value) {
      if (bandwidthPercentagePolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && bandwidthPercentagePolicy_ != null
            && bandwidthPercentagePolicy_
                != com.google.cloud.compute.v1
                    .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy
                    .getDefaultInstance()) {
          getBandwidthPercentagePolicyBuilder().mergeFrom(value);
        } else {
          bandwidthPercentagePolicy_ = value;
        }
      } else {
        bandwidthPercentagePolicyBuilder_.mergeFrom(value);
      }
      if (bandwidthPercentagePolicy_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy bandwidth_percentage_policy = 187018857;
     * </code>
     */
    public Builder clearBandwidthPercentagePolicy() {
      bitField0_ = (bitField0_ & ~0x00000001);
      bandwidthPercentagePolicy_ = null;
      if (bandwidthPercentagePolicyBuilder_ != null) {
        bandwidthPercentagePolicyBuilder_.dispose();
        bandwidthPercentagePolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy bandwidth_percentage_policy = 187018857;
     * </code>
     */
    public com.google.cloud.compute.v1
            .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy.Builder
        getBandwidthPercentagePolicyBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getBandwidthPercentagePolicyFieldBuilder().getBuilder();
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy bandwidth_percentage_policy = 187018857;
     * </code>
     */
    public com.google.cloud.compute.v1
            .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicyOrBuilder
        getBandwidthPercentagePolicyOrBuilder() {
      if (bandwidthPercentagePolicyBuilder_ != null) {
        return bandwidthPercentagePolicyBuilder_.getMessageOrBuilder();
      } else {
        return bandwidthPercentagePolicy_ == null
            ? com.google.cloud.compute.v1
                .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy
                .getDefaultInstance()
            : bandwidthPercentagePolicy_;
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy bandwidth_percentage_policy = 187018857;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1
                .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy,
            com.google.cloud.compute.v1
                .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy.Builder,
            com.google.cloud.compute.v1
                .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicyOrBuilder>
        getBandwidthPercentagePolicyFieldBuilder() {
      if (bandwidthPercentagePolicyBuilder_ == null) {
        bandwidthPercentagePolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1
                    .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy,
                com.google.cloud.compute.v1
                    .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicy.Builder,
                com.google.cloud.compute.v1
                    .InterconnectApplicationAwareInterconnectBandwidthPercentagePolicyOrBuilder>(
                getBandwidthPercentagePolicy(), getParentForChildren(), isClean());
        bandwidthPercentagePolicy_ = null;
      }
      return bandwidthPercentagePolicyBuilder_;
    }

    private java.lang.Object profileDescription_ = "";

    /**
     *
     *
     * <pre>
     * Description for the application awareness profile on this Cloud Interconnect.
     * </pre>
     *
     * <code>optional string profile_description = 262813286;</code>
     *
     * @return Whether the profileDescription field is set.
     */
    public boolean hasProfileDescription() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Description for the application awareness profile on this Cloud Interconnect.
     * </pre>
     *
     * <code>optional string profile_description = 262813286;</code>
     *
     * @return The profileDescription.
     */
    public java.lang.String getProfileDescription() {
      java.lang.Object ref = profileDescription_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        profileDescription_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Description for the application awareness profile on this Cloud Interconnect.
     * </pre>
     *
     * <code>optional string profile_description = 262813286;</code>
     *
     * @return The bytes for profileDescription.
     */
    public com.google.protobuf.ByteString getProfileDescriptionBytes() {
      java.lang.Object ref = profileDescription_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        profileDescription_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Description for the application awareness profile on this Cloud Interconnect.
     * </pre>
     *
     * <code>optional string profile_description = 262813286;</code>
     *
     * @param value The profileDescription to set.
     * @return This builder for chaining.
     */
    public Builder setProfileDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      profileDescription_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Description for the application awareness profile on this Cloud Interconnect.
     * </pre>
     *
     * <code>optional string profile_description = 262813286;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProfileDescription() {
      profileDescription_ = getDefaultInstance().getProfileDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Description for the application awareness profile on this Cloud Interconnect.
     * </pre>
     *
     * <code>optional string profile_description = 262813286;</code>
     *
     * @param value The bytes for profileDescription to set.
     * @return This builder for chaining.
     */
    public Builder setProfileDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      profileDescription_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<
            com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage>
        shapeAveragePercentages_ = java.util.Collections.emptyList();

    private void ensureShapeAveragePercentagesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        shapeAveragePercentages_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1
                    .InterconnectApplicationAwareInterconnectBandwidthPercentage>(
                shapeAveragePercentages_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage,
            com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
                .Builder,
            com.google.cloud.compute.v1
                .InterconnectApplicationAwareInterconnectBandwidthPercentageOrBuilder>
        shapeAveragePercentagesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage>
        getShapeAveragePercentagesList() {
      if (shapeAveragePercentagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(shapeAveragePercentages_);
      } else {
        return shapeAveragePercentagesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
     * </code>
     */
    public int getShapeAveragePercentagesCount() {
      if (shapeAveragePercentagesBuilder_ == null) {
        return shapeAveragePercentages_.size();
      } else {
        return shapeAveragePercentagesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
        getShapeAveragePercentages(int index) {
      if (shapeAveragePercentagesBuilder_ == null) {
        return shapeAveragePercentages_.get(index);
      } else {
        return shapeAveragePercentagesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
     * </code>
     */
    public Builder setShapeAveragePercentages(
        int index,
        com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
            value) {
      if (shapeAveragePercentagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShapeAveragePercentagesIsMutable();
        shapeAveragePercentages_.set(index, value);
        onChanged();
      } else {
        shapeAveragePercentagesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
     * </code>
     */
    public Builder setShapeAveragePercentages(
        int index,
        com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
                .Builder
            builderForValue) {
      if (shapeAveragePercentagesBuilder_ == null) {
        ensureShapeAveragePercentagesIsMutable();
        shapeAveragePercentages_.set(index, builderForValue.build());
        onChanged();
      } else {
        shapeAveragePercentagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
     * </code>
     */
    public Builder addShapeAveragePercentages(
        com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
            value) {
      if (shapeAveragePercentagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShapeAveragePercentagesIsMutable();
        shapeAveragePercentages_.add(value);
        onChanged();
      } else {
        shapeAveragePercentagesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
     * </code>
     */
    public Builder addShapeAveragePercentages(
        int index,
        com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
            value) {
      if (shapeAveragePercentagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShapeAveragePercentagesIsMutable();
        shapeAveragePercentages_.add(index, value);
        onChanged();
      } else {
        shapeAveragePercentagesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
     * </code>
     */
    public Builder addShapeAveragePercentages(
        com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
                .Builder
            builderForValue) {
      if (shapeAveragePercentagesBuilder_ == null) {
        ensureShapeAveragePercentagesIsMutable();
        shapeAveragePercentages_.add(builderForValue.build());
        onChanged();
      } else {
        shapeAveragePercentagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
     * </code>
     */
    public Builder addShapeAveragePercentages(
        int index,
        com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
                .Builder
            builderForValue) {
      if (shapeAveragePercentagesBuilder_ == null) {
        ensureShapeAveragePercentagesIsMutable();
        shapeAveragePercentages_.add(index, builderForValue.build());
        onChanged();
      } else {
        shapeAveragePercentagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
     * </code>
     */
    public Builder addAllShapeAveragePercentages(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.compute.v1
                        .InterconnectApplicationAwareInterconnectBandwidthPercentage>
            values) {
      if (shapeAveragePercentagesBuilder_ == null) {
        ensureShapeAveragePercentagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, shapeAveragePercentages_);
        onChanged();
      } else {
        shapeAveragePercentagesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
     * </code>
     */
    public Builder clearShapeAveragePercentages() {
      if (shapeAveragePercentagesBuilder_ == null) {
        shapeAveragePercentages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        shapeAveragePercentagesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
     * </code>
     */
    public Builder removeShapeAveragePercentages(int index) {
      if (shapeAveragePercentagesBuilder_ == null) {
        ensureShapeAveragePercentagesIsMutable();
        shapeAveragePercentages_.remove(index);
        onChanged();
      } else {
        shapeAveragePercentagesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
            .Builder
        getShapeAveragePercentagesBuilder(int index) {
      return getShapeAveragePercentagesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
     * </code>
     */
    public com.google.cloud.compute.v1
            .InterconnectApplicationAwareInterconnectBandwidthPercentageOrBuilder
        getShapeAveragePercentagesOrBuilder(int index) {
      if (shapeAveragePercentagesBuilder_ == null) {
        return shapeAveragePercentages_.get(index);
      } else {
        return shapeAveragePercentagesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.compute.v1
                    .InterconnectApplicationAwareInterconnectBandwidthPercentageOrBuilder>
        getShapeAveragePercentagesOrBuilderList() {
      if (shapeAveragePercentagesBuilder_ != null) {
        return shapeAveragePercentagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(shapeAveragePercentages_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
            .Builder
        addShapeAveragePercentagesBuilder() {
      return getShapeAveragePercentagesFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1
                  .InterconnectApplicationAwareInterconnectBandwidthPercentage
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
            .Builder
        addShapeAveragePercentagesBuilder(int index) {
      return getShapeAveragePercentagesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1
                  .InterconnectApplicationAwareInterconnectBandwidthPercentage
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional field to specify a list of shape average percentages to be applied in conjunction with StrictPriorityPolicy or BandwidthPercentagePolicy.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage shape_average_percentages = 259857497;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
                .Builder>
        getShapeAveragePercentagesBuilderList() {
      return getShapeAveragePercentagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage,
            com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectBandwidthPercentage
                .Builder,
            com.google.cloud.compute.v1
                .InterconnectApplicationAwareInterconnectBandwidthPercentageOrBuilder>
        getShapeAveragePercentagesFieldBuilder() {
      if (shapeAveragePercentagesBuilder_ == null) {
        shapeAveragePercentagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1
                    .InterconnectApplicationAwareInterconnectBandwidthPercentage,
                com.google.cloud.compute.v1
                    .InterconnectApplicationAwareInterconnectBandwidthPercentage.Builder,
                com.google.cloud.compute.v1
                    .InterconnectApplicationAwareInterconnectBandwidthPercentageOrBuilder>(
                shapeAveragePercentages_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        shapeAveragePercentages_ = null;
      }
      return shapeAveragePercentagesBuilder_;
    }

    private com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy
        strictPriorityPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1
                .InterconnectApplicationAwareInterconnectStrictPriorityPolicy,
            com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy
                .Builder,
            com.google.cloud.compute.v1
                .InterconnectApplicationAwareInterconnectStrictPriorityPolicyOrBuilder>
        strictPriorityPolicyBuilder_;

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy strict_priority_policy = 145083063;
     * </code>
     *
     * @return Whether the strictPriorityPolicy field is set.
     */
    public boolean hasStrictPriorityPolicy() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy strict_priority_policy = 145083063;
     * </code>
     *
     * @return The strictPriorityPolicy.
     */
    public com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy
        getStrictPriorityPolicy() {
      if (strictPriorityPolicyBuilder_ == null) {
        return strictPriorityPolicy_ == null
            ? com.google.cloud.compute.v1
                .InterconnectApplicationAwareInterconnectStrictPriorityPolicy.getDefaultInstance()
            : strictPriorityPolicy_;
      } else {
        return strictPriorityPolicyBuilder_.getMessage();
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy strict_priority_policy = 145083063;
     * </code>
     */
    public Builder setStrictPriorityPolicy(
        com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy
            value) {
      if (strictPriorityPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        strictPriorityPolicy_ = value;
      } else {
        strictPriorityPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy strict_priority_policy = 145083063;
     * </code>
     */
    public Builder setStrictPriorityPolicy(
        com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy
                .Builder
            builderForValue) {
      if (strictPriorityPolicyBuilder_ == null) {
        strictPriorityPolicy_ = builderForValue.build();
      } else {
        strictPriorityPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy strict_priority_policy = 145083063;
     * </code>
     */
    public Builder mergeStrictPriorityPolicy(
        com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy
            value) {
      if (strictPriorityPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && strictPriorityPolicy_ != null
            && strictPriorityPolicy_
                != com.google.cloud.compute.v1
                    .InterconnectApplicationAwareInterconnectStrictPriorityPolicy
                    .getDefaultInstance()) {
          getStrictPriorityPolicyBuilder().mergeFrom(value);
        } else {
          strictPriorityPolicy_ = value;
        }
      } else {
        strictPriorityPolicyBuilder_.mergeFrom(value);
      }
      if (strictPriorityPolicy_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy strict_priority_policy = 145083063;
     * </code>
     */
    public Builder clearStrictPriorityPolicy() {
      bitField0_ = (bitField0_ & ~0x00000008);
      strictPriorityPolicy_ = null;
      if (strictPriorityPolicyBuilder_ != null) {
        strictPriorityPolicyBuilder_.dispose();
        strictPriorityPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy strict_priority_policy = 145083063;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy
            .Builder
        getStrictPriorityPolicyBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getStrictPriorityPolicyFieldBuilder().getBuilder();
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy strict_priority_policy = 145083063;
     * </code>
     */
    public com.google.cloud.compute.v1
            .InterconnectApplicationAwareInterconnectStrictPriorityPolicyOrBuilder
        getStrictPriorityPolicyOrBuilder() {
      if (strictPriorityPolicyBuilder_ != null) {
        return strictPriorityPolicyBuilder_.getMessageOrBuilder();
      } else {
        return strictPriorityPolicy_ == null
            ? com.google.cloud.compute.v1
                .InterconnectApplicationAwareInterconnectStrictPriorityPolicy.getDefaultInstance()
            : strictPriorityPolicy_;
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy strict_priority_policy = 145083063;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1
                .InterconnectApplicationAwareInterconnectStrictPriorityPolicy,
            com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnectStrictPriorityPolicy
                .Builder,
            com.google.cloud.compute.v1
                .InterconnectApplicationAwareInterconnectStrictPriorityPolicyOrBuilder>
        getStrictPriorityPolicyFieldBuilder() {
      if (strictPriorityPolicyBuilder_ == null) {
        strictPriorityPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1
                    .InterconnectApplicationAwareInterconnectStrictPriorityPolicy,
                com.google.cloud.compute.v1
                    .InterconnectApplicationAwareInterconnectStrictPriorityPolicy.Builder,
                com.google.cloud.compute.v1
                    .InterconnectApplicationAwareInterconnectStrictPriorityPolicyOrBuilder>(
                getStrictPriorityPolicy(), getParentForChildren(), isClean());
        strictPriorityPolicy_ = null;
      }
      return strictPriorityPolicyBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InterconnectApplicationAwareInterconnect)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InterconnectApplicationAwareInterconnect)
  private static final com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect();
  }

  public static com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InterconnectApplicationAwareInterconnect> PARSER =
      new com.google.protobuf.AbstractParser<InterconnectApplicationAwareInterconnect>() {
        @java.lang.Override
        public InterconnectApplicationAwareInterconnect parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InterconnectApplicationAwareInterconnect> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InterconnectApplicationAwareInterconnect> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectApplicationAwareInterconnect
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
