/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * A request message for ReservationBlocks.Get. See the method description for details.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.GetReservationBlockRequest}
 */
public final class GetReservationBlockRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.GetReservationBlockRequest)
    GetReservationBlockRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use GetReservationBlockRequest.newBuilder() to construct.
  private GetReservationBlockRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GetReservationBlockRequest() {
    project_ = "";
    reservation_ = "";
    reservationBlock_ = "";
    view_ = "";
    zone_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GetReservationBlockRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_GetReservationBlockRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_GetReservationBlockRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.GetReservationBlockRequest.class,
            com.google.cloud.compute.v1.GetReservationBlockRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * View of the Block.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.GetReservationBlockRequest.View}
   */
  public enum View implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_VIEW = 0;</code>
     */
    UNDEFINED_VIEW(0),
    /**
     *
     *
     * <pre>
     * This view includes basic information about the reservation block
     * </pre>
     *
     * <code>BASIC = 62970894;</code>
     */
    BASIC(62970894),
    /**
     *
     *
     * <pre>
     * The default / unset value. The API will default to the BASIC view.
     * </pre>
     *
     * <code>BLOCK_VIEW_UNSPECIFIED = 275070479;</code>
     */
    BLOCK_VIEW_UNSPECIFIED(275070479),
    /**
     *
     *
     * <pre>
     * Includes detailed topology view.
     * </pre>
     *
     * <code>FULL = 2169487;</code>
     */
    FULL(2169487),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_VIEW = 0;</code>
     */
    public static final int UNDEFINED_VIEW_VALUE = 0;

    /**
     *
     *
     * <pre>
     * This view includes basic information about the reservation block
     * </pre>
     *
     * <code>BASIC = 62970894;</code>
     */
    public static final int BASIC_VALUE = 62970894;

    /**
     *
     *
     * <pre>
     * The default / unset value. The API will default to the BASIC view.
     * </pre>
     *
     * <code>BLOCK_VIEW_UNSPECIFIED = 275070479;</code>
     */
    public static final int BLOCK_VIEW_UNSPECIFIED_VALUE = 275070479;

    /**
     *
     *
     * <pre>
     * Includes detailed topology view.
     * </pre>
     *
     * <code>FULL = 2169487;</code>
     */
    public static final int FULL_VALUE = 2169487;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static View valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static View forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_VIEW;
        case 62970894:
          return BASIC;
        case 275070479:
          return BLOCK_VIEW_UNSPECIFIED;
        case 2169487:
          return FULL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<View> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<View> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<View>() {
          public View findValueByNumber(int number) {
            return View.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.GetReservationBlockRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final View[] VALUES = values();

    public static View valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private View(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.GetReservationBlockRequest.View)
  }

  private int bitField0_;
  public static final int PROJECT_FIELD_NUMBER = 227560217;

  @SuppressWarnings("serial")
  private volatile java.lang.Object project_ = "";

  /**
   *
   *
   * <pre>
   * Project ID for this request.
   * </pre>
   *
   * <code>string project = 227560217 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The project.
   */
  @java.lang.Override
  public java.lang.String getProject() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      project_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Project ID for this request.
   * </pre>
   *
   * <code>string project = 227560217 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for project.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectBytes() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      project_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESERVATION_FIELD_NUMBER = 47530956;

  @SuppressWarnings("serial")
  private volatile java.lang.Object reservation_ = "";

  /**
   *
   *
   * <pre>
   * The name of the reservation. Name should conform to RFC1035 or be a resource ID.
   * </pre>
   *
   * <code>string reservation = 47530956 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The reservation.
   */
  @java.lang.Override
  public java.lang.String getReservation() {
    java.lang.Object ref = reservation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      reservation_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The name of the reservation. Name should conform to RFC1035 or be a resource ID.
   * </pre>
   *
   * <code>string reservation = 47530956 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for reservation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReservationBytes() {
    java.lang.Object ref = reservation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      reservation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESERVATION_BLOCK_FIELD_NUMBER = 532832858;

  @SuppressWarnings("serial")
  private volatile java.lang.Object reservationBlock_ = "";

  /**
   *
   *
   * <pre>
   * The name of the reservation block. Name should conform to RFC1035 or be a resource ID.
   * </pre>
   *
   * <code>string reservation_block = 532832858 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The reservationBlock.
   */
  @java.lang.Override
  public java.lang.String getReservationBlock() {
    java.lang.Object ref = reservationBlock_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      reservationBlock_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The name of the reservation block. Name should conform to RFC1035 or be a resource ID.
   * </pre>
   *
   * <code>string reservation_block = 532832858 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for reservationBlock.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReservationBlockBytes() {
    java.lang.Object ref = reservationBlock_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      reservationBlock_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VIEW_FIELD_NUMBER = 3619493;

  @SuppressWarnings("serial")
  private volatile java.lang.Object view_ = "";

  /**
   *
   *
   * <pre>
   * View of the Block.
   * Check the View enum for the list of possible values.
   * </pre>
   *
   * <code>optional string view = 3619493;</code>
   *
   * @return Whether the view field is set.
   */
  @java.lang.Override
  public boolean hasView() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * View of the Block.
   * Check the View enum for the list of possible values.
   * </pre>
   *
   * <code>optional string view = 3619493;</code>
   *
   * @return The view.
   */
  @java.lang.Override
  public java.lang.String getView() {
    java.lang.Object ref = view_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      view_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * View of the Block.
   * Check the View enum for the list of possible values.
   * </pre>
   *
   * <code>optional string view = 3619493;</code>
   *
   * @return The bytes for view.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getViewBytes() {
    java.lang.Object ref = view_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      view_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONE_FIELD_NUMBER = 3744684;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";

  /**
   *
   *
   * <pre>
   * Name of the zone for this request. Zone name should conform to RFC1035.
   * </pre>
   *
   * <code>string zone = 3744684 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The zone.
   */
  @java.lang.Override
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the zone for this request. Zone name should conform to RFC1035.
   * </pre>
   *
   * <code>string zone = 3744684 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for zone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3619493, view_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3744684, zone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reservation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 47530956, reservation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 227560217, project_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reservationBlock_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 532832858, reservationBlock_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3619493, view_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3744684, zone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reservation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(47530956, reservation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(227560217, project_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reservationBlock_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(532832858, reservationBlock_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.GetReservationBlockRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.GetReservationBlockRequest other =
        (com.google.cloud.compute.v1.GetReservationBlockRequest) obj;

    if (!getProject().equals(other.getProject())) return false;
    if (!getReservation().equals(other.getReservation())) return false;
    if (!getReservationBlock().equals(other.getReservationBlock())) return false;
    if (hasView() != other.hasView()) return false;
    if (hasView()) {
      if (!getView().equals(other.getView())) return false;
    }
    if (!getZone().equals(other.getZone())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_FIELD_NUMBER;
    hash = (53 * hash) + getProject().hashCode();
    hash = (37 * hash) + RESERVATION_FIELD_NUMBER;
    hash = (53 * hash) + getReservation().hashCode();
    hash = (37 * hash) + RESERVATION_BLOCK_FIELD_NUMBER;
    hash = (53 * hash) + getReservationBlock().hashCode();
    if (hasView()) {
      hash = (37 * hash) + VIEW_FIELD_NUMBER;
      hash = (53 * hash) + getView().hashCode();
    }
    hash = (37 * hash) + ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getZone().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.GetReservationBlockRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.GetReservationBlockRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.GetReservationBlockRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.GetReservationBlockRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.GetReservationBlockRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.GetReservationBlockRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.GetReservationBlockRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.GetReservationBlockRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.GetReservationBlockRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.GetReservationBlockRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.GetReservationBlockRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.GetReservationBlockRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.GetReservationBlockRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A request message for ReservationBlocks.Get. See the method description for details.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.GetReservationBlockRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.GetReservationBlockRequest)
      com.google.cloud.compute.v1.GetReservationBlockRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_GetReservationBlockRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_GetReservationBlockRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.GetReservationBlockRequest.class,
              com.google.cloud.compute.v1.GetReservationBlockRequest.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.GetReservationBlockRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      project_ = "";
      reservation_ = "";
      reservationBlock_ = "";
      view_ = "";
      zone_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_GetReservationBlockRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.GetReservationBlockRequest getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.GetReservationBlockRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.GetReservationBlockRequest build() {
      com.google.cloud.compute.v1.GetReservationBlockRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.GetReservationBlockRequest buildPartial() {
      com.google.cloud.compute.v1.GetReservationBlockRequest result =
          new com.google.cloud.compute.v1.GetReservationBlockRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.GetReservationBlockRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.project_ = project_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.reservation_ = reservation_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.reservationBlock_ = reservationBlock_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.view_ = view_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.zone_ = zone_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.GetReservationBlockRequest) {
        return mergeFrom((com.google.cloud.compute.v1.GetReservationBlockRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.GetReservationBlockRequest other) {
      if (other == com.google.cloud.compute.v1.GetReservationBlockRequest.getDefaultInstance())
        return this;
      if (!other.getProject().isEmpty()) {
        project_ = other.project_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getReservation().isEmpty()) {
        reservation_ = other.reservation_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getReservationBlock().isEmpty()) {
        reservationBlock_ = other.reservationBlock_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasView()) {
        view_ = other.view_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getZone().isEmpty()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 28955946:
              {
                view_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 28955946
            case 29957474:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 29957474
            case 380247650:
              {
                reservation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 380247650
            case 1820481738:
              {
                project_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 1820481738
            case -32304430:
              {
                reservationBlock_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -32304430
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object project_ = "";

    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>string project = 227560217 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The project.
     */
    public java.lang.String getProject() {
      java.lang.Object ref = project_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        project_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>string project = 227560217 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for project.
     */
    public com.google.protobuf.ByteString getProjectBytes() {
      java.lang.Object ref = project_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        project_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>string project = 227560217 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The project to set.
     * @return This builder for chaining.
     */
    public Builder setProject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      project_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>string project = 227560217 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProject() {
      project_ = getDefaultInstance().getProject();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>string project = 227560217 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for project to set.
     * @return This builder for chaining.
     */
    public Builder setProjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      project_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object reservation_ = "";

    /**
     *
     *
     * <pre>
     * The name of the reservation. Name should conform to RFC1035 or be a resource ID.
     * </pre>
     *
     * <code>string reservation = 47530956 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The reservation.
     */
    public java.lang.String getReservation() {
      java.lang.Object ref = reservation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        reservation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the reservation. Name should conform to RFC1035 or be a resource ID.
     * </pre>
     *
     * <code>string reservation = 47530956 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for reservation.
     */
    public com.google.protobuf.ByteString getReservationBytes() {
      java.lang.Object ref = reservation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        reservation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the reservation. Name should conform to RFC1035 or be a resource ID.
     * </pre>
     *
     * <code>string reservation = 47530956 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The reservation to set.
     * @return This builder for chaining.
     */
    public Builder setReservation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      reservation_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the reservation. Name should conform to RFC1035 or be a resource ID.
     * </pre>
     *
     * <code>string reservation = 47530956 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReservation() {
      reservation_ = getDefaultInstance().getReservation();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the reservation. Name should conform to RFC1035 or be a resource ID.
     * </pre>
     *
     * <code>string reservation = 47530956 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for reservation to set.
     * @return This builder for chaining.
     */
    public Builder setReservationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      reservation_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object reservationBlock_ = "";

    /**
     *
     *
     * <pre>
     * The name of the reservation block. Name should conform to RFC1035 or be a resource ID.
     * </pre>
     *
     * <code>string reservation_block = 532832858 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The reservationBlock.
     */
    public java.lang.String getReservationBlock() {
      java.lang.Object ref = reservationBlock_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        reservationBlock_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the reservation block. Name should conform to RFC1035 or be a resource ID.
     * </pre>
     *
     * <code>string reservation_block = 532832858 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for reservationBlock.
     */
    public com.google.protobuf.ByteString getReservationBlockBytes() {
      java.lang.Object ref = reservationBlock_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        reservationBlock_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the reservation block. Name should conform to RFC1035 or be a resource ID.
     * </pre>
     *
     * <code>string reservation_block = 532832858 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The reservationBlock to set.
     * @return This builder for chaining.
     */
    public Builder setReservationBlock(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      reservationBlock_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the reservation block. Name should conform to RFC1035 or be a resource ID.
     * </pre>
     *
     * <code>string reservation_block = 532832858 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReservationBlock() {
      reservationBlock_ = getDefaultInstance().getReservationBlock();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the reservation block. Name should conform to RFC1035 or be a resource ID.
     * </pre>
     *
     * <code>string reservation_block = 532832858 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for reservationBlock to set.
     * @return This builder for chaining.
     */
    public Builder setReservationBlockBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      reservationBlock_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object view_ = "";

    /**
     *
     *
     * <pre>
     * View of the Block.
     * Check the View enum for the list of possible values.
     * </pre>
     *
     * <code>optional string view = 3619493;</code>
     *
     * @return Whether the view field is set.
     */
    public boolean hasView() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * View of the Block.
     * Check the View enum for the list of possible values.
     * </pre>
     *
     * <code>optional string view = 3619493;</code>
     *
     * @return The view.
     */
    public java.lang.String getView() {
      java.lang.Object ref = view_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        view_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * View of the Block.
     * Check the View enum for the list of possible values.
     * </pre>
     *
     * <code>optional string view = 3619493;</code>
     *
     * @return The bytes for view.
     */
    public com.google.protobuf.ByteString getViewBytes() {
      java.lang.Object ref = view_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        view_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * View of the Block.
     * Check the View enum for the list of possible values.
     * </pre>
     *
     * <code>optional string view = 3619493;</code>
     *
     * @param value The view to set.
     * @return This builder for chaining.
     */
    public Builder setView(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      view_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * View of the Block.
     * Check the View enum for the list of possible values.
     * </pre>
     *
     * <code>optional string view = 3619493;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearView() {
      view_ = getDefaultInstance().getView();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * View of the Block.
     * Check the View enum for the list of possible values.
     * </pre>
     *
     * <code>optional string view = 3619493;</code>
     *
     * @param value The bytes for view to set.
     * @return This builder for chaining.
     */
    public Builder setViewBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      view_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object zone_ = "";

    /**
     *
     *
     * <pre>
     * Name of the zone for this request. Zone name should conform to RFC1035.
     * </pre>
     *
     * <code>string zone = 3744684 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The zone.
     */
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the zone for this request. Zone name should conform to RFC1035.
     * </pre>
     *
     * <code>string zone = 3744684 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for zone.
     */
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the zone for this request. Zone name should conform to RFC1035.
     * </pre>
     *
     * <code>string zone = 3744684 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the zone for this request. Zone name should conform to RFC1035.
     * </pre>
     *
     * <code>string zone = 3744684 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the zone for this request. Zone name should conform to RFC1035.
     * </pre>
     *
     * <code>string zone = 3744684 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.GetReservationBlockRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.GetReservationBlockRequest)
  private static final com.google.cloud.compute.v1.GetReservationBlockRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.GetReservationBlockRequest();
  }

  public static com.google.cloud.compute.v1.GetReservationBlockRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GetReservationBlockRequest> PARSER =
      new com.google.protobuf.AbstractParser<GetReservationBlockRequest>() {
        @java.lang.Override
        public GetReservationBlockRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GetReservationBlockRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GetReservationBlockRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.GetReservationBlockRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
