/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

public interface CustomErrorResponsePolicyCustomErrorResponseRuleOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.compute.v1.CustomErrorResponsePolicyCustomErrorResponseRule)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Valid values include: - A number between 400 and 599: For example 401 or 503, in which case the load balancer applies the policy if the error code exactly matches this value. - 5xx: Load Balancer will apply the policy if the backend service responds with any response code in the range of 500 to 599. - 4xx: Load Balancer will apply the policy if the backend service responds with any response code in the range of 400 to 499. Values must be unique within matchResponseCodes and across all errorResponseRules of CustomErrorResponsePolicy.
   * </pre>
   *
   * <code>repeated string match_response_codes = 104973410;</code>
   *
   * @return A list containing the matchResponseCodes.
   */
  java.util.List<java.lang.String> getMatchResponseCodesList();

  /**
   *
   *
   * <pre>
   * Valid values include: - A number between 400 and 599: For example 401 or 503, in which case the load balancer applies the policy if the error code exactly matches this value. - 5xx: Load Balancer will apply the policy if the backend service responds with any response code in the range of 500 to 599. - 4xx: Load Balancer will apply the policy if the backend service responds with any response code in the range of 400 to 499. Values must be unique within matchResponseCodes and across all errorResponseRules of CustomErrorResponsePolicy.
   * </pre>
   *
   * <code>repeated string match_response_codes = 104973410;</code>
   *
   * @return The count of matchResponseCodes.
   */
  int getMatchResponseCodesCount();

  /**
   *
   *
   * <pre>
   * Valid values include: - A number between 400 and 599: For example 401 or 503, in which case the load balancer applies the policy if the error code exactly matches this value. - 5xx: Load Balancer will apply the policy if the backend service responds with any response code in the range of 500 to 599. - 4xx: Load Balancer will apply the policy if the backend service responds with any response code in the range of 400 to 499. Values must be unique within matchResponseCodes and across all errorResponseRules of CustomErrorResponsePolicy.
   * </pre>
   *
   * <code>repeated string match_response_codes = 104973410;</code>
   *
   * @param index The index of the element to return.
   * @return The matchResponseCodes at the given index.
   */
  java.lang.String getMatchResponseCodes(int index);

  /**
   *
   *
   * <pre>
   * Valid values include: - A number between 400 and 599: For example 401 or 503, in which case the load balancer applies the policy if the error code exactly matches this value. - 5xx: Load Balancer will apply the policy if the backend service responds with any response code in the range of 500 to 599. - 4xx: Load Balancer will apply the policy if the backend service responds with any response code in the range of 400 to 499. Values must be unique within matchResponseCodes and across all errorResponseRules of CustomErrorResponsePolicy.
   * </pre>
   *
   * <code>repeated string match_response_codes = 104973410;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the matchResponseCodes at the given index.
   */
  com.google.protobuf.ByteString getMatchResponseCodesBytes(int index);

  /**
   *
   *
   * <pre>
   * The HTTP status code returned with the response containing the custom error content. If overrideResponseCode is not supplied, the same response code returned by the original backend bucket or backend service is returned to the client.
   * </pre>
   *
   * <code>optional int32 override_response_code = 530328568;</code>
   *
   * @return Whether the overrideResponseCode field is set.
   */
  boolean hasOverrideResponseCode();

  /**
   *
   *
   * <pre>
   * The HTTP status code returned with the response containing the custom error content. If overrideResponseCode is not supplied, the same response code returned by the original backend bucket or backend service is returned to the client.
   * </pre>
   *
   * <code>optional int32 override_response_code = 530328568;</code>
   *
   * @return The overrideResponseCode.
   */
  int getOverrideResponseCode();

  /**
   *
   *
   * <pre>
   * The full path to a file within backendBucket . For example: /errors/defaultError.html path must start with a leading slash. path cannot have trailing slashes. If the file is not available in backendBucket or the load balancer cannot reach the BackendBucket, a simple Not Found Error is returned to the client. The value must be from 1 to 1024 characters
   * </pre>
   *
   * <code>optional string path = 3433509;</code>
   *
   * @return Whether the path field is set.
   */
  boolean hasPath();

  /**
   *
   *
   * <pre>
   * The full path to a file within backendBucket . For example: /errors/defaultError.html path must start with a leading slash. path cannot have trailing slashes. If the file is not available in backendBucket or the load balancer cannot reach the BackendBucket, a simple Not Found Error is returned to the client. The value must be from 1 to 1024 characters
   * </pre>
   *
   * <code>optional string path = 3433509;</code>
   *
   * @return The path.
   */
  java.lang.String getPath();

  /**
   *
   *
   * <pre>
   * The full path to a file within backendBucket . For example: /errors/defaultError.html path must start with a leading slash. path cannot have trailing slashes. If the file is not available in backendBucket or the load balancer cannot reach the BackendBucket, a simple Not Found Error is returned to the client. The value must be from 1 to 1024 characters
   * </pre>
   *
   * <code>optional string path = 3433509;</code>
   *
   * @return The bytes for path.
   */
  com.google.protobuf.ByteString getPathBytes();
}
