/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Scaling based on user-defined schedule. The message describes a single scaling schedule. A scaling schedule changes the minimum number of VM instances an autoscaler can recommend, which can trigger scaling out.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.AutoscalingPolicyScalingSchedule}
 */
public final class AutoscalingPolicyScalingSchedule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.AutoscalingPolicyScalingSchedule)
    AutoscalingPolicyScalingScheduleOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use AutoscalingPolicyScalingSchedule.newBuilder() to construct.
  private AutoscalingPolicyScalingSchedule(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AutoscalingPolicyScalingSchedule() {
    description_ = "";
    schedule_ = "";
    timeZone_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AutoscalingPolicyScalingSchedule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_AutoscalingPolicyScalingSchedule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_AutoscalingPolicyScalingSchedule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule.class,
            com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule.Builder.class);
  }

  private int bitField0_;
  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * A description of a scaling schedule.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * A description of a scaling schedule.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A description of a scaling schedule.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISABLED_FIELD_NUMBER = 270940796;
  private boolean disabled_ = false;

  /**
   *
   *
   * <pre>
   * A boolean value that specifies whether a scaling schedule can influence autoscaler recommendations. If set to true, then a scaling schedule has no effect. This field is optional, and its value is false by default.
   * </pre>
   *
   * <code>optional bool disabled = 270940796;</code>
   *
   * @return Whether the disabled field is set.
   */
  @java.lang.Override
  public boolean hasDisabled() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * A boolean value that specifies whether a scaling schedule can influence autoscaler recommendations. If set to true, then a scaling schedule has no effect. This field is optional, and its value is false by default.
   * </pre>
   *
   * <code>optional bool disabled = 270940796;</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public boolean getDisabled() {
    return disabled_;
  }

  public static final int DURATION_SEC_FIELD_NUMBER = 212356902;
  private int durationSec_ = 0;

  /**
   *
   *
   * <pre>
   * The duration of time intervals, in seconds, for which this scaling schedule is to run. The minimum allowed value is 300. This field is required.
   * </pre>
   *
   * <code>optional int32 duration_sec = 212356902;</code>
   *
   * @return Whether the durationSec field is set.
   */
  @java.lang.Override
  public boolean hasDurationSec() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * The duration of time intervals, in seconds, for which this scaling schedule is to run. The minimum allowed value is 300. This field is required.
   * </pre>
   *
   * <code>optional int32 duration_sec = 212356902;</code>
   *
   * @return The durationSec.
   */
  @java.lang.Override
  public int getDurationSec() {
    return durationSec_;
  }

  public static final int MIN_REQUIRED_REPLICAS_FIELD_NUMBER = 365514414;
  private int minRequiredReplicas_ = 0;

  /**
   *
   *
   * <pre>
   * The minimum number of VM instances that the autoscaler will recommend in time intervals starting according to schedule. This field is required.
   * </pre>
   *
   * <code>optional int32 min_required_replicas = 365514414;</code>
   *
   * @return Whether the minRequiredReplicas field is set.
   */
  @java.lang.Override
  public boolean hasMinRequiredReplicas() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * The minimum number of VM instances that the autoscaler will recommend in time intervals starting according to schedule. This field is required.
   * </pre>
   *
   * <code>optional int32 min_required_replicas = 365514414;</code>
   *
   * @return The minRequiredReplicas.
   */
  @java.lang.Override
  public int getMinRequiredReplicas() {
    return minRequiredReplicas_;
  }

  public static final int SCHEDULE_FIELD_NUMBER = 375820951;

  @SuppressWarnings("serial")
  private volatile java.lang.Object schedule_ = "";

  /**
   *
   *
   * <pre>
   * The start timestamps of time intervals when this scaling schedule is to provide a scaling signal. This field uses the extended cron format (with an optional year field). The expression can describe a single timestamp if the optional year is set, in which case the scaling schedule runs once. The schedule is interpreted with respect to time_zone. This field is required. Note: These timestamps only describe when autoscaler starts providing the scaling signal. The VMs need additional time to become serving.
   * </pre>
   *
   * <code>optional string schedule = 375820951;</code>
   *
   * @return Whether the schedule field is set.
   */
  @java.lang.Override
  public boolean hasSchedule() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * The start timestamps of time intervals when this scaling schedule is to provide a scaling signal. This field uses the extended cron format (with an optional year field). The expression can describe a single timestamp if the optional year is set, in which case the scaling schedule runs once. The schedule is interpreted with respect to time_zone. This field is required. Note: These timestamps only describe when autoscaler starts providing the scaling signal. The VMs need additional time to become serving.
   * </pre>
   *
   * <code>optional string schedule = 375820951;</code>
   *
   * @return The schedule.
   */
  @java.lang.Override
  public java.lang.String getSchedule() {
    java.lang.Object ref = schedule_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      schedule_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The start timestamps of time intervals when this scaling schedule is to provide a scaling signal. This field uses the extended cron format (with an optional year field). The expression can describe a single timestamp if the optional year is set, in which case the scaling schedule runs once. The schedule is interpreted with respect to time_zone. This field is required. Note: These timestamps only describe when autoscaler starts providing the scaling signal. The VMs need additional time to become serving.
   * </pre>
   *
   * <code>optional string schedule = 375820951;</code>
   *
   * @return The bytes for schedule.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getScheduleBytes() {
    java.lang.Object ref = schedule_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      schedule_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIME_ZONE_FIELD_NUMBER = 36848094;

  @SuppressWarnings("serial")
  private volatile java.lang.Object timeZone_ = "";

  /**
   *
   *
   * <pre>
   * The time zone to use when interpreting the schedule. The value of this field must be a time zone name from the tz database: https://en.wikipedia.org/wiki/Tz_database. This field is assigned a default value of "UTC" if left empty.
   * </pre>
   *
   * <code>optional string time_zone = 36848094;</code>
   *
   * @return Whether the timeZone field is set.
   */
  @java.lang.Override
  public boolean hasTimeZone() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * The time zone to use when interpreting the schedule. The value of this field must be a time zone name from the tz database: https://en.wikipedia.org/wiki/Tz_database. This field is assigned a default value of "UTC" if left empty.
   * </pre>
   *
   * <code>optional string time_zone = 36848094;</code>
   *
   * @return The timeZone.
   */
  @java.lang.Override
  public java.lang.String getTimeZone() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      timeZone_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The time zone to use when interpreting the schedule. The value of this field must be a time zone name from the tz database: https://en.wikipedia.org/wiki/Tz_database. This field is assigned a default value of "UTC" if left empty.
   * </pre>
   *
   * <code>optional string time_zone = 36848094;</code>
   *
   * @return The bytes for timeZone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTimeZoneBytes() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      timeZone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 36848094, timeZone_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt32(212356902, durationSec_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(270940796, disabled_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt32(365514414, minRequiredReplicas_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 375820951, schedule_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(36848094, timeZone_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(212356902, durationSec_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(270940796, disabled_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(365514414, minRequiredReplicas_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(375820951, schedule_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule other =
        (com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule) obj;

    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasDisabled() != other.hasDisabled()) return false;
    if (hasDisabled()) {
      if (getDisabled() != other.getDisabled()) return false;
    }
    if (hasDurationSec() != other.hasDurationSec()) return false;
    if (hasDurationSec()) {
      if (getDurationSec() != other.getDurationSec()) return false;
    }
    if (hasMinRequiredReplicas() != other.hasMinRequiredReplicas()) return false;
    if (hasMinRequiredReplicas()) {
      if (getMinRequiredReplicas() != other.getMinRequiredReplicas()) return false;
    }
    if (hasSchedule() != other.hasSchedule()) return false;
    if (hasSchedule()) {
      if (!getSchedule().equals(other.getSchedule())) return false;
    }
    if (hasTimeZone() != other.hasTimeZone()) return false;
    if (hasTimeZone()) {
      if (!getTimeZone().equals(other.getTimeZone())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasDisabled()) {
      hash = (37 * hash) + DISABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
    }
    if (hasDurationSec()) {
      hash = (37 * hash) + DURATION_SEC_FIELD_NUMBER;
      hash = (53 * hash) + getDurationSec();
    }
    if (hasMinRequiredReplicas()) {
      hash = (37 * hash) + MIN_REQUIRED_REPLICAS_FIELD_NUMBER;
      hash = (53 * hash) + getMinRequiredReplicas();
    }
    if (hasSchedule()) {
      hash = (37 * hash) + SCHEDULE_FIELD_NUMBER;
      hash = (53 * hash) + getSchedule().hashCode();
    }
    if (hasTimeZone()) {
      hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
      hash = (53 * hash) + getTimeZone().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Scaling based on user-defined schedule. The message describes a single scaling schedule. A scaling schedule changes the minimum number of VM instances an autoscaler can recommend, which can trigger scaling out.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.AutoscalingPolicyScalingSchedule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.AutoscalingPolicyScalingSchedule)
      com.google.cloud.compute.v1.AutoscalingPolicyScalingScheduleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AutoscalingPolicyScalingSchedule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AutoscalingPolicyScalingSchedule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule.class,
              com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      description_ = "";
      disabled_ = false;
      durationSec_ = 0;
      minRequiredReplicas_ = 0;
      schedule_ = "";
      timeZone_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AutoscalingPolicyScalingSchedule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule build() {
      com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule buildPartial() {
      com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule result =
          new com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.disabled_ = disabled_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.durationSec_ = durationSec_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.minRequiredReplicas_ = minRequiredReplicas_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.schedule_ = schedule_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.timeZone_ = timeZone_;
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule) {
        return mergeFrom((com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule other) {
      if (other
          == com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule.getDefaultInstance())
        return this;
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDisabled()) {
        setDisabled(other.getDisabled());
      }
      if (other.hasDurationSec()) {
        setDurationSec(other.getDurationSec());
      }
      if (other.hasMinRequiredReplicas()) {
        setMinRequiredReplicas(other.getMinRequiredReplicas());
      }
      if (other.hasSchedule()) {
        schedule_ = other.schedule_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasTimeZone()) {
        timeZone_ = other.timeZone_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 294784754:
              {
                timeZone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 294784754
            case 1698855216:
              {
                durationSec_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 1698855216
            case -2127440928:
              {
                disabled_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case -2127440928
            case -1370851984:
              {
                minRequiredReplicas_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case -1370851984
            case -1288399686:
              {
                schedule_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -1288399686
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -911466526
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * A description of a scaling schedule.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * A description of a scaling schedule.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A description of a scaling schedule.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A description of a scaling schedule.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A description of a scaling schedule.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A description of a scaling schedule.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean disabled_;

    /**
     *
     *
     * <pre>
     * A boolean value that specifies whether a scaling schedule can influence autoscaler recommendations. If set to true, then a scaling schedule has no effect. This field is optional, and its value is false by default.
     * </pre>
     *
     * <code>optional bool disabled = 270940796;</code>
     *
     * @return Whether the disabled field is set.
     */
    @java.lang.Override
    public boolean hasDisabled() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * A boolean value that specifies whether a scaling schedule can influence autoscaler recommendations. If set to true, then a scaling schedule has no effect. This field is optional, and its value is false by default.
     * </pre>
     *
     * <code>optional bool disabled = 270940796;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }

    /**
     *
     *
     * <pre>
     * A boolean value that specifies whether a scaling schedule can influence autoscaler recommendations. If set to true, then a scaling schedule has no effect. This field is optional, and its value is false by default.
     * </pre>
     *
     * <code>optional bool disabled = 270940796;</code>
     *
     * @param value The disabled to set.
     * @return This builder for chaining.
     */
    public Builder setDisabled(boolean value) {

      disabled_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A boolean value that specifies whether a scaling schedule can influence autoscaler recommendations. If set to true, then a scaling schedule has no effect. This field is optional, and its value is false by default.
     * </pre>
     *
     * <code>optional bool disabled = 270940796;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisabled() {
      bitField0_ = (bitField0_ & ~0x00000002);
      disabled_ = false;
      onChanged();
      return this;
    }

    private int durationSec_;

    /**
     *
     *
     * <pre>
     * The duration of time intervals, in seconds, for which this scaling schedule is to run. The minimum allowed value is 300. This field is required.
     * </pre>
     *
     * <code>optional int32 duration_sec = 212356902;</code>
     *
     * @return Whether the durationSec field is set.
     */
    @java.lang.Override
    public boolean hasDurationSec() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The duration of time intervals, in seconds, for which this scaling schedule is to run. The minimum allowed value is 300. This field is required.
     * </pre>
     *
     * <code>optional int32 duration_sec = 212356902;</code>
     *
     * @return The durationSec.
     */
    @java.lang.Override
    public int getDurationSec() {
      return durationSec_;
    }

    /**
     *
     *
     * <pre>
     * The duration of time intervals, in seconds, for which this scaling schedule is to run. The minimum allowed value is 300. This field is required.
     * </pre>
     *
     * <code>optional int32 duration_sec = 212356902;</code>
     *
     * @param value The durationSec to set.
     * @return This builder for chaining.
     */
    public Builder setDurationSec(int value) {

      durationSec_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The duration of time intervals, in seconds, for which this scaling schedule is to run. The minimum allowed value is 300. This field is required.
     * </pre>
     *
     * <code>optional int32 duration_sec = 212356902;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDurationSec() {
      bitField0_ = (bitField0_ & ~0x00000004);
      durationSec_ = 0;
      onChanged();
      return this;
    }

    private int minRequiredReplicas_;

    /**
     *
     *
     * <pre>
     * The minimum number of VM instances that the autoscaler will recommend in time intervals starting according to schedule. This field is required.
     * </pre>
     *
     * <code>optional int32 min_required_replicas = 365514414;</code>
     *
     * @return Whether the minRequiredReplicas field is set.
     */
    @java.lang.Override
    public boolean hasMinRequiredReplicas() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * The minimum number of VM instances that the autoscaler will recommend in time intervals starting according to schedule. This field is required.
     * </pre>
     *
     * <code>optional int32 min_required_replicas = 365514414;</code>
     *
     * @return The minRequiredReplicas.
     */
    @java.lang.Override
    public int getMinRequiredReplicas() {
      return minRequiredReplicas_;
    }

    /**
     *
     *
     * <pre>
     * The minimum number of VM instances that the autoscaler will recommend in time intervals starting according to schedule. This field is required.
     * </pre>
     *
     * <code>optional int32 min_required_replicas = 365514414;</code>
     *
     * @param value The minRequiredReplicas to set.
     * @return This builder for chaining.
     */
    public Builder setMinRequiredReplicas(int value) {

      minRequiredReplicas_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The minimum number of VM instances that the autoscaler will recommend in time intervals starting according to schedule. This field is required.
     * </pre>
     *
     * <code>optional int32 min_required_replicas = 365514414;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinRequiredReplicas() {
      bitField0_ = (bitField0_ & ~0x00000008);
      minRequiredReplicas_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object schedule_ = "";

    /**
     *
     *
     * <pre>
     * The start timestamps of time intervals when this scaling schedule is to provide a scaling signal. This field uses the extended cron format (with an optional year field). The expression can describe a single timestamp if the optional year is set, in which case the scaling schedule runs once. The schedule is interpreted with respect to time_zone. This field is required. Note: These timestamps only describe when autoscaler starts providing the scaling signal. The VMs need additional time to become serving.
     * </pre>
     *
     * <code>optional string schedule = 375820951;</code>
     *
     * @return Whether the schedule field is set.
     */
    public boolean hasSchedule() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * The start timestamps of time intervals when this scaling schedule is to provide a scaling signal. This field uses the extended cron format (with an optional year field). The expression can describe a single timestamp if the optional year is set, in which case the scaling schedule runs once. The schedule is interpreted with respect to time_zone. This field is required. Note: These timestamps only describe when autoscaler starts providing the scaling signal. The VMs need additional time to become serving.
     * </pre>
     *
     * <code>optional string schedule = 375820951;</code>
     *
     * @return The schedule.
     */
    public java.lang.String getSchedule() {
      java.lang.Object ref = schedule_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schedule_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The start timestamps of time intervals when this scaling schedule is to provide a scaling signal. This field uses the extended cron format (with an optional year field). The expression can describe a single timestamp if the optional year is set, in which case the scaling schedule runs once. The schedule is interpreted with respect to time_zone. This field is required. Note: These timestamps only describe when autoscaler starts providing the scaling signal. The VMs need additional time to become serving.
     * </pre>
     *
     * <code>optional string schedule = 375820951;</code>
     *
     * @return The bytes for schedule.
     */
    public com.google.protobuf.ByteString getScheduleBytes() {
      java.lang.Object ref = schedule_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schedule_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The start timestamps of time intervals when this scaling schedule is to provide a scaling signal. This field uses the extended cron format (with an optional year field). The expression can describe a single timestamp if the optional year is set, in which case the scaling schedule runs once. The schedule is interpreted with respect to time_zone. This field is required. Note: These timestamps only describe when autoscaler starts providing the scaling signal. The VMs need additional time to become serving.
     * </pre>
     *
     * <code>optional string schedule = 375820951;</code>
     *
     * @param value The schedule to set.
     * @return This builder for chaining.
     */
    public Builder setSchedule(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      schedule_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The start timestamps of time intervals when this scaling schedule is to provide a scaling signal. This field uses the extended cron format (with an optional year field). The expression can describe a single timestamp if the optional year is set, in which case the scaling schedule runs once. The schedule is interpreted with respect to time_zone. This field is required. Note: These timestamps only describe when autoscaler starts providing the scaling signal. The VMs need additional time to become serving.
     * </pre>
     *
     * <code>optional string schedule = 375820951;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchedule() {
      schedule_ = getDefaultInstance().getSchedule();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The start timestamps of time intervals when this scaling schedule is to provide a scaling signal. This field uses the extended cron format (with an optional year field). The expression can describe a single timestamp if the optional year is set, in which case the scaling schedule runs once. The schedule is interpreted with respect to time_zone. This field is required. Note: These timestamps only describe when autoscaler starts providing the scaling signal. The VMs need additional time to become serving.
     * </pre>
     *
     * <code>optional string schedule = 375820951;</code>
     *
     * @param value The bytes for schedule to set.
     * @return This builder for chaining.
     */
    public Builder setScheduleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      schedule_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object timeZone_ = "";

    /**
     *
     *
     * <pre>
     * The time zone to use when interpreting the schedule. The value of this field must be a time zone name from the tz database: https://en.wikipedia.org/wiki/Tz_database. This field is assigned a default value of "UTC" if left empty.
     * </pre>
     *
     * <code>optional string time_zone = 36848094;</code>
     *
     * @return Whether the timeZone field is set.
     */
    public boolean hasTimeZone() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * The time zone to use when interpreting the schedule. The value of this field must be a time zone name from the tz database: https://en.wikipedia.org/wiki/Tz_database. This field is assigned a default value of "UTC" if left empty.
     * </pre>
     *
     * <code>optional string time_zone = 36848094;</code>
     *
     * @return The timeZone.
     */
    public java.lang.String getTimeZone() {
      java.lang.Object ref = timeZone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timeZone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The time zone to use when interpreting the schedule. The value of this field must be a time zone name from the tz database: https://en.wikipedia.org/wiki/Tz_database. This field is assigned a default value of "UTC" if left empty.
     * </pre>
     *
     * <code>optional string time_zone = 36848094;</code>
     *
     * @return The bytes for timeZone.
     */
    public com.google.protobuf.ByteString getTimeZoneBytes() {
      java.lang.Object ref = timeZone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        timeZone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The time zone to use when interpreting the schedule. The value of this field must be a time zone name from the tz database: https://en.wikipedia.org/wiki/Tz_database. This field is assigned a default value of "UTC" if left empty.
     * </pre>
     *
     * <code>optional string time_zone = 36848094;</code>
     *
     * @param value The timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      timeZone_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time zone to use when interpreting the schedule. The value of this field must be a time zone name from the tz database: https://en.wikipedia.org/wiki/Tz_database. This field is assigned a default value of "UTC" if left empty.
     * </pre>
     *
     * <code>optional string time_zone = 36848094;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeZone() {
      timeZone_ = getDefaultInstance().getTimeZone();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time zone to use when interpreting the schedule. The value of this field must be a time zone name from the tz database: https://en.wikipedia.org/wiki/Tz_database. This field is assigned a default value of "UTC" if left empty.
     * </pre>
     *
     * <code>optional string time_zone = 36848094;</code>
     *
     * @param value The bytes for timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      timeZone_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.AutoscalingPolicyScalingSchedule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.AutoscalingPolicyScalingSchedule)
  private static final com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule();
  }

  public static com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AutoscalingPolicyScalingSchedule> PARSER =
      new com.google.protobuf.AbstractParser<AutoscalingPolicyScalingSchedule>() {
        @java.lang.Override
        public AutoscalingPolicyScalingSchedule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AutoscalingPolicyScalingSchedule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AutoscalingPolicyScalingSchedule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.AutoscalingPolicyScalingSchedule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
