/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * This reservation type is specified by total resource amounts (e.g. total count of CPUs) and can account for multiple instance SKUs. In other words, one can create instances of varying shapes against this reservation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.AllocationAggregateReservation}
 */
public final class AllocationAggregateReservation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.AllocationAggregateReservation)
    AllocationAggregateReservationOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use AllocationAggregateReservation.newBuilder() to construct.
  private AllocationAggregateReservation(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AllocationAggregateReservation() {
    inUseResources_ = java.util.Collections.emptyList();
    reservedResources_ = java.util.Collections.emptyList();
    vmFamily_ = "";
    workloadType_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AllocationAggregateReservation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_AllocationAggregateReservation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_AllocationAggregateReservation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.AllocationAggregateReservation.class,
            com.google.cloud.compute.v1.AllocationAggregateReservation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The VM family that all instances scheduled against this reservation must belong to.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.AllocationAggregateReservation.VmFamily}
   */
  public enum VmFamily implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_VM_FAMILY = 0;</code>
     */
    UNDEFINED_VM_FAMILY(0),
    /** <code>VM_FAMILY_CLOUD_TPU_DEVICE_CT3 = 42845948;</code> */
    VM_FAMILY_CLOUD_TPU_DEVICE_CT3(42845948),
    /** <code>VM_FAMILY_CLOUD_TPU_LITE_DEVICE_CT5L = 108020067;</code> */
    VM_FAMILY_CLOUD_TPU_LITE_DEVICE_CT5L(108020067),
    /** <code>VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT5LP = 18705267;</code> */
    VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT5LP(18705267),
    /** <code>VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT6E = 398926997;</code> */
    VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT6E(398926997),
    /** <code>VM_FAMILY_CLOUD_TPU_POD_SLICE_CT3P = 517384376;</code> */
    VM_FAMILY_CLOUD_TPU_POD_SLICE_CT3P(517384376),
    /** <code>VM_FAMILY_CLOUD_TPU_POD_SLICE_CT4P = 517384407;</code> */
    VM_FAMILY_CLOUD_TPU_POD_SLICE_CT4P(517384407),
    /** <code>VM_FAMILY_CLOUD_TPU_POD_SLICE_CT5P = 517384438;</code> */
    VM_FAMILY_CLOUD_TPU_POD_SLICE_CT5P(517384438),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_VM_FAMILY = 0;</code>
     */
    public static final int UNDEFINED_VM_FAMILY_VALUE = 0;

    /** <code>VM_FAMILY_CLOUD_TPU_DEVICE_CT3 = 42845948;</code> */
    public static final int VM_FAMILY_CLOUD_TPU_DEVICE_CT3_VALUE = 42845948;

    /** <code>VM_FAMILY_CLOUD_TPU_LITE_DEVICE_CT5L = 108020067;</code> */
    public static final int VM_FAMILY_CLOUD_TPU_LITE_DEVICE_CT5L_VALUE = 108020067;

    /** <code>VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT5LP = 18705267;</code> */
    public static final int VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT5LP_VALUE = 18705267;

    /** <code>VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT6E = 398926997;</code> */
    public static final int VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT6E_VALUE = 398926997;

    /** <code>VM_FAMILY_CLOUD_TPU_POD_SLICE_CT3P = 517384376;</code> */
    public static final int VM_FAMILY_CLOUD_TPU_POD_SLICE_CT3P_VALUE = 517384376;

    /** <code>VM_FAMILY_CLOUD_TPU_POD_SLICE_CT4P = 517384407;</code> */
    public static final int VM_FAMILY_CLOUD_TPU_POD_SLICE_CT4P_VALUE = 517384407;

    /** <code>VM_FAMILY_CLOUD_TPU_POD_SLICE_CT5P = 517384438;</code> */
    public static final int VM_FAMILY_CLOUD_TPU_POD_SLICE_CT5P_VALUE = 517384438;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VmFamily valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static VmFamily forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_VM_FAMILY;
        case 42845948:
          return VM_FAMILY_CLOUD_TPU_DEVICE_CT3;
        case 108020067:
          return VM_FAMILY_CLOUD_TPU_LITE_DEVICE_CT5L;
        case 18705267:
          return VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT5LP;
        case 398926997:
          return VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT6E;
        case 517384376:
          return VM_FAMILY_CLOUD_TPU_POD_SLICE_CT3P;
        case 517384407:
          return VM_FAMILY_CLOUD_TPU_POD_SLICE_CT4P;
        case 517384438:
          return VM_FAMILY_CLOUD_TPU_POD_SLICE_CT5P;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<VmFamily> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<VmFamily> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<VmFamily>() {
          public VmFamily findValueByNumber(int number) {
            return VmFamily.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.AllocationAggregateReservation.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final VmFamily[] VALUES = values();

    public static VmFamily valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private VmFamily(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.AllocationAggregateReservation.VmFamily)
  }

  /**
   *
   *
   * <pre>
   * The workload type of the instances that will target this reservation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.AllocationAggregateReservation.WorkloadType}
   */
  public enum WorkloadType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_WORKLOAD_TYPE = 0;</code>
     */
    UNDEFINED_WORKLOAD_TYPE(0),
    /**
     *
     *
     * <pre>
     * Reserved resources will be optimized for BATCH workloads, such as ML training.
     * </pre>
     *
     * <code>BATCH = 62971674;</code>
     */
    BATCH(62971674),
    /**
     *
     *
     * <pre>
     * Reserved resources will be optimized for SERVING workloads, such as ML inference.
     * </pre>
     *
     * <code>SERVING = 17781740;</code>
     */
    SERVING(17781740),
    /** <code>UNSPECIFIED = 526786327;</code> */
    UNSPECIFIED(526786327),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_WORKLOAD_TYPE = 0;</code>
     */
    public static final int UNDEFINED_WORKLOAD_TYPE_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Reserved resources will be optimized for BATCH workloads, such as ML training.
     * </pre>
     *
     * <code>BATCH = 62971674;</code>
     */
    public static final int BATCH_VALUE = 62971674;

    /**
     *
     *
     * <pre>
     * Reserved resources will be optimized for SERVING workloads, such as ML inference.
     * </pre>
     *
     * <code>SERVING = 17781740;</code>
     */
    public static final int SERVING_VALUE = 17781740;

    /** <code>UNSPECIFIED = 526786327;</code> */
    public static final int UNSPECIFIED_VALUE = 526786327;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static WorkloadType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static WorkloadType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_WORKLOAD_TYPE;
        case 62971674:
          return BATCH;
        case 17781740:
          return SERVING;
        case 526786327:
          return UNSPECIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<WorkloadType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<WorkloadType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<WorkloadType>() {
          public WorkloadType findValueByNumber(int number) {
            return WorkloadType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.AllocationAggregateReservation.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final WorkloadType[] VALUES = values();

    public static WorkloadType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private WorkloadType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.AllocationAggregateReservation.WorkloadType)
  }

  private int bitField0_;
  public static final int IN_USE_RESOURCES_FIELD_NUMBER = 409009107;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo>
      inUseResources_;

  /**
   *
   *
   * <pre>
   * [Output only] List of resources currently in use.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo>
      getInUseResourcesList() {
    return inUseResources_;
  }

  /**
   *
   *
   * <pre>
   * [Output only] List of resources currently in use.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.compute.v1
                  .AllocationAggregateReservationReservedResourceInfoOrBuilder>
      getInUseResourcesOrBuilderList() {
    return inUseResources_;
  }

  /**
   *
   *
   * <pre>
   * [Output only] List of resources currently in use.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
   * </code>
   */
  @java.lang.Override
  public int getInUseResourcesCount() {
    return inUseResources_.size();
  }

  /**
   *
   *
   * <pre>
   * [Output only] List of resources currently in use.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo
      getInUseResources(int index) {
    return inUseResources_.get(index);
  }

  /**
   *
   *
   * <pre>
   * [Output only] List of resources currently in use.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfoOrBuilder
      getInUseResourcesOrBuilder(int index) {
    return inUseResources_.get(index);
  }

  public static final int RESERVED_RESOURCES_FIELD_NUMBER = 213217742;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo>
      reservedResources_;

  /**
   *
   *
   * <pre>
   * List of reserved resources (CPUs, memory, accelerators).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo>
      getReservedResourcesList() {
    return reservedResources_;
  }

  /**
   *
   *
   * <pre>
   * List of reserved resources (CPUs, memory, accelerators).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.compute.v1
                  .AllocationAggregateReservationReservedResourceInfoOrBuilder>
      getReservedResourcesOrBuilderList() {
    return reservedResources_;
  }

  /**
   *
   *
   * <pre>
   * List of reserved resources (CPUs, memory, accelerators).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
   * </code>
   */
  @java.lang.Override
  public int getReservedResourcesCount() {
    return reservedResources_.size();
  }

  /**
   *
   *
   * <pre>
   * List of reserved resources (CPUs, memory, accelerators).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo
      getReservedResources(int index) {
    return reservedResources_.get(index);
  }

  /**
   *
   *
   * <pre>
   * List of reserved resources (CPUs, memory, accelerators).
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfoOrBuilder
      getReservedResourcesOrBuilder(int index) {
    return reservedResources_.get(index);
  }

  public static final int VM_FAMILY_FIELD_NUMBER = 125017580;

  @SuppressWarnings("serial")
  private volatile java.lang.Object vmFamily_ = "";

  /**
   *
   *
   * <pre>
   * The VM family that all instances scheduled against this reservation must belong to.
   * Check the VmFamily enum for the list of possible values.
   * </pre>
   *
   * <code>optional string vm_family = 125017580;</code>
   *
   * @return Whether the vmFamily field is set.
   */
  @java.lang.Override
  public boolean hasVmFamily() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The VM family that all instances scheduled against this reservation must belong to.
   * Check the VmFamily enum for the list of possible values.
   * </pre>
   *
   * <code>optional string vm_family = 125017580;</code>
   *
   * @return The vmFamily.
   */
  @java.lang.Override
  public java.lang.String getVmFamily() {
    java.lang.Object ref = vmFamily_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      vmFamily_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The VM family that all instances scheduled against this reservation must belong to.
   * Check the VmFamily enum for the list of possible values.
   * </pre>
   *
   * <code>optional string vm_family = 125017580;</code>
   *
   * @return The bytes for vmFamily.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVmFamilyBytes() {
    java.lang.Object ref = vmFamily_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      vmFamily_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WORKLOAD_TYPE_FIELD_NUMBER = 273432322;

  @SuppressWarnings("serial")
  private volatile java.lang.Object workloadType_ = "";

  /**
   *
   *
   * <pre>
   * The workload type of the instances that will target this reservation.
   * Check the WorkloadType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string workload_type = 273432322;</code>
   *
   * @return Whether the workloadType field is set.
   */
  @java.lang.Override
  public boolean hasWorkloadType() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The workload type of the instances that will target this reservation.
   * Check the WorkloadType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string workload_type = 273432322;</code>
   *
   * @return The workloadType.
   */
  @java.lang.Override
  public java.lang.String getWorkloadType() {
    java.lang.Object ref = workloadType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      workloadType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The workload type of the instances that will target this reservation.
   * Check the WorkloadType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string workload_type = 273432322;</code>
   *
   * @return The bytes for workloadType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWorkloadTypeBytes() {
    java.lang.Object ref = workloadType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      workloadType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 125017580, vmFamily_);
    }
    for (int i = 0; i < reservedResources_.size(); i++) {
      output.writeMessage(213217742, reservedResources_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 273432322, workloadType_);
    }
    for (int i = 0; i < inUseResources_.size(); i++) {
      output.writeMessage(409009107, inUseResources_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(125017580, vmFamily_);
    }
    for (int i = 0; i < reservedResources_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              213217742, reservedResources_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(273432322, workloadType_);
    }
    for (int i = 0; i < inUseResources_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              409009107, inUseResources_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.AllocationAggregateReservation)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.AllocationAggregateReservation other =
        (com.google.cloud.compute.v1.AllocationAggregateReservation) obj;

    if (!getInUseResourcesList().equals(other.getInUseResourcesList())) return false;
    if (!getReservedResourcesList().equals(other.getReservedResourcesList())) return false;
    if (hasVmFamily() != other.hasVmFamily()) return false;
    if (hasVmFamily()) {
      if (!getVmFamily().equals(other.getVmFamily())) return false;
    }
    if (hasWorkloadType() != other.hasWorkloadType()) return false;
    if (hasWorkloadType()) {
      if (!getWorkloadType().equals(other.getWorkloadType())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getInUseResourcesCount() > 0) {
      hash = (37 * hash) + IN_USE_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getInUseResourcesList().hashCode();
    }
    if (getReservedResourcesCount() > 0) {
      hash = (37 * hash) + RESERVED_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getReservedResourcesList().hashCode();
    }
    if (hasVmFamily()) {
      hash = (37 * hash) + VM_FAMILY_FIELD_NUMBER;
      hash = (53 * hash) + getVmFamily().hashCode();
    }
    if (hasWorkloadType()) {
      hash = (37 * hash) + WORKLOAD_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getWorkloadType().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.AllocationAggregateReservation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AllocationAggregateReservation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AllocationAggregateReservation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AllocationAggregateReservation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AllocationAggregateReservation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AllocationAggregateReservation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AllocationAggregateReservation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AllocationAggregateReservation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AllocationAggregateReservation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AllocationAggregateReservation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AllocationAggregateReservation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AllocationAggregateReservation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.AllocationAggregateReservation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * This reservation type is specified by total resource amounts (e.g. total count of CPUs) and can account for multiple instance SKUs. In other words, one can create instances of varying shapes against this reservation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.AllocationAggregateReservation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.AllocationAggregateReservation)
      com.google.cloud.compute.v1.AllocationAggregateReservationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AllocationAggregateReservation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AllocationAggregateReservation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.AllocationAggregateReservation.class,
              com.google.cloud.compute.v1.AllocationAggregateReservation.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.AllocationAggregateReservation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (inUseResourcesBuilder_ == null) {
        inUseResources_ = java.util.Collections.emptyList();
      } else {
        inUseResources_ = null;
        inUseResourcesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (reservedResourcesBuilder_ == null) {
        reservedResources_ = java.util.Collections.emptyList();
      } else {
        reservedResources_ = null;
        reservedResourcesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      vmFamily_ = "";
      workloadType_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AllocationAggregateReservation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AllocationAggregateReservation getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.AllocationAggregateReservation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AllocationAggregateReservation build() {
      com.google.cloud.compute.v1.AllocationAggregateReservation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AllocationAggregateReservation buildPartial() {
      com.google.cloud.compute.v1.AllocationAggregateReservation result =
          new com.google.cloud.compute.v1.AllocationAggregateReservation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.AllocationAggregateReservation result) {
      if (inUseResourcesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          inUseResources_ = java.util.Collections.unmodifiableList(inUseResources_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.inUseResources_ = inUseResources_;
      } else {
        result.inUseResources_ = inUseResourcesBuilder_.build();
      }
      if (reservedResourcesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          reservedResources_ = java.util.Collections.unmodifiableList(reservedResources_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.reservedResources_ = reservedResources_;
      } else {
        result.reservedResources_ = reservedResourcesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.AllocationAggregateReservation result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.vmFamily_ = vmFamily_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.workloadType_ = workloadType_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.AllocationAggregateReservation) {
        return mergeFrom((com.google.cloud.compute.v1.AllocationAggregateReservation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.AllocationAggregateReservation other) {
      if (other == com.google.cloud.compute.v1.AllocationAggregateReservation.getDefaultInstance())
        return this;
      if (inUseResourcesBuilder_ == null) {
        if (!other.inUseResources_.isEmpty()) {
          if (inUseResources_.isEmpty()) {
            inUseResources_ = other.inUseResources_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureInUseResourcesIsMutable();
            inUseResources_.addAll(other.inUseResources_);
          }
          onChanged();
        }
      } else {
        if (!other.inUseResources_.isEmpty()) {
          if (inUseResourcesBuilder_.isEmpty()) {
            inUseResourcesBuilder_.dispose();
            inUseResourcesBuilder_ = null;
            inUseResources_ = other.inUseResources_;
            bitField0_ = (bitField0_ & ~0x00000001);
            inUseResourcesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInUseResourcesFieldBuilder()
                    : null;
          } else {
            inUseResourcesBuilder_.addAllMessages(other.inUseResources_);
          }
        }
      }
      if (reservedResourcesBuilder_ == null) {
        if (!other.reservedResources_.isEmpty()) {
          if (reservedResources_.isEmpty()) {
            reservedResources_ = other.reservedResources_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureReservedResourcesIsMutable();
            reservedResources_.addAll(other.reservedResources_);
          }
          onChanged();
        }
      } else {
        if (!other.reservedResources_.isEmpty()) {
          if (reservedResourcesBuilder_.isEmpty()) {
            reservedResourcesBuilder_.dispose();
            reservedResourcesBuilder_ = null;
            reservedResources_ = other.reservedResources_;
            bitField0_ = (bitField0_ & ~0x00000002);
            reservedResourcesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getReservedResourcesFieldBuilder()
                    : null;
          } else {
            reservedResourcesBuilder_.addAllMessages(other.reservedResources_);
          }
        }
      }
      if (other.hasVmFamily()) {
        vmFamily_ = other.vmFamily_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasWorkloadType()) {
        workloadType_ = other.workloadType_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 1000140642:
              {
                vmFamily_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 1000140642
            case 1705741938:
              {
                com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo m =
                    input.readMessage(
                        com.google.cloud.compute.v1
                            .AllocationAggregateReservationReservedResourceInfo.parser(),
                        extensionRegistry);
                if (reservedResourcesBuilder_ == null) {
                  ensureReservedResourcesIsMutable();
                  reservedResources_.add(m);
                } else {
                  reservedResourcesBuilder_.addMessage(m);
                }
                break;
              } // case 1705741938
            case -2107508718:
              {
                workloadType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -2107508718
            case -1022894438:
              {
                com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo m =
                    input.readMessage(
                        com.google.cloud.compute.v1
                            .AllocationAggregateReservationReservedResourceInfo.parser(),
                        extensionRegistry);
                if (inUseResourcesBuilder_ == null) {
                  ensureInUseResourcesIsMutable();
                  inUseResources_.add(m);
                } else {
                  inUseResourcesBuilder_.addMessage(m);
                }
                break;
              } // case -1022894438
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo>
        inUseResources_ = java.util.Collections.emptyList();

    private void ensureInUseResourcesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        inUseResources_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo>(
                inUseResources_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo,
            com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo.Builder,
            com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfoOrBuilder>
        inUseResourcesBuilder_;

    /**
     *
     *
     * <pre>
     * [Output only] List of resources currently in use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo>
        getInUseResourcesList() {
      if (inUseResourcesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(inUseResources_);
      } else {
        return inUseResourcesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] List of resources currently in use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
     * </code>
     */
    public int getInUseResourcesCount() {
      if (inUseResourcesBuilder_ == null) {
        return inUseResources_.size();
      } else {
        return inUseResourcesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] List of resources currently in use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
     * </code>
     */
    public com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo
        getInUseResources(int index) {
      if (inUseResourcesBuilder_ == null) {
        return inUseResources_.get(index);
      } else {
        return inUseResourcesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] List of resources currently in use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
     * </code>
     */
    public Builder setInUseResources(
        int index,
        com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo value) {
      if (inUseResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInUseResourcesIsMutable();
        inUseResources_.set(index, value);
        onChanged();
      } else {
        inUseResourcesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] List of resources currently in use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
     * </code>
     */
    public Builder setInUseResources(
        int index,
        com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo.Builder
            builderForValue) {
      if (inUseResourcesBuilder_ == null) {
        ensureInUseResourcesIsMutable();
        inUseResources_.set(index, builderForValue.build());
        onChanged();
      } else {
        inUseResourcesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] List of resources currently in use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
     * </code>
     */
    public Builder addInUseResources(
        com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo value) {
      if (inUseResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInUseResourcesIsMutable();
        inUseResources_.add(value);
        onChanged();
      } else {
        inUseResourcesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] List of resources currently in use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
     * </code>
     */
    public Builder addInUseResources(
        int index,
        com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo value) {
      if (inUseResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInUseResourcesIsMutable();
        inUseResources_.add(index, value);
        onChanged();
      } else {
        inUseResourcesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] List of resources currently in use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
     * </code>
     */
    public Builder addInUseResources(
        com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo.Builder
            builderForValue) {
      if (inUseResourcesBuilder_ == null) {
        ensureInUseResourcesIsMutable();
        inUseResources_.add(builderForValue.build());
        onChanged();
      } else {
        inUseResourcesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] List of resources currently in use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
     * </code>
     */
    public Builder addInUseResources(
        int index,
        com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo.Builder
            builderForValue) {
      if (inUseResourcesBuilder_ == null) {
        ensureInUseResourcesIsMutable();
        inUseResources_.add(index, builderForValue.build());
        onChanged();
      } else {
        inUseResourcesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] List of resources currently in use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
     * </code>
     */
    public Builder addAllInUseResources(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo>
            values) {
      if (inUseResourcesBuilder_ == null) {
        ensureInUseResourcesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, inUseResources_);
        onChanged();
      } else {
        inUseResourcesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] List of resources currently in use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
     * </code>
     */
    public Builder clearInUseResources() {
      if (inUseResourcesBuilder_ == null) {
        inUseResources_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        inUseResourcesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] List of resources currently in use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
     * </code>
     */
    public Builder removeInUseResources(int index) {
      if (inUseResourcesBuilder_ == null) {
        ensureInUseResourcesIsMutable();
        inUseResources_.remove(index);
        onChanged();
      } else {
        inUseResourcesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output only] List of resources currently in use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
     * </code>
     */
    public com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo.Builder
        getInUseResourcesBuilder(int index) {
      return getInUseResourcesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * [Output only] List of resources currently in use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
     * </code>
     */
    public com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfoOrBuilder
        getInUseResourcesOrBuilder(int index) {
      if (inUseResourcesBuilder_ == null) {
        return inUseResources_.get(index);
      } else {
        return inUseResourcesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] List of resources currently in use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.compute.v1
                    .AllocationAggregateReservationReservedResourceInfoOrBuilder>
        getInUseResourcesOrBuilderList() {
      if (inUseResourcesBuilder_ != null) {
        return inUseResourcesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(inUseResources_);
      }
    }

    /**
     *
     *
     * <pre>
     * [Output only] List of resources currently in use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
     * </code>
     */
    public com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo.Builder
        addInUseResourcesBuilder() {
      return getInUseResourcesFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * [Output only] List of resources currently in use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
     * </code>
     */
    public com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo.Builder
        addInUseResourcesBuilder(int index) {
      return getInUseResourcesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * [Output only] List of resources currently in use.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo in_use_resources = 409009107;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo.Builder>
        getInUseResourcesBuilderList() {
      return getInUseResourcesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo,
            com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo.Builder,
            com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfoOrBuilder>
        getInUseResourcesFieldBuilder() {
      if (inUseResourcesBuilder_ == null) {
        inUseResourcesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo,
                com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo
                    .Builder,
                com.google.cloud.compute.v1
                    .AllocationAggregateReservationReservedResourceInfoOrBuilder>(
                inUseResources_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        inUseResources_ = null;
      }
      return inUseResourcesBuilder_;
    }

    private java.util.List<
            com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo>
        reservedResources_ = java.util.Collections.emptyList();

    private void ensureReservedResourcesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        reservedResources_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo>(
                reservedResources_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo,
            com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo.Builder,
            com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfoOrBuilder>
        reservedResourcesBuilder_;

    /**
     *
     *
     * <pre>
     * List of reserved resources (CPUs, memory, accelerators).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo>
        getReservedResourcesList() {
      if (reservedResourcesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(reservedResources_);
      } else {
        return reservedResourcesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * List of reserved resources (CPUs, memory, accelerators).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
     * </code>
     */
    public int getReservedResourcesCount() {
      if (reservedResourcesBuilder_ == null) {
        return reservedResources_.size();
      } else {
        return reservedResourcesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * List of reserved resources (CPUs, memory, accelerators).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
     * </code>
     */
    public com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo
        getReservedResources(int index) {
      if (reservedResourcesBuilder_ == null) {
        return reservedResources_.get(index);
      } else {
        return reservedResourcesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of reserved resources (CPUs, memory, accelerators).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
     * </code>
     */
    public Builder setReservedResources(
        int index,
        com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo value) {
      if (reservedResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReservedResourcesIsMutable();
        reservedResources_.set(index, value);
        onChanged();
      } else {
        reservedResourcesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of reserved resources (CPUs, memory, accelerators).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
     * </code>
     */
    public Builder setReservedResources(
        int index,
        com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo.Builder
            builderForValue) {
      if (reservedResourcesBuilder_ == null) {
        ensureReservedResourcesIsMutable();
        reservedResources_.set(index, builderForValue.build());
        onChanged();
      } else {
        reservedResourcesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of reserved resources (CPUs, memory, accelerators).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
     * </code>
     */
    public Builder addReservedResources(
        com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo value) {
      if (reservedResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReservedResourcesIsMutable();
        reservedResources_.add(value);
        onChanged();
      } else {
        reservedResourcesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of reserved resources (CPUs, memory, accelerators).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
     * </code>
     */
    public Builder addReservedResources(
        int index,
        com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo value) {
      if (reservedResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReservedResourcesIsMutable();
        reservedResources_.add(index, value);
        onChanged();
      } else {
        reservedResourcesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of reserved resources (CPUs, memory, accelerators).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
     * </code>
     */
    public Builder addReservedResources(
        com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo.Builder
            builderForValue) {
      if (reservedResourcesBuilder_ == null) {
        ensureReservedResourcesIsMutable();
        reservedResources_.add(builderForValue.build());
        onChanged();
      } else {
        reservedResourcesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of reserved resources (CPUs, memory, accelerators).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
     * </code>
     */
    public Builder addReservedResources(
        int index,
        com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo.Builder
            builderForValue) {
      if (reservedResourcesBuilder_ == null) {
        ensureReservedResourcesIsMutable();
        reservedResources_.add(index, builderForValue.build());
        onChanged();
      } else {
        reservedResourcesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of reserved resources (CPUs, memory, accelerators).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
     * </code>
     */
    public Builder addAllReservedResources(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo>
            values) {
      if (reservedResourcesBuilder_ == null) {
        ensureReservedResourcesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, reservedResources_);
        onChanged();
      } else {
        reservedResourcesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of reserved resources (CPUs, memory, accelerators).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
     * </code>
     */
    public Builder clearReservedResources() {
      if (reservedResourcesBuilder_ == null) {
        reservedResources_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        reservedResourcesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of reserved resources (CPUs, memory, accelerators).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
     * </code>
     */
    public Builder removeReservedResources(int index) {
      if (reservedResourcesBuilder_ == null) {
        ensureReservedResourcesIsMutable();
        reservedResources_.remove(index);
        onChanged();
      } else {
        reservedResourcesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of reserved resources (CPUs, memory, accelerators).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
     * </code>
     */
    public com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo.Builder
        getReservedResourcesBuilder(int index) {
      return getReservedResourcesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * List of reserved resources (CPUs, memory, accelerators).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
     * </code>
     */
    public com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfoOrBuilder
        getReservedResourcesOrBuilder(int index) {
      if (reservedResourcesBuilder_ == null) {
        return reservedResources_.get(index);
      } else {
        return reservedResourcesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of reserved resources (CPUs, memory, accelerators).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.compute.v1
                    .AllocationAggregateReservationReservedResourceInfoOrBuilder>
        getReservedResourcesOrBuilderList() {
      if (reservedResourcesBuilder_ != null) {
        return reservedResourcesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(reservedResources_);
      }
    }

    /**
     *
     *
     * <pre>
     * List of reserved resources (CPUs, memory, accelerators).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
     * </code>
     */
    public com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo.Builder
        addReservedResourcesBuilder() {
      return getReservedResourcesFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of reserved resources (CPUs, memory, accelerators).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
     * </code>
     */
    public com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo.Builder
        addReservedResourcesBuilder(int index) {
      return getReservedResourcesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of reserved resources (CPUs, memory, accelerators).
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo reserved_resources = 213217742;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo.Builder>
        getReservedResourcesBuilderList() {
      return getReservedResourcesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo,
            com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo.Builder,
            com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfoOrBuilder>
        getReservedResourcesFieldBuilder() {
      if (reservedResourcesBuilder_ == null) {
        reservedResourcesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo,
                com.google.cloud.compute.v1.AllocationAggregateReservationReservedResourceInfo
                    .Builder,
                com.google.cloud.compute.v1
                    .AllocationAggregateReservationReservedResourceInfoOrBuilder>(
                reservedResources_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        reservedResources_ = null;
      }
      return reservedResourcesBuilder_;
    }

    private java.lang.Object vmFamily_ = "";

    /**
     *
     *
     * <pre>
     * The VM family that all instances scheduled against this reservation must belong to.
     * Check the VmFamily enum for the list of possible values.
     * </pre>
     *
     * <code>optional string vm_family = 125017580;</code>
     *
     * @return Whether the vmFamily field is set.
     */
    public boolean hasVmFamily() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The VM family that all instances scheduled against this reservation must belong to.
     * Check the VmFamily enum for the list of possible values.
     * </pre>
     *
     * <code>optional string vm_family = 125017580;</code>
     *
     * @return The vmFamily.
     */
    public java.lang.String getVmFamily() {
      java.lang.Object ref = vmFamily_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        vmFamily_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The VM family that all instances scheduled against this reservation must belong to.
     * Check the VmFamily enum for the list of possible values.
     * </pre>
     *
     * <code>optional string vm_family = 125017580;</code>
     *
     * @return The bytes for vmFamily.
     */
    public com.google.protobuf.ByteString getVmFamilyBytes() {
      java.lang.Object ref = vmFamily_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        vmFamily_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The VM family that all instances scheduled against this reservation must belong to.
     * Check the VmFamily enum for the list of possible values.
     * </pre>
     *
     * <code>optional string vm_family = 125017580;</code>
     *
     * @param value The vmFamily to set.
     * @return This builder for chaining.
     */
    public Builder setVmFamily(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      vmFamily_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The VM family that all instances scheduled against this reservation must belong to.
     * Check the VmFamily enum for the list of possible values.
     * </pre>
     *
     * <code>optional string vm_family = 125017580;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVmFamily() {
      vmFamily_ = getDefaultInstance().getVmFamily();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The VM family that all instances scheduled against this reservation must belong to.
     * Check the VmFamily enum for the list of possible values.
     * </pre>
     *
     * <code>optional string vm_family = 125017580;</code>
     *
     * @param value The bytes for vmFamily to set.
     * @return This builder for chaining.
     */
    public Builder setVmFamilyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      vmFamily_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object workloadType_ = "";

    /**
     *
     *
     * <pre>
     * The workload type of the instances that will target this reservation.
     * Check the WorkloadType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string workload_type = 273432322;</code>
     *
     * @return Whether the workloadType field is set.
     */
    public boolean hasWorkloadType() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * The workload type of the instances that will target this reservation.
     * Check the WorkloadType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string workload_type = 273432322;</code>
     *
     * @return The workloadType.
     */
    public java.lang.String getWorkloadType() {
      java.lang.Object ref = workloadType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        workloadType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The workload type of the instances that will target this reservation.
     * Check the WorkloadType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string workload_type = 273432322;</code>
     *
     * @return The bytes for workloadType.
     */
    public com.google.protobuf.ByteString getWorkloadTypeBytes() {
      java.lang.Object ref = workloadType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        workloadType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The workload type of the instances that will target this reservation.
     * Check the WorkloadType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string workload_type = 273432322;</code>
     *
     * @param value The workloadType to set.
     * @return This builder for chaining.
     */
    public Builder setWorkloadType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      workloadType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The workload type of the instances that will target this reservation.
     * Check the WorkloadType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string workload_type = 273432322;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWorkloadType() {
      workloadType_ = getDefaultInstance().getWorkloadType();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The workload type of the instances that will target this reservation.
     * Check the WorkloadType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string workload_type = 273432322;</code>
     *
     * @param value The bytes for workloadType to set.
     * @return This builder for chaining.
     */
    public Builder setWorkloadTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      workloadType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.AllocationAggregateReservation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.AllocationAggregateReservation)
  private static final com.google.cloud.compute.v1.AllocationAggregateReservation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.AllocationAggregateReservation();
  }

  public static com.google.cloud.compute.v1.AllocationAggregateReservation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AllocationAggregateReservation> PARSER =
      new com.google.protobuf.AbstractParser<AllocationAggregateReservation>() {
        @java.lang.Override
        public AllocationAggregateReservation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AllocationAggregateReservation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AllocationAggregateReservation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.AllocationAggregateReservation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
