/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * An access configuration attached to an instance's network interface. Only one access config per instance is supported.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.AccessConfig}
 */
public final class AccessConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.AccessConfig)
    AccessConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use AccessConfig.newBuilder() to construct.
  private AccessConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AccessConfig() {
    externalIpv6_ = "";
    kind_ = "";
    name_ = "";
    natIP_ = "";
    networkTier_ = "";
    publicPtrDomainName_ = "";
    securityPolicy_ = "";
    type_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AccessConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_AccessConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_AccessConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.AccessConfig.class,
            com.google.cloud.compute.v1.AccessConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.AccessConfig.NetworkTier}
   */
  public enum NetworkTier implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_NETWORK_TIER = 0;</code>
     */
    UNDEFINED_NETWORK_TIER(0),
    /**
     *
     *
     * <pre>
     * Public internet quality with fixed bandwidth.
     * </pre>
     *
     * <code>FIXED_STANDARD = 310464328;</code>
     */
    FIXED_STANDARD(310464328),
    /**
     *
     *
     * <pre>
     * High quality, Google-grade network tier, support for all networking products.
     * </pre>
     *
     * <code>PREMIUM = 399530551;</code>
     */
    PREMIUM(399530551),
    /**
     *
     *
     * <pre>
     * Public internet quality, only limited support for other networking products.
     * </pre>
     *
     * <code>STANDARD = 484642493;</code>
     */
    STANDARD(484642493),
    /**
     *
     *
     * <pre>
     * (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
     * </pre>
     *
     * <code>STANDARD_OVERRIDES_FIXED_STANDARD = 465847234;</code>
     */
    STANDARD_OVERRIDES_FIXED_STANDARD(465847234),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_NETWORK_TIER = 0;</code>
     */
    public static final int UNDEFINED_NETWORK_TIER_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Public internet quality with fixed bandwidth.
     * </pre>
     *
     * <code>FIXED_STANDARD = 310464328;</code>
     */
    public static final int FIXED_STANDARD_VALUE = 310464328;

    /**
     *
     *
     * <pre>
     * High quality, Google-grade network tier, support for all networking products.
     * </pre>
     *
     * <code>PREMIUM = 399530551;</code>
     */
    public static final int PREMIUM_VALUE = 399530551;

    /**
     *
     *
     * <pre>
     * Public internet quality, only limited support for other networking products.
     * </pre>
     *
     * <code>STANDARD = 484642493;</code>
     */
    public static final int STANDARD_VALUE = 484642493;

    /**
     *
     *
     * <pre>
     * (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
     * </pre>
     *
     * <code>STANDARD_OVERRIDES_FIXED_STANDARD = 465847234;</code>
     */
    public static final int STANDARD_OVERRIDES_FIXED_STANDARD_VALUE = 465847234;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NetworkTier valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static NetworkTier forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_NETWORK_TIER;
        case 310464328:
          return FIXED_STANDARD;
        case 399530551:
          return PREMIUM;
        case 484642493:
          return STANDARD;
        case 465847234:
          return STANDARD_OVERRIDES_FIXED_STANDARD;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<NetworkTier> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<NetworkTier> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<NetworkTier>() {
          public NetworkTier findValueByNumber(int number) {
            return NetworkTier.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.AccessConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final NetworkTier[] VALUES = values();

    public static NetworkTier valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private NetworkTier(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.AccessConfig.NetworkTier)
  }

  /**
   *
   *
   * <pre>
   * The type of configuration. In accessConfigs (IPv4), the default and only option is ONE_TO_ONE_NAT. In ipv6AccessConfigs, the default and only option is DIRECT_IPV6.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.AccessConfig.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    UNDEFINED_TYPE(0),
    /** <code>DIRECT_IPV6 = 4397213;</code> */
    DIRECT_IPV6(4397213),
    /** <code>ONE_TO_ONE_NAT = 84090205;</code> */
    ONE_TO_ONE_NAT(84090205),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    public static final int UNDEFINED_TYPE_VALUE = 0;

    /** <code>DIRECT_IPV6 = 4397213;</code> */
    public static final int DIRECT_IPV6_VALUE = 4397213;

    /** <code>ONE_TO_ONE_NAT = 84090205;</code> */
    public static final int ONE_TO_ONE_NAT_VALUE = 84090205;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_TYPE;
        case 4397213:
          return DIRECT_IPV6;
        case 84090205:
          return ONE_TO_ONE_NAT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.AccessConfig.getDescriptor().getEnumTypes().get(1);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.AccessConfig.Type)
  }

  private int bitField0_;
  public static final int EXTERNAL_IPV6_FIELD_NUMBER = 532703707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object externalIpv6_ = "";

  /**
   *
   *
   * <pre>
   * Applies to ipv6AccessConfigs only. The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. To use a static external IP address, it must be unused and in the same region as the instance's zone. If not specified, Google Cloud will automatically assign an external IPv6 address from the instance's subnetwork.
   * </pre>
   *
   * <code>optional string external_ipv6 = 532703707;</code>
   *
   * @return Whether the externalIpv6 field is set.
   */
  @java.lang.Override
  public boolean hasExternalIpv6() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Applies to ipv6AccessConfigs only. The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. To use a static external IP address, it must be unused and in the same region as the instance's zone. If not specified, Google Cloud will automatically assign an external IPv6 address from the instance's subnetwork.
   * </pre>
   *
   * <code>optional string external_ipv6 = 532703707;</code>
   *
   * @return The externalIpv6.
   */
  @java.lang.Override
  public java.lang.String getExternalIpv6() {
    java.lang.Object ref = externalIpv6_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      externalIpv6_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Applies to ipv6AccessConfigs only. The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. To use a static external IP address, it must be unused and in the same region as the instance's zone. If not specified, Google Cloud will automatically assign an external IPv6 address from the instance's subnetwork.
   * </pre>
   *
   * <code>optional string external_ipv6 = 532703707;</code>
   *
   * @return The bytes for externalIpv6.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExternalIpv6Bytes() {
    java.lang.Object ref = externalIpv6_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      externalIpv6_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXTERNAL_IPV6_PREFIX_LENGTH_FIELD_NUMBER = 425672143;
  private int externalIpv6PrefixLength_ = 0;

  /**
   *
   *
   * <pre>
   * Applies to ipv6AccessConfigs only. The prefix length of the external IPv6 range.
   * </pre>
   *
   * <code>optional int32 external_ipv6_prefix_length = 425672143;</code>
   *
   * @return Whether the externalIpv6PrefixLength field is set.
   */
  @java.lang.Override
  public boolean hasExternalIpv6PrefixLength() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Applies to ipv6AccessConfigs only. The prefix length of the external IPv6 range.
   * </pre>
   *
   * <code>optional int32 external_ipv6_prefix_length = 425672143;</code>
   *
   * @return The externalIpv6PrefixLength.
   */
  @java.lang.Override
  public int getExternalIpv6PrefixLength() {
    return externalIpv6PrefixLength_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#accessConfig for access configs.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#accessConfig for access configs.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#accessConfig for access configs.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * The name of this access configuration. In accessConfigs (IPv4), the default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access. In ipv6AccessConfigs, the recommend name is External IPv6.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * The name of this access configuration. In accessConfigs (IPv4), the default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access. In ipv6AccessConfigs, the recommend name is External IPv6.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The name of this access configuration. In accessConfigs (IPv4), the default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access. In ipv6AccessConfigs, the recommend name is External IPv6.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAT_I_P_FIELD_NUMBER = 117634556;

  @SuppressWarnings("serial")
  private volatile java.lang.Object natIP_ = "";

  /**
   *
   *
   * <pre>
   * Applies to accessConfigs (IPv4) only. An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
   * </pre>
   *
   * <code>optional string nat_i_p = 117634556;</code>
   *
   * @return Whether the natIP field is set.
   */
  @java.lang.Override
  public boolean hasNatIP() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Applies to accessConfigs (IPv4) only. An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
   * </pre>
   *
   * <code>optional string nat_i_p = 117634556;</code>
   *
   * @return The natIP.
   */
  @java.lang.Override
  public java.lang.String getNatIP() {
    java.lang.Object ref = natIP_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      natIP_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Applies to accessConfigs (IPv4) only. An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
   * </pre>
   *
   * <code>optional string nat_i_p = 117634556;</code>
   *
   * @return The bytes for natIP.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNatIPBytes() {
    java.lang.Object ref = natIP_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      natIP_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_TIER_FIELD_NUMBER = 517397843;

  @SuppressWarnings("serial")
  private volatile java.lang.Object networkTier_ = "";

  /**
   *
   *
   * <pre>
   * This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
   * Check the NetworkTier enum for the list of possible values.
   * </pre>
   *
   * <code>optional string network_tier = 517397843;</code>
   *
   * @return Whether the networkTier field is set.
   */
  @java.lang.Override
  public boolean hasNetworkTier() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
   * Check the NetworkTier enum for the list of possible values.
   * </pre>
   *
   * <code>optional string network_tier = 517397843;</code>
   *
   * @return The networkTier.
   */
  @java.lang.Override
  public java.lang.String getNetworkTier() {
    java.lang.Object ref = networkTier_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      networkTier_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
   * Check the NetworkTier enum for the list of possible values.
   * </pre>
   *
   * <code>optional string network_tier = 517397843;</code>
   *
   * @return The bytes for networkTier.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkTierBytes() {
    java.lang.Object ref = networkTier_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      networkTier_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PUBLIC_PTR_DOMAIN_NAME_FIELD_NUMBER = 316599167;

  @SuppressWarnings("serial")
  private volatile java.lang.Object publicPtrDomainName_ = "";

  /**
   *
   *
   * <pre>
   * The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled in accessConfig. If this field is unspecified in ipv6AccessConfig, a default PTR record will be created for first IP in associated external IPv6 range.
   * </pre>
   *
   * <code>optional string public_ptr_domain_name = 316599167;</code>
   *
   * @return Whether the publicPtrDomainName field is set.
   */
  @java.lang.Override
  public boolean hasPublicPtrDomainName() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled in accessConfig. If this field is unspecified in ipv6AccessConfig, a default PTR record will be created for first IP in associated external IPv6 range.
   * </pre>
   *
   * <code>optional string public_ptr_domain_name = 316599167;</code>
   *
   * @return The publicPtrDomainName.
   */
  @java.lang.Override
  public java.lang.String getPublicPtrDomainName() {
    java.lang.Object ref = publicPtrDomainName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      publicPtrDomainName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled in accessConfig. If this field is unspecified in ipv6AccessConfig, a default PTR record will be created for first IP in associated external IPv6 range.
   * </pre>
   *
   * <code>optional string public_ptr_domain_name = 316599167;</code>
   *
   * @return The bytes for publicPtrDomainName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPublicPtrDomainNameBytes() {
    java.lang.Object ref = publicPtrDomainName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      publicPtrDomainName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECURITY_POLICY_FIELD_NUMBER = 171082513;

  @SuppressWarnings("serial")
  private volatile java.lang.Object securityPolicy_ = "";

  /**
   *
   *
   * <pre>
   * The resource URL for the security policy associated with this access config.
   * </pre>
   *
   * <code>optional string security_policy = 171082513;</code>
   *
   * @return Whether the securityPolicy field is set.
   */
  @java.lang.Override
  public boolean hasSecurityPolicy() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * The resource URL for the security policy associated with this access config.
   * </pre>
   *
   * <code>optional string security_policy = 171082513;</code>
   *
   * @return The securityPolicy.
   */
  @java.lang.Override
  public java.lang.String getSecurityPolicy() {
    java.lang.Object ref = securityPolicy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      securityPolicy_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The resource URL for the security policy associated with this access config.
   * </pre>
   *
   * <code>optional string security_policy = 171082513;</code>
   *
   * @return The bytes for securityPolicy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSecurityPolicyBytes() {
    java.lang.Object ref = securityPolicy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      securityPolicy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SET_PUBLIC_PTR_FIELD_NUMBER = 523870229;
  private boolean setPublicPtr_ = false;

  /**
   *
   *
   * <pre>
   * Specifies whether a public DNS 'PTR' record should be created to map the external IP address of the instance to a DNS domain name. This field is not used in ipv6AccessConfig. A default PTR record will be created if the VM has external IPv6 range associated.
   * </pre>
   *
   * <code>optional bool set_public_ptr = 523870229;</code>
   *
   * @return Whether the setPublicPtr field is set.
   */
  @java.lang.Override
  public boolean hasSetPublicPtr() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies whether a public DNS 'PTR' record should be created to map the external IP address of the instance to a DNS domain name. This field is not used in ipv6AccessConfig. A default PTR record will be created if the VM has external IPv6 range associated.
   * </pre>
   *
   * <code>optional bool set_public_ptr = 523870229;</code>
   *
   * @return The setPublicPtr.
   */
  @java.lang.Override
  public boolean getSetPublicPtr() {
    return setPublicPtr_;
  }

  public static final int TYPE_FIELD_NUMBER = 3575610;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";

  /**
   *
   *
   * <pre>
   * The type of configuration. In accessConfigs (IPv4), the default and only option is ONE_TO_ONE_NAT. In ipv6AccessConfigs, the default and only option is DIRECT_IPV6.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return Whether the type field is set.
   */
  @java.lang.Override
  public boolean hasType() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * The type of configuration. In accessConfigs (IPv4), the default and only option is ONE_TO_ONE_NAT. In ipv6AccessConfigs, the default and only option is DIRECT_IPV6.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The type of configuration. In accessConfigs (IPv4), the default and only option is ONE_TO_ONE_NAT. In ipv6AccessConfigs, the default and only option is DIRECT_IPV6.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3575610, type_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 117634556, natIP_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 171082513, securityPolicy_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 316599167, publicPtrDomainName_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt32(425672143, externalIpv6PrefixLength_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 517397843, networkTier_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeBool(523870229, setPublicPtr_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 532703707, externalIpv6_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3575610, type_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(117634556, natIP_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(171082513, securityPolicy_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(316599167, publicPtrDomainName_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              425672143, externalIpv6PrefixLength_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(517397843, networkTier_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(523870229, setPublicPtr_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(532703707, externalIpv6_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.AccessConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.AccessConfig other = (com.google.cloud.compute.v1.AccessConfig) obj;

    if (hasExternalIpv6() != other.hasExternalIpv6()) return false;
    if (hasExternalIpv6()) {
      if (!getExternalIpv6().equals(other.getExternalIpv6())) return false;
    }
    if (hasExternalIpv6PrefixLength() != other.hasExternalIpv6PrefixLength()) return false;
    if (hasExternalIpv6PrefixLength()) {
      if (getExternalIpv6PrefixLength() != other.getExternalIpv6PrefixLength()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasNatIP() != other.hasNatIP()) return false;
    if (hasNatIP()) {
      if (!getNatIP().equals(other.getNatIP())) return false;
    }
    if (hasNetworkTier() != other.hasNetworkTier()) return false;
    if (hasNetworkTier()) {
      if (!getNetworkTier().equals(other.getNetworkTier())) return false;
    }
    if (hasPublicPtrDomainName() != other.hasPublicPtrDomainName()) return false;
    if (hasPublicPtrDomainName()) {
      if (!getPublicPtrDomainName().equals(other.getPublicPtrDomainName())) return false;
    }
    if (hasSecurityPolicy() != other.hasSecurityPolicy()) return false;
    if (hasSecurityPolicy()) {
      if (!getSecurityPolicy().equals(other.getSecurityPolicy())) return false;
    }
    if (hasSetPublicPtr() != other.hasSetPublicPtr()) return false;
    if (hasSetPublicPtr()) {
      if (getSetPublicPtr() != other.getSetPublicPtr()) return false;
    }
    if (hasType() != other.hasType()) return false;
    if (hasType()) {
      if (!getType().equals(other.getType())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasExternalIpv6()) {
      hash = (37 * hash) + EXTERNAL_IPV6_FIELD_NUMBER;
      hash = (53 * hash) + getExternalIpv6().hashCode();
    }
    if (hasExternalIpv6PrefixLength()) {
      hash = (37 * hash) + EXTERNAL_IPV6_PREFIX_LENGTH_FIELD_NUMBER;
      hash = (53 * hash) + getExternalIpv6PrefixLength();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasNatIP()) {
      hash = (37 * hash) + NAT_I_P_FIELD_NUMBER;
      hash = (53 * hash) + getNatIP().hashCode();
    }
    if (hasNetworkTier()) {
      hash = (37 * hash) + NETWORK_TIER_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkTier().hashCode();
    }
    if (hasPublicPtrDomainName()) {
      hash = (37 * hash) + PUBLIC_PTR_DOMAIN_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getPublicPtrDomainName().hashCode();
    }
    if (hasSecurityPolicy()) {
      hash = (37 * hash) + SECURITY_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getSecurityPolicy().hashCode();
    }
    if (hasSetPublicPtr()) {
      hash = (37 * hash) + SET_PUBLIC_PTR_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSetPublicPtr());
    }
    if (hasType()) {
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.AccessConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AccessConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AccessConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AccessConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AccessConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AccessConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AccessConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AccessConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AccessConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AccessConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AccessConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AccessConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.AccessConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * An access configuration attached to an instance's network interface. Only one access config per instance is supported.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.AccessConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.AccessConfig)
      com.google.cloud.compute.v1.AccessConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AccessConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AccessConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.AccessConfig.class,
              com.google.cloud.compute.v1.AccessConfig.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.AccessConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      externalIpv6_ = "";
      externalIpv6PrefixLength_ = 0;
      kind_ = "";
      name_ = "";
      natIP_ = "";
      networkTier_ = "";
      publicPtrDomainName_ = "";
      securityPolicy_ = "";
      setPublicPtr_ = false;
      type_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AccessConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AccessConfig getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.AccessConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AccessConfig build() {
      com.google.cloud.compute.v1.AccessConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AccessConfig buildPartial() {
      com.google.cloud.compute.v1.AccessConfig result =
          new com.google.cloud.compute.v1.AccessConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.AccessConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.externalIpv6_ = externalIpv6_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.externalIpv6PrefixLength_ = externalIpv6PrefixLength_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.natIP_ = natIP_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.networkTier_ = networkTier_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.publicPtrDomainName_ = publicPtrDomainName_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.securityPolicy_ = securityPolicy_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.setPublicPtr_ = setPublicPtr_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.type_ = type_;
        to_bitField0_ |= 0x00000200;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.AccessConfig) {
        return mergeFrom((com.google.cloud.compute.v1.AccessConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.AccessConfig other) {
      if (other == com.google.cloud.compute.v1.AccessConfig.getDefaultInstance()) return this;
      if (other.hasExternalIpv6()) {
        externalIpv6_ = other.externalIpv6_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasExternalIpv6PrefixLength()) {
        setExternalIpv6PrefixLength(other.getExternalIpv6PrefixLength());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasNatIP()) {
        natIP_ = other.natIP_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasNetworkTier()) {
        networkTier_ = other.networkTier_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasPublicPtrDomainName()) {
        publicPtrDomainName_ = other.publicPtrDomainName_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasSecurityPolicy()) {
        securityPolicy_ = other.securityPolicy_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasSetPublicPtr()) {
        setSetPublicPtr(other.getSetPublicPtr());
      }
      if (other.hasType()) {
        type_ = other.type_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 26989658
            case 28604882:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 28604882
            case 941076450:
              {
                natIP_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 941076450
            case 1368660106:
              {
                securityPolicy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 1368660106
            case -1762173958:
              {
                publicPtrDomainName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case -1762173958
            case -889590152:
              {
                externalIpv6PrefixLength_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case -889590152
            case -155784550:
              {
                networkTier_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case -155784550
            case -104005464:
              {
                setPublicPtr_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case -104005464
            case -33337638:
              {
                externalIpv6_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -33337638
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object externalIpv6_ = "";

    /**
     *
     *
     * <pre>
     * Applies to ipv6AccessConfigs only. The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. To use a static external IP address, it must be unused and in the same region as the instance's zone. If not specified, Google Cloud will automatically assign an external IPv6 address from the instance's subnetwork.
     * </pre>
     *
     * <code>optional string external_ipv6 = 532703707;</code>
     *
     * @return Whether the externalIpv6 field is set.
     */
    public boolean hasExternalIpv6() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Applies to ipv6AccessConfigs only. The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. To use a static external IP address, it must be unused and in the same region as the instance's zone. If not specified, Google Cloud will automatically assign an external IPv6 address from the instance's subnetwork.
     * </pre>
     *
     * <code>optional string external_ipv6 = 532703707;</code>
     *
     * @return The externalIpv6.
     */
    public java.lang.String getExternalIpv6() {
      java.lang.Object ref = externalIpv6_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        externalIpv6_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Applies to ipv6AccessConfigs only. The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. To use a static external IP address, it must be unused and in the same region as the instance's zone. If not specified, Google Cloud will automatically assign an external IPv6 address from the instance's subnetwork.
     * </pre>
     *
     * <code>optional string external_ipv6 = 532703707;</code>
     *
     * @return The bytes for externalIpv6.
     */
    public com.google.protobuf.ByteString getExternalIpv6Bytes() {
      java.lang.Object ref = externalIpv6_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        externalIpv6_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Applies to ipv6AccessConfigs only. The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. To use a static external IP address, it must be unused and in the same region as the instance's zone. If not specified, Google Cloud will automatically assign an external IPv6 address from the instance's subnetwork.
     * </pre>
     *
     * <code>optional string external_ipv6 = 532703707;</code>
     *
     * @param value The externalIpv6 to set.
     * @return This builder for chaining.
     */
    public Builder setExternalIpv6(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      externalIpv6_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Applies to ipv6AccessConfigs only. The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. To use a static external IP address, it must be unused and in the same region as the instance's zone. If not specified, Google Cloud will automatically assign an external IPv6 address from the instance's subnetwork.
     * </pre>
     *
     * <code>optional string external_ipv6 = 532703707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExternalIpv6() {
      externalIpv6_ = getDefaultInstance().getExternalIpv6();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Applies to ipv6AccessConfigs only. The first IPv6 address of the external IPv6 range associated with this instance, prefix length is stored in externalIpv6PrefixLength in ipv6AccessConfig. To use a static external IP address, it must be unused and in the same region as the instance's zone. If not specified, Google Cloud will automatically assign an external IPv6 address from the instance's subnetwork.
     * </pre>
     *
     * <code>optional string external_ipv6 = 532703707;</code>
     *
     * @param value The bytes for externalIpv6 to set.
     * @return This builder for chaining.
     */
    public Builder setExternalIpv6Bytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      externalIpv6_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int externalIpv6PrefixLength_;

    /**
     *
     *
     * <pre>
     * Applies to ipv6AccessConfigs only. The prefix length of the external IPv6 range.
     * </pre>
     *
     * <code>optional int32 external_ipv6_prefix_length = 425672143;</code>
     *
     * @return Whether the externalIpv6PrefixLength field is set.
     */
    @java.lang.Override
    public boolean hasExternalIpv6PrefixLength() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Applies to ipv6AccessConfigs only. The prefix length of the external IPv6 range.
     * </pre>
     *
     * <code>optional int32 external_ipv6_prefix_length = 425672143;</code>
     *
     * @return The externalIpv6PrefixLength.
     */
    @java.lang.Override
    public int getExternalIpv6PrefixLength() {
      return externalIpv6PrefixLength_;
    }

    /**
     *
     *
     * <pre>
     * Applies to ipv6AccessConfigs only. The prefix length of the external IPv6 range.
     * </pre>
     *
     * <code>optional int32 external_ipv6_prefix_length = 425672143;</code>
     *
     * @param value The externalIpv6PrefixLength to set.
     * @return This builder for chaining.
     */
    public Builder setExternalIpv6PrefixLength(int value) {

      externalIpv6PrefixLength_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Applies to ipv6AccessConfigs only. The prefix length of the external IPv6 range.
     * </pre>
     *
     * <code>optional int32 external_ipv6_prefix_length = 425672143;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExternalIpv6PrefixLength() {
      bitField0_ = (bitField0_ & ~0x00000002);
      externalIpv6PrefixLength_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#accessConfig for access configs.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#accessConfig for access configs.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#accessConfig for access configs.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#accessConfig for access configs.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#accessConfig for access configs.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#accessConfig for access configs.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * The name of this access configuration. In accessConfigs (IPv4), the default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access. In ipv6AccessConfigs, the recommend name is External IPv6.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * The name of this access configuration. In accessConfigs (IPv4), the default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access. In ipv6AccessConfigs, the recommend name is External IPv6.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of this access configuration. In accessConfigs (IPv4), the default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access. In ipv6AccessConfigs, the recommend name is External IPv6.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of this access configuration. In accessConfigs (IPv4), the default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access. In ipv6AccessConfigs, the recommend name is External IPv6.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of this access configuration. In accessConfigs (IPv4), the default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access. In ipv6AccessConfigs, the recommend name is External IPv6.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of this access configuration. In accessConfigs (IPv4), the default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access. In ipv6AccessConfigs, the recommend name is External IPv6.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object natIP_ = "";

    /**
     *
     *
     * <pre>
     * Applies to accessConfigs (IPv4) only. An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
     * </pre>
     *
     * <code>optional string nat_i_p = 117634556;</code>
     *
     * @return Whether the natIP field is set.
     */
    public boolean hasNatIP() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Applies to accessConfigs (IPv4) only. An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
     * </pre>
     *
     * <code>optional string nat_i_p = 117634556;</code>
     *
     * @return The natIP.
     */
    public java.lang.String getNatIP() {
      java.lang.Object ref = natIP_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        natIP_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Applies to accessConfigs (IPv4) only. An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
     * </pre>
     *
     * <code>optional string nat_i_p = 117634556;</code>
     *
     * @return The bytes for natIP.
     */
    public com.google.protobuf.ByteString getNatIPBytes() {
      java.lang.Object ref = natIP_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        natIP_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Applies to accessConfigs (IPv4) only. An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
     * </pre>
     *
     * <code>optional string nat_i_p = 117634556;</code>
     *
     * @param value The natIP to set.
     * @return This builder for chaining.
     */
    public Builder setNatIP(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      natIP_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Applies to accessConfigs (IPv4) only. An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
     * </pre>
     *
     * <code>optional string nat_i_p = 117634556;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNatIP() {
      natIP_ = getDefaultInstance().getNatIP();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Applies to accessConfigs (IPv4) only. An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
     * </pre>
     *
     * <code>optional string nat_i_p = 117634556;</code>
     *
     * @param value The bytes for natIP to set.
     * @return This builder for chaining.
     */
    public Builder setNatIPBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      natIP_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object networkTier_ = "";

    /**
     *
     *
     * <pre>
     * This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
     * Check the NetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_tier = 517397843;</code>
     *
     * @return Whether the networkTier field is set.
     */
    public boolean hasNetworkTier() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
     * Check the NetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_tier = 517397843;</code>
     *
     * @return The networkTier.
     */
    public java.lang.String getNetworkTier() {
      java.lang.Object ref = networkTier_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        networkTier_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
     * Check the NetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_tier = 517397843;</code>
     *
     * @return The bytes for networkTier.
     */
    public com.google.protobuf.ByteString getNetworkTierBytes() {
      java.lang.Object ref = networkTier_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        networkTier_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
     * Check the NetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_tier = 517397843;</code>
     *
     * @param value The networkTier to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkTier(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      networkTier_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
     * Check the NetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_tier = 517397843;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkTier() {
      networkTier_ = getDefaultInstance().getNetworkTier();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD. If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier. If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
     * Check the NetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_tier = 517397843;</code>
     *
     * @param value The bytes for networkTier to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkTierBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      networkTier_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object publicPtrDomainName_ = "";

    /**
     *
     *
     * <pre>
     * The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled in accessConfig. If this field is unspecified in ipv6AccessConfig, a default PTR record will be created for first IP in associated external IPv6 range.
     * </pre>
     *
     * <code>optional string public_ptr_domain_name = 316599167;</code>
     *
     * @return Whether the publicPtrDomainName field is set.
     */
    public boolean hasPublicPtrDomainName() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled in accessConfig. If this field is unspecified in ipv6AccessConfig, a default PTR record will be created for first IP in associated external IPv6 range.
     * </pre>
     *
     * <code>optional string public_ptr_domain_name = 316599167;</code>
     *
     * @return The publicPtrDomainName.
     */
    public java.lang.String getPublicPtrDomainName() {
      java.lang.Object ref = publicPtrDomainName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        publicPtrDomainName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled in accessConfig. If this field is unspecified in ipv6AccessConfig, a default PTR record will be created for first IP in associated external IPv6 range.
     * </pre>
     *
     * <code>optional string public_ptr_domain_name = 316599167;</code>
     *
     * @return The bytes for publicPtrDomainName.
     */
    public com.google.protobuf.ByteString getPublicPtrDomainNameBytes() {
      java.lang.Object ref = publicPtrDomainName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        publicPtrDomainName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled in accessConfig. If this field is unspecified in ipv6AccessConfig, a default PTR record will be created for first IP in associated external IPv6 range.
     * </pre>
     *
     * <code>optional string public_ptr_domain_name = 316599167;</code>
     *
     * @param value The publicPtrDomainName to set.
     * @return This builder for chaining.
     */
    public Builder setPublicPtrDomainName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      publicPtrDomainName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled in accessConfig. If this field is unspecified in ipv6AccessConfig, a default PTR record will be created for first IP in associated external IPv6 range.
     * </pre>
     *
     * <code>optional string public_ptr_domain_name = 316599167;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPublicPtrDomainName() {
      publicPtrDomainName_ = getDefaultInstance().getPublicPtrDomainName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled in accessConfig. If this field is unspecified in ipv6AccessConfig, a default PTR record will be created for first IP in associated external IPv6 range.
     * </pre>
     *
     * <code>optional string public_ptr_domain_name = 316599167;</code>
     *
     * @param value The bytes for publicPtrDomainName to set.
     * @return This builder for chaining.
     */
    public Builder setPublicPtrDomainNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      publicPtrDomainName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object securityPolicy_ = "";

    /**
     *
     *
     * <pre>
     * The resource URL for the security policy associated with this access config.
     * </pre>
     *
     * <code>optional string security_policy = 171082513;</code>
     *
     * @return Whether the securityPolicy field is set.
     */
    public boolean hasSecurityPolicy() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * The resource URL for the security policy associated with this access config.
     * </pre>
     *
     * <code>optional string security_policy = 171082513;</code>
     *
     * @return The securityPolicy.
     */
    public java.lang.String getSecurityPolicy() {
      java.lang.Object ref = securityPolicy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        securityPolicy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource URL for the security policy associated with this access config.
     * </pre>
     *
     * <code>optional string security_policy = 171082513;</code>
     *
     * @return The bytes for securityPolicy.
     */
    public com.google.protobuf.ByteString getSecurityPolicyBytes() {
      java.lang.Object ref = securityPolicy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        securityPolicy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource URL for the security policy associated with this access config.
     * </pre>
     *
     * <code>optional string security_policy = 171082513;</code>
     *
     * @param value The securityPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setSecurityPolicy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      securityPolicy_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource URL for the security policy associated with this access config.
     * </pre>
     *
     * <code>optional string security_policy = 171082513;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSecurityPolicy() {
      securityPolicy_ = getDefaultInstance().getSecurityPolicy();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource URL for the security policy associated with this access config.
     * </pre>
     *
     * <code>optional string security_policy = 171082513;</code>
     *
     * @param value The bytes for securityPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setSecurityPolicyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      securityPolicy_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private boolean setPublicPtr_;

    /**
     *
     *
     * <pre>
     * Specifies whether a public DNS 'PTR' record should be created to map the external IP address of the instance to a DNS domain name. This field is not used in ipv6AccessConfig. A default PTR record will be created if the VM has external IPv6 range associated.
     * </pre>
     *
     * <code>optional bool set_public_ptr = 523870229;</code>
     *
     * @return Whether the setPublicPtr field is set.
     */
    @java.lang.Override
    public boolean hasSetPublicPtr() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies whether a public DNS 'PTR' record should be created to map the external IP address of the instance to a DNS domain name. This field is not used in ipv6AccessConfig. A default PTR record will be created if the VM has external IPv6 range associated.
     * </pre>
     *
     * <code>optional bool set_public_ptr = 523870229;</code>
     *
     * @return The setPublicPtr.
     */
    @java.lang.Override
    public boolean getSetPublicPtr() {
      return setPublicPtr_;
    }

    /**
     *
     *
     * <pre>
     * Specifies whether a public DNS 'PTR' record should be created to map the external IP address of the instance to a DNS domain name. This field is not used in ipv6AccessConfig. A default PTR record will be created if the VM has external IPv6 range associated.
     * </pre>
     *
     * <code>optional bool set_public_ptr = 523870229;</code>
     *
     * @param value The setPublicPtr to set.
     * @return This builder for chaining.
     */
    public Builder setSetPublicPtr(boolean value) {

      setPublicPtr_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies whether a public DNS 'PTR' record should be created to map the external IP address of the instance to a DNS domain name. This field is not used in ipv6AccessConfig. A default PTR record will be created if the VM has external IPv6 range associated.
     * </pre>
     *
     * <code>optional bool set_public_ptr = 523870229;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSetPublicPtr() {
      bitField0_ = (bitField0_ & ~0x00000100);
      setPublicPtr_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";

    /**
     *
     *
     * <pre>
     * The type of configuration. In accessConfigs (IPv4), the default and only option is ONE_TO_ONE_NAT. In ipv6AccessConfigs, the default and only option is DIRECT_IPV6.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return Whether the type field is set.
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * The type of configuration. In accessConfigs (IPv4), the default and only option is ONE_TO_ONE_NAT. In ipv6AccessConfigs, the default and only option is DIRECT_IPV6.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The type of configuration. In accessConfigs (IPv4), the default and only option is ONE_TO_ONE_NAT. In ipv6AccessConfigs, the default and only option is DIRECT_IPV6.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The type of configuration. In accessConfigs (IPv4), the default and only option is ONE_TO_ONE_NAT. In ipv6AccessConfigs, the default and only option is DIRECT_IPV6.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of configuration. In accessConfigs (IPv4), the default and only option is ONE_TO_ONE_NAT. In ipv6AccessConfigs, the default and only option is DIRECT_IPV6.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of configuration. In accessConfigs (IPv4), the default and only option is ONE_TO_ONE_NAT. In ipv6AccessConfigs, the default and only option is DIRECT_IPV6.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.AccessConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.AccessConfig)
  private static final com.google.cloud.compute.v1.AccessConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.AccessConfig();
  }

  public static com.google.cloud.compute.v1.AccessConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AccessConfig> PARSER =
      new com.google.protobuf.AbstractParser<AccessConfig>() {
        @java.lang.Override
        public AccessConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AccessConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AccessConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.AccessConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
