/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.cloudquotas.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QuotaPreferenceName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_QUOTA_PREFERENCE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/quotaPreferences/{quota_preference}");
    private static final PathTemplate FOLDER_LOCATION_QUOTA_PREFERENCE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/quotaPreferences/{quota_preference}");
    private static final PathTemplate ORGANIZATION_LOCATION_QUOTA_PREFERENCE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/quotaPreferences/{quota_preference}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String quotaPreference;
    private final String folder;
    private final String organization;

    @Deprecated
    protected QuotaPreferenceName() {
        this.project = null;
        this.location = null;
        this.quotaPreference = null;
        this.folder = null;
        this.organization = null;
    }

    private QuotaPreferenceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.quotaPreference = (String)Preconditions.checkNotNull((Object)builder.getQuotaPreference());
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_QUOTA_PREFERENCE;
    }

    private QuotaPreferenceName(FolderLocationQuotaPreferenceBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.quotaPreference = (String)Preconditions.checkNotNull((Object)builder.getQuotaPreference());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_LOCATION_QUOTA_PREFERENCE;
    }

    private QuotaPreferenceName(OrganizationLocationQuotaPreferenceBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.quotaPreference = (String)Preconditions.checkNotNull((Object)builder.getQuotaPreference());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_LOCATION_QUOTA_PREFERENCE;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getQuotaPreference() {
        return this.quotaPreference;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationQuotaPreferenceBuilder() {
        return new Builder();
    }

    public static FolderLocationQuotaPreferenceBuilder newFolderLocationQuotaPreferenceBuilder() {
        return new FolderLocationQuotaPreferenceBuilder();
    }

    public static OrganizationLocationQuotaPreferenceBuilder newOrganizationLocationQuotaPreferenceBuilder() {
        return new OrganizationLocationQuotaPreferenceBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static QuotaPreferenceName of(String project, String location, String quotaPreference) {
        return QuotaPreferenceName.newBuilder().setProject(project).setLocation(location).setQuotaPreference(quotaPreference).build();
    }

    public static QuotaPreferenceName ofProjectLocationQuotaPreferenceName(String project, String location, String quotaPreference) {
        return QuotaPreferenceName.newBuilder().setProject(project).setLocation(location).setQuotaPreference(quotaPreference).build();
    }

    public static QuotaPreferenceName ofFolderLocationQuotaPreferenceName(String folder, String location, String quotaPreference) {
        return QuotaPreferenceName.newFolderLocationQuotaPreferenceBuilder().setFolder(folder).setLocation(location).setQuotaPreference(quotaPreference).build();
    }

    public static QuotaPreferenceName ofOrganizationLocationQuotaPreferenceName(String organization, String location, String quotaPreference) {
        return QuotaPreferenceName.newOrganizationLocationQuotaPreferenceBuilder().setOrganization(organization).setLocation(location).setQuotaPreference(quotaPreference).build();
    }

    public static String format(String project, String location, String quotaPreference) {
        return QuotaPreferenceName.newBuilder().setProject(project).setLocation(location).setQuotaPreference(quotaPreference).build().toString();
    }

    public static String formatProjectLocationQuotaPreferenceName(String project, String location, String quotaPreference) {
        return QuotaPreferenceName.newBuilder().setProject(project).setLocation(location).setQuotaPreference(quotaPreference).build().toString();
    }

    public static String formatFolderLocationQuotaPreferenceName(String folder, String location, String quotaPreference) {
        return QuotaPreferenceName.newFolderLocationQuotaPreferenceBuilder().setFolder(folder).setLocation(location).setQuotaPreference(quotaPreference).build().toString();
    }

    public static String formatOrganizationLocationQuotaPreferenceName(String organization, String location, String quotaPreference) {
        return QuotaPreferenceName.newOrganizationLocationQuotaPreferenceBuilder().setOrganization(organization).setLocation(location).setQuotaPreference(quotaPreference).build().toString();
    }

    public static QuotaPreferenceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_QUOTA_PREFERENCE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_QUOTA_PREFERENCE.match(formattedString);
            return QuotaPreferenceName.ofProjectLocationQuotaPreferenceName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("quota_preference"));
        }
        if (FOLDER_LOCATION_QUOTA_PREFERENCE.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION_QUOTA_PREFERENCE.match(formattedString);
            return QuotaPreferenceName.ofFolderLocationQuotaPreferenceName((String)matchMap.get("folder"), (String)matchMap.get("location"), (String)matchMap.get("quota_preference"));
        }
        if (ORGANIZATION_LOCATION_QUOTA_PREFERENCE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_QUOTA_PREFERENCE.match(formattedString);
            return QuotaPreferenceName.ofOrganizationLocationQuotaPreferenceName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("quota_preference"));
        }
        throw new ValidationException("QuotaPreferenceName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<QuotaPreferenceName> parseList(List<String> formattedStrings) {
        ArrayList<QuotaPreferenceName> list = new ArrayList<QuotaPreferenceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(QuotaPreferenceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<QuotaPreferenceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (QuotaPreferenceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_QUOTA_PREFERENCE.matches(formattedString) || FOLDER_LOCATION_QUOTA_PREFERENCE.matches(formattedString) || ORGANIZATION_LOCATION_QUOTA_PREFERENCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            QuotaPreferenceName quotaPreferenceName = this;
            synchronized (quotaPreferenceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.quotaPreference != null) {
                        fieldMapBuilder.put((Object)"quota_preference", (Object)this.quotaPreference);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            QuotaPreferenceName that = (QuotaPreferenceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.quotaPreference, that.quotaPreference) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.quotaPreference);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    public static class OrganizationLocationQuotaPreferenceBuilder {
        private String organization;
        private String location;
        private String quotaPreference;

        protected OrganizationLocationQuotaPreferenceBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getQuotaPreference() {
            return this.quotaPreference;
        }

        public OrganizationLocationQuotaPreferenceBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationQuotaPreferenceBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationQuotaPreferenceBuilder setQuotaPreference(String quotaPreference) {
            this.quotaPreference = quotaPreference;
            return this;
        }

        public QuotaPreferenceName build() {
            return new QuotaPreferenceName(this);
        }
    }

    public static class FolderLocationQuotaPreferenceBuilder {
        private String folder;
        private String location;
        private String quotaPreference;

        protected FolderLocationQuotaPreferenceBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getQuotaPreference() {
            return this.quotaPreference;
        }

        public FolderLocationQuotaPreferenceBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationQuotaPreferenceBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationQuotaPreferenceBuilder setQuotaPreference(String quotaPreference) {
            this.quotaPreference = quotaPreference;
            return this;
        }

        public QuotaPreferenceName build() {
            return new QuotaPreferenceName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String quotaPreference;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getQuotaPreference() {
            return this.quotaPreference;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setQuotaPreference(String quotaPreference) {
            this.quotaPreference = quotaPreference;
            return this;
        }

        private Builder(QuotaPreferenceName quotaPreferenceName) {
            Preconditions.checkArgument((boolean)Objects.equals(quotaPreferenceName.pathTemplate, PROJECT_LOCATION_QUOTA_PREFERENCE), (Object)"toBuilder is only supported when QuotaPreferenceName has the pattern of projects/{project}/locations/{location}/quotaPreferences/{quota_preference}");
            this.project = quotaPreferenceName.project;
            this.location = quotaPreferenceName.location;
            this.quotaPreference = quotaPreferenceName.quotaPreference;
        }

        public QuotaPreferenceName build() {
            return new QuotaPreferenceName(this);
        }
    }
}

