/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/cloudquotas/v1beta/resources.proto

// Protobuf Java Version: 3.25.8
package com.google.api.cloudquotas.v1beta;

/**
 *
 *
 * <pre>
 * The preferred quota configuration.
 * </pre>
 *
 * Protobuf type {@code google.api.cloudquotas.v1beta.QuotaConfig}
 */
public final class QuotaConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.cloudquotas.v1beta.QuotaConfig)
    QuotaConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use QuotaConfig.newBuilder() to construct.
  private QuotaConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QuotaConfig() {
    stateDetail_ = "";
    traceId_ = "";
    requestOrigin_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QuotaConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.cloudquotas.v1beta.ResourcesProto
        .internal_static_google_api_cloudquotas_v1beta_QuotaConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 5:
        return internalGetAnnotations();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.cloudquotas.v1beta.ResourcesProto
        .internal_static_google_api_cloudquotas_v1beta_QuotaConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.cloudquotas.v1beta.QuotaConfig.class,
            com.google.api.cloudquotas.v1beta.QuotaConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The enumeration of the origins of quota preference requests.
   * </pre>
   *
   * Protobuf enum {@code google.api.cloudquotas.v1beta.QuotaConfig.Origin}
   */
  public enum Origin implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The unspecified value.
     * </pre>
     *
     * <code>ORIGIN_UNSPECIFIED = 0;</code>
     */
    ORIGIN_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Created through Cloud Console.
     * </pre>
     *
     * <code>CLOUD_CONSOLE = 1;</code>
     */
    CLOUD_CONSOLE(1),
    /**
     *
     *
     * <pre>
     * Generated by automatic quota adjustment.
     * </pre>
     *
     * <code>AUTO_ADJUSTER = 2;</code>
     */
    AUTO_ADJUSTER(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The unspecified value.
     * </pre>
     *
     * <code>ORIGIN_UNSPECIFIED = 0;</code>
     */
    public static final int ORIGIN_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Created through Cloud Console.
     * </pre>
     *
     * <code>CLOUD_CONSOLE = 1;</code>
     */
    public static final int CLOUD_CONSOLE_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Generated by automatic quota adjustment.
     * </pre>
     *
     * <code>AUTO_ADJUSTER = 2;</code>
     */
    public static final int AUTO_ADJUSTER_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Origin valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Origin forNumber(int value) {
      switch (value) {
        case 0:
          return ORIGIN_UNSPECIFIED;
        case 1:
          return CLOUD_CONSOLE;
        case 2:
          return AUTO_ADJUSTER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Origin> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Origin> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Origin>() {
          public Origin findValueByNumber(int number) {
            return Origin.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.api.cloudquotas.v1beta.QuotaConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final Origin[] VALUES = values();

    public static Origin valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Origin(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.api.cloudquotas.v1beta.QuotaConfig.Origin)
  }

  private int bitField0_;
  public static final int PREFERRED_VALUE_FIELD_NUMBER = 1;
  private long preferredValue_ = 0L;

  /**
   *
   *
   * <pre>
   * Required. The preferred value. Must be greater than or equal to -1. If set
   * to -1, it means the value is "unlimited".
   * </pre>
   *
   * <code>int64 preferred_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The preferredValue.
   */
  @java.lang.Override
  public long getPreferredValue() {
    return preferredValue_;
  }

  public static final int STATE_DETAIL_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stateDetail_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Optional details about the state of this quota preference.
   * </pre>
   *
   * <code>string state_detail = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The stateDetail.
   */
  @java.lang.Override
  public java.lang.String getStateDetail() {
    java.lang.Object ref = stateDetail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stateDetail_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Optional details about the state of this quota preference.
   * </pre>
   *
   * <code>string state_detail = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for stateDetail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateDetailBytes() {
    java.lang.Object ref = stateDetail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stateDetail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GRANTED_VALUE_FIELD_NUMBER = 3;
  private com.google.protobuf.Int64Value grantedValue_;

  /**
   *
   *
   * <pre>
   * Output only. Granted quota value.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value granted_value = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the grantedValue field is set.
   */
  @java.lang.Override
  public boolean hasGrantedValue() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Granted quota value.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value granted_value = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The grantedValue.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getGrantedValue() {
    return grantedValue_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : grantedValue_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Granted quota value.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value granted_value = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getGrantedValueOrBuilder() {
    return grantedValue_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : grantedValue_;
  }

  public static final int TRACE_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object traceId_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The trace id that the Google Cloud uses to provision the
   * requested quota. This trace id may be used by the client to contact Cloud
   * support to track the state of a quota preference request. The trace id is
   * only produced for increase requests and is unique for each request. The
   * quota decrease requests do not have a trace id.
   * </pre>
   *
   * <code>string trace_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The traceId.
   */
  @java.lang.Override
  public java.lang.String getTraceId() {
    java.lang.Object ref = traceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      traceId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The trace id that the Google Cloud uses to provision the
   * requested quota. This trace id may be used by the client to contact Cloud
   * support to track the state of a quota preference request. The trace id is
   * only produced for increase requests and is unique for each request. The
   * quota decrease requests do not have a trace id.
   * </pre>
   *
   * <code>string trace_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for traceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTraceIdBytes() {
    java.lang.Object ref = traceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      traceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 5;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.api.cloudquotas.v1beta.ResourcesProto
                .internal_static_google_api_cloudquotas_v1beta_QuotaConfig_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. The annotations map for clients to store small amounts of
   * arbitrary data. Do not put PII or other sensitive information here. See
   * https://google.aip.dev/128#annotations
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }

  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. The annotations map for clients to store small amounts of
   * arbitrary data. Do not put PII or other sensitive information here. See
   * https://google.aip.dev/128#annotations
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. The annotations map for clients to store small amounts of
   * arbitrary data. Do not put PII or other sensitive information here. See
   * https://google.aip.dev/128#annotations
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. The annotations map for clients to store small amounts of
   * arbitrary data. Do not put PII or other sensitive information here. See
   * https://google.aip.dev/128#annotations
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int REQUEST_ORIGIN_FIELD_NUMBER = 6;
  private int requestOrigin_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. The origin of the quota preference request.
   * </pre>
   *
   * <code>
   * .google.api.cloudquotas.v1beta.QuotaConfig.Origin request_origin = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for requestOrigin.
   */
  @java.lang.Override
  public int getRequestOriginValue() {
    return requestOrigin_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The origin of the quota preference request.
   * </pre>
   *
   * <code>
   * .google.api.cloudquotas.v1beta.QuotaConfig.Origin request_origin = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The requestOrigin.
   */
  @java.lang.Override
  public com.google.api.cloudquotas.v1beta.QuotaConfig.Origin getRequestOrigin() {
    com.google.api.cloudquotas.v1beta.QuotaConfig.Origin result =
        com.google.api.cloudquotas.v1beta.QuotaConfig.Origin.forNumber(requestOrigin_);
    return result == null
        ? com.google.api.cloudquotas.v1beta.QuotaConfig.Origin.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (preferredValue_ != 0L) {
      output.writeInt64(1, preferredValue_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateDetail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, stateDetail_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getGrantedValue());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(traceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, traceId_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 5);
    if (requestOrigin_
        != com.google.api.cloudquotas.v1beta.QuotaConfig.Origin.ORIGIN_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, requestOrigin_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (preferredValue_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, preferredValue_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateDetail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, stateDetail_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getGrantedValue());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(traceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, traceId_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, annotations__);
    }
    if (requestOrigin_
        != com.google.api.cloudquotas.v1beta.QuotaConfig.Origin.ORIGIN_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, requestOrigin_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.cloudquotas.v1beta.QuotaConfig)) {
      return super.equals(obj);
    }
    com.google.api.cloudquotas.v1beta.QuotaConfig other =
        (com.google.api.cloudquotas.v1beta.QuotaConfig) obj;

    if (getPreferredValue() != other.getPreferredValue()) return false;
    if (!getStateDetail().equals(other.getStateDetail())) return false;
    if (hasGrantedValue() != other.hasGrantedValue()) return false;
    if (hasGrantedValue()) {
      if (!getGrantedValue().equals(other.getGrantedValue())) return false;
    }
    if (!getTraceId().equals(other.getTraceId())) return false;
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (requestOrigin_ != other.requestOrigin_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PREFERRED_VALUE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPreferredValue());
    hash = (37 * hash) + STATE_DETAIL_FIELD_NUMBER;
    hash = (53 * hash) + getStateDetail().hashCode();
    if (hasGrantedValue()) {
      hash = (37 * hash) + GRANTED_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getGrantedValue().hashCode();
    }
    hash = (37 * hash) + TRACE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTraceId().hashCode();
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    hash = (37 * hash) + REQUEST_ORIGIN_FIELD_NUMBER;
    hash = (53 * hash) + requestOrigin_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.cloudquotas.v1beta.QuotaConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.cloudquotas.v1beta.QuotaConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1beta.QuotaConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.cloudquotas.v1beta.QuotaConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1beta.QuotaConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.cloudquotas.v1beta.QuotaConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1beta.QuotaConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.cloudquotas.v1beta.QuotaConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1beta.QuotaConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.cloudquotas.v1beta.QuotaConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1beta.QuotaConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.cloudquotas.v1beta.QuotaConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.cloudquotas.v1beta.QuotaConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The preferred quota configuration.
   * </pre>
   *
   * Protobuf type {@code google.api.cloudquotas.v1beta.QuotaConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.cloudquotas.v1beta.QuotaConfig)
      com.google.api.cloudquotas.v1beta.QuotaConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.cloudquotas.v1beta.ResourcesProto
          .internal_static_google_api_cloudquotas_v1beta_QuotaConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMutableAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.cloudquotas.v1beta.ResourcesProto
          .internal_static_google_api_cloudquotas_v1beta_QuotaConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.cloudquotas.v1beta.QuotaConfig.class,
              com.google.api.cloudquotas.v1beta.QuotaConfig.Builder.class);
    }

    // Construct using com.google.api.cloudquotas.v1beta.QuotaConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getGrantedValueFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      preferredValue_ = 0L;
      stateDetail_ = "";
      grantedValue_ = null;
      if (grantedValueBuilder_ != null) {
        grantedValueBuilder_.dispose();
        grantedValueBuilder_ = null;
      }
      traceId_ = "";
      internalGetMutableAnnotations().clear();
      requestOrigin_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.cloudquotas.v1beta.ResourcesProto
          .internal_static_google_api_cloudquotas_v1beta_QuotaConfig_descriptor;
    }

    @java.lang.Override
    public com.google.api.cloudquotas.v1beta.QuotaConfig getDefaultInstanceForType() {
      return com.google.api.cloudquotas.v1beta.QuotaConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.cloudquotas.v1beta.QuotaConfig build() {
      com.google.api.cloudquotas.v1beta.QuotaConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.cloudquotas.v1beta.QuotaConfig buildPartial() {
      com.google.api.cloudquotas.v1beta.QuotaConfig result =
          new com.google.api.cloudquotas.v1beta.QuotaConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.api.cloudquotas.v1beta.QuotaConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.preferredValue_ = preferredValue_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.stateDetail_ = stateDetail_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.grantedValue_ =
            grantedValueBuilder_ == null ? grantedValue_ : grantedValueBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.traceId_ = traceId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.requestOrigin_ = requestOrigin_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.cloudquotas.v1beta.QuotaConfig) {
        return mergeFrom((com.google.api.cloudquotas.v1beta.QuotaConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.cloudquotas.v1beta.QuotaConfig other) {
      if (other == com.google.api.cloudquotas.v1beta.QuotaConfig.getDefaultInstance()) return this;
      if (other.getPreferredValue() != 0L) {
        setPreferredValue(other.getPreferredValue());
      }
      if (!other.getStateDetail().isEmpty()) {
        stateDetail_ = other.stateDetail_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasGrantedValue()) {
        mergeGrantedValue(other.getGrantedValue());
      }
      if (!other.getTraceId().isEmpty()) {
        traceId_ = other.traceId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000010;
      if (other.requestOrigin_ != 0) {
        setRequestOriginValue(other.getRequestOriginValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                preferredValue_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                stateDetail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getGrantedValueFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                traceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                requestOrigin_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private long preferredValue_;

    /**
     *
     *
     * <pre>
     * Required. The preferred value. Must be greater than or equal to -1. If set
     * to -1, it means the value is "unlimited".
     * </pre>
     *
     * <code>int64 preferred_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The preferredValue.
     */
    @java.lang.Override
    public long getPreferredValue() {
      return preferredValue_;
    }

    /**
     *
     *
     * <pre>
     * Required. The preferred value. Must be greater than or equal to -1. If set
     * to -1, it means the value is "unlimited".
     * </pre>
     *
     * <code>int64 preferred_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The preferredValue to set.
     * @return This builder for chaining.
     */
    public Builder setPreferredValue(long value) {

      preferredValue_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The preferred value. Must be greater than or equal to -1. If set
     * to -1, it means the value is "unlimited".
     * </pre>
     *
     * <code>int64 preferred_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPreferredValue() {
      bitField0_ = (bitField0_ & ~0x00000001);
      preferredValue_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object stateDetail_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Optional details about the state of this quota preference.
     * </pre>
     *
     * <code>string state_detail = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stateDetail.
     */
    public java.lang.String getStateDetail() {
      java.lang.Object ref = stateDetail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateDetail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Optional details about the state of this quota preference.
     * </pre>
     *
     * <code>string state_detail = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stateDetail.
     */
    public com.google.protobuf.ByteString getStateDetailBytes() {
      java.lang.Object ref = stateDetail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stateDetail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Optional details about the state of this quota preference.
     * </pre>
     *
     * <code>string state_detail = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The stateDetail to set.
     * @return This builder for chaining.
     */
    public Builder setStateDetail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stateDetail_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Optional details about the state of this quota preference.
     * </pre>
     *
     * <code>string state_detail = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStateDetail() {
      stateDetail_ = getDefaultInstance().getStateDetail();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Optional details about the state of this quota preference.
     * </pre>
     *
     * <code>string state_detail = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for stateDetail to set.
     * @return This builder for chaining.
     */
    public Builder setStateDetailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stateDetail_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Int64Value grantedValue_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        grantedValueBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Granted quota value.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value granted_value = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the grantedValue field is set.
     */
    public boolean hasGrantedValue() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Granted quota value.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value granted_value = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The grantedValue.
     */
    public com.google.protobuf.Int64Value getGrantedValue() {
      if (grantedValueBuilder_ == null) {
        return grantedValue_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : grantedValue_;
      } else {
        return grantedValueBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Granted quota value.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value granted_value = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGrantedValue(com.google.protobuf.Int64Value value) {
      if (grantedValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        grantedValue_ = value;
      } else {
        grantedValueBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Granted quota value.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value granted_value = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGrantedValue(com.google.protobuf.Int64Value.Builder builderForValue) {
      if (grantedValueBuilder_ == null) {
        grantedValue_ = builderForValue.build();
      } else {
        grantedValueBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Granted quota value.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value granted_value = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeGrantedValue(com.google.protobuf.Int64Value value) {
      if (grantedValueBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && grantedValue_ != null
            && grantedValue_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
          getGrantedValueBuilder().mergeFrom(value);
        } else {
          grantedValue_ = value;
        }
      } else {
        grantedValueBuilder_.mergeFrom(value);
      }
      if (grantedValue_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Granted quota value.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value granted_value = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearGrantedValue() {
      bitField0_ = (bitField0_ & ~0x00000004);
      grantedValue_ = null;
      if (grantedValueBuilder_ != null) {
        grantedValueBuilder_.dispose();
        grantedValueBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Granted quota value.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value granted_value = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Int64Value.Builder getGrantedValueBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getGrantedValueFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Granted quota value.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value granted_value = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getGrantedValueOrBuilder() {
      if (grantedValueBuilder_ != null) {
        return grantedValueBuilder_.getMessageOrBuilder();
      } else {
        return grantedValue_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : grantedValue_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Granted quota value.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value granted_value = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getGrantedValueFieldBuilder() {
      if (grantedValueBuilder_ == null) {
        grantedValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getGrantedValue(), getParentForChildren(), isClean());
        grantedValue_ = null;
      }
      return grantedValueBuilder_;
    }

    private java.lang.Object traceId_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The trace id that the Google Cloud uses to provision the
     * requested quota. This trace id may be used by the client to contact Cloud
     * support to track the state of a quota preference request. The trace id is
     * only produced for increase requests and is unique for each request. The
     * quota decrease requests do not have a trace id.
     * </pre>
     *
     * <code>string trace_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The traceId.
     */
    public java.lang.String getTraceId() {
      java.lang.Object ref = traceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        traceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The trace id that the Google Cloud uses to provision the
     * requested quota. This trace id may be used by the client to contact Cloud
     * support to track the state of a quota preference request. The trace id is
     * only produced for increase requests and is unique for each request. The
     * quota decrease requests do not have a trace id.
     * </pre>
     *
     * <code>string trace_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for traceId.
     */
    public com.google.protobuf.ByteString getTraceIdBytes() {
      java.lang.Object ref = traceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        traceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The trace id that the Google Cloud uses to provision the
     * requested quota. This trace id may be used by the client to contact Cloud
     * support to track the state of a quota preference request. The trace id is
     * only produced for increase requests and is unique for each request. The
     * quota decrease requests do not have a trace id.
     * </pre>
     *
     * <code>string trace_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The traceId to set.
     * @return This builder for chaining.
     */
    public Builder setTraceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      traceId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The trace id that the Google Cloud uses to provision the
     * requested quota. This trace id may be used by the client to contact Cloud
     * support to track the state of a quota preference request. The trace id is
     * only produced for increase requests and is unique for each request. The
     * quota decrease requests do not have a trace id.
     * </pre>
     *
     * <code>string trace_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTraceId() {
      traceId_ = getDefaultInstance().getTraceId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The trace id that the Google Cloud uses to provision the
     * requested quota. This trace id may be used by the client to contact Cloud
     * support to track the state of a quota preference request. The trace id is
     * only produced for increase requests and is unique for each request. The
     * quota decrease requests do not have a trace id.
     * </pre>
     *
     * <code>string trace_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for traceId to set.
     * @return This builder for chaining.
     */
    public Builder setTraceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      traceId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. The annotations map for clients to store small amounts of
     * arbitrary data. Do not put PII or other sensitive information here. See
     * https://google.aip.dev/128#annotations
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }

    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The annotations map for clients to store small amounts of
     * arbitrary data. Do not put PII or other sensitive information here. See
     * https://google.aip.dev/128#annotations
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The annotations map for clients to store small amounts of
     * arbitrary data. Do not put PII or other sensitive information here. See
     * https://google.aip.dev/128#annotations
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. The annotations map for clients to store small amounts of
     * arbitrary data. Do not put PII or other sensitive information here. See
     * https://google.aip.dev/128#annotations
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The annotations map for clients to store small amounts of
     * arbitrary data. Do not put PII or other sensitive information here. See
     * https://google.aip.dev/128#annotations
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000010;
      return internalGetMutableAnnotations().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The annotations map for clients to store small amounts of
     * arbitrary data. Do not put PII or other sensitive information here. See
     * https://google.aip.dev/128#annotations
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The annotations map for clients to store small amounts of
     * arbitrary data. Do not put PII or other sensitive information here. See
     * https://google.aip.dev/128#annotations
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private int requestOrigin_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. The origin of the quota preference request.
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1beta.QuotaConfig.Origin request_origin = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for requestOrigin.
     */
    @java.lang.Override
    public int getRequestOriginValue() {
      return requestOrigin_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The origin of the quota preference request.
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1beta.QuotaConfig.Origin request_origin = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for requestOrigin to set.
     * @return This builder for chaining.
     */
    public Builder setRequestOriginValue(int value) {
      requestOrigin_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The origin of the quota preference request.
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1beta.QuotaConfig.Origin request_origin = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The requestOrigin.
     */
    @java.lang.Override
    public com.google.api.cloudquotas.v1beta.QuotaConfig.Origin getRequestOrigin() {
      com.google.api.cloudquotas.v1beta.QuotaConfig.Origin result =
          com.google.api.cloudquotas.v1beta.QuotaConfig.Origin.forNumber(requestOrigin_);
      return result == null
          ? com.google.api.cloudquotas.v1beta.QuotaConfig.Origin.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. The origin of the quota preference request.
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1beta.QuotaConfig.Origin request_origin = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The requestOrigin to set.
     * @return This builder for chaining.
     */
    public Builder setRequestOrigin(com.google.api.cloudquotas.v1beta.QuotaConfig.Origin value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      requestOrigin_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The origin of the quota preference request.
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1beta.QuotaConfig.Origin request_origin = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestOrigin() {
      bitField0_ = (bitField0_ & ~0x00000020);
      requestOrigin_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.cloudquotas.v1beta.QuotaConfig)
  }

  // @@protoc_insertion_point(class_scope:google.api.cloudquotas.v1beta.QuotaConfig)
  private static final com.google.api.cloudquotas.v1beta.QuotaConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.cloudquotas.v1beta.QuotaConfig();
  }

  public static com.google.api.cloudquotas.v1beta.QuotaConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QuotaConfig> PARSER =
      new com.google.protobuf.AbstractParser<QuotaConfig>() {
        @java.lang.Override
        public QuotaConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QuotaConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QuotaConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.cloudquotas.v1beta.QuotaConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
