/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/cloudquotas/v1beta/cloudquotas.proto

// Protobuf Java Version: 3.25.8
package com.google.api.cloudquotas.v1beta;

/**
 *
 *
 * <pre>
 * Message for creating a QuotaPreference
 * </pre>
 *
 * Protobuf type {@code google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest}
 */
public final class CreateQuotaPreferenceRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest)
    CreateQuotaPreferenceRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CreateQuotaPreferenceRequest.newBuilder() to construct.
  private CreateQuotaPreferenceRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateQuotaPreferenceRequest() {
    parent_ = "";
    quotaPreferenceId_ = "";
    ignoreSafetyChecks_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateQuotaPreferenceRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.cloudquotas.v1beta.CloudquotasProto
        .internal_static_google_api_cloudquotas_v1beta_CreateQuotaPreferenceRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.cloudquotas.v1beta.CloudquotasProto
        .internal_static_google_api_cloudquotas_v1beta_CreateQuotaPreferenceRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest.class,
            com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. Value for parent.
   *
   * Example:
   * `projects/123/locations/global`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Value for parent.
   *
   * Example:
   * `projects/123/locations/global`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUOTA_PREFERENCE_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object quotaPreferenceId_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Id of the requesting object, must be unique under its parent.
   * If client does not set this field, the service will generate one.
   * </pre>
   *
   * <code>string quota_preference_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The quotaPreferenceId.
   */
  @java.lang.Override
  public java.lang.String getQuotaPreferenceId() {
    java.lang.Object ref = quotaPreferenceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      quotaPreferenceId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Id of the requesting object, must be unique under its parent.
   * If client does not set this field, the service will generate one.
   * </pre>
   *
   * <code>string quota_preference_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for quotaPreferenceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQuotaPreferenceIdBytes() {
    java.lang.Object ref = quotaPreferenceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      quotaPreferenceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUOTA_PREFERENCE_FIELD_NUMBER = 3;
  private com.google.api.cloudquotas.v1beta.QuotaPreference quotaPreference_;

  /**
   *
   *
   * <pre>
   * Required. The resource being created
   * </pre>
   *
   * <code>
   * .google.api.cloudquotas.v1beta.QuotaPreference quota_preference = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the quotaPreference field is set.
   */
  @java.lang.Override
  public boolean hasQuotaPreference() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. The resource being created
   * </pre>
   *
   * <code>
   * .google.api.cloudquotas.v1beta.QuotaPreference quota_preference = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The quotaPreference.
   */
  @java.lang.Override
  public com.google.api.cloudquotas.v1beta.QuotaPreference getQuotaPreference() {
    return quotaPreference_ == null
        ? com.google.api.cloudquotas.v1beta.QuotaPreference.getDefaultInstance()
        : quotaPreference_;
  }

  /**
   *
   *
   * <pre>
   * Required. The resource being created
   * </pre>
   *
   * <code>
   * .google.api.cloudquotas.v1beta.QuotaPreference quota_preference = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.api.cloudquotas.v1beta.QuotaPreferenceOrBuilder getQuotaPreferenceOrBuilder() {
    return quotaPreference_ == null
        ? com.google.api.cloudquotas.v1beta.QuotaPreference.getDefaultInstance()
        : quotaPreference_;
  }

  public static final int IGNORE_SAFETY_CHECKS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> ignoreSafetyChecks_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.api.cloudquotas.v1beta.QuotaSafetyCheck>
      ignoreSafetyChecks_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.api.cloudquotas.v1beta.QuotaSafetyCheck>() {
            public com.google.api.cloudquotas.v1beta.QuotaSafetyCheck convert(
                java.lang.Integer from) {
              com.google.api.cloudquotas.v1beta.QuotaSafetyCheck result =
                  com.google.api.cloudquotas.v1beta.QuotaSafetyCheck.forNumber(from);
              return result == null
                  ? com.google.api.cloudquotas.v1beta.QuotaSafetyCheck.UNRECOGNIZED
                  : result;
            }
          };

  /**
   *
   *
   * <pre>
   * The list of quota safety checks to be ignored.
   * </pre>
   *
   * <code>repeated .google.api.cloudquotas.v1beta.QuotaSafetyCheck ignore_safety_checks = 4;</code>
   *
   * @return A list containing the ignoreSafetyChecks.
   */
  @java.lang.Override
  public java.util.List<com.google.api.cloudquotas.v1beta.QuotaSafetyCheck>
      getIgnoreSafetyChecksList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.api.cloudquotas.v1beta.QuotaSafetyCheck>(
        ignoreSafetyChecks_, ignoreSafetyChecks_converter_);
  }

  /**
   *
   *
   * <pre>
   * The list of quota safety checks to be ignored.
   * </pre>
   *
   * <code>repeated .google.api.cloudquotas.v1beta.QuotaSafetyCheck ignore_safety_checks = 4;</code>
   *
   * @return The count of ignoreSafetyChecks.
   */
  @java.lang.Override
  public int getIgnoreSafetyChecksCount() {
    return ignoreSafetyChecks_.size();
  }

  /**
   *
   *
   * <pre>
   * The list of quota safety checks to be ignored.
   * </pre>
   *
   * <code>repeated .google.api.cloudquotas.v1beta.QuotaSafetyCheck ignore_safety_checks = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The ignoreSafetyChecks at the given index.
   */
  @java.lang.Override
  public com.google.api.cloudquotas.v1beta.QuotaSafetyCheck getIgnoreSafetyChecks(int index) {
    return ignoreSafetyChecks_converter_.convert(ignoreSafetyChecks_.get(index));
  }

  /**
   *
   *
   * <pre>
   * The list of quota safety checks to be ignored.
   * </pre>
   *
   * <code>repeated .google.api.cloudquotas.v1beta.QuotaSafetyCheck ignore_safety_checks = 4;</code>
   *
   * @return A list containing the enum numeric values on the wire for ignoreSafetyChecks.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getIgnoreSafetyChecksValueList() {
    return ignoreSafetyChecks_;
  }

  /**
   *
   *
   * <pre>
   * The list of quota safety checks to be ignored.
   * </pre>
   *
   * <code>repeated .google.api.cloudquotas.v1beta.QuotaSafetyCheck ignore_safety_checks = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of ignoreSafetyChecks at the given index.
   */
  @java.lang.Override
  public int getIgnoreSafetyChecksValue(int index) {
    return ignoreSafetyChecks_.get(index);
  }

  private int ignoreSafetyChecksMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(quotaPreferenceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, quotaPreferenceId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getQuotaPreference());
    }
    if (getIgnoreSafetyChecksList().size() > 0) {
      output.writeUInt32NoTag(34);
      output.writeUInt32NoTag(ignoreSafetyChecksMemoizedSerializedSize);
    }
    for (int i = 0; i < ignoreSafetyChecks_.size(); i++) {
      output.writeEnumNoTag(ignoreSafetyChecks_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(quotaPreferenceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, quotaPreferenceId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getQuotaPreference());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < ignoreSafetyChecks_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(ignoreSafetyChecks_.get(i));
      }
      size += dataSize;
      if (!getIgnoreSafetyChecksList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      ignoreSafetyChecksMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest)) {
      return super.equals(obj);
    }
    com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest other =
        (com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getQuotaPreferenceId().equals(other.getQuotaPreferenceId())) return false;
    if (hasQuotaPreference() != other.hasQuotaPreference()) return false;
    if (hasQuotaPreference()) {
      if (!getQuotaPreference().equals(other.getQuotaPreference())) return false;
    }
    if (!ignoreSafetyChecks_.equals(other.ignoreSafetyChecks_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + QUOTA_PREFERENCE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getQuotaPreferenceId().hashCode();
    if (hasQuotaPreference()) {
      hash = (37 * hash) + QUOTA_PREFERENCE_FIELD_NUMBER;
      hash = (53 * hash) + getQuotaPreference().hashCode();
    }
    if (getIgnoreSafetyChecksCount() > 0) {
      hash = (37 * hash) + IGNORE_SAFETY_CHECKS_FIELD_NUMBER;
      hash = (53 * hash) + ignoreSafetyChecks_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Message for creating a QuotaPreference
   * </pre>
   *
   * Protobuf type {@code google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest)
      com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.cloudquotas.v1beta.CloudquotasProto
          .internal_static_google_api_cloudquotas_v1beta_CreateQuotaPreferenceRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.cloudquotas.v1beta.CloudquotasProto
          .internal_static_google_api_cloudquotas_v1beta_CreateQuotaPreferenceRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest.class,
              com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest.Builder.class);
    }

    // Construct using com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getQuotaPreferenceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      quotaPreferenceId_ = "";
      quotaPreference_ = null;
      if (quotaPreferenceBuilder_ != null) {
        quotaPreferenceBuilder_.dispose();
        quotaPreferenceBuilder_ = null;
      }
      ignoreSafetyChecks_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.cloudquotas.v1beta.CloudquotasProto
          .internal_static_google_api_cloudquotas_v1beta_CreateQuotaPreferenceRequest_descriptor;
    }

    @java.lang.Override
    public com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest
        getDefaultInstanceForType() {
      return com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest build() {
      com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest buildPartial() {
      com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest result =
          new com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest result) {
      if (((bitField0_ & 0x00000008) != 0)) {
        ignoreSafetyChecks_ = java.util.Collections.unmodifiableList(ignoreSafetyChecks_);
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.ignoreSafetyChecks_ = ignoreSafetyChecks_;
    }

    private void buildPartial0(
        com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.quotaPreferenceId_ = quotaPreferenceId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.quotaPreference_ =
            quotaPreferenceBuilder_ == null ? quotaPreference_ : quotaPreferenceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest) {
        return mergeFrom((com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest other) {
      if (other
          == com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getQuotaPreferenceId().isEmpty()) {
        quotaPreferenceId_ = other.quotaPreferenceId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasQuotaPreference()) {
        mergeQuotaPreference(other.getQuotaPreference());
      }
      if (!other.ignoreSafetyChecks_.isEmpty()) {
        if (ignoreSafetyChecks_.isEmpty()) {
          ignoreSafetyChecks_ = other.ignoreSafetyChecks_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureIgnoreSafetyChecksIsMutable();
          ignoreSafetyChecks_.addAll(other.ignoreSafetyChecks_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                quotaPreferenceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getQuotaPreferenceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                int tmpRaw = input.readEnum();
                ensureIgnoreSafetyChecksIsMutable();
                ignoreSafetyChecks_.add(tmpRaw);
                break;
              } // case 32
            case 34:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureIgnoreSafetyChecksIsMutable();
                  ignoreSafetyChecks_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. Value for parent.
     *
     * Example:
     * `projects/123/locations/global`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Value for parent.
     *
     * Example:
     * `projects/123/locations/global`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Value for parent.
     *
     * Example:
     * `projects/123/locations/global`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Value for parent.
     *
     * Example:
     * `projects/123/locations/global`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Value for parent.
     *
     * Example:
     * `projects/123/locations/global`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object quotaPreferenceId_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Id of the requesting object, must be unique under its parent.
     * If client does not set this field, the service will generate one.
     * </pre>
     *
     * <code>string quota_preference_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The quotaPreferenceId.
     */
    public java.lang.String getQuotaPreferenceId() {
      java.lang.Object ref = quotaPreferenceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        quotaPreferenceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Id of the requesting object, must be unique under its parent.
     * If client does not set this field, the service will generate one.
     * </pre>
     *
     * <code>string quota_preference_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for quotaPreferenceId.
     */
    public com.google.protobuf.ByteString getQuotaPreferenceIdBytes() {
      java.lang.Object ref = quotaPreferenceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        quotaPreferenceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Id of the requesting object, must be unique under its parent.
     * If client does not set this field, the service will generate one.
     * </pre>
     *
     * <code>string quota_preference_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The quotaPreferenceId to set.
     * @return This builder for chaining.
     */
    public Builder setQuotaPreferenceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      quotaPreferenceId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Id of the requesting object, must be unique under its parent.
     * If client does not set this field, the service will generate one.
     * </pre>
     *
     * <code>string quota_preference_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuotaPreferenceId() {
      quotaPreferenceId_ = getDefaultInstance().getQuotaPreferenceId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Id of the requesting object, must be unique under its parent.
     * If client does not set this field, the service will generate one.
     * </pre>
     *
     * <code>string quota_preference_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for quotaPreferenceId to set.
     * @return This builder for chaining.
     */
    public Builder setQuotaPreferenceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      quotaPreferenceId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.api.cloudquotas.v1beta.QuotaPreference quotaPreference_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.cloudquotas.v1beta.QuotaPreference,
            com.google.api.cloudquotas.v1beta.QuotaPreference.Builder,
            com.google.api.cloudquotas.v1beta.QuotaPreferenceOrBuilder>
        quotaPreferenceBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The resource being created
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1beta.QuotaPreference quota_preference = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the quotaPreference field is set.
     */
    public boolean hasQuotaPreference() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. The resource being created
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1beta.QuotaPreference quota_preference = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The quotaPreference.
     */
    public com.google.api.cloudquotas.v1beta.QuotaPreference getQuotaPreference() {
      if (quotaPreferenceBuilder_ == null) {
        return quotaPreference_ == null
            ? com.google.api.cloudquotas.v1beta.QuotaPreference.getDefaultInstance()
            : quotaPreference_;
      } else {
        return quotaPreferenceBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource being created
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1beta.QuotaPreference quota_preference = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setQuotaPreference(com.google.api.cloudquotas.v1beta.QuotaPreference value) {
      if (quotaPreferenceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        quotaPreference_ = value;
      } else {
        quotaPreferenceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource being created
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1beta.QuotaPreference quota_preference = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setQuotaPreference(
        com.google.api.cloudquotas.v1beta.QuotaPreference.Builder builderForValue) {
      if (quotaPreferenceBuilder_ == null) {
        quotaPreference_ = builderForValue.build();
      } else {
        quotaPreferenceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource being created
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1beta.QuotaPreference quota_preference = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeQuotaPreference(com.google.api.cloudquotas.v1beta.QuotaPreference value) {
      if (quotaPreferenceBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && quotaPreference_ != null
            && quotaPreference_
                != com.google.api.cloudquotas.v1beta.QuotaPreference.getDefaultInstance()) {
          getQuotaPreferenceBuilder().mergeFrom(value);
        } else {
          quotaPreference_ = value;
        }
      } else {
        quotaPreferenceBuilder_.mergeFrom(value);
      }
      if (quotaPreference_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource being created
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1beta.QuotaPreference quota_preference = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearQuotaPreference() {
      bitField0_ = (bitField0_ & ~0x00000004);
      quotaPreference_ = null;
      if (quotaPreferenceBuilder_ != null) {
        quotaPreferenceBuilder_.dispose();
        quotaPreferenceBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource being created
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1beta.QuotaPreference quota_preference = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.api.cloudquotas.v1beta.QuotaPreference.Builder getQuotaPreferenceBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getQuotaPreferenceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. The resource being created
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1beta.QuotaPreference quota_preference = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.api.cloudquotas.v1beta.QuotaPreferenceOrBuilder
        getQuotaPreferenceOrBuilder() {
      if (quotaPreferenceBuilder_ != null) {
        return quotaPreferenceBuilder_.getMessageOrBuilder();
      } else {
        return quotaPreference_ == null
            ? com.google.api.cloudquotas.v1beta.QuotaPreference.getDefaultInstance()
            : quotaPreference_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource being created
     * </pre>
     *
     * <code>
     * .google.api.cloudquotas.v1beta.QuotaPreference quota_preference = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.cloudquotas.v1beta.QuotaPreference,
            com.google.api.cloudquotas.v1beta.QuotaPreference.Builder,
            com.google.api.cloudquotas.v1beta.QuotaPreferenceOrBuilder>
        getQuotaPreferenceFieldBuilder() {
      if (quotaPreferenceBuilder_ == null) {
        quotaPreferenceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.cloudquotas.v1beta.QuotaPreference,
                com.google.api.cloudquotas.v1beta.QuotaPreference.Builder,
                com.google.api.cloudquotas.v1beta.QuotaPreferenceOrBuilder>(
                getQuotaPreference(), getParentForChildren(), isClean());
        quotaPreference_ = null;
      }
      return quotaPreferenceBuilder_;
    }

    private java.util.List<java.lang.Integer> ignoreSafetyChecks_ =
        java.util.Collections.emptyList();

    private void ensureIgnoreSafetyChecksIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        ignoreSafetyChecks_ = new java.util.ArrayList<java.lang.Integer>(ignoreSafetyChecks_);
        bitField0_ |= 0x00000008;
      }
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to be ignored.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1beta.QuotaSafetyCheck ignore_safety_checks = 4;
     * </code>
     *
     * @return A list containing the ignoreSafetyChecks.
     */
    public java.util.List<com.google.api.cloudquotas.v1beta.QuotaSafetyCheck>
        getIgnoreSafetyChecksList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.api.cloudquotas.v1beta.QuotaSafetyCheck>(
          ignoreSafetyChecks_, ignoreSafetyChecks_converter_);
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to be ignored.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1beta.QuotaSafetyCheck ignore_safety_checks = 4;
     * </code>
     *
     * @return The count of ignoreSafetyChecks.
     */
    public int getIgnoreSafetyChecksCount() {
      return ignoreSafetyChecks_.size();
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to be ignored.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1beta.QuotaSafetyCheck ignore_safety_checks = 4;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The ignoreSafetyChecks at the given index.
     */
    public com.google.api.cloudquotas.v1beta.QuotaSafetyCheck getIgnoreSafetyChecks(int index) {
      return ignoreSafetyChecks_converter_.convert(ignoreSafetyChecks_.get(index));
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to be ignored.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1beta.QuotaSafetyCheck ignore_safety_checks = 4;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The ignoreSafetyChecks to set.
     * @return This builder for chaining.
     */
    public Builder setIgnoreSafetyChecks(
        int index, com.google.api.cloudquotas.v1beta.QuotaSafetyCheck value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIgnoreSafetyChecksIsMutable();
      ignoreSafetyChecks_.set(index, value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to be ignored.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1beta.QuotaSafetyCheck ignore_safety_checks = 4;
     * </code>
     *
     * @param value The ignoreSafetyChecks to add.
     * @return This builder for chaining.
     */
    public Builder addIgnoreSafetyChecks(com.google.api.cloudquotas.v1beta.QuotaSafetyCheck value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIgnoreSafetyChecksIsMutable();
      ignoreSafetyChecks_.add(value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to be ignored.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1beta.QuotaSafetyCheck ignore_safety_checks = 4;
     * </code>
     *
     * @param values The ignoreSafetyChecks to add.
     * @return This builder for chaining.
     */
    public Builder addAllIgnoreSafetyChecks(
        java.lang.Iterable<? extends com.google.api.cloudquotas.v1beta.QuotaSafetyCheck> values) {
      ensureIgnoreSafetyChecksIsMutable();
      for (com.google.api.cloudquotas.v1beta.QuotaSafetyCheck value : values) {
        ignoreSafetyChecks_.add(value.getNumber());
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to be ignored.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1beta.QuotaSafetyCheck ignore_safety_checks = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIgnoreSafetyChecks() {
      ignoreSafetyChecks_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to be ignored.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1beta.QuotaSafetyCheck ignore_safety_checks = 4;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for ignoreSafetyChecks.
     */
    public java.util.List<java.lang.Integer> getIgnoreSafetyChecksValueList() {
      return java.util.Collections.unmodifiableList(ignoreSafetyChecks_);
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to be ignored.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1beta.QuotaSafetyCheck ignore_safety_checks = 4;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of ignoreSafetyChecks at the given index.
     */
    public int getIgnoreSafetyChecksValue(int index) {
      return ignoreSafetyChecks_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to be ignored.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1beta.QuotaSafetyCheck ignore_safety_checks = 4;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for ignoreSafetyChecks to set.
     * @return This builder for chaining.
     */
    public Builder setIgnoreSafetyChecksValue(int index, int value) {
      ensureIgnoreSafetyChecksIsMutable();
      ignoreSafetyChecks_.set(index, value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to be ignored.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1beta.QuotaSafetyCheck ignore_safety_checks = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for ignoreSafetyChecks to add.
     * @return This builder for chaining.
     */
    public Builder addIgnoreSafetyChecksValue(int value) {
      ensureIgnoreSafetyChecksIsMutable();
      ignoreSafetyChecks_.add(value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of quota safety checks to be ignored.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1beta.QuotaSafetyCheck ignore_safety_checks = 4;
     * </code>
     *
     * @param values The enum numeric values on the wire for ignoreSafetyChecks to add.
     * @return This builder for chaining.
     */
    public Builder addAllIgnoreSafetyChecksValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureIgnoreSafetyChecksIsMutable();
      for (int value : values) {
        ignoreSafetyChecks_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest)
  }

  // @@protoc_insertion_point(class_scope:google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest)
  private static final com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest();
  }

  public static com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateQuotaPreferenceRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateQuotaPreferenceRequest>() {
        @java.lang.Override
        public CreateQuotaPreferenceRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateQuotaPreferenceRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateQuotaPreferenceRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.cloudquotas.v1beta.CreateQuotaPreferenceRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
