/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1beta/metastore_partition.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.bigquery.storage.v1beta;

public interface BatchDeleteMetastorePartitionsRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. Reference to the table to which these metastore partitions
   * belong, in the format of
   * projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();

  /**
   *
   *
   * <pre>
   * Required. Reference to the table to which these metastore partitions
   * belong, in the format of
   * projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Required. The list of metastore partitions (identified by its values) to be
   * deleted. A maximum of 900 partitions can be deleted in a batch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues>
      getPartitionValuesList();

  /**
   *
   *
   * <pre>
   * Required. The list of metastore partitions (identified by its values) to be
   * deleted. A maximum of 900 partitions can be deleted in a batch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues getPartitionValues(int index);

  /**
   *
   *
   * <pre>
   * Required. The list of metastore partitions (identified by its values) to be
   * deleted. A maximum of 900 partitions can be deleted in a batch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  int getPartitionValuesCount();

  /**
   *
   *
   * <pre>
   * Required. The list of metastore partitions (identified by its values) to be
   * deleted. A maximum of 900 partitions can be deleted in a batch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<
          ? extends com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValuesOrBuilder>
      getPartitionValuesOrBuilderList();

  /**
   *
   *
   * <pre>
   * Required. The list of metastore partitions (identified by its values) to be
   * deleted. A maximum of 900 partitions can be deleted in a batch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValuesOrBuilder
      getPartitionValuesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Optional. Optional trace id to be used for debugging. It is expected that
   * the client sets the same `trace_id` for all the batches in the same
   * operation, so that it is possible to tie together the logs to all the
   * batches in the same operation. This is expected, but not required, to be
   * globally unique.
   * </pre>
   *
   * <code>string trace_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The traceId.
   */
  java.lang.String getTraceId();

  /**
   *
   *
   * <pre>
   * Optional. Optional trace id to be used for debugging. It is expected that
   * the client sets the same `trace_id` for all the batches in the same
   * operation, so that it is possible to tie together the logs to all the
   * batches in the same operation. This is expected, but not required, to be
   * globally unique.
   * </pre>
   *
   * <code>string trace_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for traceId.
   */
  com.google.protobuf.ByteString getTraceIdBytes();
}
