/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1beta/metastore_partition.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.bigquery.storage.v1beta;

/**
 *
 *
 * <pre>
 * Request message for BatchDeleteMetastorePartitions. The MetastorePartition is
 * uniquely identified by values, which is an ordered list. Hence, there is no
 * separate name or partition id field.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest}
 */
public final class BatchDeleteMetastorePartitionsRequest
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest)
    BatchDeleteMetastorePartitionsRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use BatchDeleteMetastorePartitionsRequest.newBuilder() to construct.
  private BatchDeleteMetastorePartitionsRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchDeleteMetastorePartitionsRequest() {
    parent_ = "";
    partitionValues_ = java.util.Collections.emptyList();
    traceId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchDeleteMetastorePartitionsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.storage.v1beta.MetastorePartitionServiceProto
        .internal_static_google_cloud_bigquery_storage_v1beta_BatchDeleteMetastorePartitionsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.storage.v1beta.MetastorePartitionServiceProto
        .internal_static_google_cloud_bigquery_storage_v1beta_BatchDeleteMetastorePartitionsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest.class,
            com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest.Builder
                .class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. Reference to the table to which these metastore partitions
   * belong, in the format of
   * projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Reference to the table to which these metastore partitions
   * belong, in the format of
   * projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARTITION_VALUES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues>
      partitionValues_;

  /**
   *
   *
   * <pre>
   * Required. The list of metastore partitions (identified by its values) to be
   * deleted. A maximum of 900 partitions can be deleted in a batch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues>
      getPartitionValuesList() {
    return partitionValues_;
  }

  /**
   *
   *
   * <pre>
   * Required. The list of metastore partitions (identified by its values) to be
   * deleted. A maximum of 900 partitions can be deleted in a batch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValuesOrBuilder>
      getPartitionValuesOrBuilderList() {
    return partitionValues_;
  }

  /**
   *
   *
   * <pre>
   * Required. The list of metastore partitions (identified by its values) to be
   * deleted. A maximum of 900 partitions can be deleted in a batch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getPartitionValuesCount() {
    return partitionValues_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. The list of metastore partitions (identified by its values) to be
   * deleted. A maximum of 900 partitions can be deleted in a batch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues getPartitionValues(
      int index) {
    return partitionValues_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. The list of metastore partitions (identified by its values) to be
   * deleted. A maximum of 900 partitions can be deleted in a batch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValuesOrBuilder
      getPartitionValuesOrBuilder(int index) {
    return partitionValues_.get(index);
  }

  public static final int TRACE_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object traceId_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Optional trace id to be used for debugging. It is expected that
   * the client sets the same `trace_id` for all the batches in the same
   * operation, so that it is possible to tie together the logs to all the
   * batches in the same operation. This is expected, but not required, to be
   * globally unique.
   * </pre>
   *
   * <code>string trace_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The traceId.
   */
  @java.lang.Override
  public java.lang.String getTraceId() {
    java.lang.Object ref = traceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      traceId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Optional trace id to be used for debugging. It is expected that
   * the client sets the same `trace_id` for all the batches in the same
   * operation, so that it is possible to tie together the logs to all the
   * batches in the same operation. This is expected, but not required, to be
   * globally unique.
   * </pre>
   *
   * <code>string trace_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for traceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTraceIdBytes() {
    java.lang.Object ref = traceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      traceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    for (int i = 0; i < partitionValues_.size(); i++) {
      output.writeMessage(2, partitionValues_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(traceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, traceId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    for (int i = 0; i < partitionValues_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, partitionValues_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(traceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, traceId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest other =
        (com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getPartitionValuesList().equals(other.getPartitionValuesList())) return false;
    if (!getTraceId().equals(other.getTraceId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (getPartitionValuesCount() > 0) {
      hash = (37 * hash) + PARTITION_VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getPartitionValuesList().hashCode();
    }
    hash = (37 * hash) + TRACE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTraceId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for BatchDeleteMetastorePartitions. The MetastorePartition is
   * uniquely identified by values, which is an ordered list. Hence, there is no
   * separate name or partition id field.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest)
      com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta.MetastorePartitionServiceProto
          .internal_static_google_cloud_bigquery_storage_v1beta_BatchDeleteMetastorePartitionsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta.MetastorePartitionServiceProto
          .internal_static_google_cloud_bigquery_storage_v1beta_BatchDeleteMetastorePartitionsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest.class,
              com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      if (partitionValuesBuilder_ == null) {
        partitionValues_ = java.util.Collections.emptyList();
      } else {
        partitionValues_ = null;
        partitionValuesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      traceId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.storage.v1beta.MetastorePartitionServiceProto
          .internal_static_google_cloud_bigquery_storage_v1beta_BatchDeleteMetastorePartitionsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest build() {
      com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest
        buildPartial() {
      com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest result =
          new com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest result) {
      if (partitionValuesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          partitionValues_ = java.util.Collections.unmodifiableList(partitionValues_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.partitionValues_ = partitionValues_;
      } else {
        result.partitionValues_ = partitionValuesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.traceId_ = traceId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest) {
        return mergeFrom(
            (com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest other) {
      if (other
          == com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest
              .getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (partitionValuesBuilder_ == null) {
        if (!other.partitionValues_.isEmpty()) {
          if (partitionValues_.isEmpty()) {
            partitionValues_ = other.partitionValues_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePartitionValuesIsMutable();
            partitionValues_.addAll(other.partitionValues_);
          }
          onChanged();
        }
      } else {
        if (!other.partitionValues_.isEmpty()) {
          if (partitionValuesBuilder_.isEmpty()) {
            partitionValuesBuilder_.dispose();
            partitionValuesBuilder_ = null;
            partitionValues_ = other.partitionValues_;
            bitField0_ = (bitField0_ & ~0x00000002);
            partitionValuesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPartitionValuesFieldBuilder()
                    : null;
          } else {
            partitionValuesBuilder_.addAllMessages(other.partitionValues_);
          }
        }
      }
      if (!other.getTraceId().isEmpty()) {
        traceId_ = other.traceId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues m =
                    input.readMessage(
                        com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues.parser(),
                        extensionRegistry);
                if (partitionValuesBuilder_ == null) {
                  ensurePartitionValuesIsMutable();
                  partitionValues_.add(m);
                } else {
                  partitionValuesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 34:
              {
                traceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. Reference to the table to which these metastore partitions
     * belong, in the format of
     * projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Reference to the table to which these metastore partitions
     * belong, in the format of
     * projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Reference to the table to which these metastore partitions
     * belong, in the format of
     * projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Reference to the table to which these metastore partitions
     * belong, in the format of
     * projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Reference to the table to which these metastore partitions
     * belong, in the format of
     * projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues>
        partitionValues_ = java.util.Collections.emptyList();

    private void ensurePartitionValuesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        partitionValues_ =
            new java.util.ArrayList<
                com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues>(
                partitionValues_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues,
            com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues.Builder,
            com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValuesOrBuilder>
        partitionValuesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The list of metastore partitions (identified by its values) to be
     * deleted. A maximum of 900 partitions can be deleted in a batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues>
        getPartitionValuesList() {
      if (partitionValuesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(partitionValues_);
      } else {
        return partitionValuesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The list of metastore partitions (identified by its values) to be
     * deleted. A maximum of 900 partitions can be deleted in a batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getPartitionValuesCount() {
      if (partitionValuesBuilder_ == null) {
        return partitionValues_.size();
      } else {
        return partitionValuesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The list of metastore partitions (identified by its values) to be
     * deleted. A maximum of 900 partitions can be deleted in a batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues getPartitionValues(
        int index) {
      if (partitionValuesBuilder_ == null) {
        return partitionValues_.get(index);
      } else {
        return partitionValuesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The list of metastore partitions (identified by its values) to be
     * deleted. A maximum of 900 partitions can be deleted in a batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPartitionValues(
        int index, com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues value) {
      if (partitionValuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartitionValuesIsMutable();
        partitionValues_.set(index, value);
        onChanged();
      } else {
        partitionValuesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of metastore partitions (identified by its values) to be
     * deleted. A maximum of 900 partitions can be deleted in a batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPartitionValues(
        int index,
        com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues.Builder builderForValue) {
      if (partitionValuesBuilder_ == null) {
        ensurePartitionValuesIsMutable();
        partitionValues_.set(index, builderForValue.build());
        onChanged();
      } else {
        partitionValuesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of metastore partitions (identified by its values) to be
     * deleted. A maximum of 900 partitions can be deleted in a batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addPartitionValues(
        com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues value) {
      if (partitionValuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartitionValuesIsMutable();
        partitionValues_.add(value);
        onChanged();
      } else {
        partitionValuesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of metastore partitions (identified by its values) to be
     * deleted. A maximum of 900 partitions can be deleted in a batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addPartitionValues(
        int index, com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues value) {
      if (partitionValuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartitionValuesIsMutable();
        partitionValues_.add(index, value);
        onChanged();
      } else {
        partitionValuesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of metastore partitions (identified by its values) to be
     * deleted. A maximum of 900 partitions can be deleted in a batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addPartitionValues(
        com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues.Builder builderForValue) {
      if (partitionValuesBuilder_ == null) {
        ensurePartitionValuesIsMutable();
        partitionValues_.add(builderForValue.build());
        onChanged();
      } else {
        partitionValuesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of metastore partitions (identified by its values) to be
     * deleted. A maximum of 900 partitions can be deleted in a batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addPartitionValues(
        int index,
        com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues.Builder builderForValue) {
      if (partitionValuesBuilder_ == null) {
        ensurePartitionValuesIsMutable();
        partitionValues_.add(index, builderForValue.build());
        onChanged();
      } else {
        partitionValuesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of metastore partitions (identified by its values) to be
     * deleted. A maximum of 900 partitions can be deleted in a batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllPartitionValues(
        java.lang.Iterable<
                ? extends com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues>
            values) {
      if (partitionValuesBuilder_ == null) {
        ensurePartitionValuesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, partitionValues_);
        onChanged();
      } else {
        partitionValuesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of metastore partitions (identified by its values) to be
     * deleted. A maximum of 900 partitions can be deleted in a batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearPartitionValues() {
      if (partitionValuesBuilder_ == null) {
        partitionValues_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        partitionValuesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of metastore partitions (identified by its values) to be
     * deleted. A maximum of 900 partitions can be deleted in a batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removePartitionValues(int index) {
      if (partitionValuesBuilder_ == null) {
        ensurePartitionValuesIsMutable();
        partitionValues_.remove(index);
        onChanged();
      } else {
        partitionValuesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The list of metastore partitions (identified by its values) to be
     * deleted. A maximum of 900 partitions can be deleted in a batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues.Builder
        getPartitionValuesBuilder(int index) {
      return getPartitionValuesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The list of metastore partitions (identified by its values) to be
     * deleted. A maximum of 900 partitions can be deleted in a batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValuesOrBuilder
        getPartitionValuesOrBuilder(int index) {
      if (partitionValuesBuilder_ == null) {
        return partitionValues_.get(index);
      } else {
        return partitionValuesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The list of metastore partitions (identified by its values) to be
     * deleted. A maximum of 900 partitions can be deleted in a batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValuesOrBuilder>
        getPartitionValuesOrBuilderList() {
      if (partitionValuesBuilder_ != null) {
        return partitionValuesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(partitionValues_);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The list of metastore partitions (identified by its values) to be
     * deleted. A maximum of 900 partitions can be deleted in a batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues.Builder
        addPartitionValuesBuilder() {
      return getPartitionValuesFieldBuilder()
          .addBuilder(
              com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The list of metastore partitions (identified by its values) to be
     * deleted. A maximum of 900 partitions can be deleted in a batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues.Builder
        addPartitionValuesBuilder(int index) {
      return getPartitionValuesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The list of metastore partitions (identified by its values) to be
     * deleted. A maximum of 900 partitions can be deleted in a batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1beta.MetastorePartitionValues partition_values = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues.Builder>
        getPartitionValuesBuilderList() {
      return getPartitionValuesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues,
            com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues.Builder,
            com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValuesOrBuilder>
        getPartitionValuesFieldBuilder() {
      if (partitionValuesBuilder_ == null) {
        partitionValuesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues,
                com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValues.Builder,
                com.google.cloud.bigquery.storage.v1beta.MetastorePartitionValuesOrBuilder>(
                partitionValues_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        partitionValues_ = null;
      }
      return partitionValuesBuilder_;
    }

    private java.lang.Object traceId_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Optional trace id to be used for debugging. It is expected that
     * the client sets the same `trace_id` for all the batches in the same
     * operation, so that it is possible to tie together the logs to all the
     * batches in the same operation. This is expected, but not required, to be
     * globally unique.
     * </pre>
     *
     * <code>string trace_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The traceId.
     */
    public java.lang.String getTraceId() {
      java.lang.Object ref = traceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        traceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional trace id to be used for debugging. It is expected that
     * the client sets the same `trace_id` for all the batches in the same
     * operation, so that it is possible to tie together the logs to all the
     * batches in the same operation. This is expected, but not required, to be
     * globally unique.
     * </pre>
     *
     * <code>string trace_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for traceId.
     */
    public com.google.protobuf.ByteString getTraceIdBytes() {
      java.lang.Object ref = traceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        traceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional trace id to be used for debugging. It is expected that
     * the client sets the same `trace_id` for all the batches in the same
     * operation, so that it is possible to tie together the logs to all the
     * batches in the same operation. This is expected, but not required, to be
     * globally unique.
     * </pre>
     *
     * <code>string trace_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The traceId to set.
     * @return This builder for chaining.
     */
    public Builder setTraceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      traceId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional trace id to be used for debugging. It is expected that
     * the client sets the same `trace_id` for all the batches in the same
     * operation, so that it is possible to tie together the logs to all the
     * batches in the same operation. This is expected, but not required, to be
     * globally unique.
     * </pre>
     *
     * <code>string trace_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTraceId() {
      traceId_ = getDefaultInstance().getTraceId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional trace id to be used for debugging. It is expected that
     * the client sets the same `trace_id` for all the batches in the same
     * operation, so that it is possible to tie together the logs to all the
     * batches in the same operation. This is expected, but not required, to be
     * globally unique.
     * </pre>
     *
     * <code>string trace_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for traceId to set.
     * @return This builder for chaining.
     */
    public Builder setTraceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      traceId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest)
  private static final com.google.cloud.bigquery.storage.v1beta
          .BatchDeleteMetastorePartitionsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest();
  }

  public static com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchDeleteMetastorePartitionsRequest> PARSER =
      new com.google.protobuf.AbstractParser<BatchDeleteMetastorePartitionsRequest>() {
        @java.lang.Override
        public BatchDeleteMetastorePartitionsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchDeleteMetastorePartitionsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchDeleteMetastorePartitionsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1beta.BatchDeleteMetastorePartitionsRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
