/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/analyticshub/v1/pubsub.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.bigquery.analyticshub.v1;

/**
 *
 *
 * <pre>
 * A policy that specifies how Pub/Sub retries message delivery.
 *
 * Retry delay will be exponential based on provided minimum and maximum
 * backoffs. https://en.wikipedia.org/wiki/Exponential_backoff.
 *
 * RetryPolicy will be triggered on NACKs or acknowledgement deadline exceeded
 * events for a given message.
 *
 * Retry Policy is implemented on a best effort basis. At times, the delay
 * between consecutive deliveries may not match the configuration. That is,
 * delay can be more or less than configured backoff.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.RetryPolicy}
 */
public final class RetryPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.analyticshub.v1.RetryPolicy)
    RetryPolicyOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RetryPolicy.newBuilder() to construct.
  private RetryPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RetryPolicy() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RetryPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.analyticshub.v1.PubsubProto
        .internal_static_google_cloud_bigquery_analyticshub_v1_RetryPolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.analyticshub.v1.PubsubProto
        .internal_static_google_cloud_bigquery_analyticshub_v1_RetryPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.analyticshub.v1.RetryPolicy.class,
            com.google.cloud.bigquery.analyticshub.v1.RetryPolicy.Builder.class);
  }

  private int bitField0_;
  public static final int MINIMUM_BACKOFF_FIELD_NUMBER = 1;
  private com.google.protobuf.Duration minimumBackoff_;

  /**
   *
   *
   * <pre>
   * Optional. The minimum delay between consecutive deliveries of a given
   * message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration minimum_backoff = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the minimumBackoff field is set.
   */
  @java.lang.Override
  public boolean hasMinimumBackoff() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The minimum delay between consecutive deliveries of a given
   * message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration minimum_backoff = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The minimumBackoff.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getMinimumBackoff() {
    return minimumBackoff_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : minimumBackoff_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The minimum delay between consecutive deliveries of a given
   * message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration minimum_backoff = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getMinimumBackoffOrBuilder() {
    return minimumBackoff_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : minimumBackoff_;
  }

  public static final int MAXIMUM_BACKOFF_FIELD_NUMBER = 2;
  private com.google.protobuf.Duration maximumBackoff_;

  /**
   *
   *
   * <pre>
   * Optional. The maximum delay between consecutive deliveries of a given
   * message. Value should be between 0 and 600 seconds. Defaults to 600
   * seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration maximum_backoff = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the maximumBackoff field is set.
   */
  @java.lang.Override
  public boolean hasMaximumBackoff() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The maximum delay between consecutive deliveries of a given
   * message. Value should be between 0 and 600 seconds. Defaults to 600
   * seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration maximum_backoff = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The maximumBackoff.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getMaximumBackoff() {
    return maximumBackoff_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : maximumBackoff_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The maximum delay between consecutive deliveries of a given
   * message. Value should be between 0 and 600 seconds. Defaults to 600
   * seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration maximum_backoff = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getMaximumBackoffOrBuilder() {
    return maximumBackoff_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : maximumBackoff_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getMinimumBackoff());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getMaximumBackoff());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMinimumBackoff());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMaximumBackoff());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.analyticshub.v1.RetryPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.analyticshub.v1.RetryPolicy other =
        (com.google.cloud.bigquery.analyticshub.v1.RetryPolicy) obj;

    if (hasMinimumBackoff() != other.hasMinimumBackoff()) return false;
    if (hasMinimumBackoff()) {
      if (!getMinimumBackoff().equals(other.getMinimumBackoff())) return false;
    }
    if (hasMaximumBackoff() != other.hasMaximumBackoff()) return false;
    if (hasMaximumBackoff()) {
      if (!getMaximumBackoff().equals(other.getMaximumBackoff())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasMinimumBackoff()) {
      hash = (37 * hash) + MINIMUM_BACKOFF_FIELD_NUMBER;
      hash = (53 * hash) + getMinimumBackoff().hashCode();
    }
    if (hasMaximumBackoff()) {
      hash = (37 * hash) + MAXIMUM_BACKOFF_FIELD_NUMBER;
      hash = (53 * hash) + getMaximumBackoff().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.analyticshub.v1.RetryPolicy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.RetryPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.RetryPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.RetryPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.RetryPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.RetryPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.RetryPolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.RetryPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.RetryPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.RetryPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.RetryPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.RetryPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.analyticshub.v1.RetryPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A policy that specifies how Pub/Sub retries message delivery.
   *
   * Retry delay will be exponential based on provided minimum and maximum
   * backoffs. https://en.wikipedia.org/wiki/Exponential_backoff.
   *
   * RetryPolicy will be triggered on NACKs or acknowledgement deadline exceeded
   * events for a given message.
   *
   * Retry Policy is implemented on a best effort basis. At times, the delay
   * between consecutive deliveries may not match the configuration. That is,
   * delay can be more or less than configured backoff.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.RetryPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.analyticshub.v1.RetryPolicy)
      com.google.cloud.bigquery.analyticshub.v1.RetryPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.analyticshub.v1.PubsubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_RetryPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.analyticshub.v1.PubsubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_RetryPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.analyticshub.v1.RetryPolicy.class,
              com.google.cloud.bigquery.analyticshub.v1.RetryPolicy.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.analyticshub.v1.RetryPolicy.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMinimumBackoffFieldBuilder();
        getMaximumBackoffFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      minimumBackoff_ = null;
      if (minimumBackoffBuilder_ != null) {
        minimumBackoffBuilder_.dispose();
        minimumBackoffBuilder_ = null;
      }
      maximumBackoff_ = null;
      if (maximumBackoffBuilder_ != null) {
        maximumBackoffBuilder_.dispose();
        maximumBackoffBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.analyticshub.v1.PubsubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_RetryPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.RetryPolicy getDefaultInstanceForType() {
      return com.google.cloud.bigquery.analyticshub.v1.RetryPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.RetryPolicy build() {
      com.google.cloud.bigquery.analyticshub.v1.RetryPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.RetryPolicy buildPartial() {
      com.google.cloud.bigquery.analyticshub.v1.RetryPolicy result =
          new com.google.cloud.bigquery.analyticshub.v1.RetryPolicy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.bigquery.analyticshub.v1.RetryPolicy result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.minimumBackoff_ =
            minimumBackoffBuilder_ == null ? minimumBackoff_ : minimumBackoffBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.maximumBackoff_ =
            maximumBackoffBuilder_ == null ? maximumBackoff_ : maximumBackoffBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.analyticshub.v1.RetryPolicy) {
        return mergeFrom((com.google.cloud.bigquery.analyticshub.v1.RetryPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.analyticshub.v1.RetryPolicy other) {
      if (other == com.google.cloud.bigquery.analyticshub.v1.RetryPolicy.getDefaultInstance())
        return this;
      if (other.hasMinimumBackoff()) {
        mergeMinimumBackoff(other.getMinimumBackoff());
      }
      if (other.hasMaximumBackoff()) {
        mergeMaximumBackoff(other.getMaximumBackoff());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getMinimumBackoffFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getMaximumBackoffFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Duration minimumBackoff_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        minimumBackoffBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The minimum delay between consecutive deliveries of a given
     * message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration minimum_backoff = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the minimumBackoff field is set.
     */
    public boolean hasMinimumBackoff() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The minimum delay between consecutive deliveries of a given
     * message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration minimum_backoff = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The minimumBackoff.
     */
    public com.google.protobuf.Duration getMinimumBackoff() {
      if (minimumBackoffBuilder_ == null) {
        return minimumBackoff_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : minimumBackoff_;
      } else {
        return minimumBackoffBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The minimum delay between consecutive deliveries of a given
     * message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration minimum_backoff = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMinimumBackoff(com.google.protobuf.Duration value) {
      if (minimumBackoffBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        minimumBackoff_ = value;
      } else {
        minimumBackoffBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The minimum delay between consecutive deliveries of a given
     * message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration minimum_backoff = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMinimumBackoff(com.google.protobuf.Duration.Builder builderForValue) {
      if (minimumBackoffBuilder_ == null) {
        minimumBackoff_ = builderForValue.build();
      } else {
        minimumBackoffBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The minimum delay between consecutive deliveries of a given
     * message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration minimum_backoff = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMinimumBackoff(com.google.protobuf.Duration value) {
      if (minimumBackoffBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && minimumBackoff_ != null
            && minimumBackoff_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getMinimumBackoffBuilder().mergeFrom(value);
        } else {
          minimumBackoff_ = value;
        }
      } else {
        minimumBackoffBuilder_.mergeFrom(value);
      }
      if (minimumBackoff_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The minimum delay between consecutive deliveries of a given
     * message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration minimum_backoff = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMinimumBackoff() {
      bitField0_ = (bitField0_ & ~0x00000001);
      minimumBackoff_ = null;
      if (minimumBackoffBuilder_ != null) {
        minimumBackoffBuilder_.dispose();
        minimumBackoffBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The minimum delay between consecutive deliveries of a given
     * message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration minimum_backoff = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getMinimumBackoffBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getMinimumBackoffFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The minimum delay between consecutive deliveries of a given
     * message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration minimum_backoff = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getMinimumBackoffOrBuilder() {
      if (minimumBackoffBuilder_ != null) {
        return minimumBackoffBuilder_.getMessageOrBuilder();
      } else {
        return minimumBackoff_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : minimumBackoff_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The minimum delay between consecutive deliveries of a given
     * message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration minimum_backoff = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMinimumBackoffFieldBuilder() {
      if (minimumBackoffBuilder_ == null) {
        minimumBackoffBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMinimumBackoff(), getParentForChildren(), isClean());
        minimumBackoff_ = null;
      }
      return minimumBackoffBuilder_;
    }

    private com.google.protobuf.Duration maximumBackoff_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        maximumBackoffBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The maximum delay between consecutive deliveries of a given
     * message. Value should be between 0 and 600 seconds. Defaults to 600
     * seconds.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration maximum_backoff = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the maximumBackoff field is set.
     */
    public boolean hasMaximumBackoff() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The maximum delay between consecutive deliveries of a given
     * message. Value should be between 0 and 600 seconds. Defaults to 600
     * seconds.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration maximum_backoff = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The maximumBackoff.
     */
    public com.google.protobuf.Duration getMaximumBackoff() {
      if (maximumBackoffBuilder_ == null) {
        return maximumBackoff_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maximumBackoff_;
      } else {
        return maximumBackoffBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The maximum delay between consecutive deliveries of a given
     * message. Value should be between 0 and 600 seconds. Defaults to 600
     * seconds.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration maximum_backoff = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMaximumBackoff(com.google.protobuf.Duration value) {
      if (maximumBackoffBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maximumBackoff_ = value;
      } else {
        maximumBackoffBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The maximum delay between consecutive deliveries of a given
     * message. Value should be between 0 and 600 seconds. Defaults to 600
     * seconds.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration maximum_backoff = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMaximumBackoff(com.google.protobuf.Duration.Builder builderForValue) {
      if (maximumBackoffBuilder_ == null) {
        maximumBackoff_ = builderForValue.build();
      } else {
        maximumBackoffBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The maximum delay between consecutive deliveries of a given
     * message. Value should be between 0 and 600 seconds. Defaults to 600
     * seconds.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration maximum_backoff = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMaximumBackoff(com.google.protobuf.Duration value) {
      if (maximumBackoffBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && maximumBackoff_ != null
            && maximumBackoff_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getMaximumBackoffBuilder().mergeFrom(value);
        } else {
          maximumBackoff_ = value;
        }
      } else {
        maximumBackoffBuilder_.mergeFrom(value);
      }
      if (maximumBackoff_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The maximum delay between consecutive deliveries of a given
     * message. Value should be between 0 and 600 seconds. Defaults to 600
     * seconds.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration maximum_backoff = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMaximumBackoff() {
      bitField0_ = (bitField0_ & ~0x00000002);
      maximumBackoff_ = null;
      if (maximumBackoffBuilder_ != null) {
        maximumBackoffBuilder_.dispose();
        maximumBackoffBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The maximum delay between consecutive deliveries of a given
     * message. Value should be between 0 and 600 seconds. Defaults to 600
     * seconds.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration maximum_backoff = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getMaximumBackoffBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getMaximumBackoffFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The maximum delay between consecutive deliveries of a given
     * message. Value should be between 0 and 600 seconds. Defaults to 600
     * seconds.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration maximum_backoff = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getMaximumBackoffOrBuilder() {
      if (maximumBackoffBuilder_ != null) {
        return maximumBackoffBuilder_.getMessageOrBuilder();
      } else {
        return maximumBackoff_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maximumBackoff_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The maximum delay between consecutive deliveries of a given
     * message. Value should be between 0 and 600 seconds. Defaults to 600
     * seconds.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration maximum_backoff = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMaximumBackoffFieldBuilder() {
      if (maximumBackoffBuilder_ == null) {
        maximumBackoffBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMaximumBackoff(), getParentForChildren(), isClean());
        maximumBackoff_ = null;
      }
      return maximumBackoffBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.analyticshub.v1.RetryPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.analyticshub.v1.RetryPolicy)
  private static final com.google.cloud.bigquery.analyticshub.v1.RetryPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.analyticshub.v1.RetryPolicy();
  }

  public static com.google.cloud.bigquery.analyticshub.v1.RetryPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RetryPolicy> PARSER =
      new com.google.protobuf.AbstractParser<RetryPolicy>() {
        @java.lang.Override
        public RetryPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RetryPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RetryPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.RetryPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
