/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/analyticshub/v1/analyticshub.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.bigquery.analyticshub.v1;

/**
 *
 *
 * <pre>
 * A data exchange is a container that lets you share data. Along with the
 * descriptive information about the data exchange, it contains listings that
 * reference shared datasets.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.DataExchange}
 */
public final class DataExchange extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.analyticshub.v1.DataExchange)
    DataExchangeOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use DataExchange.newBuilder() to construct.
  private DataExchange(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DataExchange() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    primaryContact_ = "";
    documentation_ = "";
    icon_ = com.google.protobuf.ByteString.EMPTY;
    discoveryType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DataExchange();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
        .internal_static_google_cloud_bigquery_analyticshub_v1_DataExchange_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
        .internal_static_google_cloud_bigquery_analyticshub_v1_DataExchange_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.analyticshub.v1.DataExchange.class,
            com.google.cloud.bigquery.analyticshub.v1.DataExchange.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the data exchange.
   * e.g. `projects/myproject/locations/us/dataExchanges/123`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the data exchange.
   * e.g. `projects/myproject/locations/us/dataExchanges/123`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Required. Human-readable display name of the data exchange. The display
   * name must contain only Unicode letters, numbers (0-9), underscores (_),
   * dashes (-), spaces ( ), ampersands (&amp;) and must not start or end with
   * spaces. Default value is an empty string. Max length: 63 bytes.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Human-readable display name of the data exchange. The display
   * name must contain only Unicode letters, numbers (0-9), underscores (_),
   * dashes (-), spaces ( ), ampersands (&amp;) and must not start or end with
   * spaces. Default value is an empty string. Max length: 63 bytes.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Description of the data exchange. The description must not
   * contain Unicode non-characters as well as C0 and C1 control codes except
   * tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
   * Default value is an empty string.
   * Max length: 2000 bytes.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Description of the data exchange. The description must not
   * contain Unicode non-characters as well as C0 and C1 control codes except
   * tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
   * Default value is an empty string.
   * Max length: 2000 bytes.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRIMARY_CONTACT_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object primaryContact_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Email or URL of the primary point of contact of the data
   * exchange. Max Length: 1000 bytes.
   * </pre>
   *
   * <code>string primary_contact = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The primaryContact.
   */
  @java.lang.Override
  public java.lang.String getPrimaryContact() {
    java.lang.Object ref = primaryContact_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      primaryContact_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Email or URL of the primary point of contact of the data
   * exchange. Max Length: 1000 bytes.
   * </pre>
   *
   * <code>string primary_contact = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for primaryContact.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrimaryContactBytes() {
    java.lang.Object ref = primaryContact_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      primaryContact_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCUMENTATION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object documentation_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Documentation describing the data exchange.
   * </pre>
   *
   * <code>string documentation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The documentation.
   */
  @java.lang.Override
  public java.lang.String getDocumentation() {
    java.lang.Object ref = documentation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      documentation_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Documentation describing the data exchange.
   * </pre>
   *
   * <code>string documentation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for documentation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDocumentationBytes() {
    java.lang.Object ref = documentation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      documentation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LISTING_COUNT_FIELD_NUMBER = 6;
  private int listingCount_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. Number of listings contained in the data exchange.
   * </pre>
   *
   * <code>int32 listing_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The listingCount.
   */
  @java.lang.Override
  public int getListingCount() {
    return listingCount_;
  }

  public static final int ICON_FIELD_NUMBER = 7;
  private com.google.protobuf.ByteString icon_ = com.google.protobuf.ByteString.EMPTY;

  /**
   *
   *
   * <pre>
   * Optional. Base64 encoded image representing the data exchange. Max
   * Size: 3.0MiB Expected image dimensions are 512x512 pixels, however the API
   * only performs validation on size of the encoded data. Note: For byte
   * fields, the content of the fields are base64-encoded (which increases the
   * size of the data by 33-36%) when using JSON on the wire.
   * </pre>
   *
   * <code>bytes icon = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The icon.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIcon() {
    return icon_;
  }

  public static final int SHARING_ENVIRONMENT_CONFIG_FIELD_NUMBER = 8;
  private com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig
      sharingEnvironmentConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Configurable data sharing environment option for a data exchange.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig sharing_environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sharingEnvironmentConfig field is set.
   */
  @java.lang.Override
  public boolean hasSharingEnvironmentConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Configurable data sharing environment option for a data exchange.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig sharing_environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sharingEnvironmentConfig.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig
      getSharingEnvironmentConfig() {
    return sharingEnvironmentConfig_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig.getDefaultInstance()
        : sharingEnvironmentConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Configurable data sharing environment option for a data exchange.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig sharing_environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfigOrBuilder
      getSharingEnvironmentConfigOrBuilder() {
    return sharingEnvironmentConfig_ == null
        ? com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig.getDefaultInstance()
        : sharingEnvironmentConfig_;
  }

  public static final int DISCOVERY_TYPE_FIELD_NUMBER = 9;
  private int discoveryType_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Type of discovery on the discovery page for all the listings
   * under this exchange. Updating this field also updates (overwrites) the
   * discovery_type field for all the listings under this exchange.
   * </pre>
   *
   * <code>
   * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the discoveryType field is set.
   */
  @java.lang.Override
  public boolean hasDiscoveryType() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Type of discovery on the discovery page for all the listings
   * under this exchange. Updating this field also updates (overwrites) the
   * discovery_type field for all the listings under this exchange.
   * </pre>
   *
   * <code>
   * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for discoveryType.
   */
  @java.lang.Override
  public int getDiscoveryTypeValue() {
    return discoveryType_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Type of discovery on the discovery page for all the listings
   * under this exchange. Updating this field also updates (overwrites) the
   * discovery_type field for all the listings under this exchange.
   * </pre>
   *
   * <code>
   * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The discoveryType.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.DiscoveryType getDiscoveryType() {
    com.google.cloud.bigquery.analyticshub.v1.DiscoveryType result =
        com.google.cloud.bigquery.analyticshub.v1.DiscoveryType.forNumber(discoveryType_);
    return result == null
        ? com.google.cloud.bigquery.analyticshub.v1.DiscoveryType.UNRECOGNIZED
        : result;
  }

  public static final int LOG_LINKED_DATASET_QUERY_USER_EMAIL_FIELD_NUMBER = 10;
  private boolean logLinkedDatasetQueryUserEmail_ = false;

  /**
   *
   *
   * <pre>
   * Optional. By default, false.
   * If true, the DataExchange has an email sharing mandate enabled.
   * </pre>
   *
   * <code>
   * optional bool log_linked_dataset_query_user_email = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the logLinkedDatasetQueryUserEmail field is set.
   */
  @java.lang.Override
  public boolean hasLogLinkedDatasetQueryUserEmail() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. By default, false.
   * If true, the DataExchange has an email sharing mandate enabled.
   * </pre>
   *
   * <code>
   * optional bool log_linked_dataset_query_user_email = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The logLinkedDatasetQueryUserEmail.
   */
  @java.lang.Override
  public boolean getLogLinkedDatasetQueryUserEmail() {
    return logLinkedDatasetQueryUserEmail_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(primaryContact_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, primaryContact_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(documentation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, documentation_);
    }
    if (listingCount_ != 0) {
      output.writeInt32(6, listingCount_);
    }
    if (!icon_.isEmpty()) {
      output.writeBytes(7, icon_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(8, getSharingEnvironmentConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeEnum(9, discoveryType_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeBool(10, logLinkedDatasetQueryUserEmail_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(primaryContact_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, primaryContact_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(documentation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, documentation_);
    }
    if (listingCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, listingCount_);
    }
    if (!icon_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(7, icon_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, getSharingEnvironmentConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, discoveryType_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              10, logLinkedDatasetQueryUserEmail_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.analyticshub.v1.DataExchange)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.analyticshub.v1.DataExchange other =
        (com.google.cloud.bigquery.analyticshub.v1.DataExchange) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getPrimaryContact().equals(other.getPrimaryContact())) return false;
    if (!getDocumentation().equals(other.getDocumentation())) return false;
    if (getListingCount() != other.getListingCount()) return false;
    if (!getIcon().equals(other.getIcon())) return false;
    if (hasSharingEnvironmentConfig() != other.hasSharingEnvironmentConfig()) return false;
    if (hasSharingEnvironmentConfig()) {
      if (!getSharingEnvironmentConfig().equals(other.getSharingEnvironmentConfig())) return false;
    }
    if (hasDiscoveryType() != other.hasDiscoveryType()) return false;
    if (hasDiscoveryType()) {
      if (discoveryType_ != other.discoveryType_) return false;
    }
    if (hasLogLinkedDatasetQueryUserEmail() != other.hasLogLinkedDatasetQueryUserEmail())
      return false;
    if (hasLogLinkedDatasetQueryUserEmail()) {
      if (getLogLinkedDatasetQueryUserEmail() != other.getLogLinkedDatasetQueryUserEmail())
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + PRIMARY_CONTACT_FIELD_NUMBER;
    hash = (53 * hash) + getPrimaryContact().hashCode();
    hash = (37 * hash) + DOCUMENTATION_FIELD_NUMBER;
    hash = (53 * hash) + getDocumentation().hashCode();
    hash = (37 * hash) + LISTING_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getListingCount();
    hash = (37 * hash) + ICON_FIELD_NUMBER;
    hash = (53 * hash) + getIcon().hashCode();
    if (hasSharingEnvironmentConfig()) {
      hash = (37 * hash) + SHARING_ENVIRONMENT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSharingEnvironmentConfig().hashCode();
    }
    if (hasDiscoveryType()) {
      hash = (37 * hash) + DISCOVERY_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + discoveryType_;
    }
    if (hasLogLinkedDatasetQueryUserEmail()) {
      hash = (37 * hash) + LOG_LINKED_DATASET_QUERY_USER_EMAIL_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(getLogLinkedDatasetQueryUserEmail());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DataExchange parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DataExchange parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DataExchange parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DataExchange parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DataExchange parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DataExchange parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DataExchange parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DataExchange parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DataExchange parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DataExchange parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DataExchange parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DataExchange parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.analyticshub.v1.DataExchange prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A data exchange is a container that lets you share data. Along with the
   * descriptive information about the data exchange, it contains listings that
   * reference shared datasets.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.analyticshub.v1.DataExchange}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.analyticshub.v1.DataExchange)
      com.google.cloud.bigquery.analyticshub.v1.DataExchangeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_DataExchange_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_DataExchange_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.analyticshub.v1.DataExchange.class,
              com.google.cloud.bigquery.analyticshub.v1.DataExchange.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.analyticshub.v1.DataExchange.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSharingEnvironmentConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      description_ = "";
      primaryContact_ = "";
      documentation_ = "";
      listingCount_ = 0;
      icon_ = com.google.protobuf.ByteString.EMPTY;
      sharingEnvironmentConfig_ = null;
      if (sharingEnvironmentConfigBuilder_ != null) {
        sharingEnvironmentConfigBuilder_.dispose();
        sharingEnvironmentConfigBuilder_ = null;
      }
      discoveryType_ = 0;
      logLinkedDatasetQueryUserEmail_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.analyticshub.v1.AnalyticsHubProto
          .internal_static_google_cloud_bigquery_analyticshub_v1_DataExchange_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.DataExchange getDefaultInstanceForType() {
      return com.google.cloud.bigquery.analyticshub.v1.DataExchange.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.DataExchange build() {
      com.google.cloud.bigquery.analyticshub.v1.DataExchange result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.DataExchange buildPartial() {
      com.google.cloud.bigquery.analyticshub.v1.DataExchange result =
          new com.google.cloud.bigquery.analyticshub.v1.DataExchange(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.bigquery.analyticshub.v1.DataExchange result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.primaryContact_ = primaryContact_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.documentation_ = documentation_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.listingCount_ = listingCount_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.icon_ = icon_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.sharingEnvironmentConfig_ =
            sharingEnvironmentConfigBuilder_ == null
                ? sharingEnvironmentConfig_
                : sharingEnvironmentConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.discoveryType_ = discoveryType_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.logLinkedDatasetQueryUserEmail_ = logLinkedDatasetQueryUserEmail_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.analyticshub.v1.DataExchange) {
        return mergeFrom((com.google.cloud.bigquery.analyticshub.v1.DataExchange) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.analyticshub.v1.DataExchange other) {
      if (other == com.google.cloud.bigquery.analyticshub.v1.DataExchange.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getPrimaryContact().isEmpty()) {
        primaryContact_ = other.primaryContact_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDocumentation().isEmpty()) {
        documentation_ = other.documentation_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getListingCount() != 0) {
        setListingCount(other.getListingCount());
      }
      if (other.getIcon() != com.google.protobuf.ByteString.EMPTY) {
        setIcon(other.getIcon());
      }
      if (other.hasSharingEnvironmentConfig()) {
        mergeSharingEnvironmentConfig(other.getSharingEnvironmentConfig());
      }
      if (other.hasDiscoveryType()) {
        setDiscoveryType(other.getDiscoveryType());
      }
      if (other.hasLogLinkedDatasetQueryUserEmail()) {
        setLogLinkedDatasetQueryUserEmail(other.getLogLinkedDatasetQueryUserEmail());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                primaryContact_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                documentation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                listingCount_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                icon_ = input.readBytes();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getSharingEnvironmentConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 72:
              {
                discoveryType_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 80:
              {
                logLinkedDatasetQueryUserEmail_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the data exchange.
     * e.g. `projects/myproject/locations/us/dataExchanges/123`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the data exchange.
     * e.g. `projects/myproject/locations/us/dataExchanges/123`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the data exchange.
     * e.g. `projects/myproject/locations/us/dataExchanges/123`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the data exchange.
     * e.g. `projects/myproject/locations/us/dataExchanges/123`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the data exchange.
     * e.g. `projects/myproject/locations/us/dataExchanges/123`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Required. Human-readable display name of the data exchange. The display
     * name must contain only Unicode letters, numbers (0-9), underscores (_),
     * dashes (-), spaces ( ), ampersands (&amp;) and must not start or end with
     * spaces. Default value is an empty string. Max length: 63 bytes.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Human-readable display name of the data exchange. The display
     * name must contain only Unicode letters, numbers (0-9), underscores (_),
     * dashes (-), spaces ( ), ampersands (&amp;) and must not start or end with
     * spaces. Default value is an empty string. Max length: 63 bytes.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Human-readable display name of the data exchange. The display
     * name must contain only Unicode letters, numbers (0-9), underscores (_),
     * dashes (-), spaces ( ), ampersands (&amp;) and must not start or end with
     * spaces. Default value is an empty string. Max length: 63 bytes.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Human-readable display name of the data exchange. The display
     * name must contain only Unicode letters, numbers (0-9), underscores (_),
     * dashes (-), spaces ( ), ampersands (&amp;) and must not start or end with
     * spaces. Default value is an empty string. Max length: 63 bytes.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Human-readable display name of the data exchange. The display
     * name must contain only Unicode letters, numbers (0-9), underscores (_),
     * dashes (-), spaces ( ), ampersands (&amp;) and must not start or end with
     * spaces. Default value is an empty string. Max length: 63 bytes.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Description of the data exchange. The description must not
     * contain Unicode non-characters as well as C0 and C1 control codes except
     * tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
     * Default value is an empty string.
     * Max length: 2000 bytes.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Description of the data exchange. The description must not
     * contain Unicode non-characters as well as C0 and C1 control codes except
     * tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
     * Default value is an empty string.
     * Max length: 2000 bytes.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Description of the data exchange. The description must not
     * contain Unicode non-characters as well as C0 and C1 control codes except
     * tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
     * Default value is an empty string.
     * Max length: 2000 bytes.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Description of the data exchange. The description must not
     * contain Unicode non-characters as well as C0 and C1 control codes except
     * tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
     * Default value is an empty string.
     * Max length: 2000 bytes.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Description of the data exchange. The description must not
     * contain Unicode non-characters as well as C0 and C1 control codes except
     * tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
     * Default value is an empty string.
     * Max length: 2000 bytes.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object primaryContact_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Email or URL of the primary point of contact of the data
     * exchange. Max Length: 1000 bytes.
     * </pre>
     *
     * <code>string primary_contact = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The primaryContact.
     */
    public java.lang.String getPrimaryContact() {
      java.lang.Object ref = primaryContact_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        primaryContact_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Email or URL of the primary point of contact of the data
     * exchange. Max Length: 1000 bytes.
     * </pre>
     *
     * <code>string primary_contact = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for primaryContact.
     */
    public com.google.protobuf.ByteString getPrimaryContactBytes() {
      java.lang.Object ref = primaryContact_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        primaryContact_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Email or URL of the primary point of contact of the data
     * exchange. Max Length: 1000 bytes.
     * </pre>
     *
     * <code>string primary_contact = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The primaryContact to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryContact(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      primaryContact_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Email or URL of the primary point of contact of the data
     * exchange. Max Length: 1000 bytes.
     * </pre>
     *
     * <code>string primary_contact = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrimaryContact() {
      primaryContact_ = getDefaultInstance().getPrimaryContact();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Email or URL of the primary point of contact of the data
     * exchange. Max Length: 1000 bytes.
     * </pre>
     *
     * <code>string primary_contact = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for primaryContact to set.
     * @return This builder for chaining.
     */
    public Builder setPrimaryContactBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      primaryContact_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object documentation_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Documentation describing the data exchange.
     * </pre>
     *
     * <code>string documentation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The documentation.
     */
    public java.lang.String getDocumentation() {
      java.lang.Object ref = documentation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        documentation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Documentation describing the data exchange.
     * </pre>
     *
     * <code>string documentation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for documentation.
     */
    public com.google.protobuf.ByteString getDocumentationBytes() {
      java.lang.Object ref = documentation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        documentation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Documentation describing the data exchange.
     * </pre>
     *
     * <code>string documentation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The documentation to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      documentation_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Documentation describing the data exchange.
     * </pre>
     *
     * <code>string documentation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDocumentation() {
      documentation_ = getDefaultInstance().getDocumentation();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Documentation describing the data exchange.
     * </pre>
     *
     * <code>string documentation = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for documentation to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      documentation_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int listingCount_;

    /**
     *
     *
     * <pre>
     * Output only. Number of listings contained in the data exchange.
     * </pre>
     *
     * <code>int32 listing_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The listingCount.
     */
    @java.lang.Override
    public int getListingCount() {
      return listingCount_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Number of listings contained in the data exchange.
     * </pre>
     *
     * <code>int32 listing_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The listingCount to set.
     * @return This builder for chaining.
     */
    public Builder setListingCount(int value) {

      listingCount_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Number of listings contained in the data exchange.
     * </pre>
     *
     * <code>int32 listing_count = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearListingCount() {
      bitField0_ = (bitField0_ & ~0x00000020);
      listingCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString icon_ = com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * Optional. Base64 encoded image representing the data exchange. Max
     * Size: 3.0MiB Expected image dimensions are 512x512 pixels, however the API
     * only performs validation on size of the encoded data. Note: For byte
     * fields, the content of the fields are base64-encoded (which increases the
     * size of the data by 33-36%) when using JSON on the wire.
     * </pre>
     *
     * <code>bytes icon = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The icon.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIcon() {
      return icon_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Base64 encoded image representing the data exchange. Max
     * Size: 3.0MiB Expected image dimensions are 512x512 pixels, however the API
     * only performs validation on size of the encoded data. Note: For byte
     * fields, the content of the fields are base64-encoded (which increases the
     * size of the data by 33-36%) when using JSON on the wire.
     * </pre>
     *
     * <code>bytes icon = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The icon to set.
     * @return This builder for chaining.
     */
    public Builder setIcon(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      icon_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Base64 encoded image representing the data exchange. Max
     * Size: 3.0MiB Expected image dimensions are 512x512 pixels, however the API
     * only performs validation on size of the encoded data. Note: For byte
     * fields, the content of the fields are base64-encoded (which increases the
     * size of the data by 33-36%) when using JSON on the wire.
     * </pre>
     *
     * <code>bytes icon = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIcon() {
      bitField0_ = (bitField0_ & ~0x00000040);
      icon_ = getDefaultInstance().getIcon();
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig
        sharingEnvironmentConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig,
            com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig.Builder,
            com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfigOrBuilder>
        sharingEnvironmentConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Configurable data sharing environment option for a data exchange.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig sharing_environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sharingEnvironmentConfig field is set.
     */
    public boolean hasSharingEnvironmentConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Configurable data sharing environment option for a data exchange.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig sharing_environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sharingEnvironmentConfig.
     */
    public com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig
        getSharingEnvironmentConfig() {
      if (sharingEnvironmentConfigBuilder_ == null) {
        return sharingEnvironmentConfig_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig
                .getDefaultInstance()
            : sharingEnvironmentConfig_;
      } else {
        return sharingEnvironmentConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Configurable data sharing environment option for a data exchange.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig sharing_environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSharingEnvironmentConfig(
        com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig value) {
      if (sharingEnvironmentConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sharingEnvironmentConfig_ = value;
      } else {
        sharingEnvironmentConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configurable data sharing environment option for a data exchange.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig sharing_environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSharingEnvironmentConfig(
        com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig.Builder
            builderForValue) {
      if (sharingEnvironmentConfigBuilder_ == null) {
        sharingEnvironmentConfig_ = builderForValue.build();
      } else {
        sharingEnvironmentConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configurable data sharing environment option for a data exchange.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig sharing_environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSharingEnvironmentConfig(
        com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig value) {
      if (sharingEnvironmentConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && sharingEnvironmentConfig_ != null
            && sharingEnvironmentConfig_
                != com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig
                    .getDefaultInstance()) {
          getSharingEnvironmentConfigBuilder().mergeFrom(value);
        } else {
          sharingEnvironmentConfig_ = value;
        }
      } else {
        sharingEnvironmentConfigBuilder_.mergeFrom(value);
      }
      if (sharingEnvironmentConfig_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configurable data sharing environment option for a data exchange.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig sharing_environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSharingEnvironmentConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      sharingEnvironmentConfig_ = null;
      if (sharingEnvironmentConfigBuilder_ != null) {
        sharingEnvironmentConfigBuilder_.dispose();
        sharingEnvironmentConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configurable data sharing environment option for a data exchange.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig sharing_environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig.Builder
        getSharingEnvironmentConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getSharingEnvironmentConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Configurable data sharing environment option for a data exchange.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig sharing_environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfigOrBuilder
        getSharingEnvironmentConfigOrBuilder() {
      if (sharingEnvironmentConfigBuilder_ != null) {
        return sharingEnvironmentConfigBuilder_.getMessageOrBuilder();
      } else {
        return sharingEnvironmentConfig_ == null
            ? com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig
                .getDefaultInstance()
            : sharingEnvironmentConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Configurable data sharing environment option for a data exchange.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig sharing_environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig,
            com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig.Builder,
            com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfigOrBuilder>
        getSharingEnvironmentConfigFieldBuilder() {
      if (sharingEnvironmentConfigBuilder_ == null) {
        sharingEnvironmentConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig,
                com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfig.Builder,
                com.google.cloud.bigquery.analyticshub.v1.SharingEnvironmentConfigOrBuilder>(
                getSharingEnvironmentConfig(), getParentForChildren(), isClean());
        sharingEnvironmentConfig_ = null;
      }
      return sharingEnvironmentConfigBuilder_;
    }

    private int discoveryType_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. Type of discovery on the discovery page for all the listings
     * under this exchange. Updating this field also updates (overwrites) the
     * discovery_type field for all the listings under this exchange.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the discoveryType field is set.
     */
    @java.lang.Override
    public boolean hasDiscoveryType() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Type of discovery on the discovery page for all the listings
     * under this exchange. Updating this field also updates (overwrites) the
     * discovery_type field for all the listings under this exchange.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for discoveryType.
     */
    @java.lang.Override
    public int getDiscoveryTypeValue() {
      return discoveryType_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Type of discovery on the discovery page for all the listings
     * under this exchange. Updating this field also updates (overwrites) the
     * discovery_type field for all the listings under this exchange.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for discoveryType to set.
     * @return This builder for chaining.
     */
    public Builder setDiscoveryTypeValue(int value) {
      discoveryType_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Type of discovery on the discovery page for all the listings
     * under this exchange. Updating this field also updates (overwrites) the
     * discovery_type field for all the listings under this exchange.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The discoveryType.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.analyticshub.v1.DiscoveryType getDiscoveryType() {
      com.google.cloud.bigquery.analyticshub.v1.DiscoveryType result =
          com.google.cloud.bigquery.analyticshub.v1.DiscoveryType.forNumber(discoveryType_);
      return result == null
          ? com.google.cloud.bigquery.analyticshub.v1.DiscoveryType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. Type of discovery on the discovery page for all the listings
     * under this exchange. Updating this field also updates (overwrites) the
     * discovery_type field for all the listings under this exchange.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The discoveryType to set.
     * @return This builder for chaining.
     */
    public Builder setDiscoveryType(com.google.cloud.bigquery.analyticshub.v1.DiscoveryType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      discoveryType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Type of discovery on the discovery page for all the listings
     * under this exchange. Updating this field also updates (overwrites) the
     * discovery_type field for all the listings under this exchange.
     * </pre>
     *
     * <code>
     * optional .google.cloud.bigquery.analyticshub.v1.DiscoveryType discovery_type = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiscoveryType() {
      bitField0_ = (bitField0_ & ~0x00000100);
      discoveryType_ = 0;
      onChanged();
      return this;
    }

    private boolean logLinkedDatasetQueryUserEmail_;

    /**
     *
     *
     * <pre>
     * Optional. By default, false.
     * If true, the DataExchange has an email sharing mandate enabled.
     * </pre>
     *
     * <code>
     * optional bool log_linked_dataset_query_user_email = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the logLinkedDatasetQueryUserEmail field is set.
     */
    @java.lang.Override
    public boolean hasLogLinkedDatasetQueryUserEmail() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. By default, false.
     * If true, the DataExchange has an email sharing mandate enabled.
     * </pre>
     *
     * <code>
     * optional bool log_linked_dataset_query_user_email = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The logLinkedDatasetQueryUserEmail.
     */
    @java.lang.Override
    public boolean getLogLinkedDatasetQueryUserEmail() {
      return logLinkedDatasetQueryUserEmail_;
    }

    /**
     *
     *
     * <pre>
     * Optional. By default, false.
     * If true, the DataExchange has an email sharing mandate enabled.
     * </pre>
     *
     * <code>
     * optional bool log_linked_dataset_query_user_email = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The logLinkedDatasetQueryUserEmail to set.
     * @return This builder for chaining.
     */
    public Builder setLogLinkedDatasetQueryUserEmail(boolean value) {

      logLinkedDatasetQueryUserEmail_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. By default, false.
     * If true, the DataExchange has an email sharing mandate enabled.
     * </pre>
     *
     * <code>
     * optional bool log_linked_dataset_query_user_email = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLogLinkedDatasetQueryUserEmail() {
      bitField0_ = (bitField0_ & ~0x00000200);
      logLinkedDatasetQueryUserEmail_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.analyticshub.v1.DataExchange)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.analyticshub.v1.DataExchange)
  private static final com.google.cloud.bigquery.analyticshub.v1.DataExchange DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.analyticshub.v1.DataExchange();
  }

  public static com.google.cloud.bigquery.analyticshub.v1.DataExchange getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DataExchange> PARSER =
      new com.google.protobuf.AbstractParser<DataExchange>() {
        @java.lang.Override
        public DataExchange parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DataExchange> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DataExchange> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.analyticshub.v1.DataExchange getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
