/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.storage.v2.Bucket;
import com.google.storage.v2.CancelResumableWriteRequest;
import com.google.storage.v2.CancelResumableWriteResponse;
import com.google.storage.v2.ComposeObjectRequest;
import com.google.storage.v2.CreateBucketRequest;
import com.google.storage.v2.CreateHmacKeyRequest;
import com.google.storage.v2.CreateHmacKeyResponse;
import com.google.storage.v2.CreateNotificationRequest;
import com.google.storage.v2.DeleteBucketRequest;
import com.google.storage.v2.DeleteHmacKeyRequest;
import com.google.storage.v2.DeleteNotificationRequest;
import com.google.storage.v2.DeleteObjectRequest;
import com.google.storage.v2.GetBucketRequest;
import com.google.storage.v2.GetHmacKeyRequest;
import com.google.storage.v2.GetNotificationRequest;
import com.google.storage.v2.GetObjectRequest;
import com.google.storage.v2.GetServiceAccountRequest;
import com.google.storage.v2.HmacKeyMetadata;
import com.google.storage.v2.ListBucketsRequest;
import com.google.storage.v2.ListBucketsResponse;
import com.google.storage.v2.ListHmacKeysRequest;
import com.google.storage.v2.ListHmacKeysResponse;
import com.google.storage.v2.ListNotificationsRequest;
import com.google.storage.v2.ListNotificationsResponse;
import com.google.storage.v2.ListObjectsRequest;
import com.google.storage.v2.ListObjectsResponse;
import com.google.storage.v2.LockBucketRetentionPolicyRequest;
import com.google.storage.v2.Notification;
import com.google.storage.v2.Object;
import com.google.storage.v2.QueryWriteStatusRequest;
import com.google.storage.v2.QueryWriteStatusResponse;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.ReadObjectResponse;
import com.google.storage.v2.RewriteObjectRequest;
import com.google.storage.v2.RewriteResponse;
import com.google.storage.v2.ServiceAccount;
import com.google.storage.v2.StartResumableWriteRequest;
import com.google.storage.v2.StartResumableWriteResponse;
import com.google.storage.v2.StorageClient;
import com.google.storage.v2.UpdateBucketRequest;
import com.google.storage.v2.UpdateHmacKeyRequest;
import com.google.storage.v2.UpdateObjectRequest;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import com.google.storage.v2.stub.GrpcStorageCallableFactory;
import com.google.storage.v2.stub.StorageStub;
import com.google.storage.v2.stub.StorageStubSettings;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcStorageStub
extends StorageStub {
    private static final MethodDescriptor<DeleteBucketRequest, Empty> deleteBucketMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/DeleteBucket").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteBucketRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<GetBucketRequest, Bucket> getBucketMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/GetBucket").setRequestMarshaller(ProtoUtils.marshaller((Message)GetBucketRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Bucket.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateBucketRequest, Bucket> createBucketMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/CreateBucket").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateBucketRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Bucket.getDefaultInstance())).build();
    private static final MethodDescriptor<ListBucketsRequest, ListBucketsResponse> listBucketsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/ListBuckets").setRequestMarshaller(ProtoUtils.marshaller((Message)ListBucketsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListBucketsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<LockBucketRetentionPolicyRequest, Bucket> lockBucketRetentionPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/LockBucketRetentionPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)LockBucketRetentionPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Bucket.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateBucketRequest, Bucket> updateBucketMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/UpdateBucket").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateBucketRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Bucket.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteNotificationRequest, Empty> deleteNotificationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/DeleteNotification").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteNotificationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<GetNotificationRequest, Notification> getNotificationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/GetNotification").setRequestMarshaller(ProtoUtils.marshaller((Message)GetNotificationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Notification.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateNotificationRequest, Notification> createNotificationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/CreateNotification").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateNotificationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Notification.getDefaultInstance())).build();
    private static final MethodDescriptor<ListNotificationsRequest, ListNotificationsResponse> listNotificationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/ListNotifications").setRequestMarshaller(ProtoUtils.marshaller((Message)ListNotificationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListNotificationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ComposeObjectRequest, Object> composeObjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/ComposeObject").setRequestMarshaller(ProtoUtils.marshaller((Message)ComposeObjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Object.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteObjectRequest, Empty> deleteObjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/DeleteObject").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteObjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<CancelResumableWriteRequest, CancelResumableWriteResponse> cancelResumableWriteMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/CancelResumableWrite").setRequestMarshaller(ProtoUtils.marshaller((Message)CancelResumableWriteRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CancelResumableWriteResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetObjectRequest, Object> getObjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/GetObject").setRequestMarshaller(ProtoUtils.marshaller((Message)GetObjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Object.getDefaultInstance())).build();
    private static final MethodDescriptor<ReadObjectRequest, ReadObjectResponse> readObjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.storage.v2.Storage/ReadObject").setRequestMarshaller(ProtoUtils.marshaller((Message)ReadObjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReadObjectResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateObjectRequest, Object> updateObjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/UpdateObject").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateObjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Object.getDefaultInstance())).build();
    private static final MethodDescriptor<WriteObjectRequest, WriteObjectResponse> writeObjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.CLIENT_STREAMING).setFullMethodName("google.storage.v2.Storage/WriteObject").setRequestMarshaller(ProtoUtils.marshaller((Message)WriteObjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)WriteObjectResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListObjectsRequest, ListObjectsResponse> listObjectsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/ListObjects").setRequestMarshaller(ProtoUtils.marshaller((Message)ListObjectsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListObjectsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<RewriteObjectRequest, RewriteResponse> rewriteObjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/RewriteObject").setRequestMarshaller(ProtoUtils.marshaller((Message)RewriteObjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RewriteResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/StartResumableWrite").setRequestMarshaller(ProtoUtils.marshaller((Message)StartResumableWriteRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StartResumableWriteResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/QueryWriteStatus").setRequestMarshaller(ProtoUtils.marshaller((Message)QueryWriteStatusRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)QueryWriteStatusResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetServiceAccountRequest, ServiceAccount> getServiceAccountMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/GetServiceAccount").setRequestMarshaller(ProtoUtils.marshaller((Message)GetServiceAccountRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ServiceAccount.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateHmacKeyRequest, CreateHmacKeyResponse> createHmacKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/CreateHmacKey").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateHmacKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CreateHmacKeyResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteHmacKeyRequest, Empty> deleteHmacKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/DeleteHmacKey").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteHmacKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<GetHmacKeyRequest, HmacKeyMetadata> getHmacKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/GetHmacKey").setRequestMarshaller(ProtoUtils.marshaller((Message)GetHmacKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)HmacKeyMetadata.getDefaultInstance())).build();
    private static final MethodDescriptor<ListHmacKeysRequest, ListHmacKeysResponse> listHmacKeysMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/ListHmacKeys").setRequestMarshaller(ProtoUtils.marshaller((Message)ListHmacKeysRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListHmacKeysResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateHmacKeyRequest, HmacKeyMetadata> updateHmacKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/UpdateHmacKey").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateHmacKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)HmacKeyMetadata.getDefaultInstance())).build();
    private final UnaryCallable<DeleteBucketRequest, Empty> deleteBucketCallable;
    private final UnaryCallable<GetBucketRequest, Bucket> getBucketCallable;
    private final UnaryCallable<CreateBucketRequest, Bucket> createBucketCallable;
    private final UnaryCallable<ListBucketsRequest, ListBucketsResponse> listBucketsCallable;
    private final UnaryCallable<ListBucketsRequest, StorageClient.ListBucketsPagedResponse> listBucketsPagedCallable;
    private final UnaryCallable<LockBucketRetentionPolicyRequest, Bucket> lockBucketRetentionPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final UnaryCallable<UpdateBucketRequest, Bucket> updateBucketCallable;
    private final UnaryCallable<DeleteNotificationRequest, Empty> deleteNotificationCallable;
    private final UnaryCallable<GetNotificationRequest, Notification> getNotificationCallable;
    private final UnaryCallable<CreateNotificationRequest, Notification> createNotificationCallable;
    private final UnaryCallable<ListNotificationsRequest, ListNotificationsResponse> listNotificationsCallable;
    private final UnaryCallable<ListNotificationsRequest, StorageClient.ListNotificationsPagedResponse> listNotificationsPagedCallable;
    private final UnaryCallable<ComposeObjectRequest, Object> composeObjectCallable;
    private final UnaryCallable<DeleteObjectRequest, Empty> deleteObjectCallable;
    private final UnaryCallable<CancelResumableWriteRequest, CancelResumableWriteResponse> cancelResumableWriteCallable;
    private final UnaryCallable<GetObjectRequest, Object> getObjectCallable;
    private final ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> readObjectCallable;
    private final UnaryCallable<UpdateObjectRequest, Object> updateObjectCallable;
    private final ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> writeObjectCallable;
    private final UnaryCallable<ListObjectsRequest, ListObjectsResponse> listObjectsCallable;
    private final UnaryCallable<ListObjectsRequest, StorageClient.ListObjectsPagedResponse> listObjectsPagedCallable;
    private final UnaryCallable<RewriteObjectRequest, RewriteResponse> rewriteObjectCallable;
    private final UnaryCallable<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteCallable;
    private final UnaryCallable<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusCallable;
    private final UnaryCallable<GetServiceAccountRequest, ServiceAccount> getServiceAccountCallable;
    private final UnaryCallable<CreateHmacKeyRequest, CreateHmacKeyResponse> createHmacKeyCallable;
    private final UnaryCallable<DeleteHmacKeyRequest, Empty> deleteHmacKeyCallable;
    private final UnaryCallable<GetHmacKeyRequest, HmacKeyMetadata> getHmacKeyCallable;
    private final UnaryCallable<ListHmacKeysRequest, ListHmacKeysResponse> listHmacKeysCallable;
    private final UnaryCallable<ListHmacKeysRequest, StorageClient.ListHmacKeysPagedResponse> listHmacKeysPagedCallable;
    private final UnaryCallable<UpdateHmacKeyRequest, HmacKeyMetadata> updateHmacKeyCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;
    private static final PathTemplate DELETE_BUCKET_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate GET_BUCKET_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate CREATE_BUCKET_0_PATH_TEMPLATE = PathTemplate.create((String)"{project=**}");
    private static final PathTemplate LIST_BUCKETS_0_PATH_TEMPLATE = PathTemplate.create((String)"{project=**}");
    private static final PathTemplate LOCK_BUCKET_RETENTION_POLICY_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate GET_IAM_POLICY_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate GET_IAM_POLICY_1_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/objects/**");
    private static final PathTemplate SET_IAM_POLICY_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate SET_IAM_POLICY_1_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/objects/**");
    private static final PathTemplate TEST_IAM_PERMISSIONS_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate TEST_IAM_PERMISSIONS_1_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/objects/**");
    private static final PathTemplate UPDATE_BUCKET_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate DELETE_NOTIFICATION_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");
    private static final PathTemplate GET_NOTIFICATION_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");
    private static final PathTemplate CREATE_NOTIFICATION_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate LIST_NOTIFICATIONS_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate COMPOSE_OBJECT_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate DELETE_OBJECT_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate CANCEL_RESUMABLE_WRITE_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");
    private static final PathTemplate GET_OBJECT_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate READ_OBJECT_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate UPDATE_OBJECT_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate WRITE_OBJECT_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate WRITE_OBJECT_1_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");
    private static final PathTemplate LIST_OBJECTS_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate REWRITE_OBJECT_0_PATH_TEMPLATE = PathTemplate.create((String)"{source_bucket=**}");
    private static final PathTemplate REWRITE_OBJECT_1_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate START_RESUMABLE_WRITE_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=**}");
    private static final PathTemplate QUERY_WRITE_STATUS_0_PATH_TEMPLATE = PathTemplate.create((String)"{bucket=projects/*/buckets/*}/**");
    private static final PathTemplate GET_SERVICE_ACCOUNT_0_PATH_TEMPLATE = PathTemplate.create((String)"{project=**}");
    private static final PathTemplate CREATE_HMAC_KEY_0_PATH_TEMPLATE = PathTemplate.create((String)"{project=**}");
    private static final PathTemplate DELETE_HMAC_KEY_0_PATH_TEMPLATE = PathTemplate.create((String)"{project=**}");
    private static final PathTemplate GET_HMAC_KEY_0_PATH_TEMPLATE = PathTemplate.create((String)"{project=**}");
    private static final PathTemplate LIST_HMAC_KEYS_0_PATH_TEMPLATE = PathTemplate.create((String)"{project=**}");
    private static final PathTemplate UPDATE_HMAC_KEY_0_PATH_TEMPLATE = PathTemplate.create((String)"{project=**}");

    public static final GrpcStorageStub create(StorageStubSettings settings) throws IOException {
        return new GrpcStorageStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcStorageStub create(ClientContext clientContext) throws IOException {
        return new GrpcStorageStub(StorageStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcStorageStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcStorageStub(StorageStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcStorageStub(StorageStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcStorageCallableFactory());
    }

    protected GrpcStorageStub(StorageStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings deleteBucketTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteBucketMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "bucket", DELETE_BUCKET_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings getBucketTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getBucketMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "bucket", GET_BUCKET_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings createBucketTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createBucketMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "project", CREATE_BUCKET_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings listBucketsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listBucketsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "project", LIST_BUCKETS_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings lockBucketRetentionPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(lockBucketRetentionPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getBucket(), "bucket", LOCK_BUCKET_RETENTION_POLICY_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getResource(), "bucket", GET_IAM_POLICY_0_PATH_TEMPLATE);
            builder.add(request.getResource(), "bucket", GET_IAM_POLICY_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getResource(), "bucket", SET_IAM_POLICY_0_PATH_TEMPLATE);
            builder.add(request.getResource(), "bucket", SET_IAM_POLICY_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getResource(), "bucket", TEST_IAM_PERMISSIONS_0_PATH_TEMPLATE);
            builder.add(request.getResource(), "bucket", TEST_IAM_PERMISSIONS_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings updateBucketTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateBucketMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            if (request.getBucket() != null) {
                builder.add(request.getBucket().getName(), "bucket", UPDATE_BUCKET_0_PATH_TEMPLATE);
            }
            return builder.build();
        }).build();
        GrpcCallSettings deleteNotificationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteNotificationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "bucket", DELETE_NOTIFICATION_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings getNotificationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getNotificationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "bucket", GET_NOTIFICATION_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings createNotificationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createNotificationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "bucket", CREATE_NOTIFICATION_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings listNotificationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listNotificationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "bucket", LIST_NOTIFICATIONS_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings composeObjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(composeObjectMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            if (request.getDestination() != null) {
                builder.add(request.getDestination().getBucket(), "bucket", COMPOSE_OBJECT_0_PATH_TEMPLATE);
            }
            return builder.build();
        }).build();
        GrpcCallSettings deleteObjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteObjectMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getBucket(), "bucket", DELETE_OBJECT_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings cancelResumableWriteTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(cancelResumableWriteMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getUploadId(), "bucket", CANCEL_RESUMABLE_WRITE_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings getObjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getObjectMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getBucket(), "bucket", GET_OBJECT_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings readObjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(readObjectMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getBucket(), "bucket", READ_OBJECT_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings updateObjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateObjectMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            if (request.getObject() != null) {
                builder.add(request.getObject().getBucket(), "bucket", UPDATE_OBJECT_0_PATH_TEMPLATE);
            }
            return builder.build();
        }).build();
        GrpcCallSettings writeObjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(writeObjectMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            if (request.getWriteObjectSpec() != null && request.getWriteObjectSpec().getResource() != null) {
                builder.add(request.getWriteObjectSpec().getResource().getBucket(), "bucket", WRITE_OBJECT_0_PATH_TEMPLATE);
            }
            builder.add(request.getUploadId(), "bucket", WRITE_OBJECT_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings listObjectsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listObjectsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "bucket", LIST_OBJECTS_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings rewriteObjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(rewriteObjectMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getSourceBucket(), "source_bucket", REWRITE_OBJECT_0_PATH_TEMPLATE);
            builder.add(request.getDestinationBucket(), "bucket", REWRITE_OBJECT_1_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings startResumableWriteTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(startResumableWriteMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            if (request.getWriteObjectSpec() != null && request.getWriteObjectSpec().getResource() != null) {
                builder.add(request.getWriteObjectSpec().getResource().getBucket(), "bucket", START_RESUMABLE_WRITE_0_PATH_TEMPLATE);
            }
            return builder.build();
        }).build();
        GrpcCallSettings queryWriteStatusTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(queryWriteStatusMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getUploadId(), "bucket", QUERY_WRITE_STATUS_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings getServiceAccountTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getServiceAccountMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProject(), "project", GET_SERVICE_ACCOUNT_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings createHmacKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createHmacKeyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProject(), "project", CREATE_HMAC_KEY_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings deleteHmacKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteHmacKeyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProject(), "project", DELETE_HMAC_KEY_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings getHmacKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getHmacKeyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProject(), "project", GET_HMAC_KEY_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings listHmacKeysTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listHmacKeysMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getProject(), "project", LIST_HMAC_KEYS_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings updateHmacKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateHmacKeyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            if (request.getHmacKey() != null) {
                builder.add(request.getHmacKey().getProject(), "project", UPDATE_HMAC_KEY_0_PATH_TEMPLATE);
            }
            return builder.build();
        }).build();
        this.deleteBucketCallable = callableFactory.createUnaryCallable(deleteBucketTransportSettings, settings.deleteBucketSettings(), clientContext);
        this.getBucketCallable = callableFactory.createUnaryCallable(getBucketTransportSettings, settings.getBucketSettings(), clientContext);
        this.createBucketCallable = callableFactory.createUnaryCallable(createBucketTransportSettings, settings.createBucketSettings(), clientContext);
        this.listBucketsCallable = callableFactory.createUnaryCallable(listBucketsTransportSettings, settings.listBucketsSettings(), clientContext);
        this.listBucketsPagedCallable = callableFactory.createPagedCallable(listBucketsTransportSettings, settings.listBucketsSettings(), clientContext);
        this.lockBucketRetentionPolicyCallable = callableFactory.createUnaryCallable(lockBucketRetentionPolicyTransportSettings, settings.lockBucketRetentionPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.updateBucketCallable = callableFactory.createUnaryCallable(updateBucketTransportSettings, settings.updateBucketSettings(), clientContext);
        this.deleteNotificationCallable = callableFactory.createUnaryCallable(deleteNotificationTransportSettings, settings.deleteNotificationSettings(), clientContext);
        this.getNotificationCallable = callableFactory.createUnaryCallable(getNotificationTransportSettings, settings.getNotificationSettings(), clientContext);
        this.createNotificationCallable = callableFactory.createUnaryCallable(createNotificationTransportSettings, settings.createNotificationSettings(), clientContext);
        this.listNotificationsCallable = callableFactory.createUnaryCallable(listNotificationsTransportSettings, settings.listNotificationsSettings(), clientContext);
        this.listNotificationsPagedCallable = callableFactory.createPagedCallable(listNotificationsTransportSettings, settings.listNotificationsSettings(), clientContext);
        this.composeObjectCallable = callableFactory.createUnaryCallable(composeObjectTransportSettings, settings.composeObjectSettings(), clientContext);
        this.deleteObjectCallable = callableFactory.createUnaryCallable(deleteObjectTransportSettings, settings.deleteObjectSettings(), clientContext);
        this.cancelResumableWriteCallable = callableFactory.createUnaryCallable(cancelResumableWriteTransportSettings, settings.cancelResumableWriteSettings(), clientContext);
        this.getObjectCallable = callableFactory.createUnaryCallable(getObjectTransportSettings, settings.getObjectSettings(), clientContext);
        this.readObjectCallable = callableFactory.createServerStreamingCallable(readObjectTransportSettings, settings.readObjectSettings(), clientContext);
        this.updateObjectCallable = callableFactory.createUnaryCallable(updateObjectTransportSettings, settings.updateObjectSettings(), clientContext);
        this.writeObjectCallable = callableFactory.createClientStreamingCallable(writeObjectTransportSettings, settings.writeObjectSettings(), clientContext);
        this.listObjectsCallable = callableFactory.createUnaryCallable(listObjectsTransportSettings, settings.listObjectsSettings(), clientContext);
        this.listObjectsPagedCallable = callableFactory.createPagedCallable(listObjectsTransportSettings, settings.listObjectsSettings(), clientContext);
        this.rewriteObjectCallable = callableFactory.createUnaryCallable(rewriteObjectTransportSettings, settings.rewriteObjectSettings(), clientContext);
        this.startResumableWriteCallable = callableFactory.createUnaryCallable(startResumableWriteTransportSettings, settings.startResumableWriteSettings(), clientContext);
        this.queryWriteStatusCallable = callableFactory.createUnaryCallable(queryWriteStatusTransportSettings, settings.queryWriteStatusSettings(), clientContext);
        this.getServiceAccountCallable = callableFactory.createUnaryCallable(getServiceAccountTransportSettings, settings.getServiceAccountSettings(), clientContext);
        this.createHmacKeyCallable = callableFactory.createUnaryCallable(createHmacKeyTransportSettings, settings.createHmacKeySettings(), clientContext);
        this.deleteHmacKeyCallable = callableFactory.createUnaryCallable(deleteHmacKeyTransportSettings, settings.deleteHmacKeySettings(), clientContext);
        this.getHmacKeyCallable = callableFactory.createUnaryCallable(getHmacKeyTransportSettings, settings.getHmacKeySettings(), clientContext);
        this.listHmacKeysCallable = callableFactory.createUnaryCallable(listHmacKeysTransportSettings, settings.listHmacKeysSettings(), clientContext);
        this.listHmacKeysPagedCallable = callableFactory.createPagedCallable(listHmacKeysTransportSettings, settings.listHmacKeysSettings(), clientContext);
        this.updateHmacKeyCallable = callableFactory.createUnaryCallable(updateHmacKeyTransportSettings, settings.updateHmacKeySettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<DeleteBucketRequest, Empty> deleteBucketCallable() {
        return this.deleteBucketCallable;
    }

    @Override
    public UnaryCallable<GetBucketRequest, Bucket> getBucketCallable() {
        return this.getBucketCallable;
    }

    @Override
    public UnaryCallable<CreateBucketRequest, Bucket> createBucketCallable() {
        return this.createBucketCallable;
    }

    @Override
    public UnaryCallable<ListBucketsRequest, ListBucketsResponse> listBucketsCallable() {
        return this.listBucketsCallable;
    }

    @Override
    public UnaryCallable<ListBucketsRequest, StorageClient.ListBucketsPagedResponse> listBucketsPagedCallable() {
        return this.listBucketsPagedCallable;
    }

    @Override
    public UnaryCallable<LockBucketRetentionPolicyRequest, Bucket> lockBucketRetentionPolicyCallable() {
        return this.lockBucketRetentionPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public UnaryCallable<UpdateBucketRequest, Bucket> updateBucketCallable() {
        return this.updateBucketCallable;
    }

    @Override
    public UnaryCallable<DeleteNotificationRequest, Empty> deleteNotificationCallable() {
        return this.deleteNotificationCallable;
    }

    @Override
    public UnaryCallable<GetNotificationRequest, Notification> getNotificationCallable() {
        return this.getNotificationCallable;
    }

    @Override
    public UnaryCallable<CreateNotificationRequest, Notification> createNotificationCallable() {
        return this.createNotificationCallable;
    }

    @Override
    public UnaryCallable<ListNotificationsRequest, ListNotificationsResponse> listNotificationsCallable() {
        return this.listNotificationsCallable;
    }

    @Override
    public UnaryCallable<ListNotificationsRequest, StorageClient.ListNotificationsPagedResponse> listNotificationsPagedCallable() {
        return this.listNotificationsPagedCallable;
    }

    @Override
    public UnaryCallable<ComposeObjectRequest, Object> composeObjectCallable() {
        return this.composeObjectCallable;
    }

    @Override
    public UnaryCallable<DeleteObjectRequest, Empty> deleteObjectCallable() {
        return this.deleteObjectCallable;
    }

    @Override
    public UnaryCallable<CancelResumableWriteRequest, CancelResumableWriteResponse> cancelResumableWriteCallable() {
        return this.cancelResumableWriteCallable;
    }

    @Override
    public UnaryCallable<GetObjectRequest, Object> getObjectCallable() {
        return this.getObjectCallable;
    }

    @Override
    public ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> readObjectCallable() {
        return this.readObjectCallable;
    }

    @Override
    public UnaryCallable<UpdateObjectRequest, Object> updateObjectCallable() {
        return this.updateObjectCallable;
    }

    @Override
    public ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> writeObjectCallable() {
        return this.writeObjectCallable;
    }

    @Override
    public UnaryCallable<ListObjectsRequest, ListObjectsResponse> listObjectsCallable() {
        return this.listObjectsCallable;
    }

    @Override
    public UnaryCallable<ListObjectsRequest, StorageClient.ListObjectsPagedResponse> listObjectsPagedCallable() {
        return this.listObjectsPagedCallable;
    }

    @Override
    public UnaryCallable<RewriteObjectRequest, RewriteResponse> rewriteObjectCallable() {
        return this.rewriteObjectCallable;
    }

    @Override
    public UnaryCallable<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteCallable() {
        return this.startResumableWriteCallable;
    }

    @Override
    public UnaryCallable<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusCallable() {
        return this.queryWriteStatusCallable;
    }

    @Override
    public UnaryCallable<GetServiceAccountRequest, ServiceAccount> getServiceAccountCallable() {
        return this.getServiceAccountCallable;
    }

    @Override
    public UnaryCallable<CreateHmacKeyRequest, CreateHmacKeyResponse> createHmacKeyCallable() {
        return this.createHmacKeyCallable;
    }

    @Override
    public UnaryCallable<DeleteHmacKeyRequest, Empty> deleteHmacKeyCallable() {
        return this.deleteHmacKeyCallable;
    }

    @Override
    public UnaryCallable<GetHmacKeyRequest, HmacKeyMetadata> getHmacKeyCallable() {
        return this.getHmacKeyCallable;
    }

    @Override
    public UnaryCallable<ListHmacKeysRequest, ListHmacKeysResponse> listHmacKeysCallable() {
        return this.listHmacKeysCallable;
    }

    @Override
    public UnaryCallable<ListHmacKeysRequest, StorageClient.ListHmacKeysPagedResponse> listHmacKeysPagedCallable() {
        return this.listHmacKeysPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateHmacKeyRequest, HmacKeyMetadata> updateHmacKeyCallable() {
        return this.updateHmacKeyCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

