/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.NoopApiTracer;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedUnaryCallable;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class TracedUnaryCallableTest {
    private static final SpanName SPAN_NAME = SpanName.of((String)"FakeClient", (String)"FakeRpc");
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    private ApiTracerFactory tracerFactory;
    private ApiTracer parentTracer;
    @Mock
    private ApiTracer tracer;
    @Mock
    private UnaryCallable<String, String> innerCallable;
    private SettableApiFuture<String> innerResult;
    private TracedUnaryCallable<String, String> tracedUnaryCallable;
    private FakeCallContext callContext;

    @Before
    public void setUp() {
        this.parentTracer = NoopApiTracer.getInstance();
        Mockito.when((Object)this.tracerFactory.newTracer((ApiTracer)Mockito.any(ApiTracer.class), (SpanName)Mockito.any(SpanName.class), (ApiTracerFactory.OperationType)Mockito.eq((Object)ApiTracerFactory.OperationType.Unary))).thenReturn((Object)this.tracer);
        this.innerResult = SettableApiFuture.create();
        Mockito.when((Object)this.innerCallable.futureCall((Object)Mockito.anyString(), (ApiCallContext)Mockito.any(ApiCallContext.class))).thenReturn(this.innerResult);
        this.tracedUnaryCallable = new TracedUnaryCallable(this.innerCallable, this.tracerFactory, SPAN_NAME);
        this.callContext = FakeCallContext.createDefault();
    }

    @Test
    public void testTracerCreated() {
        this.tracedUnaryCallable.futureCall((Object)"test", (ApiCallContext)this.callContext);
        ((ApiTracerFactory)Mockito.verify((Object)this.tracerFactory, (VerificationMode)Mockito.times((int)1))).newTracer(this.parentTracer, SPAN_NAME, ApiTracerFactory.OperationType.Unary);
    }

    @Test
    public void testOperationFinish() {
        this.innerResult.set((Object)"successful result");
        this.tracedUnaryCallable.futureCall((Object)"test", (ApiCallContext)this.callContext);
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationSucceeded();
    }

    @Test
    public void testOperationCancelled() {
        this.innerResult.cancel(true);
        this.tracedUnaryCallable.futureCall((Object)"test", (ApiCallContext)this.callContext);
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationCancelled();
    }

    @Test
    public void testOperationFailed() {
        RuntimeException fakeError = new RuntimeException("fake error");
        this.innerResult.setException((Throwable)fakeError);
        this.tracedUnaryCallable.futureCall((Object)"test", (ApiCallContext)this.callContext);
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)fakeError);
    }

    @Test
    public void testSyncError() {
        RuntimeException fakeError = new RuntimeException("fake error");
        Object[] innerCallableWrapper = new UnaryCallable[]{this.innerCallable};
        Mockito.reset((Object[])innerCallableWrapper);
        Mockito.when((Object)this.innerCallable.futureCall(Mockito.eq((Object)"failing test"), (ApiCallContext)Mockito.any(ApiCallContext.class))).thenThrow(new Throwable[]{fakeError});
        try {
            this.tracedUnaryCallable.futureCall((Object)"failing test", (ApiCallContext)this.callContext);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)fakeError);
    }
}

