/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.BatchingDescriptor;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedBatchingCallable;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

public class TracedBatchingCallableTest {
    private static final SpanName SPAN_NAME = SpanName.of((String)"FakeClient", (String)"FakeRpc");
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    private ApiTracerFactory tracerFactory;
    @Mock
    private ApiTracer tracer;
    @Mock
    private BatchingDescriptor<String, String> batchingDescriptor;
    @Mock
    private UnaryCallable<String, String> innerCallable;
    private SettableApiFuture<String> innerResult;
    private TracedBatchingCallable<String, String> tracedBatchingCallable;
    private FakeCallContext callContext;

    @Before
    public void setUp() {
        Mockito.when((Object)this.tracerFactory.newTracer((ApiTracer)ArgumentMatchers.any(ApiTracer.class), (SpanName)ArgumentMatchers.any(SpanName.class), (ApiTracerFactory.OperationType)ArgumentMatchers.eq((Object)ApiTracerFactory.OperationType.Batching))).thenReturn((Object)this.tracer);
        this.innerResult = SettableApiFuture.create();
        Mockito.when((Object)this.innerCallable.futureCall((Object)ArgumentMatchers.anyString(), (ApiCallContext)ArgumentMatchers.any(ApiCallContext.class))).thenReturn(this.innerResult);
        this.tracedBatchingCallable = new TracedBatchingCallable(this.innerCallable, this.tracerFactory, SPAN_NAME, this.batchingDescriptor);
        this.callContext = FakeCallContext.createDefault();
    }

    @Test
    public void testRootTracerCreated() {
        this.tracedBatchingCallable.futureCall((Object)"test", (ApiCallContext)this.callContext);
        ((ApiTracerFactory)Mockito.verify((Object)this.tracerFactory, (VerificationMode)Mockito.times((int)1))).newTracer(this.callContext.getTracer(), SPAN_NAME, ApiTracerFactory.OperationType.Batching);
    }

    @Test
    public void testBatchAttributesStamped() {
        Mockito.when((Object)this.batchingDescriptor.countElements((Object)ArgumentMatchers.anyString())).thenReturn((Object)10L);
        Mockito.when((Object)this.batchingDescriptor.countBytes((Object)ArgumentMatchers.anyString())).thenReturn((Object)20L);
        this.tracedBatchingCallable.futureCall((Object)"test", (ApiCallContext)this.callContext);
        ((ApiTracer)Mockito.verify((Object)this.tracer)).batchRequestSent(10L, 20L);
    }

    @Test
    public void testOperationFinish() {
        this.innerResult.set((Object)"successful result");
        this.tracedBatchingCallable.futureCall((Object)"test", (ApiCallContext)this.callContext);
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationSucceeded();
    }

    @Test
    public void testOperationFailed() {
        RuntimeException fakeError = new RuntimeException("fake error");
        this.innerResult.setException((Throwable)fakeError);
        this.tracedBatchingCallable.futureCall((Object)"test", (ApiCallContext)this.callContext);
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)fakeError);
    }

    @Test
    public void testSyncError() {
        RuntimeException fakeError = new RuntimeException("fake error");
        Object[] innerCallableWrapper = new UnaryCallable[]{this.innerCallable};
        Mockito.reset((Object[])innerCallableWrapper);
        Mockito.when((Object)this.innerCallable.futureCall(ArgumentMatchers.eq((Object)"failing test"), (ApiCallContext)ArgumentMatchers.any(ApiCallContext.class))).thenThrow(new Throwable[]{fakeError});
        try {
            this.tracedBatchingCallable.futureCall((Object)"failing test", (ApiCallContext)this.callContext);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)fakeError);
    }
}

