/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.testing;

import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.testing.FakeStatusCode;

@InternalApi(value="for testing")
public class FakeStatusException
extends Exception {
    private final FakeStatusCode fakeStatusCode;

    public static String formatCode(StatusCode.Code code) {
        if (code == null) {
            return "";
        }
        return code.toString();
    }

    public static String formatCodeAsPrefix(StatusCode.Code code) {
        if (code == null) {
            return "";
        }
        return code + ": ";
    }

    public FakeStatusException(StatusCode.Code statusCode) {
        super(FakeStatusException.formatCode(statusCode));
        this.fakeStatusCode = FakeStatusCode.of(statusCode);
    }

    public FakeStatusException(Throwable cause, StatusCode.Code statusCode) {
        super(FakeStatusException.formatCode(statusCode), cause);
        this.fakeStatusCode = FakeStatusCode.of(statusCode);
    }

    public FakeStatusException(String message, Throwable cause, StatusCode.Code statusCode) {
        super(FakeStatusException.formatCodeAsPrefix(statusCode) + message, cause);
        this.fakeStatusCode = FakeStatusCode.of(statusCode);
    }

    public FakeStatusCode getStatusCode() {
        return this.fakeStatusCode;
    }
}

