/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.testing;

import com.google.api.core.AbstractApiFuture;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalApi;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.OperationCallable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;

@InternalApi(value="for testing")
public class FakeOperationApi {

    public static class FakeOperation {
    }

    public static class FakeOperationFuture
    extends AbstractApiFuture<String>
    implements OperationFuture<String, Long> {
        private final String result;
        private final String operationName;

        public FakeOperationFuture(String result, String operationName) {
            this.result = result;
            this.operationName = operationName;
        }

        public String get() {
            return this.result;
        }

        public String getName() throws InterruptedException, ExecutionException {
            return this.operationName;
        }

        public ApiFuture<OperationSnapshot> getInitialFuture() {
            throw new UnsupportedOperationException("getInitialFuture() not implemented");
        }

        public RetryingFuture<OperationSnapshot> getPollingFuture() {
            throw new UnsupportedOperationException("getPollingFuture() not implemented");
        }

        public ApiFuture<Long> peekMetadata() {
            return null;
        }

        public ApiFuture<Long> getMetadata() {
            return null;
        }
    }

    public static class OperationStashCallable
    extends OperationCallable<Integer, String, Long> {
        private ApiCallContext context;
        private Integer request;
        private Map<String, FakeOperationFuture> operations = new HashMap<String, FakeOperationFuture>();
        private ApiCallContext resumeContext;
        private ApiCallContext cancelContext;
        private boolean wasCancelCalled = false;

        public OperationFuture<String, Long> futureCall(Integer request, ApiCallContext context) {
            this.request = request;
            this.context = context;
            String opName = "opName-" + request;
            FakeOperationFuture opFuture = new FakeOperationFuture(request.toString(), opName);
            this.operations.put(opName, opFuture);
            return opFuture;
        }

        public OperationFuture<String, Long> resumeFutureCall(String operationName, ApiCallContext context) {
            if (!this.operations.containsKey(operationName)) {
                throw new IllegalArgumentException("Operation not found: " + operationName);
            }
            this.resumeContext = context;
            return this.operations.get(operationName);
        }

        public ApiFuture<Void> cancel(String operationName, ApiCallContext context) {
            this.wasCancelCalled = true;
            this.cancelContext = context;
            return ApiFutures.immediateFuture(null);
        }

        public ApiCallContext getContext() {
            return this.context;
        }

        public Integer getRequest() {
            return this.request;
        }

        public ApiCallContext getResumeContext() {
            return this.resumeContext;
        }

        public boolean wasCancelCalled() {
            return this.wasCancelCalled;
        }

        public ApiCallContext getCancelContext() {
            return this.cancelContext;
        }
    }
}

