/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.testing.MockStreamingApi;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ServerStreamTest {
    private ServerStream<Integer> stream;
    private MockStreamingApi.MockStreamController<Integer> controller;
    private ExecutorService executor;

    @Before
    public void setUp() {
        this.stream = new ServerStream();
        this.controller = new MockStreamingApi.MockStreamController(this.stream.observer());
        this.stream.observer().onStart(this.controller);
        this.executor = Executors.newCachedThreadPool();
    }

    @After
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testEmptyStream() {
        this.stream.observer().onComplete();
        Truth.assertThat((Iterable)Lists.newArrayList(this.stream)).isEmpty();
    }

    @Test
    public void testMultipleItemStream() throws Exception {
        Future<Void> producerFuture = this.executor.submit(new Callable<Void>(){

            @Override
            public Void call() {
                for (int i = 0; i < 5; ++i) {
                    int requestCount = ServerStreamTest.this.controller.popLastPull();
                    Truth.assertWithMessage((String)"ServerStream should request one item at a time").that(Integer.valueOf(requestCount)).isEqualTo((Object)1);
                    ServerStreamTest.this.stream.observer().onResponse((Object)i);
                }
                ServerStreamTest.this.stream.observer().onComplete();
                return null;
            }
        });
        Future<List<Integer>> consumerFuture = this.executor.submit(new Callable<List<Integer>>(){

            @Override
            public List<Integer> call() {
                return Lists.newArrayList((Iterable)ServerStreamTest.this.stream);
            }
        });
        producerFuture.get(60L, TimeUnit.SECONDS);
        List<Integer> results = consumerFuture.get();
        Truth.assertThat(results).containsExactly(new Object[]{0, 1, 2, 3, 4});
    }

    @Test
    public void testEarlyTermination() throws Exception {
        Future<Void> taskFuture = this.executor.submit(new Callable<Void>(){

            @Override
            public Void call() {
                int i = 0;
                while (ServerStreamTest.this.controller.popLastPull() > 0) {
                    ServerStreamTest.this.stream.observer().onResponse((Object)i++);
                }
                ServerStreamTest.this.controller.waitForCancel();
                ServerStreamTest.this.stream.observer().onError((Throwable)new CancellationException("cancelled"));
                return null;
            }
        });
        ArrayList results = Lists.newArrayList();
        for (Integer result : this.stream) {
            results.add(result);
            if (result != 1) continue;
            this.stream.cancel();
        }
        taskFuture.get(30L, TimeUnit.SECONDS);
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{0, 1});
    }

    @Test
    public void testErrorPropagation() {
        ClassCastException e = new ClassCastException("fake error");
        this.stream.observer().onError((Throwable)e);
        Throwable actualError = null;
        try {
            Lists.newArrayList(this.stream);
        }
        catch (Throwable t) {
            actualError = t;
        }
        Truth.assertThat((Throwable)actualError).hasMessageThat().contains((CharSequence)e.getMessage());
        Truth.assertThat((Throwable)actualError).isEqualTo((Object)e);
    }

    @Test
    public void testNoErrorsBetweenHasNextAndNext() {
        Iterator it = this.stream.iterator();
        this.controller.popLastPull();
        this.stream.observer().onResponse((Object)1);
        Truth.assertThat((Boolean)it.hasNext()).isTrue();
        RuntimeException fakeError = new RuntimeException("fake");
        this.stream.observer().onError((Throwable)fakeError);
        Truth.assertThat((Integer)((Integer)it.next())).isEqualTo((Object)1);
        try {
            it.next();
            throw new RuntimeException("ServerStream never threw an error!");
        }
        catch (RuntimeException e) {
            Truth.assertThat((Throwable)e).isSameAs((Object)fakeError);
            return;
        }
    }

    @Test
    public void testReady() {
        Iterator it = this.stream.iterator();
        Truth.assertThat((Boolean)this.stream.isReceiveReady()).isFalse();
        this.controller.popLastPull();
        this.stream.observer().onResponse((Object)1);
        Truth.assertThat((Boolean)this.stream.isReceiveReady()).isTrue();
        it.next();
        Truth.assertThat((Boolean)this.stream.isReceiveReady()).isFalse();
    }

    @Test
    public void testNextAfterEOF() {
        Iterator it = this.stream.iterator();
        this.stream.observer().onComplete();
        Truth.assertThat((Boolean)it.hasNext()).isFalse();
        Throwable actualError = null;
        try {
            it.next();
        }
        catch (Throwable t) {
            actualError = t;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    public void testAfterError() {
        Iterator it = this.stream.iterator();
        RuntimeException expectError = new RuntimeException("my upstream error");
        this.stream.observer().onError((Throwable)expectError);
        Throwable actualError = null;
        try {
            boolean bl = it.hasNext();
        }
        catch (Throwable t) {
            actualError = t;
        }
        Truth.assertThat((Throwable)actualError).isEqualTo((Object)expectError);
        try {
            it.next();
        }
        catch (Throwable t) {
            actualError = t;
        }
        Truth.assertThat((Throwable)actualError).isEqualTo((Object)expectError);
    }
}

