/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.RequestUrlParamsEncoder;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class RequestUrlParamsEncoderTest {
    @Test
    public void testEncodeValidationSuccess() throws Exception {
        RequestParamsExtractor<Integer> extractor = this.getMockExtractor(2, (Map<String, String>)ImmutableMap.of((Object)"param1", (Object)"value+1", (Object)"param2", (Object)"value+2+%26"));
        RequestUrlParamsEncoder encoder = new RequestUrlParamsEncoder(extractor, true);
        String encodedParams = encoder.encode((Object)2);
        Assert.assertEquals((Object)"param1=value+1&param2=value+2+%26", (Object)encodedParams);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEncodeValidationFail() throws Exception {
        RequestParamsExtractor<Integer> extractor = this.getMockExtractor(1, (Map<String, String>)ImmutableMap.of((Object)"param1", (Object)"value+1", (Object)"param2", (Object)"value+2+&"));
        RequestUrlParamsEncoder encoder = new RequestUrlParamsEncoder(extractor, true);
        encoder.encode((Object)1);
    }

    @Test
    public void testEncodeNoValidationSuccess() throws Exception {
        RequestParamsExtractor<Integer> extractor = this.getMockExtractor(1, (Map<String, String>)ImmutableMap.of((Object)"param1", (Object)"value+1", (Object)"param2", (Object)"value+2+&"));
        RequestUrlParamsEncoder encoder = new RequestUrlParamsEncoder(extractor, false);
        String encodedParams = encoder.encode((Object)1);
        Assert.assertEquals((Object)"param1=value+1&param2=value+2+&", (Object)encodedParams);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEncodeNullName() throws Exception {
        RequestParamsExtractor<Integer> extractor = this.getMockExtractor(1, Collections.singletonMap(null, "value1"));
        RequestUrlParamsEncoder encoder = new RequestUrlParamsEncoder(extractor, false);
        encoder.encode((Object)1);
    }

    @Test
    public void testEncodeNullValue() throws Exception {
        RequestParamsExtractor<Integer> extractor = this.getMockExtractor(1, Collections.singletonMap("param1", null));
        RequestUrlParamsEncoder encoder = new RequestUrlParamsEncoder(extractor, false);
        String encodedParams = encoder.encode((Object)1);
        Assert.assertEquals((Object)"", (Object)encodedParams);
    }

    @Test
    public void testEncodeEmptyValue() throws Exception {
        RequestParamsExtractor<Integer> extractor = this.getMockExtractor(1, Collections.singletonMap("param1", ""));
        RequestUrlParamsEncoder encoder = new RequestUrlParamsEncoder(extractor, false);
        String encodedParams = encoder.encode((Object)1);
        Assert.assertEquals((Object)"param1=", (Object)encodedParams);
    }

    @Test
    public void testEncodeNullAndEmptyParams() throws Exception {
        RequestParamsExtractor<Integer> extractor = this.getMockExtractor(1, Collections.emptyMap());
        RequestUrlParamsEncoder encoder = new RequestUrlParamsEncoder(extractor, false);
        String encodedParams = encoder.encode((Object)1);
        Assert.assertEquals((Object)"", (Object)encodedParams);
        extractor = this.getMockExtractor(1, null);
        encoder = new RequestUrlParamsEncoder(extractor, false);
        NullPointerException exception = null;
        try {
            encoder.encode((Object)1);
        }
        catch (NullPointerException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)exception);
    }

    private RequestParamsExtractor<Integer> getMockExtractor(Integer input, Map<String, String> output) {
        RequestParamsExtractor extractor = (RequestParamsExtractor)Mockito.mock(RequestParamsExtractor.class);
        Mockito.when((Object)extractor.extract((Object)input)).thenReturn(output);
        return extractor;
    }
}

